# This an autogenerated file
# 
# Generated with SegmentLengthVariationItem
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.segmentlengthvariationitem import SegmentLengthVariationItemBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .segmentreference import SegmentReference
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .arline import ARLine

class SegmentLengthVariationItem(SegmentReference):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : ARLine
         Line
    segment : int
         Segment on given line(default 1)
    allSegments : bool
         All segments(default False)
    startTime : float
         Start time for segment length variation(default 0.0)
    endTime : float
         End time for segment length variation(default 0.0)
    segmentLengthRate : float
         Segment length variation per time unit(default 0.0)
    interactive : bool
         Activate interactive (HLA) control of segment variation(default False)
    """

    def __init__(self , description="", segment=1, allSegments=False, startTime=0.0, endTime=0.0, segmentLengthRate=0.0, interactive=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.line = None
        self.segment = segment
        self.allSegments = allSegments
        self.startTime = startTime
        self.endTime = endTime
        self.segmentLengthRate = segmentLengthRate
        self.interactive = interactive
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SegmentLengthVariationItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> ARLine:
        """Line"""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def segment(self) -> int:
        """Segment on given line"""
        return self.__segment

    @segment.setter
    def segment(self, value: int):
        """Set segment"""
        self.__segment = int(value)

    @property
    def allSegments(self) -> bool:
        """All segments"""
        return self.__allSegments

    @allSegments.setter
    def allSegments(self, value: bool):
        """Set allSegments"""
        self.__allSegments = bool(value)

    @property
    def startTime(self) -> float:
        """Start time for segment length variation"""
        return self.__startTime

    @startTime.setter
    def startTime(self, value: float):
        """Set startTime"""
        self.__startTime = float(value)

    @property
    def endTime(self) -> float:
        """End time for segment length variation"""
        return self.__endTime

    @endTime.setter
    def endTime(self, value: float):
        """Set endTime"""
        self.__endTime = float(value)

    @property
    def segmentLengthRate(self) -> float:
        """Segment length variation per time unit"""
        return self.__segmentLengthRate

    @segmentLengthRate.setter
    def segmentLengthRate(self, value: float):
        """Set segmentLengthRate"""
        self.__segmentLengthRate = float(value)

    @property
    def interactive(self) -> bool:
        """Activate interactive (HLA) control of segment variation"""
        return self.__interactive

    @interactive.setter
    def interactive(self, value: bool):
        """Set interactive"""
        self.__interactive = bool(value)
