# This an autogenerated file
# 
# Generated with StrainStressItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.strainstressitem import StrainStressItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class StrainStressItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    strain : float
         Strain for a given point on strain-stress curve.(default 0.0)
    stress : float
         Stress for a given point on strain-stress curve.(default 0.0)
    """

    def __init__(self , description="", strain=0.0, stress=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.strain = strain
        self.stress = stress
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StrainStressItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def strain(self) -> float:
        """Strain for a given point on strain-stress curve."""
        return self.__strain

    @strain.setter
    def strain(self, value: float):
        """Set strain"""
        self.__strain = float(value)

    @property
    def stress(self) -> float:
        """Stress for a given point on strain-stress curve."""
        return self.__stress

    @stress.setter
    def stress(self, value: float):
        """Set stress"""
        self.__stress = float(value)
