# This an autogenerated file
# 
# Generated with SupportVessel
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.supportvessel import SupportVesselBlueprint
from typing import Dict
from ..hydro import DiffractedWaveField
from ..hydro import FirstOrderMotionTransferFunction
from ..sima import Appearance
from ..sima import Body
from ..sima import BodyViewpoint
from ..sima import Position
from ..sima import ScriptableValue

class SupportVessel(Body):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    length : float
         Length(default 10.0)
    width : float
         Width(default 5.0)
    height : float
         Height(default 5.0)
    appearance : Appearance
    initialPosition : Position
    viewpoints : List[BodyViewpoint]
    firstOrderMotionTransferFunction : FirstOrderMotionTransferFunction
    diffractedWaveFields : List[DiffractedWaveField]
    """

    def __init__(self , description="", length=10.0, width=5.0, height=5.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.length = length
        self.width = width
        self.height = height
        self.appearance = None
        self.initialPosition = None
        self.viewpoints = list()
        self.firstOrderMotionTransferFunction = None
        self.diffractedWaveFields = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SupportVesselBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def length(self) -> float:
        """Length"""
        return self.__length

    @length.setter
    def length(self, value: float):
        """Set length"""
        self.__length = float(value)

    @property
    def width(self) -> float:
        """Width"""
        return self.__width

    @width.setter
    def width(self, value: float):
        """Set width"""
        self.__width = float(value)

    @property
    def height(self) -> float:
        """Height"""
        return self.__height

    @height.setter
    def height(self, value: float):
        """Set height"""
        self.__height = float(value)

    @property
    def appearance(self) -> Appearance:
        """"""
        return self.__appearance

    @appearance.setter
    def appearance(self, value: Appearance):
        """Set appearance"""
        self.__appearance = value

    @property
    def initialPosition(self) -> Position:
        """"""
        return self.__initialPosition

    @initialPosition.setter
    def initialPosition(self, value: Position):
        """Set initialPosition"""
        self.__initialPosition = value

    @property
    def viewpoints(self) -> List[BodyViewpoint]:
        """"""
        return self.__viewpoints

    @viewpoints.setter
    def viewpoints(self, value: List[BodyViewpoint]):
        """Set viewpoints"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__viewpoints = value

    @property
    def firstOrderMotionTransferFunction(self) -> FirstOrderMotionTransferFunction:
        """"""
        return self.__firstOrderMotionTransferFunction

    @firstOrderMotionTransferFunction.setter
    def firstOrderMotionTransferFunction(self, value: FirstOrderMotionTransferFunction):
        """Set firstOrderMotionTransferFunction"""
        self.__firstOrderMotionTransferFunction = value

    @property
    def diffractedWaveFields(self) -> List[DiffractedWaveField]:
        """"""
        return self.__diffractedWaveFields

    @diffractedWaveFields.setter
    def diffractedWaveFields(self, value: List[DiffractedWaveField]):
        """Set diffractedWaveFields"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__diffractedWaveFields = value
