# This an autogenerated file
# 2D matrix of values with dimension
# Generated with DimensionalMatrix
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.dimensionalmatrix import DimensionalMatrixBlueprint
from numpy import ndarray,asarray
from .attribute import Attribute
from .signal import Signal

class DimensionalMatrix(Signal):
    """
    2D matrix of values with dimension
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         (default None)
    attributes : List[Attribute]
    value : ndarray of float
    label : str
         (default None)
    unit : ndarray of str
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.attributes = list()
        self.value = []
        self.label = None
        self.unit = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DimensionalMatrixBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def attributes(self) -> List[Attribute]:
        """"""
        return self.__attributes

    @attributes.setter
    def attributes(self, value: List[Attribute]):
        """Set attributes"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__attributes = value

    @property
    def value(self) -> ndarray:
        """"""
        return self.__value

    @value.setter
    def value(self, value: ndarray):
        """Set value"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 2:
            raise ValueError("Expected array with 2 dimensions")
        self.__value = array

    @property
    def label(self) -> str:
        """"""
        return self.__label

    @label.setter
    def label(self, value: str):
        """Set label"""
        self.__label = value

    @property
    def unit(self) -> ndarray:
        """"""
        return self.__unit

    @unit.setter
    def unit(self, value: ndarray):
        """Set unit"""
        array = asarray(value, dtype=str)
        if len(array) > 0 and array.ndim != 2:
            raise ValueError("Expected array with 2 dimensions")
        self.__unit = array
