# This an autogenerated file
# 
# Generated with SimaMessage
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.simamessage import SimaMessageBlueprint
from typing import Dict
from .moao import MOAO
from .scriptablevalue import ScriptableValue
from .severity import Severity

class SimaMessage(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    title : str
         (default None)
    severity : Severity
    messages : List[SimaMessage]
    """

    def __init__(self , description="", severity=Severity.WARNING, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.title = None
        self.severity = severity
        self.messages = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SimaMessageBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def title(self) -> str:
        """"""
        return self.__title

    @title.setter
    def title(self, value: str):
        """Set title"""
        self.__title = value

    @property
    def severity(self) -> Severity:
        """"""
        return self.__severity

    @severity.setter
    def severity(self, value: Severity):
        """Set severity"""
        self.__severity = value

    @property
    def messages(self) -> List[SimaMessage]:
        """"""
        return self.__messages

    @messages.setter
    def messages(self, value: List[SimaMessage]):
        """Set messages"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__messages = value
