# This an autogenerated file
# 
# Generated with StorageTask
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.storagetask import StorageTaskBlueprint
from typing import Dict
from .doublevariable import DoubleVariable
from .integervariable import IntegerVariable
from .scriptablevalue import ScriptableValue
from .simascript import SIMAScript
from .storagetasktype import StorageTaskType
from .stringvariable import StringVariable
from .task import Task

class StorageTask(Task):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    doubleVariables : List[DoubleVariable]
    integerVariables : List[IntegerVariable]
    stringVariables : List[StringVariable]
    runNumber : int
         (default 0)
    scripts : List[SIMAScript]
    _type : StorageTaskType
    root : str
         Defines the root of the storage task. If not set, the root will be the normal workspace task location(default None)
    includeInExport : bool
         If not set the file content withing this storage task will be ommitted when exporting.(default True)
    """

    def __init__(self , description="", runNumber=0, _type=StorageTaskType.PRIVATE, includeInExport=True, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.doubleVariables = list()
        self.integerVariables = list()
        self.stringVariables = list()
        self.runNumber = runNumber
        self.scripts = list()
        self._type = _type
        self.root = None
        self.includeInExport = includeInExport
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StorageTaskBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def doubleVariables(self) -> List[DoubleVariable]:
        """"""
        return self.__doubleVariables

    @doubleVariables.setter
    def doubleVariables(self, value: List[DoubleVariable]):
        """Set doubleVariables"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__doubleVariables = value

    @property
    def integerVariables(self) -> List[IntegerVariable]:
        """"""
        return self.__integerVariables

    @integerVariables.setter
    def integerVariables(self, value: List[IntegerVariable]):
        """Set integerVariables"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__integerVariables = value

    @property
    def stringVariables(self) -> List[StringVariable]:
        """"""
        return self.__stringVariables

    @stringVariables.setter
    def stringVariables(self, value: List[StringVariable]):
        """Set stringVariables"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__stringVariables = value

    @property
    def runNumber(self) -> int:
        """"""
        return self.__runNumber

    @runNumber.setter
    def runNumber(self, value: int):
        """Set runNumber"""
        self.__runNumber = int(value)

    @property
    def scripts(self) -> List[SIMAScript]:
        """"""
        return self.__scripts

    @scripts.setter
    def scripts(self, value: List[SIMAScript]):
        """Set scripts"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scripts = value

    @property
    def _type(self) -> StorageTaskType:
        """"""
        return self.___type

    @_type.setter
    def _type(self, value: StorageTaskType):
        """Set _type"""
        self.___type = value

    @property
    def root(self) -> str:
        """Defines the root of the storage task. If not set, the root will be the normal workspace task location"""
        return self.__root

    @root.setter
    def root(self, value: str):
        """Set root"""
        self.__root = value

    @property
    def includeInExport(self) -> bool:
        """If not set the file content withing this storage task will be ommitted when exporting."""
        return self.__includeInExport

    @includeInExport.setter
    def includeInExport(self, value: bool):
        """Set includeInExport"""
        self.__includeInExport = bool(value)
