# This an autogenerated file
# 
# Generated with AxialStiffnessItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.axialstiffnessitem import AxialStiffnessItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class AxialStiffnessItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    strain : float
         Relative elongation of segment.(default 0.0)
    tension : float
         Tension in segment.(default 0.0)
    """

    def __init__(self , description="", strain=0.0, tension=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.strain = strain
        self.tension = tension
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return AxialStiffnessItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def strain(self) -> float:
        """Relative elongation of segment."""
        return self.__strain

    @strain.setter
    def strain(self, value: float):
        """Set strain"""
        self.__strain = float(value)

    @property
    def tension(self) -> float:
        """Tension in segment."""
        return self.__tension

    @tension.setter
    def tension(self, value: float):
        """Set tension"""
        self.__tension = float(value)
