# 
# Generated with SIMOBodyBlueprint
from dmt.blueprint import Blueprint
from dmt.dimension import Dimension
from dmt.attribute import Attribute
from dmt.enum_attribute import EnumAttribute
from dmt.blueprint_attribute import BlueprintAttribute
from ...sima.blueprints.body import BodyBlueprint

class SIMOBodyBlueprint(BodyBlueprint):
    """"""

    def __init__(self, name="SIMOBody", package_path="sima/simo", description=""):
        super().__init__(name,package_path,description)
        self.add_attribute(Attribute("description","string","",default=""))
        self.add_attribute(BlueprintAttribute("scriptableValues","sima/sima/ScriptableValue","",True,Dimension("*")))
        self.add_attribute(Attribute("name","string",""))
        self.add_attribute(Attribute("length","number","Length",default=10.0))
        self.add_attribute(Attribute("width","number","Width",default=5.0))
        self.add_attribute(Attribute("height","number","Height",default=5.0))
        self.add_attribute(BlueprintAttribute("appearance","sima/sima/Appearance","",True))
        self.add_attribute(BlueprintAttribute("initialPosition","sima/sima/Position","",True))
        self.add_attribute(BlueprintAttribute("viewpoints","sima/sima/BodyViewpoint","",True,Dimension("*")))
        self.add_attribute(EnumAttribute("_type","sima/simo/BodyType","Body type"))
        self.add_attribute(EnumAttribute("positionsImportType","sima/simo/PositionsImportType","Type of import for positions"))
        self.add_attribute(Attribute("positionsFileName","string","File name for body positions"))
        self.add_attribute(Attribute("positionsHLAObjectName","string","HLA object name for body"))
        self.add_attribute(Attribute("applyGravityForce","boolean","Should gravity force be included",default=False))
        self.add_attribute(BlueprintAttribute("bodyPoints","sima/simo/SIMOBodyPoint","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("catenarySystem","sima/simo/CatenarySystem","",True))
        self.add_attribute(BlueprintAttribute("structuralMass","sima/hydro/StructuralMass","",True))
        self.add_attribute(BlueprintAttribute("linearDamping","sima/hydro/LinearDampingMatrix","",True))
        self.add_attribute(BlueprintAttribute("quadraticDamping","sima/hydro/QuadraticDampingMatrix","",True))
        self.add_attribute(BlueprintAttribute("linearDampingMatrices","sima/simo/SIMOLinearDampingMatrix","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("quadraticDampingMatrices","sima/simo/SIMOQuadraticDampingMatrix","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("hydrostaticStiffnessData","sima/hydro/HydrostaticStiffnessData","",True))
        self.add_attribute(BlueprintAttribute("nonLinearHydrostaticStiffness","sima/simo/NonLinearHydrostaticStiffness","",True))
        self.add_attribute(BlueprintAttribute("nonlinearBuoyancyCorrection","sima/simo/NonlinearBuoyancyCorrection","",True))
        self.add_attribute(BlueprintAttribute("firstOrderMotionTransferFunction","sima/hydro/FirstOrderMotionTransferFunction","",True))
        self.add_attribute(BlueprintAttribute("firstOrderWaveForceTransferFunction","sima/hydro/FirstOrderWaveForceTransferFunction","",True))
        self.add_attribute(BlueprintAttribute("waveDriftForce","sima/hydro/WaveDriftForce","",True))
        self.add_attribute(BlueprintAttribute("waveDriftDamping","sima/hydro/WaveDriftDamping","",True))
        self.add_attribute(BlueprintAttribute("simplifiedWaveDriftDamping","sima/hydro/SimplifiedWaveDriftDamping","",True))
        self.add_attribute(BlueprintAttribute("quadraticWindCoefficients","sima/hydro/QuadraticWindCoefficient","",True))
        self.add_attribute(BlueprintAttribute("linearCurrentCoefficients","sima/hydro/LinearCurrentCoefficient","",True))
        self.add_attribute(BlueprintAttribute("quadraticCurrentCoefficients","sima/hydro/QuadraticCurrentCoefficient","",True))
        self.add_attribute(BlueprintAttribute("diffractedWaveField","sima/hydro/DiffractedWaveField","",True))
        self.add_attribute(BlueprintAttribute("smallBodyHydrodynamicalData","sima/simo/SmallBodyHydrodynamicData","",True))
        self.add_attribute(BlueprintAttribute("radiationData","sima/hydro/RadiationDataGroup","",True))
        self.add_attribute(BlueprintAttribute("specifiedForces","sima/simo/SpecifiedForce","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("specifiedMoments","sima/simo/SpecifiedMoment","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("thrusters","sima/simo/IThruster","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("controlSystem","sima/simo/ControlSystem","",True))
        self.add_attribute(BlueprintAttribute("slenderElements","sima/simo/SlenderElement","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("externalDLLForces","sima/simo/ExternalDLLForce","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("externalHLAForces","sima/simo/ExternalHLAForce","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("externalForcesFromFile","sima/simo/ExternalForceFromFile","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("fixedBodyElements","sima/simo/FixedBodyElement","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("timeDependentPointMasses","sima/simo/TimeDependentPointMass","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("timeDependentVolumeMasses","sima/simo/TimeDependentVolumeMass","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("slenderSystemConnection","sima/simo/BodySlenderSystemConnection","",True))
        self.add_attribute(BlueprintAttribute("gdfGeometry","sima/hydro/GDFGeometry","",True))
        self.add_attribute(BlueprintAttribute("fixedForceElongations","sima/simo/FixedForceElongation","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("accCOG","sima/sima/Point3","",True))
        self.add_attribute(BlueprintAttribute("liftAndDragForces","sima/simo/LiftAndDragForce","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("articulatedStructure","sima/simo/ArticulatedStructureData","",True))
        self.add_attribute(BlueprintAttribute("externalControlSystem","sima/simo/ExternalControlSystem","",True))
        self.add_attribute(BlueprintAttribute("dockingConePositionings","sima/simo/DockingConePositioning","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("pointBerthingFenders","sima/simo/PointBerthingFender","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("rollerBerthingFenders","sima/simo/RollerBerthingFender","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("bumperDatas","sima/simo/BumperData","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("horizontalAxisWindTurbine","sima/simo/HorizontalAxisWindTurbine","",True))
        self.add_attribute(BlueprintAttribute("verticalAxisWindTurbine","sima/simo/VerticalAxisWindTurbine","",True))
        self.add_attribute(BlueprintAttribute("genericExternalControlSystems","sima/simo/GenericExternalControlSystem","",True,Dimension("*")))
        self.add_attribute(BlueprintAttribute("ballastSystem","sima/simo/BallastSystem","",True))
        self.add_attribute(EnumAttribute("hydrodynamicSeparationMethod","sima/simo/HydrodynamicSeparationMethod","Method for estimating low frequency motions"))
        self.add_attribute(Attribute("hydrodynamicFilterCutOffPeriod","number","Cut off period used to estimate low ferquency motion from total motion",default=0.0))
        self.add_attribute(BlueprintAttribute("bodyShapeData","sima/simo/BodyShapeData","",True))
        self.add_attribute(BlueprintAttribute("qtf","sima/hydro/SparseQTF","",True))