# This an autogenerated file
# 
# Generated with BodyResult
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.bodyresult import BodyResultBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import Position
from ..sima import ScriptableValue
from .couplingelementresult import CouplingElementResult
from .forceresult import ForceResult
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .positioningelementresult import PositioningElementResult

class BodyResult(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    body : str
         Result body(default None)
    initialPosition : Position
    staticPosition : Position
    bodyForces : List[ForceResult]
    positioningElementResults : List[PositioningElementResult]
    couplingResults : List[CouplingElementResult]
    specifiedForces : List[ForceResult]
    thrusterForces : List[ForceResult]
    externalForces : List[ForceResult]
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.body = None
        self.initialPosition = None
        self.staticPosition = None
        self.bodyForces = list()
        self.positioningElementResults = list()
        self.couplingResults = list()
        self.specifiedForces = list()
        self.thrusterForces = list()
        self.externalForces = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return BodyResultBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def body(self) -> str:
        """Result body"""
        return self.__body

    @body.setter
    def body(self, value: str):
        """Set body"""
        self.__body = value

    @property
    def initialPosition(self) -> Position:
        """"""
        return self.__initialPosition

    @initialPosition.setter
    def initialPosition(self, value: Position):
        """Set initialPosition"""
        self.__initialPosition = value

    @property
    def staticPosition(self) -> Position:
        """"""
        return self.__staticPosition

    @staticPosition.setter
    def staticPosition(self, value: Position):
        """Set staticPosition"""
        self.__staticPosition = value

    @property
    def bodyForces(self) -> List[ForceResult]:
        """"""
        return self.__bodyForces

    @bodyForces.setter
    def bodyForces(self, value: List[ForceResult]):
        """Set bodyForces"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__bodyForces = value

    @property
    def positioningElementResults(self) -> List[PositioningElementResult]:
        """"""
        return self.__positioningElementResults

    @positioningElementResults.setter
    def positioningElementResults(self, value: List[PositioningElementResult]):
        """Set positioningElementResults"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__positioningElementResults = value

    @property
    def couplingResults(self) -> List[CouplingElementResult]:
        """"""
        return self.__couplingResults

    @couplingResults.setter
    def couplingResults(self, value: List[CouplingElementResult]):
        """Set couplingResults"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__couplingResults = value

    @property
    def specifiedForces(self) -> List[ForceResult]:
        """"""
        return self.__specifiedForces

    @specifiedForces.setter
    def specifiedForces(self, value: List[ForceResult]):
        """Set specifiedForces"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__specifiedForces = value

    @property
    def thrusterForces(self) -> List[ForceResult]:
        """"""
        return self.__thrusterForces

    @thrusterForces.setter
    def thrusterForces(self, value: List[ForceResult]):
        """Set thrusterForces"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__thrusterForces = value

    @property
    def externalForces(self) -> List[ForceResult]:
        """"""
        return self.__externalForces

    @externalForces.setter
    def externalForces(self, value: List[ForceResult]):
        """Set externalForces"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__externalForces = value
