# This an autogenerated file
# 
# Generated with BumperData
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.bumperdata import BumperDataBlueprint
from typing import Dict
from ..sima import NamedObject
from ..sima import Point3
from ..sima import ScriptableValue
from .forcedampingcharacteristic import ForceDampingCharacteristic

class BumperData(NamedObject):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    velocityLimit : float
         Velocity limit for damping force(default 0.0)
    characteristic : ForceDampingCharacteristic
    bodyEnd1 : Point3
    bodyEnd2 : Point3
    globalEnd1 : Point3
    globalEnd2 : Point3
    """

    def __init__(self , description="", velocityLimit=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.velocityLimit = velocityLimit
        self.characteristic = None
        self.bodyEnd1 = None
        self.bodyEnd2 = None
        self.globalEnd1 = None
        self.globalEnd2 = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return BumperDataBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def velocityLimit(self) -> float:
        """Velocity limit for damping force"""
        return self.__velocityLimit

    @velocityLimit.setter
    def velocityLimit(self, value: float):
        """Set velocityLimit"""
        self.__velocityLimit = float(value)

    @property
    def characteristic(self) -> ForceDampingCharacteristic:
        """"""
        return self.__characteristic

    @characteristic.setter
    def characteristic(self, value: ForceDampingCharacteristic):
        """Set characteristic"""
        self.__characteristic = value

    @property
    def bodyEnd1(self) -> Point3:
        """"""
        return self.__bodyEnd1

    @bodyEnd1.setter
    def bodyEnd1(self, value: Point3):
        """Set bodyEnd1"""
        self.__bodyEnd1 = value

    @property
    def bodyEnd2(self) -> Point3:
        """"""
        return self.__bodyEnd2

    @bodyEnd2.setter
    def bodyEnd2(self, value: Point3):
        """Set bodyEnd2"""
        self.__bodyEnd2 = value

    @property
    def globalEnd1(self) -> Point3:
        """"""
        return self.__globalEnd1

    @globalEnd1.setter
    def globalEnd1(self, value: Point3):
        """Set globalEnd1"""
        self.__globalEnd1 = value

    @property
    def globalEnd2(self) -> Point3:
        """"""
        return self.__globalEnd2

    @globalEnd2.setter
    def globalEnd2(self, value: Point3):
        """Set globalEnd2"""
        self.__globalEnd2 = value
