# This an autogenerated file
# 
# Generated with ExternalControlSetup
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.externalcontrolsetup import ExternalControlSetupBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class ExternalControlSetup(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    executable : str
         Executable to run(default None)
    arguments : str
         Process arguments(default None)
    port : int
         Port number of the central unit for the external process(default 9876)
    """

    def __init__(self , description="", port=9876, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.executable = None
        self.arguments = None
        self.port = port
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ExternalControlSetupBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def executable(self) -> str:
        """Executable to run"""
        return self.__executable

    @executable.setter
    def executable(self, value: str):
        """Set executable"""
        self.__executable = value

    @property
    def arguments(self) -> str:
        """Process arguments"""
        return self.__arguments

    @arguments.setter
    def arguments(self, value: str):
        """Set arguments"""
        self.__arguments = value

    @property
    def port(self) -> int:
        """Port number of the central unit for the external process"""
        return self.__port

    @port.setter
    def port(self, value: int):
        """Set port"""
        self.__port = int(value)
