# This an autogenerated file
# 
# Generated with GenericExternalControlSystem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.genericexternalcontrolsystem import GenericExternalControlSystemBlueprint
from typing import Dict
from ..sima import LibraryPaths
from ..sima import NamedObject
from ..sima import ScriptableValue
from .nameddoubleparameter import NamedDoubleParameter
from .namedintparameter import NamedIntParameter
from .namedstringparameter import NamedStringParameter
from .signalentity import SignalEntity

class GenericExternalControlSystem(NamedObject):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    jarFile : str
         Path to jar file(default None)
    className : str
         Class name of controller(default None)
    measurementEntities : List[SignalEntity]
    feedbackEntities : List[SignalEntity]
    intParameters : List[NamedIntParameter]
    doubleParameters : List[NamedDoubleParameter]
    stringParameters : List[NamedStringParameter]
    libraryPaths : LibraryPaths
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.jarFile = None
        self.className = None
        self.measurementEntities = list()
        self.feedbackEntities = list()
        self.intParameters = list()
        self.doubleParameters = list()
        self.stringParameters = list()
        self.libraryPaths = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return GenericExternalControlSystemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def jarFile(self) -> str:
        """Path to jar file"""
        return self.__jarFile

    @jarFile.setter
    def jarFile(self, value: str):
        """Set jarFile"""
        self.__jarFile = value

    @property
    def className(self) -> str:
        """Class name of controller"""
        return self.__className

    @className.setter
    def className(self, value: str):
        """Set className"""
        self.__className = value

    @property
    def measurementEntities(self) -> List[SignalEntity]:
        """"""
        return self.__measurementEntities

    @measurementEntities.setter
    def measurementEntities(self, value: List[SignalEntity]):
        """Set measurementEntities"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__measurementEntities = value

    @property
    def feedbackEntities(self) -> List[SignalEntity]:
        """"""
        return self.__feedbackEntities

    @feedbackEntities.setter
    def feedbackEntities(self, value: List[SignalEntity]):
        """Set feedbackEntities"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__feedbackEntities = value

    @property
    def intParameters(self) -> List[NamedIntParameter]:
        """"""
        return self.__intParameters

    @intParameters.setter
    def intParameters(self, value: List[NamedIntParameter]):
        """Set intParameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__intParameters = value

    @property
    def doubleParameters(self) -> List[NamedDoubleParameter]:
        """"""
        return self.__doubleParameters

    @doubleParameters.setter
    def doubleParameters(self, value: List[NamedDoubleParameter]):
        """Set doubleParameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__doubleParameters = value

    @property
    def stringParameters(self) -> List[NamedStringParameter]:
        """"""
        return self.__stringParameters

    @stringParameters.setter
    def stringParameters(self, value: List[NamedStringParameter]):
        """Set stringParameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__stringParameters = value

    @property
    def libraryPaths(self) -> LibraryPaths:
        """"""
        return self.__libraryPaths

    @libraryPaths.setter
    def libraryPaths(self, value: LibraryPaths):
        """Set libraryPaths"""
        self.__libraryPaths = value
