# This an autogenerated file
# 
# Generated with LineTensionItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.linetensionitem import LineTensionItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class LineTensionItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    length : float
         Horizontal length of the nonlinear line(default 0.0)
    tension : float
         Horizontal tension of the nonlinear line for the given length(default 0.0)
    """

    def __init__(self , description="", length=0.0, tension=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.length = length
        self.tension = tension
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return LineTensionItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def length(self) -> float:
        """Horizontal length of the nonlinear line"""
        return self.__length

    @length.setter
    def length(self, value: float):
        """Set length"""
        self.__length = float(value)

    @property
    def tension(self) -> float:
        """Horizontal tension of the nonlinear line for the given length"""
        return self.__tension

    @tension.setter
    def tension(self, value: float):
        """Set tension"""
        self.__tension = float(value)
