# This an autogenerated file
# 
# Generated with NonlinearBuoyancyCorrection
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.nonlinearbuoyancycorrection import NonlinearBuoyancyCorrectionBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import Point3
from ..sima import ScriptableValue
from .nonlinearbuoyancycorrectionmethod import NonlinearBuoyancyCorrectionMethod

class NonlinearBuoyancyCorrection(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    fileName : str
         Name of geometry file ('.gdf'-file)(default None)
    location : Point3
    minZ : float
         Minimum vertical range value to be used given in '.gdf' file system(default 0.0)
    maxZ : float
         Maximum vertical range value to be used given in '.gdf' file system(default 0.0)
    correctionMethod : NonlinearBuoyancyCorrectionMethod
    """

    def __init__(self , description="", minZ=0.0, maxZ=0.0, correctionMethod=NonlinearBuoyancyCorrectionMethod.MWL, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.fileName = None
        self.location = None
        self.minZ = minZ
        self.maxZ = maxZ
        self.correctionMethod = correctionMethod
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return NonlinearBuoyancyCorrectionBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def fileName(self) -> str:
        """Name of geometry file ('.gdf'-file)"""
        return self.__fileName

    @fileName.setter
    def fileName(self, value: str):
        """Set fileName"""
        self.__fileName = value

    @property
    def location(self) -> Point3:
        """"""
        return self.__location

    @location.setter
    def location(self, value: Point3):
        """Set location"""
        self.__location = value

    @property
    def minZ(self) -> float:
        """Minimum vertical range value to be used given in '.gdf' file system"""
        return self.__minZ

    @minZ.setter
    def minZ(self, value: float):
        """Set minZ"""
        self.__minZ = float(value)

    @property
    def maxZ(self) -> float:
        """Maximum vertical range value to be used given in '.gdf' file system"""
        return self.__maxZ

    @maxZ.setter
    def maxZ(self, value: float):
        """Set maxZ"""
        self.__maxZ = float(value)

    @property
    def correctionMethod(self) -> NonlinearBuoyancyCorrectionMethod:
        """"""
        return self.__correctionMethod

    @correctionMethod.setter
    def correctionMethod(self, value: NonlinearBuoyancyCorrectionMethod):
        """Set correctionMethod"""
        self.__correctionMethod = value
