# This an autogenerated file
# 
# Generated with NonLinearHydrostaticStiffness
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.nonlinearhydrostaticstiffness import NonLinearHydrostaticStiffnessBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import Position
from ..sima import ScriptableValue

class NonLinearHydrostaticStiffness(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    geometryPosition : Position
    geometryFile : str
         Geometry definition file(default None)
    transparency : float
         Geometry transparency, [0-1], where 1 is full transparency.(default 0.0)
    """

    def __init__(self , description="", transparency=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.geometryPosition = None
        self.geometryFile = None
        self.transparency = transparency
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return NonLinearHydrostaticStiffnessBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def geometryPosition(self) -> Position:
        """"""
        return self.__geometryPosition

    @geometryPosition.setter
    def geometryPosition(self, value: Position):
        """Set geometryPosition"""
        self.__geometryPosition = value

    @property
    def geometryFile(self) -> str:
        """Geometry definition file"""
        return self.__geometryFile

    @geometryFile.setter
    def geometryFile(self, value: str):
        """Set geometryFile"""
        self.__geometryFile = value

    @property
    def transparency(self) -> float:
        """Geometry transparency, [0-1], where 1 is full transparency."""
        return self.__transparency

    @transparency.setter
    def transparency(self, value: float):
        """Set transparency"""
        self.__transparency = float(value)
