# This an autogenerated file
# 
# Generated with SegmentedLineType
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.segmentedlinetype import SegmentedLineTypeBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .bottomcontactoption import BottomContactOption
from .linecharacteristicmethod import LineCharacteristicMethod
from .linesegment import LineSegment
from .linetype import LineType

class SegmentedLineType(LineType):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    segments : List[LineSegment]
    vmin : float
         Min. relative z-pos. for which the line characteristics will be calculated.(default 0.0)
    vmax : float
         Max. relative z-pos. for which the line characteristics will be calculated.(default 0.0)
    bottomContactOption : BottomContactOption
         Bottom contact option
    anchorZ : float
         Z-coordinate of the anchor in global coordinate system(default 0.0)
    maxTension : float
         Maximum tension to be used in the line characteristics\ncalculations(default 0.0)
    minHTension : float
         Minimum horizontal tension to be used for calculation\nof line characteristics(default 0.0)
    method : LineCharacteristicMethod
         Method for initialization of line
    npth : int
         Number of points in the line characteristics matrix, offset variation in the horizontal plane.(default 40)
    nptv : int
         Number of points in the line characteristics matrix, offset variation in the vertical plane.(default 5)
    slope : float
         The angle of the seabed under the catenary line. Slope = 0 means a flat seabed. Positive slope means that the seabed is sloping downwards from the anchor towards the attachment point.(default 0.0)
    allowVerticalExtrapolation : bool
         Controls wether a fairlead position outside the vmin, vmax range should be an error(default False)
    """

    def __init__(self , description="", vmin=0.0, vmax=0.0, bottomContactOption=BottomContactOption.LINE_END_ONLY, anchorZ=0.0, maxTension=0.0, minHTension=0.0, method=LineCharacteristicMethod.SHOOTING, npth=40, nptv=5, slope=0.0, allowVerticalExtrapolation=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.segments = list()
        self.vmin = vmin
        self.vmax = vmax
        self.bottomContactOption = bottomContactOption
        self.anchorZ = anchorZ
        self.maxTension = maxTension
        self.minHTension = minHTension
        self.method = method
        self.npth = npth
        self.nptv = nptv
        self.slope = slope
        self.allowVerticalExtrapolation = allowVerticalExtrapolation
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SegmentedLineTypeBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def segments(self) -> List[LineSegment]:
        """"""
        return self.__segments

    @segments.setter
    def segments(self, value: List[LineSegment]):
        """Set segments"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__segments = value

    @property
    def vmin(self) -> float:
        """Min. relative z-pos. for which the line characteristics will be calculated."""
        return self.__vmin

    @vmin.setter
    def vmin(self, value: float):
        """Set vmin"""
        self.__vmin = float(value)

    @property
    def vmax(self) -> float:
        """Max. relative z-pos. for which the line characteristics will be calculated."""
        return self.__vmax

    @vmax.setter
    def vmax(self, value: float):
        """Set vmax"""
        self.__vmax = float(value)

    @property
    def bottomContactOption(self) -> BottomContactOption:
        """Bottom contact option"""
        return self.__bottomContactOption

    @bottomContactOption.setter
    def bottomContactOption(self, value: BottomContactOption):
        """Set bottomContactOption"""
        self.__bottomContactOption = value

    @property
    def anchorZ(self) -> float:
        """Z-coordinate of the anchor in global coordinate system"""
        return self.__anchorZ

    @anchorZ.setter
    def anchorZ(self, value: float):
        """Set anchorZ"""
        self.__anchorZ = float(value)

    @property
    def maxTension(self) -> float:
        """Maximum tension to be used in the line characteristics
calculations"""
        return self.__maxTension

    @maxTension.setter
    def maxTension(self, value: float):
        """Set maxTension"""
        self.__maxTension = float(value)

    @property
    def minHTension(self) -> float:
        """Minimum horizontal tension to be used for calculation
of line characteristics"""
        return self.__minHTension

    @minHTension.setter
    def minHTension(self, value: float):
        """Set minHTension"""
        self.__minHTension = float(value)

    @property
    def method(self) -> LineCharacteristicMethod:
        """Method for initialization of line"""
        return self.__method

    @method.setter
    def method(self, value: LineCharacteristicMethod):
        """Set method"""
        self.__method = value

    @property
    def npth(self) -> int:
        """Number of points in the line characteristics matrix, offset variation in the horizontal plane."""
        return self.__npth

    @npth.setter
    def npth(self, value: int):
        """Set npth"""
        self.__npth = int(value)

    @property
    def nptv(self) -> int:
        """Number of points in the line characteristics matrix, offset variation in the vertical plane."""
        return self.__nptv

    @nptv.setter
    def nptv(self, value: int):
        """Set nptv"""
        self.__nptv = int(value)

    @property
    def slope(self) -> float:
        """The angle of the seabed under the catenary line. Slope = 0 means a flat seabed. Positive slope means that the seabed is sloping downwards from the anchor towards the attachment point."""
        return self.__slope

    @slope.setter
    def slope(self, value: float):
        """Set slope"""
        self.__slope = float(value)

    @property
    def allowVerticalExtrapolation(self) -> bool:
        """Controls wether a fairlead position outside the vmin, vmax range should be an error"""
        return self.__allowVerticalExtrapolation

    @allowVerticalExtrapolation.setter
    def allowVerticalExtrapolation(self, value: bool):
        """Set allowVerticalExtrapolation"""
        self.__allowVerticalExtrapolation = bool(value)
