# This an autogenerated file
# 
# Generated with SIMOBodyPoint
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.simobodypoint import SIMOBodyPointBlueprint
from typing import Dict
from ..sima import NamedObject
from ..sima import ScriptableValue
from .bodyforcecomponent import BodyForceComponent
from .simoheavecompensator import SIMOHeaveCompensator
from .simotensioner import SIMOTensioner
from .winch import Winch

class SIMOBodyPoint(NamedObject,BodyForceComponent):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    winch : Winch
    tensioner : SIMOTensioner
    heaveCompensator : SIMOHeaveCompensator
    x : float
         Local  x position(default 0.0)
    y : float
         Local  y position(default 0.0)
    z : float
         Local z position(default 0.0)
    """

    def __init__(self , description="", x=0.0, y=0.0, z=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.winch = None
        self.tensioner = None
        self.heaveCompensator = None
        self.x = x
        self.y = y
        self.z = z
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMOBodyPointBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def winch(self) -> Winch:
        """"""
        return self.__winch

    @winch.setter
    def winch(self, value: Winch):
        """Set winch"""
        self.__winch = value

    @property
    def tensioner(self) -> SIMOTensioner:
        """"""
        return self.__tensioner

    @tensioner.setter
    def tensioner(self, value: SIMOTensioner):
        """Set tensioner"""
        self.__tensioner = value

    @property
    def heaveCompensator(self) -> SIMOHeaveCompensator:
        """"""
        return self.__heaveCompensator

    @heaveCompensator.setter
    def heaveCompensator(self, value: SIMOHeaveCompensator):
        """Set heaveCompensator"""
        self.__heaveCompensator = value

    @property
    def x(self) -> float:
        """Local  x position"""
        return self.__x

    @x.setter
    def x(self, value: float):
        """Set x"""
        self.__x = float(value)

    @property
    def y(self) -> float:
        """Local  y position"""
        return self.__y

    @y.setter
    def y(self, value: float):
        """Set y"""
        self.__y = float(value)

    @property
    def z(self) -> float:
        """Local z position"""
        return self.__z

    @z.setter
    def z(self, value: float):
        """Set z"""
        self.__z = float(value)
