# This an autogenerated file
# 
# Generated with StabilityCalculationParameters
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.stabilitycalculationparameters import StabilityCalculationParametersBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .dofelimination import DOFElimination
from .staticequilibriumbody import StaticEquilibriumBody
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .simobody import SIMOBody

class StabilityCalculationParameters(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    forceTolerance : float
         An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance.(default 100.0)
    momentTolerance : float
         An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance.(default 1000.0)
    staticEquilibriumBodies : List[StaticEquilibriumBody]
    restrainFromGlobalDOFBodies : List[DOFElimination]
    body : SIMOBody
         Body for which GZ-curve will be calculated
    minAzimuthAngle : float
         Minimum angle of the azimuth axis of rotation (body-related coordinate system)(default 0.0)
    maxAzimuthAngle : float
         Maximum angle of the azimuth axis of rotation (body-related coordinate system)(default 0.0)
    numAzimuthValues : int
         (default 0)
    minRotationAngle : float
         Minimum inclination angle about the azimuth axis(default 0.0)
    maxRotationAngle : float
         Maximum inclination angle about the azimuth axis(default 0.0)
    numRotationvalues : int
         (default 0)
    """

    def __init__(self , description="", forceTolerance=100.0, momentTolerance=1000.0, minAzimuthAngle=0.0, maxAzimuthAngle=0.0, numAzimuthValues=0, minRotationAngle=0.0, maxRotationAngle=0.0, numRotationvalues=0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.forceTolerance = forceTolerance
        self.momentTolerance = momentTolerance
        self.staticEquilibriumBodies = list()
        self.restrainFromGlobalDOFBodies = list()
        self.body = None
        self.minAzimuthAngle = minAzimuthAngle
        self.maxAzimuthAngle = maxAzimuthAngle
        self.numAzimuthValues = numAzimuthValues
        self.minRotationAngle = minRotationAngle
        self.maxRotationAngle = maxRotationAngle
        self.numRotationvalues = numRotationvalues
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StabilityCalculationParametersBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def forceTolerance(self) -> float:
        """An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance."""
        return self.__forceTolerance

    @forceTolerance.setter
    def forceTolerance(self, value: float):
        """Set forceTolerance"""
        self.__forceTolerance = float(value)

    @property
    def momentTolerance(self) -> float:
        """An equilibrium will be accepted if all the force components are lower than the force tolerance, and all the moment components are lower than the moment tolerance."""
        return self.__momentTolerance

    @momentTolerance.setter
    def momentTolerance(self, value: float):
        """Set momentTolerance"""
        self.__momentTolerance = float(value)

    @property
    def staticEquilibriumBodies(self) -> List[StaticEquilibriumBody]:
        """"""
        return self.__staticEquilibriumBodies

    @staticEquilibriumBodies.setter
    def staticEquilibriumBodies(self, value: List[StaticEquilibriumBody]):
        """Set staticEquilibriumBodies"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__staticEquilibriumBodies = value

    @property
    def restrainFromGlobalDOFBodies(self) -> List[DOFElimination]:
        """"""
        return self.__restrainFromGlobalDOFBodies

    @restrainFromGlobalDOFBodies.setter
    def restrainFromGlobalDOFBodies(self, value: List[DOFElimination]):
        """Set restrainFromGlobalDOFBodies"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__restrainFromGlobalDOFBodies = value

    @property
    def body(self) -> SIMOBody:
        """Body for which GZ-curve will be calculated"""
        return self.__body

    @body.setter
    def body(self, value: SIMOBody):
        """Set body"""
        self.__body = value

    @property
    def minAzimuthAngle(self) -> float:
        """Minimum angle of the azimuth axis of rotation (body-related coordinate system)"""
        return self.__minAzimuthAngle

    @minAzimuthAngle.setter
    def minAzimuthAngle(self, value: float):
        """Set minAzimuthAngle"""
        self.__minAzimuthAngle = float(value)

    @property
    def maxAzimuthAngle(self) -> float:
        """Maximum angle of the azimuth axis of rotation (body-related coordinate system)"""
        return self.__maxAzimuthAngle

    @maxAzimuthAngle.setter
    def maxAzimuthAngle(self, value: float):
        """Set maxAzimuthAngle"""
        self.__maxAzimuthAngle = float(value)

    @property
    def numAzimuthValues(self) -> int:
        """"""
        return self.__numAzimuthValues

    @numAzimuthValues.setter
    def numAzimuthValues(self, value: int):
        """Set numAzimuthValues"""
        self.__numAzimuthValues = int(value)

    @property
    def minRotationAngle(self) -> float:
        """Minimum inclination angle about the azimuth axis"""
        return self.__minRotationAngle

    @minRotationAngle.setter
    def minRotationAngle(self, value: float):
        """Set minRotationAngle"""
        self.__minRotationAngle = float(value)

    @property
    def maxRotationAngle(self) -> float:
        """Maximum inclination angle about the azimuth axis"""
        return self.__maxRotationAngle

    @maxRotationAngle.setter
    def maxRotationAngle(self, value: float):
        """Set maxRotationAngle"""
        self.__maxRotationAngle = float(value)

    @property
    def numRotationvalues(self) -> int:
        """"""
        return self.__numRotationvalues

    @numRotationvalues.setter
    def numRotationvalues(self, value: int):
        """Set numRotationvalues"""
        self.__numRotationvalues = int(value)
