# This an autogenerated file
# 
# Generated with Thruster
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.thruster import ThrusterBlueprint
from typing import Dict
from ..sima import Point3
from ..sima import ScriptableValue
from .controlsequenceitem import ControlSequenceItem
from .formulation import Formulation
from .ithruster import IThruster
from .surfaceproximityreductionfactor import SurfaceProximityReductionFactor
from .thrustcoefficientmodel import ThrustCoefficientModel
from .thrusterfailuremode import ThrusterFailureMode
from .thrusterforbiddenzone import ThrusterForbiddenZone
from .thrusterreduction import ThrusterReduction
from .thrustertype import ThrusterType
from .thrustloss import ThrustLoss
from .thrustsignaltype import ThrustSignalType
from .thrusttorquecoefficient import ThrustTorqueCoefficient

class Thruster(IThruster):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    minForce : float
         Minimum thruster force(default 0.0)
    maxForce : float
         Maximum thruster force(default 0.0)
    _type : ThrusterType
         Thruster type
    attachmentPoint : Point3
    diameter : float
         Thruster diameter(default 1.0)
    forceDirection : float
         Direction of thrust force in body x-y plane, initial value if controlled by a DP-system(default 0.0)
    force : float
         Resulting force, initial value if controlled by a DP-system(default 0.0)
    minTimeChange : float
         Minimum time to change from 10% to 90% of maximum thrust(default 0.0)
    maxRevolvingSpeed : float
         Maximum revolving speed of rotatable thrusters(default 10.0)
    failureMode : ThrusterFailureMode
         Thruster failure mode
    failureTime : float
         Time for thruster failure(default 0.0)
    maxRudderAngle : float
         Maximum rudder angle(default 0.0)
    rudderCoefficient : float
         Rudder coefficient(default 0.0)
    reductionItems : List[ThrusterReduction]
    relativeDeadBand : float
         Relative dead band, minimum change of force relative to total change(default 0.01)
    thrustReductionFactor : float
         Thrust reduction factor(default 1.0)
    minDirectionChange : float
         Minimum change in direction of thrusters force(default 0.0)
    forbiddenZoneItems : List[ThrusterForbiddenZone]
    formulation : Formulation
    ctForward : float
         Modification factor for forward thrust(default 1.0)
    cqForward : float
         Modification factor for forward torque(default 1.0)
    ctReverse : float
         Modification factor for reverse thrust(default 1.0)
    cqReverse : float
         Modification factor for reverse torque(default 1.0)
    pdRatio : float
         Pitch-diameter ratio(default 1.0)
    tcThrust : float
         Time constant of thrust(default 0.0)
    tcAzimuth : float
         Time constant of azimuth change(default 0.0)
    coefficientModel : ThrustCoefficientModel
    forwardThrustTorqueCoefficients : List[ThrustTorqueCoefficient]
    reverseThrustTorqueCoefficients : List[ThrustTorqueCoefficient]
    thrustLoss : ThrustLoss
    surfaceProximityReductionFactors : List[SurfaceProximityReductionFactor]
    specifyControlSequence : bool
         Should a list of control signals be specified for thruster?(default False)
    controlSequenceSignalType : ThrustSignalType
         Unit for demanded thrust force
    controlSequence : List[ControlSequenceItem]
    """

    def __init__(self , description="", minForce=0.0, maxForce=0.0, _type=ThrusterType.FIXED_CONVENTIONAL, diameter=1.0, forceDirection=0.0, force=0.0, minTimeChange=0.0, maxRevolvingSpeed=10.0, failureMode=ThrusterFailureMode.NO_FAILURE, failureTime=0.0, maxRudderAngle=0.0, rudderCoefficient=0.0, relativeDeadBand=0.01, thrustReductionFactor=1.0, minDirectionChange=0.0, formulation=Formulation.SIMO_41, ctForward=1.0, cqForward=1.0, ctReverse=1.0, cqReverse=1.0, pdRatio=1.0, tcThrust=0.0, tcAzimuth=0.0, coefficientModel=ThrustCoefficientModel.INTERNAL, thrustLoss=ThrustLoss.NONE, specifyControlSequence=False, controlSequenceSignalType=ThrustSignalType.FORCE, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.minForce = minForce
        self.maxForce = maxForce
        self._type = _type
        self.attachmentPoint = None
        self.diameter = diameter
        self.forceDirection = forceDirection
        self.force = force
        self.minTimeChange = minTimeChange
        self.maxRevolvingSpeed = maxRevolvingSpeed
        self.failureMode = failureMode
        self.failureTime = failureTime
        self.maxRudderAngle = maxRudderAngle
        self.rudderCoefficient = rudderCoefficient
        self.reductionItems = list()
        self.relativeDeadBand = relativeDeadBand
        self.thrustReductionFactor = thrustReductionFactor
        self.minDirectionChange = minDirectionChange
        self.forbiddenZoneItems = list()
        self.formulation = formulation
        self.ctForward = ctForward
        self.cqForward = cqForward
        self.ctReverse = ctReverse
        self.cqReverse = cqReverse
        self.pdRatio = pdRatio
        self.tcThrust = tcThrust
        self.tcAzimuth = tcAzimuth
        self.coefficientModel = coefficientModel
        self.forwardThrustTorqueCoefficients = list()
        self.reverseThrustTorqueCoefficients = list()
        self.thrustLoss = thrustLoss
        self.surfaceProximityReductionFactors = list()
        self.specifyControlSequence = specifyControlSequence
        self.controlSequenceSignalType = controlSequenceSignalType
        self.controlSequence = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ThrusterBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def minForce(self) -> float:
        """Minimum thruster force"""
        return self.__minForce

    @minForce.setter
    def minForce(self, value: float):
        """Set minForce"""
        self.__minForce = float(value)

    @property
    def maxForce(self) -> float:
        """Maximum thruster force"""
        return self.__maxForce

    @maxForce.setter
    def maxForce(self, value: float):
        """Set maxForce"""
        self.__maxForce = float(value)

    @property
    def _type(self) -> ThrusterType:
        """Thruster type"""
        return self.___type

    @_type.setter
    def _type(self, value: ThrusterType):
        """Set _type"""
        self.___type = value

    @property
    def attachmentPoint(self) -> Point3:
        """"""
        return self.__attachmentPoint

    @attachmentPoint.setter
    def attachmentPoint(self, value: Point3):
        """Set attachmentPoint"""
        self.__attachmentPoint = value

    @property
    def diameter(self) -> float:
        """Thruster diameter"""
        return self.__diameter

    @diameter.setter
    def diameter(self, value: float):
        """Set diameter"""
        self.__diameter = float(value)

    @property
    def forceDirection(self) -> float:
        """Direction of thrust force in body x-y plane, initial value if controlled by a DP-system"""
        return self.__forceDirection

    @forceDirection.setter
    def forceDirection(self, value: float):
        """Set forceDirection"""
        self.__forceDirection = float(value)

    @property
    def force(self) -> float:
        """Resulting force, initial value if controlled by a DP-system"""
        return self.__force

    @force.setter
    def force(self, value: float):
        """Set force"""
        self.__force = float(value)

    @property
    def minTimeChange(self) -> float:
        """Minimum time to change from 10% to 90% of maximum thrust"""
        return self.__minTimeChange

    @minTimeChange.setter
    def minTimeChange(self, value: float):
        """Set minTimeChange"""
        self.__minTimeChange = float(value)

    @property
    def maxRevolvingSpeed(self) -> float:
        """Maximum revolving speed of rotatable thrusters"""
        return self.__maxRevolvingSpeed

    @maxRevolvingSpeed.setter
    def maxRevolvingSpeed(self, value: float):
        """Set maxRevolvingSpeed"""
        self.__maxRevolvingSpeed = float(value)

    @property
    def failureMode(self) -> ThrusterFailureMode:
        """Thruster failure mode"""
        return self.__failureMode

    @failureMode.setter
    def failureMode(self, value: ThrusterFailureMode):
        """Set failureMode"""
        self.__failureMode = value

    @property
    def failureTime(self) -> float:
        """Time for thruster failure"""
        return self.__failureTime

    @failureTime.setter
    def failureTime(self, value: float):
        """Set failureTime"""
        self.__failureTime = float(value)

    @property
    def maxRudderAngle(self) -> float:
        """Maximum rudder angle"""
        return self.__maxRudderAngle

    @maxRudderAngle.setter
    def maxRudderAngle(self, value: float):
        """Set maxRudderAngle"""
        self.__maxRudderAngle = float(value)

    @property
    def rudderCoefficient(self) -> float:
        """Rudder coefficient"""
        return self.__rudderCoefficient

    @rudderCoefficient.setter
    def rudderCoefficient(self, value: float):
        """Set rudderCoefficient"""
        self.__rudderCoefficient = float(value)

    @property
    def reductionItems(self) -> List[ThrusterReduction]:
        """"""
        return self.__reductionItems

    @reductionItems.setter
    def reductionItems(self, value: List[ThrusterReduction]):
        """Set reductionItems"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__reductionItems = value

    @property
    def relativeDeadBand(self) -> float:
        """Relative dead band, minimum change of force relative to total change"""
        return self.__relativeDeadBand

    @relativeDeadBand.setter
    def relativeDeadBand(self, value: float):
        """Set relativeDeadBand"""
        self.__relativeDeadBand = float(value)

    @property
    def thrustReductionFactor(self) -> float:
        """Thrust reduction factor"""
        return self.__thrustReductionFactor

    @thrustReductionFactor.setter
    def thrustReductionFactor(self, value: float):
        """Set thrustReductionFactor"""
        self.__thrustReductionFactor = float(value)

    @property
    def minDirectionChange(self) -> float:
        """Minimum change in direction of thrusters force"""
        return self.__minDirectionChange

    @minDirectionChange.setter
    def minDirectionChange(self, value: float):
        """Set minDirectionChange"""
        self.__minDirectionChange = float(value)

    @property
    def forbiddenZoneItems(self) -> List[ThrusterForbiddenZone]:
        """"""
        return self.__forbiddenZoneItems

    @forbiddenZoneItems.setter
    def forbiddenZoneItems(self, value: List[ThrusterForbiddenZone]):
        """Set forbiddenZoneItems"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__forbiddenZoneItems = value

    @property
    def formulation(self) -> Formulation:
        """"""
        return self.__formulation

    @formulation.setter
    def formulation(self, value: Formulation):
        """Set formulation"""
        self.__formulation = value

    @property
    def ctForward(self) -> float:
        """Modification factor for forward thrust"""
        return self.__ctForward

    @ctForward.setter
    def ctForward(self, value: float):
        """Set ctForward"""
        self.__ctForward = float(value)

    @property
    def cqForward(self) -> float:
        """Modification factor for forward torque"""
        return self.__cqForward

    @cqForward.setter
    def cqForward(self, value: float):
        """Set cqForward"""
        self.__cqForward = float(value)

    @property
    def ctReverse(self) -> float:
        """Modification factor for reverse thrust"""
        return self.__ctReverse

    @ctReverse.setter
    def ctReverse(self, value: float):
        """Set ctReverse"""
        self.__ctReverse = float(value)

    @property
    def cqReverse(self) -> float:
        """Modification factor for reverse torque"""
        return self.__cqReverse

    @cqReverse.setter
    def cqReverse(self, value: float):
        """Set cqReverse"""
        self.__cqReverse = float(value)

    @property
    def pdRatio(self) -> float:
        """Pitch-diameter ratio"""
        return self.__pdRatio

    @pdRatio.setter
    def pdRatio(self, value: float):
        """Set pdRatio"""
        self.__pdRatio = float(value)

    @property
    def tcThrust(self) -> float:
        """Time constant of thrust"""
        return self.__tcThrust

    @tcThrust.setter
    def tcThrust(self, value: float):
        """Set tcThrust"""
        self.__tcThrust = float(value)

    @property
    def tcAzimuth(self) -> float:
        """Time constant of azimuth change"""
        return self.__tcAzimuth

    @tcAzimuth.setter
    def tcAzimuth(self, value: float):
        """Set tcAzimuth"""
        self.__tcAzimuth = float(value)

    @property
    def coefficientModel(self) -> ThrustCoefficientModel:
        """"""
        return self.__coefficientModel

    @coefficientModel.setter
    def coefficientModel(self, value: ThrustCoefficientModel):
        """Set coefficientModel"""
        self.__coefficientModel = value

    @property
    def forwardThrustTorqueCoefficients(self) -> List[ThrustTorqueCoefficient]:
        """"""
        return self.__forwardThrustTorqueCoefficients

    @forwardThrustTorqueCoefficients.setter
    def forwardThrustTorqueCoefficients(self, value: List[ThrustTorqueCoefficient]):
        """Set forwardThrustTorqueCoefficients"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__forwardThrustTorqueCoefficients = value

    @property
    def reverseThrustTorqueCoefficients(self) -> List[ThrustTorqueCoefficient]:
        """"""
        return self.__reverseThrustTorqueCoefficients

    @reverseThrustTorqueCoefficients.setter
    def reverseThrustTorqueCoefficients(self, value: List[ThrustTorqueCoefficient]):
        """Set reverseThrustTorqueCoefficients"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__reverseThrustTorqueCoefficients = value

    @property
    def thrustLoss(self) -> ThrustLoss:
        """"""
        return self.__thrustLoss

    @thrustLoss.setter
    def thrustLoss(self, value: ThrustLoss):
        """Set thrustLoss"""
        self.__thrustLoss = value

    @property
    def surfaceProximityReductionFactors(self) -> List[SurfaceProximityReductionFactor]:
        """"""
        return self.__surfaceProximityReductionFactors

    @surfaceProximityReductionFactors.setter
    def surfaceProximityReductionFactors(self, value: List[SurfaceProximityReductionFactor]):
        """Set surfaceProximityReductionFactors"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__surfaceProximityReductionFactors = value

    @property
    def specifyControlSequence(self) -> bool:
        """Should a list of control signals be specified for thruster?"""
        return self.__specifyControlSequence

    @specifyControlSequence.setter
    def specifyControlSequence(self, value: bool):
        """Set specifyControlSequence"""
        self.__specifyControlSequence = bool(value)

    @property
    def controlSequenceSignalType(self) -> ThrustSignalType:
        """Unit for demanded thrust force"""
        return self.__controlSequenceSignalType

    @controlSequenceSignalType.setter
    def controlSequenceSignalType(self, value: ThrustSignalType):
        """Set controlSequenceSignalType"""
        self.__controlSequenceSignalType = value

    @property
    def controlSequence(self) -> List[ControlSequenceItem]:
        """"""
        return self.__controlSequence

    @controlSequence.setter
    def controlSequence(self, value: List[ControlSequenceItem]):
        """Set controlSequence"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__controlSequence = value
