# This an autogenerated file
# 
# Generated with ThrusterFailureSpecification
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.thrusterfailurespecification import ThrusterFailureSpecificationBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .thrusterfailuremode import ThrusterFailureMode

class ThrusterFailureSpecification(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    failureMode : ThrusterFailureMode
         Thruster failure mode
    failureTime : float
         Time for thruster failure(default 0.0)
    """

    def __init__(self , description="", failureMode=ThrusterFailureMode.NO_FAILURE, failureTime=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.failureMode = failureMode
        self.failureTime = failureTime
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ThrusterFailureSpecificationBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def failureMode(self) -> ThrusterFailureMode:
        """Thruster failure mode"""
        return self.__failureMode

    @failureMode.setter
    def failureMode(self, value: ThrusterFailureMode):
        """Set failureMode"""
        self.__failureMode = value

    @property
    def failureTime(self) -> float:
        """Time for thruster failure"""
        return self.__failureTime

    @failureTime.setter
    def failureTime(self, value: float):
        """Set failureTime"""
        self.__failureTime = float(value)
