# This an autogenerated file
# 
# Generated with ParameterLines
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.parameterlines import ParameterLinesBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class ParameterLines(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    entityName : str
         (default None)
    floatIndex : int
         (default 0)
    value : float
         (default 0.0)
    """

    def __init__(self , description="", floatIndex=0, value=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.entityName = None
        self.floatIndex = floatIndex
        self.value = value
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ParameterLinesBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def entityName(self) -> str:
        """"""
        return self.__entityName

    @entityName.setter
    def entityName(self, value: str):
        """Set entityName"""
        self.__entityName = value

    @property
    def floatIndex(self) -> int:
        """"""
        return self.__floatIndex

    @floatIndex.setter
    def floatIndex(self, value: int):
        """Set floatIndex"""
        self.__floatIndex = int(value)

    @property
    def value(self) -> float:
        """"""
        return self.__value

    @value.setter
    def value(self, value: float):
        """Set value"""
        self.__value = float(value)
