# This an autogenerated file
# 
# Generated with WamitWave
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.wamitwave import WamitWaveBlueprint
from numpy import ndarray,asarray
from ..sima import MOAO
from ..sima import ScriptableValue

class WamitWave(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    periods : ndarray of float
         Wave periods
    headings : ndarray of float
         Wave headings
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.periods = []
        self.headings = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WamitWaveBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def periods(self) -> ndarray:
        """Wave periods"""
        return self.__periods

    @periods.setter
    def periods(self, value: ndarray):
        """Set periods"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__periods = array

    @property
    def headings(self) -> ndarray:
        """Wave headings"""
        return self.__headings

    @headings.setter
    def headings(self, value: ndarray):
        """Set headings"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__headings = array
