# This an autogenerated file
# 
# Generated with WindTurbineMotion
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.windturbinemotion import WindTurbineMotionBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .motiontype import MotionType
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .windparkturbine import WindParkTurbine

class WindTurbineMotion(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    turbine : WindParkTurbine
    timeColumn : int
         Column number for time(default 0)
    shaftDirectionColumn : int
         Column or time series number for shaft direction(default 0)
    motionType : MotionType
         Kind of motion time series input
    file : str
         File name for hub positions(default None)
    """

    def __init__(self , description="", timeColumn=0, shaftDirectionColumn=0, motionType=MotionType.POSI, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.turbine = None
        self.timeColumn = timeColumn
        self.shaftDirectionColumn = shaftDirectionColumn
        self.motionType = motionType
        self.file = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WindTurbineMotionBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def turbine(self) -> WindParkTurbine:
        """"""
        return self.__turbine

    @turbine.setter
    def turbine(self, value: WindParkTurbine):
        """Set turbine"""
        self.__turbine = value

    @property
    def timeColumn(self) -> int:
        """Column number for time"""
        return self.__timeColumn

    @timeColumn.setter
    def timeColumn(self, value: int):
        """Set timeColumn"""
        self.__timeColumn = int(value)

    @property
    def shaftDirectionColumn(self) -> int:
        """Column or time series number for shaft direction"""
        return self.__shaftDirectionColumn

    @shaftDirectionColumn.setter
    def shaftDirectionColumn(self, value: int):
        """Set shaftDirectionColumn"""
        self.__shaftDirectionColumn = int(value)

    @property
    def motionType(self) -> MotionType:
        """Kind of motion time series input"""
        return self.__motionType

    @motionType.setter
    def motionType(self, value: MotionType):
        """Set motionType"""
        self.__motionType = value

    @property
    def file(self) -> str:
        """File name for hub positions"""
        return self.__file

    @file.setter
    def file(self, value: str):
        """Set file"""
        self.__file = value
