# This an autogenerated file
# 
# Generated with ReynoldItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.reynolditem import ReynoldItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .airfoilitem import AirFoilItem
from .stallpoint import StallPoint

class ReynoldItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    reynoldsNumber : float
         Reynold number for given airfoil regime(default 0.0)
    items : List[AirFoilItem]
    stallPoint : StallPoint
    """

    def __init__(self , description="", reynoldsNumber=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.reynoldsNumber = reynoldsNumber
        self.items = list()
        self.stallPoint = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ReynoldItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def reynoldsNumber(self) -> float:
        """Reynold number for given airfoil regime"""
        return self.__reynoldsNumber

    @reynoldsNumber.setter
    def reynoldsNumber(self, value: float):
        """Set reynoldsNumber"""
        self.__reynoldsNumber = float(value)

    @property
    def items(self) -> List[AirFoilItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[AirFoilItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def stallPoint(self) -> StallPoint:
        """"""
        return self.__stallPoint

    @stallPoint.setter
    def stallPoint(self, value: StallPoint):
        """Set stallPoint"""
        self.__stallPoint = value
