import { aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Factory class for creating IAM roles and service-linked roles required by Bedrock AgentCore.
 */
export declare class IamRoleFactory {
    /**
     * Creates an IAM role for Bedrock AgentCore runtime execution.
     *
     * The role includes permissions for:
     * - ECR image access
     * - CloudWatch Logs
     * - X-Ray tracing
     * - CloudWatch metrics
     * - Bedrock model invocation
     * - AgentCore workload identity
     *
     * @param ctx - The parent construct
     * @param id - The construct ID
     * @param agentName - The name of the agent runtime
     * @returns The created IAM role
     */
    static createRuntimeExecutionRole(ctx: Construct, id: string, agentName: string): iam.Role;
    /**
     * Creates service-linked roles required by Bedrock AgentCore.
     *
     * This method creates two service-linked roles:
     * - Network SLR for network configuration
     * - Runtime Identity SLR for workload identity management
     *
     * If the roles already exist, the errors are ignored.
     *
     * @param ctx - The parent construct
     * @param id - The construct ID
     */
    static createServiceLinkedRoles(ctx: Construct, id: string): void;
    private static createExecutionPolicy;
    private static addNagSuppressions;
}
