"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaUrlStreamingAgentCoreRuntimePattern = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * A construct that creates a Lambda function with streaming URL to invoke AgentCore runtimes.
 *
 * This construct handles:
 * - Creating Lambda function with response streaming support
 * - Setting up Lambda function URL with CORS configuration
 * - IAM role with AgentCore invocation permissions
 * - Streaming response support via Lambda URL
 *
 * @example
 * new LambdaUrlStreamingAgentCoreRuntimePattern(this, 'LambdaUrl', {
 *   runtimeArn: runtime.runtimeArn,
 *   authType: lambda.FunctionUrlAuthType.NONE,
 * });
 */
class LambdaUrlStreamingAgentCoreRuntimePattern extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaRole = new aws_cdk_lib_1.aws_iam.Role(this, `${id}LambdaRole`, {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        lambdaRole.addToPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: ['bedrock-agentcore:InvokeAgentRuntime'],
            resources: ['arn:aws:bedrock-agentcore:*:*:runtime/*'],
        }));
        this.function = new aws_cdk_lib_1.aws_lambda.Function(this, `${id}Function`, {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_22_X,
            handler: 'index.handler',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../build/lambda-agentcore-runtime-lambda-url-streaming')),
            role: lambdaRole,
            architecture: aws_cdk_lib_1.aws_lambda.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(5),
            memorySize: 1024,
            environment: {
                ACORE_RUNTIME_ARN: props.runtimeArn,
            },
            logGroup: new aws_cdk_lib_1.aws_logs.LogGroup(this, `${id}FunctionLogGroup`, {
                retention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_WEEK,
            }),
        });
        this.functionUrl = this.function.addFunctionUrl({
            authType: props.authType || aws_cdk_lib_1.aws_lambda.FunctionUrlAuthType.AWS_IAM,
            invokeMode: aws_cdk_lib_1.aws_lambda.InvokeMode.RESPONSE_STREAM,
            cors: {
                allowedOrigins: ['*'],
                allowedMethods: [aws_cdk_lib_1.aws_lambda.HttpMethod.POST],
                allowedHeaders: ['*'],
            },
        });
        this.url = this.functionUrl.url;
    }
}
exports.LambdaUrlStreamingAgentCoreRuntimePattern = LambdaUrlStreamingAgentCoreRuntimePattern;
_a = JSII_RTTI_SYMBOL_1;
LambdaUrlStreamingAgentCoreRuntimePattern[_a] = { fqn: "simple-agentcore-runtime-patterns.LambdaUrlStreamingAgentCoreRuntimePattern", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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