# 📝 Changelog

Todas as mudanças notáveis deste projeto são documentadas automaticamente neste arquivo.

O formato é baseado em [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
e este projeto segue [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

**🤖 Gerado automaticamente** baseado em [Conventional Commits](docs/CONVENTIONAL_COMMITS.md)

---

## [Unreleased]
## [1.0.0] - 2026-01-17

### Added
- Initial release of Simple Python Utils
- `print_message()` function for printing messages with type validation
- `add_numbers()` function for adding two numbers with type safety
- Comprehensive test suite with 100% coverage
- Type hints for all functions
- Google-style docstrings with examples
- Professional package structure
- MIT License

### Features
- 🐍 Python 3.9+ support
- ✨ Two core utility functions
- 🧪 100% test coverage
- 🔒 Type safety and validation
- 📚 Comprehensive documentation
- ⚡ Zero external dependencies
- 🎨 Clean, readable code following PEP 8

### Technical Details
- Follows semantic versioning
- Uses type hints throughout
- Comprehensive error handling
- Detailed docstrings with examples
- Professional project structure

[Unreleased]: https://github.com/fjmpereira20/simple-python-utils/compare/v1.0.0...HEAD
[1.0.0]: https://github.com/fjmpereira20/simple-python-utils/releases/tag/v1.0.0
## [v1.6.0] - 2026-01-19

### ✨ Added (feat)
- add utility functions expansion (max_numbers, min_numbers, is_even, format_currency)
- implement acceptance testing approval gate for production deploys
- use trusted publishing for TestPyPI staging environment
- implement staging and acceptance testing environments

### 🐛 Fixed (fix)
- resolve commitlint validation issues
- use TEST_PYPI_API_TOKEN for staging deploy instead of trusted publishing
- use TEST_PYPI_API_TOKEN for staging deploy instead of trusted publishing
- replace emoji in Windows compatibility test to avoid encoding issues
- resolve workflow syntax issues
- update actions to v4 for consistency (partial)

### 📚 Documentation (docs)
- implement comprehensive documentation system
- comprehensive documentation system with badges and API reference

### 🔧 Technical (ci/build/chore)
- apply code formatting and linting fixes
- cleanup and backup old README
- improve README visual elegance and formatting
- configure staging environment for trusted publishing
- trigger staging deploy to test TEST_PYPI_API_TOKEN

# 📝 Changelog

Todas as mudanças notáveis deste projeto são documentadas automaticamente neste arquivo.

O formato é baseado em [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
e este projeto segue [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

**🤖 Gerado automaticamente** baseado em [Conventional Commits](docs/CONVENTIONAL_COMMITS.md)

---


### Added
- Initial release of Simple Python Utils
- `print_message()` function for printing messages with type validation
- `add_numbers()` function for adding two numbers with type safety
- Comprehensive test suite with 100% coverage
- Type hints for all functions
- Google-style docstrings with examples
- Professional package structure
- MIT License

### Features
- 🐍 Python 3.9+ support
- ✨ Two core utility functions
- 🧪 100% test coverage
- 🔒 Type safety and validation
- 📚 Comprehensive documentation
- ⚡ Zero external dependencies
- 🎨 Clean, readable code following PEP 8

### Technical Details
- Follows semantic versioning
- Uses type hints throughout
- Comprehensive error handling
- Detailed docstrings with examples
- Professional project structure

[Unreleased]: https://github.com/fjmpereira20/simple-python-utils/compare/v1.0.0...HEAD
[1.0.0]: https://github.com/fjmpereira20/simple-python-utils/releases/tag/v1.0.0