pub const BY_NAME: &'static [(&'static str, &'static [(char, char)])] = &[
    ("Emoji_Modifier", EMOJI_MODIFIER),
    ("Emoji_Modifier_Base", EMOJI_MODIFIER_BASE),
    ("Emoji_Presentation", EMOJI_PRESENTATION),
];

pub const EMOJI_MODIFIER: &'static [(char, char)] = &[('🏻', '🏿')];
pub const EXTRA_CHARS: &'static [(char, char)] =
    &[('\u{FE0E}', '\u{FE0F}'), ('\u{20E2}', '\u{20E4}')];

pub const EMOJI_MODIFIER_BASE: &'static [(char, char)] = &[
    ('☝', '☝'),
    ('⛹', '⛹'),
    ('✊', '✍'),
    ('🎅', '🎅'),
    ('🏂', '🏄'),
    ('🏇', '🏇'),
    ('🏊', '🏌'),
    ('👂', '👃'),
    ('👆', '👐'),
    ('👦', '👸'),
    ('👼', '👼'),
    ('💁', '💃'),
    ('💅', '💇'),
    ('💏', '💏'),
    ('💑', '💑'),
    ('💪', '💪'),
    ('🕴', '🕵'),
    ('🕺', '🕺'),
    ('🖐', '🖐'),
    ('🖕', '🖖'),
    ('🙅', '🙇'),
    ('🙋', '🙏'),
    ('🚣', '🚣'),
    ('🚴', '🚶'),
    ('🛀', '🛀'),
    ('🛌', '🛌'),
    ('🤌', '🤌'),
    ('🤏', '🤏'),
    ('🤘', '🤟'),
    ('🤦', '🤦'),
    ('🤰', '🤹'),
    ('🤼', '🤾'),
    ('🥷', '🥷'),
    ('🦵', '🦶'),
    ('🦸', '🦹'),
    ('🦻', '🦻'),
    ('🧍', '🧏'),
    ('🧑', '🧝'),
    ('🫃', '🫅'),
    ('🫰', '🫸'),
];

pub const EMOJI_PRESENTATION: &'static [(char, char)] = &[
    ('⌚', '⌛'),
    ('⏩', '⏬'),
    ('⏰', '⏰'),
    ('⏳', '⏳'),
    ('◽', '◾'),
    ('☔', '☕'),
    ('♈', '♓'),
    ('♿', '♿'),
    ('⚓', '⚓'),
    ('⚡', '⚡'),
    ('⚪', '⚫'),
    ('⚽', '⚾'),
    ('⛄', '⛅'),
    ('⛎', '⛎'),
    ('⛔', '⛔'),
    ('⛪', '⛪'),
    ('⛲', '⛳'),
    ('⛵', '⛵'),
    ('⛺', '⛺'),
    ('⛽', '⛽'),
    ('✅', '✅'),
    ('✊', '✋'),
    ('✨', '✨'),
    ('❌', '❌'),
    ('❎', '❎'),
    ('❓', '❕'),
    ('❗', '❗'),
    ('➕', '➗'),
    ('➰', '➰'),
    ('➿', '➿'),
    ('⬛', '⬜'),
    ('⭐', '⭐'),
    ('⭕', '⭕'),
    ('🀄', '🀄'),
    ('🃏', '🃏'),
    ('🆎', '🆎'),
    ('🆑', '🆚'),
    ('🇦', '🇿'),
    ('🈁', '🈁'),
    ('🈚', '🈚'),
    ('🈯', '🈯'),
    ('🈲', '🈶'),
    ('🈸', '🈺'),
    ('🉐', '🉑'),
    ('🌀', '🌠'),
    ('🌭', '🌵'),
    ('🌷', '🍼'),
    ('🍾', '🎓'),
    ('🎠', '🏊'),
    ('🏏', '🏓'),
    ('🏠', '🏰'),
    ('🏴', '🏴'),
    ('🏸', '🐾'),
    ('👀', '👀'),
    ('👂', '📼'),
    ('📿', '🔽'),
    ('🕋', '🕎'),
    ('🕐', '🕧'),
    ('🕺', '🕺'),
    ('🖕', '🖖'),
    ('🖤', '🖤'),
    ('🗻', '🙏'),
    ('🚀', '🛅'),
    ('🛌', '🛌'),
    ('🛐', '🛒'),
    ('🛕', '🛗'),
    ('🛜', '🛟'),
    ('🛫', '🛬'),
    ('🛴', '🛼'),
    ('🟠', '🟫'),
    ('🟰', '🟰'),
    ('🤌', '🤺'),
    ('🤼', '🥅'),
    ('🥇', '🧿'),
    ('🩰', '🩼'),
    ('🪀', '🪈'),
    ('🪐', '🪽'),
    ('🪿', '🫅'),
    ('🫎', '🫛'),
    ('🫠', '🫨'),
    ('🫰', '🫸'),
];

pub trait IsEmoji {
    fn is_emoji(&self) -> bool;
}
impl IsEmoji for char {
    fn is_emoji(&self) -> bool {
        for (lc, hc) in EMOJI_PRESENTATION {
            if self >= lc && self <= hc {
                return true;
            }
        }
        for (lc, hc) in EMOJI_MODIFIER {
            if self >= lc && self <= hc {
                return true;
            }
        }
        for (lc, hc) in EMOJI_MODIFIER_BASE {
            if self >= lc && self <= hc {
                return true;
            }
        }
        for (lc, hc) in EXTRA_CHARS {
            if self >= lc && self <= hc {
                return true;
            }
        }
        false
    }
}
