# -*- coding: utf-8 -*-
from distutils.core import setup

packages = \
['simplipy', 'simplipy.system', 'simplipy.util']

package_data = \
{'': ['*'], 'simplipy': ['sensor/*']}

install_requires = \
['aiohttp>=3.6.2,<4.0.0',
 'python-engineio>=3.9.3',
 'python-socketio>=4.3.1',
 'websockets>=8.1,<9.0']

setup_kwargs = {
    'name': 'simplisafe-python',
    'version': '5.3.2',
    'description': 'A Python3, async interface to the SimpliSafe API',
    'long_description': '# 🚨 simplisafe-python: A Python3, async interface to the SimpliSafe™ API\n\n[![CI](https://github.com/bachya/simplisafe-python/workflows/CI/badge.svg)](https://github.com/bachya/simplisafe-python/actions)\n[![PyPi](https://img.shields.io/pypi/v/simplisafe-python.svg)](https://pypi.python.org/pypi/simplisafe-python)\n[![Version](https://img.shields.io/pypi/pyversions/simplisafe-python.svg)](https://pypi.python.org/pypi/simplisafe-python)\n[![License](https://img.shields.io/pypi/l/simplisafe-python.svg)](https://github.com/bachya/simplisafe-python/blob/master/LICENSE)\n[![Code Coverage](https://codecov.io/gh/bachya/simplisafe-python/branch/master/graph/badge.svg)](https://codecov.io/gh/bachya/simplisafe-python)\n[![Maintainability](https://api.codeclimate.com/v1/badges/f46d8b1dcfde6a2f683d/maintainability)](https://codeclimate.com/github/bachya/simplisafe-python/maintainability)\n[![Say Thanks](https://img.shields.io/badge/SayThanks-!-1EAEDB.svg)](https://saythanks.io/to/bachya)\n\n`simplisafe-python` (hereafter referred to as `simplipy`) is a Python3,\n`asyncio`-driven interface to the unofficial SimpliSafe™ API. With it, users can\nget data on their system (including available sensors), set the system state,\nand more.\n\n# Documentation\n\nYou can find complete documentation here: https://simplisafe-python.readthedocs.io\n\n# Contributing\n\n1. [Check for open features/bugs](https://github.com/bachya/simplisafe-python/issues)\n  or [initiate a discussion on one](https://github.com/bachya/simplisafe-python/issues/new).\n2. [Fork the repository](https://github.com/bachya/simplisafe-python/fork).\n3. Install the dev environment: `make init`.\n4. Enter the virtual environment: `source ./venv/bin/activate`\n5. Code your new feature or bug fix.\n6. Write a test that covers your new functionality.\n7. Update `README.md` with any new documentation.\n8. Run tests and ensure 100% code coverage: `make coverage`\n9. Ensure you have no linting errors: `make lint`\n10. Ensure you have typed your code correctly: `make typing`\n11. Add yourself to `AUTHORS.md`.\n12. Submit a pull request!\n',
    'author': 'Aaron Bach',
    'author_email': 'bachya1208@gmail.com',
    'url': 'https://github.com/bachya/simplisafe-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
