# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.flow_enum_update_type import FlowEnumUpdateType
from ..types.v_1_column_redactions import V1ColumnRedactions
from ..types.v_1_delete_response import V1DeleteResponse
from ..types.v_1_delete_token_response import V1DeleteTokenResponse
from ..types.v_1_detokenize_response import V1DetokenizeResponse
from ..types.v_1_execute_query_response import V1ExecuteQueryResponse
from ..types.v_1_flow_tokenize_response import V1FlowTokenizeResponse
from ..types.v_1_get_response import V1GetResponse
from ..types.v_1_insert_record_data import V1InsertRecordData
from ..types.v_1_insert_response import V1InsertResponse
from ..types.v_1_token_group_redactions import V1TokenGroupRedactions
from ..types.v_1_tokenize_request_object import V1TokenizeRequestObject
from ..types.v_1_update_record_data import V1UpdateRecordData
from ..types.v_1_update_response import V1UpdateResponse
from ..types.v_1_upsert import V1Upsert
from .raw_client import AsyncRawFlowserviceClient, RawFlowserviceClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FlowserviceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFlowserviceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFlowserviceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFlowserviceClient
        """
        return self._raw_client

    def executequery(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1ExecuteQueryResponse:
        """
        Executes a query on the specified vault.

        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        query : typing.Optional[str]
            Query to execute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1ExecuteQueryResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.executequery()
        """
        _response = self._raw_client.executequery(vault_id=vault_id, query=query, request_options=request_options)
        return _response.data

    def delete(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1DeleteResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being deleted

        table_name : typing.Optional[str]
            Name of the table where data is being deleted

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1DeleteResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.delete()
        """
        _response = self._raw_client.delete(
            vault_id=vault_id, table_name=table_name, skyflow_i_ds=skyflow_i_ds, request_options=request_options
        )
        return _response.data

    def get(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        column_redactions: typing.Optional[typing.Sequence[V1ColumnRedactions]] = OMIT,
        columns: typing.Optional[typing.Sequence[str]] = OMIT,
        limit: typing.Optional[int] = OMIT,
        offset: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1GetResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being fetched

        table_name : typing.Optional[str]
            Name of the table where data is being fetched

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be fetched

        column_redactions : typing.Optional[typing.Sequence[V1ColumnRedactions]]
            List of columns to be redacted.

        columns : typing.Optional[typing.Sequence[str]]
            List of columns to be fetched.

        limit : typing.Optional[int]
            Limit for the number of records to be fetched

        offset : typing.Optional[int]
            Offset for the number of records to be fetched

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1GetResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.get()
        """
        _response = self._raw_client.get(
            vault_id=vault_id,
            table_name=table_name,
            skyflow_i_ds=skyflow_i_ds,
            column_redactions=column_redactions,
            columns=columns,
            limit=limit,
            offset=offset,
            request_options=request_options,
        )
        return _response.data

    def insert(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1InsertRecordData]] = OMIT,
        upsert: typing.Optional[V1Upsert] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1InsertResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        table_name : typing.Optional[str]
            Name of the table where data is being inserted

        records : typing.Optional[typing.Sequence[V1InsertRecordData]]
            List of data row wise that is to be inserted in the vault

        upsert : typing.Optional[V1Upsert]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1InsertResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.insert()
        """
        _response = self._raw_client.insert(
            vault_id=vault_id, table_name=table_name, records=records, upsert=upsert, request_options=request_options
        )
        return _response.data

    def update(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1UpdateRecordData]] = OMIT,
        update_type: typing.Optional[FlowEnumUpdateType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1UpdateResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being updated

        table_name : typing.Optional[str]
            Name of the table where data is being updated

        records : typing.Optional[typing.Sequence[V1UpdateRecordData]]
            List of data row wise that is to be updated in the vault

        update_type : typing.Optional[FlowEnumUpdateType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1UpdateResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.update()
        """
        _response = self._raw_client.update(
            vault_id=vault_id,
            table_name=table_name,
            records=records,
            update_type=update_type,
            request_options=request_options,
        )
        return _response.data

    def deletetoken(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1DeleteTokenResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID

        tokens : typing.Optional[typing.Sequence[str]]
            Token value

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1DeleteTokenResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.deletetoken()
        """
        _response = self._raw_client.deletetoken(vault_id=vault_id, tokens=tokens, request_options=request_options)
        return _response.data

    def detokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        token_group_redactions: typing.Optional[typing.Sequence[V1TokenGroupRedactions]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1DetokenizeResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where detokenizing

        tokens : typing.Optional[typing.Sequence[str]]
            Token to be detokenized

        token_group_redactions : typing.Optional[typing.Sequence[V1TokenGroupRedactions]]
            List of token groups to be redacted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1DetokenizeResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.detokenize()
        """
        _response = self._raw_client.detokenize(
            vault_id=vault_id,
            tokens=tokens,
            token_group_redactions=token_group_redactions,
            request_options=request_options,
        )
        return _response.data

    def tokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        data: typing.Optional[typing.Sequence[V1TokenizeRequestObject]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1FlowTokenizeResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID.

        data : typing.Optional[typing.Sequence[V1TokenizeRequestObject]]
            Data to be tokenized

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1FlowTokenizeResponse
            A successful response.

        Examples
        --------
        from skyflow import Skyflow

        client = Skyflow(
            base_url="https://yourhost.com/path/to/api",
        )
        client.flowservice.tokenize()
        """
        _response = self._raw_client.tokenize(vault_id=vault_id, data=data, request_options=request_options)
        return _response.data


class AsyncFlowserviceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFlowserviceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFlowserviceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFlowserviceClient
        """
        return self._raw_client

    async def executequery(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1ExecuteQueryResponse:
        """
        Executes a query on the specified vault.

        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        query : typing.Optional[str]
            Query to execute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1ExecuteQueryResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.executequery()


        asyncio.run(main())
        """
        _response = await self._raw_client.executequery(vault_id=vault_id, query=query, request_options=request_options)
        return _response.data

    async def delete(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1DeleteResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being deleted

        table_name : typing.Optional[str]
            Name of the table where data is being deleted

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1DeleteResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.delete()


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(
            vault_id=vault_id, table_name=table_name, skyflow_i_ds=skyflow_i_ds, request_options=request_options
        )
        return _response.data

    async def get(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        column_redactions: typing.Optional[typing.Sequence[V1ColumnRedactions]] = OMIT,
        columns: typing.Optional[typing.Sequence[str]] = OMIT,
        limit: typing.Optional[int] = OMIT,
        offset: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1GetResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being fetched

        table_name : typing.Optional[str]
            Name of the table where data is being fetched

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be fetched

        column_redactions : typing.Optional[typing.Sequence[V1ColumnRedactions]]
            List of columns to be redacted.

        columns : typing.Optional[typing.Sequence[str]]
            List of columns to be fetched.

        limit : typing.Optional[int]
            Limit for the number of records to be fetched

        offset : typing.Optional[int]
            Offset for the number of records to be fetched

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1GetResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            vault_id=vault_id,
            table_name=table_name,
            skyflow_i_ds=skyflow_i_ds,
            column_redactions=column_redactions,
            columns=columns,
            limit=limit,
            offset=offset,
            request_options=request_options,
        )
        return _response.data

    async def insert(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1InsertRecordData]] = OMIT,
        upsert: typing.Optional[V1Upsert] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1InsertResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        table_name : typing.Optional[str]
            Name of the table where data is being inserted

        records : typing.Optional[typing.Sequence[V1InsertRecordData]]
            List of data row wise that is to be inserted in the vault

        upsert : typing.Optional[V1Upsert]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1InsertResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.insert()


        asyncio.run(main())
        """
        _response = await self._raw_client.insert(
            vault_id=vault_id, table_name=table_name, records=records, upsert=upsert, request_options=request_options
        )
        return _response.data

    async def update(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1UpdateRecordData]] = OMIT,
        update_type: typing.Optional[FlowEnumUpdateType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1UpdateResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being updated

        table_name : typing.Optional[str]
            Name of the table where data is being updated

        records : typing.Optional[typing.Sequence[V1UpdateRecordData]]
            List of data row wise that is to be updated in the vault

        update_type : typing.Optional[FlowEnumUpdateType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1UpdateResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            vault_id=vault_id,
            table_name=table_name,
            records=records,
            update_type=update_type,
            request_options=request_options,
        )
        return _response.data

    async def deletetoken(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1DeleteTokenResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID

        tokens : typing.Optional[typing.Sequence[str]]
            Token value

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1DeleteTokenResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.deletetoken()


        asyncio.run(main())
        """
        _response = await self._raw_client.deletetoken(
            vault_id=vault_id, tokens=tokens, request_options=request_options
        )
        return _response.data

    async def detokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        token_group_redactions: typing.Optional[typing.Sequence[V1TokenGroupRedactions]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1DetokenizeResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where detokenizing

        tokens : typing.Optional[typing.Sequence[str]]
            Token to be detokenized

        token_group_redactions : typing.Optional[typing.Sequence[V1TokenGroupRedactions]]
            List of token groups to be redacted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1DetokenizeResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.detokenize()


        asyncio.run(main())
        """
        _response = await self._raw_client.detokenize(
            vault_id=vault_id,
            tokens=tokens,
            token_group_redactions=token_group_redactions,
            request_options=request_options,
        )
        return _response.data

    async def tokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        data: typing.Optional[typing.Sequence[V1TokenizeRequestObject]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> V1FlowTokenizeResponse:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID.

        data : typing.Optional[typing.Sequence[V1TokenizeRequestObject]]
            Data to be tokenized

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        V1FlowTokenizeResponse
            A successful response.

        Examples
        --------
        import asyncio

        from skyflow import AsyncSkyflow

        client = AsyncSkyflow(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.flowservice.tokenize()


        asyncio.run(main())
        """
        _response = await self._raw_client.tokenize(vault_id=vault_id, data=data, request_options=request_options)
        return _response.data
