# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..types.flow_enum_update_type import FlowEnumUpdateType
from ..types.v_1_column_redactions import V1ColumnRedactions
from ..types.v_1_delete_response import V1DeleteResponse
from ..types.v_1_delete_token_response import V1DeleteTokenResponse
from ..types.v_1_detokenize_response import V1DetokenizeResponse
from ..types.v_1_execute_query_response import V1ExecuteQueryResponse
from ..types.v_1_flow_tokenize_response import V1FlowTokenizeResponse
from ..types.v_1_get_response import V1GetResponse
from ..types.v_1_insert_record_data import V1InsertRecordData
from ..types.v_1_insert_response import V1InsertResponse
from ..types.v_1_token_group_redactions import V1TokenGroupRedactions
from ..types.v_1_tokenize_request_object import V1TokenizeRequestObject
from ..types.v_1_update_record_data import V1UpdateRecordData
from ..types.v_1_update_response import V1UpdateResponse
from ..types.v_1_upsert import V1Upsert

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawFlowserviceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def executequery(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1ExecuteQueryResponse]:
        """
        Executes a query on the specified vault.

        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        query : typing.Optional[str]
            Query to execute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1ExecuteQueryResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/query",
            method="POST",
            json={
                "vaultID": vault_id,
                "query": query,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1ExecuteQueryResponse,
                    parse_obj_as(
                        type_=V1ExecuteQueryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1DeleteResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being deleted

        table_name : typing.Optional[str]
            Name of the table where data is being deleted

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1DeleteResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/records/delete",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "skyflowIDs": skyflow_i_ds,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1DeleteResponse,
                    parse_obj_as(
                        type_=V1DeleteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        column_redactions: typing.Optional[typing.Sequence[V1ColumnRedactions]] = OMIT,
        columns: typing.Optional[typing.Sequence[str]] = OMIT,
        limit: typing.Optional[int] = OMIT,
        offset: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1GetResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being fetched

        table_name : typing.Optional[str]
            Name of the table where data is being fetched

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be fetched

        column_redactions : typing.Optional[typing.Sequence[V1ColumnRedactions]]
            List of columns to be redacted.

        columns : typing.Optional[typing.Sequence[str]]
            List of columns to be fetched.

        limit : typing.Optional[int]
            Limit for the number of records to be fetched

        offset : typing.Optional[int]
            Offset for the number of records to be fetched

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1GetResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/records/get",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "skyflowIDs": skyflow_i_ds,
                "columnRedactions": convert_and_respect_annotation_metadata(
                    object_=column_redactions, annotation=typing.Sequence[V1ColumnRedactions], direction="write"
                ),
                "columns": columns,
                "limit": limit,
                "offset": offset,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1GetResponse,
                    parse_obj_as(
                        type_=V1GetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def insert(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1InsertRecordData]] = OMIT,
        upsert: typing.Optional[V1Upsert] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1InsertResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        table_name : typing.Optional[str]
            Name of the table where data is being inserted

        records : typing.Optional[typing.Sequence[V1InsertRecordData]]
            List of data row wise that is to be inserted in the vault

        upsert : typing.Optional[V1Upsert]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1InsertResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/records/insert",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "records": convert_and_respect_annotation_metadata(
                    object_=records, annotation=typing.Sequence[V1InsertRecordData], direction="write"
                ),
                "upsert": convert_and_respect_annotation_metadata(
                    object_=upsert, annotation=V1Upsert, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1InsertResponse,
                    parse_obj_as(
                        type_=V1InsertResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1UpdateRecordData]] = OMIT,
        update_type: typing.Optional[FlowEnumUpdateType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1UpdateResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being updated

        table_name : typing.Optional[str]
            Name of the table where data is being updated

        records : typing.Optional[typing.Sequence[V1UpdateRecordData]]
            List of data row wise that is to be updated in the vault

        update_type : typing.Optional[FlowEnumUpdateType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1UpdateResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/records/update",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "records": convert_and_respect_annotation_metadata(
                    object_=records, annotation=typing.Sequence[V1UpdateRecordData], direction="write"
                ),
                "updateType": update_type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1UpdateResponse,
                    parse_obj_as(
                        type_=V1UpdateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def deletetoken(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1DeleteTokenResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID

        tokens : typing.Optional[typing.Sequence[str]]
            Token value

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1DeleteTokenResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/tokens/delete",
            method="POST",
            json={
                "vaultID": vault_id,
                "tokens": tokens,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1DeleteTokenResponse,
                    parse_obj_as(
                        type_=V1DeleteTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def detokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        token_group_redactions: typing.Optional[typing.Sequence[V1TokenGroupRedactions]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1DetokenizeResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where detokenizing

        tokens : typing.Optional[typing.Sequence[str]]
            Token to be detokenized

        token_group_redactions : typing.Optional[typing.Sequence[V1TokenGroupRedactions]]
            List of token groups to be redacted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1DetokenizeResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/tokens/detokenize",
            method="POST",
            json={
                "vaultID": vault_id,
                "tokens": tokens,
                "tokenGroupRedactions": convert_and_respect_annotation_metadata(
                    object_=token_group_redactions,
                    annotation=typing.Sequence[V1TokenGroupRedactions],
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1DetokenizeResponse,
                    parse_obj_as(
                        type_=V1DetokenizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def tokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        data: typing.Optional[typing.Sequence[V1TokenizeRequestObject]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[V1FlowTokenizeResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID.

        data : typing.Optional[typing.Sequence[V1TokenizeRequestObject]]
            Data to be tokenized

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[V1FlowTokenizeResponse]
            A successful response.
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/tokens/get",
            method="POST",
            json={
                "vaultID": vault_id,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[V1TokenizeRequestObject], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1FlowTokenizeResponse,
                    parse_obj_as(
                        type_=V1FlowTokenizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawFlowserviceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def executequery(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1ExecuteQueryResponse]:
        """
        Executes a query on the specified vault.

        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        query : typing.Optional[str]
            Query to execute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1ExecuteQueryResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/query",
            method="POST",
            json={
                "vaultID": vault_id,
                "query": query,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1ExecuteQueryResponse,
                    parse_obj_as(
                        type_=V1ExecuteQueryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1DeleteResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being deleted

        table_name : typing.Optional[str]
            Name of the table where data is being deleted

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1DeleteResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/records/delete",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "skyflowIDs": skyflow_i_ds,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1DeleteResponse,
                    parse_obj_as(
                        type_=V1DeleteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        skyflow_i_ds: typing.Optional[typing.Sequence[str]] = OMIT,
        column_redactions: typing.Optional[typing.Sequence[V1ColumnRedactions]] = OMIT,
        columns: typing.Optional[typing.Sequence[str]] = OMIT,
        limit: typing.Optional[int] = OMIT,
        offset: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1GetResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being fetched

        table_name : typing.Optional[str]
            Name of the table where data is being fetched

        skyflow_i_ds : typing.Optional[typing.Sequence[str]]
            Skyflow ID for the record to be fetched

        column_redactions : typing.Optional[typing.Sequence[V1ColumnRedactions]]
            List of columns to be redacted.

        columns : typing.Optional[typing.Sequence[str]]
            List of columns to be fetched.

        limit : typing.Optional[int]
            Limit for the number of records to be fetched

        offset : typing.Optional[int]
            Offset for the number of records to be fetched

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1GetResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/records/get",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "skyflowIDs": skyflow_i_ds,
                "columnRedactions": convert_and_respect_annotation_metadata(
                    object_=column_redactions, annotation=typing.Sequence[V1ColumnRedactions], direction="write"
                ),
                "columns": columns,
                "limit": limit,
                "offset": offset,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1GetResponse,
                    parse_obj_as(
                        type_=V1GetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def insert(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1InsertRecordData]] = OMIT,
        upsert: typing.Optional[V1Upsert] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1InsertResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being inserted

        table_name : typing.Optional[str]
            Name of the table where data is being inserted

        records : typing.Optional[typing.Sequence[V1InsertRecordData]]
            List of data row wise that is to be inserted in the vault

        upsert : typing.Optional[V1Upsert]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1InsertResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/records/insert",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "records": convert_and_respect_annotation_metadata(
                    object_=records, annotation=typing.Sequence[V1InsertRecordData], direction="write"
                ),
                "upsert": convert_and_respect_annotation_metadata(
                    object_=upsert, annotation=V1Upsert, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1InsertResponse,
                    parse_obj_as(
                        type_=V1InsertResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        table_name: typing.Optional[str] = OMIT,
        records: typing.Optional[typing.Sequence[V1UpdateRecordData]] = OMIT,
        update_type: typing.Optional[FlowEnumUpdateType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1UpdateResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where data is being updated

        table_name : typing.Optional[str]
            Name of the table where data is being updated

        records : typing.Optional[typing.Sequence[V1UpdateRecordData]]
            List of data row wise that is to be updated in the vault

        update_type : typing.Optional[FlowEnumUpdateType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1UpdateResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/records/update",
            method="POST",
            json={
                "vaultID": vault_id,
                "tableName": table_name,
                "records": convert_and_respect_annotation_metadata(
                    object_=records, annotation=typing.Sequence[V1UpdateRecordData], direction="write"
                ),
                "updateType": update_type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1UpdateResponse,
                    parse_obj_as(
                        type_=V1UpdateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def deletetoken(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1DeleteTokenResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID

        tokens : typing.Optional[typing.Sequence[str]]
            Token value

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1DeleteTokenResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/tokens/delete",
            method="POST",
            json={
                "vaultID": vault_id,
                "tokens": tokens,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1DeleteTokenResponse,
                    parse_obj_as(
                        type_=V1DeleteTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def detokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        token_group_redactions: typing.Optional[typing.Sequence[V1TokenGroupRedactions]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1DetokenizeResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            ID of the vault where detokenizing

        tokens : typing.Optional[typing.Sequence[str]]
            Token to be detokenized

        token_group_redactions : typing.Optional[typing.Sequence[V1TokenGroupRedactions]]
            List of token groups to be redacted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1DetokenizeResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/tokens/detokenize",
            method="POST",
            json={
                "vaultID": vault_id,
                "tokens": tokens,
                "tokenGroupRedactions": convert_and_respect_annotation_metadata(
                    object_=token_group_redactions,
                    annotation=typing.Sequence[V1TokenGroupRedactions],
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1DetokenizeResponse,
                    parse_obj_as(
                        type_=V1DetokenizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def tokenize(
        self,
        *,
        vault_id: typing.Optional[str] = OMIT,
        data: typing.Optional[typing.Sequence[V1TokenizeRequestObject]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[V1FlowTokenizeResponse]:
        """
        Parameters
        ----------
        vault_id : typing.Optional[str]
            Vault ID.

        data : typing.Optional[typing.Sequence[V1TokenizeRequestObject]]
            Data to be tokenized

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[V1FlowTokenizeResponse]
            A successful response.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/tokens/get",
            method="POST",
            json={
                "vaultID": vault_id,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[V1TokenizeRequestObject], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    V1FlowTokenizeResponse,
                    parse_obj_as(
                        type_=V1FlowTokenizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
