# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class V1DetokenizeResponseObject(UniversalBaseModel):
    token: typing.Optional[str] = pydantic.Field(default=None)
    """
    Token to be detokenized
    """

    value: typing.Optional[typing.Optional[typing.Any]] = None
    token_group_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="tokenGroupName")] = (
        pydantic.Field(default=None)
    )
    """
    Token group name
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error if detokenization failed
    """

    http_code: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="httpCode")] = pydantic.Field(
        default=None
    )
    """
    HTTP status code of the response
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional metadata associated with the token, such as tableName or skyflowID
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
