# slims-python-api: Interact with SLims from python

The SLims python api allows you to interact with your SLims instance by using Python. It allows you to extend the versatile capability of SLims even further.


## Documentation

The documentation can be found on the following page:

http://slims-python-api.readthedocs.io/en/latest/


## Getting Started

To get you started we provided a few cookbook examples:

### [Data Manipulation](cookbook/data-manipulation)

In this script, we demonstrate creating, modifying and removing content.


### [Flow Example](cookbook/flow-example)
Learn how to create a SLimsgate flow with python. In the given example you will create a very simple two steps flow. In the first step a content record can be selected in the UI. In the second step a new id
for that content record can be chosen.

### [Live Report](cookbook/live-report)
This web application is displaying on a web page a live report for a selected period. It shows how a webportal can be used to create a specific report directly through the api.

### [Order Submission](cookbook/order-submission)
In this sample web application, a user can create an order direclty through a web portal, with customizable appearance and formatting

### [Plotting](cookbook/plotting)
In this example, we demonstrate how graphical plots can be created with python while fetching the data through the api.


## Contributions
If you want to contribute to the project, we welcome any addition and we will merge it through a pulls request


## Questions, Suggestions
If you have any questions or suggestions on for our python API don't hesitate to open issues on this github repository.




