import json
import unittest

import responses

from slims.flowrun import FlowRun, Status
from slims.slims import Slims


class Test_Flow_Run(unittest.TestCase):

    @responses.activate
    def test_logging(self):
        def request_callback(request):
            body = json.loads(request.body.decode('utf-8'))
            assert body == {'flowRunGuid': 'guid', 'index': 0, 'message': 'hi'}
            return (200, {}, json.dumps({}))

        responses.add_callback(
            responses.POST,
            'http://localhost:9999/rest/external/log',
            callback=request_callback,
            content_type='application/json',
        )

        slims = Slims("testSlims", "http://localhost:9999", "admin", "admin")
        flowrun = FlowRun(slims.slims_api, 0, {
            "flowInformation": {"flowRunGuid": "guid"}
        })
        flowrun.log("hi")

    @responses.activate
    def test_update_status(self):
        def request_callback(request):
            body = json.loads(request.body.decode('utf-8'))
            assert body == {'flowRunGuid': 'guid', 'index': 0, 'status': 'FAILED'}
            return (200, {}, json.dumps({}))

        responses.add_callback(
            responses.POST,
            'http://localhost:9999/rest/external/status',
            callback=request_callback,
            content_type='application/json',
        )

        slims = Slims("testSlims", "http://localhost:9999", "admin", "admin")
        flowrun = FlowRun(slims.slims_api, 0, {
            "flowInformation": {"flowRunGuid": "guid"}
        })
        flowrun._update_status(Status.FAILED)
