# Smart Git Commit 🚀

An AI-powered Git workflow tool that intelligently analyzes your changes, groups them into logical commits, and generates detailed conventional commit messages.

## Features

- 🤖 **AI-Powered Analysis**: Leverages Ollama models to understand your code changes
- 🔍 **Intelligent Grouping**: Organizes changes into logical, atomic commits
- 📝 **Conventional Commits**: Generates structured commit messages following the convention
- 🔄 **Tech Stack Detection**: Automatically adapts to different programming languages and frameworks
- 🚀 **GPU Acceleration**: Uses hardware acceleration for faster processing
- ⚡ **Fallback Mechanism**: Works even without AI using rule-based analysis
- 🎯 **Smart Change Importance**: Prioritizes changes based on impact analysis
- 🧩 **Component Detection**: Identifies file components based on project structure

## Prerequisites

### Basic Requirements
- Python 3.7+
- Git (installed and available in PATH)

### For AI-Powered Features (Optional)
- [Ollama](https://ollama.ai) installed and running
- At least one LLM model pulled in Ollama
- Ollama server accessible (default: http://localhost:11434)

## Ollama Setup

To use the AI-powered features:

1. **Install Ollama**:
   - Download from [ollama.ai](https://ollama.ai/download)
   - Follow the installation instructions for your platform

2. **Start the Ollama server**:
   ```bash
   ollama serve
   ```

3. **Pull at least one model**:
   ```bash
   # Pull a recommended model
   ollama pull llama3
   
   # Or a smaller model
   ollama pull gemma:2b
   ```

4. **Verify your installation**:
   ```bash
   # List available models
   ollama list
   ```

## Installation

```bash
# Install from PyPI
pip install smart-git-commit

# Or install directly from the repository
pip install git+https://github.com/CripterHack/smart-git-commit.git
```

## Usage

```bash
# Basic usage (will prompt for Ollama model selection)
smart-git-commit

# Disable AI-powered analysis
smart-git-commit --no-ai

# Use a specific Ollama model
smart-git-commit --ollama-model llama3

# Non-interactive mode
smart-git-commit --non-interactive

# Specify a repository path
smart-git-commit --repo-path /path/to/your/repository

# Specify a custom Ollama server
smart-git-commit --ollama-host http://custom-ollama-server:11434

# See all options
smart-git-commit --help
```

### Command Line Options

```
usage: smart-git-commit [-h] [--repo-path REPO_PATH] [--non-interactive]
                        [--ollama-host OLLAMA_HOST] 
                        [--ollama-model OLLAMA_MODEL] [--no-ai]

Smart Git Commit Workflow with Ollama Integration

options:
  -h, --help            show this help message and exit
  --repo-path REPO_PATH
                        Path to the git repository
  --non-interactive     Run without interactive prompts
  --ollama-host OLLAMA_HOST
                        Host for Ollama API
  --ollama-model OLLAMA_MODEL
                        Model to use for Ollama (will prompt if not specified)
  --no-ai               Disable AI-powered analysis
```

## Example Commit

Here's an example of a commit message generated by Smart Git Commit:

```
feat(api-auth): Add JWT token validation middleware

Implement secure JWT token validation with proper error handling and 
expiration checks. Add support for refresh tokens with configurable 
lifetime settings.

Affected files:
- M src/auth/jwt_validator.js
- M src/middleware/auth.js
- + src/utils/token_helpers.js
- M config/auth.json

Fixes #123
```

## How It Works

### Workflow Overview

1. **Load Changes**: Detects all modified and untracked files in the Git repository
2. **Analyze Changes**: Examines each file's content, language, and importance
3. **Group Changes**: Organizes related files into logical, atomic commits
4. **Generate Commit Messages**: Creates detailed, conventional commit messages
5. **Execute Commits**: Handles the git staging and commit process

### Change Analysis

The tool analyzes changes through multiple dimensions:

- **File Status**: Checks if files are modified, added, or deleted
- **Language Detection**: Identifies programming languages based on file extensions
- **Component Recognition**: Maps files to logical components (e.g., docs, tests, api)
- **Tech Stack Detection**: Detects project technologies (e.g., Python, Node.js, React)
- **Importance Rating**: With AI, assesses the impact and significance of each change

### Intelligent Grouping

Changes are grouped based on:

- **Component Coherence**: Files from the same component are grouped together
- **Logical Relationship**: AI analyzes file dependencies and relationships
- **Change Size Management**: Large groups are split into smaller, coherent commits
- **Commit Type Assignment**: Each group is assigned a conventional commit type (feat, fix, etc.)

### Ollama LLM Integration

When using AI mode (default):

1. Smart Git Commit connects to Ollama's API
2. Available LLM models are detected automatically
3. The selected model analyzes file changes and content
4. AI determines logical groupings and generates commit descriptions
5. GPU acceleration is used when available

### Non-AI Fallback

When AI is unavailable or disabled:

1. Files are grouped by component/directory
2. Commit types are assigned based on file paths and extensions
3. Basic commit messages are generated using rule-based templates
4. The user can interactively refine the commit details

### Interactive Workflow

In interactive mode (default):

1. Each commit group is presented for review
2. You can approve, skip, or edit the commit details
3. Edit options include changing the commit name, type, description, and issue references
4. The tool handles staging and committing the files
5. You can review the final commit before proceeding to the next group

## Project Structure

- **`CommitType` Enum**: Defines conventional commit types (feat, fix, docs, etc.)
- **`GitChange` Class**: Represents a changed file with metadata
- **`CommitGroup` Class**: Groups related changes for a single commit
- **`OllamaClient` Class**: Handles communication with Ollama API
- **`SmartGitCommitWorkflow` Class**: Orchestrates the entire commit process

## Advanced Usage

### Using Custom Ollama Endpoints

```bash
# Use a different Ollama host
smart-git-commit --ollama-host http://custom-ollama-server:11434
```

### Non-Interactive Automation

```bash
# For CI/CD or automated scripts
smart-git-commit --non-interactive
```

### Working with Multiple Repositories

```bash
# Specify the repository path
smart-git-commit --repo-path /path/to/your/repository
```

## Troubleshooting

### Common Issues

#### Error: "No models found in Ollama"
- Make sure Ollama is running: `ollama serve`
- Check that you have at least one model installed: `ollama list`
- If no models are available, pull one: `ollama pull llama3`

#### Error: "Failed to get models from Ollama API"
- Check that the Ollama server is accessible on the specified host
- Default location is http://localhost:11434
- Verify your network connection allows access to the Ollama server
- Try restarting the Ollama server: `ollama serve`

#### Error: "Failed to generate text with Ollama"
- The model might be too large for your hardware
- Try a smaller model like gemma:2b or tinyllama
- Check Ollama server logs for any errors or memory issues

### Ollama Connection Issues

If you encounter issues connecting to Ollama:

1. Ensure Ollama is running: `ollama serve`
2. Check that you have at least one model: `ollama list`
3. Try specifying the host explicitly: `--ollama-host http://localhost:11434`
4. Check for firewall or network issues if using a remote server

### Falling Back to Non-AI Mode

If AI analysis isn't working properly:

```bash
# Run with fallback mode explicitly
smart-git-commit --no-ai
```

## System Requirements

- **Minimum**: Python 3.7+, Git, 4GB RAM
- **Recommended for AI mode**:
  - 8GB+ RAM
  - An Ollama-compatible system
  - Internet connection (for initial model download)

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

To set up your development environment:

1. Clone the repository
2. Install development dependencies: `pip install -e ".[dev]"`
3. Run tests: `pytest tests/`

## License

MIT

## Acknowledgements

- [Conventional Commits](https://www.conventionalcommits.org/) for the commit message format
- [Ollama](https://github.com/ollama/ollama) for the local LLM capabilities

# Changelog

## 0.1.3 (2025-04-23)
- Fix several issues related to ollama

## 0.1.2 (2025-04-23)
- Update meta data

## 0.1.1 (2025-04-23)
- Fixed bug in component detection for subdirectories
- Improved error handling for Ollama connection issues

## 0.1.0 (2025-04-23)
- Initial release