
<p align="center">
  <img src="https://raw.githubusercontent.com/CripterHack/smart-git-commit/main/smart-commit.png" alt="Smart Git Commit" width="256" height="256"/>
</p>

# Smart Git Commit 🚀

An AI-powered Git workflow tool that intelligently analyzes your changes, groups them into logical commits, and generates detailed conventional commit messages.

## ❤️ Support This Project

If you find Smart Git Commit helpful for your workflow, please consider supporting the development:

- **[GitHub Sponsors](https://github.com/sponsors/CripterHack)**: Become a sponsor through GitHub
- **[PayPal](http://paypal.com/paypalme/cripterhack)**: Make a one-time donation

Your support helps maintain this project and develop new features!

## Features

- 🤖 **AI-Powered Analysis**: Leverages Ollama models to understand your code changes
- 🔍 **Intelligent Grouping**: Organizes changes into logical, atomic commits
- 📝 **Conventional Commits**: Generates structured commit messages following the convention
- 🔄 **Tech Stack Detection**: Automatically adapts to different programming languages and frameworks
- 🚀 **GPU Acceleration**: Uses hardware acceleration for faster processing
- ⚡ **Fallback Mechanism**: Works even without AI using rule-based analysis
- 🎯 **Smart Change Importance**: Prioritizes changes based on impact analysis
- 🧩 **Component Detection**: Identifies file components based on project structure

## Installation from PyPI

The package is available on PyPI and can be installed using pip: https://pypi.org/project/smart-git-commit/

## Prerequisites

### Basic Requirements
- Python 3.7+
- Git (installed and available in PATH)

### For AI-Powered Features (Optional)
- [Ollama](https://ollama.ai) installed and running
- At least one LLM model pulled in Ollama
- Ollama server accessible (default: http://localhost:11434)

## Ollama Setup

To use the AI-powered features:

1. **Install Ollama**:
   - Download from [ollama.ai](https://ollama.ai/download)
   - Follow the installation instructions for your platform

2. **Start the Ollama server**:
   ```bash
   ollama serve
   ```

3. **Pull at least one model**:
   ```bash
   # Pull a recommended model
   ollama pull llama3
   
   # Or a smaller model
   ollama pull gemma:2b
   ```

4. **Verify your installation**:
   ```bash
   # List available models
   ollama list
   ```

## Installation

```bash
# Install from PyPI
pip install smart-git-commit

# Or install directly from the repository
pip install git+https://github.com/CripterHack/smart-git-commit.git
```

## Usage

```bash
# Basic usage (will prompt for Ollama model selection)
smart-git-commit

# Disable AI-powered analysis
smart-git-commit --no-ai

# Use a specific Ollama model
smart-git-commit --ollama-model llama3

# Non-interactive mode
smart-git-commit --non-interactive

# Specify a repository path
smart-git-commit --repo-path /path/to/your/repository

# Specify a custom Ollama server
smart-git-commit --ollama-host http://custom-ollama-server:11434

# See all options
smart-git-commit --help
```

### Command Line Options

```
usage: smart-git-commit [-h] [--repo-path REPO_PATH] [--non-interactive]
                        [--ollama-host OLLAMA_HOST] 
                        [--ollama-model OLLAMA_MODEL] [--no-ai]
                        [--timeout TIMEOUT] [--verbose] [--skip-hooks]
                        [--no-revert] [--no-parallel] [--no-color]
                        [--version]

Smart Git Commit Workflow with Ollama Integration

options:
  -h, --help            show this help message and exit
  --repo-path REPO_PATH
                        Path to the git repository
  --non-interactive     Run without interactive prompts
  --ollama-host OLLAMA_HOST
                        Host for Ollama API
  --ollama-model OLLAMA_MODEL
                        Model to use for Ollama (will prompt if not specified)
  --no-ai               Disable AI-powered analysis
  --timeout TIMEOUT     Timeout in seconds for HTTP requests (default: 60)
  --verbose             Show verbose debug output
  --skip-hooks          Skip Git hooks when committing (useful if pre-commit is not installed)
  --no-revert           Don't automatically revert staged changes on error
  --no-parallel         Disable parallel processing for slower but more stable operation
  --no-color            Disable colored output
  --version             Show version information and support links
```

## Example Commit

Here's an example of a commit message generated by Smart Git Commit:

```
feat(api-auth): Add JWT token validation middleware

Implement secure JWT token validation with proper error handling and 
expiration checks. Add support for refresh tokens with configurable 
lifetime settings.

Affected files:
- M src/auth/jwt_validator.js
- M src/middleware/auth.js
- + src/utils/token_helpers.js
- M config/auth.json

Fixes #123
```

## How It Works

### Workflow Overview

1. **Load Changes**: Detects all modified and untracked files in the Git repository
2. **Analyze Changes**: Examines each file's content, language, and importance
3. **Group Changes**: Organizes related files into logical, atomic commits
4. **Generate Commit Messages**: Creates detailed, conventional commit messages
5. **Execute Commits**: Handles the git staging and commit process

### Change Analysis

The tool analyzes changes through multiple dimensions:

- **File Status**: Checks if files are modified, added, or deleted
- **Language Detection**: Identifies programming languages based on file extensions
- **Component Recognition**: Maps files to logical components (e.g., docs, tests, api)
- **Tech Stack Detection**: Detects project technologies (e.g., Python, Node.js, React)
- **Importance Rating**: With AI, assesses the impact and significance of each change

### Intelligent Grouping

Changes are grouped based on:

- **Component Coherence**: Files from the same component are grouped together
- **Logical Relationship**: AI analyzes file dependencies and relationships
- **Change Size Management**: Large groups are split into smaller, coherent commits
- **Commit Type Assignment**: Each group is assigned a conventional commit type (feat, fix, etc.)

### Ollama LLM Integration

When using AI mode (default):

1. Smart Git Commit connects to Ollama's API
2. Available LLM models are detected automatically
3. The selected model analyzes file changes and content
4. AI determines logical groupings and generates commit descriptions
5. GPU acceleration is used when available

### Non-AI Fallback

When AI is unavailable or disabled:

1. Files are grouped by component/directory
2. Commit types are assigned based on file paths and extensions
3. Basic commit messages are generated using rule-based templates
4. The user can interactively refine the commit details

### Interactive Workflow

In interactive mode (default):

1. Each commit group is presented for review
2. You can approve, skip, or edit the commit details
3. Edit options include changing the commit name, type, description, and issue references
4. The tool handles staging and committing the files
5. You can review the final commit before proceeding to the next group

## Project Structure

- **`CommitType` Enum**: Defines conventional commit types (feat, fix, docs, etc.)
- **`GitChange` Class**: Represents a changed file with metadata
- **`CommitGroup` Class**: Groups related changes for a single commit
- **`OllamaClient` Class**: Handles communication with Ollama API
- **`SmartGitCommitWorkflow` Class**: Orchestrates the entire commit process

## Advanced Usage

### Using Custom Ollama Endpoints

```bash
# Use a different Ollama host
smart-git-commit --ollama-host http://custom-ollama-server:11434
```

### Non-Interactive Automation

```bash
# For CI/CD or automated scripts
smart-git-commit --non-interactive
```

### Working with Multiple Repositories

```bash
# Specify the repository path
smart-git-commit --repo-path /path/to/your/repository
```

## Troubleshooting

### Common Issues

#### Error: "Not a git repository"
- Ensure you're running the command from within a git repository
- If needed, initialize a new git repository with `git init`
- Verify that the `.git` directory exists and is accessible

#### Error: "Repository path does not exist"
- Check that the specified path exists when using `--repo-path`
- Use absolute paths if relative paths aren't working correctly

#### Error: "Git is not properly configured"
- Git requires user.name and user.email to be set before committing
- Configure with:
  ```bash
  git config --global user.name "Your Name"
  git config --global user.email "your.email@example.com"
  ```

#### Error: "Failed to stage files"
- When running from a subdirectory, use the `--repo-path` argument to specify the git root directory:
  ```bash
  # If you're in a subdirectory like 'backend'
  smart-git-commit --repo-path ..
  ```
- Ensure you have write access to the repository files

#### Error: "No models found in Ollama"
- Make sure Ollama is running: `ollama serve`
- Check that you have at least one model installed: `ollama list`
- If no models are available, pull one: `ollama pull llama3`

#### Error: "Failed to get models from Ollama API"
- Check that the Ollama server is accessible on the specified host
- Default location is http://localhost:11434
- Verify your network connection allows access to the Ollama server
- Try restarting the Ollama server: `ollama serve`

#### Error: "Failed to generate text with Ollama"
- The model might be too large for your hardware
- Try a smaller model like gemma:2b or tinyllama
- Check Ollama server logs for any errors or memory issues

#### Connection Timeouts
- If you experience connection timeouts with Ollama, you can adjust the timeout parameter:
  ```bash
  # Increase the timeout to 100 seconds
  smart-git-commit --timeout 100
  ```
- For slow networks or large models, a longer timeout may be necessary

#### Error: "No module named pre_commit"
- This occurs when your repository has pre-commit hooks configured but the pre-commit Python module is not installed
- Solutions:
  1. Smart Git Commit will now automatically detect this issue and skip hooks (with a notice)
  2. Install pre-commit: `pip install pre-commit`
  3. Skip the hooks manually: `smart-git-commit --skip-hooks`
  4. Remove pre-commit hooks from the repository if not needed

### Command-Line Debugging

For more detailed information when errors occur, use the `--verbose` flag:

```bash
smart-git-commit --verbose
```

This will show additional debugging information that can help diagnose issues.

### Ollama Connection Issues

If you encounter issues connecting to Ollama:

1. Ensure Ollama is running: `ollama serve`
2. Check that you have at least one model: `ollama list`
3. Try specifying the host explicitly: `--ollama-host http://localhost:11434`
4. Check for firewall or network issues if using a remote server

### Falling Back to Non-AI Mode

If AI analysis isn't working properly:

```bash
# Run with fallback mode explicitly
smart-git-commit --no-ai
```

## System Requirements

- **Minimum**: Python 3.7+, Git, 4GB RAM
- **Recommended for AI mode**:
  - 8GB+ RAM
  - An Ollama-compatible system
  - Internet connection (for initial model download)

## To-Do / Future Features

Here are some planned enhancements and features for future releases:

- [ ] **GitHub/GitLab Integration**: Automatic issue linking and PR description generation
- [ ] **Commit Squashing**: Intelligently squash related commits for cleaner history
- [ ] **Multiple AI Backends**: Support for additional AI providers beyond Ollama (like OpenAI, Anthropic, or local models)
- [ ] **Interactive TUI Mode**: Text-based user interface for easier navigation through changes
- [ ] **Custom Commit Templates**: Support for user-defined commit templates and conventions
- [ ] **Config File Support**: Persistent user configurations and project-specific settings
- [ ] **Pre-commit Hook Integration**: Run as a Git hook for seamless workflow integration
- [ ] **Bulk Processing Mode**: Process multiple repositories in batch mode for organization-wide standards
- [ ] **Plugin System**: Allow extensions to add custom functionality
- [x] **Performance Optimization**: Faster processing of large repositories with many changes

Contributions to any of these features are welcome! See the Contributing section below.

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

To set up your development environment:

1. Clone the repository
2. Install development dependencies: `pip install -e ".[dev]"`
3. Run tests: `pytest tests/` or use the included test runner: `python run_tests.py`

### Running Tests

The project includes a test runner script with coverage reporting:

```bash
# Run tests with verbose output
python run_tests.py -v

# Run tests with coverage reporting (requires the coverage package)
python run_tests.py -c

# Run tests with both verbose output and coverage reporting
python run_tests.py -v -c
```

## Sponsorship

If this tool saves you time or helps your workflow, please consider supporting its development:

- **[GitHub Sponsors](https://github.com/sponsors/CripterHack)**: Support ongoing development through GitHub
- **[PayPal](http://paypal.com/paypalme/cripterhack)**: Make a one-time donation

Every contribution helps maintain this project and add new features. Thank you for your support! ❤️

## License

MIT

## Acknowledgements

- [Conventional Commits](https://www.conventionalcommits.org/) for the commit message format
- [Ollama](https://github.com/ollama/ollama) for the local LLM capabilities

# Changelog

## 0.2.3 (2025-04-26)
- Enhanced cyberpunk theme with artistic Celtic knot border design for improved visual aesthetics
- Implemented wider banner display (130 characters) for better visibility on modern terminals
- Added support for previously implemented dracula and nord themes in command-line interface
- Improved theme-specific banner styling with unique layouts for each theme variant
- Enhanced theme-specific section headers with distinct visual styles for each theme
- Optimized ASCII art rendering for better compatibility across terminal types
- Fixed theme formatting inconsistencies between different UI components
- Improved color contrast in cyberpunk theme for better readability in various terminal backgrounds
- Added highlight color usage in banner display for better visual hierarchy

## 0.2.2 (2025-04-26)
- Enhanced cyberpunk theme with vibrant colors for improved terminal visibility
- Added theme switching via command-line parameter with --theme option
- Implemented consistent color theme application across all UI components
- Added color support detection with graceful fallback for terminals without ANSI support
- Improved banner display with theme-specific ASCII art
- Enhanced section headers with themed styling for better readability
- Added accent colors for highlighting important information
- Implemented spinner animations with theme-consistent colors
- Applied theme colors to success, warning, and error messages for intuitive feedback
- Fixed critical bug with theme color getters causing 'str' object not callable errors
- Added robust error handling to theme color methods for improved reliability
- Fixed color support detection to preserve class methods during terminal capability checks

## 0.2.1 (2025-04-26)
- Added early git status check to avoid loading AI model when working directory is clean
- Fixed default "Yes" option in commit confirmation prompt to properly handle Enter key
- Fixed critical issue with file staging where git was incorrectly processing filenames with status indicators
- Improved git staging process with proper handling of files with special characters or dashes
- Enhanced error handling during file staging operations with better reporting
- Added intelligent auto-detection of pre-commit hook availability to avoid errors without manual flag
- Improved user experience with automatic hook skipping when pre_commit module is missing
- Added informative error messages with actionable solutions for pre-commit issues
- Enhanced terminal output with ANSI colors for improved readability
- Added color support detection with graceful fallback for unsupported terminals
- Improved Windows compatibility with better path handling for file staging
- Added --no-color flag for environments that don't support color output
- Enhanced progress indicators with file staging progress bar
- Improved cross-platform path handling with better slash normalization
- Increased default timeout from 30 to 60 seconds for more reliable operation with large repositories

## 0.2.0 (2025-04-25)
- Major enhancement to component detection for modern tech stacks and architectures
- Added support for monorepo structures with package-specific commit grouping
- Expanded commit type taxonomy with 8 new conventional commit types
- Improved commit message formatting to follow GitHub best practices
- Enhanced non-AI commit generation with more intelligent grouping
- Added sophisticated tech stack detection for 30+ frameworks and libraries
- Updated formatter detection to recognize more linting tools
- Implemented smarter naming for commits with descriptive prefixes
- Improved frontend and backend framework component detection
- Made default timeout configurable through the codebase with a central constant
- Better resource utilization with improved CPU and memory detection
- Fixed cross-platform issues with filenames containing spaces and special characters
- Enhanced Git status parsing using null-terminated output for better handling of complex filenames
- Improved path handling with normalized separators for Windows/Unix compatibility
- Added more robust error handling for Git command failures
- Enhanced logging with detailed filename debugging information
- Added failover mechanism for path normalization when staging files fails
- Implemented strict 50-character limit for commit title lines to comply with GitHub best practices

## 0.1.9 (2025-04-25)
- Increased default timeout from 10 to 30 seconds to avoid frequent timeouts with larger models
- Fixed issue with truncated filenames when staging files for commit
- Improved error handling for file staging operations with better error messages
- Enhanced git configuration validation with user-friendly messaging
- Added parameter descriptions with defaults in help text

## 0.1.8 (2025-04-25)
- Improved CLI interface with enhanced progress indicators and loading spinners
- Added automatic download of recommended model if no models are available
- Enhanced model selection UI with model size indicators and recommendations
- Implemented intelligent warm-up for models with realistic prompts
- Added resource-awareness to adapt batch processing based on system capabilities
- Improved parallel processing with automatic fallback for low-resource systems
- Added detailed statistics about system resources during startup
- Fixed spinner display during user interaction for better UX
- Added more informative feedback during model initialization and processing
- Added donation links and sponsor information throughout the application
- Added --version flag to display version and project information
- Optimized memory usage for large repositories with change batching

## 0.1.7 (2025-04-25)
- Enhanced pre-commit hook detection with automatic retry on failure
- Added automatic hook skipping in non-interactive mode for repositories with pre-commit issues
- Added proper success/failure tracking across multiple commit attempts

## 0.1.6 (2025-04-25)
- Improved error handling for git repositories and file paths
- Added detection and proper handling when running from subdirectories
- Added clear, user-friendly error messages with actionable instructions
- Added --verbose flag for detailed debugging information
- Added verification of git configuration before committing
- Added checks to prevent incomplete staging and failed commits
- Added detection and handling of pre-commit hooks with --skip-hooks option
- Added automatic fixes for "No module named pre_commit" errors
- Added automatic revert system to clean up staged changes on error or interruption
- Expanded troubleshooting documentation with common error solutions
- Added relative path resolution to prevent path duplication issues

## 0.1.5 (2025-04-25)
- Fixed issue with file paths when running from subdirectories
- Fixed commit message file path handling in git repositories
- Added timeout parameter for better control of network operations
- Improved error handling for network and connection issues
- Enhanced Test Coverage with clear instructions of usage

## 0.1.4 (2025-04-25)
- UnicodeDecodeError fixed

## 0.1.3 (2025-04-23)
- Fix several issues related to ollama

## 0.1.2 (2025-04-23)
- Update meta data

## 0.1.1 (2025-04-23)
- Fixed bug in component detection for subdirectories
- Improved error handling for Ollama connection issues

## 0.1.0 (2025-04-23)
- Initial release