window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "__init__", "modulename": "__init__", "kind": "module", "doc": "<h1 class=\"modulename\">\nSmartInspect Python3 Library\n</h1>\n\n<h1 id=\"overview\">Overview</h1>\n\n<p>This API provides Python code execution tracing and diagnostics support via the SmartInspect library.\nMore information on SmartInspect can be found here: <a href=\"https://code-partners.com/offerings/smartinspect/\" target=\"_blank\"><a href=\"https://code-partners.com/offerings/smartinspect/\">https://code-partners.com/offerings/smartinspect/</a></a></p>\n\n<p>Warning: Enabling diagnostics tracing could significantly impact application performance, depending on the logging level.\nFor example, a DEBUG logging level will generate a significant amount of trace data compared to an ERROR logging level.</p>\n\n<p>Diagnostic data can be captured in various ways: Real-Time Console, File, Memory, or Text.  Diagnostic data is buffered in a message list, and sent by a separate worker thread.  This approach ensures that performance impact of the diagnosed application is minimal while diagnostics are enabled.</p>\n\n<p>Diagnostics tracing options can be set via an application configuration settings file.</p>\n\n<p>The Real-Time Console method of sending diagnostic data is the ideal way to diagnose applications that utilize services, such as ASP.NET or Windows Services.  For real-time monitoring, diagnostics trace data is sent from your application to the SmartInspect Console viewer over the TCP/IP network.  The SmartInspect Console can be started on the same machine where your application is running, or on a different machine that is accessible via the TCP/IP network.</p>\n\n<h1 id=\"documentation\">Documentation</h1>\n\n<ul>\n<li>Documentation is located in the package library under the 'docs' folder; use the index.html as your starting point. </li>\n</ul>\n\n<h1 id=\"requirements\">Requirements</h1>\n\n<ul>\n<li>Python 3.4 or greater (not tested with Python 2).</li>\n<li>pycryptodome package - used for log file encryption support.</li>\n<li>pywin32 package - for named-pipe support (Windows platform only - use <code>pip install pywin32</code> to install manually).</li>\n</ul>\n\n<h1 id=\"dependencies\">Dependencies</h1>\n\n<ul>\n<li><p>SmartInspect Redistributable Console, Version 3.3+.</p>\n\n<p>The Console Viewer is required to view SmartInspect Log (.sil) formatted files, as well capture packets via the SITcpProtocol or SIPipeProtocol connections. \nThe Console Viewer (aka Redistributable Console) can be downloaded here: <a href=\"https://code-partners.com/offerings/smartinspect/releases/\" target=\"_blank\"><a href=\"https://code-partners.com/offerings/smartinspect/releases/\">https://code-partners.com/offerings/smartinspect/releases/</a></a></p></li>\n</ul>\n\n<h1 id=\"quick-start-sample-code\">Quick-Start Sample Code</h1>\n\n<p>The following code snippets will get you started with establishing a connection to a logging Console or file.\nPlease refer to the <code>smartinspectpython.sisession.SISession</code> class for all of the various \"Logx\" methods to log data.</p>\n\n<p><em>Example 1 - Logging via tcp to a running SmartInspect Console on localhost</em></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># our package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=localhost,port=4228,timeout=5000)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>    <span class=\"c1\"># enable logging</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Level</span> <span class=\"o\">=</span> <span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span>   <span class=\"c1\"># set Message level logging</span>\n\n<span class=\"c1\"># log some test messages.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogSystem</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span><span class=\"p\">,</span> <span class=\"s2\">&quot;System Information on application startup&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World has started&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p><br/></p>\n\n<p><em>Example 2 - Logging to rotating hourly log files in SmartInspect Console format</em></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># our package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"c1\"># this will keep 24 log files, that rotate every hour.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">.</span><span class=\"se\">\\\\</span><span class=\"s2\">logfiles</span><span class=\"se\">\\\\</span><span class=\"s2\">AppLog.sil</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, rotate=hourly, maxparts=24, append=true)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>    <span class=\"c1\"># enable logging</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Level</span> <span class=\"o\">=</span> <span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span>   <span class=\"c1\"># set Message level logging</span>\n\n<span class=\"c1\"># log some test messages.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogSystem</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span><span class=\"p\">,</span> <span class=\"s2\">&quot;System Information on application startup&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World has started&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p><br/></p>\n\n<p><em>Example 3 - Logging to rotating hourly log files in Plain Text format</em></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># our package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"c1\"># this will keep 24 log files, that rotate every hour.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">.</span><span class=\"se\">\\\\</span><span class=\"s2\">logfiles</span><span class=\"se\">\\\\</span><span class=\"s2\">AppLog.txt</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, rotate=hourly, maxparts=24, append=true)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>    <span class=\"c1\"># enable logging</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Level</span> <span class=\"o\">=</span> <span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span>   <span class=\"c1\"># set Message level logging</span>\n\n<span class=\"c1\"># log some test messages.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogSystem</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span><span class=\"p\">,</span> <span class=\"s2\">&quot;System Information on application startup&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World has started&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h1 id=\"licensing\">Licensing</h1>\n\n<p>This project is licensed under the terms of the MIT End-User License Agreement (EULA) license.</p>\n\n<hr />\n\n<p><details>\n  <summary>View Change Log</summary></p>\n\n<h1 id=\"change-log\">Change Log</h1>\n\n<p>All notable changes to this project are listed here.\nDetailed changes are listed in the module where the change was made.</p>\n\n<p>Change are listed in reverse chronological order (newest to oldest).</p>\n\n<p><span class=\"changelog\"></p>\n\n<h6 id=\"3023-20231015\">[ 3.0.23 ] - 2023/10/15</h6>\n\n<ul>\n<li>Changed SIPacket methods GetThreadId and GetProcessId to verify the returned size of their values do not exceed 32-bits.  Prior to this fix, the console viewer would report a value of zero if the values exceeded 32-bits in length.  Python frequently returns thread id's larger than 32-bits on most operating systems.  Although the value is incorrect, it is better than a zero value.  The only way to truly fix this is to expand the thread id and process id sizes in the console viewer; until then, this is the best we can do.</li>\n</ul>\n\n<h6 id=\"3022-20230929\">[ 3.0.22 ] - 2023/09/29</h6>\n\n<ul>\n<li>Set Logger.propagate = False so that our exception capture process does not forward the message on to other loggers.</li>\n<li>Changed methods in SISession that support SystemLogger functionality to allow bypass of logging to the system logger.</li>\n<li>Updated documentation sample code and examples.</li>\n</ul>\n\n<h6 id=\"3021-20230927\">[ 3.0.21 ] - 2023/09/27</h6>\n\n<ul>\n<li>Added SystemLogger functionality to allow logging to system logs.</li>\n<li>Changed SIColors class initialiation method to accept either an integer or SIColors enum for value argument.</li>\n<li>Updated documentation sample code and examples.</li>\n</ul>\n\n<h6 id=\"3020-20230903\">[ 3.0.20 ] - 2023/09/03</h6>\n\n<ul>\n<li>Changed alpha byte from 0xFF to 0x00 for all color definitions in the SIColors enum class.</li>\n<li>Changed all Session.LogX method signatures to use the SIColors enum type, or an integer value in ARGB format.</li>\n<li>Updated internal build processes to use Python Virtual Environment.</li>\n</ul>\n\n<h6 id=\"3019-20230901\">[ 3.0.19 ] - 2023/09/01</h6>\n\n<ul>\n<li>Minor internal naming changes to functions in various modules to conform to Python best-practice naming standards (e.g. use single underscore instead of double underscore for internal methods).</li>\n</ul>\n\n<h6 id=\"3018-20230831\">[ 3.0.18 ] - 2023/08/31</h6>\n\n<ul>\n<li>Major changes to the package!  All classes were renamed to start with an \"SI\" prefix, to avoid naming conflicts with other namespaces.  </li>\n<li>Renamed the KnownColorValues class to SIColors.  </li>\n<li>I was hesitant to do this, as it will cause breaking changes to applications that utilize the package.  It was required though, to avoid namespace conflicts with like-named modules in system / other packages.</li>\n</ul>\n\n<h6 id=\"3017-20230711\">[ 3.0.17 ] - 2023/07/11</h6>\n\n<ul>\n<li>Minor internal only changes to build process.</li>\n</ul>\n\n<h6 id=\"3016-20230711\">[ 3.0.16 ] - 2023/07/11</h6>\n\n<ul>\n<li>Changed Session.GetMethodName method to use inspect.stack(0) instead of inspect.stack() to improve performace.</li>\n</ul>\n\n<h6 id=\"3015-20230630\">[ 3.0.15 ] - 2023/06/30</h6>\n\n<ul>\n<li>Changed 'Development Status' to '5 - Production/Stable', and uploaded to Pypi.org site.</li>\n</ul>\n\n<h6 id=\"3014-20230628\">[ 3.0.14 ] - 2023/06/28</h6>\n\n<ul>\n<li>Changed Session class to use temporary logger to capture exception details in LogException method.</li>\n</ul>\n\n<h6 id=\"3013-20230623\">[ 3.0.13 ] - 2023/06/23</h6>\n\n<ul>\n<li>Changed Session LogAssigned method to properly format the LogMessage title value.</li>\n</ul>\n\n<h6 id=\"3012-20230617\">[ 3.0.12 ] - 2023/06/17</h6>\n\n<ul>\n<li>Changed Session.EnterMethod, LeaveMethod to include source file.</li>\n<li>Added default title to Session.LogAppDomain method.</li>\n<li>Added exception handling in Session.LogSystem for user name value.  It was failing on Windows WSL systems, returning some sort of permissions error.</li>\n</ul>\n\n<h6 id=\"3011-20230617\">[ 3.0.11 ] - 2023/06/17</h6>\n\n<ul>\n<li>Added *args support to Session class methods: LogDebug, LogVerbose, LogMessage, LogWarning, LogException, and LogFatal methods.</li>\n</ul>\n\n<h6 id=\"3010-20230615\">[ 3.0.10 ] - 2023/06/15</h6>\n\n<ul>\n<li>Added Session.LogPngFile, LogPngStream methods for SI Console 3.4+ support.</li>\n</ul>\n\n<h6 id=\"309-20230615\">[ 3.0.9 ] - 2023/06/15</h6>\n\n<ul>\n<li>Changed the Session.CurrentMethodName, CurrentMethodNameClass, CurrentMethodNameClassNamespace properties to static methods.</li>\n</ul>\n\n<h6 id=\"308-20230609\">[ 3.0.8 ] - 2023/06/09</h6>\n\n<ul>\n<li>Added InfoEvent event and RaiseInfoEvent methods to SmartInspect and Protocol classes.  This allows SmartInspect to convey informational events to interested parties.  For example, the SI Console Server banner is available, as well as when a SIConfiguration settings file is changed and reloaded if using SIConfigurationTimer class.</li>\n</ul>\n\n<h6 id=\"307-20230605\">[ 3.0.7 ] - 2023/06/05</h6>\n\n<ul>\n<li>Documentation updates.</li>\n</ul>\n\n<h6 id=\"306-20230602\">[ 3.0.6 ] - 2023/06/02</h6>\n\n<ul>\n<li>Documentation updates.</li>\n</ul>\n\n<h6 id=\"305-20230601\">[ 3.0.5 ] - 2023/06/01</h6>\n\n<ul>\n<li>Fixed an issue with Session.GetMethod() not returning a method name.</li>\n</ul>\n\n<h6 id=\"304-20230531\">[ 3.0.4 ] - 2023/05/31</h6>\n\n<ul>\n<li>Fixed an error related to using the \"pack()\" method that was not using the endian format characters (e.g. &lt; &gt;).\nThis was causing packet sizes to be off on non-Windows platforms.</li>\n</ul>\n\n<h6 id=\"302-20230531\">[ 3.0.2 ] - 2023/05/31</h6>\n\n<ul>\n<li>Added conditional import of pipeprotocol module, as named-pipes are only supported on the Windows platform.  This was causing module not found error when trying to execute on non-Windows platforms.</li>\n</ul>\n\n<h6 id=\"300-20230530\">[ 3.0.0 ] - 2023/05/30</h6>\n\n<ul>\n<li>Version 3 initial release, ported to Python from the SmartInspect for .Net framework.</li>\n</ul>\n\n<p></span>\n</details></p>\n"}, {"fullname": "smartinspectpython.siargumentnullexception", "modulename": "smartinspectpython.siargumentnullexception", "kind": "module", "doc": "<p>Module: siargumentnullexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siargumentnullexception.SIArgumentNullException", "modulename": "smartinspectpython.siargumentnullexception", "qualname": "SIArgumentNullException", "kind": "class", "doc": "<p>The exception that is thrown when a null reference is passed to a method that does not accept it as a valid argument.</p>\n", "bases": "builtins.Exception"}, {"fullname": "smartinspectpython.siargumentnullexception.SIArgumentNullException.__init__", "modulename": "smartinspectpython.siargumentnullexception", "qualname": "SIArgumentNullException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class with the name of the parameter that causes this exception.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">paramName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, {"fullname": "smartinspectpython.siargumentnullexception.SIArgumentNullException.Message", "modulename": "smartinspectpython.siargumentnullexception", "qualname": "SIArgumentNullException.Message", "kind": "variable", "doc": "<p>Gets the error message and the parameter name, or only the error message if no parameter name is set.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siargumentnullexception.SIArgumentNullException.paramName", "modulename": "smartinspectpython.siargumentnullexception", "qualname": "SIArgumentNullException.paramName", "kind": "variable", "doc": "<p>Gets the name of the parameter that causes this exception.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siargumentoutofrangeexception", "modulename": "smartinspectpython.siargumentoutofrangeexception", "kind": "module", "doc": "<p>Module: siargumentoutofrangeexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siargumentoutofrangeexception.SIArgumentOutOfRangeException", "modulename": "smartinspectpython.siargumentoutofrangeexception", "qualname": "SIArgumentOutOfRangeException", "kind": "class", "doc": "<p>The exception that is thrown when the value of an argument is outside the \nallowable range of values as defined by the invoked method.</p>\n", "bases": "builtins.Exception"}, {"fullname": "smartinspectpython.siargumentoutofrangeexception.SIArgumentOutOfRangeException.__init__", "modulename": "smartinspectpython.siargumentoutofrangeexception", "qualname": "SIArgumentOutOfRangeException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class with the name of the parameter that causes this exception.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">paramName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, {"fullname": "smartinspectpython.siargumentoutofrangeexception.SIArgumentOutOfRangeException.Message", "modulename": "smartinspectpython.siargumentoutofrangeexception", "qualname": "SIArgumentOutOfRangeException.Message", "kind": "variable", "doc": "<p>Gets the error message and the parameter name, or only the error message if no parameter name is set.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siargumentoutofrangeexception.SIArgumentOutOfRangeException.paramName", "modulename": "smartinspectpython.siargumentoutofrangeexception", "qualname": "SIArgumentOutOfRangeException.paramName", "kind": "variable", "doc": "<p>Gets the name of the parameter that causes this exception.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siauto", "modulename": "smartinspectpython.siauto", "kind": "module", "doc": "<p>Module: siauto.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n\n<p>Provides automatically created objects for using SmartInspect Python logging.  </p>\n\n<p>The following classes are imported when <code>from smartinspectpython.siauto import *</code> is specified:  </p>\n\n<ul>\n<li>SIArgumentNullException</li>\n<li>SIArgumentOutOfRangeException</li>\n<li>SIAuto</li>\n<li>SIColors</li>\n<li>SIConfigurationTimer</li>\n<li>SIControlCommandEventArgs</li>\n<li>SIErrorEventArgs</li>\n<li>SIFilterEventArgs</li>\n<li>SIInfoEventArgs</li>\n<li>SILevel</li>\n<li>SILogEntryEventArgs</li>\n<li>SIProcessFlowEventArgs</li>\n<li>SISession</li>\n<li>SIWatchEventArgs</li>\n<li>SmartInspectException</li>\n</ul>\n"}, {"fullname": "smartinspectpython.siauto.SIAuto", "modulename": "smartinspectpython.siauto", "qualname": "SIAuto", "kind": "class", "doc": "<p>Provides automatically created objects for using the SmartInspect and SISession classes.</p>\n\n<p>This class provides a static property called Si of type SmartInspect.\nFurthermore a SISession instance named Main with Si as parent is ready to use. The siauto module \nis especially useful if you do not want to create SmartInspect and SISession instances by yourself.</p>\n\n<p>The SmartInspect.Connections property of Si is set to \"tcp(host=localhost)\", the\nSmartInspect.AppName property to \"Auto\" and the SISession.Name property to \"Main\".</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public static members of this class are thread-safe.</p>\n</blockquote>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\">#############################################################################</span>\n<span class=\"c1\"># Use the following for 1-time initialization code:</span>\n<span class=\"c1\">#############################################################################</span>\n\n<span class=\"c1\"># load SmartInspect settings from a configuration settings file.</span>\n<span class=\"n\">siConfigPath</span><span class=\"p\">:</span><span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;./smartinspect.cfg&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">LoadConfiguration</span><span class=\"p\">(</span><span class=\"n\">siConfigPath</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># start monitoring the configuration file for changes, and reload it when it changes.</span>\n<span class=\"c1\"># this will check the file for changes every 60 seconds.</span>\n<span class=\"n\">siConfigTask</span><span class=\"p\">:</span><span class=\"n\">SIConfigurationTimer</span> <span class=\"o\">=</span> <span class=\"n\">SIConfigurationTimer</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">,</span> <span class=\"n\">siConfigPath</span><span class=\"p\">,</span> <span class=\"mi\">60</span><span class=\"p\">)</span>\n\n<span class=\"c1\">#############################################################################</span>\n<span class=\"c1\"># Use the following in main (or classes) in your project:</span>\n<span class=\"c1\">#############################################################################</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># log some messages and data.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogSystem</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a Debug message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a Message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;You have been warned!&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;Danger Will Robinson!&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p><br/>\nThe following is the configuration settings file contents:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\">; smartinspect.cfg</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration General settings.</span>\n<span class=\"c1\">; - &quot;Enabled&quot; parameter to turn logging on (True) or off (False).</span>\n<span class=\"c1\">; - &quot;Level&quot; parameter to control the logging level (Debug|Verbose|Message|Warning|Error).</span>\n<span class=\"c1\">; - &quot;AppName&quot; parameter to control the application name.</span>\n<span class=\"na\">Enabled</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">False</span><span class=\"w\"> </span>\n<span class=\"na\">Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Verbose</span>\n<span class=\"na\">DefaultLevel</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Debug</span>\n<span class=\"na\">AppName</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">My Application Name</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration Output settings.</span>\n<span class=\"c1\">; - Log to SmartInspect Console Viewer running on the specified network address.</span>\n<span class=\"na\">Connections</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">tcp(host=localhost, port=4228, timeout=5000, reconnect=true, reconnect.interval=10s, async.enabled=true)</span>\n<span class=\"c1\">; - Log to a file:</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfile.log\\&quot;, rotate=hourly, maxparts=24, append=true)&quot;</span>\n<span class=\"c1\">; - Log to an encrypted file:</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfileEncrypted.sil\\&quot;, encrypt=true, key=&quot;&quot;1234567890123456&quot;&quot;, rotate=hourly, maxparts=14, append=true)&quot;</span>\n\n<span class=\"c1\">; set defaults for new sessions</span>\n<span class=\"c1\">; note that session defaults do not apply to the SIAuto.Main session, since</span>\n<span class=\"c1\">; this session was already added before a configuration file can be loaded. </span>\n<span class=\"c1\">; session defaults only apply to newly added sessions and do not affect existing sessions.</span>\n<span class=\"na\">SessionDefaults.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">SessionDefaults.Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Message</span>\n<span class=\"na\">SessionDefaults.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n\n<span class=\"c1\">; configure some individual session properties.</span>\n<span class=\"c1\">; note that this does not add the session to the sessionmanager; it simply</span>\n<span class=\"c1\">; sets the property values IF the session name already exists.</span>\n<span class=\"na\">Session.Main.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">Session.Main.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n</code></pre>\n</div>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siauto.SIAuto.Si", "modulename": "smartinspectpython.siauto", "qualname": "SIAuto.Si", "kind": "variable", "doc": "<p>SmartInspect logging instance (automatically created).</p>\n", "annotation": ": smartinspectpython.smartinspect.SmartInspect", "default_value": "&lt;smartinspectpython.smartinspect.SmartInspect object&gt;"}, {"fullname": "smartinspectpython.siauto.SIAuto.Main", "modulename": "smartinspectpython.siauto", "qualname": "SIAuto.Main", "kind": "variable", "doc": "<p>SmartInspect logging Session instance ('Main', automatically created). </p>\n\n<p>The SISession.Name is set to \"Main\" and the SISession.Parent to SIAuto.Si.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># log some messages and data.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogSystem</span><span class=\"p\">(</span><span class=\"n\">SILevel</span><span class=\"o\">.</span><span class=\"n\">Debug</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a Debug message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a Message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;You have been warned!&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;Danger Will Robinson!&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "annotation": ": smartinspectpython.sisession.SISession", "default_value": "&lt;smartinspectpython.sisession.SISession object&gt;"}, {"fullname": "smartinspectpython.siauto.SIAuto.static_init", "modulename": "smartinspectpython.siauto", "qualname": "SIAuto.static_init", "kind": "function", "doc": "<p>Initializes a new static instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinarycontext", "modulename": "smartinspectpython.sibinarycontext", "kind": "module", "doc": "<p>Module: sibinarycontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext", "kind": "class", "doc": "<p>This is the base class for all viewer contexts which deal with\nbinary data. A viewer context is the library-side representation\nof a viewer in the Console.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siviewercontext.SIViewerContext"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.__init__", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>vi (SIViewerId):</strong>  The viewer ID to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span></span>)</span>"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.ViewerData", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.ViewerData", "kind": "variable", "doc": "<p>Overridden. Returns the actual binary data which will be\ndisplayed in the viewer specified by the viewer id.</p>\n", "annotation": ": _io.BytesIO"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.AppendBytes", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.AppendBytes", "kind": "function", "doc": "<p>Appends a buffer of data to the stream.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>buffer (bytes):</strong>  The buffer to append.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The buffer argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">buffer</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.AppendBytesWithOffset", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.AppendBytesWithOffset", "kind": "function", "doc": "<p>Appends a buffer of data to the stream, specifying the offset in\nthe buffer and the amount of bytes to append.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>buffer (bytes):</strong>  The buffer to append.</li>\n<li><strong>offset (int):</strong>  The offset at which to begin appending.</li>\n<li><strong>count (int):</strong>  The number of bytes to append.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The buffer argument is null</li>\n<li><strong>ArgumentException:</strong>  The sum of the offset and count parameters is greater than the actual buffer length.</li>\n<li><strong>SIArgumentOutOfRangeException:</strong>  The offset or count parameter is negative.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">buffer</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span>, </span><span class=\"param\"><span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">count</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.Dispose", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.Dispose", "kind": "function", "doc": "<p>Releases any resources.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>disposing (bool):</strong>  True if managed resources should be released and false otherwise.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">disposing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.LoadFromFile", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.LoadFromFile", "kind": "function", "doc": "<p>Loads the binary data from a file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>fileName (str):</strong>  The name of the file to load the binary data from.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The filename argument is null.</li>\n<li><strong>IOException:</strong>  An I/O error occurred.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.LoadFromStream", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.LoadFromStream", "kind": "function", "doc": "<p>Loads the binary data from a stream.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to load the binary data from.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The stream argument is null.</li>\n<li><strong>IOException:</strong>  An I/O error occurred.</li>\n</ul>\n\n<p>If the supplied stream supports seeking then the entire\nstream content will be read and the stream position will be\nrestored correctly. Otherwise the data will be read from the\ncurrent position to the end and the original position can\nnot be restored.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinarycontext.SIBinaryContext.ResetData", "modulename": "smartinspectpython.sibinarycontext", "qualname": "SIBinaryContext.ResetData", "kind": "function", "doc": "<p>Resets the internal data stream.</p>\n\n<p>This method is intended to reset the internal data stream\nif custom handling of data is needed by derived classes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinaryformatter", "modulename": "smartinspectpython.sibinaryformatter", "kind": "module", "doc": "<p>Module: sibinaryformatter.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter", "kind": "class", "doc": "<p>Responsible for formatting and writing a packet in the standard\nSmartInspect binary format.</p>\n\n<p>This class formats and writes a packet in the standard binary\nformat which can be read by the SmartInspect Console. The\nCompile method preprocesses a packet and computes the required\nsize of the packet. The Write method writes the preprocessed\npacket to the supplied stream.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siformatter.SIFormatter"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.__init__", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.MAX_STREAM_CAPACITY", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.MAX_STREAM_CAPACITY", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "10485760"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.MAX_BUFFER_SIZE", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.MAX_BUFFER_SIZE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "8192"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.TICKS_EPOCH", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.TICKS_EPOCH", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "621355968000000000"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.MICROSECONDS_PER_DAY", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.MICROSECONDS_PER_DAY", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "86400000000"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.DAY_OFFSET_DELPHI_DEFAULT", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.DAY_OFFSET_DELPHI_DEFAULT", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "25569"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.Compile", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.Compile", "kind": "function", "doc": "<p>Overridden. Preprocesses (or compiles) a packet and returns the\nrequired size for the compiled result.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to compile.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The size for the compiled result.</p>\n</blockquote>\n\n<p>This method preprocesses the supplied packet and computes the\nrequired binary format size. To write this compiled packet,\ncall the Write method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinaryformatter.SIBinaryFormatter.Write", "modulename": "smartinspectpython.sibinaryformatter", "qualname": "SIBinaryFormatter.Write", "kind": "function", "doc": "<p>Overridden. Writes a previously compiled packet to the supplied stream.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to write the packet to.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>IOException:</strong>  An I/O error occurred while trying to write the compiled packet.</li>\n</ul>\n\n<p>This method writes the previously compiled packet (see Compile)\nto the supplied stream object. If the return value of the\nCompile method was 0, nothing is written.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sibinaryviewercontext", "modulename": "smartinspectpython.sibinaryviewercontext", "kind": "module", "doc": "<p>Module: sibinaryviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sibinaryviewercontext.SIBinaryViewerContext", "modulename": "smartinspectpython.sibinaryviewercontext", "qualname": "SIBinaryViewerContext", "kind": "class", "doc": "<p>Represents the binary viewer in the Console which can display binary\ndata in a read-only hex editor.</p>\n\n<p>The binary viewer in the Console interprets the Log Entry Data\nas binary data and displays it in a read-only hex editor.</p>\n\n<p>You can use the SIBinaryViewerContext class for creating custom log\nmethods around SISession.LogCustomContext(string, SILogEntryType, SIViewerContext)\nfor sending custom binary data.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sibinarycontext.SIBinaryContext"}, {"fullname": "smartinspectpython.sibinaryviewercontext.SIBinaryViewerContext.__init__", "modulename": "smartinspectpython.sibinaryviewercontext", "qualname": "SIBinaryViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class with a Binary SIViewerId value.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sicolor", "modulename": "smartinspectpython.sicolor", "kind": "module", "doc": "<p>Module: sicolor.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Changed initialiation method to accept either an integer or SIColors enum for value argument.</td>\n</tr>\n<tr>\n  <td>2023/09/03</td>\n  <td>3.0.20.0</td>\n  <td>Changed all alpha byte from 0xFF to 0x00 for all color definitions.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sicolor.SIColor", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor", "kind": "class", "doc": "<p>Mimics the System.Drawing.Color class functionality.</p>\n"}, {"fullname": "smartinspectpython.sicolor.SIColor.__init__", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class using a supplied known color value\nthat represents the four ARGB components (alpha, red, green, and blue).</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (int):</strong>  Integer value that represents the ARGB components of the color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span>)</span>"}, {"fullname": "smartinspectpython.sicolor.SIColor.A", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.A", "kind": "variable", "doc": "<p>Gets the alpha component value of this color structure.</p>\n\n<p>0 is fully transparent, and 255 is fully opaque.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicolor.SIColor.B", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.B", "kind": "variable", "doc": "<p>Gets the blue component value of this SIColor structure.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicolor.SIColor.G", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.G", "kind": "variable", "doc": "<p>Gets the green component value of this SIColor structure.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicolor.SIColor.Name", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.Name", "kind": "variable", "doc": "<p>Gets the name of the color, if it's a known color value.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sicolor.SIColor.R", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.R", "kind": "variable", "doc": "<p>Gets the red component value of this SIColor structure.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicolor.SIColor.Value", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.Value", "kind": "variable", "doc": "<p>Gets the raw value of the color in integer form.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicolor.SIColor.ValueHex", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.ValueHex", "kind": "variable", "doc": "<p>Gets the raw value of the color in hexadecimal form.</p>\n\n<p>Returns a string value in the form of 0xAARRBBGG (e.g. 0x00FF0000).</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicolor.SIColor.CheckByte", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.CheckByte", "kind": "function", "doc": "<p>Ensures the value for the named parameter (A,R,G, or B) is between 0 through 255.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (int):</strong>  The value to check.</li>\n<li><strong>name (str):</strong>  The descriptove name of the value, used to identify the value in case of an exception.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicolor.SIColor.FromArgb", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.FromArgb", "kind": "function", "doc": "<p>Creates a SIColor structure from the four ARGB component (alpha, red, green, and blue) values. \nAlthough this method allows a 32-bit value to be passed for each component, the value of each \ncomponent is limited to 8 bits.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>alpha (int):</strong>  The alpha component. Valid values are 0 (fully transparent) through 255 (fully opaque).</li>\n<li><strong>red (int):</strong>  The red component. Valid values are 0 through 255.</li>\n<li><strong>green (int):</strong>  The green component. Valid values are 0 through 255.</li>\n<li><strong>blue (int):</strong>  The blue component. Valid values are 0 through 255.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SIColor that this method creates.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentException:</strong>  alpha, red, green, or blue is less than 0 or greater than 255.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">alpha</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">red</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">green</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">blue</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicolor.SIColor.FromRgb", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.FromRgb", "kind": "function", "doc": "<p>Creates a SIColor structure from the three RGB component (red, green, and blue) values. \nAlthough this method allows a 32-bit value to be passed for each component, the value of each \ncomponent is limited to 8 bits.  The alpha value is implicitly 255 (fully opaque). </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>red (int):</strong>  The red component. Valid values are 0 through 255.</li>\n<li><strong>green (int):</strong>  The green component. Valid values are 0 through 255.</li>\n<li><strong>blue (int):</strong>  The blue component. Valid values are 0 through 255.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SIColor that this method creates.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentException:</strong>  red, green, or blue is less than 0 or greater than 255.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">red</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">green</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">blue</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicolor.SIColor.ToArgb", "modulename": "smartinspectpython.sicolor", "qualname": "SIColor.ToArgb", "kind": "function", "doc": "<p>Gets the 32-bit ARGB value of this color structure.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicolor.SIColors", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors", "kind": "class", "doc": "<p>Pre-defined known color values.</p>\n", "bases": "enum.Enum"}, {"fullname": "smartinspectpython.sicolor.SIColors.AliceBlue", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.AliceBlue", "kind": "variable", "doc": "<p>System-defined color that has an ARGB value of #FFF0F8FF.</p>\n", "default_value": "&lt;SIColors.AliceBlue: 15792383&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.AntiqueWhite", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.AntiqueWhite", "kind": "variable", "doc": "<p><summary>Gets a system-defined color that has an ARGB value of #FFFAEBD7.</p>\n", "default_value": "&lt;SIColors.AntiqueWhite: 16444375&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Coral", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Coral", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFFF7F50.</p>\n", "default_value": "&lt;SIColors.Coral: 16744272&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.CornflowerBlue", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.CornflowerBlue", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF6495ED.</p>\n", "default_value": "&lt;SIColors.CornflowerBlue: 6591981&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.DarkBlue", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.DarkBlue", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF00008B.</p>\n", "default_value": "&lt;SIColors.DarkBlue: 139&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.DarkCyan", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.DarkCyan", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF008B8B.</p>\n", "default_value": "&lt;SIColors.DarkCyan: 35723&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.DarkGray", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.DarkGray", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFA9A9A9.</p>\n", "default_value": "&lt;SIColors.DarkGray: 11119017&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.DarkOrange", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.DarkOrange", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFFF8C00.</p>\n", "default_value": "&lt;SIColors.DarkOrange: 16747520&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.DeepSkyBlue", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.DeepSkyBlue", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF00BFFF.</p>\n", "default_value": "&lt;SIColors.DeepSkyBlue: 49151&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.DimGray", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.DimGray", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF696969.</p>\n", "default_value": "&lt;SIColors.DimGray: 6908265&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.ForestGreen", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.ForestGreen", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #.</p>\n", "default_value": "&lt;SIColors.ForestGreen: 2263842&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Gainsboro", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Gainsboro", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFDCDCDC.</p>\n", "default_value": "&lt;SIColors.Gainsboro: 14474460&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Gold", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Gold", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #.</p>\n", "default_value": "&lt;SIColors.Gold: 16766720&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Green", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Green", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF008000.</p>\n", "default_value": "&lt;SIColors.Green: 32768&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Khaki", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Khaki", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFF0E68C.</p>\n", "default_value": "&lt;SIColors.Khaki: 15787660&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Lavender", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Lavender", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFE6E6FA.</p>\n", "default_value": "&lt;SIColors.Lavender: 15132410&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.LightBlue", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.LightBlue", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFADD8E6.</p>\n", "default_value": "&lt;SIColors.LightBlue: 11393254&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.LightCoral", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.LightCoral", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFF08080.</p>\n", "default_value": "&lt;SIColors.LightCoral: 15761536&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.LightGreen", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.LightGreen", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF90EE90.</p>\n", "default_value": "&lt;SIColors.LightGreen: 9498256&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.LightGray", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.LightGray", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFD3D3D3.</p>\n", "default_value": "&lt;SIColors.LightGray: 13882323&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.LightSkyBlue", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.LightSkyBlue", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF87CEFA.</p>\n", "default_value": "&lt;SIColors.LightSkyBlue: 8900346&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Orange", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Orange", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFFFA500.</p>\n", "default_value": "&lt;SIColors.Orange: 16753920&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Red", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Red", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFFF0000.</p>\n", "default_value": "&lt;SIColors.Red: 16711680&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.SaddleBrown", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.SaddleBrown", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF8B4513.</p>\n", "default_value": "&lt;SIColors.SaddleBrown: 9127187&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.SeaGreen", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.SeaGreen", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF2E8B57.</p>\n", "default_value": "&lt;SIColors.SeaGreen: 3050327&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Silver", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Silver", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFC0C0C0.</p>\n", "default_value": "&lt;SIColors.Silver: 12632256&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.SkyBlue", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.SkyBlue", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF87CEEB.</p>\n", "default_value": "&lt;SIColors.SkyBlue: 8900331&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.SlateGray", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.SlateGray", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FF708090.</p>\n", "default_value": "&lt;SIColors.SlateGray: 7372944&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Tan", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Tan", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFD2B48C.</p>\n", "default_value": "&lt;SIColors.Tan: 13808780&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.White", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.White", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFFFFFFF.</p>\n", "default_value": "&lt;SIColors.White: 16777215&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.WhiteSmoke", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.WhiteSmoke", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFF5F5F5.</p>\n", "default_value": "&lt;SIColors.WhiteSmoke: 16119285&gt;"}, {"fullname": "smartinspectpython.sicolor.SIColors.Yellow", "modulename": "smartinspectpython.sicolor", "qualname": "SIColors.Yellow", "kind": "variable", "doc": "<p>Gets a system-defined color that has an ARGB value of #FFFFFF00.</p>\n", "default_value": "&lt;SIColors.Yellow: 16776960&gt;"}, {"fullname": "smartinspectpython.siconfiguration", "modulename": "smartinspectpython.siconfiguration", "kind": "module", "doc": "<p>Module: siconfiguration.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration", "kind": "class", "doc": "<p>Responsible for handling the SmartInspect configuration and loading\nit from a file.</p>\n\n<p>This class is responsible for loading and reading values from a\nSmartInspect configuration file. For more information, please refer\nto the SmartInspect.LoadConfiguration method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.__init__", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.Count", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.Count", "kind": "variable", "doc": "<p>Returns the number of key/value pairs of this SmartInspect\nconfiguration.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.Contains", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.Contains", "kind": "function", "doc": "<p>Tests if the configuration contains a value for a given key. </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key to test for.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if a value exists for the given key; otherwise, false.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.Clear", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.Clear", "kind": "function", "doc": "<p>Removes all key/value pairs of the configuration.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.LoadFromFile", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.LoadFromFile", "kind": "function", "doc": "<p>Loads the configuration from a file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>fileName (str):</strong>  The name of the file to load the configuration from.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>IOException:</strong>  An I/O error occurred while trying to load the configuration or if the\nspecified file does not exist.</li>\n<li><strong>SIArgumentNullException:</strong>  The fileName argument is null.</li>\n</ul>\n\n<p>This method loads key/value pairs separated with a '='\ncharacter from a file. Empty, unrecognized lines or lines\nbeginning with a ';' character are ignored.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.Parse", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.Parse", "kind": "function", "doc": "<p>Parses a line read from a configuration file, adding the\nfound key and value to the configuration variables table.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pair (str):</strong>  String that contains a KEY=VALUE pair.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">pair</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.ReadBoolean", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.ReadBoolean", "kind": "function", "doc": "<p>Returns a boolean value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (bool):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a bool for the given key if an\n  element with the given key exists or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns a bool value of true if the found value\nof the given key matches either \"true\", \"1\" or \"yes\" and false\notherwise. If the supplied key is unknown, the defaultValue\nargument is returned.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.ReadColor", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.ReadColor", "kind": "function", "doc": "<p>Returns a color value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (SIColor):</strong>  The value to return if the given key is unknown or if the\nfound value has an invalid format.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a SIColor value for the given key\n  if an element with the given key exists and the found value\n  has a valid format or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>The element value must be specified as hexadecimal string.\nTo indicate that the element value represents a hexadecimal\nstring, the element value must begin with \"0x\", \"&amp;H\" or \"$\".\nA '0' nibble is appended if the hexadecimal string has an odd\nlength.</p>\n\n<p>The hexadecimal value must represent a three or four byte\ninteger value. The hexadecimal value is handled as follows.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Bytes</th>\n  <th>Format</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>3</td>\n  <td>RRGGBB</td>\n</tr>\n<tr>\n  <td>4</td>\n  <td>AARRGGBB</td>\n</tr>\n<tr>\n  <td>Other</td>\n  <td>Ignored</td>\n</tr>\n</tbody>\n</table>\n\n<p>A stands for the alpha channel and R, G and B represent the\nred, green and blue channels, respectively. If the value is not\ngiven as hexadecimal value with a length of 6 or 8 characters\nexcluding the hexadecimal prefix identifier or if the value\ndoes not have a valid hexadecimal format, this method returns\ndefaultValue.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColor</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColor</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.ReadInteger", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.ReadInteger", "kind": "function", "doc": "<p>Returns a integer value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (bool):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to an int for the given key if an\n  element with the given key exists and the found value is a\n  valid int or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid int.\nOnly non-negative int values are recognized as valid.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.ReadKey", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.ReadKey", "kind": "function", "doc": "<p>Returns a key of this SmartInspect configuration for a\ngiven index.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>index (int):</strong>  The index in this SmartInspect configuration.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A key of this SmartInspect configuration for the given index.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentOutOfRangeException:</strong>  The index argument is not a valid index of this SmartInspect configuration.</li>\n</ul>\n\n<p>To find out the total number of key/value pairs in this\nSmartInspect configuration, use Count. To get the value for\na given key, use ReadString.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.ReadLevel", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.ReadLevel", "kind": "function", "doc": "<p>Returns a SILevel value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (SILevel):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to the corresponding SILevel value for\n  the given key if an element with the given key exists and the\n  found value is a valid SILevel value or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid SILevel\nvalue. Please see the SILevel enum for more information on the\navailable values.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfiguration.SIConfiguration.ReadString", "modulename": "smartinspectpython.siconfiguration", "qualname": "SIConfiguration.ReadString", "kind": "function", "doc": "<p>Returns a string value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (str):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value for a given key if an element with the \n  given key exists or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfigurationtimer", "modulename": "smartinspectpython.siconfigurationtimer", "kind": "module", "doc": "<p>Module: siconfigurationtimer.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/06/09</td>\n  <td>3.0.8.0</td>\n  <td>Added call to RaiseInfoEvent for when a configuration settings file is changed and reloaded.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siconfigurationtimer.SIConfigurationTimer", "modulename": "smartinspectpython.siconfigurationtimer", "qualname": "SIConfigurationTimer", "kind": "class", "doc": "<p>Monitors a SmartInspect configuration settings file for changes\nand reloads the configuration when it does.</p>\n\n<p>Use this class to monitor and automatically reload SmartInspect\nconfiguration files.  This class periodically checks if the\nrelated configuration file has changed (by comparing the last\nmodified datetime) and automatically tries to reload the configuration\nproperties. You can pass the SmartInspect object to configure,\nthe path of the configuration file to monitor, and the interval\nin which the path should check for changes.</p>\n\n<p>For information about SmartInspect configuration files, please\nrefer to the documentation of the SmartInspect.LoadConfiguration\nmethod.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># load SmartInspect settings from a configuration settings file.</span>\n<span class=\"n\">siConfigPath</span><span class=\"p\">:</span><span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;./smartinspect.cfg&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">LoadConfiguration</span><span class=\"p\">(</span><span class=\"n\">siConfigPath</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># start monitoring the configuration file for changes, and reload it when it changes.</span>\n<span class=\"c1\"># this will check the file for changes every 60 seconds.</span>\n<span class=\"n\">siConfigTask</span><span class=\"p\">:</span><span class=\"n\">SIConfigurationTimer</span> <span class=\"o\">=</span> <span class=\"n\">SIConfigurationTimer</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">,</span> <span class=\"n\">siConfigPath</span><span class=\"p\">,</span> <span class=\"mi\">60</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n</code></pre>\n</div>\n\n<p><br/>\nThe following is the configuration settings file contents:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\">; smartinspect.cfg</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration General settings.</span>\n<span class=\"c1\">; - &quot;Enabled&quot; parameter to turn logging on (True) or off (False).</span>\n<span class=\"c1\">; - &quot;Level&quot; parameter to control the logging level (Debug|Verbose|Message|Warning|Error).</span>\n<span class=\"c1\">; - &quot;AppName&quot; parameter to control the application name.</span>\n<span class=\"na\">Enabled</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">False</span><span class=\"w\"> </span>\n<span class=\"na\">Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Verbose</span>\n<span class=\"na\">DefaultLevel</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Debug</span>\n<span class=\"na\">AppName</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">My Application Name</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration Output settings.</span>\n<span class=\"c1\">; - Log to SmartInspect Console Viewer running on the specified network address.</span>\n<span class=\"na\">Connections</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">tcp(host=localhost, port=4228, timeout=5000, reconnect=true, reconnect.interval=10s, async.enabled=true)</span>\n<span class=\"c1\">; - Log to a file:</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfile.log\\&quot;, rotate=hourly, maxparts=24, append=true)&quot;</span>\n<span class=\"c1\">; - Log to an encrypted file:</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfileEncrypted.sil\\&quot;, encrypt=true, key=&quot;&quot;1234567890123456&quot;&quot;, rotate=hourly, maxparts=14, append=true)&quot;</span>\n\n<span class=\"c1\">; set defaults for new sessions</span>\n<span class=\"c1\">; note that session defaults do not apply to the SIAuto.Main session, since</span>\n<span class=\"c1\">; this session was already added before a configuration file can be loaded. </span>\n<span class=\"c1\">; session defaults only apply to newly added sessions and do not affect existing sessions.</span>\n<span class=\"na\">SessionDefaults.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">SessionDefaults.Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Message</span>\n<span class=\"na\">SessionDefaults.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n\n<span class=\"c1\">; configure some individual session properties.</span>\n<span class=\"c1\">; note that this does not add the session to the sessionmanager; it simply</span>\n<span class=\"c1\">; sets the property values IF the session name already exists.</span>\n<span class=\"na\">Session.Main.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">Session.Main.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n</code></pre>\n</div>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siconfigurationtimer.SIConfigurationTimer.__init__", "modulename": "smartinspectpython.siconfigurationtimer", "qualname": "SIConfigurationTimer.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>smartInspect (SmartInspect):</strong>  The SmartInspect object to configure.</li>\n<li><strong>fileName (str):</strong>  The path of the configuration file to monitor.</li>\n<li><strong>interval (int):</strong>  The interval (in seconds) in which this timer should check for changes\nto the configuration file.\nDefault value is 60 (seconds).</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The smartInspect or fileName parameter is null.</li>\n<li><strong>ArgumentError:</strong>  The interval parameter is less than 1 or greater than 300 (seconds).</li>\n</ul>\n\n<p>The monitoring of the file begins immediately.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">smartInspect</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">smartinspect</span><span class=\"o\">.</span><span class=\"n\">SmartInspect</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">interval</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">60</span></span>)</span>"}, {"fullname": "smartinspectpython.siconfigurationtimer.SIConfigurationTimer.Start", "modulename": "smartinspectpython.siconfigurationtimer", "qualname": "SIConfigurationTimer.Start", "kind": "function", "doc": "<p>Starts monitoring the configuration file for changes.</p>\n\n<p>This method is called automatically when a new instance of the class \nis created.  It can also be called after issuing a \"Stop\" method\ncall, to restart monitoring of the configuration file.</p>\n\n<p>It will start a new thread named \"SiConfigFileMonitorTask\" that will\nmonitor a specified configuration file for changes at a selected\ninterval, and reload the configuration automatically.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconfigurationtimer.SIConfigurationTimer.Stop", "modulename": "smartinspectpython.siconfigurationtimer", "qualname": "SIConfigurationTimer.Stop", "kind": "function", "doc": "<p>Stops monitoring the configuration file for changes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionfoundeventargs", "modulename": "smartinspectpython.siconnectionfoundeventargs", "kind": "module", "doc": "<p>Module: siconnectionfoundeventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siconnectionfoundeventargs.SIConnectionFoundEventArgs", "modulename": "smartinspectpython.siconnectionfoundeventargs", "qualname": "SIConnectionFoundEventArgs", "kind": "class", "doc": "<p>This class is used by the SIConnectionsParser class to inform interested parties \nthat a protocol connection string has been found.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siconnectionfoundeventargs.SIConnectionFoundEventArgs.__init__", "modulename": "smartinspectpython.siconnectionfoundeventargs", "qualname": "SIConnectionFoundEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>protocol (str):</strong>  The protocol name which has been found.</li>\n<li><strong>options (str):</strong>  The options of the new protocol.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">protocol</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">options</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, {"fullname": "smartinspectpython.siconnectionfoundeventargs.SIConnectionFoundEventArgs.Options", "modulename": "smartinspectpython.siconnectionfoundeventargs", "qualname": "SIConnectionFoundEventArgs.Options", "kind": "variable", "doc": "<p>This read-only property returns the key of the option which\nhas just been found by a SIConnectionsParser object.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siconnectionfoundeventargs.SIConnectionFoundEventArgs.Protocol", "modulename": "smartinspectpython.siconnectionfoundeventargs", "qualname": "SIConnectionFoundEventArgs.Protocol", "kind": "variable", "doc": "<p>This read-only property returns the protocol which has just\nbeen found by a SIConnectionsParser object.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siconnectionfoundeventargs.SIConnectionFoundEventHandler", "modulename": "smartinspectpython.siconnectionfoundeventargs", "qualname": "SIConnectionFoundEventHandler", "kind": "class", "doc": "<p>This is the callback type for the SIConnectionsParser.Parse method.</p>\n"}, {"fullname": "smartinspectpython.siconnectionfoundeventargs.SIConnectionFoundEventHandler.__init__", "modulename": "smartinspectpython.siconnectionfoundeventargs", "qualname": "SIConnectionFoundEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (ConnectionFoundEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconnectionfoundeventargs</span><span class=\"o\">.</span><span class=\"n\">SIConnectionFoundEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.siconnectionsbuilder", "modulename": "smartinspectpython.siconnectionsbuilder", "kind": "module", "doc": "<p>Module: siconnectionsbuilder.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder", "kind": "class", "doc": "<p>Assists in building a SmartInspect connections string.</p>\n\n<p>This class assists in creating connections strings as used by the \nSmartInspect.Connections property. For general information about \nconnections strings, please refer to the SmartInspect.Connections property.</p>\n"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.__init__", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.Connections", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.Connections", "kind": "variable", "doc": "<p>Get the Connections property value.</p>\n\n<p>This read-only property returns the connections string which\nhas previously been built with the BeginProtocol, AddOption\nand EndProtocol methods.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.AddOptionBool", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.AddOptionBool", "kind": "function", "doc": "<p>Adds a new boolean option to the current protocol section.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  Option key name to add.</li>\n<li><strong>value (bool):</strong>  Option key boolean value to add.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.AddOptionFileRotate", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.AddOptionFileRotate", "kind": "function", "doc": "<p>Adds a new file rotate option to the current protocol section.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  Option key name to add.</li>\n<li><strong>value (SIFileRotate):</strong>  Option key SIFileRotate value to add.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sifilerotate</span><span class=\"o\">.</span><span class=\"n\">SIFileRotate</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.AddOptionInteger", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.AddOptionInteger", "kind": "function", "doc": "<p>Adds a new integer option to the current protocol section.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  Option key name to add.</li>\n<li><strong>value (int):</strong>  Option key integer value to add.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.AddOptionLevel", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.AddOptionLevel", "kind": "function", "doc": "<p>Adds a new level option to the current protocol section.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  Option key name to add.</li>\n<li><strong>value (SILevel):</strong>  Option key Level value to add.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.AddOptionString", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.AddOptionString", "kind": "function", "doc": "<p>Adds a new string option to the current protocol section.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  Option key name to add.</li>\n<li><strong>value (str):</strong>  Option key string value to add.</li>\n</ul>\n\n<p>This method adds a new string option to the current protocol\nsection. The supplied value argument is properly escaped if\nnecessary.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.BeginProtocol", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.BeginProtocol", "kind": "function", "doc": "<p>Begins a new protocol section.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>protocolName (str):</strong>  The protocol name (e.g. file, text, tcp, etc).</li>\n</ul>\n\n<p>This method begins a new protocol with the supplied name.\nAll subsequent protocol options are added to this protocol\nuntil the new protocol section is closed by calling the\nEndProtocol method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">protocolName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.Clear", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.Clear", "kind": "function", "doc": "<p>Clears this instance by removing all protocols and their options.</p>\n\n<p>After this method has been called, the Connections property\nreturns an empty string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.EndProtocol", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.EndProtocol", "kind": "function", "doc": "<p>Ends the current protocol section.\nThis method ends the current protocol. To begin a new protocol\nsection, use the BeginProtocol method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsbuilder.SIConnectionsBuilder.Escape", "modulename": "smartinspectpython.siconnectionsbuilder", "qualname": "SIConnectionsBuilder.Escape", "kind": "function", "doc": "<p>Replaces any backslash characters in the value with double-backslash characters.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The value to escape.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The escaped value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconnectionsparser", "modulename": "smartinspectpython.siconnectionsparser", "kind": "module", "doc": "<p>Module: siconnectionsparser.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siconnectionsparser.SIConnectionsParser", "modulename": "smartinspectpython.siconnectionsparser", "qualname": "SIConnectionsParser", "kind": "class", "doc": "<p>Responsible for parsing a SmartInspect connections string.</p>\n\n<p>This class offers a single method only, called Parse, which is\nresponsible for parsing a connections string. This method informs\nthe caller about found protocols and connections by raising the\nConnectionFoundEvent event.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siconnectionsparser.SIConnectionsParser.__init__", "modulename": "smartinspectpython.siconnectionsparser", "qualname": "SIConnectionsParser.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.siconnectionsparser.SIConnectionsParser.ConnectionFoundEvent", "modulename": "smartinspectpython.siconnectionsparser", "qualname": "SIConnectionsParser.ConnectionFoundEvent", "kind": "variable", "doc": "<p>Event raised when a connections string has been found.</p>\n"}, {"fullname": "smartinspectpython.siconnectionsparser.SIConnectionsParser.Parse", "modulename": "smartinspectpython.siconnectionsparser", "qualname": "SIConnectionsParser.Parse", "kind": "function", "doc": "<p>Parses the connections part of a connections string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>connections (str):</strong>  The connections to parse. Not allowed to be null.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The connections argument is null.</li>\n<li><strong>SmartInspectException:</strong>  Invalid connections string syntax.</li>\n</ul>\n\n<p>This method parses the supplied connections part of a connections\nstring and informs the caller about found connections via the\nConnectionFoundEvent event.</p>\n\n<p>For information about the correct syntax of the connections,\nplease refer to the documentation of the SIProtocol.connections\nproperty.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siconnectionsparser</span> <span class=\"kn\">import</span> <span class=\"n\">SIConnectionsParser</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siconnectionfoundeventargs</span> <span class=\"kn\">import</span> <span class=\"n\">SIConnectionFoundEventArgs</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Test Script Starting.</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">AddConnection</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">SIConnectionFoundEventArgs</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Connection Found: </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">args</span><span class=\"p\">)))</span>\n\n<span class=\"c1\"># create parser class and wire up events.</span>\n<span class=\"n\">parser</span><span class=\"p\">:</span><span class=\"n\">SIConnectionsParser</span> <span class=\"o\">=</span> <span class=\"n\">SIConnectionsParser</span><span class=\"p\">()</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">ConnectionFoundEvent</span> <span class=\"o\">+=</span> <span class=\"n\">AddConnection</span>\n\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;tcp(host=thlucasi9.netlucas.com,port=4228,timeout=30000)&quot;</span><span class=\"p\">)</span>                               <span class=\"c1\"># test single protocol</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;tcp(host=thlucasi9.netlucas.com,port=4228,timeout=30000),file(filename=c:</span><span class=\"se\">\\\\</span><span class=\"s2\">log.sil,rotate=weekly)&quot;</span><span class=\"p\">)</span>     <span class=\"c1\"># test multiple protocols</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"c1\">#parser.Parse(&quot;tcp(host=localhost&quot;)     # test missing closed parenthesis</span>\n<span class=\"c1\">#parser.Parse(&#39;tcp(host=&quot;localhost&quot;)&#39;)  # test quoted values</span>\n<span class=\"c1\">#parser.Parse(&#39;tcp(host=&quot;localhost&quot;&#39;)   # test missing closed parenthesis</span>\n<span class=\"c1\">#parser.Parse(&#39;tcp(host=&quot;localhost),file(fileoption1=value)&#39;)   # test missing closed quotes</span>\n<span class=\"c1\">#parser.Parse(&#39;pipe()&#39;)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s1\">&#39;pipe(pipename=smartinspect,reconnect=true,reconnect.interval=5s,async.enabled=true)&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"c1\">#parser.Parse(&#39;pipe(pipename=smartinspect,reconnect=true,reconnect.interval=5s,async.enabled=false)&#39;)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s1\">&#39;file(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s1\">./tests/logfiles/FileProtocol-RotateHourlyNoBuffer.sil</span><span class=\"se\">\\&quot;</span><span class=\"s1\">, rotate=hourly, maxparts=24, append=true)&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s1\">&#39;file(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s1\">./tests/logfiles/FileProtocol-ENCRYPTTEST.sil</span><span class=\"se\">\\&quot;</span><span class=\"s1\">, encrypt=true, key=</span><span class=\"se\">\\&quot;</span><span class=\"s1\">secret</span><span class=\"se\">\\&quot;</span><span class=\"s1\">, rotate=none, append=false)&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s1\">&#39;mem(astext=true, indent=true)&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s1\">&#39;mem(astext=true, indent=true, pattern=</span><span class=\"se\">\\&quot;</span><span class=\"si\">%le</span><span class=\"s1\">vel% [%timestamp%]: %title%</span><span class=\"se\">\\&quot;</span><span class=\"s1\">)&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s1\">&#39;text(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s1\">./tests/logfiles/TextProtocol-RotateHourly.txt</span><span class=\"se\">\\&quot;</span><span class=\"s1\">, rotate=hourly, maxparts=24, indent=true, pattern=</span><span class=\"se\">\\&quot;</span><span class=\"si\">%le</span><span class=\"s1\">vel% [%timestamp%]: %title%</span><span class=\"se\">\\&quot;</span><span class=\"s1\">, append=true)&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># unwire events.</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">ConnectionFoundEvent</span> <span class=\"o\">-=</span> <span class=\"n\">AddConnection</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;</span><span class=\"se\">\\n</span><span class=\"s2\">Test Script Ended.&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">connections</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siconst", "modulename": "smartinspectpython.siconst", "kind": "module", "doc": "<p>Module: const.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/03</td>\n  <td>3.0.20.0</td>\n  <td>Changed package name to all lower-case to match installed package name.</td>\n</tr>\n<tr>\n  <td>2023/06/30</td>\n  <td>3.0.17.0</td>\n  <td>Added some files to .gitignore.</td>\n</tr>\n<tr>\n  <td>2023/06/30</td>\n  <td>3.0.15.0</td>\n  <td>Changed 'Development Status' to '5 - Production/Stable', and uploaded to Pypi.org site.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siconst.VERSION", "modulename": "smartinspectpython.siconst", "qualname": "VERSION", "kind": "variable", "doc": "<p>Current version of the SmartInspect Python3 Library.</p>\n", "annotation": ": str", "default_value": "&#x27;3.0.23&#x27;"}, {"fullname": "smartinspectpython.siconst.PACKAGENAME", "modulename": "smartinspectpython.siconst", "qualname": "PACKAGENAME", "kind": "variable", "doc": "<p>Name of our package (used by PDoc Documentation build).</p>\n", "annotation": ": str", "default_value": "&#x27;smartinspectpython&#x27;"}, {"fullname": "smartinspectpython.siconst.PDOC_BRAND_ICON_URL", "modulename": "smartinspectpython.siconst", "qualname": "PDOC_BRAND_ICON_URL", "kind": "variable", "doc": "<p>PDoc Documentation brand icon link url that is displayed in the help document TOC.\nValue = \"https://code-partners.com/offerings/smartinspect/\"</p>\n", "annotation": ": str", "default_value": "&#x27;https://code-partners.com/offerings/smartinspect/&#x27;"}, {"fullname": "smartinspectpython.siconst.PDOC_BRAND_ICON_URL_SRC", "modulename": "smartinspectpython.siconst", "qualname": "PDOC_BRAND_ICON_URL_SRC", "kind": "variable", "doc": "<p>PDoc Documentation brand icon link url that is displayed in the help document TOC.\nValue = \"smartinspect.ico\"</p>\n", "annotation": ": str", "default_value": "&#x27;smartinspect.ico&#x27;"}, {"fullname": "smartinspectpython.siconst.PDOC_BRAND_ICON_URL_TITLE", "modulename": "smartinspectpython.siconst", "qualname": "PDOC_BRAND_ICON_URL_TITLE", "kind": "variable", "doc": "<p>PDoc Documentation brand icon link title that is displayed in the help document TOC.\nValue = \"A SmartInspect Client\"</p>\n", "annotation": ": str", "default_value": "&#x27;A SmartInspect Client&#x27;"}, {"fullname": "smartinspectpython.siconst.TEXTFILE_PATTERN_DEFAULT", "modulename": "smartinspectpython.siconst", "qualname": "TEXTFILE_PATTERN_DEFAULT", "kind": "variable", "doc": "<p>Default value assigned to a Pattern property, which controls how lines are formatted in text log files. </p>\n\n<p>Value: \n    <code>\"[%timestamp%] %level%: %title%\"</code></p>\n", "annotation": ": str", "default_value": "&#x27;[%timestamp%] %level%: %title%&#x27;"}, {"fullname": "smartinspectpython.siconst.TEXTFILE_INDENT_DEFAULT", "modulename": "smartinspectpython.siconst", "qualname": "TEXTFILE_INDENT_DEFAULT", "kind": "variable", "doc": "<p>Default value assigned to a Indent property, which controls how lines are indented in text log files. </p>\n\n<p>Value: \n    False</p>\n", "annotation": ": bool", "default_value": "False"}, {"fullname": "smartinspectpython.siconst.TEXTFILE_HEADER_BOM", "modulename": "smartinspectpython.siconst", "qualname": "TEXTFILE_HEADER_BOM", "kind": "variable", "doc": "<p>Standard UTF-8 Byte Order Mark (BOM) that is written to a file stream to identify a log file as text in UTF-8 encoding.</p>\n\n<p>Value: \n    <code>[0xEF, 0xBB, 0xBF]</code></p>\n", "default_value": "bytearray(b&#x27;\\xef\\xbb\\xbf&#x27;)"}, {"fullname": "smartinspectpython.siconst.CLIENT_BANNER", "modulename": "smartinspectpython.siconst", "qualname": "CLIENT_BANNER", "kind": "variable", "doc": "<p>Our (client) banner sent to a SmartInspect Console server, which will be added to the console connections log.\nThis identifies what clients are connecting to the SI Console server.</p>\n\n<p>Value: \n    <code>\"SmartInspect Python3 Library vN.NN \n\"</code></p>\n", "annotation": ": str", "default_value": "&#x27;SmartInspect Python Library v3.0.23 ({0})\\r\\n&#x27;"}, {"fullname": "smartinspectpython.siconst.SERVER_BANNER_ERROR", "modulename": "smartinspectpython.siconst", "qualname": "SERVER_BANNER_ERROR", "kind": "variable", "doc": "<p>Indicates that the SmartInspect Console server unexpectedly closed the connection to our client.</p>\n\n<p>Value: \n    <code>\"Could not read server banner correctly: Connection has been closed unexpectedly!\"</code></p>\n", "annotation": ": str", "default_value": "&#x27;Could not read server banner correctly: Connection has been closed unexpectedly!&#x27;"}, {"fullname": "smartinspectpython.siconst.DEFAULT_COLOR_VALUE", "modulename": "smartinspectpython.siconst", "qualname": "DEFAULT_COLOR_VALUE", "kind": "variable", "doc": "<p>Default color integer value that represents 'White (transparent)'.</p>\n\n<p>Value: \n    16777215 (0x00FFFFFF in ARGB format).</p>\n", "annotation": ": int", "default_value": "16777215"}, {"fullname": "smartinspectpython.siconst.UNKNOWN_VALUE", "modulename": "smartinspectpython.siconst", "qualname": "UNKNOWN_VALUE", "kind": "variable", "doc": "<p>Indicates if an event argument value is unknown for event argument objects that are displayed as a string.</p>\n\n<p>Value: \n    <code>\"&lt;unknown&gt;\"</code></p>\n", "annotation": ": str", "default_value": "&#x27;&lt;unknown&gt;&#x27;"}, {"fullname": "smartinspectpython.sicontrolcommand", "modulename": "smartinspectpython.sicontrolcommand", "kind": "module", "doc": "<p>Module: sicontrolcommand.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand", "kind": "class", "doc": "<p>Represents the Control Command packet type which is used for\nadministrative tasks like resetting or clearing the Console.</p>\n\n<p>A Control Command can be used for several administrative Console\ntasks. Among other things, this packet type allows you to SISession.ClearAll.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe. However, instances\n  of this class will normally only be used in the context of a single thread.</p>\n</blockquote>\n", "bases": "smartinspectpython.sipacket.SIPacket"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.__init__", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.__init__", "kind": "function", "doc": "<p>Initializes a new ControlCommand instance with a custom control command type.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>controlCommandType (SIControlCommandType):</strong>  The type of the new Control Command describes the way the\nConsole interprets this packet. Please see the SIControlCommandType\nenum for more information.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">controlCommandType</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicontrolcommandtype</span><span class=\"o\">.</span><span class=\"n\">SIControlCommandType</span></span>)</span>"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.HEADER_SIZE", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.HEADER_SIZE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "8"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.Level", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.Level", "kind": "variable", "doc": "<p>Gets the Level property value.</p>\n\n<p>Represents the log level of this packet.</p>\n\n<p>Every packet can have a certain log level value. Log levels\ndescribe the severity of a packet. Please see the Level\nenum for more information about log levels and their usage.</p>\n", "annotation": ": smartinspectpython.silevel.SILevel"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.ControlCommandType", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.ControlCommandType", "kind": "variable", "doc": "<p>Gets the ControlCommandType property value.</p>\n\n<p>The type of the Control Command describes the way the Console\ninterprets this packet. Please see the SIControlCommandType enum\nfor more information.</p>\n", "annotation": ": smartinspectpython.sicontrolcommandtype.SIControlCommandType"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.Data", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.Data", "kind": "variable", "doc": "<p>Gets the Data property value.</p>\n\n<p>This property contains an optional data stream of the Control Command.\nThis property can be null if this Control Command does not\ncontain additional data.</p>\n\n<p><b>Important:</b> Treat this stream as read-only. This means,\nmodifying this stream in any way is not supported. Additionally,\nonly pass streams which support seeking. Streams which do not\nsupport seeking cannot be used by this class.</p>\n", "annotation": ": _io.BytesIO"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.DataLength", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.DataLength", "kind": "variable", "doc": "<p>Returns the number of bytes used in the Data property.\nNote that this is the actual # of bytes used, and not the # of bytes allocated!</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.HasData", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.HasData", "kind": "variable", "doc": "<p>Returns true if this packet contains optional data; otherwise, false.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.PacketType", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.PacketType", "kind": "variable", "doc": "<p>Overridden.  Returns SIPacketType.ControlCommand</p>\n", "annotation": ": smartinspectpython.sipackettype.SIPacketType"}, {"fullname": "smartinspectpython.sicontrolcommand.SIControlCommand.Size", "modulename": "smartinspectpython.sicontrolcommand", "qualname": "SIControlCommand.Size", "kind": "variable", "doc": "<p>Overridden.  Returns the total occupied memory size of this Control Command packet.</p>\n\n<p>The total occupied memory size of this Control Command is\nthe size of memory occupied the optional Data stream and any\ninternal data structures of this Control Command.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sicontrolcommandeventargs", "modulename": "smartinspectpython.sicontrolcommandeventargs", "kind": "module", "doc": "<p>Module: sicontrolcommandeventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sicontrolcommandeventargs.SIControlCommandEventArgs", "modulename": "smartinspectpython.sicontrolcommandeventargs", "qualname": "SIControlCommandEventArgs", "kind": "class", "doc": "<p>This class is used by the SmartInspect.ControlCommandEvent event.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sicontrolcommandeventargs.SIControlCommandEventArgs.__init__", "modulename": "smartinspectpython.sicontrolcommandeventargs", "qualname": "SIControlCommandEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>controlCommand (SIControlCommand):</strong>  The Control Command packet which caused the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">controlCommand</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicontrolcommand</span><span class=\"o\">.</span><span class=\"n\">SIControlCommand</span></span>)</span>"}, {"fullname": "smartinspectpython.sicontrolcommandeventargs.SIControlCommandEventArgs.ControlCommand", "modulename": "smartinspectpython.sicontrolcommandeventargs", "qualname": "SIControlCommandEventArgs.ControlCommand", "kind": "variable", "doc": "<p>Returns the ControlCommand item that was processed.</p>\n", "annotation": ": smartinspectpython.sicontrolcommand.SIControlCommand"}, {"fullname": "smartinspectpython.sicontrolcommandeventargs.SIControlCommandEventHandler", "modulename": "smartinspectpython.sicontrolcommandeventargs", "qualname": "SIControlCommandEventHandler", "kind": "class", "doc": "<p>This is the event handler type for the SmartInspect.ControlCommandEvent event.</p>\n"}, {"fullname": "smartinspectpython.sicontrolcommandeventargs.SIControlCommandEventHandler.__init__", "modulename": "smartinspectpython.sicontrolcommandeventargs", "qualname": "SIControlCommandEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIControlCommandEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicontrolcommandeventargs</span><span class=\"o\">.</span><span class=\"n\">SIControlCommandEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.sicontrolcommandtype", "modulename": "smartinspectpython.sicontrolcommandtype", "kind": "module", "doc": "<p>Module: sicontrolcommandtype.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sicontrolcommandtype.SIControlCommandType", "modulename": "smartinspectpython.sicontrolcommandtype", "qualname": "SIControlCommandType", "kind": "class", "doc": "<p>Represents the type of a ControlCommand packet. The type of\na control command influences the way the Console interprets the packet.</p>\n\n<p>For example, if a Control Command packet has a type of ClearAll, the entire \nConsole is reset when this packet arrives. Also have a look at the corresponding\nSISession.ClearAll method.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.sicontrolcommandtype.SIControlCommandType.ClearLog", "modulename": "smartinspectpython.sicontrolcommandtype", "qualname": "SIControlCommandType.ClearLog", "kind": "variable", "doc": "<p>Instructs the Console to clear all Log Entries.</p>\n", "default_value": "&lt;SIControlCommandType.ClearLog: 0&gt;"}, {"fullname": "smartinspectpython.sicontrolcommandtype.SIControlCommandType.ClearWatches", "modulename": "smartinspectpython.sicontrolcommandtype", "qualname": "SIControlCommandType.ClearWatches", "kind": "variable", "doc": "<p>Instructs the Console to clear all Watches.</p>\n", "default_value": "&lt;SIControlCommandType.ClearWatches: 1&gt;"}, {"fullname": "smartinspectpython.sicontrolcommandtype.SIControlCommandType.ClearAutoViews", "modulename": "smartinspectpython.sicontrolcommandtype", "qualname": "SIControlCommandType.ClearAutoViews", "kind": "variable", "doc": "<p>Instructs the Console to clear all AutoViews.</p>\n", "default_value": "&lt;SIControlCommandType.ClearAutoViews: 2&gt;"}, {"fullname": "smartinspectpython.sicontrolcommandtype.SIControlCommandType.ClearAll", "modulename": "smartinspectpython.sicontrolcommandtype", "qualname": "SIControlCommandType.ClearAll", "kind": "variable", "doc": "<p>Instructs the Console to reset the whole Console.</p>\n", "default_value": "&lt;SIControlCommandType.ClearAll: 3&gt;"}, {"fullname": "smartinspectpython.sicontrolcommandtype.SIControlCommandType.ClearProcessFlow", "modulename": "smartinspectpython.sicontrolcommandtype", "qualname": "SIControlCommandType.ClearProcessFlow", "kind": "variable", "doc": "<p>Instructs the Console to clear all Process Flow entries.</p>\n", "default_value": "&lt;SIControlCommandType.ClearProcessFlow: 4&gt;"}, {"fullname": "smartinspectpython.sicryptostreamwriter", "modulename": "smartinspectpython.sicryptostreamwriter", "kind": "module", "doc": "<p>Module: sicryptostreamwriter.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sicryptostreamwriter.SICryptoStreamWriter", "modulename": "smartinspectpython.sicryptostreamwriter", "qualname": "SICryptoStreamWriter", "kind": "class", "doc": "<p>Cryptographic stream writer class used to encrypt data and write to a destination\nstream.</p>\n\n<p>This class utilizes PyCryptodome cryptography support.  More info can be found here:\n<a href=\"https://pycryptodome.readthedocs.io/en/latest/index.html\">https://pycryptodome.readthedocs.io/en/latest/index.html</a></p>\n", "bases": "_io.BytesIO"}, {"fullname": "smartinspectpython.sicryptostreamwriter.SICryptoStreamWriter.__init__", "modulename": "smartinspectpython.sicryptostreamwriter", "qualname": "SICryptoStreamWriter.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BufferedWriter):</strong>  Destination stream (BufferedWriter object) that encrypted data will be written to.</li>\n<li><strong>cipher (object):</strong>  AES Cipher object used to encrypt the data.</li>\n<li><strong>padMethod (str):</strong>  Method used for padding bytes to be encoded; possible values are 'pkcs7' (default), 'iso7816' or 'x923'.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  Thrown if the cipher or stream argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedWriter</span>, </span><span class=\"param\"><span class=\"n\">cipher</span>, </span><span class=\"param\"><span class=\"n\">padMethod</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;pkcs7&#39;</span></span>)</span>"}, {"fullname": "smartinspectpython.sicryptostreamwriter.SICryptoStreamWriter.flush", "modulename": "smartinspectpython.sicryptostreamwriter", "qualname": "SICryptoStreamWriter.flush", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicryptostreamwriter.SICryptoStreamWriter.tell", "modulename": "smartinspectpython.sicryptostreamwriter", "qualname": "SICryptoStreamWriter.tell", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicryptostreamwriter.SICryptoStreamWriter.writable", "modulename": "smartinspectpython.sicryptostreamwriter", "qualname": "SICryptoStreamWriter.writable", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicryptostreamwriter.SICryptoStreamWriter.write", "modulename": "smartinspectpython.sicryptostreamwriter", "qualname": "SICryptoStreamWriter.write", "kind": "function", "doc": "<p>Overridden.  Write encrypted data to the destination stream specified at initialization.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>data (object):</strong>  Data to write.</li>\n</ul>\n\n<p>The data to write is encrypted using a block size of the Cipher specified at \ninitialization, and written to the underlying stream.  If there is not enough \ndata to fill a block, then it is written to a temporary buffer to be processed \non the next write or close.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sicryptostreamwriter.SICryptoStreamWriter.close", "modulename": "smartinspectpython.sicryptostreamwriter", "qualname": "SICryptoStreamWriter.close", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n\n<p>Prior to closing the destination stream, it will encrypt and write out any remaining \nbytes in the temporary buffer to the destination stream.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sidataviewercontext", "modulename": "smartinspectpython.sidataviewercontext", "kind": "module", "doc": "<p>Module: sidataviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sidataviewercontext.SIDataViewerContext", "modulename": "smartinspectpython.sidataviewercontext", "qualname": "SIDataViewerContext", "kind": "class", "doc": "<p>Represents the data viewer in the Console which can display simple\nand unformatted text.</p>\n\n<p>The data viewer in the Console interprets the Log Entry Data as text\nand displays it in a read-only text field.</p>\n\n<p>You can use this class for creating custom log methods around \nSISession.LogCustomContext(string, SILogEntryType, SIViewerContext)\nfor sending custom text data.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sitextcontext.SITextContext"}, {"fullname": "smartinspectpython.sidataviewercontext.SIDataViewerContext.__init__", "modulename": "smartinspectpython.sidataviewercontext", "qualname": "SIDataViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class with a Data SIViewerId value.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sienumcomparable", "modulename": "smartinspectpython.sienumcomparable", "kind": "module", "doc": "<p>Module: sienumcomparable.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sienumcomparable.SIEnumComparable", "modulename": "smartinspectpython.sienumcomparable", "qualname": "SIEnumComparable", "kind": "class", "doc": "<p>Class used to compare Enum objects without having to specify \".value\" on\nthe end of the enum name.</p>\n", "bases": "enum.Enum"}, {"fullname": "smartinspectpython.sienumcomparable.SIEnumComparable.__init__", "modulename": "smartinspectpython.sienumcomparable", "qualname": "SIEnumComparable.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>other (object):</strong>  Object to compare with this object.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">other</span></span>)</span>"}, {"fullname": "smartinspectpython.sierroreventargs", "modulename": "smartinspectpython.sierroreventargs", "kind": "module", "doc": "<p>Module: sierroreventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sierroreventargs.SIErrorEventArgs", "modulename": "smartinspectpython.sierroreventargs", "qualname": "SIErrorEventArgs", "kind": "class", "doc": "<p>Arguments passed to the SmartInspect.ErrorEvent event.</p>\n\n<p>It has only one public class member named Exception. This member\nis a property, which just returns the occurred exception.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sierroreventargs.SIErrorEventArgs.__init__", "modulename": "smartinspectpython.sierroreventargs", "qualname": "SIErrorEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>e (Exception):</strong>  Exception that caused the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"ne\">Exception</span></span>)</span>"}, {"fullname": "smartinspectpython.sierroreventargs.SIErrorEventArgs.Exception", "modulename": "smartinspectpython.sierroreventargs", "qualname": "SIErrorEventArgs.Exception", "kind": "variable", "doc": "<p>Exception that caused the event.</p>\n", "annotation": ": Exception"}, {"fullname": "smartinspectpython.sierroreventargs.SIErrorEventHandler", "modulename": "smartinspectpython.sierroreventargs", "qualname": "SIErrorEventHandler", "kind": "class", "doc": "<p>Event handler type for the SmartInspect.ErrorEvent event.</p>\n"}, {"fullname": "smartinspectpython.sierroreventargs.SIErrorEventHandler.__init__", "modulename": "smartinspectpython.sierroreventargs", "qualname": "SIErrorEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIErrorEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sierroreventargs</span><span class=\"o\">.</span><span class=\"n\">SIErrorEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.sifilehelper", "modulename": "smartinspectpython.sifilehelper", "kind": "module", "doc": "<p>Module: sifilehelper.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper", "kind": "class", "doc": "<p>Responsible for the log file rotate management as used by the\nSIFileProtocol class.</p>\n\n<p>This class implements a flexible log file rotate management\nsystem. For a detailed description of how to use this class,\nplease refer to the documentation of the Initialize(DateTime)\nand Update(DateTime) methods and the Mode property.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.ALREADY_EXISTS_SUFFIX", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.ALREADY_EXISTS_SUFFIX", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;a&#x27;"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.DATETIME_FORMAT", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.DATETIME_FORMAT", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;yyyy-MM-dd-HH-mm-ss&#x27;"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.DATETIME_FORMAT_LEN", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.DATETIME_FORMAT_LEN", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "19"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.DATETIME_SEPARATOR", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.DATETIME_SEPARATOR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": &lt;built-in function chr&gt;", "default_value": "&#x27;-&#x27;"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.DATETIME_TOKENS", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.DATETIME_TOKENS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "6"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.DeleteFiles", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.DeleteFiles", "kind": "function", "doc": "<p>Deletes existing log files that fall outside the maximum retention range.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>baseName (str):</strong>  Base name path of a log file (e.g. \"C:\\logfile-hourly.txt\").</li>\n<li><strong>maxParts (int):</strong>  Maximum number of files to keep for the base name path.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">baseName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">maxParts</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.GetFileDate", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.GetFileDate", "kind": "function", "doc": "<p>Returns a datetime object of the timestamp portion of the filename path argument.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>baseName (str):</strong>  Base name path of a log file (e.g. \"C:\\logfile-hourly.txt\").</li>\n<li><strong>path (str):</strong>  Full name of a log file, which is comprised of the base name path and a timestamp before the extension (e.g. \"C:\\logfile-hourly-2023-05-22-00-49-55.txt\").</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A datetime object of the timestamp portion of the path argument filename.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SmartInspectException:</strong>  Thrown if the datetime object could not be created from the timestamp portion of the path argument filename.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">baseName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifilehelper.SIFileHelper.GetFileName", "modulename": "smartinspectpython.sifilehelper", "qualname": "SIFileHelper.GetFileName", "kind": "function", "doc": "<p>Returns a log file path.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>baseName (str):</strong>  Base name path of a log file (e.g. \"C:\\logfile-hourly.txt\").</li>\n<li><strong>append (bool):</strong>  True to append to the existing latest log file; otherwise, False to create \na new log file path from the specified base name path.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A log file path that includes the base name path along with a \n  timestamp value (e.g. \"C:\\logfile-hourly-2023-05-22-12-00-00.txt\").</p>\n</blockquote>\n\n<p>If no rotating log file was found, or we are not appending\nto an existing file, then a new log file will be created.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">baseName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol", "modulename": "smartinspectpython.sifileprotocol", "kind": "module", "doc": "<p>Module: sifileprotocol.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol", "kind": "class", "doc": "<p>The standard SmartInspect protocol for writing log packets to a log file.</p>\n\n<p>SIFileProtocol is the base class for all protocol classes which\ndeal with log files. By default, it uses the binary log file format\nwhich is compatible to the Console. Derived classes can change this\nbehavior. For example, for a simple protocol which is capable of\ncreating plain text files, see the SITextProtocol class.</p>\n\n<p>The file protocol supports a variety of options, such as log\nrotation (by size and date), encryption and I/O buffers. </p>\n\n<p>For a list of available protocol options, please refer to the\nIsValidOption method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siprotocol.SIProtocol"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.__init__", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.DefaultFileName", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.DefaultFileName", "kind": "variable", "doc": "<p>Gets the DefaultFileName property value.</p>\n\n<p>Returns the default filename for this log file protocol.</p>\n\n<p>The standard implementation of this method returns the string\n\"log.sil\" here. Derived classes can change this behavior by\noverriding this property method.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.Formatter", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.Formatter", "kind": "variable", "doc": "<p>Gets the Formatter property value.</p>\n\n<p>Returns the formatter for this log file protocol.</p>\n\n<p>The standard implementation of this method returns an instance\nof the SIBinaryFormatter class. Derived classes can change this\nbehavior by overriding this property method.</p>\n", "annotation": ": smartinspectpython.siformatter.SIFormatter"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.Name", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.Name", "kind": "variable", "doc": "<p>Overridden.  Returns \"file\".</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.BuildOptions", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.BuildOptions", "kind": "function", "doc": "<p>Overridden. Fills a SIConnectionsBuilder instance with the\noptions currently used by this protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>builder (SIConnectionsBuilder):</strong>  The SIConnectionsBuilder object to fill with the current options\nof this protocol.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">builder</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconnectionsbuilder</span><span class=\"o\">.</span><span class=\"n\">SIConnectionsBuilder</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.GetIVector", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.GetIVector", "kind": "function", "doc": "<p>Returns a new MD5 hashed initialization vector for AES cryptographic functions.\nThe vector is based on a current datetime ticks value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A new MD5 hashed initialization vector of 16 bytes (128-bits).</returns></p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">bytes</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.GetStream", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.GetStream", "kind": "function", "doc": "<p>Intended to provide a wrapper stream for the underlying file stream.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The underlying file stream.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The wrapper stream.</p>\n</blockquote>\n\n<p>This method can be used by custom protocol implementers\nto wrap the underlying file stream into a filter stream.\nSuch filter streams include\nSystem.Security.Cryptography.CryptoStream for encrypting\nor System.IO.Compression.DeflateStream for compressing log\nfiles, for example.</p>\n\n<p>By default, this method simply returns the passed stream argument.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.InternalConnect", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.InternalConnect", "kind": "function", "doc": "<p>Overridden. Opens the destination file.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Opening the destination file failed.</li>\n</ul>\n\n<p>This method tries to open the destination file, which can\nbe specified by passing the \"filename\" option to the Initialize\nmethod. For other valid options which might affect the\nbehavior of this method, please see the IsValidOption method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.InternalDisconnect", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.InternalDisconnect", "kind": "function", "doc": "<p>Overridden. Closes the destination file.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Closing the destination file failed.</li>\n</ul>\n\n<p>This method closes the underlying file handle if previously\ncreated and disposes any supplemental objects.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.InternalWritePacket", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.InternalWritePacket", "kind": "function", "doc": "<p>Overridden. Writes a packet to the destination file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to write.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Writing the packet to the destination file failed.</li>\n</ul>\n\n<p>If the \"maxsize\" option is set and the supplied packet would\nexceed the maximum size of the destination file, then the \ncurrent log file is closed and a new file is opened.\nAdditionally, if the \"rotate\" option is active, the log file\nis rotated if necessary. Please see the documentation of the\nIsValidOption method for more information.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.IsValidOption", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.IsValidOption", "kind": "function", "doc": "<p>Overridden. Validates if a protocol option is supported.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The option name to validate.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the option is supported and false otherwise.</p>\n</blockquote>\n\n<p>The following table lists all valid options, their default\nvalues and descriptions for the FILE protocol.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Valid Options (default value)</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>append (false)</td>\n  <td>Specifies if new packets should be appended to the destination file instead of overwriting the file first.</td>\n</tr>\n<tr>\n  <td>buffer (0)</td>\n  <td>Specifies the I/O buffer size in kilobytes. It is possible to specify size units like this: \"1 MB\". Supported units are \"KB\", \"MB\" and \"GB\". A value of 0 disables this feature. Enabling the I/O buffering greatly improves the logging performance but has the disadvantage that log packets are temporarily stored in memory and are not immediately written to disk.</td>\n</tr>\n<tr>\n  <td>encrypt (false)</td>\n  <td>Specifies if the resulting log file should be encrypted. Note that the 'append' option cannot be used with encryption enabled. If encryption is enabled the 'append' option has no effect.</td>\n</tr>\n<tr>\n  <td>filename ([varies])</td>\n  <td>Specifies the filename of the log.</td>\n</tr>\n<tr>\n  <td>key ([empty])</td>\n  <td>Specifies the secret encryption key as string if the 'encrypt' option is enabled.</td>\n</tr>\n<tr>\n  <td>maxparts ([varies])</td>\n  <td>Specifies the maximum amount of log files at any given time when log rotating is enabled or the maxsize option is set. Specify 0 for no limit. See below for information on the default value for this option.</td>\n</tr>\n<tr>\n  <td>maxsize (0)</td>\n  <td>Specifies the maximum size of a log file in kilobytes. When this size is reached, the current log file is closed and a new file is opened. The maximum amount of log files can be set with the maxparts option. It is possible to specify size units like this: \"1 MB\". Supported units are \"KB\", \"MB\" and \"GB\".  A value of 0 disables this feature.</td>\n</tr>\n<tr>\n  <td>rotate (none)</td>\n  <td>Specifies the rotate mode for log files. Please see below for a list of available values. A value of \"none\" disables this feature. The maximum amount of log files can be set with the maxparts option.  See the SIFileRotate enum for more info.</td>\n</tr>\n</tbody>\n</table>\n\n<p>When using the standard binary log file protocol (\"file\" in the SmartInspect.Connections, the default\nfilename is set to \"log.sil\". When using text log files (\"text\" in the SmartInspect.Connections), the\ndefault filename is \"log.txt\".</p>\n\n<p>The append option specifies if new packets should be appended to the destination file instead of \noverwriting the file. The default value of this option is \"false\". </p>\n\n<p>The rotate option specifies the date log rotate mode for this file protocol. When this option is used, \nthe filename of the resulting log consists of the value of the filename option and\nan appended time stamp (the used time stamp format thereby is \"yyyy-MM-dd-HH-mm-ss\"). To avoid problems \nwith daylight saving time or time zone changes, the time stamp is always in UTC (Coordinated Universal Time). \nThe following table lists the available rotate modes together with a short description.</p>\n\n<p>As example, if you specify \"log.sil\" as value for the filename option and use the Daily rotate mode, the log file is rotated\ndaily and always has a name of log-yyyy-MM-dd-HH-mm-ss.sil. In addition to, or instead of, rotating log files by date, you\ncan also let the file protocol rotate log files by size. To enable this feature, set the maxsize option to the desired\nmaximum size. Similar to rotating by date, the resulting log files include a time stamp. Note that starting with\nSmartInspect 3.0, it is supported to combine the maxsize and rotate options (i.e. use both options at the same time).</p>\n\n<p>To control the maximum amount of created log files for the rotate and/or maxsize options, you can use the maxparts option.\nThe default value for maxparts is 2 when used with the maxsize option, 0 when used with rotate and 0 when both options,\nmaxsize and rotate, are used.</p>\n\n<p>SmartInspect log files can be automatically encrypted by enabling the 'encrypt' option. The used cipher is Rijndael\n(AES) with a key size of 128 bit. The secret encryption key can be specified with the 'key' option. The specified\nkey is automatically shortened or padded (with zeros) to a key size of 128 bit. Note that the 'append' option cannot be\nused in combination with encryption enabled. If encryption is enabled the 'append' option has no effect.</p>\n\n<p>For further options which affect the behavior of this protocol, please have a look at the documentation of the\nSIProtocol.IsValidOption method of the parent class.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># the following are sample SI Connections options for this protocol.</span>\n\n<span class=\"c1\"># log messages using all default options (&quot;log.sil&quot;, no rotating).</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;file()&#39;</span>\n\n<span class=\"c1\"># log messages (appending) to file &#39;mylog.sil&#39;.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">mylog.sil</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, append=true)&quot;</span>\n\n<span class=\"c1\"># log messages to rotating default file &#39;log.sil&#39;, that do not </span>\n<span class=\"c1\"># exceed 16MB in size.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(maxsize=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">16MB</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, maxparts=5)&quot;</span>\n\n<span class=\"c1\"># log messages to rotating default file &#39;log.sil&#39;, that creates a new log </span>\n<span class=\"c1\"># file every week.  since maxparts is not specified, log files will continue </span>\n<span class=\"c1\"># to accumulate and must be manually deleted.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(rotate=weekly)&quot;</span>\n\n<span class=\"c1\"># log messages to default file &#39;log.sil&#39;, in an encrypted format with a </span>\n<span class=\"c1\"># password of &quot;secret&quot;.  when opening the log file in the SI Console, you </span>\n<span class=\"c1\"># will be prompted for the passphrase key.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(encrypt=true, key=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">secret</span><span class=\"se\">\\&quot;</span><span class=\"s2\">)&quot;</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.LoadOptions", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.LoadOptions", "kind": "function", "doc": "<p>Overridden. Loads and inspects specific options for this protocol.</p>\n\n<p>This method loads all relevant options and ensures their\ncorrectness. See IsValidOption for a list of options which\nare recognized by the protocol.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.ThrowException", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.ThrowException", "kind": "function", "doc": "<p>Raises a new SIProtocolException exception</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Thrown when this method is called.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.WriteFooter", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.WriteFooter", "kind": "function", "doc": "<p>Intended to write the footer of a log file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to which the footer should be written to.</li>\n</ul>\n\n<p>The implementation of this method does nothing. Derived\nclass may change this behavior by overriding this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifileprotocol.SIFileProtocol.WriteHeader", "modulename": "smartinspectpython.sifileprotocol", "qualname": "SIFileProtocol.WriteHeader", "kind": "function", "doc": "<p>Intended to write the header of a log file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to which the header should be written to.</li>\n<li><strong>size (int):</strong>  Specifies the current size of the supplied stream.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new size of the stream after writing the header. If no\n  header is written, the supplied size argument is returned.</p>\n</blockquote>\n\n<p>This default implementation of this method writes the standard\nbinary protocol header to the supplied Stream instance.\nDerived classes may change this behavior by overriding this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span>, </span><span class=\"param\"><span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifilerotate", "modulename": "smartinspectpython.sifilerotate", "kind": "module", "doc": "<p>Module: sifilerotate.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sifilerotate.SIFileRotate", "modulename": "smartinspectpython.sifilerotate", "qualname": "SIFileRotate", "kind": "class", "doc": "<p>Specifies the log rotate mode for the SIFileProtocol class and\nderived classes.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.sifilerotate.SIFileRotate.NoRotate", "modulename": "smartinspectpython.sifilerotate", "qualname": "SIFileRotate.NoRotate", "kind": "variable", "doc": "<p>Completely disables the log rotate functionality.</p>\n", "default_value": "&lt;SIFileRotate.NoRotate: 0&gt;"}, {"fullname": "smartinspectpython.sifilerotate.SIFileRotate.Hourly", "modulename": "smartinspectpython.sifilerotate", "qualname": "SIFileRotate.Hourly", "kind": "variable", "doc": "<p>Instructs the file protocol to rotate log files hourly.</p>\n", "default_value": "&lt;SIFileRotate.Hourly: 1&gt;"}, {"fullname": "smartinspectpython.sifilerotate.SIFileRotate.Daily", "modulename": "smartinspectpython.sifilerotate", "qualname": "SIFileRotate.Daily", "kind": "variable", "doc": "<p>Instructs the file protocol to rotate log files daily.</p>\n", "default_value": "&lt;SIFileRotate.Daily: 2&gt;"}, {"fullname": "smartinspectpython.sifilerotate.SIFileRotate.Weekly", "modulename": "smartinspectpython.sifilerotate", "qualname": "SIFileRotate.Weekly", "kind": "variable", "doc": "<p>Instructs the file protocol to rotate log files weekly.</p>\n", "default_value": "&lt;SIFileRotate.Weekly: 3&gt;"}, {"fullname": "smartinspectpython.sifilerotate.SIFileRotate.Monthly", "modulename": "smartinspectpython.sifilerotate", "qualname": "SIFileRotate.Monthly", "kind": "variable", "doc": "<p>Instructs the file protocol to rotate log files monthly.</p>\n", "default_value": "&lt;SIFileRotate.Monthly: 4&gt;"}, {"fullname": "smartinspectpython.sifilerotate.SIFileRotate.Parse", "modulename": "smartinspectpython.sifilerotate", "qualname": "SIFileRotate.Parse", "kind": "function", "doc": "<p>Returns an enum value for the given string representation if found,\notherwise the default value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The string representation of the enum value.</li>\n<li><strong>defaultValue (object):</strong>  The value to use if an enum could not be determined from the value.</li>\n</ul>\n\n<p>Both the Name and Value of the enum are compared for a match.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifilerotater", "modulename": "smartinspectpython.sifilerotater", "kind": "module", "doc": "<p>Module: sifilerotater.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sifilerotater.SIFileRotater", "modulename": "smartinspectpython.sifilerotater", "qualname": "SIFileRotater", "kind": "class", "doc": "<p>Responsible for the log file rotate management as used by the\nSIFileProtocol class.</p>\n\n<p>This class implements a flexible log file rotate management\nsystem. For a detailed description of how to use this class,\nplease refer to the documentation of the Initialize(DateTime)\nand Update(DateTime) methods and the Mode property.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sifilerotater.SIFileRotater.__init__", "modulename": "smartinspectpython.sifilerotater", "qualname": "SIFileRotater.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sifilerotater.SIFileRotater.Mode", "modulename": "smartinspectpython.sifilerotater", "qualname": "SIFileRotater.Mode", "kind": "variable", "doc": "<p>Gets the FileRotate property value.</p>\n\n<p>Represents the SIFileRotate mode of this SIFileRotater object.</p>\n\n<p>Always call the Initialize method after changing this\nproperty to reinitialize this SIFileRotater object. For a\ncomplete list of available property values, please refer\nto the documentation of the SIFileRotate enum.</p>\n", "annotation": ": smartinspectpython.sifilerotate.SIFileRotate"}, {"fullname": "smartinspectpython.sifilerotater.SIFileRotater.Initialize", "modulename": "smartinspectpython.sifilerotater", "qualname": "SIFileRotater.Initialize", "kind": "function", "doc": "<p>Initializes this object with a user-supplied timestamp.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>now (datetime):</strong>  The user-specified timestamp to use to initialize this object.</li>\n</ul>\n\n<p>Always call this method after creating a new SIFileRotater\nobject and before calling the Update method the first time.\nFor additional information please refer to the Update method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">now</span><span class=\"p\">:</span> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifilerotater.SIFileRotater.GetTimeValue", "modulename": "smartinspectpython.sifilerotater", "qualname": "SIFileRotater.GetTimeValue", "kind": "function", "doc": "<p>Determines the amount of time between the specified date and when the next file\nrotation will take place.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>now (datetime):</strong>  The date the File Rotation event is calculated from.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The amount of time between the specified date and when the next file\n  rotation will take place.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">now</span><span class=\"p\">:</span> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifilerotater.SIFileRotater.Update", "modulename": "smartinspectpython.sifilerotater", "qualname": "SIFileRotater.Update", "kind": "function", "doc": "<p>Updates the date of this object and returns\nwhether the rotate state has changed since the last call to\nthis method or to Initialize.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>now (datetime):</strong>  The timestamp to update this object.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the rotate state has changed since the last call to\n  this method or to Initialize and false otherwise.</p>\n</blockquote>\n\n<p>This method updates the internal date of this SIFileRotater\nobject and returns whether the rotate state has changed since\nthe last call to this method or to Initialize. Before calling\nthis method, always call the Initialize method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">now</span><span class=\"p\">:</span> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sifiltereventargs", "modulename": "smartinspectpython.sifiltereventargs", "kind": "module", "doc": "<p>Module: sifiltereventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sifiltereventargs.SIFilterEventArgs", "modulename": "smartinspectpython.sifiltereventargs", "qualname": "SIFilterEventArgs", "kind": "class", "doc": "<p>This class is used by the SmartInspect.Filter event.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sifiltereventargs.SIFilterEventArgs.__init__", "modulename": "smartinspectpython.sifiltereventargs", "qualname": "SIFilterEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet which caused the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span>)</span>"}, {"fullname": "smartinspectpython.sifiltereventargs.SIFilterEventArgs.Packet", "modulename": "smartinspectpython.sifiltereventargs", "qualname": "SIFilterEventArgs.Packet", "kind": "variable", "doc": "<p>This read-only property returns the packet, which caused\nthe event.</p>\n", "annotation": ": smartinspectpython.sipacket.SIPacket"}, {"fullname": "smartinspectpython.sifiltereventargs.SIFilterEventArgs.Cancel", "modulename": "smartinspectpython.sifiltereventargs", "qualname": "SIFilterEventArgs.Cancel", "kind": "variable", "doc": "<p>Gets the Cancel property value.</p>\n\n<p>This property can be used to cancel the processing of certain\npackets during the SmartInspect.Filter event.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sifiltereventargs.SIFilterEventHandler", "modulename": "smartinspectpython.sifiltereventargs", "qualname": "SIFilterEventHandler", "kind": "class", "doc": "<p>This is the event handler type for the SmartInspect.Filter event.</p>\n"}, {"fullname": "smartinspectpython.sifiltereventargs.SIFilterEventHandler.__init__", "modulename": "smartinspectpython.sifiltereventargs", "qualname": "SIFilterEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIFilterEventArgs):</strong>  Arguments that contain detailed information related to the event,\nand canceling of its processing.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sifiltereventargs</span><span class=\"o\">.</span><span class=\"n\">SIFilterEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.siformatter", "modulename": "smartinspectpython.siformatter", "kind": "module", "doc": "<p>Module: siformatter.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siformatter.SIFormatter", "modulename": "smartinspectpython.siformatter", "qualname": "SIFormatter", "kind": "class", "doc": "<p>Responsible for formatting and writing a packet.</p>\n\n<p>This abstract class defines several methods which are intended\nto preprocess a packet and subsequently write it to a stream.\nThe process of preprocessing (or compiling) and writing a packet\ncan either be executed with a single step by calling the Format\nmethod or with two steps by calls to Compile and Write.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class and subclasses thereof are not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siformatter.SIFormatter.Compile", "modulename": "smartinspectpython.siformatter", "qualname": "SIFormatter.Compile", "kind": "function", "doc": "<p>Preprocesses (or compiles) a packet and returns the required\nsize for the compiled result.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to compile.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>NotImplementedError:</strong>  Raised if the method is not implemented in an inheriting class.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The size for the compiled result.</p>\n</blockquote>\n\n<p>To write a previously compiled packet, call the Write method.\nDerived classes are intended to compile the supplied packet\nand return the required size for the compiled result.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siformatter.SIFormatter.Format", "modulename": "smartinspectpython.siformatter", "qualname": "SIFormatter.Format", "kind": "function", "doc": "<p>Compiles a packet and writes it to a stream.  </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to compile.</li>\n<li><strong>stream (BytesIO):</strong>  The stream to write the packet to.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>IOException:</strong>  An I/O error occurred while trying to write the compiled packet.</li>\n</ul>\n\n<p>This non-abstract method simply calls the Compile method with\nthe supplied packet object and then the Write method with\nthe supplied stream object.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siformatter.SIFormatter.Write", "modulename": "smartinspectpython.siformatter", "qualname": "SIFormatter.Write", "kind": "function", "doc": "<p>Writes a previously compiled packet to the supplied stream.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to write the packet to.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>IOException:</strong>  An I/O error occurred while trying to write the compiled packet.</li>\n<li><strong>NotImplementedError:</strong>  Raised if the method is not implemented in an inheriting class.</li>\n</ul>\n\n<p>This method is intended to write a previously compiled packet\n(see Compile) to the supplied stream object. If the return\nvalue of the Compile method was 0, nothing is written.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sigraphicid", "modulename": "smartinspectpython.sigraphicid", "kind": "module", "doc": "<p>Module: sigraphicid.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sigraphicid.SIGraphicId", "modulename": "smartinspectpython.sigraphicid", "qualname": "SIGraphicId", "kind": "class", "doc": "<p>Used by the SIGraphicViewerContext class to specify the desired\npicture type.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.sigraphicid.SIGraphicId.Bitmap", "modulename": "smartinspectpython.sigraphicid", "qualname": "SIGraphicId.Bitmap", "kind": "variable", "doc": "<p>Instructs the graphic viewer context class to treat the data as bitmap image.</p>\n", "default_value": "&lt;SIGraphicId.Bitmap: 400&gt;"}, {"fullname": "smartinspectpython.sigraphicid.SIGraphicId.Jpeg", "modulename": "smartinspectpython.sigraphicid", "qualname": "SIGraphicId.Jpeg", "kind": "variable", "doc": "<p>Instructs the graphic viewer context class class to treat the data as JPEG image.</p>\n", "default_value": "&lt;SIGraphicId.Jpeg: 401&gt;"}, {"fullname": "smartinspectpython.sigraphicid.SIGraphicId.Icon", "modulename": "smartinspectpython.sigraphicid", "qualname": "SIGraphicId.Icon", "kind": "variable", "doc": "<p>Instructs the graphic viewer context class class to treat the data as Window icon.</p>\n", "default_value": "&lt;SIGraphicId.Icon: 402&gt;"}, {"fullname": "smartinspectpython.sigraphicid.SIGraphicId.Metafile", "modulename": "smartinspectpython.sigraphicid", "qualname": "SIGraphicId.Metafile", "kind": "variable", "doc": "<p>Instructs the graphic viewer context class class to treat the data as Window Metafile image.</p>\n", "default_value": "&lt;SIGraphicId.Metafile: 403&gt;"}, {"fullname": "smartinspectpython.sigraphicid.SIGraphicId.Png", "modulename": "smartinspectpython.sigraphicid", "qualname": "SIGraphicId.Png", "kind": "variable", "doc": "<p>Instructs the graphic viewer context class class to treat the data as PNG image.</p>\n", "default_value": "&lt;SIGraphicId.Png: 404&gt;"}, {"fullname": "smartinspectpython.sigraphicviewercontext", "modulename": "smartinspectpython.sigraphicviewercontext", "kind": "module", "doc": "<p>Module: graphicviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sigraphicviewercontext.SIGraphicViewerContext", "modulename": "smartinspectpython.sigraphicviewercontext", "qualname": "SIGraphicViewerContext", "kind": "class", "doc": "<p>Represents the graphic viewer in the Console which can display images.</p>\n\n<p>The graphic viewer in the Console interprets the Log Entry Data as picture.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sibinarycontext.SIBinaryContext"}, {"fullname": "smartinspectpython.sigraphicviewercontext.SIGraphicViewerContext.__init__", "modulename": "smartinspectpython.sigraphicviewercontext", "qualname": "SIGraphicViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>id (SIGraphicId):</strong>  The graphic ID to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sigraphicid</span><span class=\"o\">.</span><span class=\"n\">SIGraphicId</span></span>)</span>"}, {"fullname": "smartinspectpython.siinfoeventargs", "modulename": "smartinspectpython.siinfoeventargs", "kind": "module", "doc": "<p>Module: siinfoeventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siinfoeventargs.SIInfoEventArgs", "modulename": "smartinspectpython.siinfoeventargs", "qualname": "SIInfoEventArgs", "kind": "class", "doc": "<p>Arguments passed to the SmartInspect.InfoEvent event.</p>\n\n<p>It has only one public class property named Message.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siinfoeventargs.SIInfoEventArgs.__init__", "modulename": "smartinspectpython.siinfoeventargs", "qualname": "SIInfoEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (str):</strong>  Informational message to convey.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, {"fullname": "smartinspectpython.siinfoeventargs.SIInfoEventArgs.Message", "modulename": "smartinspectpython.siinfoeventargs", "qualname": "SIInfoEventArgs.Message", "kind": "variable", "doc": "<p>Informational message to convey.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siinfoeventargs.SIInfoEventHandler", "modulename": "smartinspectpython.siinfoeventargs", "qualname": "SIInfoEventHandler", "kind": "class", "doc": "<p>Event handler type for the SmartInspect.InfoEvent event.</p>\n"}, {"fullname": "smartinspectpython.siinfoeventargs.SIInfoEventHandler.__init__", "modulename": "smartinspectpython.siinfoeventargs", "qualname": "SIInfoEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIInfoEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siinfoeventargs</span><span class=\"o\">.</span><span class=\"n\">SIInfoEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.siinspectorviewercontext", "modulename": "smartinspectpython.siinspectorviewercontext", "kind": "module", "doc": "<p>Module: siinspectorviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siinspectorviewercontext.SIInspectorViewerContext", "modulename": "smartinspectpython.siinspectorviewercontext", "qualname": "SIInspectorViewerContext", "kind": "class", "doc": "<p>Represents the inspector viewer in the Console which displays key/value pairs in \nan object inspector control.</p>\n\n<p>The inspector viewer in the Console interprets the Log Entry Data as a key/value list with\ngroup support like object inspectors from popular IDEs. This class takes care of the necessary \nformatting and escaping required by the corresponding inspector viewer in the Console.</p>\n\n<p>You can use the SIInspectorViewerContext class for creating custom log methods around \nSISession.LogCustomContext for sending custom data organized as grouped key/value pairs.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sivaluelistviewercontext.SIValueListViewerContext"}, {"fullname": "smartinspectpython.siinspectorviewercontext.SIInspectorViewerContext.__init__", "modulename": "smartinspectpython.siinspectorviewercontext", "qualname": "SIInspectorViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.siinspectorviewercontext.SIInspectorViewerContext.EscapeItem", "modulename": "smartinspectpython.siinspectorviewercontext", "qualname": "SIInspectorViewerContext.EscapeItem", "kind": "function", "doc": "<p>Overridden. Escapes a key or a value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>item (str):</strong>  The key or value to escape.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The escaped key or value.</p>\n</blockquote>\n\n<p>This method ensures that the escaped key or value does\nnot contain any newline characters, such as the carriage\nreturn or linefeed characters. Furthermore, it escapes\nthe '', '=', '[' and ']' characters.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">item</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siinspectorviewercontext.SIInspectorViewerContext.StartGroup", "modulename": "smartinspectpython.siinspectorviewercontext", "qualname": "SIInspectorViewerContext.StartGroup", "kind": "function", "doc": "<p>Starts a new group.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>group (str):</strong>  The name of the group to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">group</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siinvalidconnectionsexception", "modulename": "smartinspectpython.siinvalidconnectionsexception", "kind": "module", "doc": "<p>Module: siinvalidconnectionsexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siinvalidconnectionsexception.SIInvalidConnectionsException", "modulename": "smartinspectpython.siinvalidconnectionsexception", "qualname": "SIInvalidConnectionsException", "kind": "class", "doc": "<p>Used to report errors concerning the connections string in the\nSmartInspect class.</p>\n\n<p>An invalid syntax, unknown protocols or inexistent options in the\nSmartInspect.Connections property value will result in\nan SIInvalidConnectionsException exception.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "builtins.Exception"}, {"fullname": "smartinspectpython.siinvalidconnectionsexception.SIInvalidConnectionsException.__init__", "modulename": "smartinspectpython.siinvalidconnectionsexception", "qualname": "SIInvalidConnectionsException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (Any):</strong>  The exception message.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">message</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, {"fullname": "smartinspectpython.silevel", "modulename": "smartinspectpython.silevel", "kind": "module", "doc": "<p>Module: silevel.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.silevel.SILevel", "modulename": "smartinspectpython.silevel", "qualname": "SILevel", "kind": "class", "doc": "<p>Represents the log level in the SmartInspect Python3 library.</p>\n\n<p>Please see the Level and DefaultLevel properties for detailed \nexamples and more information on how to use the Level enum.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.silevel.SILevel.Debug", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Debug", "kind": "variable", "doc": "<p>Represents the Debug log level. </p>\n\n<p>This log level is mostly intended to be used in the debug and development process.</p>\n", "default_value": "&lt;SILevel.Debug: 0&gt;"}, {"fullname": "smartinspectpython.silevel.SILevel.Verbose", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Verbose", "kind": "variable", "doc": "<p>Represents the Verbose log level. </p>\n\n<p>This log level is intended to track the general progress of applications at a\nfine-grained level.</p>\n", "default_value": "&lt;SILevel.Verbose: 1&gt;"}, {"fullname": "smartinspectpython.silevel.SILevel.Message", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Message", "kind": "variable", "doc": "<p>Represents the Message log level. </p>\n\n<p>This log level is intended to track the general progress of applications at a coarse-grained level.</p>\n", "default_value": "&lt;SILevel.Message: 2&gt;"}, {"fullname": "smartinspectpython.silevel.SILevel.Warning", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Warning", "kind": "variable", "doc": "<p>Represents the Warning log level. </p>\n\n<p>This log level designates potentially harmful events or situations.</p>\n", "default_value": "&lt;SILevel.Warning: 3&gt;"}, {"fullname": "smartinspectpython.silevel.SILevel.Error", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Error", "kind": "variable", "doc": "<p>Represents the Error log level. </p>\n\n<p>This log level designates error events or situations which are not critical to the\nentire system. This log level thus describes recoverable or less important errors.</p>\n", "default_value": "&lt;SILevel.Error: 4&gt;"}, {"fullname": "smartinspectpython.silevel.SILevel.Fatal", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Fatal", "kind": "variable", "doc": "<p>Represents the Fatal log level. </p>\n\n<p>This log level designates errors which are not recoverable and eventually stop the\nsystem or application from working.</p>\n", "default_value": "&lt;SILevel.Fatal: 5&gt;"}, {"fullname": "smartinspectpython.silevel.SILevel.Control", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Control", "kind": "variable", "doc": "<p>Represents the Control Command log level. </p>\n\n<p>This log level represents a special log level which is only used by the SIControlCommand \nclass and is not intended to be used directly.</p>\n", "default_value": "&lt;SILevel.Control: 6&gt;"}, {"fullname": "smartinspectpython.silevel.SILevel.Parse", "modulename": "smartinspectpython.silevel", "qualname": "SILevel.Parse", "kind": "function", "doc": "<p>Returns an enum value for the given string representation if found,\notherwise the default value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The string representation of the enum value.</li>\n<li><strong>defaultValue:</strong>  The value to use if an enum could not be determined from the value.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A new Level instance if Parse was successful; otherwise, the defaultValue Level.</p>\n</blockquote>\n\n<p>Both the Name and Value of the enum are compared for a match.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silistviewercontext", "modulename": "smartinspectpython.silistviewercontext", "kind": "module", "doc": "<p>Module: silistviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.silistviewercontext.SIListViewerContext", "modulename": "smartinspectpython.silistviewercontext", "qualname": "SIListViewerContext", "kind": "class", "doc": "<p>Represents the list viewer in the Console which can display simple lists of text data.</p>\n\n<p>The list viewer in the Console interprets the Log Entry Data as a list. \nEvery line in the text data is interpreted as one item of the list. \nThis class takes care of the necessary formatting and escaping required \nby the corresponding list viewer in the Console.</p>\n\n<p>You can use the SIListViewerContext class for creating custom\nlog methods around SISession.LogCustomContext\nfor sending custom data organized as simple lists.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sitextcontext.SITextContext"}, {"fullname": "smartinspectpython.silistviewercontext.SIListViewerContext.__init__", "modulename": "smartinspectpython.silistviewercontext", "qualname": "SIListViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>vi (SIViewerId):</strong>  The viewer ID to use; if None, then ViewId.List is used.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "smartinspectpython.silistviewercontext.SIListViewerContext.EscapeLine", "modulename": "smartinspectpython.silistviewercontext", "qualname": "SIListViewerContext.EscapeLine", "kind": "function", "doc": "<p>Escapes a line.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>line (str):</strong>  The line to escape.</li>\n<li><strong>toEscape (str):</strong>  A set of characters which should be escaped in addition\nto the newline characters, or an empty string if there are none.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The escaped line.</p>\n</blockquote>\n\n<p>This method ensures that the escaped line does not\ncontain characters listed in the toEscape parameter plus\nany newline characters, such as the carriage return or\nlinefeed characters.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">toEscape</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siloadconfigurationexception", "modulename": "smartinspectpython.siloadconfigurationexception", "kind": "module", "doc": "<p>Module: siloadconfigurationexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siloadconfigurationexception.SILoadConfigurationException", "modulename": "smartinspectpython.siloadconfigurationexception", "qualname": "SILoadConfigurationException", "kind": "class", "doc": "<p>Used to report errors concerning the SmartInspect.LoadConfiguration method.</p>\n\n<p>This exception is used to report errors concerning the\nSmartInspect.LoadConfiguration method. This method is able to load\nthe SmartInspect properties from a file. Therefore errors can occur\nwhen trying to load properties from an inexistent file or when the\nfile can not be opened for reading, for example.</p>\n\n<p>If such an error occurs, an instance of this class will be passed\nto the SmartInspect.Error event. Please note, that, if a connections\nstring can be read while loading the configuration file, but is\nfound to be invalid then this exception type will not be used. In\nthis case, the SmartInspect.LoadConfiguration method will use the\nSIInvalidConnectionsException exception instead.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "builtins.Exception"}, {"fullname": "smartinspectpython.siloadconfigurationexception.SILoadConfigurationException.__init__", "modulename": "smartinspectpython.siloadconfigurationexception", "qualname": "SILoadConfigurationException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (Any):</strong>  The exception message.</li>\n<li><strong>fileName (str):</strong>  The filename that contained the configuration settings.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">message</span>, </span><span class=\"param\"><span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, {"fullname": "smartinspectpython.siloadconfigurationexception.SILoadConfigurationException.FileName", "modulename": "smartinspectpython.siloadconfigurationexception", "qualname": "SILoadConfigurationException.FileName", "kind": "variable", "doc": "<p>Gets the FileName property value.</p>\n\n<p>Name of the file which caused this exception\nwhile trying to load the SmartInspect properties from it.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siloadconnectionsexception", "modulename": "smartinspectpython.siloadconnectionsexception", "kind": "module", "doc": "<p>Module: siloadconnectionsexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siloadconnectionsexception.SILoadConnectionsException", "modulename": "smartinspectpython.siloadconnectionsexception", "qualname": "SILoadConnectionsException", "kind": "class", "doc": "<p>Used to report errors concerning the SmartInspect.LoadConnections method.</p>\n\n<p>This exception is used to report errors concerning the\nSmartInspect.LoadConnections method. This method is able to load\na SmartInspect.Connections from a file.\nTherefore errors can occur when trying to load a connections string\nfrom an inexistent file or when the file can not be opened for\nreading, for example.</p>\n\n<p>If such an error occurs, an instance of this class will be passed\nto the SmartInspect.Error event. Please note, that, if a connections\nstring can be read correctly, but is found to be invalid then this\nexception type will not be used. The SmartInspect.LoadConnections\nmethod will use the SIInvalidConnectionsException exception instead.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "builtins.Exception"}, {"fullname": "smartinspectpython.siloadconnectionsexception.SILoadConnectionsException.__init__", "modulename": "smartinspectpython.siloadconnectionsexception", "qualname": "SILoadConnectionsException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (Any):</strong>  The exception message.</li>\n<li><strong>fileName (str):</strong>  The filename that contained the connections string.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">message</span>, </span><span class=\"param\"><span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, {"fullname": "smartinspectpython.siloadconnectionsexception.SILoadConnectionsException.FileName", "modulename": "smartinspectpython.siloadconnectionsexception", "qualname": "SILoadConnectionsException.FileName", "kind": "variable", "doc": "<p>Gets the FileName property value.</p>\n\n<p>The name of the file which caused this exception\nwhile trying to load the connections string from it.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogentry", "modulename": "smartinspectpython.silogentry", "kind": "module", "doc": "<p>Module: silogentry.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.silogentry.SILogEntry", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry", "kind": "class", "doc": "<p>Represents the Log Entry packet type which is used for nearly\nall logging methods in the SISession class.</p>\n\n<p>A Log Entry is the most important packet available in the\nSmartInspect concept. It is used for almost all logging methods\nin the SISession class, like, for example, SISession.LogMessage,\nSISession.LogObject or SISession.LogSql.</p>\n\n<p>A Log Entry has several properties which describe its creation\ncontext (like a thread ID, time-stamp or host name) and other\nproperties which specify the way the Console interprets this packet\n(like the viewer ID or the background color). Furthermore a Log\nEntry contains the actual data which will be displayed in the\nConsole.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe. However, instances\n  of this class will normally only be used in the context of a single\n  thread.</p>\n</blockquote>\n", "bases": "smartinspectpython.sipacket.SIPacket"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.__init__", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.__init__", "kind": "function", "doc": "<p>Initializes a new SILogEntry instance with\na custom log entry type and custom viewer ID.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>logEntryType (SILogEntryType):</strong>  The type of the new Log Entry describes the way the Console\ninterprets this packet. Please see the SILogEntryType enum for\nmore information.</li>\n<li><strong>viewerId (SIViewerId):</strong>  The viewer ID of the new Log Entry describes which viewer\nshould be used in the Console when displaying the data of\nthis Log Entry. Please see the SIViewerId enum for more information.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">logEntryType</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentrytype</span><span class=\"o\">.</span><span class=\"n\">SILogEntryType</span>,</span><span class=\"param\">\t<span class=\"n\">viewerId</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span></span>)</span>"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.AppName", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.AppName", "kind": "variable", "doc": "<p>Gets the AppName property value.</p>\n\n<p>Represents the application name of this Log Entry.</p>\n\n<p>The application name of a Log Entry is usually set to the\nname of the application this Log Entry is created in. It will\nbe empty in the SmartInspect Console when this property is set\nto null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.ColorBG", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.ColorBG", "kind": "variable", "doc": "<p>Gets the ColorBG property value.</p>\n\n<p>Represents the background color of this Log Entry.</p>\n\n<p>The background color of a Log Entry is normally set to the\ncolor of the session which sent this Log Entry.</p>\n", "annotation": ": smartinspectpython.sicolor.SIColor"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.Data", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.Data", "kind": "variable", "doc": "<p>Gets the Data property value.</p>\n\n<p>This property contains an optional data stream of the Log Entry.\nThis property can be null if this Log Entry does not\ncontain additional data.</p>\n\n<p><b>Important:</b> Treat this stream as read-only. This means,\nmodifying this stream in any way is not supported. Additionally,\nonly pass streams which support seeking. Streams which do not\nsupport seeking cannot be used by this class.</p>\n", "annotation": ": _io.BytesIO"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.DataLength", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.DataLength", "kind": "variable", "doc": "<p>Returns the number of bytes used in the Data property.\nNote that this is the actual # of bytes used, and not the # of bytes allocated!</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.HasData", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.HasData", "kind": "variable", "doc": "<p>Returns true if this packet contains optional data; otherwise, false.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.HostName", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.HostName", "kind": "variable", "doc": "<p>Gets the HostName property value.</p>\n\n<p>Represents the host name of this Log Entry.</p>\n\n<p>The host name of a Log Entry is usually set to the name of\nthe machine this Log Entry is sent from. It will be empty in\nthe SmartInspect Console when this property is set to null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.LogEntryType", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.LogEntryType", "kind": "variable", "doc": "<p>Gets the LogEntryType property value.</p>\n\n<p>Represents the type of this Log Entry.</p>\n\n<p>The type of this Log Entry describes the way the Console\ninterprets this packet. Please see the SILogEntryType enum for more\ninformation.</p>\n", "annotation": ": smartinspectpython.silogentrytype.SILogEntryType"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.PacketType", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.PacketType", "kind": "variable", "doc": "<p>Overridden.  Returns SIPacketType.LogEntry</p>\n", "annotation": ": smartinspectpython.sipackettype.SIPacketType"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.ProcessId", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.ProcessId", "kind": "variable", "doc": "<p>Gets the ProcessId property value.</p>\n\n<p>Represents the ID of the process this object was created in.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.SessionName", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.SessionName", "kind": "variable", "doc": "<p>Gets the SessionName property value.</p>\n\n<p>Represents the session name of this Log Entry.</p>\n\n<p>The session name of a Log Entry is normally set to the name\nof the session which sent this Log Entry. It will be empty in\nthe SmartInspect Console when this property is set to null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.Size", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.Size", "kind": "variable", "doc": "<p>Overridden. Returns the total occupied memory size of this Log Entry packet.</p>\n\n<p>The total occupied memory size of this Log Entry is the size\nof memory occupied by all strings, the optional Data stream\nand any internal data structures of this Log Entry.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.ThreadId", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.ThreadId", "kind": "variable", "doc": "<p>Gets the ThreadId property value.</p>\n\n<p>Represents the ID of the thread this object was created in.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.Timestamp", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.Timestamp", "kind": "variable", "doc": "<p>Gets the Timestamp property value.</p>\n\n<p>Represents the time-stamp of this Log Entry object.</p>\n\n<p>This property returns the creation time of this Log Entry object.</p>\n", "annotation": ": datetime.datetime"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.Title", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.Title", "kind": "variable", "doc": "<p>Gets the Title property value.</p>\n\n<p>Represents the title of this Log Entry.</p>\n\n<p>The title of this Log Entry will be empty in the SmartInspect\nConsole when this property is set to null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogentry.SILogEntry.ViewerId", "modulename": "smartinspectpython.silogentry", "qualname": "SILogEntry.ViewerId", "kind": "variable", "doc": "<p>Gets the ViewerId property value.</p>\n\n<p>Represents the viewer ID of this Log Entry.</p>\n\n<p>The viewer ID of the Log Entry describes which viewer should\nbe used in the Console when displaying the data of this Log\nEntry. Please see the SIViewerId enum for more information.</p>\n", "annotation": ": smartinspectpython.siviewerid.SIViewerId"}, {"fullname": "smartinspectpython.silogentryeventargs", "modulename": "smartinspectpython.silogentryeventargs", "kind": "module", "doc": "<p>Module: silogentryeventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.silogentryeventargs.SILogEntryEventArgs", "modulename": "smartinspectpython.silogentryeventargs", "qualname": "SILogEntryEventArgs", "kind": "class", "doc": "<p>This class is used by the SmartInspect.LogEntry event.</p>\n\n<p>It has only one public class member named LogEntry. This member\nis a property, which just returns the sent packet.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.silogentryeventargs.SILogEntryEventArgs.__init__", "modulename": "smartinspectpython.silogentryeventargs", "qualname": "SILogEntryEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>logEntry (SILogEntry):</strong>  The Log Entry packet which caused the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">logEntry</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentry</span><span class=\"o\">.</span><span class=\"n\">SILogEntry</span></span>)</span>"}, {"fullname": "smartinspectpython.silogentryeventargs.SILogEntryEventArgs.LogEntry", "modulename": "smartinspectpython.silogentryeventargs", "qualname": "SILogEntryEventArgs.LogEntry", "kind": "variable", "doc": "<p>Returns the LogEntry packet, which has just been sent.</p>\n", "annotation": ": smartinspectpython.silogentry.SILogEntry"}, {"fullname": "smartinspectpython.silogentryeventargs.SILogEntryEventHandler", "modulename": "smartinspectpython.silogentryeventargs", "qualname": "SILogEntryEventHandler", "kind": "class", "doc": "<p>This is the event handler type for the SmartInspect.LogEntryEvent event.</p>\n"}, {"fullname": "smartinspectpython.silogentryeventargs.SILogEntryEventHandler.__init__", "modulename": "smartinspectpython.silogentryeventargs", "qualname": "SILogEntryEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (LogEntryEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentryeventargs</span><span class=\"o\">.</span><span class=\"n\">SILogEntryEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.silogentrytype", "modulename": "smartinspectpython.silogentrytype", "kind": "module", "doc": "<p>Module: silogentrytype.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType", "kind": "class", "doc": "<p>Represents the type of a Log Entry packet. Instructs the Console\nto choose the correct icon and to perform additional actions,\nlike, for example, enter a new method or draw a separator.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Separator", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Separator", "kind": "variable", "doc": "<p>Instructs the Console to draw a separator.</p>\n", "default_value": "&lt;SILogEntryType.Separator: 0&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.EnterMethod", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.EnterMethod", "kind": "variable", "doc": "<p>Instructs the Console to enter a new method.</p>\n", "default_value": "&lt;SILogEntryType.EnterMethod: 1&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.LeaveMethod", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.LeaveMethod", "kind": "variable", "doc": "<p>Instructs the Console to leave a method.</p>\n", "default_value": "&lt;SILogEntryType.LeaveMethod: 2&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.ResetCallstack", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.ResetCallstack", "kind": "variable", "doc": "<p>Instructs the Console to reset the current call stack.</p>\n", "default_value": "&lt;SILogEntryType.ResetCallstack: 3&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Message", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Message", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as simple message.</p>\n", "default_value": "&lt;SILogEntryType.Message: 100&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Warning", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Warning", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as warning message.</p>\n", "default_value": "&lt;SILogEntryType.Warning: 101&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Error", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Error", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as error message.</p>\n", "default_value": "&lt;SILogEntryType.Error: 102&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.InternalError", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.InternalError", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as internal error.</p>\n", "default_value": "&lt;SILogEntryType.InternalError: 103&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Comment", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Comment", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as comment.</p>\n", "default_value": "&lt;SILogEntryType.Comment: 104&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.VariableValue", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.VariableValue", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as a variable value.</p>\n", "default_value": "&lt;SILogEntryType.VariableValue: 105&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Checkpoint", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Checkpoint", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as checkpoint.</p>\n", "default_value": "&lt;SILogEntryType.Checkpoint: 106&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Debug", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Debug", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as debug message.</p>\n", "default_value": "&lt;SILogEntryType.Debug: 107&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Verbose", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Verbose", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as verbose message.</p>\n", "default_value": "&lt;SILogEntryType.Verbose: 108&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Fatal", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Fatal", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as fatal error message.</p>\n", "default_value": "&lt;SILogEntryType.Fatal: 109&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Conditional", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Conditional", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as conditional message.</p>\n", "default_value": "&lt;SILogEntryType.Conditional: 110&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Assert", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Assert", "kind": "variable", "doc": "<p>Instructs the Console to treat a Log Entry as assert message.</p>\n", "default_value": "&lt;SILogEntryType.Assert: 111&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Text", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Text", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry with text.</p>\n", "default_value": "&lt;SILogEntryType.Text: 200&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Binary", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Binary", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry with binary data.</p>\n", "default_value": "&lt;SILogEntryType.Binary: 201&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Graphic", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Graphic", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith a picture as data.</p>\n", "default_value": "&lt;SILogEntryType.Graphic: 202&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Source", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Source", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith source code data.</p>\n", "default_value": "&lt;SILogEntryType.Source: 203&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.Object", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.Object", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith object data.</p>\n", "default_value": "&lt;SILogEntryType.Object: 204&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.WebContent", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.WebContent", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith web data.</p>\n", "default_value": "&lt;SILogEntryType.WebContent: 205&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.System", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.System", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith system information.</p>\n", "default_value": "&lt;SILogEntryType.System: 206&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.MemoryStatistic", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.MemoryStatistic", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith memory statistics.</p>\n", "default_value": "&lt;SILogEntryType.MemoryStatistic: 207&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.DatabaseResult", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.DatabaseResult", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith a database result.</p>\n", "default_value": "&lt;SILogEntryType.DatabaseResult: 208&gt;"}, {"fullname": "smartinspectpython.silogentrytype.SILogEntryType.DatabaseStructure", "modulename": "smartinspectpython.silogentrytype", "qualname": "SILogEntryType.DatabaseStructure", "kind": "variable", "doc": "<p>Instructs the Console to treat the Log Entry as Log Entry\nwith a database structure.</p>\n", "default_value": "&lt;SILogEntryType.DatabaseStructure: 209&gt;"}, {"fullname": "smartinspectpython.silogheader", "modulename": "smartinspectpython.silogheader", "kind": "module", "doc": "<p>Module: silogheader.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.silogheader.SILogHeader", "modulename": "smartinspectpython.silogheader", "qualname": "SILogHeader", "kind": "class", "doc": "<p>Represents the Log Header packet type which is used for storing\nand transferring log metadata.</p>\n\n<p>The SILogHeader class is used to store and transfer log metadata.\nAfter the SIPipeProtocol or SITcpProtocol has established a connection,\na Log Header packet with the metadata of the current logging\ncontext is created and written. Log Header packets are used by\nthe SmartInspect Router application for its filter and trigger\nfunctionality.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe. However, instances\n  of this class will normally only be used in the context of a single thread.</p>\n</blockquote>\n", "bases": "smartinspectpython.sipacket.SIPacket"}, {"fullname": "smartinspectpython.silogheader.SILogHeader.__init__", "modulename": "smartinspectpython.silogheader", "qualname": "SILogHeader.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.silogheader.SILogHeader.AppName", "modulename": "smartinspectpython.silogheader", "qualname": "SILogHeader.AppName", "kind": "variable", "doc": "<p>Gets the AppName property value.</p>\n\n<p>Represents the application name of this Log Header.</p>\n\n<p>The application name of a Log Header is usually set to the\nname of the application this Log Header is created in.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogheader.SILogHeader.Content", "modulename": "smartinspectpython.silogheader", "qualname": "SILogHeader.Content", "kind": "variable", "doc": "<p>Gets the Content property value.</p>\n\n<p>Represents the entire content of this Log Header packet.</p>\n\n<p>The content of a Log Header packet is a key-value (syntax:\nkey=value) list of the properties of this Log Header packet\n(currently only the AppName and the HostName strings).\nKey-value pairs are separated by carriage return and newline\ncharacters.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogheader.SILogHeader.HostName", "modulename": "smartinspectpython.silogheader", "qualname": "SILogHeader.HostName", "kind": "variable", "doc": "<p>Gets the HostName property value.</p>\n\n<p>Represents the hostname of this Log Header.</p>\n\n<p>The hostname of a Log Header is usually set to the name of\nthe machine this Log Header is sent from.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.silogheader.SILogHeader.PacketType", "modulename": "smartinspectpython.silogheader", "qualname": "SILogHeader.PacketType", "kind": "variable", "doc": "<p>Overridden.  Returns SIPacketType.LogHeader.</p>\n", "annotation": ": smartinspectpython.sipackettype.SIPacketType"}, {"fullname": "smartinspectpython.silogheader.SILogHeader.Size", "modulename": "smartinspectpython.silogheader", "qualname": "SILogHeader.Size", "kind": "variable", "doc": "<p>Overridden. Returns the total occupied memory size of this Log Header packet (including header length).</p>\n\n<p>The total occupied memory size of this Log Header is the size\nof memory occupied by all strings and any internal data\nstructures of this Log Header.  Also note that the data\nis in UTF-8 encoding, so it takes up twice the storage as\nASCII encoding.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.silookuptable", "modulename": "smartinspectpython.silookuptable", "kind": "module", "doc": "<p>Module: silookuptable.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable", "kind": "class", "doc": "<p>Represents a simple collection of key/value pairs.</p>\n\n<p>The SILookupTable class is responsible for storing and returning\nvalues which are organized by keys. Values can be added with\nthe Put method. To query a String value for a given key, the\nGetStringValue method can be used. To query and automatically\nconvert values to types other than String, please have a look\nat the Get method family.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.__init__", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.Count", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.Count", "kind": "variable", "doc": "<p>Returns the number of key/value pairs of this collection.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.Add", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.Add", "kind": "function", "doc": "<p>Adds a new element with a specified key and value to the Lookup Table.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the element.</li>\n<li><strong>value (str):</strong>  The value of the element.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key or value argument is null.</li>\n</ul>\n\n<p>This method adds a new element with a given key and value to\nthe collection of key/value pairs. If an element for the\ngiven key already exists, the original element's value is\nnot updated.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.Clear", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.Clear", "kind": "function", "doc": "<p>Removes all key/value pairs of the collection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.Contains", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.Contains", "kind": "function", "doc": "<p>Tests if the collection contains a value for a given key. </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key to test for.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if a value exists for the given key and false otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetBooleanValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetBooleanValue", "kind": "function", "doc": "<p>Returns a value of an element converted to a bool for a\ngiven key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (bool):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a bool for the given key if an\n  element with the given key exists or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns a bool value of true if the found value\nof the given key matches either \"true\", \"1\" or \"yes\" and false\notherwise. If the supplied key is unknown, the defaultValue\nargument is returned.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetBytesValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetBytesValue", "kind": "function", "doc": "<p>Returns a byte array value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>size (int):</strong>  The desired size in bytes of the returned byte array. If\nthe element value does not have the expected size, it is\nshortened or padded automatically.</li>\n<li><strong>defaultValue (bytearrau):</strong>  The value to return if the given key is unknown or if the\nfound value has an invalid format.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a byte array for the given key\n  if an element with the given key exists and the found value\n  has a valid format or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"exception\">Exception:</h6>\n\n<blockquote>\n  <p>SIArgumentNullException:\n      The key argument is null.</p>\n</blockquote>\n\n<p>The returned byte array always has the desired length as\nspecified by the size argument. If the element value does\nnot have the required size after conversion, it is shortened\nor padded (with zeros) automatically. This method returns\nthe defaultValue argument if either the supplied key is\nunknown or the found value does not have a valid format\n(e.g. invalid characters when using hexadecimal strings).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">bytearray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bytearray</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetColorValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetColorValue", "kind": "function", "doc": "<p>Returns a color value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (SIColor):</strong>  The value to return if the given key is unknown or if the\nfound value has an invalid format.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a Color value for the given key\n  if an element with the given key exists and the found value\n  has a valid format or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n<li><strong>ArgumentError:</strong>  The read value is not a valid color value representation.</li>\n</ul>\n\n<p>The element value must be specified as hexadecimal string.\nTo indicate that the element value represents a hexadecimal\nstring, the element value must begin with \"0x\", \"&amp;H\" or \"$\".\nA '0' nibble is appended if the hexadecimal string has an odd\nlength.</p>\n\n<p>The hexadecimal value must represent a three or four byte\ninteger value. The hexadecimal value is handled as follows.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Bytes</th>\n  <th>Format</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>3</td>\n  <td>RRGGBB</td>\n</tr>\n<tr>\n  <td>4</td>\n  <td>AARRGGBB</td>\n</tr>\n<tr>\n  <td>Other</td>\n  <td>Ignored</td>\n</tr>\n</tbody>\n</table>\n\n<p>A stands for the alpha channel and R, G and B represent the\nred, green and blue channels, respectively. If the value is not\ngiven as hexadecimal value with a length of 6 or 8 characters\nexcluding the hexadecimal prefix identifier or if the value\ndoes not have a valid hexadecimal format, this method returns\ndefaultValue.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColor</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColor</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetIntegerValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetIntegerValue", "kind": "function", "doc": "<p>Returns a value of an element converted to an integer for a\ngiven key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>(str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (int):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to an integer for the given key if\n  an element with the given key exists and the found value is a\n  valid integer or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>Only non-negative integer values are recognized as valid.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetLevelValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetLevelValue", "kind": "function", "doc": "<p>Returns a value of an element converted to a Level value for\na given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (SILevel):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to the corresponding Level value for\n  the given key if an element with the given key exists and the\n  found value is a valid Level value or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid Level\nvalue. Please see the Level enum for more information on the\navailable values.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetRotateValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetRotateValue", "kind": "function", "doc": "<p>Returns a value of an element converted to a SIFileRotate value for\na given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (SIFileRotate):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a SIFileRotate value for the\n  given key if an element with the given key exists and the found\n  value is a valid SIFileRotate or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid SIFileRotate\nvalue. Please see the SIFileRotate enum for more information on the\navailable values.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sifilerotate</span><span class=\"o\">.</span><span class=\"n\">SIFileRotate</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sifilerotate</span><span class=\"o\">.</span><span class=\"n\">SIFileRotate</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetSizeValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetSizeValue", "kind": "function", "doc": "<p>Returns a value of an element converted to an integer for a\ngiven key. The integer value is interpreted as a byte size and\nit is supported to specify byte units.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (int):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to an integer for the given key if\n  an element with the given key exists and the found value is a\n  valid integer or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid\ninteger or ends with an unknown byte unit. Only non-negative\ninteger values are recognized as valid.</p>\n\n<p>It is possible to specify a size unit at the end of the value.\nIf a known unit is found, this function multiplies the\nresulting value with the corresponding factor. For example, if\nthe value of the element is \"1KB\", the return value of this\nfunction would be 1024.</p>\n\n<p>The following table lists the available units together with a\nshort description and the corresponding factor.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Unit Name / Factor</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>KB / 1024</td>\n  <td>KiloByte</td>\n</tr>\n<tr>\n  <td>MB / 1024^2</td>\n  <td>MegaByte</td>\n</tr>\n<tr>\n  <td>GB / 1024^3</td>\n  <td>GigaByte</td>\n</tr>\n</tbody>\n</table>\n\n<p>If no unit is specified, this function defaults to the KB unit.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetStringValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetStringValue", "kind": "function", "doc": "<p>Returns a string value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (str):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The value for a given key if an element with the given\n  key exists; otherwise, the defaultValue.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.GetTimespanValue", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.GetTimespanValue", "kind": "function", "doc": "<p>Returns a value of an element converted to an integer for a\ngiven key. The integer value is interpreted as a time span\nand it is supported to specify time span units.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (int):</strong>  The value to return if the given key is unknown.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to an integer for the given key if\n  an element with the given key exists and the found value is a\n  valid integer or defaultValue otherwise. The value is returned\n  in milliseconds.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid\ninteger or ends with an unknown time span unit.</p>\n\n<p>It is possible to specify a time span unit at the end of the\nvalue. If a known unit is found, this function multiplies the\nresulting value with the corresponding factor. For example, if\nthe value of the element is \"1s\", the return value of this\nfunction would be 1000.</p>\n\n<p>The following table lists the available units together with a\nshort description and the corresponding factor.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Unit Name / Factor</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>s (seconds)</td>\n  <td>1000</td>\n</tr>\n<tr>\n  <td>m (minutes)</td>\n  <td>60*s</td>\n</tr>\n<tr>\n  <td>h (hours)</td>\n  <td>60*m</td>\n</tr>\n<tr>\n  <td>d (days)</td>\n  <td>24*h</td>\n</tr>\n</tbody>\n</table>\n\n<p>If no unit is specified, this function defaults to the Seconds\nunit. Please note that the value is always returned in\nmilliseconds.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.IsValidInteger", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.IsValidInteger", "kind": "function", "doc": "<p>Checks to see if the supplied value is numeric or not.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The value to check.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the value is numeric; otherwise, false.</p>\n</blockquote>\n\n<p>Only non-negative whole integer values are recognized as numeric.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.IsValidSizeUnit", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.IsValidSizeUnit", "kind": "function", "doc": "<p>Checks to see if the supplied value is a valid size unit or not.\nValid size units are: kb, mb, and gb.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The value to check.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the value is valid; otherwise, false.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.IsValidTimespanUnit", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.IsValidTimespanUnit", "kind": "function", "doc": "<p>Checks to see if the supplied value is a valid timespan unit or not.\nValid units are: s, m, h, and d.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The value to check.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the value is valid; otherwise, false.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.Put", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.Put", "kind": "function", "doc": "<p>Adds or updates an element with a specified key and value\nto the Lookup Table.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the element.</li>\n<li><strong>value (str):</strong>  The value of the element.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key or value argument is null.</li>\n</ul>\n\n<p>This method adds a new element with a given key and value to\nthe collection of key/value pairs. If an element for the\ngiven key already exists, the original element's value is\nupdated.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.silookuptable.SILookupTable.Remove", "modulename": "smartinspectpython.silookuptable", "qualname": "SILookupTable.Remove", "kind": "function", "doc": "<p>Removes an existing element with a given key from this lookup table.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the element to remove.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method removes the element with the given key from the\ninternal list. Nothing happens if no element with the given\nkey can be found.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.simemoryprotocol", "modulename": "smartinspectpython.simemoryprotocol", "kind": "module", "doc": "<p>Module: simemoryprotocol.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol", "kind": "class", "doc": "<p>Used for writing log data to memory and saving it to a stream\nor another protocol object on request.\nTo initiate such a request, use the InternalDispatch method.</p>\n\n<p>SITextProtocol is used for writing plain text log files. The SIMemoryProtocol class is used when \nthe 'mem' protocol is specified in the SmartInspect.Connections. See the \nIsValidOption method for a list of available protocol options.</p>\n\n<p>For a list of available protocol options, please refer to the\nIsValidOption method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siprotocol.SIProtocol"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.__init__", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.Name", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.Name", "kind": "variable", "doc": "<p>Overridden.  Returns \"mem\".</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.BuildOptions", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.BuildOptions", "kind": "function", "doc": "<p>Overridden. Fills a SIConnectionsBuilder instance with the\noptions currently used by this protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>builder (SIConnectionsBuilder):</strong>  The SIConnectionsBuilder object to fill with the current options\nof this protocol.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">builder</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconnectionsbuilder</span><span class=\"o\">.</span><span class=\"n\">SIConnectionsBuilder</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.InternalConnect", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.InternalConnect", "kind": "function", "doc": "<p>Overridden. Creates and initializes the packet queue.</p>\n\n<p>This method creates and initializes a new packet queue with\na maximum size as specified by the Initialize method. For\nother valid options which might affect the behavior of this\nmethod and protocol, please see the IsValidOption method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.InternalDisconnect", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.InternalDisconnect", "kind": "function", "doc": "<p>Overridden.  Clears the internal queue of packets.</p>\n\n<p>This method does nothing more than to clear the internal\nqueue of packets. After this method has been called, the\nInternalDispatch method writes an empty log unless new\npackets are queued in the meantime.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.InternalDispatch", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.InternalDispatch", "kind": "function", "doc": "<p>Overridden. Implements a custom action for saving the current\nqueue of packets of this memory protocol to a stream or\nprotocol object.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>command (SIProtocolCommand):</strong>  The protocol command which is expected to provide the stream\nor protocol object.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Writing the internal queue of packets to the supplied stream or protocol failed.</li>\n</ul>\n\n<p>Depending on the supplied command argument, this method does\nthe following.</p>\n\n<p>If the supplied State object of the protocol command is of\ntype Stream, then this method uses this stream to write the\nentire content of the internal queue of packets. The necessary\nheader is written first and then the actual packets are\nappended.</p>\n\n<p>The header and packet output format can be influenced with\nthe \"astext\" protocol option (see IsValidOption). If the\n\"astext\" option is true, the header is a UTF8 Byte Order\nMark and the packets are written in plain text format. If\nthe \"astext\" option is false, the header is the standard\nheader for SmartInspect log files and the packets are\nwritten in the default binary mode. In the latter case, the\nresulting log files can be loaded by the SmartInspect Console.</p>\n\n<p>If the supplied State object of the protocol command is of\ntype Protocol instead, then this method uses this protocol\nobject to call its WritePacket method for each packet in the\ninternal packet queue.</p>\n\n<p>The Action property of the command argument should currently\nalways be set to 0. If the State object is not a stream or\nprotocol command or if the command argument is null, then\nthis method does nothing.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">command</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprotocolcommand</span><span class=\"o\">.</span><span class=\"n\">SIProtocolCommand</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.InternalWritePacket", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.InternalWritePacket", "kind": "function", "doc": "<p>Overridden. Writes a packet to the packet queue.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to write.</li>\n</ul>\n\n<p>This method writes the supplied packet to the internal\nqueue of packets. If the size of the queue exceeds the\nmaximum size as specified by the Options property, the\nqueue is automatically resized and older packets are\ndiscarded.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.IsValidOption", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.IsValidOption", "kind": "function", "doc": "<p>Overridden. Validates if a protocol option is supported.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The option name to validate.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the option is supported and false otherwise.</p>\n</blockquote>\n\n<p>The following table lists all valid options, their default values and descriptions for the TEXT protocol.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Valid Options (default value)</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>astext (false)</td>\n  <td>Specifies if logging data should be written as text instead of binary.</td>\n</tr>\n<tr>\n  <td>indent (false)</td>\n  <td>Indicates if the logging output should automatically be indented like in the Console if 'astext' is set to true.</td>\n</tr>\n<tr>\n  <td>maxsize (2048)</td>\n  <td>Specifies the maximum size of the packet queue of this protocol in kilobytes.  Specify size units like this: \"1 MB\".  Supported units are \"KB\", \"MB\" and \"GB\".</td>\n</tr>\n<tr>\n  <td>pattern (\"[%timestamp%] %level%: %title%\")</td>\n  <td>Specifies the pattern used to create a text representation of a packet.</td>\n</tr>\n</tbody>\n</table>\n\n<p>If the \"astext\" option is used for creating a textual output instead of the default binary, the \"pattern\" string specifies\nthe textual representation of a log packet. For detailed information of how a pattern string can look like, please\nhave a look at the documentation of the PatternParser class, especially the PatternParser.Pattern property.</p>\n\n<p>Please note that this protocol DOES NOT support log data encryption.</p>\n\n<p>For further options which affect the behavior of this protocol, please have a look at the documentation of the\nSIProtocol.IsValidOption method of the parent class.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># the following are sample SI Connections options for this protocol.</span>\n\n<span class=\"c1\"># log messages using all default options (binary log, no indent).</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;mem()&quot;</span>\n\n<span class=\"c1\"># log messages using max packet queue size of 8 MB.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;mem(maxsize=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">8MB</span><span class=\"se\">\\&quot;</span><span class=\"s2\">)&quot;</span>\n\n<span class=\"c1\"># log messages using text instead of binary.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;mem(astext=true)&quot;</span>\n\n<span class=\"c1\"># log messages using indented text and a custom pattern.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;mem(astext=true, indent=true, pattern=</span><span class=\"se\">\\&quot;</span><span class=\"si\">%le</span><span class=\"s2\">vel% [%timestamp%]: %title%</span><span class=\"se\">\\&quot;</span><span class=\"s2\">)&quot;</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.simemoryprotocol.SIMemoryProtocol.LoadOptions", "modulename": "smartinspectpython.simemoryprotocol", "qualname": "SIMemoryProtocol.LoadOptions", "kind": "function", "doc": "<p>Overridden. Loads and inspects specific options for this protocol.</p>\n\n<p>This method loads all relevant options and ensures their\ncorrectness. See IsValidOption for a list of options which\nare recognized by the protocol.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siobjectrenderer", "modulename": "smartinspectpython.siobjectrenderer", "kind": "module", "doc": "<p>Module: siobjectrenderer.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siobjectrenderer.SIObjectRenderer", "modulename": "smartinspectpython.siobjectrenderer", "qualname": "SIObjectRenderer", "kind": "class", "doc": "<p>Responsible for creating a string representation of any arbitrary object.</p>\n\n<p>This class provides only one method, RenderObject, which is\ncapable of creating a string representation of an object. It\nrenders dictionaries, collections or any other object.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public static members of this class are thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siobjectrenderer.SIObjectRenderer.__init__", "modulename": "smartinspectpython.siobjectrenderer", "qualname": "SIObjectRenderer.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.siobjectrenderer.SIObjectRenderer.RenderObject", "modulename": "smartinspectpython.siobjectrenderer", "qualname": "SIObjectRenderer.RenderObject", "kind": "function", "doc": "<p>Creates a string representation of an object.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>obj (object):</strong>  The object to render. Can be null.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A string representation of the supplied object.</p>\n</blockquote>\n\n<p>This method is capable of creating a string representation\nof an object. For most types this method simply calls the\n__str__ method of the supplied object. Some objects, like\ndictionaries or collections, are handled special.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"nb\">object</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sioptionfoundeventargs", "modulename": "smartinspectpython.sioptionfoundeventargs", "kind": "module", "doc": "<p>Module: sioptionfoundeventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sioptionfoundeventargs.SIOptionFoundEventArgs", "modulename": "smartinspectpython.sioptionfoundeventargs", "qualname": "SIOptionFoundEventArgs", "kind": "class", "doc": "<p>This class is used by the SIOptionsParser class to inform interested parties \nthat a protocol option has been found.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sioptionfoundeventargs.SIOptionFoundEventArgs.__init__", "modulename": "smartinspectpython.sioptionfoundeventargs", "qualname": "SIOptionFoundEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>protocol (str):</strong>  The protocol name of the new option.</li>\n<li><strong>key (str):</strong>  The key of the new option.</li>\n<li><strong>value (str):</strong>  The value of the new option.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">protocol</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, {"fullname": "smartinspectpython.sioptionfoundeventargs.SIOptionFoundEventArgs.Protocol", "modulename": "smartinspectpython.sioptionfoundeventargs", "qualname": "SIOptionFoundEventArgs.Protocol", "kind": "variable", "doc": "<p>This read-only property returns the protocol name of the option\nwhich has just been found by a SIOptionsParser object.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sioptionfoundeventargs.SIOptionFoundEventArgs.Key", "modulename": "smartinspectpython.sioptionfoundeventargs", "qualname": "SIOptionFoundEventArgs.Key", "kind": "variable", "doc": "<p>This read-only property returns the key of the option which\nhas just been found by a SIOptionsParser object.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sioptionfoundeventargs.SIOptionFoundEventArgs.Value", "modulename": "smartinspectpython.sioptionfoundeventargs", "qualname": "SIOptionFoundEventArgs.Value", "kind": "variable", "doc": "<p>This read-only property returns the value of the option which\nhas just been found by a SIOptionsParser object.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sioptionfoundeventargs.SIOptionFoundEventHandler", "modulename": "smartinspectpython.sioptionfoundeventargs", "qualname": "SIOptionFoundEventHandler", "kind": "class", "doc": "<p>This is the callback type for the SIOptionsParser.Parse method.</p>\n"}, {"fullname": "smartinspectpython.sioptionfoundeventargs.SIOptionFoundEventHandler.__init__", "modulename": "smartinspectpython.sioptionfoundeventargs", "qualname": "SIOptionFoundEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIOptionFoundEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sioptionfoundeventargs</span><span class=\"o\">.</span><span class=\"n\">SIOptionFoundEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.sioptionsparser", "modulename": "smartinspectpython.sioptionsparser", "kind": "module", "doc": "<p>Module: sioptionsparser.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sioptionsparser.SIOptionsParser", "modulename": "smartinspectpython.sioptionsparser", "qualname": "SIOptionsParser", "kind": "class", "doc": "<p>Responsible for parsing the options part of a SmartInspect\nconnections string.</p>\n\n<p>This class offers a single method only, called Parse, which\nis responsible for parsing the options part of a connections\nstring. This method informs the caller about found options\nby raising the OptionFound event.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sioptionsparser.SIOptionsParser.__init__", "modulename": "smartinspectpython.sioptionsparser", "qualname": "SIOptionsParser.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sioptionsparser.SIOptionsParser.OptionFoundEvent", "modulename": "smartinspectpython.sioptionsparser", "qualname": "SIOptionsParser.OptionFoundEvent", "kind": "variable", "doc": "<p>Event raised when an option key=value pair has been found.</p>\n", "annotation": ": smartinspectpython.siutils.Event"}, {"fullname": "smartinspectpython.sioptionsparser.SIOptionsParser.Parse", "modulename": "smartinspectpython.sioptionsparser", "qualname": "SIOptionsParser.Parse", "kind": "function", "doc": "<p>Parses the options part of a connections string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>protocol (str):</strong>  The related protocol. Not allowed to be null.</li>\n<li><strong>options (str):</strong>  The options to parse. Not allowed to be null.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The protocol or options argument is null.</li>\n<li><strong>SmartInspectException:</strong>  Invalid options string syntax.</li>\n</ul>\n\n<p>This method parses the supplied options part of a connections\nstring and informs the caller about found options via the\nOptionFound event.</p>\n\n<p>For information about the correct syntax of the options,\nplease refer to the documentation of the SIProtocol.Options\nproperty.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.sioptionsparser</span> <span class=\"kn\">import</span> <span class=\"n\">SIOptionsParser</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.sioptionfoundeventargs</span> <span class=\"kn\">import</span> <span class=\"n\">SIOptionFoundEventArgs</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Test Script Starting.</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">AddOption</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">args</span><span class=\"p\">:</span><span class=\"n\">SIOptionFoundEventArgs</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Protocol Option Found: </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">args</span><span class=\"p\">)))</span>\n\n<span class=\"c1\"># create parser class and wire up events.</span>\n<span class=\"n\">parser</span><span class=\"p\">:</span><span class=\"n\">SIOptionsParser</span> <span class=\"o\">=</span> <span class=\"n\">SIOptionsParser</span><span class=\"p\">()</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">OptionFoundEvent</span> <span class=\"o\">+=</span> <span class=\"n\">AddOption</span>\n\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;tcp&quot;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;host=localhost, port=4228, timeout=30000, reconnect=true, reconnect.interval=10s, async.enabled=false&#39;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;tcp&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;host=thlucasi9.netlucas.com,port=4228,timeout=30000&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;pipe&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;pipename=smartinspect,reconnect=true,reconnect.interval=5s,async.enabled=true&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;file&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">./tests/logfiles/FileProtocol-RotateHourly.sil</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, rotate=hourly, maxparts=24, append=true&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;file&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">./tests/logfiles/FileProtocol-ENCRYPTTEST.sil</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, encrypt=true, key=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">secret</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, rotate=none, append=false&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;mem&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;astext=true, indent=true&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;mem&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;astext=true, indent=true, pattern=</span><span class=\"se\">\\&quot;</span><span class=\"si\">%le</span><span class=\"s2\">vel% [%timestamp%]: %title%</span><span class=\"se\">\\&quot;</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;text&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">./tests/logfiles/TextProtocol-RotateHourly.txt</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, rotate=hourly, maxparts=24, indent=true, pattern=</span><span class=\"se\">\\&quot;</span><span class=\"si\">%le</span><span class=\"s2\">vel% [%timestamp%]: %title%</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, append=true&quot;</span><span class=\"p\">)</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># unwire events.</span>\n<span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">OptionFoundEvent</span> <span class=\"o\">-=</span> <span class=\"n\">AddOption</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;/nTest Script Ended.&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">protocol</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">options</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacket", "modulename": "smartinspectpython.sipacket", "kind": "module", "doc": "<p>Module: sipacket.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipacket.SIPacket", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket", "kind": "class", "doc": "<p>Abstract base class for all packets in the SmartInspect library.</p>\n\n<p>This class is the base class for all packets in the SmartInspect\nlibrary. The following table lists the available packets\ntogether with a short description.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Packet</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>ControlCommand</td>\n  <td>Responsible for administrative tasks like clearing the Console.</td>\n</tr>\n<tr>\n  <td>LogEntry</td>\n  <td>Represents the most important packet in the entire SmartInspect concept. Is used for the majority of logging methods in the SISession class.</td>\n</tr>\n<tr>\n  <td>LogHeader</td>\n  <td>Responsible for storing and transferring log metadata. Used by the SIPipeProtocol and SITcpProtocol classes to support the filter and trigger functionality of the SmartInspect Router service application.</td>\n</tr>\n<tr>\n  <td>ProcessFlow</td>\n  <td>Responsible for managing thread and process information about your application.</td>\n</tr>\n<tr>\n  <td>Watch</td>\n  <td>Responsible for handling variable watches.</td>\n</tr>\n</tbody>\n</table>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class and sub-classes are not guaranteed to be thread-safe.\n  To ensure thread-safety, use ThreadSafe as well as the Lock and\n  Unlock methods.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sipacket.SIPacket.__init__", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sipacket.SIPacket.PACKET_HEADER_SIZE", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.PACKET_HEADER_SIZE", "kind": "variable", "doc": "<p>Size in bytes of the packet header prefix.</p>\n", "annotation": ": int", "default_value": "6"}, {"fullname": "smartinspectpython.sipacket.SIPacket.Bytes", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.Bytes", "kind": "variable", "doc": "<p>Gets the Bytes property value.</p>\n\n<p>Represents the amount of bytes needed for storing this packet\nin the standard SmartInspect binary log file format as\nrepresented by SIBinaryFormatter.</p>\n\n<p>Please note that this property is only set and used by the\nSmartInspect SDK.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sipacket.SIPacket.HasData", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.HasData", "kind": "variable", "doc": "<p>Gets the HasData property value.</p>\n\n<p>Indicates if this packet contains optional data or not.</p>\n\n<p>Returns true if this packet contains optional\ndata and false otherwise.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sipacket.SIPacket.Level", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.Level", "kind": "variable", "doc": "<p>Gets the Level property value.</p>\n\n<p>Represents the log level of this packet.</p>\n\n<p>Every packet can have a certain log level value. Log levels\ndescribe the severity of a packet. Please see the Level\nenum for more information about log levels and their usage.</p>\n", "annotation": ": smartinspectpython.silevel.SILevel"}, {"fullname": "smartinspectpython.sipacket.SIPacket.PacketType", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.PacketType", "kind": "variable", "doc": "<p>Gets the PacketType property value.</p>\n\n<p>Represents the type of this packet.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>NotImplementedError:</strong>  Thrown if the property method is not overridden in an inheriting class.</li>\n</ul>\n\n<p>Represents the type of a packet. In the SmartInspect concept,\nthere are multiple packet types each serving a special purpose.\nPlease see the SIPacketType enum for more information.</p>\n", "annotation": ": smartinspectpython.sipackettype.SIPacketType"}, {"fullname": "smartinspectpython.sipacket.SIPacket.Size", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.Size", "kind": "variable", "doc": "<p>Gets the Size property value.</p>\n\n<p>Calculates and returns the total memory size occupied by\nthis packet.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>NotImplementedError:</strong>  Thrown if the property method is not overridden in an inheriting class.</li>\n</ul>\n\n<p>This read-only property returns the total occupied memory\nsize of this packet. This functionality is used by the\nSIProtocol.IsValidOption protocol feature to calculate the \ntotal backlog queue size.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sipacket.SIPacket.ThreadSafe", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.ThreadSafe", "kind": "variable", "doc": "<p>Gets the ThreadSafe property value.</p>\n\n<p>Indicates if this packet is used in a multi-threaded\nSmartInspect environment.</p>\n\n<p>Set this property to true before calling Lock and Unlock\nin a multi-threaded environment. Otherwise, the Lock and\nUnlock methods do nothing. Note that setting this\nproperty is done automatically if this packet has been\ncreated by the SISession class and is processed by a related\nSmartInspect object which has one or more connections which\noperate in asynchronous protocol mode.</p>\n\n<p>Setting this property must be done before using this packet\nfrom multiple threads simultaneously.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sipacket.SIPacket.GetThreadId", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.GetThreadId", "kind": "function", "doc": "<p>Returns the ID of the current thread.</p>\n\n<p>The ID the current thread or 0 if the caller does not have\nthe required permissions to retrieve the ID of the current thread.</p>\n\n<p>This method is intended to be used by derived packet classes\nwhich make use of a thread ID. Please note that this method\ncatches any SecurityException and returns 0 in this case.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacket.SIPacket.GetProcessId", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.GetProcessId", "kind": "function", "doc": "<p>Returns the ID of the current process.</p>\n\n<p>The ID the current process or 0 if the caller does not have\nthe required permissions to retrieve the ID of the current\nprocess.</p>\n\n<p>This method is intended to be used by derived packet classes\nwhich make use of a process ID. Please note that this method\ncatches any SecurityException and returns 0 in this case.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacket.SIPacket.GetStringSize", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.GetStringSize", "kind": "function", "doc": "<p>Returns the memory size occupied by the supplied string or 0 if the\nsupplied argument is null.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  String value to get the size of.</li>\n</ul>\n\n<p>This method calculates and returns the total memory size\noccupied by the supplied string. if the supplied argument\nis null, 0 is returned.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacket.SIPacket.Lock", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.Lock", "kind": "function", "doc": "<p>Locks this packet for safe multi-threaded packet processing\nif this packet is operating in thread-safe mode.</p>\n\n<p>Call this method before reading or changing properties of a\npacket when using this packet from multiple threads at the\nsame time. This is needed, for example, when one or more\nSmartInspect.Connections of a SmartInspect object are told \nto operate in SIProtocol.IsValidOption.  Each Lock call must \nbe matched by a call to Unlock.</p>\n\n<p>Before using Lock and Unlock in a multi-threaded environment\nyou must indicate that this packet should operate in\nthread-safe mode by setting the ThreadSafe property to true.\nOtherwise, the Lock and Unlock methods do nothing. Note\nthat setting the ThreadSafe property is done automatically\nif this packet has been created by the SISession class and is\nprocessed by a related SmartInspect object which has one or\nmore connections which operate in asynchronous protocol mode.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacket.SIPacket.Unlock", "modulename": "smartinspectpython.sipacket", "qualname": "SIPacket.Unlock", "kind": "function", "doc": "<p>Unlocks a previously locked packet.</p>\n\n<p>Call this method after reading or changing properties of a\npacket when using this packet from multiple threads at the\nsame time. This is needed, for example, when one or more\nSmartInspect.Connections of a SmartInspect object are told to \noperate in SIProtocol.IsValidOption.  Each Unlock call must be \nmatched by a previous call to Lock.</p>\n\n<p>Before using Lock and Unlock in a multi-threaded environment\nyou must indicate that this packet should operate in\nthread-safe mode by setting the ThreadSafe property to true.\nOtherwise, the Lock and Unlock methods do nothing. Note\nthat setting the ThreadSafe property is done automatically\nif this packet has been created by the SISession class and is\nprocessed by a related SmartInspect object which has one or\nmore connections which operate in asynchronous protocol mode.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacketqueue", "modulename": "smartinspectpython.sipacketqueue", "kind": "module", "doc": "<p>Module: sipacketqueue.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipacketqueue.SIPacketQueue", "modulename": "smartinspectpython.sipacketqueue", "qualname": "SIPacketQueue", "kind": "class", "doc": "<p>Manages a memory size limited queue of packets.</p>\n\n<p>This class is responsible for managing a size limited queue\nof packets. This functionality is needed by the protocol\nSIProtocol.IsValidOption feature. The maximum\ntotal memory size of the queue can be set with the Backlog\nproperty. New packets can be added with the Push method. Packets\nwhich are no longer needed can be retrieved and removed from the\nqueue with the Pop method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sipacketqueue.SIPacketQueue.__init__", "modulename": "smartinspectpython.sipacketqueue", "qualname": "SIPacketQueue.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sipacketqueue.SIPacketQueue.Backlog", "modulename": "smartinspectpython.sipacketqueue", "qualname": "SIPacketQueue.Backlog", "kind": "variable", "doc": "<p>Gets the Backlog property value.</p>\n\n<p>Represents the total maximum memory size of this queue in bytes.</p>\n\n<p>Each time a new packet is added with the Push method, it will\nbe verified that the total occupied memory size of the queue\nstill falls below the supplied Backlog limit. To satisfy this\nconstraint, old packets are removed from the queue when necessary.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sipacketqueue.SIPacketQueue.Count", "modulename": "smartinspectpython.sipacketqueue", "qualname": "SIPacketQueue.Count", "kind": "variable", "doc": "<p>Gets the Count property value.</p>\n\n<p>Returns the current amount of packets in this queue.</p>\n\n<p>For each added packet this counter is incremented by one\nand for each removed packet (either with the Pop method or\nautomatically while resizing the queue) this counter is decremented\nby one. If the queue is empty, this property returns 0.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sipacketqueue.SIPacketQueue.Clear", "modulename": "smartinspectpython.sipacketqueue", "qualname": "SIPacketQueue.Clear", "kind": "function", "doc": "<p>Removes all packets from this queue.</p>\n\n<p>Removing all packets of the queue is done by calling the Pop\nmethod for each packet in the current queue.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacketqueue.SIPacketQueue.Pop", "modulename": "smartinspectpython.sipacketqueue", "qualname": "SIPacketQueue.Pop", "kind": "function", "doc": "<p>Returns a packet and removes it from the queue.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The removed packet or null if the queue does not contain any packets.</p>\n</blockquote>\n\n<p>If the queue is not empty, this method removes the oldest\npacket from the queue (also known as FIFO) and returns it.\nThe total size of the queue is decremented by the size of\nthe returned packet (plus some internal management overhead).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacketqueue.SIPacketQueue.Push", "modulename": "smartinspectpython.sipacketqueue", "qualname": "SIPacketQueue.Push", "kind": "function", "doc": "<p>Adds a new packet to the queue.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to add.</li>\n</ul>\n\n<p>This method adds the supplied packet to the queue. The size\nof the queue is incremented by the size of the supplied\npacket (plus some internal management overhead). If the total\noccupied memory size of this queue exceeds the Backlog limit\nafter adding the new packet, then already added packets will\nbe removed from this queue until the Backlog size limit is\nreached again.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipacketqueueitem", "modulename": "smartinspectpython.sipacketqueueitem", "kind": "module", "doc": "<p>Module: sipacketqueueitem.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipacketqueueitem.SIPacketQueueItem", "modulename": "smartinspectpython.sipacketqueueitem", "qualname": "SIPacketQueueItem", "kind": "class", "doc": "<p>SIPacketQueue item class.</p>\n"}, {"fullname": "smartinspectpython.sipacketqueueitem.SIPacketQueueItem.__init__", "modulename": "smartinspectpython.sipacketqueueitem", "qualname": "SIPacketQueueItem.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sipacketqueueitem.SIPacketQueueItem.Packet", "modulename": "smartinspectpython.sipacketqueueitem", "qualname": "SIPacketQueueItem.Packet", "kind": "variable", "doc": "<p>Packet stored by this queue item.</p>\n", "annotation": ": smartinspectpython.sipacket.SIPacket"}, {"fullname": "smartinspectpython.sipacketqueueitem.SIPacketQueueItem.Next", "modulename": "smartinspectpython.sipacketqueueitem", "qualname": "SIPacketQueueItem.Next", "kind": "variable", "doc": "<p>The next packet queue item in the queue.</p>\n", "annotation": ": smartinspectpython.sipacketqueueitem.SIPacketQueueItem"}, {"fullname": "smartinspectpython.sipacketqueueitem.SIPacketQueueItem.Previous", "modulename": "smartinspectpython.sipacketqueueitem", "qualname": "SIPacketQueueItem.Previous", "kind": "variable", "doc": "<p>The previous packet queue item in the queue.</p>\n", "annotation": ": smartinspectpython.sipacketqueueitem.SIPacketQueueItem"}, {"fullname": "smartinspectpython.sipackettype", "modulename": "smartinspectpython.sipackettype", "kind": "module", "doc": "<p>Module: sipackettype.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipackettype.SIPacketType", "modulename": "smartinspectpython.sipackettype", "qualname": "SIPacketType", "kind": "class", "doc": "<p>Represents the type of a packet. In the SmartInspect concept,\nthere are multiple packet types each serving a special purpose.\nFor a good starting point on packets, please have a look at the\ndocumentation of the SIPacket class.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.sipackettype.SIPacketType.ControlCommand", "modulename": "smartinspectpython.sipackettype", "qualname": "SIPacketType.ControlCommand", "kind": "variable", "doc": "<p>Identifies a packet as Control Command. Please have a look\nat the documentation of the SIControlCommand class for more\ninformation about this packet type.</p>\n", "default_value": "&lt;SIPacketType.ControlCommand: 1&gt;"}, {"fullname": "smartinspectpython.sipackettype.SIPacketType.LogEntry", "modulename": "smartinspectpython.sipackettype", "qualname": "SIPacketType.LogEntry", "kind": "variable", "doc": "<p>Identifies a packet as Log Entry. Please have a look at the\ndocumentation of the SILogEntry class for information about\nthis packet type.</p>\n", "default_value": "&lt;SIPacketType.LogEntry: 4&gt;"}, {"fullname": "smartinspectpython.sipackettype.SIPacketType.Watch", "modulename": "smartinspectpython.sipackettype", "qualname": "SIPacketType.Watch", "kind": "variable", "doc": "<p>Identifies a packet as Watch. Please have a look at the\ndocumentation of the SIWatch class for information about\nthis packet type.</p>\n", "default_value": "&lt;SIPacketType.Watch: 5&gt;"}, {"fullname": "smartinspectpython.sipackettype.SIPacketType.ProcessFlow", "modulename": "smartinspectpython.sipackettype", "qualname": "SIPacketType.ProcessFlow", "kind": "variable", "doc": "<p>Identifies a packet as Process Flow entry. Please have a\nlook at the documentation of the SIProcessFlow class for\ninformation about this packet type.</p>\n", "default_value": "&lt;SIPacketType.ProcessFlow: 6&gt;"}, {"fullname": "smartinspectpython.sipackettype.SIPacketType.LogHeader", "modulename": "smartinspectpython.sipackettype", "qualname": "SIPacketType.LogHeader", "kind": "variable", "doc": "<p>Identifies a packet as Log Header. Please have a look\nat the documentation of the SILogHeader class for information\nabout this packet type.</p>\n", "default_value": "&lt;SIPacketType.LogHeader: 7&gt;"}, {"fullname": "smartinspectpython.sipatternparser", "modulename": "smartinspectpython.sipatternparser", "kind": "module", "doc": "<p>Module: sipatternparser.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipatternparser.SIPatternParser", "modulename": "smartinspectpython.sipatternparser", "qualname": "SIPatternParser", "kind": "class", "doc": "<p>Capable of parsing and expanding a pattern string as used in the\nSITextProtocol and SITextFormatter classes.</p>\n\n<p>The SIPatternParser class is capable of creating a text\nrepresentation of a SILogEntry object (see Expand). The string\nrepresentation can be influenced by setting a pattern string.\nPlease see the Pattern property for a description.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sipatternparser.SIPatternParser.__init__", "modulename": "smartinspectpython.sipatternparser", "qualname": "SIPatternParser.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sipatternparser.SIPatternParser.Indent", "modulename": "smartinspectpython.sipatternparser", "qualname": "SIPatternParser.Indent", "kind": "variable", "doc": "<p>Gets the Indent property value.</p>\n\n<p>Indicates if the Expand method should automatically intend\nlog packets like in the Views of the SmartInspect Console.</p>\n\n<p>Log Entry packets of type EnterMethod increase the indentation\nand packets of type LeaveMethod decrease it.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sipatternparser.SIPatternParser.Pattern", "modulename": "smartinspectpython.sipatternparser", "qualname": "SIPatternParser.Pattern", "kind": "variable", "doc": "<p>Gets the Pattern property value.</p>\n\n<p>Represents the pattern string for this SIPatternParser object.</p>\n\n<p>The pattern string influences the way a text representation of\na SILogEntry object is created. A pattern string consists of a\nlist of so called variable and literal tokens. When a string\nrepresentation of a SILogEntry object is created, the variables\nare replaced with the actual values of the SILogEntry object.</p>\n\n<p>Variables have a unique name, are surrounded with '%' characters\nand can have an optional options string enclosed in curly\nbraces like this: %name{options}%.</p>\n\n<p>You can also specify the minimum width of a value like this:\n%name,width%. Width must be a valid positive or negative\ninteger. If the width is greater than 0, formatted values will\nbe right-aligned. If the width is less than 0, they will be\nleft-aligned.</p>\n\n<p>The following table lists the available variables together with\nthe corresponding Log Entry property.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Variable</th>\n  <th>Corresponding Property</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>%appname%</td>\n  <td>LogEntry.AppName</td>\n</tr>\n<tr>\n  <td>%color%</td>\n  <td>LogEntry.ColorBG</td>\n</tr>\n<tr>\n  <td>%hostname%</td>\n  <td>LogEntry.HostName</td>\n</tr>\n<tr>\n  <td>%level%</td>\n  <td>Packet.Level</td>\n</tr>\n<tr>\n  <td>%logentrytype%</td>\n  <td>LogEntry.LogEntryType</td>\n</tr>\n<tr>\n  <td>%process%</td>\n  <td>LogEntry.ProcessId</td>\n</tr>\n<tr>\n  <td>%session%</td>\n  <td>LogEntry.SessionName</td>\n</tr>\n<tr>\n  <td>%thread%</td>\n  <td>LogEntry.ThreadId</td>\n</tr>\n<tr>\n  <td>%timestamp%</td>\n  <td>LogEntry.Timestamp</td>\n</tr>\n<tr>\n  <td>%title%</td>\n  <td>LogEntry.Title</td>\n</tr>\n<tr>\n  <td>%viewerid%</td>\n  <td>LogEntry.ViewerId</td>\n</tr>\n</tbody>\n</table>\n\n<p>For the time-stamp token, you can use the options string to\npass a custom date/time format string. This can look as follows:\n%timestamp{HH:mm:ss.fff}%</p>\n\n<p>The format string must be a valid Python DateTime format\nstring. The default format string used by the time-stamp token\nis \"yyyy-MM-dd HH:mm:ss.fff\".</p>\n\n<p>Literals are preserved as specified in the pattern string. When\na specified variable is unknown, it is handled as literal.</p>\n\n<h1 id=\"examples\">Examples:</h1>\n\n<p><code>\"[%timestamp%] %level,8%: %title%\"</code></p>\n\n<p><code>\"[%timestamp%] %session%: %title% (Level: %level%)\"</code></p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sipatternparser.SIPatternParser.Expand", "modulename": "smartinspectpython.sipatternparser", "qualname": "SIPatternParser.Expand", "kind": "function", "doc": "<p>Creates a text representation of a Log Entry by applying a\nuser-specified Pattern string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>logEntry (LogEntry):</strong>  The Log Entry whose text representation should be computed by\napplying the current Pattern string. All recognized variables\nin the pattern string are replaced with the actual values of\nthis Log Entry.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The text representation for the supplied Log Entry object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">logEntry</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentry</span><span class=\"o\">.</span><span class=\"n\">SILogEntry</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipehandle", "modulename": "smartinspectpython.sipipehandle", "kind": "module", "doc": "<p>Module: sipipehandle.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipipehandle.SIPipeHandle", "modulename": "smartinspectpython.sipipehandle", "qualname": "SIPipeHandle", "kind": "class", "doc": "<p>Used to open a named-pipe connection.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sipipehandle.SIPipeHandle.__init__", "modulename": "smartinspectpython.sipipehandle", "qualname": "SIPipeHandle.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class with the specified named pipe.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pipeName (str):</strong>  The named pipe to open.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">pipeName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "smartinspectpython.sipipehandle.SIPipeHandle.IsInvalid", "modulename": "smartinspectpython.sipipehandle", "qualname": "SIPipeHandle.IsInvalid", "kind": "variable", "doc": "<p>Gets the IsInvalid property value.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sipipehandle.SIPipeHandle.HResult", "modulename": "smartinspectpython.sipipehandle", "qualname": "SIPipeHandle.HResult", "kind": "variable", "doc": "<p>Gets the HResult property value.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sipipehandle.SIPipeHandle.Handle", "modulename": "smartinspectpython.sipipehandle", "qualname": "SIPipeHandle.Handle", "kind": "variable", "doc": "<p>Gets the named pipe file Handle.</p>\n", "annotation": ": object"}, {"fullname": "smartinspectpython.sipipehandle.SIPipeHandle.OpenPipe", "modulename": "smartinspectpython.sipipehandle", "qualname": "SIPipeHandle.OpenPipe", "kind": "function", "doc": "<p>Calls win32api to create a named pipe file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pipeName (str):</strong>  The named pipe to open.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Thrown if an exception occurs for any reason (pipe not found,\nbroken pipe, etc).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A win32api file handle to the named pipe.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">pipeName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">object</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipeprotocol", "modulename": "smartinspectpython.sipipeprotocol", "kind": "module", "doc": "<p>Module: sipipeprotocol.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/06/09</td>\n  <td>3.0.8.0</td>\n  <td>Added call to RaiseInfoEvent for the SI Console Server banner.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol", "kind": "class", "doc": "<p>Used for sending packets to a local SmartInspect Console over a\nnamed pipe connection.  This protocol only works on Windows-based\nsystems, as it utilizes a Win32 API for named pipe access.</p>\n\n<p>This class is used for sending packets through a local named pipe\nto the SmartInspect Console. It is used when the 'pipe' protocol\nis specified in the SmartInspect.Connections.  Please see the \nIsValidOption method for a list of available protocol options. \nPlease note that this protocol can only be used for local connections. \nFor remote connections to other machines, please use SITcpProtocol.</p>\n\n<p>For a list of available protocol options, please refer to the\nIsValidOption method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siprotocol.SIProtocol"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.__init__", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.Name", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.Name", "kind": "variable", "doc": "<p>Overridden.  Returns \"pipe\".</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.BuildOptions", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.BuildOptions", "kind": "function", "doc": "<p>Overridden. Fills a SIConnectionsBuilder instance with the\noptions currently used by this protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>builder (SIConnectionsBuilder):</strong>  The SIConnectionsBuilder object to fill with the current options\nof this protocol.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">builder</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconnectionsbuilder</span><span class=\"o\">.</span><span class=\"n\">SIConnectionsBuilder</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.InternalConnect", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.InternalConnect", "kind": "function", "doc": "<p>Overridden.  Connects to the specified local named pipe.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Establishing the named pipe connection failed.</li>\n</ul>\n\n<p>This method tries to establish a connection to a local named\npipe of a SmartInspect Console.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.InternalDisconnect", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.InternalDisconnect", "kind": "function", "doc": "<p>Overridden.  Closes the connection to the specified local named pipe.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Closing the named pipe handle failed.</li>\n</ul>\n\n<p>This method closes the named pipe handle if previously created\nand disposes any supplemental objects.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.InternalReconnect", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.InternalReconnect", "kind": "function", "doc": "<p>Tries to reconnect to the specified local named pipe.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the reconnect attempt has been successful and false otherwise.</p>\n</blockquote>\n\n<p>This method tries to re-establish a connection to the local\nnamed pipe of a SmartInspect Console.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.InternalWritePacket", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.InternalWritePacket", "kind": "function", "doc": "<p>Sends a packet to the Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to write.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Sending the packet to the Console failed.</li>\n</ul>\n\n<p>This method sends the supplied packet to the SmartInspect\nConsole over the previously established named pipe connection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.IsValidOption", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.IsValidOption", "kind": "function", "doc": "<p>Overridden. Validates if a protocol option is supported.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The option name to validate.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the option is supported and false otherwise.</p>\n</blockquote>\n\n<p>The following table lists all valid options, their default\nvalues and descriptions for the PIPE protocol.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Valid Options (default value)</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>- pipename (\"smartinspect\")</td>\n  <td>Specifies the named pipe for sending log packets to the SmartInspect Console.  This value must match the pipe name in the SmartInspect Console options.</td>\n</tr>\n</tbody>\n</table>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># the following are sample SI Connections options for this protocol.</span>\n\n<span class=\"c1\"># log messages to SI Console using all default options (pipename=smartinspect).</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;pipe()&quot;</span>\n\n<span class=\"c1\"># log messages to SI Console using pipe name &quot;sipipe&quot;, with asyncronous send enabled.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;pipe(pipename=sipipe,reconnect=true,reconnect.interval=10s,async.enabled=true)&quot;</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipeprotocol.SIPipeProtocol.LoadOptions", "modulename": "smartinspectpython.sipipeprotocol", "qualname": "SIPipeProtocol.LoadOptions", "kind": "function", "doc": "<p>Overridden. Loads and inspects specific options for this protocol.</p>\n\n<p>This method loads all relevant options and ensures their\ncorrectness. See IsValidOption for a list of options which\nare recognized by this protocol.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream", "modulename": "smartinspectpython.sipipestream", "kind": "module", "doc": "<p>Module: sipipestream.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream", "kind": "class", "doc": "<p>Stream class used to read from / write to a named pipe via Win32API calls.</p>\n\n<p>This class utilizes the Windows win32file support from the pywin32 module.\nMore information can be found here:\n<a href=\"http://timgolden.me.uk/pywin32-docs/win32file__ReadFile_meth.html\">http://timgolden.me.uk/pywin32-docs/win32file__ReadFile_meth.html</a></p>\n", "bases": "_io.BytesIO"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.__init__", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pipeHandle (int):</strong>  Handle to the named pipe that is open for reading / writing.</li>\n<li><strong>initialSize (int):</strong>  The initial size of the buffer to allocate for this stream.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  Thrown if the pipeHandle argument is null or an empty string.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">pipeHandle</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">initialSize</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8192</span></span>)</span>"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.flush", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.flush", "kind": "function", "doc": "<p>Overridden.  Force bytes held in the buffer into the raw stream.\nPrior to flushing, buffered data will be written to the named pipe.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.tell", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.tell", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.writable", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.writable", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.write", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.write", "kind": "function", "doc": "<p>Overridden.  Writes data to the internal buffer.  </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>data (Any):</strong>  Bytes of data to write.</li>\n</ul>\n\n<p>Buffered data will only be written to the named pipe once a \"flush()\" is called.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.close", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.close", "kind": "function", "doc": "<p>Overridden.  Closes the stream, as well as the named pipe.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.read", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.read", "kind": "function", "doc": "<p>Overridden.  Read data from the named pipe, and moves it to our buffer.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>size (int):</strong>  Number of bytes to read.  This argument is ignored, as ALL available data is \nread from the named-pipe.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>IOError:</strong>  Thrown if the read failed for any reason.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A byte array of data read.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bytes</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.readable", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.readable", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.name", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.name", "kind": "variable", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.detach", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.detach", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">io</span><span class=\"o\">.</span><span class=\"n\">RawIOBase</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.fileno", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.fileno", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.isatty", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.isatty", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sipipestream.SIPipeStream.seek", "modulename": "smartinspectpython.sipipestream", "qualname": "SIPipeStream.seek", "kind": "function", "doc": "<p>Overridden.  Calls the same method on the destination stream specified at initialization.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">whence</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprocessflow", "modulename": "smartinspectpython.siprocessflow", "kind": "module", "doc": "<p>Module: siprocessflow.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow", "kind": "class", "doc": "<p>Represents the Process Flow packet type which is used in the\nEnterMethod and LeaveMethod methods in the SISession class.</p>\n\n<p>A Process Flow entry is responsible for illustrated process and\nthread information. </p>\n\n<p>It has several properties which describe its creation context\n(like a thread ID, time-stamp or hostname) and other properties\nwhich specify the way the Console interprets this packet (like the\nprocess flow ID). Furthermore a Process Flow entry contains the\nactual data, namely the title, which will be displayed in the\nConsole.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe. However, instances\n  of this class will normally only be used in the context of a\n  single thread.</p>\n</blockquote>\n", "bases": "smartinspectpython.sipacket.SIPacket"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.__init__", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.__init__", "kind": "function", "doc": "<p>Initializes a new SIProcessFlow instance with\na custom process flow type.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>processFlowType (SIProcessFlowType):</strong>  The type of the new Process Flow entry describes the way the\nConsole interprets this packet. Please see the SIProcessFlowType\nenum for more information.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">processFlowType</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprocessflowtype</span><span class=\"o\">.</span><span class=\"n\">SIProcessFlowType</span></span>)</span>"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.HEADER_SIZE", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.HEADER_SIZE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "28"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.HostName", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.HostName", "kind": "variable", "doc": "<p>Gets the HostName property value.</p>\n\n<p>Represents the hostname of this Process Flow entry.</p>\n\n<p>The hostname of this Process Flow entry is usually set to the\nname of the machine this Process Flow entry is sent from. It\nwill be empty in the SmartInspect Console when this property\nis set to null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.PacketType", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.PacketType", "kind": "variable", "doc": "<p>Overridden.  Returns SIPacketType.ProcessFlow</p>\n", "annotation": ": smartinspectpython.sipackettype.SIPacketType"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.ProcessFlowType", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.ProcessFlowType", "kind": "variable", "doc": "<p>Gets the ProcessFlowType property value.</p>\n\n<p>Represents the type of this Process Flow entry.</p>\n\n<p>The type of the Process Flow entry describes the way the\nConsole interprets this packet. Please see the SIProcessFlowType\nenum for more information.</p>\n", "annotation": ": smartinspectpython.siprocessflowtype.SIProcessFlowType"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.ProcessId", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.ProcessId", "kind": "variable", "doc": "<p>Gets the ProcessId property value.</p>\n\n<p>Represents the ID of the process this object was created in.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.Size", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.Size", "kind": "variable", "doc": "<p>Overridden.  Returns the total occupied memory size of this Process Flow packet.</p>\n\n<p>The total occupied memory size of this Process Flow is the size\nof memory occupied by all strings, the optional Data stream\nand any internal data structures of this Process Flow.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.ThreadId", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.ThreadId", "kind": "variable", "doc": "<p>Gets the ThreadId property value.</p>\n\n<p>Represents the ID of the thread this object was created in.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.Timestamp", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.Timestamp", "kind": "variable", "doc": "<p>Gets the Timestamp property value.</p>\n\n<p>Represents the time-stamp of this Log Entry object.</p>\n\n<p>This property returns the creation time of this Log Entry object.</p>\n", "annotation": ": datetime.datetime"}, {"fullname": "smartinspectpython.siprocessflow.SIProcessFlow.Title", "modulename": "smartinspectpython.siprocessflow", "qualname": "SIProcessFlow.Title", "kind": "variable", "doc": "<p>Gets the Title property value.</p>\n\n<p>Represents the title of this Process Flow entry.</p>\n\n<p>The title of this Process Flow entry will be empty in the\nSmartInspect Console when this property is set to null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprocessfloweventargs", "modulename": "smartinspectpython.siprocessfloweventargs", "kind": "module", "doc": "<p>Module: siprocessfloweventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprocessfloweventargs.SIProcessFlowEventArgs", "modulename": "smartinspectpython.siprocessfloweventargs", "qualname": "SIProcessFlowEventArgs", "kind": "class", "doc": "<p>This class is used by the SmartInspect.ProcessFlow event.</p>\n\n<p>It has only one public class member named ProcessFlow. This\nmember is a property, which just returns the sent packet.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siprocessfloweventargs.SIProcessFlowEventArgs.__init__", "modulename": "smartinspectpython.siprocessfloweventargs", "qualname": "SIProcessFlowEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>processFlow (SIProcessFlow):</strong>  The Process Flow packet which caused the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">processFlow</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprocessflow</span><span class=\"o\">.</span><span class=\"n\">SIProcessFlow</span></span>)</span>"}, {"fullname": "smartinspectpython.siprocessfloweventargs.SIProcessFlowEventArgs.ProcessFlow", "modulename": "smartinspectpython.siprocessfloweventargs", "qualname": "SIProcessFlowEventArgs.ProcessFlow", "kind": "variable", "doc": "<p>Returns the ProcessFlow packet, which has just been sent.</p>\n", "annotation": ": smartinspectpython.siprocessflow.SIProcessFlow"}, {"fullname": "smartinspectpython.siprocessfloweventargs.SIProcessFlowEventHandler", "modulename": "smartinspectpython.siprocessfloweventargs", "qualname": "SIProcessFlowEventHandler", "kind": "class", "doc": "<p>This is the event handler type for the SmartInspect.ProcessFlowEvent event.</p>\n"}, {"fullname": "smartinspectpython.siprocessfloweventargs.SIProcessFlowEventHandler.__init__", "modulename": "smartinspectpython.siprocessfloweventargs", "qualname": "SIProcessFlowEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIProcessFlowEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprocessfloweventargs</span><span class=\"o\">.</span><span class=\"n\">SIProcessFlowEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.siprocessflowtype", "modulename": "smartinspectpython.siprocessflowtype", "kind": "module", "doc": "<p>Module: siprocessflowtype.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprocessflowtype.SIProcessFlowType", "modulename": "smartinspectpython.siprocessflowtype", "qualname": "SIProcessFlowType", "kind": "class", "doc": "<p>Represents the type of a Process Flow packet. The type of Process Flow \nentry specifies the way the Console interprets this packet.</p>\n\n<p>For example, if a Process Flow entry has a type of\nSIProcessFlowType.EnterThread, the Console interprets this packet as\ninformation about a new thread of your application.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.siprocessflowtype.SIProcessFlowType.EnterMethod", "modulename": "smartinspectpython.siprocessflowtype", "qualname": "SIProcessFlowType.EnterMethod", "kind": "variable", "doc": "<p>Instructs the Console to enter a new method.</p>\n", "default_value": "&lt;SIProcessFlowType.EnterMethod: 0&gt;"}, {"fullname": "smartinspectpython.siprocessflowtype.SIProcessFlowType.LeaveMethod", "modulename": "smartinspectpython.siprocessflowtype", "qualname": "SIProcessFlowType.LeaveMethod", "kind": "variable", "doc": "<p>Instructs the Console to leave a method.</p>\n", "default_value": "&lt;SIProcessFlowType.LeaveMethod: 1&gt;"}, {"fullname": "smartinspectpython.siprocessflowtype.SIProcessFlowType.EnterThread", "modulename": "smartinspectpython.siprocessflowtype", "qualname": "SIProcessFlowType.EnterThread", "kind": "variable", "doc": "<p>Instructs the Console to enter a new thread.</p>\n", "default_value": "&lt;SIProcessFlowType.EnterThread: 2&gt;"}, {"fullname": "smartinspectpython.siprocessflowtype.SIProcessFlowType.LeaveThread", "modulename": "smartinspectpython.siprocessflowtype", "qualname": "SIProcessFlowType.LeaveThread", "kind": "variable", "doc": "<p>Instructs the Console to leave a thread.</p>\n", "default_value": "&lt;SIProcessFlowType.LeaveThread: 3&gt;"}, {"fullname": "smartinspectpython.siprocessflowtype.SIProcessFlowType.EnterProcess", "modulename": "smartinspectpython.siprocessflowtype", "qualname": "SIProcessFlowType.EnterProcess", "kind": "variable", "doc": "<p>Instructs the Console to enter a new process.</p>\n", "default_value": "&lt;SIProcessFlowType.EnterProcess: 4&gt;"}, {"fullname": "smartinspectpython.siprocessflowtype.SIProcessFlowType.LeaveProcess", "modulename": "smartinspectpython.siprocessflowtype", "qualname": "SIProcessFlowType.LeaveProcess", "kind": "variable", "doc": "<p>Instructs the Console to leave a process.</p>\n", "default_value": "&lt;SIProcessFlowType.LeaveProcess: 5&gt;"}, {"fullname": "smartinspectpython.siprotocol", "modulename": "smartinspectpython.siprotocol", "kind": "module", "doc": "<p>Module: siprotocol.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n<tr>\n  <td>2023/06/09</td>\n  <td>3.0.8.0</td>\n  <td>Added InfoEvent event and RaiseInfoEvent method to convey SI informational events to interested parties.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol", "kind": "class", "doc": "<p>Is the abstract base class for a protocol. \nA protocol is responsible for transporting packets.</p>\n\n<p>A protocol is responsible for the transport of packets. This\nbase class offers all necessary methods to handle the protocol\noptions and it declares several abstract protocol specific\nmethods for handling protocol destinations like connecting or\nwriting packets.</p>\n\n<p>The following table lists the available protocols together with\ntheir identifier in the SmartInspect.Connections and a short description.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Protocol (Identifier)</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>SIFileProtocol (\"file\")</td>\n  <td>Used for writing log files in the standard SmartInspect binary log file format which can be loaded into the Console.</td>\n</tr>\n<tr>\n  <td>SIMemoryProtocol (\"mem\")</td>\n  <td>Used for writing log data to memory and saving it to a stream on request.</td>\n</tr>\n<tr>\n  <td>SIPipeProtocol (\"pipe\")</td>\n  <td>Used for sending log data over a named pipe directly to a local Console.</td>\n</tr>\n<tr>\n  <td>SITcpProtocol (\"tcp\")</td>\n  <td>Used for sending packets over a TCP connection directly to the Console.</td>\n</tr>\n<tr>\n  <td>SITextProtocol (\"text\")</td>\n  <td>Used for writing log files in a customizable text format.  Best suited for end-user notification purposes.</td>\n</tr>\n</tbody>\n</table>\n\n<p>There are several options which are IsValidOption\nand beyond that each protocol has its\nown set of additional options. For those protocol specific\noptions, please refer to the documentation of the corresponding\nprotocol class. Protocol options can be set with Initialize and\nderived classes can query option values using the Get methods.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.__init__", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.ErrorEvent", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.ErrorEvent", "kind": "variable", "doc": "<p>Event raised when a protocol raises an exception.</p>\n", "annotation": ": smartinspectpython.siutils.Event"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.InfoEvent", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.InfoEvent", "kind": "variable", "doc": "<p>Event raised when a protocol has an informational message to convey.</p>\n", "annotation": ": smartinspectpython.siutils.Event"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.AppName", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.AppName", "kind": "variable", "doc": "<p>Gets the AppName property value.</p>\n\n<p>The application name of a protocol is usually set to the\nname of the application this protocol is created in. The\napplication name can be used to write LogHeader packets\nafter a successful protocol connect.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Asynchronous", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Asynchronous", "kind": "variable", "doc": "<p>Gets the Asynchronous property value.</p>\n\n<p>Indicates if this protocol is operating in asynchronous protocol mode.</p>\n\n<p>If this property returns true, this protocol is operating\nin asynchronous protocol mode. Otherwise, it returns false.\nAsynchronous protocol mode can be enabled with the\nInitialize method. Also see IsValidOption for information\non asynchronous logging and how to enable it.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Caption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Caption", "kind": "variable", "doc": "<p>Gets the Caption property value.</p>\n\n<p>Returns the caption of this protocol.</p>\n\n<p>The caption is used in the SmartInspect.Dispatch method to\nlookup a requested connection. The caption can be set with\nthe Options property. If you use only one connection at once\nor does not use the SmartInspect.Dispatch method, the caption\noption can safely be ignored.</p>\n\n<p>For more information, please refer to the documentation of\nthe Dispatch and SmartInspect.Dispatch methods.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Failed", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Failed", "kind": "variable", "doc": "<p>Gets the Failed property value.</p>\n\n<p>Returns if the last executed connection-related operation of\nthis protocol has failed. Indicates if the next operation is\nlikely to block.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.HostName", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.HostName", "kind": "variable", "doc": "<p>Gets the HostName property value.</p>\n\n<p>The host name of a protocol is usually set to the name of\nthe machine this protocol is created in. The host name can\nbe used to write LogHeader packets after a successful\nprotocol connect.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Name", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Name", "kind": "variable", "doc": "<p>Gets the Name property value.</p>\n\n<p>Specifies the name of a real protocol implementation.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>NotImplementedError:</strong>  Thrown if the property method is not overridden in an inheriting class.</li>\n</ul>\n\n<p>Real implementations should return a meaningful name which\nrepresents the protocol. For example, the SIFileProtocol\nreturns \"file\", the SITcpProtocol \"tcp\" and the SITextProtocol\n\"text\".</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.BuildOptions", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.BuildOptions", "kind": "function", "doc": "<p>Fills a SIConnectionsBuilder instance with the options currently\nused by this protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>builder (SIConnectionsBuilder):</strong>  The SIConnectionsBuilder object to fill with the current options\nof this protocol.</li>\n</ul>\n\n<p>The filled options string consists of key, value option pairs\nseparated by commas.</p>\n\n<p>This function takes care of the options (see IsValidOption).\nTo include protocol specific options, override this function.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">builder</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconnectionsbuilder</span><span class=\"o\">.</span><span class=\"n\">SIConnectionsBuilder</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Connect", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Connect", "kind": "function", "doc": "<p>Connects to the protocol specific destination.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Connecting to the destination failed.  Can only occur when operating in\nnormal blocking mode. In asynchronous mode, the Error event is used for\nreporting exceptions instead.</li>\n</ul>\n\n<p>In normal blocking mode (see IsValidOption), this method\ndoes nothing more than to verify that the protocol is not\nalready connected and does not use the IsValidOption\nand then calls the abstract protocol specific InternalConnect method in a thread-safe\nand exception-safe context.</p>\n\n<p>When operating in asynchronous mode instead, this method\nschedules a connect operation for asynchronous execution\nand returns immediately. Please note that possible\nexceptions which occur during the eventually executed\nconnect are not thrown directly but reported with the\nError event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Disconnect", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Disconnect", "kind": "function", "doc": "<p>Disconnects from the protocol destination.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Disconnecting from the destination failed. Can only occur when operating\nin normal blocking mode. In asynchronous mode, the Error event is used for\nreporting exceptions instead.</li>\n</ul>\n\n<p>In normal blocking mode (see IsValidOption), this method\nchecks if this protocol has a working connection and then\ncalls the protocol specific InternalDisconnect method in a\nthread-safe and exception-safe context.</p>\n\n<p>When operating in asynchronous mode instead, this method\nschedules a disconnect operation for asynchronous execution\nand then blocks until the internal protocol thread is done.\nPlease note that possible exceptions which occur during\nthe eventually executed disconnect are not thrown directly\nbut reported with the Error event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Dispatch", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Dispatch", "kind": "function", "doc": "<p>Dispatches a custom action to a concrete implementation of\na protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>command (SIProtocolCommand):</strong>  The protocol command object which provides protocol specific\ninformation about the custom action. Can be null.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  An exception occurred in the custom action. Can only occur when operating\nin normal blocking mode. In asynchronous mode, the Error event is\nused for reporting exceptions instead.</li>\n</ul>\n\n<p>In normal blocking mode (see IsValidOption), this method\ndoes nothing more than to call the protocol specific\nInternalDispatch method with the supplied command argument\nin a thread-safe and exception-safe way. Please note that\nthis method dispatches the custom action only if the protocol\nis currently connected.</p>\n\n<p>When operating in asynchronous mode instead, this method\nschedules a dispatch operation for asynchronous execution\nand returns immediately. Please note that possible\nexceptions which occur during the eventually executed\ndispatch are not thrown directly but reported with the\nError event.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">command</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprotocolcommand</span><span class=\"o\">.</span><span class=\"n\">SIProtocolCommand</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Dispose", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Dispose", "kind": "function", "doc": "<p>Disconnects from the protocol destination.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Disconnecting from the destination failed. Can only occur when operating\nin normal blocking mode. In asynchronous mode, the Error event is used for\nreporting exceptions instead.</li>\n</ul>\n\n<p>In normal blocking mode (see IsValidOption), this method\nchecks if this protocol has a working connection and then\ncalls the protocol specific InternalDisconnect method in a\nthread-safe and exception-safe context.</p>\n\n<p>When operating in asynchronous mode instead, this method\nschedules a disconnect operation for asynchronous execution\nand then blocks until the internal protocol thread is done.\nPlease note that possible exceptions which occur during\nthe eventually executed disconnect are not thrown directly\nbut reported with the Error event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetBooleanOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetBooleanOption", "kind": "function", "doc": "<p>Gets the boolean value of a key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (bool):</strong>  The value to return if the key does not exist.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value if the key exists or defaultValue\n  otherwise. Note that this method can throw an exception\n  of type ArgumentNullException if you pass a null\n  reference as key.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>A bool value will be treated as true if the value of the\nkey matches either \"true\", \"yes\" or \"1\" and as false\notherwise. Note that this method can throw an exception\nof type ArgumentNullException if you pass a null reference\nas key.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetBytesOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetBytesOption", "kind": "function", "doc": "<p>Gets the byte array value of a key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>size (int):</strong>  The desired size in bytes of the returned byte array. If\nthe element value does not have the expected size, it is\nshortened or padded automatically.</li>\n<li><strong>defaultValue (bytearray):</strong>  The value to return if the given key is unknown or if the\nfound value has an invalid format.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a byte array for the given key\n  if an element with the given key exists and the found value\n  has a valid format or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>The returned byte array always has the desired length as\nspecified by the size argument. If the element value does\nnot have the required size after conversion, it is shortened\nor padded (with zeros) automatically. This method returns\nthe defaultValue argument if either the supplied key is\nunknown or the found value does not have a valid format\n(e.g. invalid characters when using hexadecimal strings).</p>\n\n<p>Note that this method can throw an exception of type\nArgumentNullException if you pass a null reference as key.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">bytearray</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bytearray</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetIntegerOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetIntegerOption", "kind": "function", "doc": "<p>Gets the integer value of a key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (int):</strong>  The value to return if the key does not exist.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value if the key exists or defaultValue\n  otherwise. Note that this method can throw an exception\n  of type ArgumentNullException if you pass a null\n  reference as key.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>Please note that if a value could be found but is not a\nvalid integer, the supplied default value will be returned.\nOnly non-negative integers will be recognized as valid\nvalues. Also note that this method can throw an exception\nof type ArgumentNullException if you pass a null reference\nas key.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetLevelOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetLevelOption", "kind": "function", "doc": "<p>Gets the Level value of a key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (SILevel):</strong>  The value to return if the key does not exist.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to the corresponding Level value\n  for the given key if an element with the given key exists\n  and the found value is a valid Level value or defaultValue\n  otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid\nLevel value. Please see the Level enum for more information\non the available values. Note that this method can throw an\nexception of type ArgumentNullException if you pass a null\nreference as key.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetRotateOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetRotateOption", "kind": "function", "doc": "<p>Gets the FileRotate value of a key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (SIFileRotate):</strong>  The value to return if the key does not exist.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to a FileRotate value for the\n  given key if an element with the given key exists and the\n  found value is a valid FileRotate or defaultValue otherwise.\n  Note that this method can throw an exception of type\n  ArgumentNullException if you pass a null reference as key.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid\nLevel value. Please see the Level enum for more information\non the available values. Note that this method can throw an\nexception of type ArgumentNullException if you pass a null\nreference as key.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sifilerotate</span><span class=\"o\">.</span><span class=\"n\">SIFileRotate</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sifilerotate</span><span class=\"o\">.</span><span class=\"n\">SIFileRotate</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetSizeOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetSizeOption", "kind": "function", "doc": "<p>Gets an integer value of a key. The integer value is interpreted \nas a byte size and it is supported to specify byte units.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (int):</strong>  The value to return if the key does not exist.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to an integer for the given key if\n  an element with the given key exists and the found value is a\n  valid integer or defaultValue otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid\ninteger or ends with an unknown byte unit. Only non-negative\ninteger values are recognized as valid.</p>\n\n<p>It is possible to specify a size unit at the end of the value.\nIf a known unit is found, this function multiplies the\nresulting value with the corresponding factor. For example, if\nthe value of the element is \"1KB\", the return value of this\nfunction would be 1024.</p>\n\n<p>The following table lists the available units together with a\nshort description and the corresponding factor.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Unit Name / Factor</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>KB / 1024</td>\n  <td>KiloByte</td>\n</tr>\n<tr>\n  <td>MB / 1024^2</td>\n  <td>MegaByte</td>\n</tr>\n<tr>\n  <td>GB / 1024^3</td>\n  <td>GigaByte</td>\n</tr>\n</tbody>\n</table>\n\n<p>If no unit is specified, this function defaults to the KB\nunit. Note that this method can throw an exception of type\nArgumentNullException if you pass a null reference as key.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetStringOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetStringOption", "kind": "function", "doc": "<p>Gets the string value of a key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (str):</strong>  The value to return if the key does not exist.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value if the key exists or defaultValue\n  otherwise. Note that this method can throw an exception\n  of type ArgumentNullException if you pass a null\n  reference as key.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.GetTimespanOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.GetTimespanOption", "kind": "function", "doc": "<p>Gets an integer value of a key. The integer value is\ninterpreted as a time span and it is supported to specify time\nspan units.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n<li><strong>defaultValue (float):</strong>  The value to return if the key does not exist.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Either the value converted to an integer for the given key if\n  an element with the given key exists and the found value is a\n  valid integer or defaultValue otherwise. The value is returned\n  in milliseconds.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>ArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method returns the defaultValue argument if either the\nsupplied key is unknown or the found value is not a valid\ninteger or ends with an unknown time span unit.</p>\n\n<p>It is possible to specify a time span unit at the end of the\nvalue. If a known unit is found, this function multiplies the\nresulting value with the corresponding factor. For example, if\nthe value of the element is \"1s\", the return value of this\nfunction would be 1000.</p>\n\n<p>The following table lists the available units together with a\nshort description and the corresponding factor.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Unit Name / Factor</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>s (Seconds)</td>\n  <td>1000</td>\n</tr>\n<tr>\n  <td>m (Minutes)</td>\n  <td>60*s</td>\n</tr>\n<tr>\n  <td>h (Hours)</td>\n  <td>60*m</td>\n</tr>\n<tr>\n  <td>d (Days)</td>\n  <td>24*h</td>\n</tr>\n</tbody>\n</table>\n\n<p>If no unit is specified, this function defaults to the Seconds\nunit. Please note that the value is always returned in\nmilliseconds.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">defaultValue</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">float</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.HandleException", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.HandleException", "kind": "function", "doc": "<p>Handles a protocol exception.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (str):</strong>  The exception message.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Always in normal blocking mode; never in asynchronous mode.</li>\n</ul>\n\n<p>This method handles an occurred protocol exception. It\nfirst sets the Failed flag and creates a SIProtocolException\nobject with the name and options of this protocol. In\nnormal blocking mode (see IsValidOption), it then throws\nthis exception. When operating in asynchronous mode,\nit invokes the Error event handlers instead and does not\nthrow an exception.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Initialize", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Initialize", "kind": "function", "doc": "<p>Sets and initializes the options of this protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>options (str):</strong>  Protocol options, in string delimited format.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SmartInspectException:</strong>  Invalid options syntax or an unknown option key.</li>\n</ul>\n\n<p>This property expects an options string which consists\nof key, value pairs separated by commas like this:\n\"filename=log.sil, append=true\". To use a comma in a value,\nyou can use quotation marks like in the following example:\n\"filename=\\\"log.sil\\\", append=true\".</p>\n\n<p>Please note that a SmartInspectException exception is thrown\nif an incorrect options string is assigned. An incorrect\noptions string could use an invalid syntax or contain one or\nmore unknown option keys. This method can be called only once.\nFurther calls have no effect. Pass null or an empty string to\nuse the default options of a particular protocol.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">options</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.InternalConnect", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.InternalConnect", "kind": "function", "doc": "<p>Connects to the protocol destination\nAbstract method - inheriting classes must override.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Connecting to the destination failed.</li>\n</ul>\n\n<p>This method initiates a protocol specific connection attempt.\nThe behavior of real implementations of this method can often\nbe changed by setting protocol options with the Initialize\nmethod. This method is always called in a thread-safe and\nexception-safe context.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.InternalDisconnect", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.InternalDisconnect", "kind": "function", "doc": "<p>Disconnects from the protocol destination.\nAbstract method - inheriting classes must override.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Disconnecting from the destination failed.</li>\n</ul>\n\n<p>This method is intended for real protocol implementations\nto disconnect from the protocol specific source. This\ncould be closing a file or disconnecting a TCP socket, for\nexample. This method is always called in a thread-safe and\nexception-safe context.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.InternalDispatch", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.InternalDispatch", "kind": "function", "doc": "<p>Executes a protocol specific custom action.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>command (SIProtocolCommand):</strong>  The protocol command which provides protocol specific\ninformation about the custom action. Can be null.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Executing the custom action failed.</li>\n</ul>\n\n<p>The default implementation does nothing. Derived protocol\nimplementations can override this method to add custom\nactions. Please see the SIMemoryProtocol.InternalDispatch\nmethod for an example. This method is always called in a\nthread-safe and exception-safe way.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">command</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprotocolcommand</span><span class=\"o\">.</span><span class=\"n\">SIProtocolCommand</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.InternalReconnect", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.InternalReconnect", "kind": "function", "doc": "<p>Reconnects to the protocol specific destination.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the reconnect attempt has been successful and false otherwise.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Reconnecting to the destination failed.</li>\n</ul>\n\n<p>This method initiates a protocol specific reconnect attempt.\nThe behavior of real method implementations can often be\nchanged by setting protocol options with Initialize. This\nmethod is always called in a thread-safe and exception-safe\ncontext.</p>\n\n<p>The default implementation simply calls the protocol specific\nInternalConnect method. Derived classes can change this\nbehavior by overriding this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.InternalWritePacket", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.InternalWritePacket", "kind": "function", "doc": "<p>Writes a packet to the protocol destination.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to write.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Writing the packet to the destination failed.</li>\n</ul>\n\n<p>This method is intended for real protocol implementations\nto write the supplied packet to the protocol specific\ndestination. This method is always called in a thread-safe\nand exception-safe context.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.IsValidOption", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.IsValidOption", "kind": "function", "doc": "<p>Overriddeable. Validates if a option is supported by this protocol.</p>\n\n<p>True if the option is supported and false otherwise.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The option name to validate.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the option is supported and false otherwise.</p>\n</blockquote>\n\n<p>The following table lists all valid options, their default\nvalues and descriptions common to all protocols. See below\nfor explanations.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Option Name (Default Value)</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>level (debug)</td>\n  <td>Specifies the log level of this protocol.</td>\n</tr>\n<tr>\n  <td>reconnect (false)</td>\n  <td>Specifies if a reconnect should be initiated when a connection gets dropped.</td>\n</tr>\n<tr>\n  <td>reconnect.interval (0)</td>\n  <td>If reconnecting is enabled, specifies the minimum time in seconds between two successive reconnect attempts. If 0 is specified, a reconnect attempt is initiated for each packet if needed. It is possible to specify time span units like this: \"1s\". Supported units are \"s\" (seconds), \"m\" (minutes), \"h\" (hours) and \"d\" (days).</td>\n</tr>\n<tr>\n  <td>caption ([name])</td>\n  <td>Specifies the caption of this protocol as used by SmartInspect.Dispatch. By default, it is set to the protocol identifier (e.g., \"file\" or \"mem\").</td>\n</tr>\n<tr>\n  <td>async.enabled (false)</td>\n  <td>Specifies if this protocol should operate in asynchronous instead of the default blocking mode.</td>\n</tr>\n<tr>\n  <td>async.queue (2048)</td>\n  <td>Specifies the maximum size of the asynchronous queue in kilobytes. It is possible to specify size units like this: \"1 MB\". Supported units are \"KB\", \"MB\" and \"GB\".</td>\n</tr>\n<tr>\n  <td>async.throttle (true)</td>\n  <td>Specifies if the application should be automatically throttled in asynchronous mode when more data is logged than the queue can handle.</td>\n</tr>\n<tr>\n  <td>async.clearondisconnect (false)</td>\n  <td>Specifies if the current content of the asynchronous queue should be discarded before disconnecting. Useful if an application must not wait for the logging to complete before exiting.</td>\n</tr>\n<tr>\n  <td>backlog.enabled (false)</td>\n  <td>Enables the backlog feature (see below).</td>\n</tr>\n<tr>\n  <td>backlog.queue (2048)</td>\n  <td>Specifies the maximum size of the backlog queue in kilobytes. It is possible to specify size units like this: \"1 MB\". Supported units are \"KB\", \"MB\" and \"GB\".</td>\n</tr>\n<tr>\n  <td>backlog.flushon (error)</td>\n  <td>Specifies the flush level for the backlog functionality.</td>\n</tr>\n<tr>\n  <td>backlog.keepopen (false)</td>\n  <td>Specifies if the connection should be kept open between two successive writes when the backlog feature is used.</td>\n</tr>\n</tbody>\n</table>\n\n<p>With the log level of a protocol you can limit the amount of\ndata being logged by excluding packets which don't have a\ncertain minimum log level. For example, if you set the level\nto \"message\", all packets with a log level of \"debug\" or\n\"verbose\" are ignored. For a complete list of available log\nlevel values, please see the documentation of the Level enum.</p>\n\n<p>The caption option specifies the caption for this protocol\nas used by the SmartInspect.Dispatch method. This method\ncan send and initiate custom protocol actions and the caption\nis used to lookup the requested connection. By default, the\ncaption is set to the identifier of a protocol (e.g., \"file\"\nor \"mem\"). For more information about the dispatching of\ncustom protocol actions, please refer to the documentation of\nthe Dispatch and SmartInspect.Dispatch methods.</p>\n\n<p>If the backlog option is enabled, all packets whose log level\nis less than the flushon level and equal to or higher than the\ngeneral log level of a protocol, will be written to a queue\nrather than directly to the protocol specific destination. When\na packet arrives with a log level of at least the same value\nas the flushon option, the current content of the queue is\nwritten. The total amount of memory occupied by this queue\ncan be set with the queue option. If the packet queue has\nbeen filled up with packets and a new packet is about to be\nstored, old packets are discarded.</p>\n\n<p>As an example, if the backlog queue is set to \"2 MB\" and the\nflushon level to \"error\", all packets with a log level less\nthan error are written to a queue first. By specifying a queue\noption of \"2 MB\", the backlog queue is set to a maximum memory\nsize of 2 megabyte. Now, when a packet with a log level of\nerror arrives, the current content of the queue and then the\nerror itself are written.</p>\n\n<p>With the keepopen option of the backlog feature you can specify\nif a connection should be kept open between two successive\nwrites. When keepopen is set to false, a connection is only\navailable during the actual write / flush. A connection is\nthus only created when absolutely necessary.</p>\n\n<p>A protocol can either operate in normal blocking (the default)\nor in asynchronous mode. In blocking mode, the operations of\nthis protocol (Connect, Disconnect, Dispatch and WritePacket)\nare executed synchronously and block the caller until they are\ndone. In asynchronous mode, these operations are not executed\ndirectly but scheduled for execution in a different thread \nand return immediately. Asynchronous logging can increase the\nlogging performance and reduce the blocking of applications.</p>\n\n<p>When operating in asynchronous mode, this protocol uses a\nqueue to buffer the logging data. The total amount of memory\noccupied by this queue can be set with the queue option. The\nthrottle option specifies if an application should be\nautomatically throttled in asynchronous mode when more data\nis logged / generated than the queue can handle. If this\noption is disabled and the queue is currently full, old\npackets are discarded when new data is logged. The throttle\noption ensures that no logging data is lost but can be\ndisabled if logging performance is critical.</p>\n\n<p>With the clearondisconnect option, you can specify if the\ncurrent content of the asynchronous queue should be discarded\nbefore disconnecting. This can be useful if an application\nmust not wait for the logging to complete before exiting.</p>\n\n<p>The reconnect option allows a protocol to reconnect\nautomatically before a packet is being written. A reconnect\nmight be necessary if a working connection has been unexpectedly\ndisconnected or could not be established in the first place.\nPossible errors during a reconnect attempt will silently be\nignored and not reported.</p>\n\n<p>Please note that the reconnect functionality causes a protocol\nby default to initiate a connection attempt for every packet\nuntil a connection has been successfully (re-) established.\nThis can be a very time consuming process, especially when\nusing a protocol which requires a complex connection process\nlike SITcpProtocol, for example. This can slow down\nthe logging performance. When using the reconnect option, it\nis thus recommended to also enable asynchronous logging to not\nblock the application or to specify a reconnect interval to\nminimize the reconnect attempts.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.LoadOptions", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.LoadOptions", "kind": "function", "doc": "<p>Overriddeable. Loads and inspects protocol-specific options.</p>\n\n<p>This method is intended to give real protocol implementations\nthe opportunity to load and inspect options. This method will\nbe called automatically when the options have been changed.\nThe default implementation of this method takes care of the\noptions IsValidOption and  should thus always be called by \nderived classes which override this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.OnErrorEvent", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.OnErrorEvent", "kind": "function", "doc": "<p>Method that will handle the SIProtocol.ErrorEvent event.\nInheriting classes can override this method to handle the event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIErrorEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n\n<p>Derived classes can override this method to intercept the\nSIProtocol.Error event. Note that the Error event is only\nused in combination with asynchronous logging (please see\nIsValidOption for more information). In normal blocking\nmode, exceptions are reported by throwing.</p>\n\n<p>IMPORTANT: Keep in mind that adding SmartInspect log statements to the event \nhandlers can cause a presumably undesired recursive behavior!</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sierroreventargs</span><span class=\"o\">.</span><span class=\"n\">SIErrorEventArgs</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.OnInfoEvent", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.OnInfoEvent", "kind": "function", "doc": "<p>Method that will handle the SIProtocol.InfoEvent event.\nInheriting classes can override this method to handle the event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIInfoEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n\n<p>Derived classes can override this method to intercept the\nSIProtocol.Info event. </p>\n\n<p>IMPORTANT: Keep in mind that adding SmartInspect log statements to the event \nhandlers can cause a presumably undesired recursive behavior!</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siinfoeventargs</span><span class=\"o\">.</span><span class=\"n\">SIInfoEventArgs</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.RaiseInfoEvent", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.RaiseInfoEvent", "kind": "function", "doc": "<p>Raises the InfoEvent event with an informational message.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li>message (str)\nThe message that caused the event.</li>\n</ul>\n\n<p>This method is used to inform other objects that an informational message was\nissued by a protocol function.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.Reset", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.Reset", "kind": "function", "doc": "<p>Resets the protocol and brings it into a consistent state.</p>\n\n<p>This method resets the current protocol state by clearing\nthe internal backlog queue of packets, setting the connected\nstatus to false and calling the abstract InternalDisconnect\nmethod of a real protocol implementation to cleanup any\nprotocol specific resources.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocol.SIProtocol.WritePacket", "modulename": "smartinspectpython.siprotocol", "qualname": "SIProtocol.WritePacket", "kind": "function", "doc": "<p>Writes a packet to the protocol specific destination.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to write.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIProtocolException:</strong>  Writing the packet to the destination failed. Can only occur when operating\nin normal blocking mode. In asynchronous mode, the Error event is\nused for reporting exceptions instead.</li>\n</ul>\n\n<p>This method first checks if the log level of the supplied\npacket is sufficient to be logged. If this is not the\ncase, this method returns immediately.</p>\n\n<p>Otherwise, in normal blocking mode (see IsValidOption),\nthis method verifies that this protocol is successfully\nconnected and then writes the supplied packet to the\nIsValidOption or passes it directly to the protocol specific \ndestination by calling the InternalWritePacket method. \nCalling InternalWritePacket is always done in a thread-safe \nand exception-safe way.</p>\n\n<p>When operating in asynchronous mode instead, this method\nschedules a write operation for asynchronous execution and\nreturns immediately. Please note that possible exceptions\nwhich occur during the eventually executed write are not\nthrown directly but reported with the Error event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolcommand", "modulename": "smartinspectpython.siprotocolcommand", "kind": "module", "doc": "<p>Module: siprotocolcommand.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprotocolcommand.SIProtocolCommand", "modulename": "smartinspectpython.siprotocolcommand", "qualname": "SIProtocolCommand", "kind": "class", "doc": "<p>Represents a custom protocol action command as used by the\nSIProtocol.Dispatch method.</p>\n\n<p>This class is used by custom protocol actions. For detailed \ninformation about custom protocol actions, please refer to\nthe SIProtocol.Dispatch and SmartInspect.Dispatch methods.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siprotocolcommand.SIProtocolCommand.__init__", "modulename": "smartinspectpython.siprotocolcommand", "qualname": "SIProtocolCommand.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>action (int):</strong>  The custom protocol action to execute.</li>\n<li><strong>state (object):</strong>  Optional object which provides additional information about\nthe custom protocol action.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">action</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">state</span><span class=\"p\">:</span> <span class=\"nb\">object</span></span>)</span>"}, {"fullname": "smartinspectpython.siprotocolcommand.SIProtocolCommand.Action", "modulename": "smartinspectpython.siprotocolcommand", "qualname": "SIProtocolCommand.Action", "kind": "variable", "doc": "<p>Gets the Action property value.</p>\n\n<p>Returns the custom protocol action to execute. The value\nof this property is protocol specific.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.siprotocolcommand.SIProtocolCommand.State", "modulename": "smartinspectpython.siprotocolcommand", "qualname": "SIProtocolCommand.State", "kind": "variable", "doc": "<p>Gets the State property value.</p>\n\n<p>Returns the optional protocol command object which provides\nadditional information about the custom protocol action.\nThis property can be null.</p>\n", "annotation": ": object"}, {"fullname": "smartinspectpython.siprotocolexception", "modulename": "smartinspectpython.siprotocolexception", "kind": "module", "doc": "<p>Module: siprotocolexception.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprotocolexception.SIProtocolException", "modulename": "smartinspectpython.siprotocolexception", "qualname": "SIProtocolException", "kind": "class", "doc": "<p>Used to report any errors concerning the protocol classes.</p>\n", "bases": "smartinspectpython.smartinspectexception.SmartInspectException"}, {"fullname": "smartinspectpython.siprotocolexception.SIProtocolException.__init__", "modulename": "smartinspectpython.siprotocolexception", "qualname": "SIProtocolException.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>message (str):</strong>  The exception message.</li>\n<li><strong>protocol (str):</strong>  The protocol name value.</li>\n<li><strong>options (str):</strong>  The protocol options string.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">protocol</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">options</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, {"fullname": "smartinspectpython.siprotocolexception.SIProtocolException.ProtocolName", "modulename": "smartinspectpython.siprotocolexception", "qualname": "SIProtocolException.ProtocolName", "kind": "variable", "doc": "<p>Gets the ProtocolName property value.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprotocolexception.SIProtocolException.ProtocolOptions", "modulename": "smartinspectpython.siprotocolexception", "qualname": "SIProtocolException.ProtocolOptions", "kind": "variable", "doc": "<p>Gets the ProtocolOptions property value.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siprotocolfactory", "modulename": "smartinspectpython.siprotocolfactory", "kind": "module", "doc": "<p>Module: siprotocolfactory.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprotocolfactory.SIProtocolFactory", "modulename": "smartinspectpython.siprotocolfactory", "qualname": "SIProtocolFactory", "kind": "class", "doc": "<p>Creates Protocol instances and registers custom protocols.</p>\n\n<p>This class is responsible for creating instances of Protocol\nsubclasses and registering custom protocol implementations. To\nadd a custom protocol, please have a look at the documentation\nand example of the RegisterProtocol method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siprotocolfactory.SIProtocolFactory.static_init", "modulename": "smartinspectpython.siprotocolfactory", "qualname": "SIProtocolFactory.static_init", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolfactory.SIProtocolFactory.GetProtocol", "modulename": "smartinspectpython.siprotocolfactory", "qualname": "SIProtocolFactory.GetProtocol", "kind": "function", "doc": "<p>Creates an instance of a Protocol subclass. </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The protocol name to search for.</li>\n<li><strong>options (str):</strong>  The options to apply to the new SIProtocol instance. Can be null.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A new instance of a SIProtocol subclass.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SmartInspectException:</strong>  Unknown protocol or invalid options syntax.</li>\n</ul>\n\n<p>This method tries to create an instance of a SIProtocol subclass\nusing the name parameter. If you, for example, specify \"file\"\nas name parameter, this method returns an instance of the\nSIFileProtocol class. If the creation of such an instance has\nbeen successful, the supplied options will be applied to\nthe protocol.</p>\n\n<p>For a list of available protocols, please refer to the SIProtocol\nclass. Additionally, to add your own custom protocol, please\nhave a look at the RegisterProtocol method.</p>\n\n<p>Please note that if the name argument is null, then the\nreturn value of this method is null as well.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">options</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprotocol</span><span class=\"o\">.</span><span class=\"n\">SIProtocol</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolfactory.SIProtocolFactory.RegisterProtocol", "modulename": "smartinspectpython.siprotocolfactory", "qualname": "SIProtocolFactory.RegisterProtocol", "kind": "function", "doc": "<p>Registers a custom protocol implementation to the SmartInspect\nlibrary.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The name of the custom protocol to register.</li>\n<li><strong>protocolClass (type):</strong>  The class of your custom protocol. It needs to be a class\nderived from the SIProtocol class.</li>\n</ul>\n\n<p>This method enables you to register your own custom protocols.\nThis can be used to extend the built-in capabilities of the\nSmartInspect Python library. To add your own protocol, derive\nyour custom protocol class from .siprotocol, choose a name and\npass this name and the type to this method. After registering\nyour protocol, you are able to use it in the\nSmartInspect.Connections\" property just like\nany other (standard) protocol.</p>\n\n<p>If one of the supplied arguments is null or the supplied type\nis not derived from the SIProtocol class then no custom protocol\nis added.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">protocolClass</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolvariables", "modulename": "smartinspectpython.siprotocolvariables", "kind": "module", "doc": "<p>Module: siprotocolvariables.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables", "kind": "class", "doc": "<p>Manages connection variables.</p>\n\n<p>This class manages a list of connection variables. Connection\nvariables are placeholders for strings in the Connections of the\nSmartInspect class. Please see SmartInspect.SetVariable for\nmore information.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.__init__", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Count", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Count", "kind": "variable", "doc": "<p>Returns the number of key/value pairs of this collection.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Add", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Add", "kind": "function", "doc": "<p>Adds a new element with a specified key and value to the\nset of connection variables.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the element.</li>\n<li><strong>value (str):</strong>  The value of the element.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key or value argument is null.</li>\n</ul>\n\n<p>This method adds a new element with a given key and value to\nthe set of connection variables. If an element for the given\nkey already exists, the original element's value is not updated.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Clear", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Clear", "kind": "function", "doc": "<p>Removes all key/value pairs of the collection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Contains", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Contains", "kind": "function", "doc": "<p>Tests if the collection contains a value for a given key. </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the element to test.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>True if a value exists for the given key and false\notherwise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Expand", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Expand", "kind": "function", "doc": "<p>Expands and returns a connections string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>connections (str):</strong>  The connections string to expand and return.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The expanded connections string.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The connections argument is null.</li>\n</ul>\n\n<p>This method replaces all variables which have previously\nbeen added to this collection (with Add or Put) in the\ngiven connections string with their respective values and\nthen returns it. Variables in the connections string must\nhave the following form: $variable$.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">connections</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Get", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Get", "kind": "function", "doc": "<p>Returns a value of an element for a given key.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key whose value to return.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>Either the value for a given key if an element with the\ngiven key exists or null otherwise.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Put", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Put", "kind": "function", "doc": "<p>Adds or updates an element with a specified key and value\nto the set of connection variables.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the element.</li>\n<li><strong>value (str):</strong>  The value of the element.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key or value argument is null.</li>\n</ul>\n\n<p>This method adds a new element with a given key and value to\nthe set of connection variables. If an element for the given\nkey already exists, the original element's value is updated.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siprotocolvariables.SIProtocolVariables.Remove", "modulename": "smartinspectpython.siprotocolvariables", "qualname": "SIProtocolVariables.Remove", "kind": "function", "doc": "<p>Removes an existing element with a given key from this set\nof connection variables.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the element to remove.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The key argument is null.</li>\n</ul>\n\n<p>This method removes the element with the given key from the\ninternal set of connection variables. Nothing happens if no\nelement with the given key can be found.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischeduler", "modulename": "smartinspectpython.sischeduler", "kind": "module", "doc": "<p>Module: sischeduler.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler", "kind": "class", "doc": "<p>Responsible for scheduling protocol operations and executing\nthem asynchronously in a different thread of control.</p>\n\n<p>This class is used by the SIProtocol.IsValidOption to asynchronously execute\nprotocol operations. New commands can be scheduled for execution with\nthe Schedule method. The scheduler can be started and stopped\nwith the Start and Stop methods. The scheduler uses a size\nlimited queue to buffer scheduler commands. The maximum size of\nthis queue can be set with the Threshold property. To influence\nthe behavior of the scheduler if new commands are enqueued and\nthe queue is currently considered full, you can specify the\nThrottle mode.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler.__init__", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>protocol (SIProtocol):</strong>  The protocol object on which to execute the actual operations like\nconnect, disconnect, write or dispatch.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">protocol</span></span>)</span>"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler.Threshold", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler.Threshold", "kind": "variable", "doc": "<p>Gets the Threshold property value.</p>\n\n<p>Represents the maximum size of the scheduler command queue.</p>\n\n<p>To influence the behavior of the scheduler if new commands\nare enqueued and the queue is currently considered full,\nyou can specify the Throttle mode.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler.Throttle", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler.Throttle", "kind": "variable", "doc": "<p>Gets the Throttle property value.</p>\n\n<p>Specifies if the scheduler should automatically throttle\nthreads that enqueue new scheduler commands.</p>\n\n<p>If this property is true and the queue is considered full\nwhen enqueuing new commands, the enqueuing thread is\nautomatically throttled until there is room in the queue\nfor the new command. In non-throttle mode, the thread is\nnot blocked but older commands are removed from the queue.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler.Clear", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler.Clear", "kind": "function", "doc": "<p>Removes all scheduler commands from this scheduler.</p>\n\n<p>This method clears the current queue of scheduler commands.\nIf the Stop method is called after calling Clear and no new\ncommands are stored between these two calls, the internal\nscheduler thread will exit as soon as possible (after the\ncurrent command, if any, has been processed).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler.Schedule", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler.Schedule", "kind": "function", "doc": "<p>Schedules a new command for asynchronous execution.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>command (SISchedulerCommand):</strong>  The command to schedule.</param></li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the command could be scheduled for asynchronous\n  execution and false otherwise.</p>\n</blockquote>\n\n<p>This method adds the passed command to the internal queue\nof scheduler commands. The command is eventually executed\nby the internal scheduler thread. This method can block the\ncaller if the scheduler operates in Throttle mode and the\ninternal queue is currently considered full (see Threshold).</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">command</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sischedulercommand</span><span class=\"o\">.</span><span class=\"n\">SISchedulerCommand</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler.Start", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler.Start", "kind": "function", "doc": "<p>Starts this scheduler and the internal scheduler threadtask.</p>\n\n<p>This method must be called before scheduling new commands\nwith the Schedule method. Call Stop to stop the internal\nthread when the scheduler is no longer needed. Note that\nthis method starts the internal scheduler thread only once.\nThis means that subsequent calls to this method have no\neffect.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischeduler.SIScheduler.Stop", "modulename": "smartinspectpython.sischeduler", "qualname": "SIScheduler.Stop", "kind": "function", "doc": "<p>Stops this scheduler and the internal scheduler threadtask.</p>\n\n<p>This is the matching method for Start. After calling this\nmethod, new commands will no longer be accepted by Schedule\nand are ignored. This method blocks until the internal\nthread has processed the current content of the queue.\nCall Clear before calling Stop to exit the internal thread\nas soon as possible.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischeduleraction", "modulename": "smartinspectpython.sischeduleraction", "kind": "module", "doc": "<p>Module: sischeduleraction.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sischeduleraction.SISchedulerAction", "modulename": "smartinspectpython.sischeduleraction", "qualname": "SISchedulerAction", "kind": "class", "doc": "<p>Represents a scheduler action to execute when a protocol is\noperating in asynchronous mode. For general information about\nthe asynchronous mode, please refer to SIProtocol.IsValidOption.</p>\n", "bases": "enum.Enum"}, {"fullname": "smartinspectpython.sischeduleraction.SISchedulerAction.Connect", "modulename": "smartinspectpython.sischeduleraction", "qualname": "SISchedulerAction.Connect", "kind": "variable", "doc": "<p>Represents a connect protocol operation. This action is\nenqueued when the SIProtocol.Connect method is called and\nthe protocol is operating in asynchronous mode.</p>\n", "default_value": "&lt;SISchedulerAction.Connect: 0&gt;"}, {"fullname": "smartinspectpython.sischeduleraction.SISchedulerAction.WritePacket", "modulename": "smartinspectpython.sischeduleraction", "qualname": "SISchedulerAction.WritePacket", "kind": "variable", "doc": "<p>Represents a write protocol operation. This action is\nenqueued when the SIProtocol.WritePacket method is called\nand the protocol is operating in asynchronous mode.</p>\n", "default_value": "&lt;SISchedulerAction.WritePacket: 1&gt;"}, {"fullname": "smartinspectpython.sischeduleraction.SISchedulerAction.Disconnect", "modulename": "smartinspectpython.sischeduleraction", "qualname": "SISchedulerAction.Disconnect", "kind": "variable", "doc": "<p>Represents a disconnect protocol operation. This action\nis enqueued when the SIProtocol.Disconnect method is called\nand the protocol is operating in asynchronous mode.</p>\n", "default_value": "&lt;SISchedulerAction.Disconnect: 2&gt;"}, {"fullname": "smartinspectpython.sischeduleraction.SISchedulerAction.Dispatch", "modulename": "smartinspectpython.sischeduleraction", "qualname": "SISchedulerAction.Dispatch", "kind": "variable", "doc": "<p>Represents a dispatch protocol operation. This action is\nenqueued when the SIProtocol.Dispatch method is called and\nthe protocol is operating in asynchronous mode.</p>\n", "default_value": "&lt;SISchedulerAction.Dispatch: 3&gt;"}, {"fullname": "smartinspectpython.sischedulercommand", "modulename": "smartinspectpython.sischedulercommand", "kind": "module", "doc": "<p>Module: si .py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sischedulercommand.SISchedulerCommand", "modulename": "smartinspectpython.sischedulercommand", "qualname": "SISchedulerCommand", "kind": "class", "doc": "<p>Represents a scheduler command as used by the SIScheduler class\nand the asynchronous protocol mode.</p>\n\n<p>This class is used by the SIScheduler class to enqueue protocol\noperations for later execution when operating in asynchronous\nmode. For detailed information about the asynchronous protocol \nmode, please refer to SIProtocol.IsValidOption.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sischedulercommand.SISchedulerCommand.__init__", "modulename": "smartinspectpython.sischedulercommand", "qualname": "SISchedulerCommand.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sischedulercommand.SISchedulerCommand.Action", "modulename": "smartinspectpython.sischedulercommand", "qualname": "SISchedulerCommand.Action", "kind": "variable", "doc": "<p>Gets the Action property value.</p>\n\n<p>Represents the scheduler action to execute. Please refer\nto the documentation of the SISchedulerAction enum for more\ninformation about possible values.</p>\n", "annotation": ": smartinspectpython.sischeduleraction.SISchedulerAction"}, {"fullname": "smartinspectpython.sischedulercommand.SISchedulerCommand.Size", "modulename": "smartinspectpython.sischedulercommand", "qualname": "SISchedulerCommand.Size", "kind": "variable", "doc": "<p>Gets the Size property value.</p>\n\n<p>Calculates and returns the total memory size occupied by\nthis scheduler command.</p>\n\n<p>This read-only property returns the total occupied memory\nsize of this scheduler command. This functionality is used by\nthe SIProtocol.IsValidOption to track the total size of scheduler commands.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sischedulercommand.SISchedulerCommand.State", "modulename": "smartinspectpython.sischedulercommand", "qualname": "SISchedulerCommand.State", "kind": "variable", "doc": "<p>Gets the State property value.</p>\n\n<p>Represents the optional scheduler command state object which\nprovides additional information about the scheduler command.\nThis property can be null.</p>\n", "annotation": ": object"}, {"fullname": "smartinspectpython.sischedulerqueue", "modulename": "smartinspectpython.sischedulerqueue", "kind": "module", "doc": "<p>Module: sischedulerqueue.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue", "kind": "class", "doc": "<p>Manages a queue of scheduler commands.</p>\n\n<p>This class is responsible for managing a queue of scheduler\ncommands. This functionality is needed by the\nSIProtocol.IsValidOption and the SIScheduler class. New commands can \nbe added with the Enqueue method. Commands can be dequeued with \nDequeue. This queue does not have a maximum size or count.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.__init__", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.OVERHEAD", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.OVERHEAD", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "24"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.Count", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.Count", "kind": "variable", "doc": "<p>Returns the current amount of scheduler commands in this queue.</p>\n\n<p>For each added scheduler command this counter is incremented\nby one and for each removed command (with Dequeue) this\ncounter is decremented by one. If the queue is empty, this\nproperty returns 0.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.Size", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.Size", "kind": "variable", "doc": "<p>Returns the current size of this queue in bytes.</p>\n\n<p>For each added scheduler command this counter is incremented\nby the size of the command (plus some internal management\noverhead) and for each removed command (with Dequeue) this\ncounter is then decremented again. If the queue is empty,\nthis property returns 0.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.Clear", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.Clear", "kind": "function", "doc": "<p>Removes all scheduler commands from this queue.</p>\n\n<p>Removing all scheduler commands of the queue is done by calling\nthe Dequeue method for each command in the current queue.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.Dequeue", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.Dequeue", "kind": "function", "doc": "<p>Returns a scheduler command and removes it from the queue.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The removed scheduler command or null if the queue does not\n  contain any packets.</p>\n</blockquote>\n\n<p>If the queue is not empty, this method removes the oldest\nscheduler command from the queue (also known as FIFO) and\nreturns it. The total Size of the queue is decremented by\nthe size of the returned command (plus some internal\nmanagement overhead).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sischedulercommand</span><span class=\"o\">.</span><span class=\"n\">SISchedulerCommand</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.Enqueue", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.Enqueue", "kind": "function", "doc": "<p>Adds a new scheduler command to the queue.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>command (SISchedulerCommand):</strong>  The command to add.</li>\n</ul>\n\n<p>This method adds the supplied scheduler command to the\nqueue. The Size of the queue is incremented by the size of\nthe supplied command (plus some internal management overhead).\nThis queue does not have a maximum size or count.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">command</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sischedulercommand</span><span class=\"o\">.</span><span class=\"n\">SISchedulerCommand</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischedulerqueue.SISchedulerQueue.Trim", "modulename": "smartinspectpython.sischedulerqueue", "qualname": "SISchedulerQueue.Trim", "kind": "function", "doc": "<p>Tries to skip and remove scheduler commands from this queue.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>size (int):</strong>  The minimum amount of bytes to remove from this queue.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if enough scheduler commands could be removed and false otherwise.</p>\n</blockquote>\n\n<p>This method removes the next WritePacket scheduler commands\nfrom this queue until the specified minimum amount of bytes\nhas been removed. Administrative scheduler commands (connect,\ndisconnect or dispatch) are not removed. If the queue is\ncurrently empty or does not contain enough WritePacket\ncommands to achieve the specified minimum amount of bytes,\nthis method returns false.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sischedulerqueueitem", "modulename": "smartinspectpython.sischedulerqueueitem", "kind": "module", "doc": "<p>Module: sischedulerqueueitem.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sischedulerqueueitem.SISchedulerQueueItem", "modulename": "smartinspectpython.sischedulerqueueitem", "qualname": "SISchedulerQueueItem", "kind": "class", "doc": "<p>SchedulerQueue item class.</p>\n"}, {"fullname": "smartinspectpython.sischedulerqueueitem.SISchedulerQueueItem.__init__", "modulename": "smartinspectpython.sischedulerqueueitem", "qualname": "SISchedulerQueueItem.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sischedulerqueueitem.SISchedulerQueueItem.Command", "modulename": "smartinspectpython.sischedulerqueueitem", "qualname": "SISchedulerQueueItem.Command", "kind": "variable", "doc": "<p>Scheduler command stored by this queue item.</p>\n", "annotation": ": smartinspectpython.sischedulercommand.SISchedulerCommand"}, {"fullname": "smartinspectpython.sischedulerqueueitem.SISchedulerQueueItem.Next", "modulename": "smartinspectpython.sischedulerqueueitem", "qualname": "SISchedulerQueueItem.Next", "kind": "variable", "doc": "<p>The next scheduler queue item in the queue.</p>\n", "annotation": ": smartinspectpython.sischedulerqueueitem.SISchedulerQueueItem"}, {"fullname": "smartinspectpython.sischedulerqueueitem.SISchedulerQueueItem.Previous", "modulename": "smartinspectpython.sischedulerqueueitem", "qualname": "SISchedulerQueueItem.Previous", "kind": "variable", "doc": "<p>The previous scheduler queue item in the queue.</p>\n", "annotation": ": smartinspectpython.sischedulerqueueitem.SISchedulerQueueItem"}, {"fullname": "smartinspectpython.sisession", "modulename": "smartinspectpython.sisession", "kind": "module", "doc": "<p>Module: sisession.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/29</td>\n  <td>3.0.22.0</td>\n  <td>Set Logger.propagate = False so that our exception capture process does not forward the message on to other loggers.</td>\n</tr>\n<tr>\n  <td></td>\n  <td></td>\n  <td>Changed methods that support SystemLogger functionality to allow bypass of logging to the system logger.</td>\n</tr>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Added SystemLogger functionality to allow logging to system logs.</td>\n</tr>\n<tr>\n  <td>2023/09/03</td>\n  <td>3.0.20.0</td>\n  <td>Changed all Session.LogX method signatures to use the SIColors enum type, or an integer value in ARGB format.</td>\n</tr>\n<tr>\n  <td>2023/07/11</td>\n  <td>3.0.16.0</td>\n  <td>Changed Session.GetMethodName method to use inspect.stack(0) instead of inspect.stack() to improve performace.</td>\n</tr>\n<tr>\n  <td>2023/06/28</td>\n  <td>3.0.14.0</td>\n  <td>Changed Session class to use temporary logger to capture exception details in LogException method.</td>\n</tr>\n<tr>\n  <td>2023/06/23</td>\n  <td>3.0.13.0</td>\n  <td>Changed Session LogAssigned method to properly format the LogMessage title value.</td>\n</tr>\n<tr>\n  <td>2023/06/17</td>\n  <td>3.0.12.0</td>\n  <td>Changed Session EnterMethod, LeaveMethod to include source file.</td>\n</tr>\n<tr>\n  <td></td>\n  <td></td>\n  <td>Added default title to LogAppDomain method.</td>\n</tr>\n<tr>\n  <td></td>\n  <td></td>\n  <td>Added exception handling in Session.LogSystem for user name value.  It was failing on Windows WSL systems, returning some sort of permissions error.</td>\n</tr>\n<tr>\n  <td>2023/06/17</td>\n  <td>3.0.11.0</td>\n  <td>Added *args support to Session class methods: LogDebug, LogVerbose, LogMessage, LogWarning, LogException, and LogFatal methods.</td>\n</tr>\n<tr>\n  <td>2023/06/15</td>\n  <td>3.0.9.0</td>\n  <td>Changed the Session.CurrentMethodName, CurrentMethodNameClass, and CurrentMethodNameClassNamespace properties to static methods.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sisession.SISession", "modulename": "smartinspectpython.sisession", "qualname": "SISession", "kind": "class", "doc": "<p>Logs all kind of data and variables to the SmartInspect Console\nor to a log file.</p>\n\n<p>The SISession class offers dozens of useful methods for sending\nany kind of data with the assistance of its SISession.Parent.\nSessions can send simple messages, warnings, errors and\nmore complex things like pictures, objects, exceptions, system\ninformation and much more. They are even able to send variable\nwatches, generate illustrated process and thread information\nor control the behavior of the SmartInspect Console. It is\npossible, for example, to clear the entire log in the Console by\ncalling the ClearLog method.</p>\n\n<p>Please note that log methods of this class do nothing and return\nimmediately if the session is currently not active (Active=False),\nits parent is disabled (Parent.Enabled=False), or the Level is not\nsufficient.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sisession.SISession.__init__", "modulename": "smartinspectpython.sisession", "qualname": "SISession.__init__", "kind": "function", "doc": "<p>Initializes a new SISession instance with the\ndefault color and the specified parent and name.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>parent (SmartInspect):</strong>  The parent of the new session.</li>\n<li><strong>name (str):</strong>  The name of the new session.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">parent</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, {"fullname": "smartinspectpython.sisession.SISession.Active", "modulename": "smartinspectpython.sisession", "qualname": "SISession.Active", "kind": "variable", "doc": "<p>Gets the Active property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if this session can send log message data to the active\n  protocols; otherwise, False to suspend logging activity.</p>\n</blockquote>\n\n<p>Specifies if the session is currently active.  </p>\n\n<p>If this property is set to false, all logging methods of this\nclass will return immediately and do nothing. Please note that\nthe Parent of this session also needs to be SmartInspect.Enabled\nin order to log information.</p>\n\n<p>This property is especially useful if you are using multiple\nsessions at once and want to deactivate a subset of these\nsessions. To deactivate all your sessions, you can use the\nSmartInspect.Enabled property of the Parent.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sisession.SISession.ColorBG", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ColorBG", "kind": "variable", "doc": "<p>Gets the ColorBG property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The background color used for this session in the SmartInspect Console.</p>\n</blockquote>\n\n<p>The session color helps you to identify Log Entries from\ndifferent sessions in the SmartInspect Console by changing\nthe background color.</p>\n", "annotation": ": smartinspectpython.sicolor.SIColor"}, {"fullname": "smartinspectpython.sisession.SISession.Level", "modulename": "smartinspectpython.sisession", "qualname": "SISession.Level", "kind": "variable", "doc": "<p>Gets the Level property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The log level of this session.</p>\n</blockquote>\n\n<p>Each SISession object can have its own log level. A log message\nis only logged if its log level is greater than or equal to\nthe log level of a session AND the session Parent. Log levels\ncan thus be used to limit the logging output to important\nmessages only.</p>\n", "annotation": ": smartinspectpython.silevel.SILevel"}, {"fullname": "smartinspectpython.sisession.SISession.SystemLogger", "modulename": "smartinspectpython.sisession", "qualname": "SISession.SystemLogger", "kind": "variable", "doc": "<p>A system Logger object, which can be used to write messages\nto a system-based log file as well as the SmartInspect log.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SystemLogger property value.</p>\n</blockquote>\n\n<p>This can be useful when adding logging to third-party products\nthat require a common logging mechanism, but also allows you to\ncapture extended logging information to a SmartInspect console.</p>\n\n<p>The following methods will write information to a Logger object\nassigned to the SystemLogger property: <br />\nLogDebug - calls <code>_LOGGER.debug(msg)</code> to log a message. <br />\nLogVerbose - calls <code>_LOGGER.debug(msg)</code> to log a message. <br />\nLogMessage - calls <code>_LOGGER.info(msg)</code> to log a message. <br />\nLogWarning - calls <code>_LOGGER.warning(msg)</code> to log a message. <br />\nLogError - calls <code>_LOGGER.error(msg)</code> to log a message. <br />\nLogException - calls <code>_LOGGER.exception(ex)</code> to log an exception message. <br />\nLogFatal - calls <code>_LOGGER.critical(msg)</code> to log a message.  </p>\n\n<p><details>\n  <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=localhost,port=4228,timeout=30000)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># configure system logging (to file).</span>\n<span class=\"kn\">import</span> <span class=\"nn\">logging</span>\n<span class=\"kn\">import</span> <span class=\"nn\">logging.handlers</span>\n<span class=\"kn\">import</span> <span class=\"nn\">os</span>\n<span class=\"n\">exedir</span> <span class=\"o\">=</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">dirname</span><span class=\"p\">(</span><span class=\"n\">sys</span><span class=\"o\">.</span><span class=\"n\">argv</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n<span class=\"n\">logfilePath</span><span class=\"p\">:</span><span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"n\">exedir</span> <span class=\"o\">+</span> <span class=\"s2\">&quot;/logfiles/&quot;</span>\n<span class=\"n\">handler</span> <span class=\"o\">=</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">handlers</span><span class=\"o\">.</span><span class=\"n\">WatchedFileHandler</span><span class=\"p\">(</span><span class=\"n\">logfilePath</span><span class=\"o\">+</span><span class=\"s2\">&quot;test_SystemLogger_Output.log&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">formatter</span> <span class=\"o\">=</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Formatter</span><span class=\"p\">(</span><span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">BASIC_FORMAT</span><span class=\"p\">)</span>\n<span class=\"n\">handler</span><span class=\"o\">.</span><span class=\"n\">setFormatter</span><span class=\"p\">(</span><span class=\"n\">formatter</span><span class=\"p\">)</span>\n<span class=\"n\">_LOGGER</span> <span class=\"o\">=</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">getLogger</span><span class=\"p\">()</span>\n<span class=\"n\">_LOGGER</span><span class=\"o\">.</span><span class=\"n\">setLevel</span><span class=\"p\">(</span><span class=\"s2\">&quot;INFO&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_LOGGER</span><span class=\"o\">.</span><span class=\"n\">addHandler</span><span class=\"p\">(</span><span class=\"n\">handler</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># get smartinspect logger reference, and add system logging.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">SystemLogger</span> <span class=\"o\">=</span> <span class=\"n\">_LOGGER</span>\n\n<span class=\"c1\"># data used by various tests.</span>\n<span class=\"n\">argsVar1</span><span class=\"p\">:</span><span class=\"nb\">str</span><span class=\"o\">=</span><span class=\"s2\">&quot;Argument 1 Value&quot;</span>\n<span class=\"n\">argsVar2</span><span class=\"p\">:</span><span class=\"nb\">int</span><span class=\"o\">=</span><span class=\"mi\">1000</span>\n\n<span class=\"c1\"># log some messages of different logging levels.</span>\n<span class=\"c1\"># note that the &quot;LogDebug&quot; messages will not appear in the system logging file due to &quot;INFO&quot; system logging level.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a debug message.  It will not be displayed if Level=Verbose or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a debug message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Verbose or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogVerbose</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a verbose message.  It will not be displayed if Level=Message or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogVerbose</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a verbose message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Message or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a message.  It will not be displayed if Level=Warning or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Warning or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a warning message.  It will not be displayed if Level=Error or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a warning message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Error or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a error message.  It will not be displayed if Level=Fatal or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a error message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Fatal or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># log an exception.</span>\n<span class=\"k\">try</span><span class=\"p\">:</span>\n\n    <span class=\"k\">raise</span> <span class=\"ne\">Exception</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a forced exception used to test the LogException method.&quot;</span><span class=\"p\">)</span>\n\n<span class=\"k\">except</span> <span class=\"ne\">Exception</span> <span class=\"k\">as</span> <span class=\"n\">ex</span><span class=\"p\">:</span>\n\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogException</span><span class=\"p\">(</span><span class=\"s2\">&quot;LogException - with Custom title, exception details in SI Console viewer area.&quot;</span><span class=\"p\">,</span> <span class=\"n\">ex</span><span class=\"p\">)</span>\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogException</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">ex</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p><br/>\nCreate A New Session For Each Module</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=localhost,port=4228,timeout=30000)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># configure system logging (to file).</span>\n<span class=\"kn\">import</span> <span class=\"nn\">logging</span>\n<span class=\"kn\">import</span> <span class=\"nn\">logging.handlers</span>\n<span class=\"kn\">import</span> <span class=\"nn\">os</span>\n<span class=\"n\">exedir</span> <span class=\"o\">=</span> <span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">path</span><span class=\"o\">.</span><span class=\"n\">dirname</span><span class=\"p\">(</span><span class=\"n\">sys</span><span class=\"o\">.</span><span class=\"n\">argv</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n<span class=\"n\">logfilePath</span><span class=\"p\">:</span><span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"n\">exedir</span> <span class=\"o\">+</span> <span class=\"s2\">&quot;/logfiles/&quot;</span>\n<span class=\"n\">handler</span> <span class=\"o\">=</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">handlers</span><span class=\"o\">.</span><span class=\"n\">WatchedFileHandler</span><span class=\"p\">(</span><span class=\"n\">logfilePath</span><span class=\"o\">+</span><span class=\"s2\">&quot;test_SystemLogger_Output.log&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">formatter</span> <span class=\"o\">=</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">Formatter</span><span class=\"p\">(</span><span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">BASIC_FORMAT</span><span class=\"p\">)</span>\n<span class=\"n\">handler</span><span class=\"o\">.</span><span class=\"n\">setFormatter</span><span class=\"p\">(</span><span class=\"n\">formatter</span><span class=\"p\">)</span>\n<span class=\"n\">_LOGGER</span> <span class=\"o\">=</span> <span class=\"n\">logging</span><span class=\"o\">.</span><span class=\"n\">getLogger</span><span class=\"p\">()</span>\n<span class=\"n\">_LOGGER</span><span class=\"o\">.</span><span class=\"n\">setLevel</span><span class=\"p\">(</span><span class=\"s2\">&quot;INFO&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_LOGGER</span><span class=\"o\">.</span><span class=\"n\">addHandler</span><span class=\"p\">(</span><span class=\"n\">handler</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># get smartinspect logger reference; create a new session for this module name.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">GetSession</span><span class=\"p\">(</span><span class=\"vm\">__name__</span><span class=\"p\">)</span>\n<span class=\"k\">if</span> <span class=\"p\">(</span><span class=\"n\">_logsi</span> <span class=\"o\">==</span> <span class=\"kc\">None</span><span class=\"p\">):</span>\n    <span class=\"n\">_logsi</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">AddSession</span><span class=\"p\">(</span><span class=\"vm\">__name__</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">SystemLogger</span> <span class=\"o\">=</span> <span class=\"n\">_LOGGER</span>\n\n<span class=\"c1\"># data used by various tests.</span>\n<span class=\"n\">argsVar1</span><span class=\"p\">:</span><span class=\"nb\">str</span><span class=\"o\">=</span><span class=\"s2\">&quot;Argument 1 Value&quot;</span>\n<span class=\"n\">argsVar2</span><span class=\"p\">:</span><span class=\"nb\">int</span><span class=\"o\">=</span><span class=\"mi\">1000</span>\n\n<span class=\"c1\"># log some messages of different logging levels.</span>\n<span class=\"c1\"># note that the &quot;LogDebug&quot; messages will not appear in the system logging file due to &quot;INFO&quot; system logging level.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a debug message.  It will not be displayed if Level=Verbose or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a debug message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Verbose or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogVerbose</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a verbose message.  It will not be displayed if Level=Message or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogVerbose</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a verbose message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Message or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a message.  It will not be displayed if Level=Warning or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Warning or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a warning message.  It will not be displayed if Level=Error or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a warning message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Error or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a error message.  It will not be displayed if Level=Fatal or above.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a error message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.  It will not be displayed if Level=Fatal or above.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message with *args: str1=&#39;</span><span class=\"si\">%s</span><span class=\"s2\">&#39;, int2=</span><span class=\"si\">%i</span><span class=\"s2\">.&quot;</span><span class=\"p\">,</span> <span class=\"n\">argsVar1</span><span class=\"p\">,</span> <span class=\"n\">argsVar2</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># log an exception.</span>\n<span class=\"k\">try</span><span class=\"p\">:</span>\n\n    <span class=\"k\">raise</span> <span class=\"ne\">Exception</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a forced exception used to test the LogException method.&quot;</span><span class=\"p\">)</span>\n\n<span class=\"k\">except</span> <span class=\"ne\">Exception</span> <span class=\"k\">as</span> <span class=\"n\">ex</span><span class=\"p\">:</span>\n\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogException</span><span class=\"p\">(</span><span class=\"s2\">&quot;LogException - with Custom title, exception details in SI Console viewer area.&quot;</span><span class=\"p\">,</span> <span class=\"n\">ex</span><span class=\"p\">)</span>\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogException</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">ex</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "annotation": ": logging.Logger"}, {"fullname": "smartinspectpython.sisession.SISession.Name", "modulename": "smartinspectpython.sisession", "qualname": "SISession.Name", "kind": "variable", "doc": "<p>Gets the Name property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The session name used for Log Entries.</p>\n</blockquote>\n\n<p>The session name helps you to identify Log Entries from\ndifferent sessions in the SmartInspect Console. If you set\nthis property to null, the session name will be empty when\nsending Log Entries.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sisession.SISession.Parent", "modulename": "smartinspectpython.sisession", "qualname": "SISession.Parent", "kind": "variable", "doc": "<p>Gets the Name property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The parent SmartInspect instance that owns the session.</p>\n</blockquote>\n\n<p>The parent of a session is a SmartInspect instance. It is\nresponsible for sending the packets to the SmartInspect Console\nor for writing them to a file. If the SmartInspect.Enabled\nproperty of the parent is false, all logging methods\nof this class will return immediately and do nothing.</p>\n"}, {"fullname": "smartinspectpython.sisession.SISession.AddCheckpoint", "modulename": "smartinspectpython.sisession", "qualname": "SISession.AddCheckpoint", "kind": "function", "doc": "<p>Increments the counter of a named checkpoint and logs a\nmessage with a custom log level and an optional message.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the checkpoint to increment.</li>\n<li><strong>details (str):</strong>  An optional message to include in the resulting log entry.\nCan be null / None.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method increments the counter for the given checkpoint\nand then logs a message using \"%checkpoint% #N\" as title where\n%checkpoint% stands for the name of the checkpoint and N for\nthe incremented counter value. The initial value of the counter\nfor a given checkpoint is 0. Specify the details parameter to\ninclude an optional message in the resulting log entry. You\ncan use the ResetCheckpoint method to reset the counter to 0\nagain.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">details</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ClearAll", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ClearAll", "kind": "function", "doc": "<p>Resets the whole Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n</ul>\n\n<p>This method resets the whole Console. This means that all\nWatches, Log Entries, Process Flow entries and AutoViews\nwill be deleted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ClearAutoViews", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ClearAutoViews", "kind": "function", "doc": "<p>Clears all AutoViews in the Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ClearLog", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ClearLog", "kind": "function", "doc": "<p>Clears all Log Entries in the Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ClearProcessFlow", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ClearProcessFlow", "kind": "function", "doc": "<p>Clears all Process Flow entries in the Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ClearWatches", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ClearWatches", "kind": "function", "doc": "<p>Clears all Watches in the Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.CurrentMethodName", "modulename": "smartinspectpython.sisession", "qualname": "SISession.CurrentMethodName", "kind": "function", "doc": "<p>Returns the fully-qualified method name of the current stack level in the\nform of \"MethodName\".</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The fully-qualified method name of the current stack level in the\n  form of \"MethodName\".</p>\n</blockquote>\n\n<p>Reflection is used to determine the method name.\nIf method info could not be queried, \"&lt;Unknown&gt;\" is returned.</p>\n\n<p>No exception will be thrown by this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.CurrentMethodNameClass", "modulename": "smartinspectpython.sisession", "qualname": "SISession.CurrentMethodNameClass", "kind": "function", "doc": "<p>Returns the fully-qualified method name of the current stack level in the\nform of \"ClassName.MethodName\".</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The fully-qualified method name of the current stack level in the\n  form of \"ClassName.MethodName\".</p>\n</blockquote>\n\n<p>Reflection is used to determine the method name.\nIf method info could not be queried, \"&lt;Unknown&gt;\" is returned.</p>\n\n<p>No exception will be thrown by this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.CurrentMethodNameClassNamespace", "modulename": "smartinspectpython.sisession", "qualname": "SISession.CurrentMethodNameClassNamespace", "kind": "function", "doc": "<p>Returns the fully-qualified method name of the current stack level in the\nform of \"Namespace.ClassName.MethodName\".</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The fully-qualified method name of the current stack level in the\n  form of \"Namespace.ClassName.MethodName\".</p>\n</blockquote>\n\n<p>Reflection is used to determine the method name.\nIf method info could not be queried, \"&lt;Unknown&gt;\" is returned.</p>\n\n<p>No exception will be thrown by this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.DecCounter", "modulename": "smartinspectpython.sisession", "qualname": "SISession.DecCounter", "kind": "function", "doc": "<p>Decrements a named counter by one and automatically\nsends its name and value as integer watch with a custom log\nlevel.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the counter to log.</li>\n</ul>\n\n<p>The SISession class tracks a list of so called named counters.\nA counter has a name and a value of type integer. This method\ndecrements the value for the specified counter by one and then\nsends a normal integer watch with the name and value of the\ncounter. The initial value of a counter is 0. To reset the\nvalue of a counter to 0 again, you can call ResetCounter.</p>\n\n<p>See IncCounter for a method which increments the value of a\nnamed counter instead of decrementing it.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.EnterMethod", "modulename": "smartinspectpython.sisession", "qualname": "SISession.EnterMethod", "kind": "function", "doc": "<p>Enters a method by using a custom log level.\nThe resulting method name consists of the FullName of the\ntype of the supplied instance parameter, followed by a dot\nand the supplied methodName argument.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>methodName (str):</strong>  The name of the method; otherwise null to retrieve the \ncurrent method name from inspect data.</li>\n</ul>\n\n<p>The EnterMethod method notifies the Console that a new\nmethod has been entered. The Console includes the method in\nthe method hierarchy. If this method is used consequently, a\nfull call stack is visible in the Console which helps locating\nbugs in the source code. Please see the LeaveMethod method as \nthe counter piece to EnterMethod.</p>\n\n<p>If the methodName is null, then the currently executing method name\nis derived from calling inspect.stack.  The function name, module name,\nand source line number are displayed.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">methodName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.EnterProcess", "modulename": "smartinspectpython.sisession", "qualname": "SISession.EnterProcess", "kind": "function", "doc": "<p>Enters a new process by using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>processName (str):</strong>  The name of the process.</li>\n</ul>\n\n<p>The EnterProcess method notifies the Console that a new\nprocess has been entered. The Console displays this process\nin the Process Flow toolbox. Please see the LeaveProcess\nmethod as the counter piece to EnterProcess.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">processName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.EnterThread", "modulename": "smartinspectpython.sisession", "qualname": "SISession.EnterThread", "kind": "function", "doc": "<p>Enters a new thread by using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>threadName (str):</strong>  The name of the thread.</li>\n</ul>\n\n<p>The EnterThread method notifies the Console that a new\nthread has been entered. The Console displays this thread\nin the Process Flow toolbox. Please see the LeaveThread\nmethod as the counter piece to EnterThread.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">threadName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.GetMethodName", "modulename": "smartinspectpython.sisession", "qualname": "SISession.GetMethodName", "kind": "function", "doc": "<p>Returns the callers method name for the specified stack level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stackLevel (int):</strong>  The Stack Frame level to query - defaults to 1 if zero is specified.</li>\n<li><strong>includeSourcePos (bool):</strong>  True to append the module name and source line # to the method name; \notherwise False (default) to return only the method name.</li>\n<li><strong>includeNameSpace (bool):</strong>  True to prefix the returned method name with the name-space identifier; otherwise False to\nnot return the name-space identifier.</li>\n<li><strong>includeClassName (bool):</strong>  True to prefix the returned method name with the class name; otherwise False to\nnot return the class name.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The callers method name.</p>\n</blockquote>\n\n<p>Reflection is used to determine the method name for the specified stack level. <br />\nIf method info could not be queried, \"&lt;Unknown&gt;\" is returned.</p>\n\n<p>No exception will be thrown by this method.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">stackLevel</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">includeNameSpace</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">includeClassName</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.IncCounter", "modulename": "smartinspectpython.sisession", "qualname": "SISession.IncCounter", "kind": "function", "doc": "<p>Increments a named counter by one and automatically\nsends its name and value as integer watch with a custom log\nlevel.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the counter to log.</li>\n</ul>\n\n<p>The SISession class tracks a list of so called named counters.\nA counter has a name and a value of type integer. This method\nincrements the value for the specified counter by one and then\nsends a normal integer watch with the name and value of the\ncounter. The initial value of a counter is 0. To reset the\nvalue of a counter to 0 again, you can call ResetCounter.</p>\n\n<p>See DecCounter for a method which decrements the value of a\nnamed counter instead of incrementing it.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.IsOn", "modulename": "smartinspectpython.sisession", "qualname": "SISession.IsOn", "kind": "function", "doc": "<p>Indicates if information can be logged for a certain log level or not.  </p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level to check for.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if information can be logged and false otherwise.</p>\n</blockquote>\n\n<p>This method is used by the logging methods in this class\nto determine if information should be logged or not. When\nextending the SISession class by adding new log methods to a\nderived class it is recommended to call this method first.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LeaveMethod", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LeaveMethod", "kind": "function", "doc": "<p>Leaves a method by using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>methodName (str):</strong>  The name of the method; otherwise null to retrieve the \ncurrent method name from inspect data.</li>\n</ul>\n\n<p>The LeaveMethod method notifies the Console that a method\nhas been left. The Console closes the current method in the\nmethod hierarchy. If this method is used consequently, a full\ncall stack is visible in the Console which helps locating bugs\nin the source code. Please see the EnterMethod method as the \ncounter piece to EnterMethod.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">methodName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LeaveProcess", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LeaveProcess", "kind": "function", "doc": "<p>Leaves a process by using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>processName (str):</strong>  The name of the process.</li>\n</ul>\n\n<p>The LeaveProcess method notifies the Console that a process\nhas finished. The Console displays this change in the Process\nFlow toolbox. Please see the EnterProcess method as the\ncounter piece to LeaveProcess.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">processName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LeaveThread", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LeaveThread", "kind": "function", "doc": "<p>Leaves a thread by using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>threadName (str):</strong>  The name of the thread.</li>\n</ul>\n\n<p>The LeaveThread method notifies the Console that a thread\nhas finished. The Console displays this change in the Process\nFlow toolbox. Please see the EnterThread method as the\ncounter piece to LeaveThread.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">threadName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogAppDomain", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogAppDomain", "kind": "function", "doc": "<p>Logs information about an application and its setup with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs information about the current application and its setup.\nThis is not quite the same as the C# equivalent, but it does log similar properties.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogArray", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogArray", "kind": "function", "doc": "<p>Logs the content of an array with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console - \"Current stack trace\" is used if one is not supplied.</li>\n<li><strong>oArray (array):</strong>  The array to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method iterates through the supplied array and calls SIObjectRenderer.RenderObject to\nrender every element into a string. These elements will be displayed in a listview in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">oArray</span><span class=\"p\">:</span> <span class=\"n\">array</span><span class=\"o\">.</span><span class=\"n\">array</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogAssert", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogAssert", "kind": "function", "doc": "<p>Logs an assert message if a condition is false with\na log level of SILevel.Error.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>condition (bool):</strong>  The condition to check.</li>\n<li><strong>title (str):</strong>  The title of the Log Entry.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>An assert message is logged if this method is called with a\ncondition parameter of the value false. No Log Entry\nis generated if this method is called with a\ncondition parameter of the value true.</p>\n\n<p>A typical usage of this method would be to test if a variable\nis not set to null before you use it. To do this, you just need\nto insert a LogAssert call to the code section in question with\n\"instance != null\" as first parameter. If the reference is null\nand thus the expression evaluates to false, a message is logged.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogAssigned", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogAssigned", "kind": "function", "doc": "<p>Logs whether a variable is assigned or not with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the variable.</li>\n<li><strong>value (object):</strong>  The variable value which should be checked for null.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>If the value argument is null, then \": Not assigned\",\notherwise \": Assigned\" will be appended to the name before\nthe Log Entry is sent.</p>\n\n<p>This method is useful to check source code for null references\nin places where you experienced or expect problems and want to\nlog possible null references.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">object</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogBinary", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogBinary", "kind": "function", "doc": "<p>Logs a byte array with a custom log level and\ndisplays it in a hex viewer.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>buffer (bytes):</strong>  The byte array to display in the hex viewer.</li>\n<li><strong>offset (int):</strong>  The byte offset (zero-based) of buffer at which to display data from.</li>\n<li><strong>count (int):</strong>  The amount of bytes to display.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">buffer</span><span class=\"p\">:</span> <span class=\"nb\">bytes</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">count</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogBinaryFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogBinaryFile", "kind": "function", "doc": "<p>Logs a binary file and displays its content in\na hex viewer using a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The binary file to display in a hex viewer.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogBinaryStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogBinaryStream", "kind": "function", "doc": "<p>Logs a binary stream with a custom log level and\ndisplays its content in a hex viewer.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedReader):</strong>  The binary stream to display in a hex viewer.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogBitmapFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogBitmapFile", "kind": "function", "doc": "<p>Logs a bitmap file and displays it in the Console\nusing a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The bitmap file to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogBitmapStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogBitmapStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and\ninterprets its content as a bitmap.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedReader):</strong>  The stream to display as bitmap.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogBool", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogBool", "kind": "function", "doc": "<p>Logs a bool value with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (bool):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a boolean variable.\nA title like \"name = True\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogByte", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogByte", "kind": "function", "doc": "<p>Logs a byte value with an optional hexadecimal representation \nand custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (int):</strong>  The variable value.</li>\n<li><strong>includeHex (bool):</strong>  Indicates if a hexadecimal representation should be included (True) or not (False).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a single byte variable.\nA title like \"name = 10\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">includeHex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogChar", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogChar", "kind": "function", "doc": "<p>Logs a chr value with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (chr):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a chr variable.\nA title like \"name = 'c'\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">built</span><span class=\"o\">-</span><span class=\"ow\">in</span> <span class=\"n\">function</span> <span class=\"nb\">chr</span><span class=\"o\">&gt;</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCollection", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCollection", "kind": "function", "doc": "<p>Logs the content of a collection with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console; \"Current stack trace\" is used if one is not supplied.</li>\n<li><strong>oColl (Collection):</strong>  The collection to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method iterates through the supplied collection and calls SIObjectRenderer.RenderObject to\nrender every value into a string. These values will be displayed in a listview in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">oColl</span><span class=\"p\">:</span> <span class=\"n\">Collection</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogColored", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogColored", "kind": "function", "doc": "<p>Logs a colored message with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li><strong>title (str):</strong>  The message to log.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogComplex", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogComplex", "kind": "function", "doc": "<p>Logs a complex value with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (float):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a complex variable.\nA title like \"name = 3.14159\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">complex</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogConditional", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogConditional", "kind": "function", "doc": "<p>Logs a conditional message with a custom log level. The message \nis created with a format string and a related array of arguments.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>condition (bool):</strong>  The condition to evaluate.</li>\n<li><strong>title (str):</strong>  The title of the conditional message.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method only sends a message if the passed 'condition'\nargument evaluates to true. If 'condition' is false, this\nmethod has no effect and nothing is logged. This method is\nthus the counter piece to LogAssert.</p>\n\n<p>This version of the method accepts a format string and a\nrelated array of arguments. These parameters will be passed to\nthe String.Format method and the resulting string will be the\nconditional message.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCurrentAppDomain", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCurrentAppDomain", "kind": "function", "doc": "<p>Logs information about the current application and its setup with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs information about the current application and its setup.\nThis is not quite the same as the C# equivalent, but it does log similar properties.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCurrentStackTrace", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCurrentStackTrace", "kind": "function", "doc": "<p>Logs the current stack trace with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console; \"Current stack trace\" is used if one is not supplied.</li>\n<li><strong>limit (int):</strong>  The number of frames to print (specify None to print all remaining frames).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the current stack trace. The resulting Log Entry contains all methods including the\nrelated classes that are currently on the stack. Furthermore, the filename, line and columns numbers are included.</p>\n\n<p>Please note that the stack frame information results will NOT include 2 frames that are used\nby the SmartInspect API to process the frame data.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">limit</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCurrentThread", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCurrentThread", "kind": "function", "doc": "<p>Logs information about the current thread with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs information about the current thread. This\nincludes its name, its current state and more.</p>\n\n<p>LogCurrentThread is especially useful in a multi-threaded\nprogram like in a network server application. By using this\nmethod you can easily track all threads of a process and\nobtain detailed information about them.</p>\n\n<p>See LogThread for a more general method which can handle any thread.\npublic void LogCurrentThread(Level level, string title)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCustomContext", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCustomContext", "kind": "function", "doc": "<p>Logs a custom viewer context with a custom log level.\nviewer ID and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>lt (SILogEntryType):</strong>  The custom Log Entry type.</li>\n<li><strong>ctx (SIViewerContext):</strong>  The viewer context which holds the actual data and the appropriate viewer ID.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lt</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentrytype</span><span class=\"o\">.</span><span class=\"n\">SILogEntryType</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">ctx</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewercontext</span><span class=\"o\">.</span><span class=\"n\">SIViewerContext</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCustomFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCustomFile", "kind": "function", "doc": "<p>Logs the content of a file using a custom\nLog Entry type, viewer ID and title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The file to log.</li>\n<li>lt (SILogEntryType)\nThe custom Log Entry type.</li>\n<li><strong>vi (SIViewerId):</strong>  The custom viewer ID which specifies the way the Console\nhandles the file content.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the content of the supplied file using a\ncustom Log Entry type and viewer ID. The parameters control\nthe way the content of the file is displayed in the Console.\nThus you can extend the functionality of the SmartInspect\nlibrary with this method.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lt</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentrytype</span><span class=\"o\">.</span><span class=\"n\">SILogEntryType</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCustomReader", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCustomReader", "kind": "function", "doc": "<p>Logs the content of a text reader using a custom Log\nEntry type and viewer ID and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>reader (TextIOWrapper):</strong>  The text reader to log.</li>\n<li><strong>lt (SILogEntryType):</strong>  The custom Log Entry type.</li>\n<li><strong>vi (SIViewerId):</strong>  The custom viewer ID which specifies the way the Console\nhandles the reader content.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the content of the supplied reader using \ncustom Log Entry type and viewer ID. The parameters control\nthe way the content of the reader is displayed in the Console.\nThus you can extend the functionality of the SmartInspect\nlibrary with this method.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">reader</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lt</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentrytype</span><span class=\"o\">.</span><span class=\"n\">SILogEntryType</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCustomStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCustomStream", "kind": "function", "doc": "<p>Logs the content of a stream using a custom Log\nEntry type and viewer ID and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedReader):</strong>  The stream to log (BufferedReader).</li>\n<li><strong>lt (SILogEntryType):</strong>  The custom Log Entry type.</li>\n<li><strong>vi (SIViewerId):</strong>  The custom viewer ID which specifies the way the Console\nhandles the stream content.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the content of the supplied stream using a\ncustom Log Entry type and viewer ID. The parameters control\nthe way the content of the stream is displayed in the Console.\nThus you can extend the functionality of the SmartInspect\nPython library with this method.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lt</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentrytype</span><span class=\"o\">.</span><span class=\"n\">SILogEntryType</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogCustomText", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogCustomText", "kind": "function", "doc": "<p>Logs custom text using a custom Log Entry type and\nviewer ID and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>text (str):</strong>  The text to log.</li>\n<li><strong>lt (SILogEntryType):</strong>  The custom Log Entry type.</li>\n<li><strong>vi (SIViewerId):</strong>  The custom viewer ID which specifies the way the Console\nhandles the text content.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lt</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentrytype</span><span class=\"o\">.</span><span class=\"n\">SILogEntryType</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogDateTime", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogDateTime", "kind": "function", "doc": "<p>Logs a datetime value with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (str):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a datetime variable.\nA title like \"name = 05/15/2023 02:15:30 PM\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">module</span> <span class=\"s1\">&#39;datetime&#39;</span> <span class=\"kn\">from</span> <span class=\"s1\">&#39;C:</span><span class=\"se\">\\\\</span><span class=\"s1\">Program Files</span><span class=\"se\">\\\\</span><span class=\"s1\">Python39</span><span class=\"se\">\\\\</span><span class=\"s1\">lib</span><span class=\"se\">\\\\</span><span class=\"s1\">datetime.py&#39;</span><span class=\"o\">&gt;</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogDebug", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogDebug", "kind": "function", "doc": "<p>Logs a debug message with a log level of SILevel.Debug.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  The message to log.</li>\n<li><strong>*args:</strong>  Format arguments for the title argument.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method will also log a message to the system log if the <code>SystemLogger</code> property is set.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logToSystemLogger</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogDictionary", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogDictionary", "kind": "function", "doc": "<p>Logs the content of a dictionary with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console; \"Current stack trace\" is used if one is not supplied.</li>\n<li><strong>oDict (dict):</strong>  The dictionary to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method iterates through the supplied dictionary and calls SIObjectRenderer.RenderObject to\nrender every key/value pair into a string. These pairs will be displayed in a key/value viewer \nin the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">oDict</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogEnumerable", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogEnumerable", "kind": "function", "doc": "<p>Logs the content of a list with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console; \"Current stack trace\" is used if one is not supplied.</li>\n<li><strong>oList (list):</strong>  The list to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method iterates through the supplied list and calls SIObjectRenderer.RenderObject to\nrender every element into a string. These elements will be displayed in a listview in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">oList</span><span class=\"p\">:</span> <span class=\"nb\">list</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogError", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogError", "kind": "function", "doc": "<p>Logs a error message with a log level of SILevel.Error.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  The message to log.</li>\n<li><strong>*args:</strong>  Format arguments for the title argument.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li><strong>logToSystemLogger (bool):</strong>  True to log the exception to the SystemLogger instance (if one was supplied); <br />\notherwise, False to not log the exception to the SystemLogger instance. <br />\nDefault is True.</li>\n</ul>\n\n<p>This method will also log a message to the system log if the <code>SystemLogger</code> property is set.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logToSystemLogger</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogException", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogException", "kind": "function", "doc": "<p>Logs the content of an exception with a custom\ntitle and a log level of SILevel.Error.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>ex (Exception):</strong>  The exception to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li><strong>logToSystemLogger (bool):</strong>  True to log the exception to the SystemLogger instance (if one was supplied); <br />\notherwise, False to not log the exception to the SystemLogger instance. <br />\nDefault is True.</li>\n</ul>\n\n<p>This method extracts the exception message and stack trace\nfrom the supplied exception and logs an error with this data.\nIt is especially useful if you place calls to this method in\nexception handlers. See LogError for a more general method\nwith a similar intention.</p>\n\n<p>This method will also automatically log the exception to the \nsystem log if the <code>SystemLogger</code> property is set and the \nlogToSystemLogger argument is True.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"k\">try</span><span class=\"p\">:</span>\n\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;Forcing a divide by zero error ...&quot;</span><span class=\"p\">)</span>\n    <span class=\"mi\">1</span><span class=\"o\">/</span><span class=\"mi\">0</span>   <span class=\"c1\"># force an exception</span>\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;You should not see this message due to the above exception.&quot;</span><span class=\"p\">)</span>\n\n<span class=\"k\">except</span> <span class=\"ne\">Exception</span> <span class=\"k\">as</span> <span class=\"n\">ex</span><span class=\"p\">:</span>\n\n    <span class=\"c1\"># log exceptions.</span>\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogException</span><span class=\"p\">(</span><span class=\"s2\">&quot;*** Caught exception!&quot;</span><span class=\"p\">,</span> <span class=\"n\">ex</span><span class=\"p\">)</span>\n    <span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogException</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span> <span class=\"n\">ex</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">ex</span><span class=\"p\">:</span> <span class=\"ne\">Exception</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logToSystemLogger</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogFatal", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogFatal", "kind": "function", "doc": "<p>Logs a fatal error message with a log level of SILevel.Fatal.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  The message to log.</li>\n<li><strong>*args:</strong>  Format arguments for the title argument.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li><strong>logToSystemLogger (bool):</strong>  True to log the exception to the SystemLogger instance (if one was supplied); <br />\notherwise, False to not log the exception to the SystemLogger instance. <br />\nDefault is True.</li>\n</ul>\n\n<p>This method is ideally used in error handling code such as\nexception handlers. If this method is used consequently, it\nis easy to troubleshoot and solve bugs in applications or\nconfigurations. See LogError for a method which does not\ndescribe fatal but recoverable errors.</p>\n\n<p>This method will also log a message to the system log if the <code>SystemLogger</code> property is set.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># log messsages.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message in regular background color.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message in RED background color.&quot;</span><span class=\"p\">,</span> <span class=\"n\">SIColors</span><span class=\"o\">.</span><span class=\"n\">Red</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logToSystemLogger</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogFloat", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogFloat", "kind": "function", "doc": "<p>Logs a float value with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (float):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a float variable.\nA title like \"name = 3.14159\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogHtml", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogHtml", "kind": "function", "doc": "<p>Logs HTML code with a custom log level and\ndisplays it in a web browser.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>html (str):</strong>  The HTML source code to display.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the supplied HTML source code. The source\ncode is displayed as a website in the web viewer of the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">html</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogHtmlFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogHtmlFile", "kind": "function", "doc": "<p>Logs an HTML file and displays the content in a\nweb browser using a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The HTML file to display.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the HTML source code of the supplied file. The\nsource code is displayed as a website in the web viewer of the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogHtmlReader", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogHtmlReader", "kind": "function", "doc": "<p>Logs a text reader with a custom log level and displays\nthe content in a web browser.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>reader (TextIOWrapper):</strong>  The text reader to display (TextReader).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the HTML source code of the supplied reader.\nThe source code is displayed as a website in the web viewer of\nthe Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">reader</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogHtmlStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogHtmlStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and displays\nthe content in a web browser.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedReader):</strong>  The stream to display.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the HTML source code of the supplied stream.\nThe source code is displayed as a website in the web viewer of\nthe Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogIconFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogIconFile", "kind": "function", "doc": "<p>Logs a Windows icon file and displays it in the\nConsole using a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The Windows icon file to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogIconStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogIconStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and\ninterprets its content as Windows icon.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedReader):</strong>  The stream to display as Windows icon.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogInt", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogInt", "kind": "function", "doc": "<p>Logs an integer value with an optional hexadecimal representation \nand custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (int):</strong>  The variable value.</li>\n<li><strong>includeHex (bool):</strong>  Indicates if a hexadecimal representation should be included (True) or not (False).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a integer variable.\nA title like \"name = 10\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">includeHex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogInternalError", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogInternalError", "kind": "function", "doc": "<p>Logs an internal error with a log level of SILevel.Error.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  A string which describes the internal error.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs an internal error. Such errors can occur\nif session methods are invoked with invalid arguments. For\nexample, if you pass an invalid format string to LogMessage,\nthe exception will be caught and an internal error with the\nexception message will be sent.</p>\n\n<p>This method is also intended to be used in derived classes\nto report any errors in your own methods.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogJpegFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogJpegFile", "kind": "function", "doc": "<p>Logs a JPEG file and displays it in the Console\nusing a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The JPEG file to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogJpegStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogJpegStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and\ninterprets its content as JPEG image.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BuffereReader):</strong>  The stream to display as JPEG image.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogMessage", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogMessage", "kind": "function", "doc": "<p>Logs a message with a log level of SILevel.Message.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  The message to log.</li>\n<li><strong>*args:</strong>  Format arguments for the title argument.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li><strong>logToSystemLogger (bool):</strong>  True to log the exception to the SystemLogger instance (if one was supplied); <br />\notherwise, False to not log the exception to the SystemLogger instance. <br />\nDefault is True.</li>\n</ul>\n\n<p>This method will also log a message to the system log if the <code>SystemLogger</code> property is set.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logToSystemLogger</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogMetafileFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogMetafileFile", "kind": "function", "doc": "<p>Logs a Windows Metafile file and displays it in\nthe Console using a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The Windows Metafile file to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogMetafileStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogMetafileStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and\ninterprets its content as Windows Metafile image.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedReader):</strong>  The stream to display as Windows Metafile image.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogObject", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogObject", "kind": "function", "doc": "<p>Logs fields and properties of an object with a custom log level. \nLets you specify if non public members should also be logged.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>instance (object):</strong>  The object whose fields and properties should be logged.</li>\n<li><strong>excludeNonPublic (bool):</strong>  Specifies if non public member items (e.g. \"_x\" prefix) should \nbe excluded from the log data.</li>\n<li><strong>excludeBuiltIn (bool):</strong>  Specifies if non public \"built-in\" member items (e.g. \"__x\" prefix) should \nbe excluded from the log data.</li>\n<li><strong>excludeFunctions (bool):</strong>  Specifies if routine, function, and method data is included in the log data.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs all field and property names and their\ncurrent values of an object. These key/value pairs will be\ndisplayed in the Console in an object inspector like viewer.</p>\n\n<p>You can specify if non public or only public members should\nbe logged by setting the excludeNonPublic argument to true or false,\nrespectively.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">instance</span><span class=\"p\">:</span> <span class=\"nb\">object</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">excludeNonPublic</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">excludeBuiltIn</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">excludeFunctions</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogObjectValue", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogObjectValue", "kind": "function", "doc": "<p>Logs a object value with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (object):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a object variable.\nA title like \"name = My Object\" will be displayed in the Console.\nIf the value is null, then a title like \"name = null\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">object</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogPngFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogPngFile", "kind": "function", "doc": "<p>Logs a PNG file and displays it in the Console\nusing a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The PNG file to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>Note that this method is only supported in the SI Console Viewer v3.4+.  Previous versions\nof the Si Console will display \"A viewer for the selected Log Entry could not be found\" error.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogPngStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogPngStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and\ninterprets its content as PNG image.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BuffereReader):</strong>  The stream to display as PNG image.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>Note that this method is only supported in the SI Console Viewer v3.4+.  Previous versions\nof the Si Console will display \"A viewer for the selected Log Entry could not be found\" error.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogReader", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogReader", "kind": "function", "doc": "<p>Logs a reader with a custom log level and\ndisplays the content in a read-only text field.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>reader (TextIOWrapper):</strong>  The text reader to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">reader</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSeparator", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSeparator", "kind": "function", "doc": "<p>Logs a simple separator with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method instructs the Console to draw a separator.\nA separator is intended to group related Log Entry\nand to separate them visually from others. This\nmethod can help organizing Log Entries in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSource", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSource", "kind": "function", "doc": "<p>Logs source code that is displayed with syntax\nhighlighting in the Console using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>source (str):</strong>  The source code to log.</li>\n<li><strong>id (SISourceId):</strong>  Specifies the type of source code.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method displays the supplied source code with syntax\nhighlighting in the Console. The type of the source code can be\nspecified by the 'id' argument. Please see the SISourceId enum for\ninformation on the supported source code types.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisourceid</span><span class=\"o\">.</span><span class=\"n\">SISourceId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSourceFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSourceFile", "kind": "function", "doc": "<p>Logs the content of a file as source code with\nsyntax highlighting using a custom title and custom log\nlevel.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The name of the file which contains the source code.</li>\n<li><strong>id (SISourceId):</strong>  Specifies the type of source code.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method displays the source file with syntax highlighting\nin the Console. The type of the source code can be specified by\nthe 'id' argument. Please see the SISourceId enum for information\non the supported source code types.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisourceid</span><span class=\"o\">.</span><span class=\"n\">SISourceId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSourceReader", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSourceReader", "kind": "function", "doc": "<p>Logs the content of a text reader as source code with\nsyntax highlighting using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>reader (TextIOWrapper):</strong>  The text reader which contains the source code.</li>\n<li><strong>id (SISourceId):</strong>  Specifies the type of source code.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method displays the content of a reader with syntax\nhighlighting in the Console. The type of the source code can be\nspecified by the 'id' argument. Please see the SISourceId enum for\ninformation on the supported source code types.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">reader</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisourceid</span><span class=\"o\">.</span><span class=\"n\">SISourceId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSourceStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSourceStream", "kind": "function", "doc": "<p>Logs the content of a stream as source code with\nsyntax highlighting using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedReader):</strong>  The stream which contains the source code.</li>\n<li><strong>id (SISourceId):</strong>  Specifies the type of source code.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method displays the content of a stream with syntax\nhighlighting in the Console. The type of the source code can be\nspecified by the 'id' argument. Please see the SISourceId enum for\ninformation on the supported source code types.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisourceid</span><span class=\"o\">.</span><span class=\"n\">SISourceId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSql", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSql", "kind": "function", "doc": "<p>Logs a string containing SQL source code with a\ncustom log level. The SQL source code is displayed with syntax\nhighlighting in the Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>source (str):</strong>  The SQL source code to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method displays the supplied SQL source code with syntax\nhighlighting in the Console.</p>\n\n<p>It is especially useful to debug or track dynamically generated\nSQL source code.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSqliteDbCursorData", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSqliteDbCursorData", "kind": "function", "doc": "<p>Logs the contents of a Sqlite Cursor with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>cursor (Cursor):</strong>  The cursor data to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs all data of the supplied cursor, using a \"for row in cursor:\" statement.\nNote that this WILL move the position of the cursor, and the position is not restored.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">cursor</span><span class=\"p\">:</span> <span class=\"n\">sqlite3</span><span class=\"o\">.</span><span class=\"n\">Cursor</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSqliteDbSchemaCursor", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSqliteDbSchemaCursor", "kind": "function", "doc": "<p>Logs the schema of a Sqlite Cursor with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>cursor (Cursor):</strong>  The cursor schema to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the schema of the supplied cursor, by querying its \"description\" property value. <br />\nIt does not move the position of the cursor.</p>\n\n<p>A cursor schema contains the name of every column in the cursor.\nNote that this data could be different than what is actually defined in the database table that\nthe schema is derived from, as the SELECT statement used to query the database could limit the \ncolumns returned.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">cursor</span><span class=\"p\">:</span> <span class=\"n\">sqlite3</span><span class=\"o\">.</span><span class=\"n\">Cursor</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSqliteDbSchemaForeignKeyList", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSqliteDbSchemaForeignKeyList", "kind": "function", "doc": "<p>Logs the schema of a Sqlite DB Table Foreign Key List with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>conn (Connection):</strong>  Sqlite database connection object.</li>\n<li><strong>tableName (str):</strong>  The name of the table to obtain schema information for.</li>\n<li><strong>sortByName (bool):</strong>  Sorts the log data by Table Name (True) or by ID (False, default).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method queries the schema information by executing the following SQL statement:\n\"SELECT * FROM pragma_foreign_key_list('<tablename>');\"</p>\n\n<p>This will log the following details returned from the schema information query:\nID, Sequence, Table, From, To, On Update, On Delete, Match</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">conn</span><span class=\"p\">:</span> <span class=\"n\">sqlite3</span><span class=\"o\">.</span><span class=\"n\">Connection</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sortByName</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSqliteDbSchemaIndexList", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSqliteDbSchemaIndexList", "kind": "function", "doc": "<p>Logs the schema of a Sqlite DB Table Index List with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>conn (Connection):</strong>  Sqlite database connection object.</li>\n<li><strong>tableName (str):</strong>  The name of the table to obtain schema information for.</li>\n<li><strong>sortByName (bool):</strong>  Sorts the log data by Index Name (True) or by ID (False, default).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method queries the schema information by executing the following SQL statement:\n\"SELECT * FROM pragma_index_list('<tablename>');\"</p>\n\n<p>This will log the following details returned from the schema information query:\nSequence, Name, Unique, Origin, Partial</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">conn</span><span class=\"p\">:</span> <span class=\"n\">sqlite3</span><span class=\"o\">.</span><span class=\"n\">Connection</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sortByName</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSqliteDbSchemaTableInfo", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSqliteDbSchemaTableInfo", "kind": "function", "doc": "<p>Logs the schema of a Sqlite DB Table with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>conn (Connection):</strong>  Sqlite database connection object.</li>\n<li><strong>tableName (str):</strong>  The name of the table to obtain schema information for.</li>\n<li><strong>sortByName (bool):</strong>  Sorts the log data by Table Name (True) or by ID (False, default).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method queries the schema information by executing the following SQL statement:\n\"SELECT * FROM pragma_table_info('<tablename>');\"</p>\n\n<p>This will log the following details returned from the schema information query:</p>\n\n<ul>\n<li>id, name, data type, not null, default value, primary key, hidden column.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">conn</span><span class=\"p\">:</span> <span class=\"n\">sqlite3</span><span class=\"o\">.</span><span class=\"n\">Connection</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sortByName</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSqliteDbSchemaTables", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSqliteDbSchemaTables", "kind": "function", "doc": "<p>Logs the schema table names defined in a Sqlite DB with a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>conn (Connection):</strong>  Sqlite database connection object.</li>\n<li><strong>sortByName (bool):</strong>  Sorts the log data by Table Name (True) or by entry order (False, default).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method queries the schema information by executing the following SQL statement:\n\"SELECT * FROM sqlite_schema WHERE type ='table';\"</p>\n\n<p>This will log the following details returned from the schema information query:</p>\n\n<ul>\n<li>type, name, tbl_name, rootpage, sql</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">conn</span><span class=\"p\">:</span> <span class=\"n\">sqlite3</span><span class=\"o\">.</span><span class=\"n\">Connection</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sortByName</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogStackTrace", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogStackTrace", "kind": "function", "doc": "<p>Logs a stack trace with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>strace (object):</strong>  StackTrace instance to log.</li>\n<li><strong>startFrame (int):</strong>  The offset of the first frame preceding the caller to print (default 0).</li>\n<li><strong>limit (int):</strong>  The number of frames to print (specify None to print all remaining frames).</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the supplied stack trace. The resulting Log Entry contains all methods including the\nrelated classes lists. Furthermore the filename, line and columns numbers are included.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strace</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">inspect</span><span class=\"o\">.</span><span class=\"n\">FrameInfo</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">startFrame</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">limit</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and displays\nthe content in a read-only text field.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedStream):</strong>  The stream to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogString", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogString", "kind": "function", "doc": "<p>Logs a string value with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (str):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs the name and value of a string variable.\nA title like \"name = \"Value\"\" will be displayed in the Console.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogSystem", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogSystem", "kind": "function", "doc": "<p>Logs information about the system using a custom title and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>The logged information include the version of the operating\nsystem, the Python version and more. This method is\nuseful for logging general information at the program startup.\nThis guarantees that the support staff or developers have\ngeneral information about the execution environment.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogText", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogText", "kind": "function", "doc": "<p>Logs a string with a custom log level and displays\nit in a read-only text field.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>text (str):</strong>  The text to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogTextFile", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogTextFile", "kind": "function", "doc": "<p>Logs a text file and displays the content in a\nread-only text field using a custom title and custom log\nlevel.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>fileName (str):</strong>  The file to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogTextReader", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogTextReader", "kind": "function", "doc": "<p>Logs a text reader with a custom log level and\ndisplays the content in a read-only text field.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>reader (TextIOWrapper):</strong>  The text reader to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">reader</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogTextStream", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogTextStream", "kind": "function", "doc": "<p>Logs a stream with a custom log level and displays\nthe content in a read-only text field.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>stream (BufferedStream):</strong>  The stream to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BufferedReader</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogThread", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogThread", "kind": "function", "doc": "<p>Logs information about a thread with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title to display in the Console.</li>\n<li><strong>thread (Thread):</strong>  The thread to log.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method logs information about the supplied thread. This\nincludes its name, its current state and more.</p>\n\n<p>LogThread is especially useful in a multi-threaded program\nlike in a network server application. By using this method you\ncan easily track all threads of a process and obtain detailed\ninformation about them.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">thread</span><span class=\"p\">:</span> <span class=\"n\">threading</span><span class=\"o\">.</span><span class=\"n\">Thread</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogValue", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogValue", "kind": "function", "doc": "<p>Logs the name and value of a variable with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The variable name.</li>\n<li><strong>value (object):</strong>  The variable value.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n</ul>\n\n<p>This method just calls the appropriate \"LogX\" method (e.g. LogString, LogInt, etc) \nbased upon the type of value as determined by isinstance.  Note that it is faster to\ncall the \"LogX\" method directly - this method is provided for C# SI compatibility.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogVerbose", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogVerbose", "kind": "function", "doc": "<p>Logs a verbose message with a log level of SILevel.Verbose.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  The message to log.</li>\n<li><strong>*args:</strong>  Format arguments for the title argument.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li><strong>logToSystemLogger (bool):</strong>  True to log the exception to the SystemLogger instance (if one was supplied); <br />\notherwise, False to not log the exception to the SystemLogger instance. <br />\nDefault is True.</li>\n</ul>\n\n<p>This method will also log a message to the system log if the <code>SystemLogger</code> property is set.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logToSystemLogger</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.LogWarning", "modulename": "smartinspectpython.sisession", "qualname": "SISession.LogWarning", "kind": "function", "doc": "<p>Logs a warning message with a log level of SILevel.Warning.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>title (str):</strong>  The message to log.</li>\n<li><strong>*args:</strong>  Format arguments for the title argument.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li><strong>logToSystemLogger (bool):</strong>  True to log the exception to the SystemLogger instance (if one was supplied); <br />\notherwise, False to not log the exception to the SystemLogger instance. <br />\nDefault is True.</li>\n</ul>\n\n<p>This method will also log a message to the system log if the <code>SystemLogger</code> property is set.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">logToSystemLogger</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ResetCallstack", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ResetCallstack", "kind": "function", "doc": "<p>Resets the call stack by using a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n</ul>\n\n<p>This method instructs the Console to reset the call stack\ngenerated by the EnterMethod and LeaveMethod methods. It\nis especially useful if you want to reset the indentation\nin the method hierarchy without clearing all log entries.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ResetCheckpoint", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ResetCheckpoint", "kind": "function", "doc": "<p>Resets a named checkpoint counter.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The name of the checkpoint to reset.</li>\n</ul>\n\n<p>This method resets the counter of the given named checkpoint.\nNamed checkpoints can be incremented and logged with the\nAddCheckpoint method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ResetColor", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ResetColor", "kind": "function", "doc": "<p>Resets the session background color to its default value.</p>\n\n<p>The default background color of a session is white transparent.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.ResetCounter", "modulename": "smartinspectpython.sisession", "qualname": "SISession.ResetCounter", "kind": "function", "doc": "<p>Resets a named counter to its initial value of 0.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The name of the counter to reset.</li>\n</ul>\n\n<p>This method resets the integer value of a named counter to 0\nagain. If the supplied counter is unknown, this method has no\neffect. Please refer to the IncCounter and DecCounter methods\nfor more information about named counters.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.SendCustomControlCommand", "modulename": "smartinspectpython.sisession", "qualname": "SISession.SendCustomControlCommand", "kind": "function", "doc": "<p>Logs a custom Control Command with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>ct (SIControlCommandType):</strong>  The Control Command type to use.</li>\n<li><strong>data (BytesIO):</strong>  Optional data stream which can be null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span>,</span><span class=\"param\">\t<span class=\"n\">ct</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicontrolcommandtype</span><span class=\"o\">.</span><span class=\"n\">SIControlCommandType</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.SendCustomLogEntry", "modulename": "smartinspectpython.sisession", "qualname": "SISession.SendCustomLogEntry", "kind": "function", "doc": "<p>Logs a custom Log Entry with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title of the new Log Entry.</li>\n<li><strong>lt (SILogEntryType):</strong>  The Log Entry type to use.</li>\n<li><strong>vi (SIViewerId):</strong>  The Viewer ID to use.</li>\n<li><strong>colorValue (SIColors):</strong>  Background color value (SIColors enum, or ARGB integer form) for the message.\nRefer to the SIColors enum in the sicolor module for common color values.\nSpecify None to use default background color.</li>\n<li>data\nOptional data stream which can be null (or None).</li>\n</ul>\n\n<p>This method is useful for implementing custom Log Entry\nmethods. For example, if you want to display some information\nin a particular way in the Console, you can just create a\nsimple method which formats the data in question correctly and\nlogs them using this SendCustomLogEntry method.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">lt</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentrytype</span><span class=\"o\">.</span><span class=\"n\">SILogEntryType</span>,</span><span class=\"param\">\t<span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span>,</span><span class=\"param\">\t<span class=\"n\">colorValue</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicolor</span><span class=\"o\">.</span><span class=\"n\">SIColors</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.SendCustomProcessFlow", "modulename": "smartinspectpython.sisession", "qualname": "SISession.SendCustomProcessFlow", "kind": "function", "doc": "<p>Logs a custom Process Flow entry with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>title (str):</strong>  The title of the new Process Flow entry.</li>\n<li><strong>pt (SIProcessFlowType):</strong>  The Process Flow type to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">pt</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siprocessflowtype</span><span class=\"o\">.</span><span class=\"n\">SIProcessFlowType</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.SendCustomWatch", "modulename": "smartinspectpython.sisession", "qualname": "SISession.SendCustomWatch", "kind": "function", "doc": "<p>Logs a custom Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (object):</strong>  The value of the Watch.</li>\n<li><strong>watchType (SIWatchType):</strong>  The Watch type to use</li>\n</ul>\n\n<p>This method is useful for implementing custom Watch methods.\nFor example, if you want to track the status of an instance of\na specific class, you can just create a simple method which\nextracts all necessary information about this instance and logs\nthem using this SendCustomWatch method.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">watchType</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siwatchtype</span><span class=\"o\">.</span><span class=\"n\">SIWatchType</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.Watch", "modulename": "smartinspectpython.sisession", "qualname": "SISession.Watch", "kind": "function", "doc": "<p>Logs a Watch value by using the specified (or default) log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value:</strong>  The bool value to display as Watch value.</li>\n<li><strong>watchType (SIWatchType):</strong>  WatchType to set in the Log Entry.</li>\n</ul>\n\n<p>\"null\" will be displayed if value=None.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">watchType</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siwatchtype</span><span class=\"o\">.</span><span class=\"n\">SIWatchType</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchBool", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchBool", "kind": "function", "doc": "<p>Logs a boolean Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (bool):</strong>  The bool value to display as Watch value.</li>\n</ul>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchByte", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchByte", "kind": "function", "doc": "<p>Logs a byte Watch with an optional hexadecimal representation and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (int):</strong>  The byte value to display as Watch value.</li>\n<li><strong>includeHex (bool):</strong>  Indicates if a hexadecimal representation should be included.</li>\n</ul>\n\n<p>This method logs a byte Watch. You can specify if a\nhexadecimal representation should be included as well\nby setting the includeHex parameter to true.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">includeHex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchChar", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchChar", "kind": "function", "doc": "<p>Logs a chr Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (chr):</strong>  The chr value to display as Watch value.</li>\n</ul>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">built</span><span class=\"o\">-</span><span class=\"ow\">in</span> <span class=\"n\">function</span> <span class=\"nb\">chr</span><span class=\"o\">&gt;</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchComplex", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchComplex", "kind": "function", "doc": "<p>Logs a complex Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (complex):</strong>  The complex value to display as Watch value.</li>\n</ul>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">complex</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchDateTime", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchDateTime", "kind": "function", "doc": "<p>Logs a datetime Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li>value (datetime)\nThe datetime value to display as Watch value.</li>\n</ul>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">module</span> <span class=\"s1\">&#39;datetime&#39;</span> <span class=\"kn\">from</span> <span class=\"s1\">&#39;C:</span><span class=\"se\">\\\\</span><span class=\"s1\">Program Files</span><span class=\"se\">\\\\</span><span class=\"s1\">Python39</span><span class=\"se\">\\\\</span><span class=\"s1\">lib</span><span class=\"se\">\\\\</span><span class=\"s1\">datetime.py&#39;</span><span class=\"o\">&gt;</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchFloat", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchFloat", "kind": "function", "doc": "<p>Logs a float Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (float):</strong>  The float value to display as Watch value.</li>\n</ul>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchInt", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchInt", "kind": "function", "doc": "<p>Logs an integer Watch with an optional hexadecimal representation and custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (int):</strong>  The integer value to display as Watch value.</li>\n<li><strong>includeHex (bool):</strong>  Indicates if a hexadecimal representation should be included.</li>\n</ul>\n\n<p>This method logs a integer Watch. You can specify if a\nhexadecimal representation should be included as well\nby setting the includeHex parameter to true.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">includeHex</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchObject", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchObject", "kind": "function", "doc": "<p>Logs an object Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (object):</strong>  The object value to display as Watch value.</li>\n</ul>\n\n<p>The value of the resulting Watch is the return value of the\n\"str(value)\" method of the supplied object.</p>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">object</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisession.SISession.WatchString", "modulename": "smartinspectpython.sisession", "qualname": "SISession.WatchString", "kind": "function", "doc": "<p>Logs a string Watch with a custom log level.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>level (SILevel):</strong>  The log level of this method call.</li>\n<li><strong>name (str):</strong>  The name of the Watch.</li>\n<li><strong>value (str):</strong>  The string value to display as Watch value.</li>\n</ul>\n\n<p>This method uses the SmartInspect.DefaultLevel value if the level\nparameter is set to None (default).  Otherwise, the specified level\nis utilized.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silevel</span><span class=\"o\">.</span><span class=\"n\">SILevel</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessiondefaults", "modulename": "smartinspectpython.sisessiondefaults", "kind": "module", "doc": "<p>Module: sisessiondefaults.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sisessiondefaults.SISessionDefaults", "modulename": "smartinspectpython.sisessiondefaults", "qualname": "SISessionDefaults", "kind": "class", "doc": "<p>Specifies the default property values for newly created sessions.</p>\n\n<p>This class is used by the SmartInspect class to customize the\ndefault property values for newly created sessions. Sessions\nthat will be created by or passed to the AddSession method of\nthe SmartInspect class will be automatically configured with\nthe values of the SmartInspect.SessionDefaults property.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sisessiondefaults.SISessionDefaults.__init__", "modulename": "smartinspectpython.sisessiondefaults", "qualname": "SISessionDefaults.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sisessiondefaults.SISessionDefaults.Active", "modulename": "smartinspectpython.sisessiondefaults", "qualname": "SISessionDefaults.Active", "kind": "variable", "doc": "<p>Gets the Active property value.</p>\n\n<p>Represents the default Active property for newly created sessions.</p>\n\n<p>Please see SISession.Active for general information about the\nactive status of sessions.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sisessiondefaults.SISessionDefaults.ColorBG", "modulename": "smartinspectpython.sisessiondefaults", "qualname": "SISessionDefaults.ColorBG", "kind": "variable", "doc": "<p>Gets the ColorBG property value.</p>\n\n<p>Represents the default background color property for newly created sessions.</p>\n\n<p>Please see SISession.ColorBG for general information about the\nbackground color of sessions.</p>\n", "annotation": ": smartinspectpython.sicolor.SIColor"}, {"fullname": "smartinspectpython.sisessiondefaults.SISessionDefaults.Level", "modulename": "smartinspectpython.sisessiondefaults", "qualname": "SISessionDefaults.Level", "kind": "variable", "doc": "<p>Gets the Level property value.</p>\n\n<p>Represents the default Level property for newly created\nsessions.</p>\n\n<p>Please see SISession.Level for general information about the\nlog level of sessions.</p>\n", "annotation": ": smartinspectpython.silevel.SILevel"}, {"fullname": "smartinspectpython.sisessiondefaults.SISessionDefaults.Assign", "modulename": "smartinspectpython.sisessiondefaults", "qualname": "SISessionDefaults.Assign", "kind": "function", "doc": "<p>Sets various properties of the specified session with like-named \nproperties of the session defaults.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  Session whose properties will be set from session defaults.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager", "modulename": "smartinspectpython.sisessionmanager", "kind": "module", "doc": "<p>Module: sisessionmanager.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager", "kind": "class", "doc": "<p>Manages and configures session instances.</p>\n\n<p>This class manages and configures a list of sessions. Sessions\ncan be configured and added to the list with the Add method. To\nlookup a stored session, you can use Get. To remove an existing\nsession from the list, call Delete.</p>\n\n<p>Stored sessions will be reconfigured if LoadConfiguration has\nbeen called and contains corresponding session entries.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.__init__", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.PREFIX", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.PREFIX", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;session.&#x27;"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.PREFIX_LEN", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.PREFIX_LEN", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "8"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Defaults", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Defaults", "kind": "variable", "doc": "<p>Specifies the default property values for new sessions.</p>\n\n<p>This property lets you specify the default property values\nfor new sessions which will be passed to the Add method.\nPlease see the Add method for details. For information about\nthe available session properties, please refer to the\ndocumentation of the Session class.</p>\n", "annotation": ": smartinspectpython.sisessiondefaults.SISessionDefaults"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Add", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Add", "kind": "function", "doc": "<p>Configures a passed session instance and optionally saves it\nfor later access.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  The session to configure and to save for later access, if desired.</li>\n<li><strong>store (bool):</strong>  Indicates if the passed session should be stored for later access.</li>\n</ul>\n\n<p>This method configures the passed session with the default\nsession properties as specified by the Defaults property.\nThis default configuration can be overridden on a per-session\nbasis by loading the session configuration with the\nLoadConfiguration method.</p>\n\n<p>If the 'store' parameter is true, the passed session is stored\nfor later access and can be retrieved with the Get method. To\nremove a stored session from the internal list, call Delete. </p>\n\n<p>If this method is called multiple times with the same session\nname, then the Get method operates on the session which got\nadded last. If the session parameter is null, this method does nothing.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>,</span><span class=\"param\">\t<span class=\"n\">store</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Assign", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Assign", "kind": "function", "doc": "<p>Assigns property values to a session instance from stored session information.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  Session to assign property values to.</li>\n<li><strong>info (SISessionInfo):</strong>  Session information to retrieve property values from.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>,</span><span class=\"param\">\t<span class=\"n\">info</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisessioninfo</span><span class=\"o\">.</span><span class=\"n\">SISessionInfo</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Clear", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Clear", "kind": "function", "doc": "<p>Clears the configuration of this session manager and removes\nall sessions from the internal lookup table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Configure", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Configure", "kind": "function", "doc": "<p>Configures the specified session from stored session information.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  Session to configure.</li>\n<li><strong>sessionName (str):</strong>  Name to retrieve session information properties from.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>,</span><span class=\"param\">\t<span class=\"n\">sessionName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Delete", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Delete", "kind": "function", "doc": "<p>Removes a session from the internal list of sessions.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  The session to remove from the lookup table of sessions. </li>\n</ul>\n\n<p>This method removes a session which has previously been added\nwith the Add method. After this method returns, the Get method\nreturns null when called with the same session name unless a\ndifferent session with the same name has been added.</p>\n\n<p>This method does nothing if the supplied session argument is null.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Get", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Get", "kind": "function", "doc": "<p>Returns a previously added session.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>(str):</strong>  The name of the session to lookup and return. </li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The requested session or null if the supplied name of the\n  session is unknown.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  Thrown if the supplied sessionName is null, and a\n\"Main\" session does not exist.</li>\n</ul>\n\n<p>This method returns a session which has previously been\nadded with the Add method and can be identified by the\nsupplied name parameter. If the requested session is unknown\nthen this method returns null.</p>\n\n<p>If sessionName is null, then the default \"Main\" session is\nreturned if one exists.</p>\n\n<p>Note that the behavior of this method can be unexpected in\nterms of the result value if multiple sessions with the same\nname have been added. In this case, this method returns the\nsession which got added last and not necessarily the session\nwhich you expect. </p>\n\n<p>Adding multiple sessions with the same name should therefore be avoided.\n</para></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sessionName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.LoadConfiguration", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.LoadConfiguration", "kind": "function", "doc": "<p>Loads the configuration properties of this session manager.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config (SIConfiguration):</strong>  The SIConfiguration object to load the configuration from.</li>\n</ul>\n\n<p>This method loads the configuration of this session manager\nfrom the passed SIConfiguration object. Sessions which have\nalready been stored or will be added with Add will\nautomatically configured with the new properties if the\npassed SIConfiguration object contains corresponding session\nentries. Moreover, this method also loads the default session\nproperties which will be applied to all sessions which are\npassed to Add.</p>\n\n<p>Please see the SmartInspect.LoadConfiguration method for\ndetails on how session entries and session defaults look\nlike.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconfiguration</span><span class=\"o\">.</span><span class=\"n\">SIConfiguration</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.LoadDefaults", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.LoadDefaults", "kind": "function", "doc": "<p>Loads the configuration session default properties of this session manager.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>config (SIConfiguration):</strong>  The SIConfiguration object to load the configuration from.</li>\n</ul>\n\n<p>This method will only process \"SessionDefaults.x\" lines, and will\nignore the SmartInspect object configuration and \"Session.x.x\" lines.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconfiguration</span><span class=\"o\">.</span><span class=\"n\">SIConfiguration</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.LoadInfo", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.LoadInfo", "kind": "function", "doc": "<p>Loads the configuration session instance properties of a defined\nsession in this session manager.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The session name.</li>\n<li><strong>config (SIConfiguration):</strong>  The SIConfiguration object to load the configuration from.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A SISessionInfo object with session information.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconfiguration</span><span class=\"o\">.</span><span class=\"n\">SIConfiguration</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisessioninfo</span><span class=\"o\">.</span><span class=\"n\">SISessionInfo</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.LoadInfos", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.LoadInfos", "kind": "function", "doc": "<p>Loads the configuration session instance properties of all defined\nsessions in this session manager.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>(SIConfiguration):</strong>  The SIConfiguration object to load the configuration from.</li>\n</ul>\n\n<p>This method will only process the \"session.x.x\" configuration lines, and will\nignore the SmartInspect object configuration and SessionDefaults lines.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconfiguration</span><span class=\"o\">.</span><span class=\"n\">SIConfiguration</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisessionmanager.SISessionManager.Update", "modulename": "smartinspectpython.sisessionmanager", "qualname": "SISessionManager.Update", "kind": "function", "doc": "<p>Updates an entry in the internal lookup table of sessions.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  The session whose name has changed and whose entry should be updated.</li>\n<li><strong>toName (str):</strong>  The new name of the session.</li>\n<li><strong>fromName (str):</strong>  The old name of the session.</li>\n</ul>\n\n<p>Once the name of a session has changed, this method is called\nto update the internal session lookup table. The 'to' argument\nspecifies the new name and 'from' the old name of the session.\nAfter this method returns, the new name can be passed to the\nGet method to lookup the supplied session.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>,</span><span class=\"param\">\t<span class=\"n\">toName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">fromName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sisourceid", "modulename": "smartinspectpython.sisourceid", "kind": "module", "doc": "<p>Module: sisourceid.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sisourceid.SISourceId", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId", "kind": "class", "doc": "<p>Used in the LogSource methods of the SISession class to specify\nthe type of source code.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.Html", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.Html", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for HTML.</p>\n", "default_value": "&lt;SISourceId.Html: 300&gt;"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.JavaScript", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.JavaScript", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for JavaScript.</p>\n", "default_value": "&lt;SISourceId.JavaScript: 301&gt;"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.VbScript", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.VbScript", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for VBScript.</p>\n", "default_value": "&lt;SISourceId.VbScript: 302&gt;"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.Perl", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.Perl", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for Perl.</p>\n", "default_value": "&lt;SISourceId.Perl: 303&gt;"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.Sql", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.Sql", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for SQL.</p>\n", "default_value": "&lt;SISourceId.Sql: 304&gt;"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.Ini", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.Ini", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for INI file.</p>\n", "default_value": "&lt;SISourceId.Ini: 305&gt;"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.Python", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.Python", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for Python.</p>\n", "default_value": "&lt;SISourceId.Python: 306&gt;"}, {"fullname": "smartinspectpython.sisourceid.SISourceId.Xml", "modulename": "smartinspectpython.sisourceid", "qualname": "SISourceId.Xml", "kind": "variable", "doc": "<p>Instructs the SISession.LogSource methods to use syntax highlighting for XML.</p>\n", "default_value": "&lt;SISourceId.Xml: 307&gt;"}, {"fullname": "smartinspectpython.sisourceviewercontext", "modulename": "smartinspectpython.sisourceviewercontext", "kind": "module", "doc": "<p>Module: sisourceviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sisourceviewercontext.SISourceViewerContext", "modulename": "smartinspectpython.sisourceviewercontext", "qualname": "SISourceViewerContext", "kind": "class", "doc": "<p>Represents the source viewer in the Console which can display text\ndata as source code with syntax highlighting.</p>\n\n<p>The source viewer in the Console interprets the Log Entry Data\nas source code and displays it in a read-only\ntext editor with syntax highlighting.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sitextcontext.SITextContext"}, {"fullname": "smartinspectpython.sisourceviewercontext.SISourceViewerContext.__init__", "modulename": "smartinspectpython.sisourceviewercontext", "qualname": "SISourceViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>id (SISourceId):</strong>  The source ID to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisourceid</span><span class=\"o\">.</span><span class=\"n\">SISourceId</span></span>)</span>"}, {"fullname": "smartinspectpython.sitableviewercontext", "modulename": "smartinspectpython.sitableviewercontext", "kind": "module", "doc": "<p>Module: sitableviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sitableviewercontext.SITableViewerContext", "modulename": "smartinspectpython.sitableviewercontext", "qualname": "SITableViewerContext", "kind": "class", "doc": "<p>Represents the table viewer in the Console which can display text data as a table.</p>\n\n<p>The table viewer in the Console interprets the Log Entry Data as a table. This class\ntakes care of the necessary formatting and escaping required by the corresponding \ntable viewer in the Console.</p>\n\n<p>You can use the SITableViewerContext class for creating custom log methods around \nSISession.LogCustomContext for sending custom data organized as tables.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.silistviewercontext.SIListViewerContext"}, {"fullname": "smartinspectpython.sitableviewercontext.SITableViewerContext.__init__", "modulename": "smartinspectpython.sitableviewercontext", "qualname": "SITableViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sitableviewercontext.SITableViewerContext.AddRowEntry", "modulename": "smartinspectpython.sitableviewercontext", "qualname": "SITableViewerContext.AddRowEntry", "kind": "function", "doc": "<p>Adds an entry to the current row.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>entry (object):</strong>  The entry to add; must be able to be converted to a string\nvia the \"str(x)\" syntax.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">entry</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitableviewercontext.SITableViewerContext.AppendHeader", "modulename": "smartinspectpython.sitableviewercontext", "qualname": "SITableViewerContext.AppendHeader", "kind": "function", "doc": "<p>Appends a header to the text data.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>(str):</strong>  The header to append.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">header</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitableviewercontext.SITableViewerContext.BeginRow", "modulename": "smartinspectpython.sitableviewercontext", "qualname": "SITableViewerContext.BeginRow", "kind": "function", "doc": "<p>Begins a new row.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitableviewercontext.SITableViewerContext.EndRow", "modulename": "smartinspectpython.sitableviewercontext", "qualname": "SITableViewerContext.EndRow", "kind": "function", "doc": "<p>Ends the current row.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitableviewercontext.SITableViewerContext.EscapeCSVEntry", "modulename": "smartinspectpython.sitableviewercontext", "qualname": "SITableViewerContext.EscapeCSVEntry", "kind": "function", "doc": "<p>Escapes a CSV (comma separated values) formatted entry.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>entry (str):</strong>  The CSV entry to escape.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The escaped line.</p>\n</blockquote>\n\n<p>This method ensures that the escaped CSV entry does not\ncontain whitespace characters, and that quoted values are\nescaped properly.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">entry</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitcpprotocol", "modulename": "smartinspectpython.sitcpprotocol", "kind": "module", "doc": "<p>Module: sitcpprotocol.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/06/09</td>\n  <td>3.0.8.0</td>\n  <td>Added call to RaiseInfoEvent for the SI Console Server banner.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol", "kind": "class", "doc": "<p>Used for sending packets to the SmartInspect Console over a TCP\nsocket connection.</p>\n\n<p>This class is used for sending packets over a TCP connection to\nthe Console. It is used when the 'tcp' protocol is specified in\nthe SmartInspect.Connections property. Please see the IsValidOption \nmethod for a list of available protocol options.</p>\n\n<p>For a list of available protocol options, please refer to the\nIsValidOption method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siprotocol.SIProtocol"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.__init__", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.Name", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.Name", "kind": "variable", "doc": "<p>Overridden.  Returns \"tcp\".</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.BuildOptions", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.BuildOptions", "kind": "function", "doc": "<p>Overridden. Fills a SIConnectionsBuilder instance with the\noptions currently used by this protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>builder (SIConnectionsBuilder):</strong>  The SIConnectionsBuilder object to fill with the current options\nof this protocol.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">builder</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconnectionsbuilder</span><span class=\"o\">.</span><span class=\"n\">SIConnectionsBuilder</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.IsValidOption", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.IsValidOption", "kind": "function", "doc": "<p>Overridden. Validates if a protocol option is supported.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The option name to validate.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the option is supported and false otherwise.</p>\n</blockquote>\n\n<p>The following table lists all valid options, their default\nvalues and descriptions for the TCP protocol.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Valid Options (default value)</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>host (\"127.0.0.1\")</td>\n  <td>Specifies the TCP host name or ip address that the SI Console is listening on.</td>\n</tr>\n<tr>\n  <td>port (4228)</td>\n  <td>Specifies the TCP port number that the SI Console is listening on.</td>\n</tr>\n<tr>\n  <td>timeout (30000)</td>\n  <td>Specifies the connect, receive and send timeout in milliseconds.</td>\n</tr>\n</tbody>\n</table>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># the following are sample SI Connections options for this protocol.</span>\n\n<span class=\"c1\"># log messages using all default options (localhost, port 4228, 30s timeout).</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp()&quot;</span>\n\n<span class=\"c1\"># log messages using localhost, port 4228, 30s timeout, asynchronous processing.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=localhost,port=4228,timeout=30000,reconnect=true,reconnect.interval=10s,async.enabled=true)&quot;</span>\n\n<span class=\"c1\"># log messages using another server, port 4228, 30s timeout, asynchronous processing.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=myserver.example.com,port=4228,timeout=30000,reconnect=true,reconnect.interval=10s,async.enabled=true)&quot;</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.InternalConnect", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.InternalConnect", "kind": "function", "doc": "<p>Overridden.  Creates and connects a TCP socket.</p>\n\n<p>This method tries to connect a TCP socket to a SmartInspect\nConsole. The hostname and port can be specified by passing\nthe \"hostname\" and \"port\" options to the Initialize method.\nFurthermore, it is possible to specify the connect timeout\nby using the \"timeout\" option.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Creating or connecting the socket failed.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.InternalDisconnect", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.InternalDisconnect", "kind": "function", "doc": "<p>Overridden.  Closes the TCP socket connection.</p>\n\n<p>This method closes the underlying socket handle if previously\ncreated and disposes any supplemental objects.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Closing the TCP socket failed.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.InternalWritePacket", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.InternalWritePacket", "kind": "function", "doc": "<p>Sends a packet to the Console.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to write.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  Sending the packet to the Console failed.</li>\n</ul>\n\n<p>This method sends the supplied packet to the SmartInspect\nConsole and waits for a valid response.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitcpprotocol.SITcpProtocol.LoadOptions", "modulename": "smartinspectpython.sitcpprotocol", "qualname": "SITcpProtocol.LoadOptions", "kind": "function", "doc": "<p>Overridden. Loads and inspects specific options for this protocol.</p>\n\n<p>This method loads all relevant options and ensures their\ncorrectness. See IsValidOption for a list of options which\nare recognized by the protocol.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext", "modulename": "smartinspectpython.sitextcontext", "kind": "module", "doc": "<p>Module: sitextcontent.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext", "kind": "class", "doc": "<p>Is the base class for all viewer contexts which deal with text\ndata. A viewer context is the library-side representation of a\nviewer in the Console.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siviewercontext.SIViewerContext"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.__init__", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>vi (SIViewerId):</strong>  The viewer ID to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span></span>)</span>"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.ViewerData", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.ViewerData", "kind": "variable", "doc": "<p>Overridden.  Returns the actual data which will be displayed\nin the viewer specified by the viewer id.</p>\n", "annotation": ": _io.BytesIO"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.AppendLine", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.AppendLine", "kind": "function", "doc": "<p>Appends a line to the text data.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>line (str):</strong>  The line to append.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The line argument is null.</li>\n</ul>\n\n<p>This method appends the supplied line and a carriage return</p>\n\n<ul>\n<li>linefeed character to the internal text data after it has\nbeen escaped by the EscapeLine method.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.AppendText", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.AppendText", "kind": "function", "doc": "<p>Appends text.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>Text (str):</strong>  The text to append.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The text argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.Dispose", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.Dispose", "kind": "function", "doc": "<p>Releases any resources.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>disposing (bool):</strong>  True if managed resources should be released and false otherwise.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">disposing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.EscapeLine", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.EscapeLine", "kind": "function", "doc": "<p>Escapes a line.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>line (str):</strong>  The line to escape.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The escaped line.</p>\n</blockquote>\n\n<p>If overridden in derived classes, this method escapes a\nline depending on the viewer format used. The default\nimplementation does no escaping.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.LoadFromFile", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.LoadFromFile", "kind": "function", "doc": "<p>Loads the text from a file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>(str):</strong>  The name of the file to load the text from.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The filename argument is null.</li>\n<li><strong>IOException:</strong>  An I/O error occurred.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.LoadFromReader", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.LoadFromReader", "kind": "function", "doc": "<p>Loads the text from a reader.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>reader (TextIOWrapper):</strong>  The reader to read the text from.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The reader argument is null.</li>\n<li><strong>IOException:</strong>  An I/O error occurred.</li>\n</ul>\n\n<p>If the supplied text reader supports seeking then the entire\ntext reader content will be read and the stream position will be\nrestored correctly. Otherwise the data will be read from the\ncurrent position to the end and the original position can\nnot be restored.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">reader</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.LoadFromStream", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.LoadFromStream", "kind": "function", "doc": "<p>Loads the text from a stream.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (TextIOWrapper):</strong>  The stream to load the text from.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The stream argument is null.</li>\n<li><strong>IOException:</strong>  An I/O error occurred.</li>\n</ul>\n\n<p>If the supplied stream supports seeking then the entire\nstream content will be read and the stream position will be\nrestored correctly. Otherwise the data will be read from the\ncurrent position to the end and the original position can\nnot be restored.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.LoadFromText", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.LoadFromText", "kind": "function", "doc": "<p>Loads the text.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>Text (str):</strong>  The text to load.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  The text argument is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextcontext.SITextContext.ResetData", "modulename": "smartinspectpython.sitextcontext", "qualname": "SITextContext.ResetData", "kind": "function", "doc": "<p>Resets the internal data.</p>\n\n<p>This method is intended to reset the internal text data if\ncustom handling of data is needed by derived classes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextformatter", "modulename": "smartinspectpython.sitextformatter", "kind": "module", "doc": "<p>Module: sitextformatter.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sitextformatter.SITextFormatter", "modulename": "smartinspectpython.sitextformatter", "qualname": "SITextFormatter", "kind": "class", "doc": "<p>Responsible for creating a text representation of a packet and\nwriting it to a stream.</p>\n\n<p>This class creates a text representation of a packet and writes\nit to a stream. The representation can be influenced with the\nPattern property. The Compile method preprocesses a packet and\ncomputes the required size of the packet. The Write method writes\nthe preprocessed packet to the supplied stream.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.siformatter.SIFormatter"}, {"fullname": "smartinspectpython.sitextformatter.SITextFormatter.__init__", "modulename": "smartinspectpython.sitextformatter", "qualname": "SITextFormatter.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sitextformatter.SITextFormatter.Indent", "modulename": "smartinspectpython.sitextformatter", "qualname": "SITextFormatter.Indent", "kind": "variable", "doc": "<p>Gets the Indent property value.</p>\n\n<p>Indicates if this formatter should automatically intend log\npackets like in the Views of the SmartInspect Console.</p>\n\n<p>Log Entry packets of type EnterMethod increase the indentation\nand packets of type LeaveMethod decrease it.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sitextformatter.SITextFormatter.Pattern", "modulename": "smartinspectpython.sitextformatter", "qualname": "SITextFormatter.Pattern", "kind": "variable", "doc": "<p>Gets the Pattern property value.</p>\n\n<p>Represents the pattern used to create a text representation\nof a packet.</p>\n\n<p>For detailed information of how a pattern string can look like,\nplease have a look at the documentation of the SIPatternParser\nclass, especially the SIPatternParser.Pattern property.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sitextformatter.SITextFormatter.Compile", "modulename": "smartinspectpython.sitextformatter", "qualname": "SITextFormatter.Compile", "kind": "function", "doc": "<p>Overridden. Preprocesses (or compiles) a packet and returns the\nrequired size for the compiled result.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>packet (SIPacket):</strong>  The packet to compile.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The size for the compiled result.</p>\n</blockquote>\n\n<p>This method creates a text representation of the supplied\npacket and computes the required size. The resulting\nrepresentation can be influenced with the Pattern property.\nTo write a compiled packet, call the Write method. Please\nnote that this method only supports Log Entry objects and\nignores any other packet. This means, for packets other\nthan Log Entry, this method always returns 0.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sipacket</span><span class=\"o\">.</span><span class=\"n\">SIPacket</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextformatter.SITextFormatter.Write", "modulename": "smartinspectpython.sitextformatter", "qualname": "SITextFormatter.Write", "kind": "function", "doc": "<p>Overridden. Writes a previously compiled packet to the supplied stream.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to write the packet to.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>IOException:</strong>  An I/O error occurred while trying to write the compiled packet.</li>\n</ul>\n\n<p>This method writes the previously computed text representation\nof a packet (see Compile) to the supplied stream object.\nIf the return value of the Compile method was 0, nothing is written.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextprotocol", "modulename": "smartinspectpython.sitextprotocol", "kind": "module", "doc": "<p>Module: sitextprotocol.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol", "kind": "class", "doc": "<p>Used for writing customizable plain text log files.</p>\n\n<p>This class is used for writing plain text log files. This class is used when \nthe 'text' protocol is specified in the SmartInspect.Connections. </p>\n\n<p>For a list of available protocol options, please refer to the\nIsValidOption method.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>The public members of this class are thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sifileprotocol.SIFileProtocol"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.__init__", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.DefaultFileName", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.DefaultFileName", "kind": "variable", "doc": "<p>Returns the default filename for this log file protocol.</p>\n\n<p>The standard implementation of this method returns the string\n\"log.txt\" here. Derived classes can change this behavior by\noverriding this method.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.Formatter", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.Formatter", "kind": "variable", "doc": "<p>Returns the formatter for this log file protocol.</p>\n\n<p>The standard implementation of this method returns an instance\nof the SIBinaryFormatter class. Derived classes can change this\nbehavior by overriding this method.</p>\n", "annotation": ": smartinspectpython.siformatter.SIFormatter"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.Name", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.Name", "kind": "variable", "doc": "<p>Overridden.  Returns \"text\".</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.BuildOptions", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.BuildOptions", "kind": "function", "doc": "<p>Overridden. Fills a SIConnectionsBuilder instance with the\noptions currently used by this protocol.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>builder (SIConnectionsBuilder):</strong>  The SIConnectionsBuilder object to fill with the current options\nof this protocol.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">builder</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siconnectionsbuilder</span><span class=\"o\">.</span><span class=\"n\">SIConnectionsBuilder</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.IsValidOption", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.IsValidOption", "kind": "function", "doc": "<p>Overridden. Validates if a protocol option is supported.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The option name to validate.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the option is supported and false otherwise.</p>\n</blockquote>\n\n<p>The following table lists all valid options, their default\nvalues and descriptions for the TEXT protocol.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Valid Options (default value)</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>indent (false)</td>\n  <td>Indicates if the logging output should automatically be indented like in the Console.</td>\n</tr>\n<tr>\n  <td>pattern (\"[%timestamp%] %level%: %title%\")</td>\n  <td>Specifies the pattern used to create a text representation of a packet.</td>\n</tr>\n</tbody>\n</table>\n\n<p>Please note that this protocol DOES NOT support log file encryption.</p>\n\n<p>For further options which affect the behavior of this protocol, please have a look at the documentation of the\nSIProtocol.IsValidOption method of the parent class.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># the following are sample SI Connections options for this protocol.</span>\n\n<span class=\"c1\"># log messages using all default options (&quot;log.sil&quot;, no indent).</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text()&quot;</span>\n\n<span class=\"c1\"># log messages using all default options (&quot;log.sil&quot;, no indent).</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">log.txt</span><span class=\"se\">\\&quot;</span><span class=\"s2\">)&quot;</span>\n\n<span class=\"c1\"># log messages (appending) to file &#39;mylog.txt&#39;.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">mylog.txt</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, append=true)&quot;</span>\n\n<span class=\"c1\"># log messages to rotating log file &#39;mylog.txt&#39;, that creates a new log </span>\n<span class=\"c1\"># file every week.  since maxparts is not specified, log files will continue </span>\n<span class=\"c1\"># to accumulate and must be manually deleted.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">mylog.txt</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, append=true, rotate=weekly&quot;</span>\n\n<span class=\"c1\"># log messages to rotating log file &#39;mylog.txt&#39;, that creates a new log </span>\n<span class=\"c1\"># file every week; keep only 7 log files, automatically deleting outdated files.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">mylog.txt</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, append=true, rotate=weekly, maxparts=7)&quot;</span>\n\n<span class=\"c1\"># log messages to file &quot;mylog.txt&quot; using a custom pattern.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text(filename=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">mylog.txt</span><span class=\"se\">\\&quot;</span><span class=\"s2\">, append=true, pattern=</span><span class=\"se\">\\&quot;</span><span class=\"si\">%le</span><span class=\"s2\">vel% [%timestamp%]: %title%</span><span class=\"se\">\\&quot;</span><span class=\"s2\">)&quot;</span>\n\n<span class=\"c1\"># log messages to rotating default file &#39;mylog.txt&#39;, that do not </span>\n<span class=\"c1\"># exceed 16MB in size.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;text(maxsize=</span><span class=\"se\">\\&quot;</span><span class=\"s2\">16MB</span><span class=\"se\">\\&quot;</span><span class=\"s2\">)&quot;</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.LoadOptions", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.LoadOptions", "kind": "function", "doc": "<p>Overridden. Loads and inspects specific options for this protocol.</p>\n\n<p>This method loads all relevant options and ensures their\ncorrectness. See IsValidOption for a list of options which\nare recognized by the protocol.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.WriteFooter", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.WriteFooter", "kind": "function", "doc": "<p>Intended to write the footer of a log file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to which the footer should be written to.</li>\n</ul>\n\n<p>The implementation of this method does nothing. Derived\nclass may change this behavior by overriding this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitextprotocol.SITextProtocol.WriteHeader", "modulename": "smartinspectpython.sitextprotocol", "qualname": "SITextProtocol.WriteHeader", "kind": "function", "doc": "<p>Overridden.  Intended to write the header of a log file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stream (BytesIO):</strong>  The stream to which the header should be written to.</li>\n<li><strong>size (int):</strong>  Specifies the current size of the supplied stream.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new size of the stream after writing the header. If no\n  header is written, the supplied size argument is returned.</p>\n</blockquote>\n\n<p>The implementation of this method writes the standard UTF8\nBOM (byte order mark) to the supplied stream in order to\nidentify the log file as text file in UTF8 encoding. Derived\nclasses may change this behavior by overriding this method.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stream</span><span class=\"p\">:</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">BytesIO</span>, </span><span class=\"param\"><span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitoken", "modulename": "smartinspectpython.sitoken", "kind": "module", "doc": "<p>Module: sitoken.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sitoken.SIToken", "modulename": "smartinspectpython.sitoken", "qualname": "SIToken", "kind": "class", "doc": "<p>Represents a token in the pattern string of the SITextProtocol protocol.</p>\n\n<p>This is the abstract base class for all available tokens. Derived\nclasses are not documented for clarity reasons. To create a\nsuitable token object for a given token string, you can use the\nSITokenFactory class.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sitoken.SIToken.__init__", "modulename": "smartinspectpython.sitoken", "qualname": "SIToken.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sitoken.SIToken.Indent", "modulename": "smartinspectpython.sitoken", "qualname": "SIToken.Indent", "kind": "variable", "doc": "<p>Gets the Indent property value.</p>\n\n<p>Indicates if this token supports indenting.</p>\n\n<p>This property always returns false unless this token represents\nthe title token of a pattern string. This property is used\nby the SIPatternParser.Expand method to determine if a token\nallows indenting.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.sitoken.SIToken.Options", "modulename": "smartinspectpython.sitoken", "qualname": "SIToken.Options", "kind": "variable", "doc": "<p>Gets the Options property value.</p>\n\n<p>Represents the optional options string for this token.</p>\n\n<p>A variable token can have an optional options string. In the\nraw string representation of a token, an options string can be\nspecified in curly braces after the variable name like this:\n%name{options}%. For a literal, this property is always set to\nan empty string.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sitoken.SIToken.Value", "modulename": "smartinspectpython.sitoken", "qualname": "SIToken.Value", "kind": "variable", "doc": "<p>Gets the Value property value.</p>\n\n<p>Represents the raw string value of the parsed pattern string for this token.</p>\n\n<p>This property represents the raw string of this token as found\nin the parsed pattern string. For a variable, this property is\nset to the variable name surrounded with '%' characters and an\noptional options string like this: %name{options}%. For a\nliteral, this property can have any value.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.sitoken.SIToken.Width", "modulename": "smartinspectpython.sitoken", "qualname": "SIToken.Width", "kind": "variable", "doc": "<p>Gets the Width property value.</p>\n\n<p>Represents the minimum width of this token.</p>\n\n<p>A variable token can have an optional width modifier. In the\nraw string representation of a token, a width modifier can be\nspecified after the variable name like this: %name,width%.\nWidth must be a valid positive or negative integer.</p>\n\n<p>If the width is greater than 0, formatted values will be\nright-aligned. If the width is less than 0, they will be\nleft-aligned.</p>\n\n<p>For a literal, this property is always set to 0.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.sitoken.SIToken.Expand", "modulename": "smartinspectpython.sitoken", "qualname": "SIToken.Expand", "kind": "function", "doc": "<p>Creates a string representation of a variable or literal token.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>logEntry (SILogEntry):</strong>  The Log Entry to use to create the string representation.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The text representation of this token for the supplied Log Entry object.</p>\n</blockquote>\n\n<p>With the help of the supplied Log Entry, this token is expanded into a string. \nFor example, if this token represents the %session% variable of a pattern string, \nthis Expand method simply returns the session name of the supplied Log Entry.</p>\n\n<p>For a literal token, the supplied Log Entry argument is ignored\nand the Value property is returned.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">logEntry</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">silogentry</span><span class=\"o\">.</span><span class=\"n\">SILogEntry</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitokenfactory", "modulename": "smartinspectpython.sitokenfactory", "kind": "module", "doc": "<p>Module: sitokenfactory.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sitokenfactory.SITokenFactory", "modulename": "smartinspectpython.sitokenfactory", "qualname": "SITokenFactory", "kind": "class", "doc": "<p>Creates instances of Token subclasses.</p>\n\n<p>This class has only one public method called GetToken, which\nis capable of creating Token objects depending on the given\nargument.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.sitokenfactory.SITokenFactory.__init__", "modulename": "smartinspectpython.sitokenfactory", "qualname": "SITokenFactory.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.sitokenfactory.SITokenFactory.static_init", "modulename": "smartinspectpython.sitokenfactory", "qualname": "SITokenFactory.static_init", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitokenfactory.SITokenFactory.CreateLiteral", "modulename": "smartinspectpython.sitokenfactory", "qualname": "SITokenFactory.CreateLiteral", "kind": "function", "doc": "<p>Creates a LiteralToken instance.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The value to assign to the literal token.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A LiteralToken object with the value assigned.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sitoken</span><span class=\"o\">.</span><span class=\"n\">SIToken</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitokenfactory.SITokenFactory.GetToken", "modulename": "smartinspectpython.sitokenfactory", "qualname": "SITokenFactory.GetToken", "kind": "function", "doc": "<p>Creates instance of Token subclasses.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The original string representation of the token.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An appropriate Token object for the given string representation of a token.</p>\n</blockquote>\n\n<p>This method analyzes and parses the supplied representation of\na token and creates an appropriate Token object. For example,\nif the value argument is set to \"%session%\", a Token object\nis created and returned which is responsible for expanding the\n%session% variable. For a list of available tokens and a\ndetailed description, please have a look at the SIPatternParser\nclass, especially the SIPatternParser.Pattern property.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sitoken</span><span class=\"o\">.</span><span class=\"n\">SIToken</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sitokenfactory.SITokenFactory.ParseWidth", "modulename": "smartinspectpython.sitokenfactory", "qualname": "SITokenFactory.ParseWidth", "kind": "function", "doc": "<p>Parses the specified value for it's width.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The value to obtain the width of.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The width of the value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils", "modulename": "smartinspectpython.siutils", "kind": "module", "doc": "<p>Module: siutils.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n\n<p>Utility module of helper functions and classes.</p>\n"}, {"fullname": "smartinspectpython.siutils.static_init", "modulename": "smartinspectpython.siutils", "qualname": "static_init", "kind": "function", "doc": "<p>Define the decorator used to call an initializer for a class with all static methods.\nThis allows static variables to be initialized one time for the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.export", "modulename": "smartinspectpython.siutils", "qualname": "export", "kind": "function", "doc": "<p>Define the decorator used to modify a module's \"__all__\" variable.\nThis avoids us having to manually modify a module's \"__all__\" variable when adding new classes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fn</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.Event", "modulename": "smartinspectpython.siutils", "qualname": "Event", "kind": "class", "doc": "<p>C# like event processing in Python3.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siutils</span> <span class=\"kn\">import</span> <span class=\"n\">Event</span>\n\n<span class=\"c1\"># Define the class that will be raising events:</span>\n<span class=\"k\">class</span> <span class=\"nc\">MyFileWatcher</span><span class=\"p\">:</span>\n    <span class=\"k\">def</span> <span class=\"fm\">__init__</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">):</span>\n        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">=</span> <span class=\"n\">Event</span><span class=\"p\">()</span>      <span class=\"c1\"># define event</span>\n\n    <span class=\"k\">def</span> <span class=\"nf\">watchFiles</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">):</span>\n        <span class=\"n\">source_path</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;foo&quot;</span>\n        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span><span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">)</span>   <span class=\"c1\"># fire event</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">log_file_change</span><span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">):</span>       <span class=\"c1\"># event handler 1</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;</span><span class=\"si\">%r</span><span class=\"s2\"> changed.&quot;</span> <span class=\"o\">%</span> <span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">,))</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">log_file_change2</span><span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">):</span>      <span class=\"c1\"># event handler 2</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;</span><span class=\"si\">%r</span><span class=\"s2\"> changed!&quot;</span> <span class=\"o\">%</span> <span class=\"p\">(</span><span class=\"n\">source_path</span><span class=\"p\">,))</span>\n\n<span class=\"c1\"># Define the code that will be handling raised events.</span>\n<span class=\"n\">watcher</span>              <span class=\"o\">=</span> <span class=\"n\">MyFileWatcher</span><span class=\"p\">()</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">+=</span> <span class=\"n\">log_file_change2</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">+=</span> <span class=\"n\">log_file_change</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">fileChanged</span> <span class=\"o\">-=</span> <span class=\"n\">log_file_change2</span>\n<span class=\"n\">watcher</span><span class=\"o\">.</span><span class=\"n\">watchFiles</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siutils.Event.__init__", "modulename": "smartinspectpython.siutils", "qualname": "Event.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span></span>)</span>"}, {"fullname": "smartinspectpython.siutils.Event.handlers", "modulename": "smartinspectpython.siutils", "qualname": "Event.handlers", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "smartinspectpython.siutils.Event.fire", "modulename": "smartinspectpython.siutils", "qualname": "Event.fire", "kind": "function", "doc": "<p>Calls (i.e. \"fires\") all method handlers defined for this event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.Event.getHandlerCount", "modulename": "smartinspectpython.siutils", "qualname": "Event.getHandlerCount", "kind": "function", "doc": "<p>Returns the number of method handlers defined for this event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.Event.handle", "modulename": "smartinspectpython.siutils", "qualname": "Event.handle", "kind": "function", "doc": "<p>Adds a method handler for this event.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">handler</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.Event.unhandle", "modulename": "smartinspectpython.siutils", "qualname": "Event.unhandle", "kind": "function", "doc": "<p>Removes the specified method handler for this event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>handler (object):</strong>  The method handler to remove.</li>\n</ul>\n\n<p>This method will not throw an exception.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">handler</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.Event.unhandle_all", "modulename": "smartinspectpython.siutils", "qualname": "Event.unhandle_all", "kind": "function", "doc": "<p>Removes all method handlers (if any) for this event.</p>\n\n<p>This method will not throw an exception.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.DataTypeHelper", "modulename": "smartinspectpython.siutils", "qualname": "DataTypeHelper", "kind": "class", "doc": "<p>Helper class used for processing different types of data.</p>\n"}, {"fullname": "smartinspectpython.siutils.DataTypeHelper.BoolToStringYesNo", "modulename": "smartinspectpython.siutils", "qualname": "DataTypeHelper.BoolToStringYesNo", "kind": "function", "doc": "<p>Converts a boolean value to a \"Yes\" (true) or \"No\" (false) string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (bool):</strong>  Boolean value to convert.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A \"Yes\" or \"No\" string value.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siutils.DateHelper", "modulename": "smartinspectpython.siutils", "qualname": "DateHelper", "kind": "class", "doc": "<p>Helper class used for processing date and time data.</p>\n"}, {"fullname": "smartinspectpython.siutils.DateHelper.Ticks", "modulename": "smartinspectpython.siutils", "qualname": "DateHelper.Ticks", "kind": "function", "doc": "<p>Returns the number of ticks for a given datetime.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dt</span><span class=\"p\">:</span> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sivaluelistviewercontext", "modulename": "smartinspectpython.sivaluelistviewercontext", "kind": "module", "doc": "<p>Module: sivaluelistviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.sivaluelistviewercontext.SIValueListViewerContext", "modulename": "smartinspectpython.sivaluelistviewercontext", "qualname": "SIValueListViewerContext", "kind": "class", "doc": "<p>Represents the value list viewer in the Console which can display data as a key/value list.</p>\n\n<p>The value list viewer in the Console interprets the Log Entry Data as a simple key/value list.\nEvery line in the text data is interpreted as one key/value item of the list. This class \ntakes care of the necessary formatting and escaping required by the corresponding value \nlist viewer of the Console.</p>\n\n<p>You can use the SIValueListViewerContext class for creating custom log methods around \nSISession.LogCustomContext for sending custom data organized as key/value lists.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.silistviewercontext.SIListViewerContext"}, {"fullname": "smartinspectpython.sivaluelistviewercontext.SIValueListViewerContext.__init__", "modulename": "smartinspectpython.sivaluelistviewercontext", "qualname": "SIValueListViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>vi (SIViewerId):</strong>  The viewer ID to use;  SIViewerId.ValueList will be used if value is null.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "smartinspectpython.sivaluelistviewercontext.SIValueListViewerContext.AppendKeyValue", "modulename": "smartinspectpython.sivaluelistviewercontext", "qualname": "SIValueListViewerContext.AppendKeyValue", "kind": "function", "doc": "<p>Adds an entry to the current row.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key to use.</li>\n<li><strong>value (str):</strong>  The entry to add; must be able to be converted to a string\nvia the \"str(x)\" syntax.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.sivaluelistviewercontext.SIValueListViewerContext.EscapeItem", "modulename": "smartinspectpython.sivaluelistviewercontext", "qualname": "SIValueListViewerContext.EscapeItem", "kind": "function", "doc": "<p>Escapes a key or a value.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>item (str):</strong>  The key or value to escape.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The escaped key or value.</p>\n</blockquote>\n\n<p>This method ensures that the escaped key or value does not\ncontain any newline characters, such as the carriage return\nor linefeed characters. Furthermore, it escapes the '' and\n'=' characters.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">item</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siviewercontext", "modulename": "smartinspectpython.siviewercontext", "kind": "module", "doc": "<p>Module: siviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siviewercontext.SIViewerContext", "modulename": "smartinspectpython.siviewercontext", "qualname": "SIViewerContext", "kind": "class", "doc": "<p>Is the abstract base class for a viewer context. A viewer context\nis the library-side representation of a viewer in the Console.</p>\n\n<p>A viewer context contains a viewer ID and data which can be\ndisplayed in a viewer in the Console. Every viewer in the Console\nhas a corresponding viewer context class in this library. A viewer\ncontext is capable of processing data and to format it in a way\nso that the corresponding viewer in the Console can display it.</p>\n\n<p>Viewer contexts provide a simple way to extend the functionality\nof the SmartInspect library. See the SISession.LogCustomContext\nmethod for a detailed example.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siviewercontext.SIViewerContext.__init__", "modulename": "smartinspectpython.siviewercontext", "qualname": "SIViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">vi</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siviewerid</span><span class=\"o\">.</span><span class=\"n\">SIViewerId</span></span>)</span>"}, {"fullname": "smartinspectpython.siviewercontext.SIViewerContext.ViewerData", "modulename": "smartinspectpython.siviewercontext", "qualname": "SIViewerContext.ViewerData", "kind": "variable", "doc": "<p>Returns the actual data which will be displayed in the\nviewer specified by the viewer id.</p>\n\n<p>This property must be overridden by inheriting class.</p>\n", "annotation": ": _io.BytesIO"}, {"fullname": "smartinspectpython.siviewercontext.SIViewerContext.ViewerId", "modulename": "smartinspectpython.siviewercontext", "qualname": "SIViewerContext.ViewerId", "kind": "variable", "doc": "<p>Returns the viewer ID which specifies the viewer\nto use in the Console.</p>\n", "annotation": ": smartinspectpython.siviewerid.SIViewerId"}, {"fullname": "smartinspectpython.siviewercontext.SIViewerContext.Dispose", "modulename": "smartinspectpython.siviewercontext", "qualname": "SIViewerContext.Dispose", "kind": "function", "doc": "<p>Releases any unmanaged (and optionally) managed resources of this viewer context.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>disposing (bool):</strong>  True if managed resources should be released and false otherwise.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">disposing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.siviewerid", "modulename": "smartinspectpython.siviewerid", "kind": "module", "doc": "<p>Module: siviewerid.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId", "kind": "class", "doc": "<p>Specifies the viewer for displaying the title or data of a Log\nEntry in the Console.</p>\n\n<p>There are many viewers available for displaying the data of a\nLog Entry in different ways. For example, there are viewers that\ncan display lists, tables, binary dumps of data or even websites.</p>\n\n<p>Every viewer in the Console has a corresponding so called viewer\ncontext in this library which can be used to send custom logging\ninformation. To get started, please see the documentation of the\nSISession.LogCustomContext method and SIViewerContext class.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.NoViewer", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.NoViewer", "kind": "variable", "doc": "<p>Instructs the Console to use no viewer at all.</p>\n", "default_value": "&lt;SIViewerId.NoViewer: -1&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Title", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Title", "kind": "variable", "doc": "<p>Instructs the Console to display the title of a Log Entry\nin a read-only text field.</p>\n", "default_value": "&lt;SIViewerId.Title: 0&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Data", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Data", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nin a read-only text field.</p>\n", "default_value": "&lt;SIViewerId.Data: 1&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.List", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.List", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas a list.</p>\n", "default_value": "&lt;SIViewerId.List: 2&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.ValueList", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.ValueList", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas a key/value list.</p>\n", "default_value": "&lt;SIViewerId.ValueList: 3&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Inspector", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Inspector", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nusing an object inspector.</p>\n", "default_value": "&lt;SIViewerId.Inspector: 4&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Table", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Table", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas a table.</p>\n", "default_value": "&lt;SIViewerId.Table: 5&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Web", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Web", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas a website.</p>\n", "default_value": "&lt;SIViewerId.Web: 100&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Binary", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Binary", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas a binary dump using a read-only hex editor.</p>\n", "default_value": "&lt;SIViewerId.Binary: 200&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.HtmlSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.HtmlSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas HTML source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.HtmlSource: 300&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.JavaScriptSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.JavaScriptSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas Java Script source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.JavaScriptSource: 301&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.VbScriptSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.VbScriptSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas VBScript source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.VbScriptSource: 302&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.PerlSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.PerlSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas Perl source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.PerlSource: 303&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.SqlSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.SqlSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas SQL source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.SqlSource: 304&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.IniSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.IniSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas INI source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.IniSource: 305&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.PythonSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.PythonSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas Python source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.PythonSource: 306&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.XmlSource", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.XmlSource", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas XML source with syntax highlighting.</p>\n", "default_value": "&lt;SIViewerId.XmlSource: 307&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Bitmap", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Bitmap", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas bitmap image.</p>\n", "default_value": "&lt;SIViewerId.Bitmap: 400&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Jpeg", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Jpeg", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas JPEG image.</p>\n", "default_value": "&lt;SIViewerId.Jpeg: 401&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Icon", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Icon", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas a Windows icon.</p>\n", "default_value": "&lt;SIViewerId.Icon: 402&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Metafile", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Metafile", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas Windows Metafile image.</p>\n", "default_value": "&lt;SIViewerId.Metafile: 403&gt;"}, {"fullname": "smartinspectpython.siviewerid.SIViewerId.Png", "modulename": "smartinspectpython.siviewerid", "qualname": "SIViewerId.Png", "kind": "variable", "doc": "<p>Instructs the Console to display the data of a Log Entry\nas PNG image.</p>\n", "default_value": "&lt;SIViewerId.Png: 404&gt;"}, {"fullname": "smartinspectpython.siwatch", "modulename": "smartinspectpython.siwatch", "kind": "module", "doc": "<p>Module: siwatch.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siwatch.SIWatch", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch", "kind": "class", "doc": "<p>Represents the Watch packet type which is used in the Watch\nmethods in the SISession class.</p>\n\n<p>A Watch is responsible for sending variables and their values\nto the Console. These key/value pairs will be displayed in the\nWatches toolbox. If a Watch with the same name is sent twice,\nthe old value is overwritten and the Watches toolbox displays\nthe most current value.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe. However, instances\n  of this class will normally only be used in the context of a\n  single thread.</p>\n</blockquote>\n", "bases": "smartinspectpython.sipacket.SIPacket"}, {"fullname": "smartinspectpython.siwatch.SIWatch.__init__", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.__init__", "kind": "function", "doc": "<p>Initializes a new SIWatch instance with a\ncustom watch type.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>watchType (SIWatchType):</strong>  The type of the new Watch describes the variable type (String,\nInteger and so on). Please see the SIWatchType enum for more\ninformation.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">watchType</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siwatchtype</span><span class=\"o\">.</span><span class=\"n\">SIWatchType</span></span>)</span>"}, {"fullname": "smartinspectpython.siwatch.SIWatch.HEADER_SIZE", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.HEADER_SIZE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "20"}, {"fullname": "smartinspectpython.siwatch.SIWatch.Name", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.Name", "kind": "variable", "doc": "<p>Gets the Name property value.</p>\n\n<p>Represents the name of this Watch.</p>\n\n<p>If a Watch with the same name is sent twice, the old value is\noverwritten and the Watches toolbox displays the most current\nvalue. The name of this Watch will be empty in the SmartInspect\nConsole when this property is set to null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siwatch.SIWatch.PacketType", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.PacketType", "kind": "variable", "doc": "<p>Overridden.  Returns SIPacketType.Watch</p>\n", "annotation": ": smartinspectpython.sipackettype.SIPacketType"}, {"fullname": "smartinspectpython.siwatch.SIWatch.Size", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.Size", "kind": "variable", "doc": "<p>Overridden. Returns the total occupied memory size of this Watch packet.</p>\n\n<p>The total occupied memory size of this Watch is the size of\nmemory occupied by all strings and any internal data structures\nof this Watch.</p>\n", "annotation": ": int"}, {"fullname": "smartinspectpython.siwatch.SIWatch.Timestamp", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.Timestamp", "kind": "variable", "doc": "<p>Gets the Timestamp property value.</p>\n\n<p>Represents the time-stamp of this Watch object.</p>\n\n<p>This property returns the creation time of this object.</p>\n", "annotation": ": datetime.datetime"}, {"fullname": "smartinspectpython.siwatch.SIWatch.Value", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.Value", "kind": "variable", "doc": "<p>Gets the Value property value.</p>\n\n<p>Represents the value of this Watch.</p>\n\n<p>The value of a Watch is always sent as String. To view the\ntype of this variable Watch, please have a look at the\nWatchType property. The value of this Watch will be empty in\nthe SmartInspect Console when this property is set to null.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.siwatch.SIWatch.WatchType", "modulename": "smartinspectpython.siwatch", "qualname": "SIWatch.WatchType", "kind": "variable", "doc": "<p>Gets the WatchType property value.</p>\n\n<p>Represents the type of this Watch.</p>\n\n<p>The type of this Watch describes the variable type (String,\nInteger and so on). Please see the SIWatchType enum for more\ninformation.</p>\n", "annotation": ": smartinspectpython.siwatchtype.SIWatchType"}, {"fullname": "smartinspectpython.siwatcheventargs", "modulename": "smartinspectpython.siwatcheventargs", "kind": "module", "doc": "<p>Module: siwatcheventargs.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siwatcheventargs.SIWatchEventArgs", "modulename": "smartinspectpython.siwatcheventargs", "qualname": "SIWatchEventArgs", "kind": "class", "doc": "<p>This class is used by the SmartInspect.WatchEvent event.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.siwatcheventargs.SIWatchEventArgs.__init__", "modulename": "smartinspectpython.siwatcheventargs", "qualname": "SIWatchEventArgs.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>watch (SIWatch):</strong>  The Watch item that was processed.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">watch</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siwatch</span><span class=\"o\">.</span><span class=\"n\">SIWatch</span></span>)</span>"}, {"fullname": "smartinspectpython.siwatcheventargs.SIWatchEventArgs.Watch", "modulename": "smartinspectpython.siwatcheventargs", "qualname": "SIWatchEventArgs.Watch", "kind": "variable", "doc": "<p>Returns the Watch item that was processed.</p>\n", "annotation": ": smartinspectpython.siwatch.SIWatch"}, {"fullname": "smartinspectpython.siwatcheventargs.SIWatchEventHandler", "modulename": "smartinspectpython.siwatcheventargs", "qualname": "SIWatchEventHandler", "kind": "class", "doc": "<p>This is the event handler type for the SmartInspect.WatchEvent event.</p>\n"}, {"fullname": "smartinspectpython.siwatcheventargs.SIWatchEventHandler.__init__", "modulename": "smartinspectpython.siwatcheventargs", "qualname": "SIWatchEventHandler.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIWatchEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">siwatcheventargs</span><span class=\"o\">.</span><span class=\"n\">SIWatchEventArgs</span></span>)</span>"}, {"fullname": "smartinspectpython.siwatchtype", "modulename": "smartinspectpython.siwatchtype", "kind": "module", "doc": "<p>Module: siwatchtype.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType", "kind": "class", "doc": "<p>Represents the type of a Watch packet. The type of a Watch\nspecifies its variable type.</p>\n\n<p>For example, if a Watch packet has a type of SIWatchType.String,\nthe represented variable is treated as string in the Console.</p>\n", "bases": "smartinspectpython.sienumcomparable.SIEnumComparable"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.Char", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.Char", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as char.</p>\n", "default_value": "&lt;SIWatchType.Char: 0&gt;"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.String", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.String", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as string.</p>\n", "default_value": "&lt;SIWatchType.String: 1&gt;"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.Integer", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.Integer", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as integer.</p>\n", "default_value": "&lt;SIWatchType.Integer: 2&gt;"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.Float", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.Float", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as float.</p>\n", "default_value": "&lt;SIWatchType.Float: 3&gt;"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.Boolean", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.Boolean", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as boolean.</p>\n", "default_value": "&lt;SIWatchType.Boolean: 4&gt;"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.Address", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.Address", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as address.</p>\n", "default_value": "&lt;SIWatchType.Address: 5&gt;"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.Timestamp", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.Timestamp", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as timestamp.</p>\n", "default_value": "&lt;SIWatchType.Timestamp: 6&gt;"}, {"fullname": "smartinspectpython.siwatchtype.SIWatchType.Object", "modulename": "smartinspectpython.siwatchtype", "qualname": "SIWatchType.Object", "kind": "variable", "doc": "<p>Instructs the Console to treat a Watch value as object.</p>\n", "default_value": "&lt;SIWatchType.Object: 7&gt;"}, {"fullname": "smartinspectpython.siwebviewercontext", "modulename": "smartinspectpython.siwebviewercontext", "kind": "module", "doc": "<p>Module: siwebviewercontext.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.siwebviewercontext.SIWebViewerContext", "modulename": "smartinspectpython.siwebviewercontext", "qualname": "SIWebViewerContext", "kind": "class", "doc": "<p>Represents the web viewer in the Console which can display HTML\ntext content as web pages.</p>\n\n<p>The web viewer in the Console interprets the Log Entry Data\nas an HTML website.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is not guaranteed to be thread-safe.</p>\n</blockquote>\n", "bases": "smartinspectpython.sitextcontext.SITextContext"}, {"fullname": "smartinspectpython.siwebviewercontext.SIWebViewerContext.__init__", "modulename": "smartinspectpython.siwebviewercontext", "qualname": "SIWebViewerContext.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class with a SIViewerId.Web.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, {"fullname": "smartinspectpython.smartinspect", "modulename": "smartinspectpython.smartinspect", "kind": "module", "doc": "<p>Module: smartinspect.py</p>\n\n<p><details>\n  <summary>Revision History</summary></p>\n\n<table>\n<thead>\n<tr>\n  <th>Date</th>\n  <th>Version</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2023/09/27</td>\n  <td>3.0.21.0</td>\n  <td>Updated documentation sample code and examples.</td>\n</tr>\n<tr>\n  <td>2023/06/09</td>\n  <td>3.0.8.0</td>\n  <td>Added InfoEvent event and RaiseInfoEvent method to convey SI informational events to interested parties (e.g. Si Console Server banner, etc).</td>\n</tr>\n<tr>\n  <td>2023/05/30</td>\n  <td>3.0.0.0</td>\n  <td>Initial Version.</td>\n</tr>\n</tbody>\n</table>\n\n<p></details></p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect", "kind": "class", "doc": "<p>The SmartInspect class is the most important class in the SmartInspect Python3 library. An instance of this class is able\nto write log messages to a file or to send them directly to the SmartInspect Console using TCP. You can control these\nconnections by setting the Connections property. </p>\n\n<p>The SmartInspect class offers several properties for controlling the logging behavior. Besides the Connections property there\nis the Enabled property which controls if log messages should be sent or not. Furthermore, the AppName property specifies the\napplication name displayed in the SmartInspect Console. And last but not least, we have the Level and DefaultLevel properties\nwhich specify the log level of an SmartInspect object and its related sessions.</p>\n\n<p>Additionally, the SmartInspect class acts as parent for sessions, which contain the actual logging methods, like, for\nexample, SISession.LogMessage or SISession.LogObject. It is possible and common that several different sessions have the same parent\nand thus share the same connections. The SISession class contains dozens of useful methods for logging any kind of data. Sessions\ncan even log variable watches, generate illustrated process and thread information or control the behavior of the SmartInspect\nConsole. It is possible, for example, to clear the entire log in the Console by calling the SISession.ClearLog method.</p>\n\n<p>To accomplish these different tasks the SmartInspect concept uses several different packets. The SmartInspect class manages these\npackets and logs them to its connections. It is possibility to register event handlers for every packet type which are called\nafter a corresponding packet has been sent.</p>\n\n<p>The error handling in the SmartInspect Python3 library is a little bit different than in other libraries. This library uses\nan event, the Error event, for reporting errors. We've chosen this way because a logging framework should not alter the behavior\nof an application by firing exceptions. The only exception you need to handle can be thrown by the Connections property if the\nsupplied SmartInspect.Connections contains errors.</p>\n\n<h6 id=\"threadsafety\">Threadsafety:</h6>\n\n<blockquote>\n  <p>This class is fully thread-safe.</p>\n</blockquote>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.__init__", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.__init__", "kind": "function", "doc": "<p>Initializes a new instance of the class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>appName (str):</strong>  The application name used for Log Entries. It is usually set to the name of the application which creates this object.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">appName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.ErrorEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.ErrorEvent", "kind": "variable", "doc": "<p>Event raised when an error occurs in SmartInspect processing.</p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.FilterEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.FilterEvent", "kind": "variable", "doc": "<p>Event raised to allow packet filtering before a packet is sent to the protocol destination.</p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.InfoEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.InfoEvent", "kind": "variable", "doc": "<p>Event raised when an informational event occurs in SmartInspect processing.</p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.LogEntryEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.LogEntryEvent", "kind": "variable", "doc": "<p>Event raised when a Log Entry packet is sent to the protocol destination.</p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.WatchEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.WatchEvent", "kind": "variable", "doc": "<p>Event raised when a Watch packet is sent to the protocol destination.</p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.ProcessFlowEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.ProcessFlowEvent", "kind": "variable", "doc": "<p>Event raised when a Process Flow packet is sent to the protocol destination.</p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.ControlCommandEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.ControlCommandEvent", "kind": "variable", "doc": "<p>Event raised when a Control Command packet is sent to the protocol destination.</p>\n"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.AppName", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.AppName", "kind": "variable", "doc": "<p>Gets the AppName property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The application name used for the Log Entries.</p>\n</blockquote>\n\n<p>The application name helps you to identify Log Entries from different applications in the SmartInspect Console. \nIf you set this property to null, the application name will be empty when sending Log Entries.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.Connections", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.Connections", "kind": "variable", "doc": "<p>Gets the Connections property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A connection string that contains all connections used by this SmartInspect instance.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIInvalidConnectionsException:</strong>  Invalid syntax, unknown protocols or inexistent options.</li>\n</ul>\n\n<p>You can set multiple connections by separating the connections with commas. A connection consists of a protocol\nidentifier like \"file\" plus optional protocol parameters in parentheses. If you, for example, want to log to a file, the\nConnections property must be set to \"file()\". You can specify the filename in the parentheses after the protocol identifier\nlike this: \"file(filename=\\\"c:\\mylogfile.sil\\\")\". Please note that if the Enabled property is set to true, the connections\ntry to connect to their destinations immediately. By default, no connections are used.</p>\n\n<p>See the SIProtocol class for a list of available protocols and SIProtocolFactory for a way to add your own custom protocols.\nFurthermore have a look at the LoadConnections and LoadConfiguration methods, which can load a connections string from a file. \nAlso, for a class which assists in building connections strings, please refer to the documentation of the SIConnectionsBuilder class.</p>\n\n<p>To automatically replace placeholders in the given connections string, you can use so called connection variables. Please\nhave a look at the SetVariable method for more information.</p>\n\n<p>Please note that an SIInvalidConnectionsException exception is thrown if an invalid connections string is supplied.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># log messages to default file &#39;log.sil&#39;.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;file()&#39;</span>\n\n<span class=\"c1\"># log messages to file &#39;mylog.sil&#39;.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(filename=&quot;&quot;mylog.sil&quot;&quot;, append=true)&quot;</span>\n\n<span class=\"c1\"># log messages to default file &quot;log.sil&quot;, as well as to the SmartInspect </span>\n<span class=\"c1\"># Console viewer running on localhost.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(append=true), tcp(host=&quot;&quot;localhost&quot;&quot;)&quot;</span>\n\n<span class=\"c1\"># log messages to default file &quot;log.sil&quot;, as well as to file &quot;anotherlog.sil&quot;.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;file(), file(filename=&quot;&quot;anotherlog.sil&quot;&quot;)&quot;</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.DefaultLevel", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.DefaultLevel", "kind": "variable", "doc": "<p>Gets the DefaultLevel property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The default log level of this SmartInspect instance and its related sessions.</p>\n</blockquote>\n\n<p>The DefaultLevel property of this SmartInspect instance represents the default log level used by its corresponding\nsessions. The default value of this property is SILevel.Message.</p>\n\n<p>Every method in the SISession class which makes use of the parent's Level and does not take a Level argument, uses the \ndefault level of its parent as log level.</p>\n", "annotation": ": smartinspectpython.silevel.SILevel"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.Enabled", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.Enabled", "kind": "variable", "doc": "<p>Gets the Enabled property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The logging Enabled status.</p>\n</blockquote>\n\n<p>This property allows you to control if anything should be logged at all.</p>\n\n<p>If you set this property to true, all connections will try to connect to their destinations. For example, if the\nConnections property is set to \"file(filename=c:\\log.sil)\", the file \"c:\\log.sil\" will be opened to write all following\npackets to it. By setting this property to false, all connections will disconnect.</p>\n\n<p>Additionally, every SISession class method evaluates if its parent is enabled and returns immediately if this is not the case.\nThis guarantees that the performance hit is minimal when logging is disabled. The default value of this property is\nfalse. You need to set this property to true before you can use the SmartInspect instance and its related sessions.</p>\n\n<p>Please note: If one or more connections of this SmartInspect object operate in SIProtocol.IsValidOption\nyou must disable this object by setting this property to false before exiting your application to properly exit\nand cleanup the protocol related threads. Disabling this instance may block until the related protocol threads are\nfinished.</p>\n", "annotation": ": bool"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.HostName", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.HostName", "kind": "variable", "doc": "<p>Gets the HostName property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Returns the hostname of the current machine. </p>\n</blockquote>\n\n<p>The hostname helps you to identify Log Entries from different machines in the SmartInspect Console.\nThe value of this property is derived from the \"socket.gethostname()\" module method.</p>\n", "annotation": ": str"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.Level", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.Level", "kind": "variable", "doc": "<p>Gets the Level property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Returns the log level of this SmartInspect instance and its related sessions.</p>\n</blockquote>\n\n<p>The Level property of this SmartInspect instance represents the log level used by its corresponding sessions to determine\nif information should be logged or not. The default value of this property is SILevel.Debug.</p>\n\n<p>Every method (except the Clear method family) in the SISession class tests if its log level equals or is greater than the\nlog level of its parent. If this is not the case, the methods return immediately and won't log anything.</p>\n\n<p>The log level for a method in the SISession class can either be specified explicitly by passing a Level argument or implicitly\nby using the DefaultLevel. Every method in the SISession class which makes use of the parent's log level and does not take a \nLevel argument, uses the DefaultLevel of its parent as log level.</p>\n\n<p>For more information about the default level, please refer to the documentation of the DefaultLevel property.</p>\n", "annotation": ": smartinspectpython.silevel.SILevel"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.SessionDefaults", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.SessionDefaults", "kind": "variable", "doc": "<p>Gets the SessionDefaults property value.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The default property values for new sessions.</p>\n</blockquote>\n\n<p>This property lets you specify the default property values for new sessions which will be created by or passed to the\nAddSession method. Please see the AddSession method for more information. For information about the available session\nproperties, please refer to the documentation of the SISession class.</p>\n", "annotation": ": smartinspectpython.sisessiondefaults.SISessionDefaults"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.AddSession", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.AddSession", "kind": "function", "doc": "<p>Adds and returns a new SISession instance with this SmartInspect\nobject set as parent and optionally saves it for later access.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sessionName (str):</strong>  The name for the new session. Not allowed to be null.</li>\n<li><strong>store (bool):</strong>  Indicates if the newly created session should be stored \nfor later access.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new SISession instance or null if the supplied sessionName\n  parameter is null.</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  Thrown if sessionName is null or empty string.</li>\n</ul>\n\n<p>This method allocates a new session with this SmartInspect \ninstance set as parent and the supplied sessionName parameter\nset as session name. The returned session will be configured \nwith the default session properties as specified by the\nSessionDefaults property. This default configuration can be \noverridden on a per-session basis by loading the session\nconfiguration with the LoadConfiguration method. Please see \nthe LoadConfiguration documentation for details.</p>\n\n<p>If the 'store' parameter is true, the created and returned \nsession is stored for later access and can be retrieved with\nthe GetSession method. To remove a created session from the \ninternal list, call the DeleteSession method. </p>\n\n<p>If this method is called multiple times with the same session \nname, then the GetSession method operates on the session which\ngot added last. If the sessionName parameter is null, this method \ndoes nothing and returns null as well.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sessionName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">store</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.AddSessionObject", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.AddSessionObject", "kind": "function", "doc": "<p>Adds an existing session instance to the internal\nlist of sessions and saves it for later access.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  The session to store.</li>\n</ul>\n\n<p>This method adds the passed session to the internal list of\nsessions and saves it for later access. The passed session\nwill be configured with the default session properties as\nspecified by the SessionDefaults property. This default\nconfiguration can be overridden on a per-session basis by\nloading the session configuration with the LoadConfiguration\nmethod. Please see the LoadConfiguration documentation for\ndetails.</p>\n\n<p>The passed session can later be retrieved with the GetSession\nmethod. To remove an added session from the internal list,\ncall the DeleteSession method.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.DeleteSession", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.DeleteSession", "kind": "function", "doc": "<p>Removes a session from the internal list of sessions.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>session (SISession):</strong>  The session to remove from the lookup table of sessions.</li>\n</ul>\n\n<p>This method removes a session which has previously been added\nwith and returned by the AddSession method. After this method\nreturns, the GetSession method returns null when called with\nthe same session name unless a different session with the same\nname has been added.</p>\n\n<p>This method does nothing if the supplied session argument is null.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">session</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.Dispatch", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.Dispatch", "kind": "function", "doc": "<p>Executes a custom protocol action of a connection.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>caption (str):</strong>  The identifier of the connection. Not allowed to be null.</li>\n<li><strong>action (int):</strong>  The action to execute by the requested connection.</li>\n<li><strong>state (object):</strong>  An optional object which encapsulates additional protocol\nspecific information about the custom action. Can be null.</li>\n</ul>\n\n<p>This method dispatches the action and state parameters to the \nconnection identified by the caption argument. If no\nsuitable connection can be found, the Error event is used. The Error\nevent is also used if an exception is thrown in\nthe custom protocol action.</p>\n\n<p>The SmartInspect Python3 library currently implements one custom \nprotocol action in SIMemoryProtocol. The SIMemoryProtocol class\nis used for writing log packets to memory. On request, it can \nwrite its internal queue of packets to a user-supplied\nstream or SIProtocol object with a custom protocol action.</p>\n\n<p>The request for executing the custom action and writing the \nqueue can be initiated with this Dispatch method. </p>\n\n<p>For more information about custom protocol actions, please refer \nto the SIProtocol.Dispatch method. Also have a look at the \nSIProtocol.IsValidOption method which explains how to set the caption \nof a connection.</p>\n\n<p>Please note that the custom protocol action is executed asynchronously\nif the requested connection operates in SIProtocol.IsValidOption</p>\n\n<p>If the supplied caption argument is null, this method does nothing and \nreturns immediately.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">caption</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">action</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">state</span><span class=\"p\">:</span> <span class=\"nb\">object</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.Dispose", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.Dispose", "kind": "function", "doc": "<p>Releases all resources of this SmartInspect object.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li>disposing\nTrue to dispose of both managed and unmanaged resources.</li>\n</ul>\n\n<p>This method disconnects and removes all internal connections\nand disables this instance. Moreover, all previously stored\nsessions will be removed.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">disposing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.GetSession", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.GetSession", "kind": "function", "doc": "<p>Returns a previously added session.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sessionName (str):</strong>  The name of the session to lookup and return. \nNot allowed to be null.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>SIArgumentNullException:</strong>  Thrown if sessionName is null.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The requested session or null if the supplied sessionName is unknown.</p>\n</blockquote>\n\n<p>This method returns a session which has previously been\nadded with the AddSession method and can be identified by\nthe supplied sessionName argument. If the requested session\nis unknown then this method returns null.</p>\n\n<p>Note that the behavior of this method can be unexpected in\nterms of the result value if multiple sessions with the same\nname have been added. In this case, this method returns the\nsession which got added last and not necessarily the session\nwhich you expect. </p>\n\n<p>Adding multiple sessions with the same name should therefore\nbe avoided.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sessionName</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sisession</span><span class=\"o\">.</span><span class=\"n\">SISession</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.GetVariable", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.GetVariable", "kind": "function", "doc": "<p>Returns the value of a connection variable.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>key (str):</strong>  The key of the connection variable.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The value for the given connection variable or null if the\n  connection variable is unknown.</p>\n</blockquote>\n\n<p>Please see the SetVariable method for more information\nabout connection variables.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.LoadConfiguration", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.LoadConfiguration", "kind": "function", "doc": "<p>Loads the properties and sessions of this SmartInspect instance\nfrom a configuration file.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>fileName (str):</strong>  The name of the file to load the configuration from.</li>\n</ul>\n\n<p>This method loads the properties and sessions of this SmartInspect object from a file. This file should be a plain\ntext file containing key/value pairs. Each key/value pair is expected to be on its own line. Empty, unrecognized lines and\nlines beginning with a ';' character are ignored.</p>\n\n<p>The Error event is used to notify the caller if an error occurs while trying to load the configuration from the\nspecified file. Such errors include I/O errors like trying to open a file which does not exist, for example.</p>\n\n<p>The Error event is also used if the specified configuration file contains an invalid connections string. In this case, an\ninstance of the SIInvalidConnectionsException exception type is passed to the Error event.</p>\n\n<p>Calling this method with the fileName parameter set to null has no effect.</p>\n\n<p>This method is useful for loading the properties and sessions of this SmartInspect instance after the deployment of an\napplication. A typical use case for this method is the following scenario: imagine a customer who needs to send a log file to\ncustomer service to analyze a software problem. If the software in question uses this LoadConfiguration method, the customer\nservice just needs to send a prepared configuration file to the customer. Now, to load the SmartInspect properties from a\nfile, the customer now just needs to drop this file to the application's installation directory or any other predefined location.</p>\n\n<p>To monitor a SmartInspect configuration file for changes, please have a look at the SIConfigurationTimer class.</p>\n\n<p>To automatically replace placeholders in a loaded connections string, you can use so called connection variables. Please\nhave a look at the SetVariable method for more information.</p>\n\n<p>The following table lists the recognized configuration values, the corresponding SmartInspect properties and their types:</p>\n\n<table>\n<thead>\n<tr>\n  <th>Value</th>\n  <th>Property (Type)</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>appname</td>\n  <td>AppName (string)</td>\n</tr>\n<tr>\n  <td>connections</td>\n  <td>Connections (string)</td>\n</tr>\n<tr>\n  <td>defaultlevel</td>\n  <td>DefaultLevel (SILevel)</td>\n</tr>\n<tr>\n  <td>enabled</td>\n  <td>Enabled (bool)</td>\n</tr>\n<tr>\n  <td>level</td>\n  <td>Level (SILevel)</td>\n</tr>\n</tbody>\n</table>\n\n<p>In addition to these properties, this method also configures any stored sessions of this SmartInspect object. Sessions that\nhave been stored or will be added with the AddSession method will be configured with the properties of the related session\nentry of the passed configuration file. Please see the example section for details on how sessions entries look like.</p>\n\n<p>If no entries can be found in the configuration file for a newly added session, this session will use the default session\nproperties. The default session properties can also be specified in the configuration file. Please note that the\nsession defaults do not apply to the main session SIAuto.Main since this session has already been added before a\nconfiguration file can be loaded. The session defaults only apply to newly added sessions and do not affect existing sessions.</p>\n\n<p>The case of the configuration properties doesn't matter. This means, it makes no difference if you specify 'defaultlevel'\nor 'DefaultLevel' as key, for example.</p>\n\n<p>For a typical configuration file, please see the example below.</p>\n\n<p>To support Unicode strings, both the LoadConnections and LoadConfiguration methods are capable of auto-detecting the\nstring encoding if a BOM (Byte Order Mark) is given at the start of the file. The following table lists the supported\nencodings and the corresponding BOM identifiers.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Encoding</th>\n  <th>BOM identifier</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>UTF8</td>\n  <td>0xEF, 0xBB, 0xBF</td>\n</tr>\n<tr>\n  <td>Unicode</td>\n  <td>0xFF, 0xFE</td>\n</tr>\n<tr>\n  <td>Unicode big-endian</td>\n  <td>0xFE, 0xFF</td>\n</tr>\n</tbody>\n</table>\n\n<p>If no BOM is given, the text is assumed to be in the ASCII format. If the configuration file has been created or edited\nwith the SmartInspect Configuration Builder, the file always has a UTF8 Byte Order Mark and Unicode strings are therefore\nhandled automatically.</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"c1\"># load SmartInspect settings from a configuration settings file.</span>\n<span class=\"n\">siConfigPath</span><span class=\"p\">:</span><span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;./smartinspect.cfg&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">LoadConfiguration</span><span class=\"p\">(</span><span class=\"n\">siConfigPath</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># start monitoring the configuration file for changes, and reload it when it changes.</span>\n<span class=\"c1\"># this will check the file for changes every 60 seconds.</span>\n<span class=\"n\">siConfigTask</span><span class=\"p\">:</span><span class=\"n\">SIConfigurationTimer</span> <span class=\"o\">=</span> <span class=\"n\">SIConfigurationTimer</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">,</span> <span class=\"n\">siConfigPath</span><span class=\"p\">,</span> <span class=\"mi\">60</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n</code></pre>\n</div>\n\n<p><br/>\nThe following is the configuration settings file contents:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\">; smartinspect.cfg</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration General settings.</span>\n<span class=\"c1\">; - &quot;Enabled&quot; parameter to turn logging on (True) or off (False).</span>\n<span class=\"c1\">; - &quot;Level&quot; parameter to control the logging level (Debug|Verbose|Message|Warning|Error).</span>\n<span class=\"c1\">; - &quot;AppName&quot; parameter to control the application name.</span>\n<span class=\"na\">Enabled</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">False</span><span class=\"w\"> </span>\n<span class=\"na\">Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Verbose</span>\n<span class=\"na\">DefaultLevel</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Debug</span>\n<span class=\"na\">AppName</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">My Application Name</span>\n\n<span class=\"c1\">; SmartInspect Logging Configuration Output settings.</span>\n<span class=\"c1\">; - Log to SmartInspect Console Viewer running on the specified network address.</span>\n<span class=\"na\">Connections</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">tcp(host=localhost, port=4228, timeout=5000, reconnect=true, reconnect.interval=10s, async.enabled=true)</span>\n<span class=\"c1\">; - Log to a file:</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfile.log\\&quot;, rotate=hourly, maxparts=24, append=true)&quot;</span>\n<span class=\"c1\">; - Log to an encrypted file:</span>\n<span class=\"c1\">;Connections = &quot;file(filename=\\&quot;./tests/logfiles/logfileEncrypted.sil\\&quot;, encrypt=true, key=&quot;&quot;1234567890123456&quot;&quot;, rotate=hourly, maxparts=14, append=true)&quot;</span>\n\n<span class=\"c1\">; set defaults for new sessions</span>\n<span class=\"c1\">; note that session defaults do not apply to the SIAuto.Main session, since</span>\n<span class=\"c1\">; this session was already added before a configuration file can be loaded. </span>\n<span class=\"c1\">; session defaults only apply to newly added sessions and do not affect existing sessions.</span>\n<span class=\"na\">SessionDefaults.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">SessionDefaults.Level</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">Message</span>\n<span class=\"na\">SessionDefaults.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n\n<span class=\"c1\">; configure some individual session properties.</span>\n<span class=\"c1\">; note that this does not add the session to the sessionmanager; it simply</span>\n<span class=\"c1\">; sets the property values IF the session name already exists.</span>\n<span class=\"na\">Session.Main.Active</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">True</span>\n<span class=\"na\">Session.Main.ColorBG</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"s\">0xFFFFFF</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.LoadConnections", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.LoadConnections", "kind": "function", "doc": "<p>Loads the connections string from a file and enables this SmartInspect instance.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>fileName (str):</strong>  The name of the file to load the connections string from.</li>\n<li><strong>doNotEnable (bool):</strong>  Specifies if this instance should not be enabled automatically.\nDefault value is True.</li>\n</ul>\n\n<p>This method loads the SmartInspect Connections from a file.  This file\nshould be a plain text file containing a line like in the following example:</p>\n\n<p>connections=file(filename=c:\\log.sil)</p>\n\n<p>Empty, unrecognized lines and lines beginning with a ';' character are ignored. This version of the method enables\nlogging automatically.</p>\n\n<p>The Error event is used to notify the application if the specified file cannot be opened or does not contain a\nconnection string.  The Connections and Enabled properties of this instance are not changed if such an error occurs.</p>\n\n<p>The Error event is also used if a connections string could be read but is found to be invalid. In this case, an instance of\nthe SIInvalidConnectionsException exception type is passed to the Error event.</p>\n\n<p>If this doNotEnable parameter is set to true, the Enabled property is not changed. Otherwise this SmartInspect\ninstance will be enabled. Calling this method with the fileName parameter set to null has no effect.</p>\n\n<p>This method is useful for customizing the connections string after the deployment of an application. A typical use case\nfor this method is the following scenario: imagine a customer who needs to send a log file to customer service to analyze\na software problem. If the software in question uses this LoadConnections method, the customer service just needs to send\na prepared connections file to the customer. To enable the logging, the customer now just needs to drop this file to the\napplication's installation directory or any other predefined location.</p>\n\n<p>See LoadConfiguration for a method which is not limited to loading the connections string, but is also capable of loading\nany other property of this object from a file.</p>\n\n<p>The LoadConnections and LoadConfiguration methods are both capable of detecting the string encoding of the connections\nand configuration files. Please see the LoadConfiguration method for details.</p>\n\n<p>To automatically replace placeholders in a loaded connections string, you can use so called connection variables. Please\nhave a look at the SetVariable method for more information.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">fileName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">doNotEnable</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.Now", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.Now", "kind": "function", "doc": "<p>Gets the current date and time.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The current date and time value via the \"datetime.now()\" module.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">datetime</span><span class=\"o\">.</span><span class=\"n\">datetime</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.OnControlCommandEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.OnControlCommandEvent", "kind": "function", "doc": "<p>Method that will handle the SmartInspect.ControlCommandEvent event.\nInheriting classes can override this method to handle the event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIControlCommandEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n\n<p>This event can be used if custom processing of ControlCommand\npackets is needed. The event handlers are always called in the\ncontext of the thread which causes the event.</p>\n\n<p>If you specified that one or more connections of this SmartInspect object\nshould operate in SIProtocol.IsValidOption, you need to protect the passed\npacket and its data by calling its SIPacket.Lock and SIPacket.Unlock methods\nbefore and after processing.</p>\n\n<p>IMPORTANT: Keep in mind that adding SmartInspect log statements to the event \nhandlers can cause a presumably undesired recursive behavior!</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">datetime</span> <span class=\"kn\">import</span> <span class=\"n\">datetime</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"k\">class</span> <span class=\"nc\">SIEventHandlerClass</span><span class=\"p\">:</span>\n<span class=\"w\">    </span><span class=\"sd\">&quot;&quot;&quot;</span>\n<span class=\"sd\">    Helper class for SmartInspect class testing.</span>\n<span class=\"sd\">    &quot;&quot;&quot;</span>\n\n    <span class=\"c1\"># static variables.</span>\n    <span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span><span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n    <span class=\"n\">ErrorCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">InfoCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCancelCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">WatchCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">LogEntryCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ProcessFlowCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ControlCommandCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">TotalCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">WireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># wire up events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">UnWireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># unwire events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ErrorEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIErrorEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">InfoEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIInfoEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">FilterEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIFilterEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"c1\"># ignore all warning level packets.</span>\n        <span class=\"c1\">#if (e.Packet.Level == SILevel.Warning):</span>\n        <span class=\"c1\">#    SIEventHandlerClass.FilterCancelCount = SIEventHandlerClass.FilterCancelCount + 1</span>\n        <span class=\"c1\">#    e.Cancel = True</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">WatchEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIWatchEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">LogEntryEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SILogEntryEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ProcessFlowEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIProcessFlowEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ControlCommandEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIControlCommandEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ResetCounters</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Resetting all SIEventHandlerClass counters to zero.&quot;</span><span class=\"p\">)</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCancelCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n\n    <span class=\"k\">def</span> <span class=\"nf\">PrintResults</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"nb\">str</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;SI Protocol Connections string used for this test:</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span> <span class=\"o\">+</span> <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">Connections</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;SI Event Handler Results:&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Watch Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # LogEntry Events       = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # ProcessFlow Events    = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # ControlCommand Events = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Total Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Error Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Info Events           = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Filter Events         = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Filter Cancel Events  = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCancelCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n\n\n<span class=\"c1\"># wire up smartinspect events.</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WireEvents</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=localhost,port=4228,timeout=30000)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># test some process flow methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">EnterProcess</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;My Process&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This message is in process My Process.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This warning is in process My Process.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LeaveProcess</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;My Process&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># test some logentry methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a debug message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogVerbose</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a verbose message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a warning message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a error message in RED.&quot;</span><span class=\"p\">,</span> <span class=\"n\">SIColors</span><span class=\"o\">.</span><span class=\"n\">Red</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message in RED.&quot;</span><span class=\"p\">,</span> <span class=\"n\">SIColors</span><span class=\"o\">.</span><span class=\"n\">Red</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># test some control command methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">ClearWatches</span><span class=\"p\">()</span>\n\n<span class=\"c1\"># test some watch methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;string_py&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;string1 value&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;int_py&quot;</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;float_py&quot;</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">(</span><span class=\"mf\">3.14159</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;datetime_py&quot;</span><span class=\"p\">,</span> <span class=\"n\">datetime</span><span class=\"p\">(</span><span class=\"mi\">2023</span><span class=\"p\">,</span><span class=\"mi\">5</span><span class=\"p\">,</span><span class=\"mi\">11</span><span class=\"p\">,</span><span class=\"mi\">12</span><span class=\"p\">,</span><span class=\"mi\">30</span><span class=\"p\">,</span><span class=\"mi\">10</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;bool_py&quot;</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;byte_py&quot;</span><span class=\"p\">,</span> <span class=\"mh\">0xff</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># print SI event counts, unwire events, and dispose of SmartInspect.</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">PrintResults</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">UnWireEvents</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Dispose</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sicontrolcommandeventargs</span><span class=\"o\">.</span><span class=\"n\">SIControlCommandEventArgs</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.OnErrorEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.OnErrorEvent", "kind": "function", "doc": "<p>Method that will handle the SmartInspect.ErrorEvent event.\nInheriting classes can override this method to handle the event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIErrorEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n\n<p>This event is fired when an error occurs. An error could be\na connection problem or wrong permissions when writing log\nfiles, for example. Instead of throwing exceptions, this event\nis used for error reporting in the SmartInspect Python3 library.</p>\n\n<p>The event handlers are always called in the context of the\nthread which caused the event. In SIProtocol.IsValidOption, this\nis not necessarily the thread that initiated the related call.</p>\n\n<p>IMPORTANT: Keep in mind that adding SmartInspect log statements to the event \nhandlers can cause a presumably undesired recursive behavior!</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">datetime</span> <span class=\"kn\">import</span> <span class=\"n\">datetime</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"k\">class</span> <span class=\"nc\">SIEventHandlerClass</span><span class=\"p\">:</span>\n<span class=\"w\">    </span><span class=\"sd\">&quot;&quot;&quot;</span>\n<span class=\"sd\">    Helper class for SmartInspect class testing.</span>\n<span class=\"sd\">    &quot;&quot;&quot;</span>\n\n    <span class=\"c1\"># static variables.</span>\n    <span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span><span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n    <span class=\"n\">ErrorCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">InfoCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCancelCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">WatchCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">LogEntryCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ProcessFlowCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ControlCommandCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">TotalCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">WireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># wire up events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">UnWireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># unwire events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ErrorEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIErrorEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">InfoEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIInfoEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">FilterEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIFilterEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"c1\"># ignore all warning level packets.</span>\n        <span class=\"c1\">#if (e.Packet.Level == SILevel.Warning):</span>\n        <span class=\"c1\">#    SIEventHandlerClass.FilterCancelCount = SIEventHandlerClass.FilterCancelCount + 1</span>\n        <span class=\"c1\">#    e.Cancel = True</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">WatchEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIWatchEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">LogEntryEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SILogEntryEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ProcessFlowEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIProcessFlowEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ControlCommandEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIControlCommandEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ResetCounters</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Resetting all SIEventHandlerClass counters to zero.&quot;</span><span class=\"p\">)</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCancelCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n\n    <span class=\"k\">def</span> <span class=\"nf\">PrintResults</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"nb\">str</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;SI Protocol Connections string used for this test:</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span> <span class=\"o\">+</span> <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">Connections</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;SI Event Handler Results:&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Watch Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # LogEntry Events       = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # ProcessFlow Events    = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # ControlCommand Events = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Total Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Error Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Info Events           = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Filter Events         = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Filter Cancel Events  = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCancelCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n\n\n<span class=\"c1\"># wire up smartinspect events.</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WireEvents</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=localhost,port=4228,timeout=30000)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># test some process flow methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">EnterProcess</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;My Process&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This message is in process My Process.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This warning is in process My Process.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LeaveProcess</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;My Process&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># test some logentry methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a debug message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogVerbose</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a verbose message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a warning message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a error message in RED.&quot;</span><span class=\"p\">,</span> <span class=\"n\">SIColors</span><span class=\"o\">.</span><span class=\"n\">Red</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message in RED.&quot;</span><span class=\"p\">,</span> <span class=\"n\">SIColors</span><span class=\"o\">.</span><span class=\"n\">Red</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># test some control command methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">ClearWatches</span><span class=\"p\">()</span>\n\n<span class=\"c1\"># test some watch methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;string_py&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;string1 value&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;int_py&quot;</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;float_py&quot;</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">(</span><span class=\"mf\">3.14159</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;datetime_py&quot;</span><span class=\"p\">,</span> <span class=\"n\">datetime</span><span class=\"p\">(</span><span class=\"mi\">2023</span><span class=\"p\">,</span><span class=\"mi\">5</span><span class=\"p\">,</span><span class=\"mi\">11</span><span class=\"p\">,</span><span class=\"mi\">12</span><span class=\"p\">,</span><span class=\"mi\">30</span><span class=\"p\">,</span><span class=\"mi\">10</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;bool_py&quot;</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;byte_py&quot;</span><span class=\"p\">,</span> <span class=\"mh\">0xff</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># print SI event counts, unwire events, and dispose of SmartInspect.</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">PrintResults</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">UnWireEvents</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Dispose</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sierroreventargs</span><span class=\"o\">.</span><span class=\"n\">SIErrorEventArgs</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.OnFilterEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.OnFilterEvent", "kind": "function", "doc": "<p>Method that will handle the SmartInspect.FilterEvent event.\nInheriting classes can override this method to handle the event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIFilterEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n\n<p>Occurs before a packet is processed, and offers the opportunity\nto filter out packets.</p>\n\n<p>This event can be used if filtering of certain packets is\nneeded. The event handlers are always called in the context\nof the thread which causes the event.</p>\n\n<p>IMPORTANT: Keep in mind that adding SmartInspect log statements to the event \nhandlers can cause a presumably undesired recursive behavior!</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">datetime</span> <span class=\"kn\">import</span> <span class=\"n\">datetime</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"k\">class</span> <span class=\"nc\">SIEventHandlerClass</span><span class=\"p\">:</span>\n<span class=\"w\">    </span><span class=\"sd\">&quot;&quot;&quot;</span>\n<span class=\"sd\">    Helper class for SmartInspect class testing.</span>\n<span class=\"sd\">    &quot;&quot;&quot;</span>\n\n    <span class=\"c1\"># static variables.</span>\n    <span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span><span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n    <span class=\"n\">ErrorCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">InfoCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCancelCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">WatchCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">LogEntryCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ProcessFlowCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ControlCommandCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">TotalCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">WireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># wire up events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">UnWireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># unwire events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ErrorEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIErrorEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">InfoEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIInfoEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">FilterEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIFilterEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"c1\"># ignore all warning level packets.</span>\n        <span class=\"c1\">#if (e.Packet.Level == SILevel.Warning):</span>\n        <span class=\"c1\">#    SIEventHandlerClass.FilterCancelCount = SIEventHandlerClass.FilterCancelCount + 1</span>\n        <span class=\"c1\">#    e.Cancel = True</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">WatchEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIWatchEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">LogEntryEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SILogEntryEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ProcessFlowEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIProcessFlowEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ControlCommandEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIControlCommandEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span>\n            <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ResetCounters</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Resetting all SIEventHandlerClass counters to zero.&quot;</span><span class=\"p\">)</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCancelCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n\n    <span class=\"k\">def</span> <span class=\"nf\">PrintResults</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"nb\">str</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;SI Protocol Connections string used for this test:</span><span class=\"se\">\\n</span><span class=\"s2\">&quot;</span> <span class=\"o\">+</span> <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">Connections</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;SI Event Handler Results:&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Watch Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # LogEntry Events       = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # ProcessFlow Events    = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # ControlCommand Events = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Total Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">TotalCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Error Events          = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Info Events           = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Filter Events         = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;- # Filter Cancel Events  = &quot;</span> <span class=\"o\">+</span> <span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterCancelCount</span><span class=\"p\">))</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;</span><span class=\"p\">)</span>\n\n\n<span class=\"c1\"># wire up smartinspect events.</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WireEvents</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># set smartinspect connections, and enable logging.</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Connections</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;tcp(host=localhost,port=4228,timeout=30000)&quot;</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Enabled</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n\n<span class=\"c1\"># get smartinspect logger reference.</span>\n<span class=\"n\">_logsi</span><span class=\"p\">:</span><span class=\"n\">SISession</span> <span class=\"o\">=</span> <span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Main</span>\n\n<span class=\"c1\"># test some process flow methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">EnterProcess</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;My Process&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This message is in process My Process.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This warning is in process My Process.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LeaveProcess</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;My Process&quot;</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># test some logentry methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogDebug</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a debug message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogVerbose</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a verbose message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogMessage</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogWarning</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a warning message.&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogError</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a error message in RED.&quot;</span><span class=\"p\">,</span> <span class=\"n\">SIColors</span><span class=\"o\">.</span><span class=\"n\">Red</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">LogFatal</span><span class=\"p\">(</span><span class=\"s2\">&quot;This is a fatal error message in RED.&quot;</span><span class=\"p\">,</span> <span class=\"n\">SIColors</span><span class=\"o\">.</span><span class=\"n\">Red</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># test some control command methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">ClearWatches</span><span class=\"p\">()</span>\n\n<span class=\"c1\"># test some watch methods.</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;string_py&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;string1 value&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;int_py&quot;</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;float_py&quot;</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">(</span><span class=\"mf\">3.14159</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;datetime_py&quot;</span><span class=\"p\">,</span> <span class=\"n\">datetime</span><span class=\"p\">(</span><span class=\"mi\">2023</span><span class=\"p\">,</span><span class=\"mi\">5</span><span class=\"p\">,</span><span class=\"mi\">11</span><span class=\"p\">,</span><span class=\"mi\">12</span><span class=\"p\">,</span><span class=\"mi\">30</span><span class=\"p\">,</span><span class=\"mi\">10</span><span class=\"p\">))</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;bool_py&quot;</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"n\">_logsi</span><span class=\"o\">.</span><span class=\"n\">Watch</span><span class=\"p\">(</span><span class=\"kc\">None</span><span class=\"p\">,</span><span class=\"s2\">&quot;byte_py&quot;</span><span class=\"p\">,</span> <span class=\"mh\">0xff</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># print SI event counts, unwire events, and dispose of SmartInspect.</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">PrintResults</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n<span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">UnWireEvents</span><span class=\"p\">(</span><span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"p\">)</span>\n<span class=\"n\">SIAuto</span><span class=\"o\">.</span><span class=\"n\">Si</span><span class=\"o\">.</span><span class=\"n\">Dispose</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p></details></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sender</span><span class=\"p\">:</span> <span class=\"nb\">object</span>,</span><span class=\"param\">\t<span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"n\">smartinspectpython</span><span class=\"o\">.</span><span class=\"n\">sifiltereventargs</span><span class=\"o\">.</span><span class=\"n\">SIFilterEventArgs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "smartinspectpython.smartinspect.SmartInspect.OnInfoEvent", "modulename": "smartinspectpython.smartinspect", "qualname": "SmartInspect.OnInfoEvent", "kind": "function", "doc": "<p>Method that will handle the SmartInspect.InfoEvent event.\nInheriting classes can override this method to handle the event.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sender (object):</strong>  The object which fired the event.</li>\n<li><strong>e (SIInfoEventArgs):</strong>  Arguments that contain detailed information related to the event.</li>\n</ul>\n\n<p>This event is fired when an informational event occurs. An informational\nevent could be the SI console server version, or a configuration\nsettings file change, etc.</p>\n\n<p>The event handlers are always called in the context of the\nthread which caused the event; this is not necessarily the thread \nthat initiated the related call.</p>\n\n<p>IMPORTANT: Keep in mind that adding SmartInspect log statements to the event \nhandlers can cause a presumably undesired recursive behavior!</p>\n\n<p><details>\n    <summary>Sample Code</summary></p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\"># package imports.</span>\n<span class=\"kn\">from</span> <span class=\"nn\">datetime</span> <span class=\"kn\">import</span> <span class=\"n\">datetime</span>\n<span class=\"kn\">from</span> <span class=\"nn\">smartinspectpython.siauto</span> <span class=\"kn\">import</span> <span class=\"o\">*</span>\n\n<span class=\"k\">class</span> <span class=\"nc\">SIEventHandlerClass</span><span class=\"p\">:</span>\n<span class=\"w\">    </span><span class=\"sd\">&quot;&quot;&quot;</span>\n<span class=\"sd\">    Helper class for SmartInspect class testing.</span>\n<span class=\"sd\">    &quot;&quot;&quot;</span>\n\n    <span class=\"c1\"># static variables.</span>\n    <span class=\"n\">WriteEventPacketsToConsole</span><span class=\"p\">:</span><span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>\n    <span class=\"n\">ErrorCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">InfoCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">FilterCancelCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">WatchCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">LogEntryCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ProcessFlowCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">ControlCommandCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">TotalCount</span><span class=\"p\">:</span><span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">WireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># wire up events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">+=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"nd\">@staticmethod</span>\n    <span class=\"k\">def</span> <span class=\"nf\">UnWireEvents</span><span class=\"p\">(</span><span class=\"n\">si</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># unwire events.</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">FilterEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">WatchEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">LogEntryEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ProcessFlowEvent</span>\n        <span class=\"n\">si</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span> <span class=\"o\">-=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ControlCommandEvent</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">ErrorEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIErrorEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">ErrorCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">InfoEvent</span><span class=\"p\">(</span><span class=\"n\">sender</span><span class=\"p\">:</span><span class=\"nb\">object</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span><span class=\"n\">SIInfoEventArgs</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;* SIEvent </span><span class=\"si\">{0}</span><span class=\"s2\">&quot;</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"p\">(</span><span class=\"nb\">str</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)))</span>\n        <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">=</span> <span class=\"n\">SIEventHandlerClass</span><span class=\"o\">.</span><span class=\"n\">InfoCount</span> <span class=\"o\">+</span> <span class=\"mi\">1</span>\n        <span class=\"k\">pass</span>\n\n\n    <span class=\"k\">def</span> <span class=\"nf\">FilterEvent</span><span class=\"p\">(</span><span class=\"n\">sender<