# pylint: disable=C0111,R0902,R0904,R0912,R0913,R0915,E1101
# Smartsheet Python SDK.
#
# Copyright 2018 Smartsheet.com, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from __future__ import absolute_import

from ..types import Number, String, json
from ..util import deserialize, serialize


class OAuthError:

    """Smartsheet OAuthError data model."""

    def __init__(self, props=None, base_obj=None):
        """Initialize the OAuthError model."""
        self._base = None
        if base_obj is not None:
            self._base = base_obj

        self.allowed_values = {
            "error": [
                "invalid_request",
                "invalid_client",
                "invalid_grant",
                "unauthorized_client",
                "unsupported_grant_type",
                "invalid_scope",
            ]
        }

        self._error = String(accept=self.allowed_values["error"])
        self._error_code = Number()
        self._error_description = String()

        if props:
            deserialize(self, props)

        # requests package Response object
        self.request_response = None

    @property
    def error(self):
        return self._error.value

    @error.setter
    def error(self, value):
        self._error.value = value

    @property
    def error_code(self):
        return self._error_code.value

    @error_code.setter
    def error_code(self, value):
        self._error_code.value = value

    @property
    def error_description(self):
        return self._error_description.value

    @error_description.setter
    def error_description(self, value):
        self._error_description.value = value

    def to_dict(self):
        return serialize(self)

    def to_json(self):
        return json.dumps(self.to_dict())

    def __str__(self):
        return self.to_json()
