# pylint: disable=C0111,R0902,R0904,R0912,R0913,R0915,E1101
# Smartsheet Python SDK.
#
# Copyright 2017 Smartsheet.com, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from __future__ import absolute_import

from ..types import Number, TypedList, json
from ..util import deserialize, serialize
from .image_url import ImageUrl


class ImageUrlMap:

    """Smartsheet ImageUrlMap data model."""

    def __init__(self, props=None, base_obj=None):
        """Initialize the ImageUrlMap model."""
        self._base = None
        if base_obj is not None:
            self._base = base_obj

        self._image_urls = TypedList(ImageUrl)
        self._url_expires_in_millis = Number()

        if props:
            deserialize(self, props)

        # requests package Response object
        self.request_response = None
        self.__initialized = True

    @property
    def image_urls(self):
        return self._image_urls

    @image_urls.setter
    def image_urls(self, value):
        self._image_urls.load(value)

    @property
    def url_expires_in_millis(self):
        return self._url_expires_in_millis.value

    @url_expires_in_millis.setter
    def url_expires_in_millis(self, value):
        self._url_expires_in_millis.value = value

    def to_dict(self):
        return serialize(self)

    def to_json(self):
        return json.dumps(self.to_dict())

    def __str__(self):
        return self.to_json()
