# snaptrade-python-sdk
Connect brokerage accounts to your app for live positions and trading

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonPriorClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

```sh
pip install snaptrade-python-sdk
```
(you may need to run `pip` with root permission: `sudo pip install snaptrade-python-sdk`)

Then import the package:
```python
import snaptrade_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import snaptrade_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import uuid
import snaptrade_client
from pprint import pprint
from snaptrade_client.api import api_status_api
from snaptrade_client.api import authentication_api
from snaptrade_client.api import account_information_api
from snaptrade_client.model.snap_trade_register_user_request_body import SnapTradeRegisterUserRequestBody

# 1) Initialize a client with your clientID and consumerKey.
configuration = snaptrade_client.Configuration(client_id="SDK-GEN",
                                               consumer_key="XLla46KKcmkkU49DzVCT8AhIiY76z6iZ7eimsygM8VMw0Vr0PY")

with snaptrade_client.ApiClient(configuration) as api_client:
    # 2) Check that the client is able to make a request to the API server.
    api_status_api_inst = api_status_api.APIStatusApi(api_client)
    api_response = api_status_api_inst.root_get()
    pprint(api_response)

    # 3) Create a new user on SnapTrade
    user_id = str(uuid.uuid4())
    authentication_api_inst = authentication_api.AuthenticationApi(api_client)
    register_response = authentication_api_inst.snap_trade_register_user_post(
        SnapTradeRegisterUserRequestBody(user_id=user_id))
    pprint(register_response)

    # Note: A user secret is only generated once. It's required to access
    # resources for certain endpoints.
    user_secret = register_response.user_secret

    # 4) Get a redirect URI. Users will need this to connect
    # their brokerage to the SnapTrade server.
    redirect_uri = authentication_api_inst.snap_trade_login_post(user_id, user_secret)

    # 5) Obtaining account holdings data
    account_information_api_inst = account_information_api.AccountInformationApi(api_client)
    holdings = account_information_api_inst.holdings_get(user_id, user_secret)
    pprint(holdings)

    # 6) Deleting a user
    deleted_response = authentication_api_inst.snap_trade_delete_user_delete(user_id)
    pprint(deleted_response)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.snaptrade.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIDisclaimerApi* | [**snap_trade_accept_disclaimer_post**](docs/APIDisclaimerApi.md#snap_trade_accept_disclaimer_post) | **POST** /snapTrade/acceptDisclaimer | Accept or Reject SnapTrade disclaimer agreement
*APIStatusApi* | [**root_get**](docs/APIStatusApi.md#root_get) | **GET** / | Get API Status
*AccountInformationApi* | [**accounts_account_id_balances_get**](docs/AccountInformationApi.md#accounts_account_id_balances_get) | **GET** /accounts/{accountId}/balances | Get all cash balances of an investment account
*AccountInformationApi* | [**accounts_account_id_get**](docs/AccountInformationApi.md#accounts_account_id_get) | **GET** /accounts/{accountId} | Return details of a specific investment account
*AccountInformationApi* | [**accounts_account_id_holdings_get**](docs/AccountInformationApi.md#accounts_account_id_holdings_get) | **GET** /accounts/{accountId}/holdings | List balances, positions and orders for the specified account.
*AccountInformationApi* | [**accounts_account_id_positions_get**](docs/AccountInformationApi.md#accounts_account_id_positions_get) | **GET** /accounts/{accountId}/positions | Get all positions of an investment account
*AccountInformationApi* | [**accounts_account_id_put**](docs/AccountInformationApi.md#accounts_account_id_put) | **PUT** /accounts/{accountId} | Update details of an investment account
*AccountInformationApi* | [**accounts_get**](docs/AccountInformationApi.md#accounts_get) | **GET** /accounts | List all investment accounts for the user
*AccountInformationApi* | [**holdings_get**](docs/AccountInformationApi.md#holdings_get) | **GET** /holdings | List all accounts for the user, plus balances and positions for each account.
*AuthenticationApi* | [**snap_trade_delete_user_delete**](docs/AuthenticationApi.md#snap_trade_delete_user_delete) | **DELETE** /snapTrade/deleteUser | Delete user from SnapTrade, disabling all brokerage authorizations and permanently deleting all data associated with the user
*AuthenticationApi* | [**snap_trade_encrypted_jwt_get**](docs/AuthenticationApi.md#snap_trade_encrypted_jwt_get) | **GET** /snapTrade/encryptedJWT | Obtains an encrypted JWT tokens that should be decrypted on a user&#39;s local device
*AuthenticationApi* | [**snap_trade_list_users_get**](docs/AuthenticationApi.md#snap_trade_list_users_get) | **GET** /snapTrade/listUsers | Get a list of all SnapTrade users you&#39;ve registered on our platform
*AuthenticationApi* | [**snap_trade_login_post**](docs/AuthenticationApi.md#snap_trade_login_post) | **POST** /snapTrade/login | Generate a redirect URI to securely login a user to the SnapTrade Connection Portal
*AuthenticationApi* | [**snap_trade_register_user_post**](docs/AuthenticationApi.md#snap_trade_register_user_post) | **POST** /snapTrade/registerUser | Register user with SnapTrade in order to create secure brokerage authorizations
*ConnectionsApi* | [**authorizations_authorization_id_delete**](docs/ConnectionsApi.md#authorizations_authorization_id_delete) | **DELETE** /authorizations/{authorizationId} | Remove a brokerage authorization.
*ConnectionsApi* | [**authorizations_authorization_id_get**](docs/ConnectionsApi.md#authorizations_authorization_id_get) | **GET** /authorizations/{authorizationId} | Get detail of a specific brokerage authorizations for the user
*ConnectionsApi* | [**authorizations_get**](docs/ConnectionsApi.md#authorizations_get) | **GET** /authorizations | List all brokerage authorizations for the user
*ErrorLogsApi* | [**snap_trade_list_user_errors_get**](docs/ErrorLogsApi.md#snap_trade_list_user_errors_get) | **GET** /snapTrade/listUserErrors | Retrieve error logs on behalf of your SnapTrade users
*OptionsApi* | [**accounts_account_id_options_chain_get**](docs/OptionsApi.md#accounts_account_id_options_chain_get) | **GET** /accounts/{accountId}/options_chain | Get the options chain
*OptionsApi* | [**accounts_account_id_options_get**](docs/OptionsApi.md#accounts_account_id_options_get) | **GET** /accounts/{accountId}/options | Get the options holdings in the account
*OptionsApi* | [**accounts_account_id_options_search_get**](docs/OptionsApi.md#accounts_account_id_options_search_get) | **GET** /accounts/{accountId}/options_search | Search for more specific option quotes from option chain. Date is required but can filter by min, max or min-max.
*OptionsApi* | [**accounts_account_id_strategy_impact_post**](docs/OptionsApi.md#accounts_account_id_strategy_impact_post) | **POST** /accounts/{accountId}/strategy_impact | Get a strategies impact on the account
*OptionsApi* | [**accounts_account_id_strategy_place_post**](docs/OptionsApi.md#accounts_account_id_strategy_place_post) | **POST** /accounts/{accountId}/strategy_place | Place the strategy order; impact not required but the StrategyOrderQuotes object is
*OptionsApi* | [**accounts_account_id_strategy_quotes_post**](docs/OptionsApi.md#accounts_account_id_strategy_quotes_post) | **POST** /accounts/{accountId}/strategy_quotes | Get a price quote for a strategy
*PortfolioManagementApi* | [**model_asset_class_get**](docs/PortfolioManagementApi.md#model_asset_class_get) | **GET** /modelAssetClass | List of model asset class
*PortfolioManagementApi* | [**model_asset_class_model_asset_class_id_delete**](docs/PortfolioManagementApi.md#model_asset_class_model_asset_class_id_delete) | **DELETE** /modelAssetClass/{modelAssetClassId} | Deletes a model asset class
*PortfolioManagementApi* | [**model_asset_class_model_asset_class_id_get**](docs/PortfolioManagementApi.md#model_asset_class_model_asset_class_id_get) | **GET** /modelAssetClass/{modelAssetClassId} | Get details of a model asset class
*PortfolioManagementApi* | [**model_asset_class_model_asset_class_id_post**](docs/PortfolioManagementApi.md#model_asset_class_model_asset_class_id_post) | **POST** /modelAssetClass/{modelAssetClassId} | Updates model asset class objects
*PortfolioManagementApi* | [**model_asset_class_post**](docs/PortfolioManagementApi.md#model_asset_class_post) | **POST** /modelAssetClass | Create a new model asset class
*PortfolioManagementApi* | [**model_portfolio_get**](docs/PortfolioManagementApi.md#model_portfolio_get) | **GET** /modelPortfolio | List of model portfolio
*PortfolioManagementApi* | [**model_portfolio_model_portfolio_id_delete**](docs/PortfolioManagementApi.md#model_portfolio_model_portfolio_id_delete) | **DELETE** /modelPortfolio/{modelPortfolioId} | Deletes a model portfolio
*PortfolioManagementApi* | [**model_portfolio_model_portfolio_id_get**](docs/PortfolioManagementApi.md#model_portfolio_model_portfolio_id_get) | **GET** /modelPortfolio/{modelPortfolioId} | Get details of a model portfolio
*PortfolioManagementApi* | [**model_portfolio_model_portfolio_id_post**](docs/PortfolioManagementApi.md#model_portfolio_model_portfolio_id_post) | **POST** /modelPortfolio/{modelPortfolioId} | Updates model portfolio object
*PortfolioManagementApi* | [**model_portfolio_post**](docs/PortfolioManagementApi.md#model_portfolio_post) | **POST** /modelPortfolio | Creates a new model portfolio
*PortfolioManagementApi* | [**portfolio_groups_get**](docs/PortfolioManagementApi.md#portfolio_groups_get) | **GET** /portfolioGroups | List all portfolio groups
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_accounts_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_accounts_get) | **GET** /portfolioGroups/{portfolioGroupId}/accounts | Get all accounts associated with a portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_balances_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_balances_get) | **GET** /portfolioGroups/{portfolioGroupId}/balances | Get sum of cash balances in portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_get) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Return details of a specific trade before it&#39;s placed
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_patch**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_patch) | **PATCH** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Modify units of a trade before it is placed
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_trade_id_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_trade_id_get) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/{TradeId} | Return an individual trade
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_get) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades | List of trades to make to rebalance portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_delete**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_delete) | **DELETE** /portfolioGroups/{portfolioGroupId} | Remove a target portfolio.
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_excludedassets_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_excludedassets_get) | **GET** /portfolioGroups/{portfolioGroupId}/excludedassets | Get an array of excluded assets associated with a portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_excludedassets_post**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_excludedassets_post) | **POST** /portfolioGroups/{portfolioGroupId}/excludedassets | Adds an asset to exclude to a portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_excludedassets_symbol_id_delete**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_excludedassets_symbol_id_delete) | **DELETE** /portfolioGroups/{portfolioGroupId}/excludedassets/{symbolId} | Unexclude an asset from a portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_get) | **GET** /portfolioGroups/{portfolioGroupId} | Get details of a target portfolio
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_import_post**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_import_post) | **POST** /portfolioGroups/{portfolioGroupId}/import | Import target allocation based on portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_info_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_info_get) | **GET** /portfolioGroups/{portfolioGroupId}/info | Return a whole bunch of relevant information relating to a portfolio group.
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_patch**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_patch) | **PATCH** /portfolioGroups/{portfolioGroupId} | Update an existing target portfolio.
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_positions_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_positions_get) | **GET** /portfolioGroups/{portfolioGroupId}/positions | Get total of each postions owned in portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_settings_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_settings_get) | **GET** /portfolioGroups/{portfolioGroupId}/settings | Get portfolio group settings
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_settings_patch**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_settings_patch) | **PATCH** /portfolioGroups/{portfolioGroupId}/settings | Updates portfolio group settings
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_symbols_post**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_symbols_post) | **POST** /portfolioGroups/{portfolioGroupId}/symbols | Search for symbols limited to brokerages under the specified portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_targets_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_targets_get) | **GET** /portfolioGroups/{portfolioGroupId}/targets | Get all target assets under the specified PortfolioGroup.
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_targets_post**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_targets_post) | **POST** /portfolioGroups/{portfolioGroupId}/targets | Set a new list of target assets under the specified PortfolioGroup. All existing target assets under this portfolio group will be replaced with the new list.
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_targets_target_asset_id_delete**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_targets_target_asset_id_delete) | **DELETE** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Remove a TargetAsset.
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_targets_target_asset_id_get**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_targets_target_asset_id_get) | **GET** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Get a specific target from a portfolio group
*PortfolioManagementApi* | [**portfolio_groups_portfolio_group_id_targets_target_asset_id_patch**](docs/PortfolioManagementApi.md#portfolio_groups_portfolio_group_id_targets_target_asset_id_patch) | **PATCH** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Update a TargetAsset under the specified PortfolioGroup.
*PortfolioManagementApi* | [**portfolio_groups_post**](docs/PortfolioManagementApi.md#portfolio_groups_post) | **POST** /portfolioGroups | Create new portfolio group
*ReferenceDataApi* | [**accounts_account_id_symbols_post**](docs/ReferenceDataApi.md#accounts_account_id_symbols_post) | **POST** /accounts/{accountId}/symbols | Search for symbols that are supported by a brokerage account using a substring
*ReferenceDataApi* | [**brokerage_authorization_types_get**](docs/ReferenceDataApi.md#brokerage_authorization_types_get) | **GET** /brokerageAuthorizationTypes | List of all brokerage authorization types
*ReferenceDataApi* | [**brokerages_get**](docs/ReferenceDataApi.md#brokerages_get) | **GET** /brokerages | List of all brokerages.
*ReferenceDataApi* | [**currencies_get**](docs/ReferenceDataApi.md#currencies_get) | **GET** /currencies | List of all supported currencies
*ReferenceDataApi* | [**currencies_rates_currency_pair_get**](docs/ReferenceDataApi.md#currencies_rates_currency_pair_get) | **GET** /currencies/rates/{currencyPair} | Return the exchange rate of a currency pair
*ReferenceDataApi* | [**currencies_rates_get**](docs/ReferenceDataApi.md#currencies_rates_get) | **GET** /currencies/rates | Return the exchange rates of all supported currencies
*ReferenceDataApi* | [**exchanges_get**](docs/ReferenceDataApi.md#exchanges_get) | **GET** /exchanges | Return list of stock exchanges on Passiv and their suffixes
*ReferenceDataApi* | [**security_types_get**](docs/ReferenceDataApi.md#security_types_get) | **GET** /securityTypes | List of all security types.
*ReferenceDataApi* | [**snap_trade_partners_get**](docs/ReferenceDataApi.md#snap_trade_partners_get) | **GET** /snapTrade/partners | Get metadata related to Snaptrade partner
*ReferenceDataApi* | [**symbols_post**](docs/ReferenceDataApi.md#symbols_post) | **POST** /symbols | Search for symbols
*ReferenceDataApi* | [**symbols_symbol_id_get**](docs/ReferenceDataApi.md#symbols_symbol_id_get) | **GET** /symbols/{symbolId} | Get details of a symbol
*ReferenceDataApi* | [**symbols_ticker_get**](docs/ReferenceDataApi.md#symbols_ticker_get) | **GET** /symbols/{ticker} | Get details of a symbol by the ticker
*TradingApi* | [**accounts_account_id_orders_cancel_post**](docs/TradingApi.md#accounts_account_id_orders_cancel_post) | **POST** /accounts/{accountId}/orders/cancel | Cancel open order in account
*TradingApi* | [**accounts_account_id_orders_get**](docs/TradingApi.md#accounts_account_id_orders_get) | **GET** /accounts/{accountId}/orders | Get all history of orders placed in account
*TradingApi* | [**accounts_account_id_quotes_get**](docs/TradingApi.md#accounts_account_id_quotes_get) | **GET** /accounts/{accountId}/quotes | Get symbol quotes
*TradingApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_impact_get**](docs/TradingApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_impact_get) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/impact | Return the impact of placing a series of trades on the portfolio
*TradingApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_get**](docs/TradingApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_get) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Return details of a specific trade before it&#39;s placed
*TradingApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_patch**](docs/TradingApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_modify_trade_id_patch) | **PATCH** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Modify units of a trade before it is placed
*TradingApi* | [**portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_place_orders_post**](docs/TradingApi.md#portfolio_groups_portfolio_group_id_calculatedtrades_calculated_trade_id_place_orders_post) | **POST** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/placeOrders | Place orders for the CalculatedTrades in series
*TradingApi* | [**trade_impact_post**](docs/TradingApi.md#trade_impact_post) | **POST** /trade/impact | Check impact of trades on account.
*TradingApi* | [**trade_oco_post**](docs/TradingApi.md#trade_oco_post) | **POST** /trade/oco | Place a OCO (One Cancels Other) order
*TradingApi* | [**trade_trade_id_post**](docs/TradingApi.md#trade_trade_id_post) | **POST** /trade/{tradeId} | Place order
*TransactionsAndReportingApi* | [**activities_get**](docs/TransactionsAndReportingApi.md#activities_get) | **GET** /activities/ | Get transaction history for a user
*TransactionsAndReportingApi* | [**performance_custom_get**](docs/TransactionsAndReportingApi.md#performance_custom_get) | **GET** /performance/custom | Get performance information for a specific timeframe


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountHoldings](docs/AccountHoldings.md)
 - [AccountOrderRecord](docs/AccountOrderRecord.md)
 - [AccountOrderRecordStatus](docs/AccountOrderRecordStatus.md)
 - [AccountSimple](docs/AccountSimple.md)
 - [Action](docs/Action.md)
 - [Balance](docs/Balance.md)
 - [Brokerage](docs/Brokerage.md)
 - [BrokerageAuthorization](docs/BrokerageAuthorization.md)
 - [BrokerageAuthorizationType](docs/BrokerageAuthorizationType.md)
 - [BrokerageAuthorizationTypeReadOnly](docs/BrokerageAuthorizationTypeReadOnly.md)
 - [BrokerageAuthorizationTypeReadOnlyBrokerage](docs/BrokerageAuthorizationTypeReadOnlyBrokerage.md)
 - [BrokerageSymbol](docs/BrokerageSymbol.md)
 - [BrokerageType](docs/BrokerageType.md)
 - [CalculatedTrade](docs/CalculatedTrade.md)
 - [CashRestriction](docs/CashRestriction.md)
 - [Currency](docs/Currency.md)
 - [DeleteUserResponse](docs/DeleteUserResponse.md)
 - [DividendAtDate](docs/DividendAtDate.md)
 - [EncryptedResponse](docs/EncryptedResponse.md)
 - [EncryptedResponseEncryptedMessageData](docs/EncryptedResponseEncryptedMessageData.md)
 - [Exchange](docs/Exchange.md)
 - [ExchangeRatePairs](docs/ExchangeRatePairs.md)
 - [ExcludedAsset](docs/ExcludedAsset.md)
 - [JWT](docs/JWT.md)
 - [LoginRedirectURI](docs/LoginRedirectURI.md)
 - [ManualTrade](docs/ManualTrade.md)
 - [ManualTradeAndImpact](docs/ManualTradeAndImpact.md)
 - [ManualTradeBalance](docs/ManualTradeBalance.md)
 - [ManualTradeForm](docs/ManualTradeForm.md)
 - [ManualTradeSymbol](docs/ManualTradeSymbol.md)
 - [Model400FailedRequestResponse](docs/Model400FailedRequestResponse.md)
 - [Model401FailedRequestResponse](docs/Model401FailedRequestResponse.md)
 - [Model403FailedRequestResponse](docs/Model403FailedRequestResponse.md)
 - [Model404FailedRequestResponse](docs/Model404FailedRequestResponse.md)
 - [ModelAssetClass](docs/ModelAssetClass.md)
 - [ModelAssetClassDetails](docs/ModelAssetClassDetails.md)
 - [ModelAssetClassTarget](docs/ModelAssetClassTarget.md)
 - [ModelPortfolio](docs/ModelPortfolio.md)
 - [ModelPortfolioAssetClass](docs/ModelPortfolioAssetClass.md)
 - [ModelPortfolioDetails](docs/ModelPortfolioDetails.md)
 - [ModelPortfolioSecurity](docs/ModelPortfolioSecurity.md)
 - [MonthlyDividends](docs/MonthlyDividends.md)
 - [NetContributions](docs/NetContributions.md)
 - [NetDividend](docs/NetDividend.md)
 - [OptionChain](docs/OptionChain.md)
 - [OptionChainInner](docs/OptionChainInner.md)
 - [OptionChainInnerChainPerRootInner](docs/OptionChainInnerChainPerRootInner.md)
 - [OptionChainInnerChainPerRootInnerChainPerStrikePriceInner](docs/OptionChainInnerChainPerRootInnerChainPerStrikePriceInner.md)
 - [OptionsHoldings](docs/OptionsHoldings.md)
 - [OptionsSymbol](docs/OptionsSymbol.md)
 - [OrderType](docs/OrderType.md)
 - [PartnerData](docs/PartnerData.md)
 - [PastValue](docs/PastValue.md)
 - [Percent](docs/Percent.md)
 - [PerformanceCustom](docs/PerformanceCustom.md)
 - [PortfolioGroup](docs/PortfolioGroup.md)
 - [PortfolioGroupInfo](docs/PortfolioGroupInfo.md)
 - [PortfolioGroupPosition](docs/PortfolioGroupPosition.md)
 - [PortfolioGroupSettings](docs/PortfolioGroupSettings.md)
 - [Position](docs/Position.md)
 - [PositionSymbol](docs/PositionSymbol.md)
 - [RedirectTokenandPin](docs/RedirectTokenandPin.md)
 - [SecurityType](docs/SecurityType.md)
 - [SnapTradeAPIDisclaimerAcceptStatus](docs/SnapTradeAPIDisclaimerAcceptStatus.md)
 - [SnapTradeAcceptDisclaimerPostRequest](docs/SnapTradeAcceptDisclaimerPostRequest.md)
 - [SnapTradeHoldingsAccount](docs/SnapTradeHoldingsAccount.md)
 - [SnapTradeHoldingsTotalValue](docs/SnapTradeHoldingsTotalValue.md)
 - [SnapTradeLoginPost200Response](docs/SnapTradeLoginPost200Response.md)
 - [SnapTradeLoginUserRequestBody](docs/SnapTradeLoginUserRequestBody.md)
 - [SnapTradeRegisterUserRequestBody](docs/SnapTradeRegisterUserRequestBody.md)
 - [Status](docs/Status.md)
 - [StrategyImpact](docs/StrategyImpact.md)
 - [StrategyImpactLegsInner](docs/StrategyImpactLegsInner.md)
 - [StrategyOrderPlace](docs/StrategyOrderPlace.md)
 - [StrategyOrderPlaceOrdersInner](docs/StrategyOrderPlaceOrdersInner.md)
 - [StrategyOrderPlaceOrdersInnerLegsInner](docs/StrategyOrderPlaceOrdersInnerLegsInner.md)
 - [StrategyQuotes](docs/StrategyQuotes.md)
 - [StrategyQuotesInner](docs/StrategyQuotesInner.md)
 - [SubPeriodReturnRate](docs/SubPeriodReturnRate.md)
 - [Symbol](docs/Symbol.md)
 - [SymbolQuery](docs/SymbolQuery.md)
 - [SymbolsQuotes](docs/SymbolsQuotes.md)
 - [TargetAsset](docs/TargetAsset.md)
 - [TargetAssetList](docs/TargetAssetList.md)
 - [TimeInForce](docs/TimeInForce.md)
 - [Trade](docs/Trade.md)
 - [TradeExecutionStatus](docs/TradeExecutionStatus.md)
 - [TradeImpact](docs/TradeImpact.md)
 - [TradeOcoPostRequest](docs/TradeOcoPostRequest.md)
 - [USExchange](docs/USExchange.md)
 - [UnderlyingSymbol](docs/UnderlyingSymbol.md)
 - [UniversalActivity](docs/UniversalActivity.md)
 - [UniversalSymbol](docs/UniversalSymbol.md)
 - [UserErrorLog](docs/UserErrorLog.md)
 - [UserIDandSecret](docs/UserIDandSecret.md)
 - [UserList](docs/UserList.md)
 - [UserSettings](docs/UserSettings.md)


## Documentation For Authorization


## PartnerClientId

- **Type**: API key
- **API key parameter name**: clientId
- **Location**: URL query string


## PartnerSignature

- **Type**: API key
- **API key parameter name**: Signature
- **Location**: HTTP header


## PartnerTimestamp

- **Type**: API key
- **API key parameter name**: timestamp
- **Location**: URL query string


## Author

api@snaptrade.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in snaptrade_client.apis and snaptrade_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from snaptrade_client.api.default_api import DefaultApi`
- `from snaptrade_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import snaptrade_client
from snaptrade_client.apis import *
from snaptrade_client.models import *
```
