"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Generated by: https://konfigthis.com
"""


import re  # noqa: F401
import sys  # noqa: F401

from snaptrade_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from snaptrade_client.exceptions import ApiAttributeError


def lazy_import():
    from snaptrade_client.model.monthly_dividends import MonthlyDividends
    from snaptrade_client.model.net_contributions import NetContributions
    from snaptrade_client.model.net_dividend import NetDividend
    from snaptrade_client.model.past_value import PastValue
    from snaptrade_client.model.sub_period_return_rate import SubPeriodReturnRate
    globals()['MonthlyDividends'] = MonthlyDividends
    globals()['NetContributions'] = NetContributions
    globals()['NetDividend'] = NetDividend
    globals()['PastValue'] = PastValue
    globals()['SubPeriodReturnRate'] = SubPeriodReturnRate


class PerformanceCustom(ModelNormal):
    """NOTE: This class is auto generated by Konfig.
    Ref: https://konfigthis.com

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'total_equity_timeframe': ([PastValue],),  # noqa: E501
            'contributions': (NetContributions,),  # noqa: E501
            'contribution_timeframe': ([PastValue],),  # noqa: E501
            'contribution_timeframe_cumulative': ([PastValue],),  # noqa: E501
            'withdrawal_timeframe': ([PastValue],),  # noqa: E501
            'contribution_streak': (float,),  # noqa: E501
            'contribution_months_contributed': (float,),  # noqa: E501
            'contribution_total_months': (float,),  # noqa: E501
            'dividends': ([NetDividend],),  # noqa: E501
            'dividend_income': (float,),  # noqa: E501
            'monthly_dividends': (float,),  # noqa: E501
            'bad_tickers': ([str],),  # noqa: E501
            'dividend_timeline': ([MonthlyDividends],),  # noqa: E501
            'commissions': (float,),  # noqa: E501
            'forex_fees': (float,),  # noqa: E501
            'fees': (float,),  # noqa: E501
            'rate_of_return': (float,),  # noqa: E501
            'return_rate_timeframe': ([SubPeriodReturnRate],),  # noqa: E501
            'detailed_mode': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'total_equity_timeframe': 'totalEquityTimeframe',  # noqa: E501
        'contributions': 'contributions',  # noqa: E501
        'contribution_timeframe': 'contributionTimeframe',  # noqa: E501
        'contribution_timeframe_cumulative': 'contributionTimeframeCumulative',  # noqa: E501
        'withdrawal_timeframe': 'withdrawalTimeframe',  # noqa: E501
        'contribution_streak': 'contributionStreak',  # noqa: E501
        'contribution_months_contributed': 'contributionMonthsContributed',  # noqa: E501
        'contribution_total_months': 'contributionTotalMonths',  # noqa: E501
        'dividends': 'dividends',  # noqa: E501
        'dividend_income': 'dividendIncome',  # noqa: E501
        'monthly_dividends': 'monthlyDividends',  # noqa: E501
        'bad_tickers': 'badTickers',  # noqa: E501
        'dividend_timeline': 'dividendTimeline',  # noqa: E501
        'commissions': 'commissions',  # noqa: E501
        'forex_fees': 'forexFees',  # noqa: E501
        'fees': 'fees',  # noqa: E501
        'rate_of_return': 'rateOfReturn',  # noqa: E501
        'return_rate_timeframe': 'returnRateTimeframe',  # noqa: E501
        'detailed_mode': 'detailedMode',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """PerformanceCustom - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            total_equity_timeframe ([PastValue]): [optional]  # noqa: E501
            contributions (NetContributions): [optional]  # noqa: E501
            contribution_timeframe ([PastValue]): [optional]  # noqa: E501
            contribution_timeframe_cumulative ([PastValue]): [optional]  # noqa: E501
            withdrawal_timeframe ([PastValue]): [optional]  # noqa: E501
            contribution_streak (float): Current streak of cosecutive months where contributions were made. [optional]  # noqa: E501
            contribution_months_contributed (float): Number of months in the timeframe with contributions. [optional]  # noqa: E501
            contribution_total_months (float): Total months in timeframe. [optional]  # noqa: E501
            dividends ([NetDividend]): [optional]  # noqa: E501
            dividend_income (float): Total dividends received over the timeframe. [optional]  # noqa: E501
            monthly_dividends (float): Average dividends received per month over the timeframe. [optional]  # noqa: E501
            bad_tickers ([str]): list of tickers which may not be supported or may not have accurate price data. [optional]  # noqa: E501
            dividend_timeline ([MonthlyDividends]): [optional]  # noqa: E501
            commissions (float): commissions incurred during the timeframe. [optional]  # noqa: E501
            forex_fees (float): forex fees incurred during the timeframe. [optional]  # noqa: E501
            fees (float): other fees incurred during the timeframe. [optional]  # noqa: E501
            rate_of_return (float): The return rate over the timeframe. Annualized if timeframe is longer than 1 year. [optional]  # noqa: E501
            return_rate_timeframe ([SubPeriodReturnRate]): [optional]  # noqa: E501
            detailed_mode (bool): Whether the user has detailed mode enabled (more frequent data points for totalEquity and contribution timeframes). [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PerformanceCustom - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            total_equity_timeframe ([PastValue]): [optional]  # noqa: E501
            contributions (NetContributions): [optional]  # noqa: E501
            contribution_timeframe ([PastValue]): [optional]  # noqa: E501
            contribution_timeframe_cumulative ([PastValue]): [optional]  # noqa: E501
            withdrawal_timeframe ([PastValue]): [optional]  # noqa: E501
            contribution_streak (float): Current streak of cosecutive months where contributions were made. [optional]  # noqa: E501
            contribution_months_contributed (float): Number of months in the timeframe with contributions. [optional]  # noqa: E501
            contribution_total_months (float): Total months in timeframe. [optional]  # noqa: E501
            dividends ([NetDividend]): [optional]  # noqa: E501
            dividend_income (float): Total dividends received over the timeframe. [optional]  # noqa: E501
            monthly_dividends (float): Average dividends received per month over the timeframe. [optional]  # noqa: E501
            bad_tickers ([str]): list of tickers which may not be supported or may not have accurate price data. [optional]  # noqa: E501
            dividend_timeline ([MonthlyDividends]): [optional]  # noqa: E501
            commissions (float): commissions incurred during the timeframe. [optional]  # noqa: E501
            forex_fees (float): forex fees incurred during the timeframe. [optional]  # noqa: E501
            fees (float): other fees incurred during the timeframe. [optional]  # noqa: E501
            rate_of_return (float): The return rate over the timeframe. Annualized if timeframe is longer than 1 year. [optional]  # noqa: E501
            return_rate_timeframe ([SubPeriodReturnRate]): [optional]  # noqa: E501
            detailed_mode (bool): Whether the user has detailed mode enabled (more frequent data points for totalEquity and contribution timeframes). [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
