# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Generated by: https://konfigthis.com
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class Signature(
    schemas.StrBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneStrMixin
):
    """NOTE: This class is auto generated by Konfig.
    Ref: https://konfigthis.com

    Do not edit the class manually.

    Steps to generate a signature
  * Prepare signed content (see SignedContent schema)
  * Sign content prepared above with HMAC-SHA256 using the UTF-8 encoding
  * Return base64 encoding of sign content along with headers
 Note: Use the shared consumer key provided by Passiv to signed the request
Example python code
```
import hmac
import json
from base64 import b64encode
from hashlib import sha256
from urllib.parse import urlencode
consumer_key = "UxrFb4cHdRWlmJKNuJjA6hoaN8uVa6jPGFVUl2UKHuKmurCnaU".encode()
request_data = {'userId': 'snaptrade-user-123', 'userSecret': 'CHRIS.P.BACON'}
request_path = "/api/v1/snapTrade/mockSignature"
request_query = "clientId=PASSIVTEST&timestamp=1635790389"
sig_object = {"content": request_data, "path": request_path, "query": request_query}
sig_content = json.dumps(sig_object, separators=(",", ":"), sort_keys=True)
sig_digest = hmac.new(consumer_key, sig_content.encode(), sha256).digest()
signature = b64encode(sig_digest).decode()
```

    """


    def __new__(
        cls,
        *args: typing.Union[None, str, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'Signature':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )
