# coding: utf-8

"""
    Snowflake SQL API V2

    The Snowflake SQL API is a REST API that you can use to access and update data in a Snowflake database.   Contact Support:  Name: Snowflake, Inc.  Email: support@snowflake.com  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from snowflake_sql_api_client.api_client import ApiClient


class Apiv2statementsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_v2_statements_post(self, **kwargs):  # noqa: E501
        """Submits a SQL statement for execution.  # noqa: E501

        Submits a single statement for execution. You can specify that the statement should be executed asynchronously.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_v2_statements_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body:
        :param str user_agent: (Required) Set this to the name and version of your application (e.g. “applicationName/applicationVersion”). You must use a value that complies with RFC 7231.
        :param str x_snowflake_authorization_token_type: Specify the authorization token type for the Authorization header. KEYPAIR_JWT is for Keypair JWT or OAUTH for oAuth token. If not specified, OAUTH is assumed.
        :param str content_type:
        :param str accept:
        :param str request_id: Unique ID of the API request. This ensures that the execution is idempotent. If not specified, a new UUID is generated and assigned.
        :param str _async: Set to true to execute the statement asynchronously and return the statement handle. If the parameter is not specified or is set to false, a statement is executed and the first result is returned if the execution is completed in 45 seconds. If the statement execution takes longer to complete, the statement handle is returned.
        :param str nullable: Set to true to execute the statement to generate the result set including null. If the parameter is set to false, the result set value null will be replaced with a string 'null'.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_v2_statements_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_v2_statements_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_v2_statements_post_with_http_info(self, **kwargs):  # noqa: E501
        """Submits a SQL statement for execution.  # noqa: E501

        Submits a single statement for execution. You can specify that the statement should be executed asynchronously.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_v2_statements_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body:
        :param str user_agent: (Required) Set this to the name and version of your application (e.g. “applicationName/applicationVersion”). You must use a value that complies with RFC 7231.
        :param str x_snowflake_authorization_token_type: Specify the authorization token type for the Authorization header. KEYPAIR_JWT is for Keypair JWT or OAUTH for oAuth token. If not specified, OAUTH is assumed.
        :param str content_type:
        :param str accept:
        :param str request_id: Unique ID of the API request. This ensures that the execution is idempotent. If not specified, a new UUID is generated and assigned.
        :param str _async: Set to true to execute the statement asynchronously and return the statement handle. If the parameter is not specified or is set to false, a statement is executed and the first result is returned if the execution is completed in 45 seconds. If the statement execution takes longer to complete, the statement handle is returned.
        :param str nullable: Set to true to execute the statement to generate the result set including null. If the parameter is set to false, the result set value null will be replaced with a string 'null'.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'user_agent', 'x_snowflake_authorization_token_type', 'content_type', 'accept', 'request_id', '_async', 'nullable']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_v2_statements_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'request_id' in params:
            query_params.append(('requestId', params['request_id']))  # noqa: E501
        if '_async' in params:
            query_params.append(('async', params['_async']))  # noqa: E501
        if 'nullable' in params:
            query_params.append(('nullable', params['nullable']))  # noqa: E501

        header_params = {}
        if 'user_agent' in params:
            header_params['User-Agent'] = params['user_agent']  # noqa: E501
        if 'x_snowflake_authorization_token_type' in params:
            header_params['X-Snowflake-Authorization-Token-Type'] = params['x_snowflake_authorization_token_type']  # noqa: E501
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501
        if 'accept' in params:
            header_params['Accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/statements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
