# Generated by the protoc compiler with a custom plugin. DO NOT EDIT!
# sources: opentelemetry/proto/trace/v1/trace.proto
#
# Copyright (c) 2012-2024 Snowflake Inc. All rights reserved.
#
# Copyright 2019, OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# This file has been generated from the original proto schema at
#
#     https://github.com/open-telemetry/opentelemetry-proto
#
# using a custom protoc compiler plugin by Snowflake Inc.

from __future__ import annotations

import struct
from typing import List

from snowflake.telemetry._internal.opentelemetry.proto.common.v1.common_marshaler import *
from snowflake.telemetry._internal.opentelemetry.proto.resource.v1.resource_marshaler import *
from snowflake.telemetry._internal.serialize import (
    Enum,
    MessageMarshaler,
    Varint,
)


class SpanFlags(Enum):
    SPAN_FLAGS_DO_NOT_USE = 0
    SPAN_FLAGS_TRACE_FLAGS_MASK = 255
    SPAN_FLAGS_CONTEXT_HAS_IS_REMOTE_MASK = 256
    SPAN_FLAGS_CONTEXT_IS_REMOTE_MASK = 512


class TracesData(MessageMarshaler):
    @property
    def resource_spans(self) -> List[ResourceSpans]:
        if self._resource_spans is None:
            self._resource_spans = list()
        return self._resource_spans

    def __init__(
        self,
        resource_spans: List[ResourceSpans] = None,
    ):
        self._resource_spans: List[ResourceSpans] = resource_spans

    def calculate_size(self) -> int:
        size = 0
        if self._resource_spans:
            size += sum(
                message._get_size()
                + len(b"\n")
                + Varint.size_varint_u32(message._get_size())
                for message in self._resource_spans
            )
        return size

    def write_to(self, out: bytearray) -> None:
        if self._resource_spans:
            for v in self._resource_spans:
                out += b"\n"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)


class ResourceSpans(MessageMarshaler):
    @property
    def resource(self) -> Resource:
        if self._resource is None:
            self._resource = Resource()
        return self._resource

    @property
    def scope_spans(self) -> List[ScopeSpans]:
        if self._scope_spans is None:
            self._scope_spans = list()
        return self._scope_spans

    schema_url: str

    def __init__(
        self,
        resource: Resource = None,
        scope_spans: List[ScopeSpans] = None,
        schema_url: str = "",
    ):
        self._resource: Resource = resource
        self._scope_spans: List[ScopeSpans] = scope_spans
        self.schema_url: str = schema_url

    def calculate_size(self) -> int:
        size = 0
        if self._resource is not None:
            size += (
                len(b"\n")
                + Varint.size_varint_u32(self._resource._get_size())
                + self._resource._get_size()
            )
        if self._scope_spans:
            size += sum(
                message._get_size()
                + len(b"\x12")
                + Varint.size_varint_u32(message._get_size())
                for message in self._scope_spans
            )
        if self.schema_url:
            v = self.schema_url.encode("utf-8")
            size += len(b"\x1a") + Varint.size_varint_u32(len(v)) + len(v)
        return size

    def write_to(self, out: bytearray) -> None:
        if self._resource is not None:
            out += b"\n"
            Varint.write_varint_u32(out, self._resource._get_size())
            self._resource.write_to(out)
        if self._scope_spans:
            for v in self._scope_spans:
                out += b"\x12"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)
        if self.schema_url:
            v = self.schema_url.encode("utf-8")
            out += b"\x1a"
            Varint.write_varint_u32(out, len(v))
            out += v


class ScopeSpans(MessageMarshaler):
    @property
    def scope(self) -> InstrumentationScope:
        if self._scope is None:
            self._scope = InstrumentationScope()
        return self._scope

    @property
    def spans(self) -> List[Span]:
        if self._spans is None:
            self._spans = list()
        return self._spans

    schema_url: str

    def __init__(
        self,
        scope: InstrumentationScope = None,
        spans: List[Span] = None,
        schema_url: str = "",
    ):
        self._scope: InstrumentationScope = scope
        self._spans: List[Span] = spans
        self.schema_url: str = schema_url

    def calculate_size(self) -> int:
        size = 0
        if self._scope is not None:
            size += (
                len(b"\n")
                + Varint.size_varint_u32(self._scope._get_size())
                + self._scope._get_size()
            )
        if self._spans:
            size += sum(
                message._get_size()
                + len(b"\x12")
                + Varint.size_varint_u32(message._get_size())
                for message in self._spans
            )
        if self.schema_url:
            v = self.schema_url.encode("utf-8")
            size += len(b"\x1a") + Varint.size_varint_u32(len(v)) + len(v)
        return size

    def write_to(self, out: bytearray) -> None:
        if self._scope is not None:
            out += b"\n"
            Varint.write_varint_u32(out, self._scope._get_size())
            self._scope.write_to(out)
        if self._spans:
            for v in self._spans:
                out += b"\x12"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)
        if self.schema_url:
            v = self.schema_url.encode("utf-8")
            out += b"\x1a"
            Varint.write_varint_u32(out, len(v))
            out += v


class Span(MessageMarshaler):
    trace_id: bytes
    span_id: bytes
    trace_state: str
    parent_span_id: bytes
    name: str
    kind: Span.SpanKind
    start_time_unix_nano: int
    end_time_unix_nano: int

    @property
    def attributes(self) -> List[KeyValue]:
        if self._attributes is None:
            self._attributes = list()
        return self._attributes

    dropped_attributes_count: int

    @property
    def events(self) -> List[Span.Event]:
        if self._events is None:
            self._events = list()
        return self._events

    dropped_events_count: int

    @property
    def links(self) -> List[Span.Link]:
        if self._links is None:
            self._links = list()
        return self._links

    dropped_links_count: int

    @property
    def status(self) -> Status:
        if self._status is None:
            self._status = Status()
        return self._status

    flags: int

    def __init__(
        self,
        trace_id: bytes = b"",
        span_id: bytes = b"",
        trace_state: str = "",
        parent_span_id: bytes = b"",
        name: str = "",
        kind: Span.SpanKind = 0,
        start_time_unix_nano: int = 0,
        end_time_unix_nano: int = 0,
        attributes: List[KeyValue] = None,
        dropped_attributes_count: int = 0,
        events: List[Span.Event] = None,
        dropped_events_count: int = 0,
        links: List[Span.Link] = None,
        dropped_links_count: int = 0,
        status: Status = None,
        flags: int = 0,
    ):
        self.trace_id: bytes = trace_id
        self.span_id: bytes = span_id
        self.trace_state: str = trace_state
        self.parent_span_id: bytes = parent_span_id
        self.name: str = name
        self.kind: Span.SpanKind = kind
        self.start_time_unix_nano: int = start_time_unix_nano
        self.end_time_unix_nano: int = end_time_unix_nano
        self._attributes: List[KeyValue] = attributes
        self.dropped_attributes_count: int = dropped_attributes_count
        self._events: List[Span.Event] = events
        self.dropped_events_count: int = dropped_events_count
        self._links: List[Span.Link] = links
        self.dropped_links_count: int = dropped_links_count
        self._status: Status = status
        self.flags: int = flags

    def calculate_size(self) -> int:
        size = 0
        if self.trace_id:
            size += (
                len(b"\n")
                + Varint.size_varint_u32(len(self.trace_id))
                + len(self.trace_id)
            )
        if self.span_id:
            size += (
                len(b"\x12")
                + Varint.size_varint_u32(len(self.span_id))
                + len(self.span_id)
            )
        if self.trace_state:
            v = self.trace_state.encode("utf-8")
            size += len(b"\x1a") + Varint.size_varint_u32(len(v)) + len(v)
        if self.parent_span_id:
            size += (
                len(b'"')
                + Varint.size_varint_u32(len(self.parent_span_id))
                + len(self.parent_span_id)
            )
        if self.name:
            v = self.name.encode("utf-8")
            size += len(b"*") + Varint.size_varint_u32(len(v)) + len(v)
        if self.kind:
            v = self.kind
            if not isinstance(v, int):
                v = v.value
            size += len(b"0") + Varint.size_varint_u32(v)
        if self.start_time_unix_nano:
            size += len(b"9") + 8
        if self.end_time_unix_nano:
            size += len(b"A") + 8
        if self._attributes:
            size += sum(
                message._get_size()
                + len(b"J")
                + Varint.size_varint_u32(message._get_size())
                for message in self._attributes
            )
        if self.dropped_attributes_count:
            size += len(b"P") + Varint.size_varint_u32(self.dropped_attributes_count)
        if self._events:
            size += sum(
                message._get_size()
                + len(b"Z")
                + Varint.size_varint_u32(message._get_size())
                for message in self._events
            )
        if self.dropped_events_count:
            size += len(b"`") + Varint.size_varint_u32(self.dropped_events_count)
        if self._links:
            size += sum(
                message._get_size()
                + len(b"j")
                + Varint.size_varint_u32(message._get_size())
                for message in self._links
            )
        if self.dropped_links_count:
            size += len(b"p") + Varint.size_varint_u32(self.dropped_links_count)
        if self._status is not None:
            size += (
                len(b"z")
                + Varint.size_varint_u32(self._status._get_size())
                + self._status._get_size()
            )
        if self.flags:
            size += len(b"\x85\x01") + 4
        return size

    def write_to(self, out: bytearray) -> None:
        if self.trace_id:
            out += b"\n"
            Varint.write_varint_u32(out, len(self.trace_id))
            out += self.trace_id
        if self.span_id:
            out += b"\x12"
            Varint.write_varint_u32(out, len(self.span_id))
            out += self.span_id
        if self.trace_state:
            v = self.trace_state.encode("utf-8")
            out += b"\x1a"
            Varint.write_varint_u32(out, len(v))
            out += v
        if self.parent_span_id:
            out += b'"'
            Varint.write_varint_u32(out, len(self.parent_span_id))
            out += self.parent_span_id
        if self.name:
            v = self.name.encode("utf-8")
            out += b"*"
            Varint.write_varint_u32(out, len(v))
            out += v
        if self.kind:
            v = self.kind
            if not isinstance(v, int):
                v = v.value
            out += b"0"
            Varint.write_varint_u32(out, v)
        if self.start_time_unix_nano:
            out += b"9"
            out += struct.pack("<Q", self.start_time_unix_nano)
        if self.end_time_unix_nano:
            out += b"A"
            out += struct.pack("<Q", self.end_time_unix_nano)
        if self._attributes:
            for v in self._attributes:
                out += b"J"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)
        if self.dropped_attributes_count:
            out += b"P"
            Varint.write_varint_u32(out, self.dropped_attributes_count)
        if self._events:
            for v in self._events:
                out += b"Z"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)
        if self.dropped_events_count:
            out += b"`"
            Varint.write_varint_u32(out, self.dropped_events_count)
        if self._links:
            for v in self._links:
                out += b"j"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)
        if self.dropped_links_count:
            out += b"p"
            Varint.write_varint_u32(out, self.dropped_links_count)
        if self._status is not None:
            out += b"z"
            Varint.write_varint_u32(out, self._status._get_size())
            self._status.write_to(out)
        if self.flags:
            out += b"\x85\x01"
            out += struct.pack("<I", self.flags)

    class SpanKind(Enum):
        SPAN_KIND_UNSPECIFIED = 0
        SPAN_KIND_INTERNAL = 1
        SPAN_KIND_SERVER = 2
        SPAN_KIND_CLIENT = 3
        SPAN_KIND_PRODUCER = 4
        SPAN_KIND_CONSUMER = 5

    class Event(MessageMarshaler):
        time_unix_nano: int
        name: str

        @property
        def attributes(self) -> List[KeyValue]:
            if self._attributes is None:
                self._attributes = list()
            return self._attributes

        dropped_attributes_count: int

        def __init__(
            self,
            time_unix_nano: int = 0,
            name: str = "",
            attributes: List[KeyValue] = None,
            dropped_attributes_count: int = 0,
        ):
            self.time_unix_nano: int = time_unix_nano
            self.name: str = name
            self._attributes: List[KeyValue] = attributes
            self.dropped_attributes_count: int = dropped_attributes_count

        def calculate_size(self) -> int:
            size = 0
            if self.time_unix_nano:
                size += len(b"\t") + 8
            if self.name:
                v = self.name.encode("utf-8")
                size += len(b"\x12") + Varint.size_varint_u32(len(v)) + len(v)
            if self._attributes:
                size += sum(
                    message._get_size()
                    + len(b"\x1a")
                    + Varint.size_varint_u32(message._get_size())
                    for message in self._attributes
                )
            if self.dropped_attributes_count:
                size += len(b" ") + Varint.size_varint_u32(
                    self.dropped_attributes_count
                )
            return size

        def write_to(self, out: bytearray) -> None:
            if self.time_unix_nano:
                out += b"\t"
                out += struct.pack("<Q", self.time_unix_nano)
            if self.name:
                v = self.name.encode("utf-8")
                out += b"\x12"
                Varint.write_varint_u32(out, len(v))
                out += v
            if self._attributes:
                for v in self._attributes:
                    out += b"\x1a"
                    Varint.write_varint_u32(out, v._get_size())
                    v.write_to(out)
            if self.dropped_attributes_count:
                out += b" "
                Varint.write_varint_u32(out, self.dropped_attributes_count)

    class Link(MessageMarshaler):
        trace_id: bytes
        span_id: bytes
        trace_state: str

        @property
        def attributes(self) -> List[KeyValue]:
            if self._attributes is None:
                self._attributes = list()
            return self._attributes

        dropped_attributes_count: int
        flags: int

        def __init__(
            self,
            trace_id: bytes = b"",
            span_id: bytes = b"",
            trace_state: str = "",
            attributes: List[KeyValue] = None,
            dropped_attributes_count: int = 0,
            flags: int = 0,
        ):
            self.trace_id: bytes = trace_id
            self.span_id: bytes = span_id
            self.trace_state: str = trace_state
            self._attributes: List[KeyValue] = attributes
            self.dropped_attributes_count: int = dropped_attributes_count
            self.flags: int = flags

        def calculate_size(self) -> int:
            size = 0
            if self.trace_id:
                size += (
                    len(b"\n")
                    + Varint.size_varint_u32(len(self.trace_id))
                    + len(self.trace_id)
                )
            if self.span_id:
                size += (
                    len(b"\x12")
                    + Varint.size_varint_u32(len(self.span_id))
                    + len(self.span_id)
                )
            if self.trace_state:
                v = self.trace_state.encode("utf-8")
                size += len(b"\x1a") + Varint.size_varint_u32(len(v)) + len(v)
            if self._attributes:
                size += sum(
                    message._get_size()
                    + len(b'"')
                    + Varint.size_varint_u32(message._get_size())
                    for message in self._attributes
                )
            if self.dropped_attributes_count:
                size += len(b"(") + Varint.size_varint_u32(
                    self.dropped_attributes_count
                )
            if self.flags:
                size += len(b"5") + 4
            return size

        def write_to(self, out: bytearray) -> None:
            if self.trace_id:
                out += b"\n"
                Varint.write_varint_u32(out, len(self.trace_id))
                out += self.trace_id
            if self.span_id:
                out += b"\x12"
                Varint.write_varint_u32(out, len(self.span_id))
                out += self.span_id
            if self.trace_state:
                v = self.trace_state.encode("utf-8")
                out += b"\x1a"
                Varint.write_varint_u32(out, len(v))
                out += v
            if self._attributes:
                for v in self._attributes:
                    out += b'"'
                    Varint.write_varint_u32(out, v._get_size())
                    v.write_to(out)
            if self.dropped_attributes_count:
                out += b"("
                Varint.write_varint_u32(out, self.dropped_attributes_count)
            if self.flags:
                out += b"5"
                out += struct.pack("<I", self.flags)


class Status(MessageMarshaler):
    message: str
    code: Status.StatusCode

    def __init__(
        self,
        message: str = "",
        code: Status.StatusCode = 0,
    ):
        self.message: str = message
        self.code: Status.StatusCode = code

    def calculate_size(self) -> int:
        size = 0
        if self.message:
            v = self.message.encode("utf-8")
            size += len(b"\x12") + Varint.size_varint_u32(len(v)) + len(v)
        if self.code:
            v = self.code
            if not isinstance(v, int):
                v = v.value
            size += len(b"\x18") + Varint.size_varint_u32(v)
        return size

    def write_to(self, out: bytearray) -> None:
        if self.message:
            v = self.message.encode("utf-8")
            out += b"\x12"
            Varint.write_varint_u32(out, len(v))
            out += v
        if self.code:
            v = self.code
            if not isinstance(v, int):
                v = v.value
            out += b"\x18"
            Varint.write_varint_u32(out, v)

    class StatusCode(Enum):
        STATUS_CODE_UNSET = 0
        STATUS_CODE_OK = 1
        STATUS_CODE_ERROR = 2
