from dataclasses import dataclass


@dataclass(frozen=True)
class ActionsEnum:
    BALANCE_HISTORY: str = "balancehistory"
    BALANCE_MULTI: str = "balancemulti"
    BALANCE: str = "balance"
    CHAIN_SIZE: str = "chainsize"
    DAILY_AVG_BLOCK_SIZE: str = "dailyavgblocksize"
    DAILY_AVG_BLOCK_TIME: str = "dailyavgblocktime"
    DAILY_AVG_GAS_LIMIT: str = "dailyavggaslimit"
    DAILY_AVG_GAS_PRICE: str = "dailyavggasprice"
    DAILY_AVG_HASH_RATE: str = "dailyavghashrate"
    DAILY_AVG_NET_DIFFICULTY: str = "dailyavgnetdifficulty"
    DAILY_BLK_COUNT: str = "dailyblkcount"
    DAILY_BLOCK_REWARDS: str = "dailyblockrewards"
    DAILY_GAS_USED: str = "dailygasused"
    DAILY_NET_UTILIZATION: str = "dailynetutilization"
    DAILY_NEW_ADDRESS: str = "dailynewaddress"
    DAILY_TX: str = "dailytx"
    DAILY_TXN_FEE: str = "dailytxnfee"
    DAILY_UNCLE_BLK_COUNT: str = "dailyuncleblkcount"
    avax_BLOCK_NUMBER: str = "avax_blockNumber"
    avax_CALL: str = "avax_call"
    avax_DAILY_MARKET_CAP: str = "avaxdailymarketcap"
    avax_DAILY_PRICE: str = "avaxdailyprice"
    avax_ESTIMATE_GAS: str = "avax_estimateGas"
    avax_GAS_PRICE: str = "avax_gasPrice"
    avax_GET_BLOCK_BY_NUMBER: str = "avax_getBlockByNumber"
    avax_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER: str = (
        "avax_getBlockTransactionCountByNumber"
    )
    avax_GET_CODE: str = "avax_getCode"
    avax_GET_STORAGE_AT: str = "avax_getStorageAt"
    avax_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX: str = (
        "avax_getTransactionByBlockNumberAndIndex"
    )
    avax_GET_TRANSACTION_BY_HASH: str = "avax_getTransactionByHash"
    avax_GET_TRANSACTION_COUNT: str = "avax_getTransactionCount"
    avax_GET_TRANSACTION_RECEIPT: str = "avax_getTransactionReceipt"
    avax_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX: str = "avax_getUncleByBlockNumberAndIndex"
    avax_PRICE: str = "avaxprice"
    avax_SUPPLY: str = "avaxsupply"
    GAS_ESTIMATE: str = "gasestimate"
    GAS_ORACLE: str = "gasoracle"
    GET_ABI: str = "getabi"
    GET_BLOCK_COUNTDOWN: str = "getblockcountdown"
    GET_BLOCK_NUMBER_BY_TIME: str = "getblocknobytime"
    GET_BLOCK_REWARD: str = "getblockreward"
    GET_MINED_BLOCKS: str = "getminedblocks"
    GET_SOURCE_CODE: str = "getsourcecode"
    GET_STATUS: str = "getstatus"
    GET_TX_RECEIPT_STATUS: str = "gettxreceiptstatus"
    TOKEN_BALANCE_HISTORY: str = "tokenbalancehistory"
    TOKEN_BALANCE: str = "tokenbalance"
    TOKEN_INFO: str = "tokeninfo"
    TOKEN_SUPPLY_HISTORY: str = "tokensupplyhistory"
    TOKEN_SUPPLY: str = "tokensupply"
    TOKENNFTTX: str = "tokennfttx"
    TOKENTX: str = "tokentx"
    TXLIST_INTERNAL: str = "txlistinternal"
    TXLIST: str = "txlist"
