# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-07-16

### Added
- Initial release of SofizPay SDK for Python
- Payment operations using Stellar network
- DZT asset support with default issuer configuration
- Real-time transaction streaming and monitoring
- Balance checking for DZT and other assets
- Transaction history retrieval
- Transaction lookup by hash
- Comprehensive error handling and validation
- Async/await support for all operations
- Rate limiting for API calls
- Context manager support
- Extensive documentation and examples
- Full test suite with pytest

### Features
- **Payment Management**: Send DZT payments with memo support
- **Transaction Monitoring**: Real-time transaction streaming
- **Balance Checking**: Get DZT balances and all account assets
- **Transaction History**: Retrieve transaction records with filtering
- **Error Handling**: Comprehensive exception hierarchy
- **Validation**: Input validation for all operations
- **Rate Limiting**: Built-in rate limiting for API stability
- **Examples**: Complete examples for all major operations

### Technical Details
- Compatible with Python 3.8+
- Uses stellar-sdk 8.0+ for Stellar operations
- Async/await support throughout
- Comprehensive test coverage
- Type hints for better IDE support
- PEP 8 compliant code style

### Documentation
- Complete API documentation
- Usage examples in Arabic and English
- Installation and setup instructions
- Error handling guidelines
- Development setup guide
