import os
import sys

from .constants import DEFAULT_LOG_DIR


# 获取当前运行的可执行文件名（兼容 py/exe）
def get_exe_name():
    return os.path.basename(sys.executable if getattr(sys, 'frozen', False) else sys.argv[0])

# 获取当前运行程序对应的 lock 文件绝对路径
def get_lock_file():
    return os.path.splitext(os.path.abspath(sys.argv[0]))[0] + '.lock'


def get_project_root():
    """返回当前可执行文件所在目录，兼容 py/exe。"""
    return os.path.dirname(os.path.abspath(sys.argv[0]))


def get_log_dir():
    """返回当前可执行文件所在目录下 logs 目录路径。"""
    return os.path.join(get_project_root(), DEFAULT_LOG_DIR)
