# 主程序自动重启（兼容多平台）

import logging
import os
import shutil
import subprocess
import time

logger = logging.getLogger("SoIdea-update-python.process")

def restart_main_program(exe_path, args=None, wait=1):
    """
    自动重启主程序，支持参数传递。Windows/Linux/Mac均可用。
    """
    if not os.path.isfile(exe_path):
        logger.error(f"主程序文件不存在: {exe_path}")
        return False
    try:
        time.sleep(wait)
        cmd = [exe_path]
        if args:
            cmd.extend(args)
        import platform
        sys_platform = platform.system().lower()
        if sys_platform == "windows":
            # Windows: 新控制台窗口
            creationflags = subprocess.CREATE_NEW_CONSOLE
            subprocess.Popen(cmd, close_fds=True, creationflags=creationflags)
        elif sys_platform == "linux":
            # Linux: 优先用 x-terminal-emulator 或 xterm
            term_cmd = None
            for term in ["x-terminal-emulator", "xterm"]:
                if shutil.which(term):
                    term_cmd = [term, "-e"] + cmd
                    break
            if term_cmd:
                subprocess.Popen(term_cmd, close_fds=True)
            else:
                # 兜底：直接后台运行
                subprocess.Popen(cmd, close_fds=True)
        elif sys_platform == "darwin":
            # MacOS: 用 open -a Terminal
            if shutil.which("open"):
                subprocess.Popen(["open", "-a", "Terminal"] + cmd, close_fds=True)
            else:
                subprocess.Popen(cmd, close_fds=True)
        else:
            # 其他平台兜底
            subprocess.Popen(cmd, close_fds=True)
        logger.info(f"已重启主程序: {exe_path} {' '.join(args) if args else ''}")
        return True
    except Exception as e:
        logger.error(f"重启主程序失败: {e}")
        return False

