import os

from setuptools import find_packages, setup


def get_long_description():
    for fname in ["README.md", os.path.join("docs", "README.md")]:
        if os.path.exists(fname):
            with open(fname, encoding="utf-8") as f:
                return f.read()
    return ""

setup(
    name="SoIdea-update-python",
    version="0.1.2",
    description="本项目为跨平台自动升级脚本，支持命令行参数、GUI显示、配置文件、默认参数三层优先级，具备日志轮转、异常兜底、回滚、进程管理、hash 校验等生产级特性。",
    long_description=get_long_description(),
    long_description_content_type="text/markdown",
    author="Soidea",
    author_email="sogit@soidea.uu.me",
    url="https://github.com/Soidea",
    license="GPL-3.0",
    packages=find_packages(),
    install_requires=[
        "toml",
        "pyyaml",
        "requests",
        "tqdm",
        "packaging",
        "cryptography>=41.0.0",
        "psutil",
        "pyminizip"
    ],
    python_requires=">=3.7",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Operating System :: OS Independent",
    ],
    include_package_data=True,
)
