from unittest.mock import MagicMock
from solidfire.factory import ElementFactory
from solidfire.__init__ import *
import UnitTests.Resources as Resources

def test_cancel_clone_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_CancelClone_v9_0)

    
    clone_id = 42 # clone_id
    result = ef.cancel_clone(clone_id,)

def test_cancel_group_clone_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_CancelGroupClone_v9_0)

    
    group_clone_id = 42 # group_clone_id
    result = ef.cancel_group_clone(group_clone_id,)

def test_copy_volume_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_CopyVolume_v9_0)

    
    volume_id = 42 # volume_id
    dst_volume_id = 42 # dst_volume_id
    snapshot_id = 42 # snapshot_id
    result = ef.copy_volume(volume_id,dst_volume_id,)
    assert result.async_handle == 9, "Died on +.async_handle"
    assert result.clone_id == 5, "Died on +.clone_id"

def test_create_storage_container_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_CreateStorageContainer_v9_0)

    
    name = "" # name
    initiator_secret = "" # initiator_secret
    target_secret = "" # target_secret
    result = ef.create_storage_container(name,)
    assert result.storage_container.status == """active""", "Died on +.storage_container.status"
    assert result.storage_container.storage_container_id == UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e"), "Died on .storage_container.storage_container_id"
    assert result.storage_container.name == """ExampleName""", "Died on +.storage_container.name"
    assert result.storage_container.initiator_secret == """Z5k)Cf~jiIxp3R4[""", "Died on +.storage_container.initiator_secret"
    assert result.storage_container.target_secret == """N07S4}aEh5oU]L0l""", "Died on +.storage_container.target_secret"
    assert result.storage_container.protocol_endpoint_type == """SCSI""", "Died on +.storage_container.protocol_endpoint_type"
    assert result.storage_container.account_id == 111, "Died on +.storage_container.account_id"

def test_create_volume_access_group_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_CreateVolumeAccessGroup_v9_0)

    
    name = "" # name
    initiators = "" # initiators
    volumes = 42 # volumes
    virtual_network_id = 42 # virtual_network_id
    virtual_network_tags = 42 # virtual_network_tags
    attributes = dict() # attributes
    result = ef.create_volume_access_group(name,)
    assert result.volume_access_group.name == """myaccessgroup""", "Died on +.volume_access_group.name"
    assert result.volume_access_group.initiator_ids[0] == 95, "Died on +.volume_access_group.initiator_ids[0]"
    assert result.volume_access_group.volumes[0] == 327, "Died on +.volume_access_group.volumes[0]"
    assert result.volume_access_group.initiators[0] == """iqn.1993-08.org.debian: 01: a31b1d799d5c""", "Died on +.volume_access_group.initiators[0]"
    assert type(result.volume_access_group.attributes) is dict, "Died on .volume_access_group.attributes"
    assert result.volume_access_group.volume_access_group_id == 96, "Died on +.volume_access_group.volume_access_group_id"
    assert result.volume_access_group_id == 96, "Died on +.volume_access_group_id"

def test_delete_storage_containers_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_DeleteStorageContainers_v9_0)

    
    storage_container_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # storage_container_ids
    result = ef.delete_storage_containers(storage_container_ids,)

def test_delete_volumes_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_DeleteVolumes_v9_0)

    
    account_ids = 42 # account_ids
    volume_access_group_ids = 42 # volume_access_group_ids
    volume_ids = 42 # volume_ids
    result = ef.delete_volumes()
    assert result.volumes[0].status == """active""", "Died on +.volumes[0].status"
    assert result.volumes[0].enable512e == False, "Died on +.volumes[0].enable512e"
    assert result.volumes[0].scsi_naadevice_id == """6f47acc100000000707a737200000001""", "Died on +.volumes[0].scsi_naadevice_id"
    assert result.volumes[0].name == """vclient-030-v00001""", "Died on +.volumes[0].name"
    assert result.volumes[0].total_size == 10000003072, "Died on +.volumes[0].total_size"
    assert result.volumes[0].block_size == 4096, "Died on +.volumes[0].block_size"
    assert result.volumes[0].scsi_euidevice_id == """707a737200000001f47acc0100000000""", "Died on +.volumes[0].scsi_euidevice_id"
    assert result.volumes[0].iqn == """iqn.2010-01.com.solidfire:pzsr.vclient-030-v00001.1""", "Died on +.volumes[0].iqn"
    assert result.volumes[0].volume_id == 1, "Died on +.volumes[0].volume_id"
    assert result.volumes[0].access == """readWrite""", "Died on +.volumes[0].access"
    assert result.volumes[0].slice_count == 1, "Died on +.volumes[0].slice_count"
    assert type(result.volumes[0].attributes) is dict, "Died on .volumes[0].attributes"
    assert result.volumes[0].virtual_volume_id == UUID("b4528ea8-2930-41a0-8b8e-6361e1f0a71f"), "Died on .volumes[0].virtual_volume_id"
    assert result.volumes[0].create_time == """2015-03-06T18:50:56Z""", "Died on +.volumes[0].create_time"
    assert result.volumes[0].qos.burst_iops == 15000, "Died on +.volumes[0].qos.burst_iops"
    assert result.volumes[0].qos.min_iops == 100, "Died on +.volumes[0].qos.min_iops"
    assert result.volumes[0].qos.burst_time == 60, "Died on +.volumes[0].qos.burst_time"
    assert result.volumes[0].qos.max_iops == 15000, "Died on +.volumes[0].qos.max_iops"
    assert result.volumes[0].account_id == 1, "Died on +.volumes[0].account_id"

def test_enable_feature_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_EnableFeature_v9_0)

    
    feature = "" # feature
    result = ef.enable_feature(feature,)

def test_get_account_efficiency_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetAccountEfficiency_v9_0)

    
    account_id = 42 # account_id
    result = ef.get_account_efficiency(account_id,)
    assert result.timestamp == """2016-12-08T16:00:03Z""", "Died on +.timestamp"

def test_get_cluster_hardware_info_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetClusterHardwareInfo_v9_0)

    
    type = "" # type
    result = ef.get_cluster_hardware_info()

def test_get_drive_config_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetDriveConfig_v9_0)

    
    result = ef.get_drive_config()
    assert result.drive_config.num_slice_actual == 1, "Died on +.drive_config.num_slice_actual"
    assert result.drive_config.num_total_expected == 11, "Died on +.drive_config.num_total_expected"
    assert result.drive_config.num_slice_expected == 1, "Died on +.drive_config.num_slice_expected"
    assert result.drive_config.drives[14].security_locked == False, "Died on +.drive_config.drives[14].security_locked"
    assert result.drive_config.drives[14].serial == """slot10""", "Died on +.drive_config.drives[14].serial"
    assert result.drive_config.drives[14].size == 0, "Died on +.drive_config.drives[14].size"
    assert result.drive_config.drives[14].slot == 10, "Died on +.drive_config.drives[14].slot"
    assert result.drive_config.drives[14].uuid == UUID("9d62ad9e-a097-d5d6-d4f7-1d27193270a1"), "Died on .drive_config.drives[14].uuid"
    assert result.drive_config.drives[14].dev_path == """/dev/slot10""", "Died on +.drive_config.drives[14].dev_path"
    assert result.drive_config.drives[14].version == """Unknown""", "Died on +.drive_config.drives[14].version"
    assert result.drive_config.drives[14].security_supported == False, "Died on +.drive_config.drives[14].security_supported"
    assert result.drive_config.drives[14].drive_type == """Block""", "Died on +.drive_config.drives[14].drive_type"
    assert result.drive_config.drives[14].product == """Unknown""", "Died on +.drive_config.drives[14].product"
    assert result.drive_config.drives[14].vendor == """Unknown""", "Died on +.drive_config.drives[14].vendor"
    assert result.drive_config.drives[14].security_enabled == False, "Died on +.drive_config.drives[14].security_enabled"
    assert result.drive_config.drives[14].security_frozen == False, "Died on +.drive_config.drives[14].security_frozen"
    assert result.drive_config.drives[14].connected == False, "Died on +.drive_config.drives[14].connected"
    assert result.drive_config.drives[14].path == """/dev/slot10""", "Died on +.drive_config.drives[14].path"
    assert result.drive_config.drives[14].scsi_state == """Unknown""", "Died on +.drive_config.drives[14].scsi_state"
    assert result.drive_config.drives[14].scsi_compat_id == """slot10""", "Died on +.drive_config.drives[14].scsi_compat_id"
    assert result.drive_config.drives[14].name == """slot10""", "Died on +.drive_config.drives[14].name"
    assert result.drive_config.drives[14].dev == 0, "Died on +.drive_config.drives[14].dev"
    assert result.drive_config.drives[14].security_at_maximum == False, "Died on +.drive_config.drives[14].security_at_maximum"
    assert result.drive_config.drives[14].path_link == """/dev/slot10""", "Died on +.drive_config.drives[14].path_link"
    assert result.drive_config.drives[13].security_locked == False, "Died on +.drive_config.drives[13].security_locked"
    assert result.drive_config.drives[13].serial == """slot9""", "Died on +.drive_config.drives[13].serial"
    assert result.drive_config.drives[13].size == 0, "Died on +.drive_config.drives[13].size"
    assert result.drive_config.drives[13].slot == 9, "Died on +.drive_config.drives[13].slot"
    assert result.drive_config.drives[13].uuid == UUID("612e2106-7032-850a-a16d-4980b53ffb23"), "Died on .drive_config.drives[13].uuid"
    assert result.drive_config.drives[13].dev_path == """/dev/slot9""", "Died on +.drive_config.drives[13].dev_path"
    assert result.drive_config.drives[13].version == """Unknown""", "Died on +.drive_config.drives[13].version"
    assert result.drive_config.drives[13].security_supported == False, "Died on +.drive_config.drives[13].security_supported"
    assert result.drive_config.drives[13].drive_type == """Block""", "Died on +.drive_config.drives[13].drive_type"
    assert result.drive_config.drives[13].product == """Unknown""", "Died on +.drive_config.drives[13].product"
    assert result.drive_config.drives[13].vendor == """Unknown""", "Died on +.drive_config.drives[13].vendor"
    assert result.drive_config.drives[13].security_enabled == False, "Died on +.drive_config.drives[13].security_enabled"
    assert result.drive_config.drives[13].security_frozen == False, "Died on +.drive_config.drives[13].security_frozen"
    assert result.drive_config.drives[13].connected == False, "Died on +.drive_config.drives[13].connected"
    assert result.drive_config.drives[13].path == """/dev/slot9""", "Died on +.drive_config.drives[13].path"
    assert result.drive_config.drives[13].scsi_state == """Unknown""", "Died on +.drive_config.drives[13].scsi_state"
    assert result.drive_config.drives[13].scsi_compat_id == """slot9""", "Died on +.drive_config.drives[13].scsi_compat_id"
    assert result.drive_config.drives[13].name == """slot9""", "Died on +.drive_config.drives[13].name"
    assert result.drive_config.drives[13].dev == 0, "Died on +.drive_config.drives[13].dev"
    assert result.drive_config.drives[13].security_at_maximum == False, "Died on +.drive_config.drives[13].security_at_maximum"
    assert result.drive_config.drives[13].path_link == """/dev/slot9""", "Died on +.drive_config.drives[13].path_link"
    assert result.drive_config.drives[12].security_locked == False, "Died on +.drive_config.drives[12].security_locked"
    assert result.drive_config.drives[12].serial == """slot8""", "Died on +.drive_config.drives[12].serial"
    assert result.drive_config.drives[12].size == 0, "Died on +.drive_config.drives[12].size"
    assert result.drive_config.drives[12].slot == 8, "Died on +.drive_config.drives[12].slot"
    assert result.drive_config.drives[12].uuid == UUID("28384068-fdee-1dae-21e3-493558121657"), "Died on .drive_config.drives[12].uuid"
    assert result.drive_config.drives[12].dev_path == """/dev/slot8""", "Died on +.drive_config.drives[12].dev_path"
    assert result.drive_config.drives[12].version == """Unknown""", "Died on +.drive_config.drives[12].version"
    assert result.drive_config.drives[12].security_supported == False, "Died on +.drive_config.drives[12].security_supported"
    assert result.drive_config.drives[12].drive_type == """Block""", "Died on +.drive_config.drives[12].drive_type"
    assert result.drive_config.drives[12].product == """Unknown""", "Died on +.drive_config.drives[12].product"
    assert result.drive_config.drives[12].vendor == """Unknown""", "Died on +.drive_config.drives[12].vendor"
    assert result.drive_config.drives[12].security_enabled == False, "Died on +.drive_config.drives[12].security_enabled"
    assert result.drive_config.drives[12].security_frozen == False, "Died on +.drive_config.drives[12].security_frozen"
    assert result.drive_config.drives[12].connected == False, "Died on +.drive_config.drives[12].connected"
    assert result.drive_config.drives[12].path == """/dev/slot8""", "Died on +.drive_config.drives[12].path"
    assert result.drive_config.drives[12].scsi_state == """Unknown""", "Died on +.drive_config.drives[12].scsi_state"
    assert result.drive_config.drives[12].scsi_compat_id == """slot8""", "Died on +.drive_config.drives[12].scsi_compat_id"
    assert result.drive_config.drives[12].name == """slot8""", "Died on +.drive_config.drives[12].name"
    assert result.drive_config.drives[12].dev == 0, "Died on +.drive_config.drives[12].dev"
    assert result.drive_config.drives[12].security_at_maximum == False, "Died on +.drive_config.drives[12].security_at_maximum"
    assert result.drive_config.drives[12].path_link == """/dev/slot8""", "Died on +.drive_config.drives[12].path_link"
    assert result.drive_config.drives[11].security_locked == False, "Died on +.drive_config.drives[11].security_locked"
    assert result.drive_config.drives[11].serial == """slot7""", "Died on +.drive_config.drives[11].serial"
    assert result.drive_config.drives[11].size == 0, "Died on +.drive_config.drives[11].size"
    assert result.drive_config.drives[11].slot == 7, "Died on +.drive_config.drives[11].slot"
    assert result.drive_config.drives[11].uuid == UUID("76c29a96-68a6-2d8e-6416-392f9fd07919"), "Died on .drive_config.drives[11].uuid"
    assert result.drive_config.drives[11].dev_path == """/dev/slot7""", "Died on +.drive_config.drives[11].dev_path"
    assert result.drive_config.drives[11].version == """Unknown""", "Died on +.drive_config.drives[11].version"
    assert result.drive_config.drives[11].security_supported == False, "Died on +.drive_config.drives[11].security_supported"
    assert result.drive_config.drives[11].drive_type == """Block""", "Died on +.drive_config.drives[11].drive_type"
    assert result.drive_config.drives[11].product == """Unknown""", "Died on +.drive_config.drives[11].product"
    assert result.drive_config.drives[11].vendor == """Unknown""", "Died on +.drive_config.drives[11].vendor"
    assert result.drive_config.drives[11].security_enabled == False, "Died on +.drive_config.drives[11].security_enabled"
    assert result.drive_config.drives[11].security_frozen == False, "Died on +.drive_config.drives[11].security_frozen"
    assert result.drive_config.drives[11].connected == False, "Died on +.drive_config.drives[11].connected"
    assert result.drive_config.drives[11].path == """/dev/slot7""", "Died on +.drive_config.drives[11].path"
    assert result.drive_config.drives[11].scsi_state == """Unknown""", "Died on +.drive_config.drives[11].scsi_state"
    assert result.drive_config.drives[11].scsi_compat_id == """slot7""", "Died on +.drive_config.drives[11].scsi_compat_id"
    assert result.drive_config.drives[11].name == """slot7""", "Died on +.drive_config.drives[11].name"
    assert result.drive_config.drives[11].dev == 0, "Died on +.drive_config.drives[11].dev"
    assert result.drive_config.drives[11].security_at_maximum == False, "Died on +.drive_config.drives[11].security_at_maximum"
    assert result.drive_config.drives[11].path_link == """/dev/slot7""", "Died on +.drive_config.drives[11].path_link"
    assert result.drive_config.drives[10].security_locked == False, "Died on +.drive_config.drives[10].security_locked"
    assert result.drive_config.drives[10].serial == """slot6""", "Died on +.drive_config.drives[10].serial"
    assert result.drive_config.drives[10].size == 0, "Died on +.drive_config.drives[10].size"
    assert result.drive_config.drives[10].slot == 6, "Died on +.drive_config.drives[10].slot"
    assert result.drive_config.drives[10].uuid == UUID("c1b04a69-49a0-fdee-b818-c6cdfafd6cd5"), "Died on .drive_config.drives[10].uuid"
    assert result.drive_config.drives[10].dev_path == """/dev/slot6""", "Died on +.drive_config.drives[10].dev_path"
    assert result.drive_config.drives[10].version == """Unknown""", "Died on +.drive_config.drives[10].version"
    assert result.drive_config.drives[10].security_supported == False, "Died on +.drive_config.drives[10].security_supported"
    assert result.drive_config.drives[10].drive_type == """Block""", "Died on +.drive_config.drives[10].drive_type"
    assert result.drive_config.drives[10].product == """Unknown""", "Died on +.drive_config.drives[10].product"
    assert result.drive_config.drives[10].vendor == """Unknown""", "Died on +.drive_config.drives[10].vendor"
    assert result.drive_config.drives[10].security_enabled == False, "Died on +.drive_config.drives[10].security_enabled"
    assert result.drive_config.drives[10].security_frozen == False, "Died on +.drive_config.drives[10].security_frozen"
    assert result.drive_config.drives[10].connected == False, "Died on +.drive_config.drives[10].connected"
    assert result.drive_config.drives[10].path == """/dev/slot6""", "Died on +.drive_config.drives[10].path"
    assert result.drive_config.drives[10].scsi_state == """Unknown""", "Died on +.drive_config.drives[10].scsi_state"
    assert result.drive_config.drives[10].scsi_compat_id == """slot6""", "Died on +.drive_config.drives[10].scsi_compat_id"
    assert result.drive_config.drives[10].name == """slot6""", "Died on +.drive_config.drives[10].name"
    assert result.drive_config.drives[10].dev == 0, "Died on +.drive_config.drives[10].dev"
    assert result.drive_config.drives[10].security_at_maximum == False, "Died on +.drive_config.drives[10].security_at_maximum"
    assert result.drive_config.drives[10].path_link == """/dev/slot6""", "Died on +.drive_config.drives[10].path_link"
    assert result.drive_config.drives[9].security_locked == False, "Died on +.drive_config.drives[9].security_locked"
    assert result.drive_config.drives[9].serial == """slot5""", "Died on +.drive_config.drives[9].serial"
    assert result.drive_config.drives[9].size == 0, "Died on +.drive_config.drives[9].size"
    assert result.drive_config.drives[9].slot == 5, "Died on +.drive_config.drives[9].slot"
    assert result.drive_config.drives[9].uuid == UUID("b31123fa-9a17-0ccd-deab-deac32a58371"), "Died on .drive_config.drives[9].uuid"
    assert result.drive_config.drives[9].dev_path == """/dev/slot5""", "Died on +.drive_config.drives[9].dev_path"
    assert result.drive_config.drives[9].version == """Unknown""", "Died on +.drive_config.drives[9].version"
    assert result.drive_config.drives[9].security_supported == False, "Died on +.drive_config.drives[9].security_supported"
    assert result.drive_config.drives[9].drive_type == """Block""", "Died on +.drive_config.drives[9].drive_type"
    assert result.drive_config.drives[9].product == """Unknown""", "Died on +.drive_config.drives[9].product"
    assert result.drive_config.drives[9].vendor == """Unknown""", "Died on +.drive_config.drives[9].vendor"
    assert result.drive_config.drives[9].security_enabled == False, "Died on +.drive_config.drives[9].security_enabled"
    assert result.drive_config.drives[9].security_frozen == False, "Died on +.drive_config.drives[9].security_frozen"
    assert result.drive_config.drives[9].connected == False, "Died on +.drive_config.drives[9].connected"
    assert result.drive_config.drives[9].path == """/dev/slot5""", "Died on +.drive_config.drives[9].path"
    assert result.drive_config.drives[9].scsi_state == """Unknown""", "Died on +.drive_config.drives[9].scsi_state"
    assert result.drive_config.drives[9].scsi_compat_id == """slot5""", "Died on +.drive_config.drives[9].scsi_compat_id"
    assert result.drive_config.drives[9].name == """slot5""", "Died on +.drive_config.drives[9].name"
    assert result.drive_config.drives[9].dev == 0, "Died on +.drive_config.drives[9].dev"
    assert result.drive_config.drives[9].security_at_maximum == False, "Died on +.drive_config.drives[9].security_at_maximum"
    assert result.drive_config.drives[9].path_link == """/dev/slot5""", "Died on +.drive_config.drives[9].path_link"
    assert result.drive_config.drives[8].security_locked == False, "Died on +.drive_config.drives[8].security_locked"
    assert result.drive_config.drives[8].serial == """slot4""", "Died on +.drive_config.drives[8].serial"
    assert result.drive_config.drives[8].size == 0, "Died on +.drive_config.drives[8].size"
    assert result.drive_config.drives[8].slot == 4, "Died on +.drive_config.drives[8].slot"
    assert result.drive_config.drives[8].uuid == UUID("76e3d13f-88c5-c334-8f0b-8486964d369e"), "Died on .drive_config.drives[8].uuid"
    assert result.drive_config.drives[8].dev_path == """/dev/slot4""", "Died on +.drive_config.drives[8].dev_path"
    assert result.drive_config.drives[8].version == """Unknown""", "Died on +.drive_config.drives[8].version"
    assert result.drive_config.drives[8].security_supported == False, "Died on +.drive_config.drives[8].security_supported"
    assert result.drive_config.drives[8].drive_type == """Block""", "Died on +.drive_config.drives[8].drive_type"
    assert result.drive_config.drives[8].product == """Unknown""", "Died on +.drive_config.drives[8].product"
    assert result.drive_config.drives[8].vendor == """Unknown""", "Died on +.drive_config.drives[8].vendor"
    assert result.drive_config.drives[8].security_enabled == False, "Died on +.drive_config.drives[8].security_enabled"
    assert result.drive_config.drives[8].security_frozen == False, "Died on +.drive_config.drives[8].security_frozen"
    assert result.drive_config.drives[8].connected == False, "Died on +.drive_config.drives[8].connected"
    assert result.drive_config.drives[8].path == """/dev/slot4""", "Died on +.drive_config.drives[8].path"
    assert result.drive_config.drives[8].scsi_state == """Unknown""", "Died on +.drive_config.drives[8].scsi_state"
    assert result.drive_config.drives[8].scsi_compat_id == """slot4""", "Died on +.drive_config.drives[8].scsi_compat_id"
    assert result.drive_config.drives[8].name == """slot4""", "Died on +.drive_config.drives[8].name"
    assert result.drive_config.drives[8].dev == 0, "Died on +.drive_config.drives[8].dev"
    assert result.drive_config.drives[8].security_at_maximum == False, "Died on +.drive_config.drives[8].security_at_maximum"
    assert result.drive_config.drives[8].path_link == """/dev/slot4""", "Died on +.drive_config.drives[8].path_link"
    assert result.drive_config.drives[7].security_locked == False, "Died on +.drive_config.drives[7].security_locked"
    assert result.drive_config.drives[7].serial == """slot3""", "Died on +.drive_config.drives[7].serial"
    assert result.drive_config.drives[7].size == 0, "Died on +.drive_config.drives[7].size"
    assert result.drive_config.drives[7].slot == 3, "Died on +.drive_config.drives[7].slot"
    assert result.drive_config.drives[7].uuid == UUID("25b903d1-3b55-d53f-a556-47b28f91b728"), "Died on .drive_config.drives[7].uuid"
    assert result.drive_config.drives[7].dev_path == """/dev/slot3""", "Died on +.drive_config.drives[7].dev_path"
    assert result.drive_config.drives[7].version == """Unknown""", "Died on +.drive_config.drives[7].version"
    assert result.drive_config.drives[7].security_supported == False, "Died on +.drive_config.drives[7].security_supported"
    assert result.drive_config.drives[7].drive_type == """Block""", "Died on +.drive_config.drives[7].drive_type"
    assert result.drive_config.drives[7].product == """Unknown""", "Died on +.drive_config.drives[7].product"
    assert result.drive_config.drives[7].vendor == """Unknown""", "Died on +.drive_config.drives[7].vendor"
    assert result.drive_config.drives[7].security_enabled == False, "Died on +.drive_config.drives[7].security_enabled"
    assert result.drive_config.drives[7].security_frozen == False, "Died on +.drive_config.drives[7].security_frozen"
    assert result.drive_config.drives[7].connected == False, "Died on +.drive_config.drives[7].connected"
    assert result.drive_config.drives[7].path == """/dev/slot3""", "Died on +.drive_config.drives[7].path"
    assert result.drive_config.drives[7].scsi_state == """Unknown""", "Died on +.drive_config.drives[7].scsi_state"
    assert result.drive_config.drives[7].scsi_compat_id == """slot3""", "Died on +.drive_config.drives[7].scsi_compat_id"
    assert result.drive_config.drives[7].name == """slot3""", "Died on +.drive_config.drives[7].name"
    assert result.drive_config.drives[7].dev == 0, "Died on +.drive_config.drives[7].dev"
    assert result.drive_config.drives[7].security_at_maximum == False, "Died on +.drive_config.drives[7].security_at_maximum"
    assert result.drive_config.drives[7].path_link == """/dev/slot3""", "Died on +.drive_config.drives[7].path_link"
    assert result.drive_config.drives[6].security_locked == False, "Died on +.drive_config.drives[6].security_locked"
    assert result.drive_config.drives[6].serial == """slot2""", "Died on +.drive_config.drives[6].serial"
    assert result.drive_config.drives[6].size == 0, "Died on +.drive_config.drives[6].size"
    assert result.drive_config.drives[6].slot == 2, "Died on +.drive_config.drives[6].slot"
    assert result.drive_config.drives[6].uuid == UUID("d92f909d-c606-4c27-d17a-4cb6db95a35c"), "Died on .drive_config.drives[6].uuid"
    assert result.drive_config.drives[6].dev_path == """/dev/slot2""", "Died on +.drive_config.drives[6].dev_path"
    assert result.drive_config.drives[6].version == """Unknown""", "Died on +.drive_config.drives[6].version"
    assert result.drive_config.drives[6].security_supported == False, "Died on +.drive_config.drives[6].security_supported"
    assert result.drive_config.drives[6].drive_type == """Block""", "Died on +.drive_config.drives[6].drive_type"
    assert result.drive_config.drives[6].product == """Unknown""", "Died on +.drive_config.drives[6].product"
    assert result.drive_config.drives[6].vendor == """Unknown""", "Died on +.drive_config.drives[6].vendor"
    assert result.drive_config.drives[6].security_enabled == False, "Died on +.drive_config.drives[6].security_enabled"
    assert result.drive_config.drives[6].security_frozen == False, "Died on +.drive_config.drives[6].security_frozen"
    assert result.drive_config.drives[6].connected == False, "Died on +.drive_config.drives[6].connected"
    assert result.drive_config.drives[6].path == """/dev/slot2""", "Died on +.drive_config.drives[6].path"
    assert result.drive_config.drives[6].scsi_state == """Unknown""", "Died on +.drive_config.drives[6].scsi_state"
    assert result.drive_config.drives[6].scsi_compat_id == """slot2""", "Died on +.drive_config.drives[6].scsi_compat_id"
    assert result.drive_config.drives[6].name == """slot2""", "Died on +.drive_config.drives[6].name"
    assert result.drive_config.drives[6].dev == 0, "Died on +.drive_config.drives[6].dev"
    assert result.drive_config.drives[6].security_at_maximum == False, "Died on +.drive_config.drives[6].security_at_maximum"
    assert result.drive_config.drives[6].path_link == """/dev/slot2""", "Died on +.drive_config.drives[6].path_link"
    assert result.drive_config.drives[5].security_locked == False, "Died on +.drive_config.drives[5].security_locked"
    assert result.drive_config.drives[5].serial == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].serial"
    assert result.drive_config.drives[5].size == 268435456000, "Died on +.drive_config.drives[5].size"
    assert result.drive_config.drives[5].slot == 1, "Died on +.drive_config.drives[5].slot"
    assert result.drive_config.drives[5].uuid == UUID("a6944a6f-46f4-addb-ba1e-4c237b5fedc5"), "Died on .drive_config.drives[5].uuid"
    assert result.drive_config.drives[5].dev_path == """/dev/slot1""", "Died on +.drive_config.drives[5].dev_path"
    assert result.drive_config.drives[5].version == """Unknown""", "Died on +.drive_config.drives[5].version"
    assert result.drive_config.drives[5].security_supported == False, "Died on +.drive_config.drives[5].security_supported"
    assert result.drive_config.drives[5].drive_type == """Block""", "Died on +.drive_config.drives[5].drive_type"
    assert result.drive_config.drives[5].product == """Unknown""", "Died on +.drive_config.drives[5].product"
    assert result.drive_config.drives[5].vendor == """Unknown""", "Died on +.drive_config.drives[5].vendor"
    assert result.drive_config.drives[5].security_enabled == False, "Died on +.drive_config.drives[5].security_enabled"
    assert result.drive_config.drives[5].security_frozen == False, "Died on +.drive_config.drives[5].security_frozen"
    assert result.drive_config.drives[5].connected == True, "Died on +.drive_config.drives[5].connected"
    assert result.drive_config.drives[5].canonical_name == """sdb""", "Died on +.drive_config.drives[5].canonical_name"
    assert result.drive_config.drives[5].path == """/dev/sdb""", "Died on +.drive_config.drives[5].path"
    assert result.drive_config.drives[5].scsi_state == """Running""", "Died on +.drive_config.drives[5].scsi_state"
    assert result.drive_config.drives[5].scsi_compat_id == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].scsi_compat_id"
    assert result.drive_config.drives[5].name == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].name"
    assert result.drive_config.drives[5].dev == 2064, "Died on +.drive_config.drives[5].dev"
    assert result.drive_config.drives[5].security_at_maximum == False, "Died on +.drive_config.drives[5].security_at_maximum"
    assert result.drive_config.drives[5].path_link == """/dev/slot1""", "Died on +.drive_config.drives[5].path_link"
    assert result.drive_config.drives[4].security_locked == False, "Died on +.drive_config.drives[4].security_locked"
    assert result.drive_config.drives[4].serial == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].serial"
    assert result.drive_config.drives[4].size == 216787845120, "Died on +.drive_config.drives[4].size"
    assert result.drive_config.drives[4].slot == 0, "Died on +.drive_config.drives[4].slot"
    assert result.drive_config.drives[4].uuid == UUID("38b3c943-9e45-88e9-1ebe-130b4186d8da"), "Died on .drive_config.drives[4].uuid"
    assert result.drive_config.drives[4].dev_path == """/dev/slot0p6""", "Died on +.drive_config.drives[4].dev_path"
    assert result.drive_config.drives[4].version == """Unknown""", "Died on +.drive_config.drives[4].version"
    assert result.drive_config.drives[4].security_supported == False, "Died on +.drive_config.drives[4].security_supported"
    assert result.drive_config.drives[4].drive_type == """Slice""", "Died on +.drive_config.drives[4].drive_type"
    assert result.drive_config.drives[4].product == """Unknown""", "Died on +.drive_config.drives[4].product"
    assert result.drive_config.drives[4].vendor == """Unknown""", "Died on +.drive_config.drives[4].vendor"
    assert result.drive_config.drives[4].security_enabled == False, "Died on +.drive_config.drives[4].security_enabled"
    assert result.drive_config.drives[4].security_frozen == False, "Died on +.drive_config.drives[4].security_frozen"
    assert result.drive_config.drives[4].connected == True, "Died on +.drive_config.drives[4].connected"
    assert result.drive_config.drives[4].canonical_name == """sda""", "Died on +.drive_config.drives[4].canonical_name"
    assert result.drive_config.drives[4].path == """/dev/sda6""", "Died on +.drive_config.drives[4].path"
    assert result.drive_config.drives[4].scsi_state == """Running""", "Died on +.drive_config.drives[4].scsi_state"
    assert result.drive_config.drives[4].scsi_compat_id == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].scsi_compat_id"
    assert result.drive_config.drives[4].name == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].name"
    assert result.drive_config.drives[4].dev == 2054, "Died on +.drive_config.drives[4].dev"
    assert result.drive_config.drives[4].security_at_maximum == False, "Died on +.drive_config.drives[4].security_at_maximum"
    assert result.drive_config.drives[4].path_link == """/dev/slot0p6""", "Died on +.drive_config.drives[4].path_link"
    assert result.drive_config.drives[3].security_locked == False, "Died on +.drive_config.drives[3].security_locked"
    assert result.drive_config.drives[3].serial == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].serial"
    assert result.drive_config.drives[3].size == 9223372036854775807, "Died on +.drive_config.drives[3].size"
    assert result.drive_config.drives[3].slot == -2, "Died on +.drive_config.drives[3].slot"
    assert result.drive_config.drives[3].uuid == UUID("00abd0dc-ff28-2825-7faa-38e9a49d66a4"), "Died on .drive_config.drives[3].uuid"
    assert result.drive_config.drives[3].dev_path == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].dev_path"
    assert result.drive_config.drives[3].version == """Unknown""", "Died on +.drive_config.drives[3].version"
    assert result.drive_config.drives[3].security_supported == False, "Died on +.drive_config.drives[3].security_supported"
    assert result.drive_config.drives[3].drive_type == """System""", "Died on +.drive_config.drives[3].drive_type"
    assert result.drive_config.drives[3].product == """Unknown""", "Died on +.drive_config.drives[3].product"
    assert result.drive_config.drives[3].vendor == """Unknown""", "Died on +.drive_config.drives[3].vendor"
    assert result.drive_config.drives[3].security_enabled == False, "Died on +.drive_config.drives[3].security_enabled"
    assert result.drive_config.drives[3].security_frozen == False, "Died on +.drive_config.drives[3].security_frozen"
    assert result.drive_config.drives[3].connected == False, "Died on +.drive_config.drives[3].connected"
    assert result.drive_config.drives[3].canonical_name == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].canonical_name"
    assert result.drive_config.drives[3].path == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].path"
    assert result.drive_config.drives[3].scsi_state == """Unknown""", "Died on +.drive_config.drives[3].scsi_state"
    assert result.drive_config.drives[3].scsi_compat_id == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].scsi_compat_id"
    assert result.drive_config.drives[3].name == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].name"
    assert result.drive_config.drives[3].dev == 0, "Died on +.drive_config.drives[3].dev"
    assert result.drive_config.drives[3].security_at_maximum == False, "Died on +.drive_config.drives[3].security_at_maximum"
    assert result.drive_config.drives[3].path_link == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].path_link"
    assert result.drive_config.drives[2].security_locked == False, "Died on +.drive_config.drives[2].security_locked"
    assert result.drive_config.drives[2].serial == """log""", "Died on +.drive_config.drives[2].serial"
    assert result.drive_config.drives[2].size == 9223372036854775807, "Died on +.drive_config.drives[2].size"
    assert result.drive_config.drives[2].slot == -2, "Died on +.drive_config.drives[2].slot"
    assert result.drive_config.drives[2].uuid == UUID("dc1d71bb-b5c4-d2a5-e936-db79ef10c19f"), "Died on .drive_config.drives[2].uuid"
    assert result.drive_config.drives[2].dev_path == """/var/log""", "Died on +.drive_config.drives[2].dev_path"
    assert result.drive_config.drives[2].version == """Unknown""", "Died on +.drive_config.drives[2].version"
    assert result.drive_config.drives[2].security_supported == False, "Died on +.drive_config.drives[2].security_supported"
    assert result.drive_config.drives[2].drive_type == """System""", "Died on +.drive_config.drives[2].drive_type"
    assert result.drive_config.drives[2].product == """Unknown""", "Died on +.drive_config.drives[2].product"
    assert result.drive_config.drives[2].vendor == """Unknown""", "Died on +.drive_config.drives[2].vendor"
    assert result.drive_config.drives[2].security_enabled == False, "Died on +.drive_config.drives[2].security_enabled"
    assert result.drive_config.drives[2].security_frozen == False, "Died on +.drive_config.drives[2].security_frozen"
    assert result.drive_config.drives[2].connected == False, "Died on +.drive_config.drives[2].connected"
    assert result.drive_config.drives[2].canonical_name == """log""", "Died on +.drive_config.drives[2].canonical_name"
    assert result.drive_config.drives[2].path == """/var/log""", "Died on +.drive_config.drives[2].path"
    assert result.drive_config.drives[2].scsi_state == """Unknown""", "Died on +.drive_config.drives[2].scsi_state"
    assert result.drive_config.drives[2].scsi_compat_id == """log""", "Died on +.drive_config.drives[2].scsi_compat_id"
    assert result.drive_config.drives[2].name == """log""", "Died on +.drive_config.drives[2].name"
    assert result.drive_config.drives[2].dev == 0, "Died on +.drive_config.drives[2].dev"
    assert result.drive_config.drives[2].security_at_maximum == False, "Died on +.drive_config.drives[2].security_at_maximum"
    assert result.drive_config.drives[2].path_link == """/var/log""", "Died on +.drive_config.drives[2].path_link"
    assert result.drive_config.drives[1].security_locked == False, "Died on +.drive_config.drives[1].security_locked"
    assert result.drive_config.drives[1].serial == """/""", "Died on +.drive_config.drives[1].serial"
    assert result.drive_config.drives[1].size == 9223372036854775807, "Died on +.drive_config.drives[1].size"
    assert result.drive_config.drives[1].slot == -2, "Died on +.drive_config.drives[1].slot"
    assert result.drive_config.drives[1].uuid == UUID("6666cd76-f969-5646-9e7b-e39d750cc7d9"), "Died on .drive_config.drives[1].uuid"
    assert result.drive_config.drives[1].dev_path == """/""", "Died on +.drive_config.drives[1].dev_path"
    assert result.drive_config.drives[1].version == """Unknown""", "Died on +.drive_config.drives[1].version"
    assert result.drive_config.drives[1].security_supported == False, "Died on +.drive_config.drives[1].security_supported"
    assert result.drive_config.drives[1].drive_type == """System""", "Died on +.drive_config.drives[1].drive_type"
    assert result.drive_config.drives[1].product == """Unknown""", "Died on +.drive_config.drives[1].product"
    assert result.drive_config.drives[1].vendor == """Unknown""", "Died on +.drive_config.drives[1].vendor"
    assert result.drive_config.drives[1].security_enabled == False, "Died on +.drive_config.drives[1].security_enabled"
    assert result.drive_config.drives[1].security_frozen == False, "Died on +.drive_config.drives[1].security_frozen"
    assert result.drive_config.drives[1].connected == False, "Died on +.drive_config.drives[1].connected"
    assert result.drive_config.drives[1].canonical_name == """/""", "Died on +.drive_config.drives[1].canonical_name"
    assert result.drive_config.drives[1].path == """/""", "Died on +.drive_config.drives[1].path"
    assert result.drive_config.drives[1].scsi_state == """Unknown""", "Died on +.drive_config.drives[1].scsi_state"
    assert result.drive_config.drives[1].scsi_compat_id == """/""", "Died on +.drive_config.drives[1].scsi_compat_id"
    assert result.drive_config.drives[1].name == """/""", "Died on +.drive_config.drives[1].name"
    assert result.drive_config.drives[1].dev == 0, "Died on +.drive_config.drives[1].dev"
    assert result.drive_config.drives[1].security_at_maximum == False, "Died on +.drive_config.drives[1].security_at_maximum"
    assert result.drive_config.drives[1].path_link == """/""", "Died on +.drive_config.drives[1].path_link"
    assert result.drive_config.drives[0].security_locked == False, "Died on +.drive_config.drives[0].security_locked"
    assert result.drive_config.drives[0].serial == """boot""", "Died on +.drive_config.drives[0].serial"
    assert result.drive_config.drives[0].size == 1024, "Died on +.drive_config.drives[0].size"
    assert result.drive_config.drives[0].slot == -2, "Died on +.drive_config.drives[0].slot"
    assert result.drive_config.drives[0].uuid == UUID("881cc415-7ed6-41a3-65a8-6452f27ed745"), "Died on .drive_config.drives[0].uuid"
    assert result.drive_config.drives[0].dev_path == """/boot""", "Died on +.drive_config.drives[0].dev_path"
    assert result.drive_config.drives[0].version == """Unknown""", "Died on +.drive_config.drives[0].version"
    assert result.drive_config.drives[0].security_supported == False, "Died on +.drive_config.drives[0].security_supported"
    assert result.drive_config.drives[0].drive_type == """System""", "Died on +.drive_config.drives[0].drive_type"
    assert result.drive_config.drives[0].product == """Unknown""", "Died on +.drive_config.drives[0].product"
    assert result.drive_config.drives[0].vendor == """Unknown""", "Died on +.drive_config.drives[0].vendor"
    assert result.drive_config.drives[0].security_enabled == False, "Died on +.drive_config.drives[0].security_enabled"
    assert result.drive_config.drives[0].security_frozen == False, "Died on +.drive_config.drives[0].security_frozen"
    assert result.drive_config.drives[0].connected == False, "Died on +.drive_config.drives[0].connected"
    assert result.drive_config.drives[0].canonical_name == """boot""", "Died on +.drive_config.drives[0].canonical_name"
    assert result.drive_config.drives[0].path == """/boot""", "Died on +.drive_config.drives[0].path"
    assert result.drive_config.drives[0].scsi_state == """Unknown""", "Died on +.drive_config.drives[0].scsi_state"
    assert result.drive_config.drives[0].scsi_compat_id == """boot""", "Died on +.drive_config.drives[0].scsi_compat_id"
    assert result.drive_config.drives[0].name == """boot""", "Died on +.drive_config.drives[0].name"
    assert result.drive_config.drives[0].dev == 0, "Died on +.drive_config.drives[0].dev"
    assert result.drive_config.drives[0].security_at_maximum == False, "Died on +.drive_config.drives[0].security_at_maximum"
    assert result.drive_config.drives[0].path_link == """/boot""", "Died on +.drive_config.drives[0].path_link"
    assert result.drive_config.num_block_actual == 1, "Died on +.drive_config.num_block_actual"
    assert result.drive_config.num_total_actual == 2, "Died on +.drive_config.num_total_actual"
    assert result.drive_config.num_block_expected == 10, "Died on +.drive_config.num_block_expected"

def test_get_drive_config_v9_1():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetDriveConfig_v9_1)

    
    result = ef.get_drive_config()
    assert result.drive_config.num_slice_actual == 1, "Died on +.drive_config.num_slice_actual"
    assert result.drive_config.num_total_expected == 11, "Died on +.drive_config.num_total_expected"
    assert result.drive_config.num_slice_expected == 1, "Died on +.drive_config.num_slice_expected"
    assert result.drive_config.drives[14].security_locked == False, "Died on +.drive_config.drives[14].security_locked"
    assert result.drive_config.drives[14].serial == """slot10""", "Died on +.drive_config.drives[14].serial"
    assert result.drive_config.drives[14].size == 0, "Died on +.drive_config.drives[14].size"
    assert result.drive_config.drives[14].slot == 10, "Died on +.drive_config.drives[14].slot"
    assert result.drive_config.drives[14].uuid == UUID("9d62ad9e-a097-d5d6-d4f7-1d27193270a1"), "Died on .drive_config.drives[14].uuid"
    assert result.drive_config.drives[14].dev_path == """/dev/slot10""", "Died on +.drive_config.drives[14].dev_path"
    assert result.drive_config.drives[14].version == """Unknown""", "Died on +.drive_config.drives[14].version"
    assert result.drive_config.drives[14].security_supported == False, "Died on +.drive_config.drives[14].security_supported"
    assert result.drive_config.drives[14].drive_type == """Block""", "Died on +.drive_config.drives[14].drive_type"
    assert result.drive_config.drives[14].product == """Unknown""", "Died on +.drive_config.drives[14].product"
    assert result.drive_config.drives[14].vendor == """Unknown""", "Died on +.drive_config.drives[14].vendor"
    assert result.drive_config.drives[14].security_enabled == False, "Died on +.drive_config.drives[14].security_enabled"
    assert result.drive_config.drives[14].security_frozen == False, "Died on +.drive_config.drives[14].security_frozen"
    assert result.drive_config.drives[14].connected == False, "Died on +.drive_config.drives[14].connected"
    assert result.drive_config.drives[14].path == """/dev/slot10""", "Died on +.drive_config.drives[14].path"
    assert result.drive_config.drives[14].scsi_state == """Unknown""", "Died on +.drive_config.drives[14].scsi_state"
    assert result.drive_config.drives[14].scsi_compat_id == """slot10""", "Died on +.drive_config.drives[14].scsi_compat_id"
    assert result.drive_config.drives[14].name == """slot10""", "Died on +.drive_config.drives[14].name"
    assert result.drive_config.drives[14].dev == 0, "Died on +.drive_config.drives[14].dev"
    assert result.drive_config.drives[14].security_at_maximum == False, "Died on +.drive_config.drives[14].security_at_maximum"
    assert result.drive_config.drives[14].path_link == """/dev/slot10""", "Died on +.drive_config.drives[14].path_link"
    assert result.drive_config.drives[13].security_locked == False, "Died on +.drive_config.drives[13].security_locked"
    assert result.drive_config.drives[13].serial == """slot9""", "Died on +.drive_config.drives[13].serial"
    assert result.drive_config.drives[13].size == 0, "Died on +.drive_config.drives[13].size"
    assert result.drive_config.drives[13].slot == 9, "Died on +.drive_config.drives[13].slot"
    assert result.drive_config.drives[13].uuid == UUID("612e2106-7032-850a-a16d-4980b53ffb23"), "Died on .drive_config.drives[13].uuid"
    assert result.drive_config.drives[13].dev_path == """/dev/slot9""", "Died on +.drive_config.drives[13].dev_path"
    assert result.drive_config.drives[13].version == """Unknown""", "Died on +.drive_config.drives[13].version"
    assert result.drive_config.drives[13].security_supported == False, "Died on +.drive_config.drives[13].security_supported"
    assert result.drive_config.drives[13].drive_type == """Block""", "Died on +.drive_config.drives[13].drive_type"
    assert result.drive_config.drives[13].product == """Unknown""", "Died on +.drive_config.drives[13].product"
    assert result.drive_config.drives[13].vendor == """Unknown""", "Died on +.drive_config.drives[13].vendor"
    assert result.drive_config.drives[13].security_enabled == False, "Died on +.drive_config.drives[13].security_enabled"
    assert result.drive_config.drives[13].security_frozen == False, "Died on +.drive_config.drives[13].security_frozen"
    assert result.drive_config.drives[13].connected == False, "Died on +.drive_config.drives[13].connected"
    assert result.drive_config.drives[13].path == """/dev/slot9""", "Died on +.drive_config.drives[13].path"
    assert result.drive_config.drives[13].scsi_state == """Unknown""", "Died on +.drive_config.drives[13].scsi_state"
    assert result.drive_config.drives[13].scsi_compat_id == """slot9""", "Died on +.drive_config.drives[13].scsi_compat_id"
    assert result.drive_config.drives[13].name == """slot9""", "Died on +.drive_config.drives[13].name"
    assert result.drive_config.drives[13].dev == 0, "Died on +.drive_config.drives[13].dev"
    assert result.drive_config.drives[13].security_at_maximum == False, "Died on +.drive_config.drives[13].security_at_maximum"
    assert result.drive_config.drives[13].path_link == """/dev/slot9""", "Died on +.drive_config.drives[13].path_link"
    assert result.drive_config.drives[12].security_locked == False, "Died on +.drive_config.drives[12].security_locked"
    assert result.drive_config.drives[12].serial == """slot8""", "Died on +.drive_config.drives[12].serial"
    assert result.drive_config.drives[12].size == 0, "Died on +.drive_config.drives[12].size"
    assert result.drive_config.drives[12].slot == 8, "Died on +.drive_config.drives[12].slot"
    assert result.drive_config.drives[12].uuid == UUID("28384068-fdee-1dae-21e3-493558121657"), "Died on .drive_config.drives[12].uuid"
    assert result.drive_config.drives[12].dev_path == """/dev/slot8""", "Died on +.drive_config.drives[12].dev_path"
    assert result.drive_config.drives[12].version == """Unknown""", "Died on +.drive_config.drives[12].version"
    assert result.drive_config.drives[12].security_supported == False, "Died on +.drive_config.drives[12].security_supported"
    assert result.drive_config.drives[12].drive_type == """Block""", "Died on +.drive_config.drives[12].drive_type"
    assert result.drive_config.drives[12].product == """Unknown""", "Died on +.drive_config.drives[12].product"
    assert result.drive_config.drives[12].vendor == """Unknown""", "Died on +.drive_config.drives[12].vendor"
    assert result.drive_config.drives[12].security_enabled == False, "Died on +.drive_config.drives[12].security_enabled"
    assert result.drive_config.drives[12].security_frozen == False, "Died on +.drive_config.drives[12].security_frozen"
    assert result.drive_config.drives[12].connected == False, "Died on +.drive_config.drives[12].connected"
    assert result.drive_config.drives[12].path == """/dev/slot8""", "Died on +.drive_config.drives[12].path"
    assert result.drive_config.drives[12].scsi_state == """Unknown""", "Died on +.drive_config.drives[12].scsi_state"
    assert result.drive_config.drives[12].scsi_compat_id == """slot8""", "Died on +.drive_config.drives[12].scsi_compat_id"
    assert result.drive_config.drives[12].name == """slot8""", "Died on +.drive_config.drives[12].name"
    assert result.drive_config.drives[12].dev == 0, "Died on +.drive_config.drives[12].dev"
    assert result.drive_config.drives[12].security_at_maximum == False, "Died on +.drive_config.drives[12].security_at_maximum"
    assert result.drive_config.drives[12].path_link == """/dev/slot8""", "Died on +.drive_config.drives[12].path_link"
    assert result.drive_config.drives[11].security_locked == False, "Died on +.drive_config.drives[11].security_locked"
    assert result.drive_config.drives[11].serial == """slot7""", "Died on +.drive_config.drives[11].serial"
    assert result.drive_config.drives[11].size == 0, "Died on +.drive_config.drives[11].size"
    assert result.drive_config.drives[11].slot == 7, "Died on +.drive_config.drives[11].slot"
    assert result.drive_config.drives[11].uuid == UUID("76c29a96-68a6-2d8e-6416-392f9fd07919"), "Died on .drive_config.drives[11].uuid"
    assert result.drive_config.drives[11].dev_path == """/dev/slot7""", "Died on +.drive_config.drives[11].dev_path"
    assert result.drive_config.drives[11].version == """Unknown""", "Died on +.drive_config.drives[11].version"
    assert result.drive_config.drives[11].security_supported == False, "Died on +.drive_config.drives[11].security_supported"
    assert result.drive_config.drives[11].drive_type == """Block""", "Died on +.drive_config.drives[11].drive_type"
    assert result.drive_config.drives[11].product == """Unknown""", "Died on +.drive_config.drives[11].product"
    assert result.drive_config.drives[11].vendor == """Unknown""", "Died on +.drive_config.drives[11].vendor"
    assert result.drive_config.drives[11].security_enabled == False, "Died on +.drive_config.drives[11].security_enabled"
    assert result.drive_config.drives[11].security_frozen == False, "Died on +.drive_config.drives[11].security_frozen"
    assert result.drive_config.drives[11].connected == False, "Died on +.drive_config.drives[11].connected"
    assert result.drive_config.drives[11].path == """/dev/slot7""", "Died on +.drive_config.drives[11].path"
    assert result.drive_config.drives[11].scsi_state == """Unknown""", "Died on +.drive_config.drives[11].scsi_state"
    assert result.drive_config.drives[11].scsi_compat_id == """slot7""", "Died on +.drive_config.drives[11].scsi_compat_id"
    assert result.drive_config.drives[11].name == """slot7""", "Died on +.drive_config.drives[11].name"
    assert result.drive_config.drives[11].dev == 0, "Died on +.drive_config.drives[11].dev"
    assert result.drive_config.drives[11].security_at_maximum == False, "Died on +.drive_config.drives[11].security_at_maximum"
    assert result.drive_config.drives[11].path_link == """/dev/slot7""", "Died on +.drive_config.drives[11].path_link"
    assert result.drive_config.drives[10].security_locked == False, "Died on +.drive_config.drives[10].security_locked"
    assert result.drive_config.drives[10].serial == """slot6""", "Died on +.drive_config.drives[10].serial"
    assert result.drive_config.drives[10].size == 0, "Died on +.drive_config.drives[10].size"
    assert result.drive_config.drives[10].slot == 6, "Died on +.drive_config.drives[10].slot"
    assert result.drive_config.drives[10].uuid == UUID("c1b04a69-49a0-fdee-b818-c6cdfafd6cd5"), "Died on .drive_config.drives[10].uuid"
    assert result.drive_config.drives[10].dev_path == """/dev/slot6""", "Died on +.drive_config.drives[10].dev_path"
    assert result.drive_config.drives[10].version == """Unknown""", "Died on +.drive_config.drives[10].version"
    assert result.drive_config.drives[10].security_supported == False, "Died on +.drive_config.drives[10].security_supported"
    assert result.drive_config.drives[10].drive_type == """Block""", "Died on +.drive_config.drives[10].drive_type"
    assert result.drive_config.drives[10].product == """Unknown""", "Died on +.drive_config.drives[10].product"
    assert result.drive_config.drives[10].vendor == """Unknown""", "Died on +.drive_config.drives[10].vendor"
    assert result.drive_config.drives[10].security_enabled == False, "Died on +.drive_config.drives[10].security_enabled"
    assert result.drive_config.drives[10].security_frozen == False, "Died on +.drive_config.drives[10].security_frozen"
    assert result.drive_config.drives[10].connected == False, "Died on +.drive_config.drives[10].connected"
    assert result.drive_config.drives[10].path == """/dev/slot6""", "Died on +.drive_config.drives[10].path"
    assert result.drive_config.drives[10].scsi_state == """Unknown""", "Died on +.drive_config.drives[10].scsi_state"
    assert result.drive_config.drives[10].scsi_compat_id == """slot6""", "Died on +.drive_config.drives[10].scsi_compat_id"
    assert result.drive_config.drives[10].name == """slot6""", "Died on +.drive_config.drives[10].name"
    assert result.drive_config.drives[10].dev == 0, "Died on +.drive_config.drives[10].dev"
    assert result.drive_config.drives[10].security_at_maximum == False, "Died on +.drive_config.drives[10].security_at_maximum"
    assert result.drive_config.drives[10].path_link == """/dev/slot6""", "Died on +.drive_config.drives[10].path_link"
    assert result.drive_config.drives[9].security_locked == False, "Died on +.drive_config.drives[9].security_locked"
    assert result.drive_config.drives[9].serial == """slot5""", "Died on +.drive_config.drives[9].serial"
    assert result.drive_config.drives[9].size == 0, "Died on +.drive_config.drives[9].size"
    assert result.drive_config.drives[9].slot == 5, "Died on +.drive_config.drives[9].slot"
    assert result.drive_config.drives[9].uuid == UUID("b31123fa-9a17-0ccd-deab-deac32a58371"), "Died on .drive_config.drives[9].uuid"
    assert result.drive_config.drives[9].dev_path == """/dev/slot5""", "Died on +.drive_config.drives[9].dev_path"
    assert result.drive_config.drives[9].version == """Unknown""", "Died on +.drive_config.drives[9].version"
    assert result.drive_config.drives[9].security_supported == False, "Died on +.drive_config.drives[9].security_supported"
    assert result.drive_config.drives[9].drive_type == """Block""", "Died on +.drive_config.drives[9].drive_type"
    assert result.drive_config.drives[9].product == """Unknown""", "Died on +.drive_config.drives[9].product"
    assert result.drive_config.drives[9].vendor == """Unknown""", "Died on +.drive_config.drives[9].vendor"
    assert result.drive_config.drives[9].security_enabled == False, "Died on +.drive_config.drives[9].security_enabled"
    assert result.drive_config.drives[9].security_frozen == False, "Died on +.drive_config.drives[9].security_frozen"
    assert result.drive_config.drives[9].connected == False, "Died on +.drive_config.drives[9].connected"
    assert result.drive_config.drives[9].path == """/dev/slot5""", "Died on +.drive_config.drives[9].path"
    assert result.drive_config.drives[9].scsi_state == """Unknown""", "Died on +.drive_config.drives[9].scsi_state"
    assert result.drive_config.drives[9].scsi_compat_id == """slot5""", "Died on +.drive_config.drives[9].scsi_compat_id"
    assert result.drive_config.drives[9].name == """slot5""", "Died on +.drive_config.drives[9].name"
    assert result.drive_config.drives[9].dev == 0, "Died on +.drive_config.drives[9].dev"
    assert result.drive_config.drives[9].security_at_maximum == False, "Died on +.drive_config.drives[9].security_at_maximum"
    assert result.drive_config.drives[9].path_link == """/dev/slot5""", "Died on +.drive_config.drives[9].path_link"
    assert result.drive_config.drives[8].security_locked == False, "Died on +.drive_config.drives[8].security_locked"
    assert result.drive_config.drives[8].serial == """slot4""", "Died on +.drive_config.drives[8].serial"
    assert result.drive_config.drives[8].size == 0, "Died on +.drive_config.drives[8].size"
    assert result.drive_config.drives[8].slot == 4, "Died on +.drive_config.drives[8].slot"
    assert result.drive_config.drives[8].uuid == UUID("76e3d13f-88c5-c334-8f0b-8486964d369e"), "Died on .drive_config.drives[8].uuid"
    assert result.drive_config.drives[8].dev_path == """/dev/slot4""", "Died on +.drive_config.drives[8].dev_path"
    assert result.drive_config.drives[8].version == """Unknown""", "Died on +.drive_config.drives[8].version"
    assert result.drive_config.drives[8].security_supported == False, "Died on +.drive_config.drives[8].security_supported"
    assert result.drive_config.drives[8].drive_type == """Block""", "Died on +.drive_config.drives[8].drive_type"
    assert result.drive_config.drives[8].product == """Unknown""", "Died on +.drive_config.drives[8].product"
    assert result.drive_config.drives[8].vendor == """Unknown""", "Died on +.drive_config.drives[8].vendor"
    assert result.drive_config.drives[8].security_enabled == False, "Died on +.drive_config.drives[8].security_enabled"
    assert result.drive_config.drives[8].security_frozen == False, "Died on +.drive_config.drives[8].security_frozen"
    assert result.drive_config.drives[8].connected == False, "Died on +.drive_config.drives[8].connected"
    assert result.drive_config.drives[8].path == """/dev/slot4""", "Died on +.drive_config.drives[8].path"
    assert result.drive_config.drives[8].scsi_state == """Unknown""", "Died on +.drive_config.drives[8].scsi_state"
    assert result.drive_config.drives[8].scsi_compat_id == """slot4""", "Died on +.drive_config.drives[8].scsi_compat_id"
    assert result.drive_config.drives[8].name == """slot4""", "Died on +.drive_config.drives[8].name"
    assert result.drive_config.drives[8].dev == 0, "Died on +.drive_config.drives[8].dev"
    assert result.drive_config.drives[8].security_at_maximum == False, "Died on +.drive_config.drives[8].security_at_maximum"
    assert result.drive_config.drives[8].path_link == """/dev/slot4""", "Died on +.drive_config.drives[8].path_link"
    assert result.drive_config.drives[7].security_locked == False, "Died on +.drive_config.drives[7].security_locked"
    assert result.drive_config.drives[7].serial == """slot3""", "Died on +.drive_config.drives[7].serial"
    assert result.drive_config.drives[7].size == 0, "Died on +.drive_config.drives[7].size"
    assert result.drive_config.drives[7].slot == 3, "Died on +.drive_config.drives[7].slot"
    assert result.drive_config.drives[7].uuid == UUID("25b903d1-3b55-d53f-a556-47b28f91b728"), "Died on .drive_config.drives[7].uuid"
    assert result.drive_config.drives[7].dev_path == """/dev/slot3""", "Died on +.drive_config.drives[7].dev_path"
    assert result.drive_config.drives[7].version == """Unknown""", "Died on +.drive_config.drives[7].version"
    assert result.drive_config.drives[7].security_supported == False, "Died on +.drive_config.drives[7].security_supported"
    assert result.drive_config.drives[7].drive_type == """Block""", "Died on +.drive_config.drives[7].drive_type"
    assert result.drive_config.drives[7].product == """Unknown""", "Died on +.drive_config.drives[7].product"
    assert result.drive_config.drives[7].vendor == """Unknown""", "Died on +.drive_config.drives[7].vendor"
    assert result.drive_config.drives[7].security_enabled == False, "Died on +.drive_config.drives[7].security_enabled"
    assert result.drive_config.drives[7].security_frozen == False, "Died on +.drive_config.drives[7].security_frozen"
    assert result.drive_config.drives[7].connected == False, "Died on +.drive_config.drives[7].connected"
    assert result.drive_config.drives[7].path == """/dev/slot3""", "Died on +.drive_config.drives[7].path"
    assert result.drive_config.drives[7].scsi_state == """Unknown""", "Died on +.drive_config.drives[7].scsi_state"
    assert result.drive_config.drives[7].scsi_compat_id == """slot3""", "Died on +.drive_config.drives[7].scsi_compat_id"
    assert result.drive_config.drives[7].name == """slot3""", "Died on +.drive_config.drives[7].name"
    assert result.drive_config.drives[7].dev == 0, "Died on +.drive_config.drives[7].dev"
    assert result.drive_config.drives[7].security_at_maximum == False, "Died on +.drive_config.drives[7].security_at_maximum"
    assert result.drive_config.drives[7].path_link == """/dev/slot3""", "Died on +.drive_config.drives[7].path_link"
    assert result.drive_config.drives[6].security_locked == False, "Died on +.drive_config.drives[6].security_locked"
    assert result.drive_config.drives[6].serial == """slot2""", "Died on +.drive_config.drives[6].serial"
    assert result.drive_config.drives[6].size == 0, "Died on +.drive_config.drives[6].size"
    assert result.drive_config.drives[6].slot == 2, "Died on +.drive_config.drives[6].slot"
    assert result.drive_config.drives[6].uuid == UUID("d92f909d-c606-4c27-d17a-4cb6db95a35c"), "Died on .drive_config.drives[6].uuid"
    assert result.drive_config.drives[6].dev_path == """/dev/slot2""", "Died on +.drive_config.drives[6].dev_path"
    assert result.drive_config.drives[6].version == """Unknown""", "Died on +.drive_config.drives[6].version"
    assert result.drive_config.drives[6].security_supported == False, "Died on +.drive_config.drives[6].security_supported"
    assert result.drive_config.drives[6].drive_type == """Block""", "Died on +.drive_config.drives[6].drive_type"
    assert result.drive_config.drives[6].product == """Unknown""", "Died on +.drive_config.drives[6].product"
    assert result.drive_config.drives[6].vendor == """Unknown""", "Died on +.drive_config.drives[6].vendor"
    assert result.drive_config.drives[6].security_enabled == False, "Died on +.drive_config.drives[6].security_enabled"
    assert result.drive_config.drives[6].security_frozen == False, "Died on +.drive_config.drives[6].security_frozen"
    assert result.drive_config.drives[6].connected == False, "Died on +.drive_config.drives[6].connected"
    assert result.drive_config.drives[6].path == """/dev/slot2""", "Died on +.drive_config.drives[6].path"
    assert result.drive_config.drives[6].scsi_state == """Unknown""", "Died on +.drive_config.drives[6].scsi_state"
    assert result.drive_config.drives[6].scsi_compat_id == """slot2""", "Died on +.drive_config.drives[6].scsi_compat_id"
    assert result.drive_config.drives[6].name == """slot2""", "Died on +.drive_config.drives[6].name"
    assert result.drive_config.drives[6].dev == 0, "Died on +.drive_config.drives[6].dev"
    assert result.drive_config.drives[6].security_at_maximum == False, "Died on +.drive_config.drives[6].security_at_maximum"
    assert result.drive_config.drives[6].path_link == """/dev/slot2""", "Died on +.drive_config.drives[6].path_link"
    assert result.drive_config.drives[5].security_locked == False, "Died on +.drive_config.drives[5].security_locked"
    assert result.drive_config.drives[5].serial == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].serial"
    assert result.drive_config.drives[5].size == 268435456000, "Died on +.drive_config.drives[5].size"
    assert result.drive_config.drives[5].slot == 1, "Died on +.drive_config.drives[5].slot"
    assert result.drive_config.drives[5].uuid == UUID("a6944a6f-46f4-addb-ba1e-4c237b5fedc5"), "Died on .drive_config.drives[5].uuid"
    assert result.drive_config.drives[5].dev_path == """/dev/slot1""", "Died on +.drive_config.drives[5].dev_path"
    assert result.drive_config.drives[5].version == """Unknown""", "Died on +.drive_config.drives[5].version"
    assert result.drive_config.drives[5].security_supported == False, "Died on +.drive_config.drives[5].security_supported"
    assert result.drive_config.drives[5].drive_type == """Block""", "Died on +.drive_config.drives[5].drive_type"
    assert result.drive_config.drives[5].product == """Unknown""", "Died on +.drive_config.drives[5].product"
    assert result.drive_config.drives[5].vendor == """Unknown""", "Died on +.drive_config.drives[5].vendor"
    assert result.drive_config.drives[5].security_enabled == False, "Died on +.drive_config.drives[5].security_enabled"
    assert result.drive_config.drives[5].security_frozen == False, "Died on +.drive_config.drives[5].security_frozen"
    assert result.drive_config.drives[5].connected == True, "Died on +.drive_config.drives[5].connected"
    assert result.drive_config.drives[5].canonical_name == """sdb""", "Died on +.drive_config.drives[5].canonical_name"
    assert result.drive_config.drives[5].path == """/dev/sdb""", "Died on +.drive_config.drives[5].path"
    assert result.drive_config.drives[5].scsi_state == """Running""", "Died on +.drive_config.drives[5].scsi_state"
    assert result.drive_config.drives[5].scsi_compat_id == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].scsi_compat_id"
    assert result.drive_config.drives[5].name == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].name"
    assert result.drive_config.drives[5].dev == 2064, "Died on +.drive_config.drives[5].dev"
    assert result.drive_config.drives[5].security_at_maximum == False, "Died on +.drive_config.drives[5].security_at_maximum"
    assert result.drive_config.drives[5].path_link == """/dev/slot1""", "Died on +.drive_config.drives[5].path_link"
    assert result.drive_config.drives[4].security_locked == False, "Died on +.drive_config.drives[4].security_locked"
    assert result.drive_config.drives[4].serial == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].serial"
    assert result.drive_config.drives[4].size == 216787845120, "Died on +.drive_config.drives[4].size"
    assert result.drive_config.drives[4].slot == 0, "Died on +.drive_config.drives[4].slot"
    assert result.drive_config.drives[4].uuid == UUID("38b3c943-9e45-88e9-1ebe-130b4186d8da"), "Died on .drive_config.drives[4].uuid"
    assert result.drive_config.drives[4].dev_path == """/dev/slot0p6""", "Died on +.drive_config.drives[4].dev_path"
    assert result.drive_config.drives[4].version == """Unknown""", "Died on +.drive_config.drives[4].version"
    assert result.drive_config.drives[4].security_supported == False, "Died on +.drive_config.drives[4].security_supported"
    assert result.drive_config.drives[4].drive_type == """Slice""", "Died on +.drive_config.drives[4].drive_type"
    assert result.drive_config.drives[4].product == """Unknown""", "Died on +.drive_config.drives[4].product"
    assert result.drive_config.drives[4].vendor == """Unknown""", "Died on +.drive_config.drives[4].vendor"
    assert result.drive_config.drives[4].security_enabled == False, "Died on +.drive_config.drives[4].security_enabled"
    assert result.drive_config.drives[4].security_frozen == False, "Died on +.drive_config.drives[4].security_frozen"
    assert result.drive_config.drives[4].connected == True, "Died on +.drive_config.drives[4].connected"
    assert result.drive_config.drives[4].canonical_name == """sda""", "Died on +.drive_config.drives[4].canonical_name"
    assert result.drive_config.drives[4].path == """/dev/sda6""", "Died on +.drive_config.drives[4].path"
    assert result.drive_config.drives[4].scsi_state == """Running""", "Died on +.drive_config.drives[4].scsi_state"
    assert result.drive_config.drives[4].scsi_compat_id == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].scsi_compat_id"
    assert result.drive_config.drives[4].name == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].name"
    assert result.drive_config.drives[4].dev == 2054, "Died on +.drive_config.drives[4].dev"
    assert result.drive_config.drives[4].security_at_maximum == False, "Died on +.drive_config.drives[4].security_at_maximum"
    assert result.drive_config.drives[4].path_link == """/dev/slot0p6""", "Died on +.drive_config.drives[4].path_link"
    assert result.drive_config.drives[3].security_locked == False, "Died on +.drive_config.drives[3].security_locked"
    assert result.drive_config.drives[3].serial == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].serial"
    assert result.drive_config.drives[3].size == 9223372036854775807, "Died on +.drive_config.drives[3].size"
    assert result.drive_config.drives[3].slot == -2, "Died on +.drive_config.drives[3].slot"
    assert result.drive_config.drives[3].uuid == UUID("00abd0dc-ff28-2825-7faa-38e9a49d66a4"), "Died on .drive_config.drives[3].uuid"
    assert result.drive_config.drives[3].dev_path == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].dev_path"
    assert result.drive_config.drives[3].version == """Unknown""", "Died on +.drive_config.drives[3].version"
    assert result.drive_config.drives[3].security_supported == False, "Died on +.drive_config.drives[3].security_supported"
    assert result.drive_config.drives[3].drive_type == """System""", "Died on +.drive_config.drives[3].drive_type"
    assert result.drive_config.drives[3].product == """Unknown""", "Died on +.drive_config.drives[3].product"
    assert result.drive_config.drives[3].vendor == """Unknown""", "Died on +.drive_config.drives[3].vendor"
    assert result.drive_config.drives[3].security_enabled == False, "Died on +.drive_config.drives[3].security_enabled"
    assert result.drive_config.drives[3].security_frozen == False, "Died on +.drive_config.drives[3].security_frozen"
    assert result.drive_config.drives[3].connected == False, "Died on +.drive_config.drives[3].connected"
    assert result.drive_config.drives[3].canonical_name == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].canonical_name"
    assert result.drive_config.drives[3].path == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].path"
    assert result.drive_config.drives[3].scsi_state == """Unknown""", "Died on +.drive_config.drives[3].scsi_state"
    assert result.drive_config.drives[3].scsi_compat_id == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].scsi_compat_id"
    assert result.drive_config.drives[3].name == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].name"
    assert result.drive_config.drives[3].dev == 0, "Died on +.drive_config.drives[3].dev"
    assert result.drive_config.drives[3].security_at_maximum == False, "Died on +.drive_config.drives[3].security_at_maximum"
    assert result.drive_config.drives[3].path_link == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].path_link"
    assert result.drive_config.drives[2].security_locked == False, "Died on +.drive_config.drives[2].security_locked"
    assert result.drive_config.drives[2].serial == """log""", "Died on +.drive_config.drives[2].serial"
    assert result.drive_config.drives[2].size == 9223372036854775807, "Died on +.drive_config.drives[2].size"
    assert result.drive_config.drives[2].slot == -2, "Died on +.drive_config.drives[2].slot"
    assert result.drive_config.drives[2].uuid == UUID("dc1d71bb-b5c4-d2a5-e936-db79ef10c19f"), "Died on .drive_config.drives[2].uuid"
    assert result.drive_config.drives[2].dev_path == """/var/log""", "Died on +.drive_config.drives[2].dev_path"
    assert result.drive_config.drives[2].version == """Unknown""", "Died on +.drive_config.drives[2].version"
    assert result.drive_config.drives[2].security_supported == False, "Died on +.drive_config.drives[2].security_supported"
    assert result.drive_config.drives[2].drive_type == """System""", "Died on +.drive_config.drives[2].drive_type"
    assert result.drive_config.drives[2].product == """Unknown""", "Died on +.drive_config.drives[2].product"
    assert result.drive_config.drives[2].vendor == """Unknown""", "Died on +.drive_config.drives[2].vendor"
    assert result.drive_config.drives[2].security_enabled == False, "Died on +.drive_config.drives[2].security_enabled"
    assert result.drive_config.drives[2].security_frozen == False, "Died on +.drive_config.drives[2].security_frozen"
    assert result.drive_config.drives[2].connected == False, "Died on +.drive_config.drives[2].connected"
    assert result.drive_config.drives[2].canonical_name == """log""", "Died on +.drive_config.drives[2].canonical_name"
    assert result.drive_config.drives[2].path == """/var/log""", "Died on +.drive_config.drives[2].path"
    assert result.drive_config.drives[2].scsi_state == """Unknown""", "Died on +.drive_config.drives[2].scsi_state"
    assert result.drive_config.drives[2].scsi_compat_id == """log""", "Died on +.drive_config.drives[2].scsi_compat_id"
    assert result.drive_config.drives[2].name == """log""", "Died on +.drive_config.drives[2].name"
    assert result.drive_config.drives[2].dev == 0, "Died on +.drive_config.drives[2].dev"
    assert result.drive_config.drives[2].security_at_maximum == False, "Died on +.drive_config.drives[2].security_at_maximum"
    assert result.drive_config.drives[2].path_link == """/var/log""", "Died on +.drive_config.drives[2].path_link"
    assert result.drive_config.drives[1].security_locked == False, "Died on +.drive_config.drives[1].security_locked"
    assert result.drive_config.drives[1].serial == """/""", "Died on +.drive_config.drives[1].serial"
    assert result.drive_config.drives[1].size == 9223372036854775807, "Died on +.drive_config.drives[1].size"
    assert result.drive_config.drives[1].slot == -2, "Died on +.drive_config.drives[1].slot"
    assert result.drive_config.drives[1].uuid == UUID("6666cd76-f969-5646-9e7b-e39d750cc7d9"), "Died on .drive_config.drives[1].uuid"
    assert result.drive_config.drives[1].dev_path == """/""", "Died on +.drive_config.drives[1].dev_path"
    assert result.drive_config.drives[1].version == """Unknown""", "Died on +.drive_config.drives[1].version"
    assert result.drive_config.drives[1].security_supported == False, "Died on +.drive_config.drives[1].security_supported"
    assert result.drive_config.drives[1].drive_type == """System""", "Died on +.drive_config.drives[1].drive_type"
    assert result.drive_config.drives[1].product == """Unknown""", "Died on +.drive_config.drives[1].product"
    assert result.drive_config.drives[1].vendor == """Unknown""", "Died on +.drive_config.drives[1].vendor"
    assert result.drive_config.drives[1].security_enabled == False, "Died on +.drive_config.drives[1].security_enabled"
    assert result.drive_config.drives[1].security_frozen == False, "Died on +.drive_config.drives[1].security_frozen"
    assert result.drive_config.drives[1].connected == False, "Died on +.drive_config.drives[1].connected"
    assert result.drive_config.drives[1].canonical_name == """/""", "Died on +.drive_config.drives[1].canonical_name"
    assert result.drive_config.drives[1].path == """/""", "Died on +.drive_config.drives[1].path"
    assert result.drive_config.drives[1].scsi_state == """Unknown""", "Died on +.drive_config.drives[1].scsi_state"
    assert result.drive_config.drives[1].scsi_compat_id == """/""", "Died on +.drive_config.drives[1].scsi_compat_id"
    assert result.drive_config.drives[1].name == """/""", "Died on +.drive_config.drives[1].name"
    assert result.drive_config.drives[1].dev == 0, "Died on +.drive_config.drives[1].dev"
    assert result.drive_config.drives[1].security_at_maximum == False, "Died on +.drive_config.drives[1].security_at_maximum"
    assert result.drive_config.drives[1].path_link == """/""", "Died on +.drive_config.drives[1].path_link"
    assert result.drive_config.drives[0].security_locked == False, "Died on +.drive_config.drives[0].security_locked"
    assert result.drive_config.drives[0].serial == """boot""", "Died on +.drive_config.drives[0].serial"
    assert result.drive_config.drives[0].size == 1024, "Died on +.drive_config.drives[0].size"
    assert result.drive_config.drives[0].slot == -2, "Died on +.drive_config.drives[0].slot"
    assert result.drive_config.drives[0].uuid == UUID("881cc415-7ed6-41a3-65a8-6452f27ed745"), "Died on .drive_config.drives[0].uuid"
    assert result.drive_config.drives[0].dev_path == """/boot""", "Died on +.drive_config.drives[0].dev_path"
    assert result.drive_config.drives[0].version == """Unknown""", "Died on +.drive_config.drives[0].version"
    assert result.drive_config.drives[0].security_supported == False, "Died on +.drive_config.drives[0].security_supported"
    assert result.drive_config.drives[0].drive_type == """System""", "Died on +.drive_config.drives[0].drive_type"
    assert result.drive_config.drives[0].product == """Unknown""", "Died on +.drive_config.drives[0].product"
    assert result.drive_config.drives[0].vendor == """Unknown""", "Died on +.drive_config.drives[0].vendor"
    assert result.drive_config.drives[0].security_enabled == False, "Died on +.drive_config.drives[0].security_enabled"
    assert result.drive_config.drives[0].security_frozen == False, "Died on +.drive_config.drives[0].security_frozen"
    assert result.drive_config.drives[0].connected == False, "Died on +.drive_config.drives[0].connected"
    assert result.drive_config.drives[0].canonical_name == """boot""", "Died on +.drive_config.drives[0].canonical_name"
    assert result.drive_config.drives[0].path == """/boot""", "Died on +.drive_config.drives[0].path"
    assert result.drive_config.drives[0].scsi_state == """Unknown""", "Died on +.drive_config.drives[0].scsi_state"
    assert result.drive_config.drives[0].scsi_compat_id == """boot""", "Died on +.drive_config.drives[0].scsi_compat_id"
    assert result.drive_config.drives[0].name == """boot""", "Died on +.drive_config.drives[0].name"
    assert result.drive_config.drives[0].dev == 0, "Died on +.drive_config.drives[0].dev"
    assert result.drive_config.drives[0].security_at_maximum == False, "Died on +.drive_config.drives[0].security_at_maximum"
    assert result.drive_config.drives[0].path_link == """/boot""", "Died on +.drive_config.drives[0].path_link"
    assert result.drive_config.num_block_actual == 1, "Died on +.drive_config.num_block_actual"
    assert result.drive_config.num_total_actual == 2, "Died on +.drive_config.num_total_actual"
    assert result.drive_config.num_block_expected == 10, "Died on +.drive_config.num_block_expected"

def test_get_drive_config_v9_2():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetDriveConfig_v9_2)

    
    result = ef.get_drive_config()
    assert result.drive_config.num_slice_actual == 1, "Died on +.drive_config.num_slice_actual"
    assert result.drive_config.num_total_expected == 11, "Died on +.drive_config.num_total_expected"
    assert result.drive_config.num_slice_expected == 1, "Died on +.drive_config.num_slice_expected"
    assert result.drive_config.drives[14].security_locked == False, "Died on +.drive_config.drives[14].security_locked"
    assert result.drive_config.drives[14].serial == """slot10""", "Died on +.drive_config.drives[14].serial"
    assert result.drive_config.drives[14].size == 0, "Died on +.drive_config.drives[14].size"
    assert result.drive_config.drives[14].slot == 10, "Died on +.drive_config.drives[14].slot"
    assert result.drive_config.drives[14].uuid == UUID("9d62ad9e-a097-d5d6-d4f7-1d27193270a1"), "Died on .drive_config.drives[14].uuid"
    assert result.drive_config.drives[14].dev_path == """/dev/slot10""", "Died on +.drive_config.drives[14].dev_path"
    assert result.drive_config.drives[14].version == """Unknown""", "Died on +.drive_config.drives[14].version"
    assert result.drive_config.drives[14].security_supported == False, "Died on +.drive_config.drives[14].security_supported"
    assert result.drive_config.drives[14].drive_type == """Block""", "Died on +.drive_config.drives[14].drive_type"
    assert result.drive_config.drives[14].product == """Unknown""", "Died on +.drive_config.drives[14].product"
    assert result.drive_config.drives[14].vendor == """Unknown""", "Died on +.drive_config.drives[14].vendor"
    assert result.drive_config.drives[14].security_enabled == False, "Died on +.drive_config.drives[14].security_enabled"
    assert result.drive_config.drives[14].security_frozen == False, "Died on +.drive_config.drives[14].security_frozen"
    assert result.drive_config.drives[14].connected == False, "Died on +.drive_config.drives[14].connected"
    assert result.drive_config.drives[14].path == """/dev/slot10""", "Died on +.drive_config.drives[14].path"
    assert result.drive_config.drives[14].scsi_state == """Unknown""", "Died on +.drive_config.drives[14].scsi_state"
    assert result.drive_config.drives[14].scsi_compat_id == """slot10""", "Died on +.drive_config.drives[14].scsi_compat_id"
    assert result.drive_config.drives[14].name == """slot10""", "Died on +.drive_config.drives[14].name"
    assert result.drive_config.drives[14].dev == 0, "Died on +.drive_config.drives[14].dev"
    assert result.drive_config.drives[14].security_at_maximum == False, "Died on +.drive_config.drives[14].security_at_maximum"
    assert result.drive_config.drives[14].path_link == """/dev/slot10""", "Died on +.drive_config.drives[14].path_link"
    assert result.drive_config.drives[13].security_locked == False, "Died on +.drive_config.drives[13].security_locked"
    assert result.drive_config.drives[13].serial == """slot9""", "Died on +.drive_config.drives[13].serial"
    assert result.drive_config.drives[13].size == 0, "Died on +.drive_config.drives[13].size"
    assert result.drive_config.drives[13].slot == 9, "Died on +.drive_config.drives[13].slot"
    assert result.drive_config.drives[13].uuid == UUID("612e2106-7032-850a-a16d-4980b53ffb23"), "Died on .drive_config.drives[13].uuid"
    assert result.drive_config.drives[13].dev_path == """/dev/slot9""", "Died on +.drive_config.drives[13].dev_path"
    assert result.drive_config.drives[13].version == """Unknown""", "Died on +.drive_config.drives[13].version"
    assert result.drive_config.drives[13].security_supported == False, "Died on +.drive_config.drives[13].security_supported"
    assert result.drive_config.drives[13].drive_type == """Block""", "Died on +.drive_config.drives[13].drive_type"
    assert result.drive_config.drives[13].product == """Unknown""", "Died on +.drive_config.drives[13].product"
    assert result.drive_config.drives[13].vendor == """Unknown""", "Died on +.drive_config.drives[13].vendor"
    assert result.drive_config.drives[13].security_enabled == False, "Died on +.drive_config.drives[13].security_enabled"
    assert result.drive_config.drives[13].security_frozen == False, "Died on +.drive_config.drives[13].security_frozen"
    assert result.drive_config.drives[13].connected == False, "Died on +.drive_config.drives[13].connected"
    assert result.drive_config.drives[13].path == """/dev/slot9""", "Died on +.drive_config.drives[13].path"
    assert result.drive_config.drives[13].scsi_state == """Unknown""", "Died on +.drive_config.drives[13].scsi_state"
    assert result.drive_config.drives[13].scsi_compat_id == """slot9""", "Died on +.drive_config.drives[13].scsi_compat_id"
    assert result.drive_config.drives[13].name == """slot9""", "Died on +.drive_config.drives[13].name"
    assert result.drive_config.drives[13].dev == 0, "Died on +.drive_config.drives[13].dev"
    assert result.drive_config.drives[13].security_at_maximum == False, "Died on +.drive_config.drives[13].security_at_maximum"
    assert result.drive_config.drives[13].path_link == """/dev/slot9""", "Died on +.drive_config.drives[13].path_link"
    assert result.drive_config.drives[12].security_locked == False, "Died on +.drive_config.drives[12].security_locked"
    assert result.drive_config.drives[12].serial == """slot8""", "Died on +.drive_config.drives[12].serial"
    assert result.drive_config.drives[12].size == 0, "Died on +.drive_config.drives[12].size"
    assert result.drive_config.drives[12].slot == 8, "Died on +.drive_config.drives[12].slot"
    assert result.drive_config.drives[12].uuid == UUID("28384068-fdee-1dae-21e3-493558121657"), "Died on .drive_config.drives[12].uuid"
    assert result.drive_config.drives[12].dev_path == """/dev/slot8""", "Died on +.drive_config.drives[12].dev_path"
    assert result.drive_config.drives[12].version == """Unknown""", "Died on +.drive_config.drives[12].version"
    assert result.drive_config.drives[12].security_supported == False, "Died on +.drive_config.drives[12].security_supported"
    assert result.drive_config.drives[12].drive_type == """Block""", "Died on +.drive_config.drives[12].drive_type"
    assert result.drive_config.drives[12].product == """Unknown""", "Died on +.drive_config.drives[12].product"
    assert result.drive_config.drives[12].vendor == """Unknown""", "Died on +.drive_config.drives[12].vendor"
    assert result.drive_config.drives[12].security_enabled == False, "Died on +.drive_config.drives[12].security_enabled"
    assert result.drive_config.drives[12].security_frozen == False, "Died on +.drive_config.drives[12].security_frozen"
    assert result.drive_config.drives[12].connected == False, "Died on +.drive_config.drives[12].connected"
    assert result.drive_config.drives[12].path == """/dev/slot8""", "Died on +.drive_config.drives[12].path"
    assert result.drive_config.drives[12].scsi_state == """Unknown""", "Died on +.drive_config.drives[12].scsi_state"
    assert result.drive_config.drives[12].scsi_compat_id == """slot8""", "Died on +.drive_config.drives[12].scsi_compat_id"
    assert result.drive_config.drives[12].name == """slot8""", "Died on +.drive_config.drives[12].name"
    assert result.drive_config.drives[12].dev == 0, "Died on +.drive_config.drives[12].dev"
    assert result.drive_config.drives[12].security_at_maximum == False, "Died on +.drive_config.drives[12].security_at_maximum"
    assert result.drive_config.drives[12].path_link == """/dev/slot8""", "Died on +.drive_config.drives[12].path_link"
    assert result.drive_config.drives[11].security_locked == False, "Died on +.drive_config.drives[11].security_locked"
    assert result.drive_config.drives[11].serial == """slot7""", "Died on +.drive_config.drives[11].serial"
    assert result.drive_config.drives[11].size == 0, "Died on +.drive_config.drives[11].size"
    assert result.drive_config.drives[11].slot == 7, "Died on +.drive_config.drives[11].slot"
    assert result.drive_config.drives[11].uuid == UUID("76c29a96-68a6-2d8e-6416-392f9fd07919"), "Died on .drive_config.drives[11].uuid"
    assert result.drive_config.drives[11].dev_path == """/dev/slot7""", "Died on +.drive_config.drives[11].dev_path"
    assert result.drive_config.drives[11].version == """Unknown""", "Died on +.drive_config.drives[11].version"
    assert result.drive_config.drives[11].security_supported == False, "Died on +.drive_config.drives[11].security_supported"
    assert result.drive_config.drives[11].drive_type == """Block""", "Died on +.drive_config.drives[11].drive_type"
    assert result.drive_config.drives[11].product == """Unknown""", "Died on +.drive_config.drives[11].product"
    assert result.drive_config.drives[11].vendor == """Unknown""", "Died on +.drive_config.drives[11].vendor"
    assert result.drive_config.drives[11].security_enabled == False, "Died on +.drive_config.drives[11].security_enabled"
    assert result.drive_config.drives[11].security_frozen == False, "Died on +.drive_config.drives[11].security_frozen"
    assert result.drive_config.drives[11].connected == False, "Died on +.drive_config.drives[11].connected"
    assert result.drive_config.drives[11].path == """/dev/slot7""", "Died on +.drive_config.drives[11].path"
    assert result.drive_config.drives[11].scsi_state == """Unknown""", "Died on +.drive_config.drives[11].scsi_state"
    assert result.drive_config.drives[11].scsi_compat_id == """slot7""", "Died on +.drive_config.drives[11].scsi_compat_id"
    assert result.drive_config.drives[11].name == """slot7""", "Died on +.drive_config.drives[11].name"
    assert result.drive_config.drives[11].dev == 0, "Died on +.drive_config.drives[11].dev"
    assert result.drive_config.drives[11].security_at_maximum == False, "Died on +.drive_config.drives[11].security_at_maximum"
    assert result.drive_config.drives[11].path_link == """/dev/slot7""", "Died on +.drive_config.drives[11].path_link"
    assert result.drive_config.drives[10].security_locked == False, "Died on +.drive_config.drives[10].security_locked"
    assert result.drive_config.drives[10].serial == """slot6""", "Died on +.drive_config.drives[10].serial"
    assert result.drive_config.drives[10].size == 0, "Died on +.drive_config.drives[10].size"
    assert result.drive_config.drives[10].slot == 6, "Died on +.drive_config.drives[10].slot"
    assert result.drive_config.drives[10].uuid == UUID("c1b04a69-49a0-fdee-b818-c6cdfafd6cd5"), "Died on .drive_config.drives[10].uuid"
    assert result.drive_config.drives[10].dev_path == """/dev/slot6""", "Died on +.drive_config.drives[10].dev_path"
    assert result.drive_config.drives[10].version == """Unknown""", "Died on +.drive_config.drives[10].version"
    assert result.drive_config.drives[10].security_supported == False, "Died on +.drive_config.drives[10].security_supported"
    assert result.drive_config.drives[10].drive_type == """Block""", "Died on +.drive_config.drives[10].drive_type"
    assert result.drive_config.drives[10].product == """Unknown""", "Died on +.drive_config.drives[10].product"
    assert result.drive_config.drives[10].vendor == """Unknown""", "Died on +.drive_config.drives[10].vendor"
    assert result.drive_config.drives[10].security_enabled == False, "Died on +.drive_config.drives[10].security_enabled"
    assert result.drive_config.drives[10].security_frozen == False, "Died on +.drive_config.drives[10].security_frozen"
    assert result.drive_config.drives[10].connected == False, "Died on +.drive_config.drives[10].connected"
    assert result.drive_config.drives[10].path == """/dev/slot6""", "Died on +.drive_config.drives[10].path"
    assert result.drive_config.drives[10].scsi_state == """Unknown""", "Died on +.drive_config.drives[10].scsi_state"
    assert result.drive_config.drives[10].scsi_compat_id == """slot6""", "Died on +.drive_config.drives[10].scsi_compat_id"
    assert result.drive_config.drives[10].name == """slot6""", "Died on +.drive_config.drives[10].name"
    assert result.drive_config.drives[10].dev == 0, "Died on +.drive_config.drives[10].dev"
    assert result.drive_config.drives[10].security_at_maximum == False, "Died on +.drive_config.drives[10].security_at_maximum"
    assert result.drive_config.drives[10].path_link == """/dev/slot6""", "Died on +.drive_config.drives[10].path_link"
    assert result.drive_config.drives[9].security_locked == False, "Died on +.drive_config.drives[9].security_locked"
    assert result.drive_config.drives[9].serial == """slot5""", "Died on +.drive_config.drives[9].serial"
    assert result.drive_config.drives[9].size == 0, "Died on +.drive_config.drives[9].size"
    assert result.drive_config.drives[9].slot == 5, "Died on +.drive_config.drives[9].slot"
    assert result.drive_config.drives[9].uuid == UUID("b31123fa-9a17-0ccd-deab-deac32a58371"), "Died on .drive_config.drives[9].uuid"
    assert result.drive_config.drives[9].dev_path == """/dev/slot5""", "Died on +.drive_config.drives[9].dev_path"
    assert result.drive_config.drives[9].version == """Unknown""", "Died on +.drive_config.drives[9].version"
    assert result.drive_config.drives[9].security_supported == False, "Died on +.drive_config.drives[9].security_supported"
    assert result.drive_config.drives[9].drive_type == """Block""", "Died on +.drive_config.drives[9].drive_type"
    assert result.drive_config.drives[9].product == """Unknown""", "Died on +.drive_config.drives[9].product"
    assert result.drive_config.drives[9].vendor == """Unknown""", "Died on +.drive_config.drives[9].vendor"
    assert result.drive_config.drives[9].security_enabled == False, "Died on +.drive_config.drives[9].security_enabled"
    assert result.drive_config.drives[9].security_frozen == False, "Died on +.drive_config.drives[9].security_frozen"
    assert result.drive_config.drives[9].connected == False, "Died on +.drive_config.drives[9].connected"
    assert result.drive_config.drives[9].path == """/dev/slot5""", "Died on +.drive_config.drives[9].path"
    assert result.drive_config.drives[9].scsi_state == """Unknown""", "Died on +.drive_config.drives[9].scsi_state"
    assert result.drive_config.drives[9].scsi_compat_id == """slot5""", "Died on +.drive_config.drives[9].scsi_compat_id"
    assert result.drive_config.drives[9].name == """slot5""", "Died on +.drive_config.drives[9].name"
    assert result.drive_config.drives[9].dev == 0, "Died on +.drive_config.drives[9].dev"
    assert result.drive_config.drives[9].security_at_maximum == False, "Died on +.drive_config.drives[9].security_at_maximum"
    assert result.drive_config.drives[9].path_link == """/dev/slot5""", "Died on +.drive_config.drives[9].path_link"
    assert result.drive_config.drives[8].security_locked == False, "Died on +.drive_config.drives[8].security_locked"
    assert result.drive_config.drives[8].serial == """slot4""", "Died on +.drive_config.drives[8].serial"
    assert result.drive_config.drives[8].size == 0, "Died on +.drive_config.drives[8].size"
    assert result.drive_config.drives[8].slot == 4, "Died on +.drive_config.drives[8].slot"
    assert result.drive_config.drives[8].uuid == UUID("76e3d13f-88c5-c334-8f0b-8486964d369e"), "Died on .drive_config.drives[8].uuid"
    assert result.drive_config.drives[8].dev_path == """/dev/slot4""", "Died on +.drive_config.drives[8].dev_path"
    assert result.drive_config.drives[8].version == """Unknown""", "Died on +.drive_config.drives[8].version"
    assert result.drive_config.drives[8].security_supported == False, "Died on +.drive_config.drives[8].security_supported"
    assert result.drive_config.drives[8].drive_type == """Block""", "Died on +.drive_config.drives[8].drive_type"
    assert result.drive_config.drives[8].product == """Unknown""", "Died on +.drive_config.drives[8].product"
    assert result.drive_config.drives[8].vendor == """Unknown""", "Died on +.drive_config.drives[8].vendor"
    assert result.drive_config.drives[8].security_enabled == False, "Died on +.drive_config.drives[8].security_enabled"
    assert result.drive_config.drives[8].security_frozen == False, "Died on +.drive_config.drives[8].security_frozen"
    assert result.drive_config.drives[8].connected == False, "Died on +.drive_config.drives[8].connected"
    assert result.drive_config.drives[8].path == """/dev/slot4""", "Died on +.drive_config.drives[8].path"
    assert result.drive_config.drives[8].scsi_state == """Unknown""", "Died on +.drive_config.drives[8].scsi_state"
    assert result.drive_config.drives[8].scsi_compat_id == """slot4""", "Died on +.drive_config.drives[8].scsi_compat_id"
    assert result.drive_config.drives[8].name == """slot4""", "Died on +.drive_config.drives[8].name"
    assert result.drive_config.drives[8].dev == 0, "Died on +.drive_config.drives[8].dev"
    assert result.drive_config.drives[8].security_at_maximum == False, "Died on +.drive_config.drives[8].security_at_maximum"
    assert result.drive_config.drives[8].path_link == """/dev/slot4""", "Died on +.drive_config.drives[8].path_link"
    assert result.drive_config.drives[7].security_locked == False, "Died on +.drive_config.drives[7].security_locked"
    assert result.drive_config.drives[7].serial == """slot3""", "Died on +.drive_config.drives[7].serial"
    assert result.drive_config.drives[7].size == 0, "Died on +.drive_config.drives[7].size"
    assert result.drive_config.drives[7].slot == 3, "Died on +.drive_config.drives[7].slot"
    assert result.drive_config.drives[7].uuid == UUID("25b903d1-3b55-d53f-a556-47b28f91b728"), "Died on .drive_config.drives[7].uuid"
    assert result.drive_config.drives[7].dev_path == """/dev/slot3""", "Died on +.drive_config.drives[7].dev_path"
    assert result.drive_config.drives[7].version == """Unknown""", "Died on +.drive_config.drives[7].version"
    assert result.drive_config.drives[7].security_supported == False, "Died on +.drive_config.drives[7].security_supported"
    assert result.drive_config.drives[7].drive_type == """Block""", "Died on +.drive_config.drives[7].drive_type"
    assert result.drive_config.drives[7].product == """Unknown""", "Died on +.drive_config.drives[7].product"
    assert result.drive_config.drives[7].vendor == """Unknown""", "Died on +.drive_config.drives[7].vendor"
    assert result.drive_config.drives[7].security_enabled == False, "Died on +.drive_config.drives[7].security_enabled"
    assert result.drive_config.drives[7].security_frozen == False, "Died on +.drive_config.drives[7].security_frozen"
    assert result.drive_config.drives[7].connected == False, "Died on +.drive_config.drives[7].connected"
    assert result.drive_config.drives[7].path == """/dev/slot3""", "Died on +.drive_config.drives[7].path"
    assert result.drive_config.drives[7].scsi_state == """Unknown""", "Died on +.drive_config.drives[7].scsi_state"
    assert result.drive_config.drives[7].scsi_compat_id == """slot3""", "Died on +.drive_config.drives[7].scsi_compat_id"
    assert result.drive_config.drives[7].name == """slot3""", "Died on +.drive_config.drives[7].name"
    assert result.drive_config.drives[7].dev == 0, "Died on +.drive_config.drives[7].dev"
    assert result.drive_config.drives[7].security_at_maximum == False, "Died on +.drive_config.drives[7].security_at_maximum"
    assert result.drive_config.drives[7].path_link == """/dev/slot3""", "Died on +.drive_config.drives[7].path_link"
    assert result.drive_config.drives[6].security_locked == False, "Died on +.drive_config.drives[6].security_locked"
    assert result.drive_config.drives[6].serial == """slot2""", "Died on +.drive_config.drives[6].serial"
    assert result.drive_config.drives[6].size == 0, "Died on +.drive_config.drives[6].size"
    assert result.drive_config.drives[6].slot == 2, "Died on +.drive_config.drives[6].slot"
    assert result.drive_config.drives[6].uuid == UUID("d92f909d-c606-4c27-d17a-4cb6db95a35c"), "Died on .drive_config.drives[6].uuid"
    assert result.drive_config.drives[6].dev_path == """/dev/slot2""", "Died on +.drive_config.drives[6].dev_path"
    assert result.drive_config.drives[6].version == """Unknown""", "Died on +.drive_config.drives[6].version"
    assert result.drive_config.drives[6].security_supported == False, "Died on +.drive_config.drives[6].security_supported"
    assert result.drive_config.drives[6].drive_type == """Block""", "Died on +.drive_config.drives[6].drive_type"
    assert result.drive_config.drives[6].product == """Unknown""", "Died on +.drive_config.drives[6].product"
    assert result.drive_config.drives[6].vendor == """Unknown""", "Died on +.drive_config.drives[6].vendor"
    assert result.drive_config.drives[6].security_enabled == False, "Died on +.drive_config.drives[6].security_enabled"
    assert result.drive_config.drives[6].security_frozen == False, "Died on +.drive_config.drives[6].security_frozen"
    assert result.drive_config.drives[6].connected == False, "Died on +.drive_config.drives[6].connected"
    assert result.drive_config.drives[6].path == """/dev/slot2""", "Died on +.drive_config.drives[6].path"
    assert result.drive_config.drives[6].scsi_state == """Unknown""", "Died on +.drive_config.drives[6].scsi_state"
    assert result.drive_config.drives[6].scsi_compat_id == """slot2""", "Died on +.drive_config.drives[6].scsi_compat_id"
    assert result.drive_config.drives[6].name == """slot2""", "Died on +.drive_config.drives[6].name"
    assert result.drive_config.drives[6].dev == 0, "Died on +.drive_config.drives[6].dev"
    assert result.drive_config.drives[6].security_at_maximum == False, "Died on +.drive_config.drives[6].security_at_maximum"
    assert result.drive_config.drives[6].path_link == """/dev/slot2""", "Died on +.drive_config.drives[6].path_link"
    assert result.drive_config.drives[5].security_locked == False, "Died on +.drive_config.drives[5].security_locked"
    assert result.drive_config.drives[5].serial == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].serial"
    assert result.drive_config.drives[5].size == 268435456000, "Died on +.drive_config.drives[5].size"
    assert result.drive_config.drives[5].slot == 1, "Died on +.drive_config.drives[5].slot"
    assert result.drive_config.drives[5].uuid == UUID("a6944a6f-46f4-addb-ba1e-4c237b5fedc5"), "Died on .drive_config.drives[5].uuid"
    assert result.drive_config.drives[5].dev_path == """/dev/slot1""", "Died on +.drive_config.drives[5].dev_path"
    assert result.drive_config.drives[5].version == """Unknown""", "Died on +.drive_config.drives[5].version"
    assert result.drive_config.drives[5].security_supported == False, "Died on +.drive_config.drives[5].security_supported"
    assert result.drive_config.drives[5].drive_type == """Block""", "Died on +.drive_config.drives[5].drive_type"
    assert result.drive_config.drives[5].product == """Unknown""", "Died on +.drive_config.drives[5].product"
    assert result.drive_config.drives[5].vendor == """Unknown""", "Died on +.drive_config.drives[5].vendor"
    assert result.drive_config.drives[5].security_enabled == False, "Died on +.drive_config.drives[5].security_enabled"
    assert result.drive_config.drives[5].security_frozen == False, "Died on +.drive_config.drives[5].security_frozen"
    assert result.drive_config.drives[5].connected == True, "Died on +.drive_config.drives[5].connected"
    assert result.drive_config.drives[5].canonical_name == """sdb""", "Died on +.drive_config.drives[5].canonical_name"
    assert result.drive_config.drives[5].path == """/dev/sdb""", "Died on +.drive_config.drives[5].path"
    assert result.drive_config.drives[5].scsi_state == """Running""", "Died on +.drive_config.drives[5].scsi_state"
    assert result.drive_config.drives[5].scsi_compat_id == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].scsi_compat_id"
    assert result.drive_config.drives[5].name == """scsi-36000c29b0d225d4342d5750a81af4ea6""", "Died on +.drive_config.drives[5].name"
    assert result.drive_config.drives[5].dev == 2064, "Died on +.drive_config.drives[5].dev"
    assert result.drive_config.drives[5].security_at_maximum == False, "Died on +.drive_config.drives[5].security_at_maximum"
    assert result.drive_config.drives[5].path_link == """/dev/slot1""", "Died on +.drive_config.drives[5].path_link"
    assert result.drive_config.drives[4].security_locked == False, "Died on +.drive_config.drives[4].security_locked"
    assert result.drive_config.drives[4].serial == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].serial"
    assert result.drive_config.drives[4].size == 216787845120, "Died on +.drive_config.drives[4].size"
    assert result.drive_config.drives[4].slot == 0, "Died on +.drive_config.drives[4].slot"
    assert result.drive_config.drives[4].uuid == UUID("38b3c943-9e45-88e9-1ebe-130b4186d8da"), "Died on .drive_config.drives[4].uuid"
    assert result.drive_config.drives[4].dev_path == """/dev/slot0p6""", "Died on +.drive_config.drives[4].dev_path"
    assert result.drive_config.drives[4].version == """Unknown""", "Died on +.drive_config.drives[4].version"
    assert result.drive_config.drives[4].security_supported == False, "Died on +.drive_config.drives[4].security_supported"
    assert result.drive_config.drives[4].drive_type == """Slice""", "Died on +.drive_config.drives[4].drive_type"
    assert result.drive_config.drives[4].product == """Unknown""", "Died on +.drive_config.drives[4].product"
    assert result.drive_config.drives[4].vendor == """Unknown""", "Died on +.drive_config.drives[4].vendor"
    assert result.drive_config.drives[4].security_enabled == False, "Died on +.drive_config.drives[4].security_enabled"
    assert result.drive_config.drives[4].security_frozen == False, "Died on +.drive_config.drives[4].security_frozen"
    assert result.drive_config.drives[4].connected == True, "Died on +.drive_config.drives[4].connected"
    assert result.drive_config.drives[4].canonical_name == """sda""", "Died on +.drive_config.drives[4].canonical_name"
    assert result.drive_config.drives[4].path == """/dev/sda6""", "Died on +.drive_config.drives[4].path"
    assert result.drive_config.drives[4].scsi_state == """Running""", "Died on +.drive_config.drives[4].scsi_state"
    assert result.drive_config.drives[4].scsi_compat_id == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].scsi_compat_id"
    assert result.drive_config.drives[4].name == """scsi-36000c29551932b43ba5bb11c3cd54c1e-part6""", "Died on +.drive_config.drives[4].name"
    assert result.drive_config.drives[4].dev == 2054, "Died on +.drive_config.drives[4].dev"
    assert result.drive_config.drives[4].security_at_maximum == False, "Died on +.drive_config.drives[4].security_at_maximum"
    assert result.drive_config.drives[4].path_link == """/dev/slot0p6""", "Died on +.drive_config.drives[4].path_link"
    assert result.drive_config.drives[3].security_locked == False, "Died on +.drive_config.drives[3].security_locked"
    assert result.drive_config.drives[3].serial == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].serial"
    assert result.drive_config.drives[3].size == 9223372036854775807, "Died on +.drive_config.drives[3].size"
    assert result.drive_config.drives[3].slot == -2, "Died on +.drive_config.drives[3].slot"
    assert result.drive_config.drives[3].uuid == UUID("00abd0dc-ff28-2825-7faa-38e9a49d66a4"), "Died on .drive_config.drives[3].uuid"
    assert result.drive_config.drives[3].dev_path == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].dev_path"
    assert result.drive_config.drives[3].version == """Unknown""", "Died on +.drive_config.drives[3].version"
    assert result.drive_config.drives[3].security_supported == False, "Died on +.drive_config.drives[3].security_supported"
    assert result.drive_config.drives[3].drive_type == """System""", "Died on +.drive_config.drives[3].drive_type"
    assert result.drive_config.drives[3].product == """Unknown""", "Died on +.drive_config.drives[3].product"
    assert result.drive_config.drives[3].vendor == """Unknown""", "Died on +.drive_config.drives[3].vendor"
    assert result.drive_config.drives[3].security_enabled == False, "Died on +.drive_config.drives[3].security_enabled"
    assert result.drive_config.drives[3].security_frozen == False, "Died on +.drive_config.drives[3].security_frozen"
    assert result.drive_config.drives[3].connected == False, "Died on +.drive_config.drives[3].connected"
    assert result.drive_config.drives[3].canonical_name == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].canonical_name"
    assert result.drive_config.drives[3].path == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].path"
    assert result.drive_config.drives[3].scsi_state == """Unknown""", "Died on +.drive_config.drives[3].scsi_state"
    assert result.drive_config.drives[3].scsi_compat_id == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].scsi_compat_id"
    assert result.drive_config.drives[3].name == """pendingDirtyBlocks""", "Died on +.drive_config.drives[3].name"
    assert result.drive_config.drives[3].dev == 0, "Died on +.drive_config.drives[3].dev"
    assert result.drive_config.drives[3].security_at_maximum == False, "Died on +.drive_config.drives[3].security_at_maximum"
    assert result.drive_config.drives[3].path_link == """/mnt/pendingDirtyBlocks""", "Died on +.drive_config.drives[3].path_link"
    assert result.drive_config.drives[2].security_locked == False, "Died on +.drive_config.drives[2].security_locked"
    assert result.drive_config.drives[2].serial == """log""", "Died on +.drive_config.drives[2].serial"
    assert result.drive_config.drives[2].size == 9223372036854775807, "Died on +.drive_config.drives[2].size"
    assert result.drive_config.drives[2].slot == -2, "Died on +.drive_config.drives[2].slot"
    assert result.drive_config.drives[2].uuid == UUID("dc1d71bb-b5c4-d2a5-e936-db79ef10c19f"), "Died on .drive_config.drives[2].uuid"
    assert result.drive_config.drives[2].dev_path == """/var/log""", "Died on +.drive_config.drives[2].dev_path"
    assert result.drive_config.drives[2].version == """Unknown""", "Died on +.drive_config.drives[2].version"
    assert result.drive_config.drives[2].security_supported == False, "Died on +.drive_config.drives[2].security_supported"
    assert result.drive_config.drives[2].drive_type == """System""", "Died on +.drive_config.drives[2].drive_type"
    assert result.drive_config.drives[2].product == """Unknown""", "Died on +.drive_config.drives[2].product"
    assert result.drive_config.drives[2].vendor == """Unknown""", "Died on +.drive_config.drives[2].vendor"
    assert result.drive_config.drives[2].security_enabled == False, "Died on +.drive_config.drives[2].security_enabled"
    assert result.drive_config.drives[2].security_frozen == False, "Died on +.drive_config.drives[2].security_frozen"
    assert result.drive_config.drives[2].connected == False, "Died on +.drive_config.drives[2].connected"
    assert result.drive_config.drives[2].canonical_name == """log""", "Died on +.drive_config.drives[2].canonical_name"
    assert result.drive_config.drives[2].path == """/var/log""", "Died on +.drive_config.drives[2].path"
    assert result.drive_config.drives[2].scsi_state == """Unknown""", "Died on +.drive_config.drives[2].scsi_state"
    assert result.drive_config.drives[2].scsi_compat_id == """log""", "Died on +.drive_config.drives[2].scsi_compat_id"
    assert result.drive_config.drives[2].name == """log""", "Died on +.drive_config.drives[2].name"
    assert result.drive_config.drives[2].dev == 0, "Died on +.drive_config.drives[2].dev"
    assert result.drive_config.drives[2].security_at_maximum == False, "Died on +.drive_config.drives[2].security_at_maximum"
    assert result.drive_config.drives[2].path_link == """/var/log""", "Died on +.drive_config.drives[2].path_link"
    assert result.drive_config.drives[1].security_locked == False, "Died on +.drive_config.drives[1].security_locked"
    assert result.drive_config.drives[1].serial == """/""", "Died on +.drive_config.drives[1].serial"
    assert result.drive_config.drives[1].size == 9223372036854775807, "Died on +.drive_config.drives[1].size"
    assert result.drive_config.drives[1].slot == -2, "Died on +.drive_config.drives[1].slot"
    assert result.drive_config.drives[1].uuid == UUID("6666cd76-f969-5646-9e7b-e39d750cc7d9"), "Died on .drive_config.drives[1].uuid"
    assert result.drive_config.drives[1].dev_path == """/""", "Died on +.drive_config.drives[1].dev_path"
    assert result.drive_config.drives[1].version == """Unknown""", "Died on +.drive_config.drives[1].version"
    assert result.drive_config.drives[1].security_supported == False, "Died on +.drive_config.drives[1].security_supported"
    assert result.drive_config.drives[1].drive_type == """System""", "Died on +.drive_config.drives[1].drive_type"
    assert result.drive_config.drives[1].product == """Unknown""", "Died on +.drive_config.drives[1].product"
    assert result.drive_config.drives[1].vendor == """Unknown""", "Died on +.drive_config.drives[1].vendor"
    assert result.drive_config.drives[1].security_enabled == False, "Died on +.drive_config.drives[1].security_enabled"
    assert result.drive_config.drives[1].security_frozen == False, "Died on +.drive_config.drives[1].security_frozen"
    assert result.drive_config.drives[1].connected == False, "Died on +.drive_config.drives[1].connected"
    assert result.drive_config.drives[1].canonical_name == """/""", "Died on +.drive_config.drives[1].canonical_name"
    assert result.drive_config.drives[1].path == """/""", "Died on +.drive_config.drives[1].path"
    assert result.drive_config.drives[1].scsi_state == """Unknown""", "Died on +.drive_config.drives[1].scsi_state"
    assert result.drive_config.drives[1].scsi_compat_id == """/""", "Died on +.drive_config.drives[1].scsi_compat_id"
    assert result.drive_config.drives[1].name == """/""", "Died on +.drive_config.drives[1].name"
    assert result.drive_config.drives[1].dev == 0, "Died on +.drive_config.drives[1].dev"
    assert result.drive_config.drives[1].security_at_maximum == False, "Died on +.drive_config.drives[1].security_at_maximum"
    assert result.drive_config.drives[1].path_link == """/""", "Died on +.drive_config.drives[1].path_link"
    assert result.drive_config.drives[0].security_locked == False, "Died on +.drive_config.drives[0].security_locked"
    assert result.drive_config.drives[0].serial == """boot""", "Died on +.drive_config.drives[0].serial"
    assert result.drive_config.drives[0].size == 1024, "Died on +.drive_config.drives[0].size"
    assert result.drive_config.drives[0].slot == -2, "Died on +.drive_config.drives[0].slot"
    assert result.drive_config.drives[0].uuid == UUID("881cc415-7ed6-41a3-65a8-6452f27ed745"), "Died on .drive_config.drives[0].uuid"
    assert result.drive_config.drives[0].dev_path == """/boot""", "Died on +.drive_config.drives[0].dev_path"
    assert result.drive_config.drives[0].version == """Unknown""", "Died on +.drive_config.drives[0].version"
    assert result.drive_config.drives[0].security_supported == False, "Died on +.drive_config.drives[0].security_supported"
    assert result.drive_config.drives[0].drive_type == """System""", "Died on +.drive_config.drives[0].drive_type"
    assert result.drive_config.drives[0].product == """Unknown""", "Died on +.drive_config.drives[0].product"
    assert result.drive_config.drives[0].vendor == """Unknown""", "Died on +.drive_config.drives[0].vendor"
    assert result.drive_config.drives[0].security_enabled == False, "Died on +.drive_config.drives[0].security_enabled"
    assert result.drive_config.drives[0].security_frozen == False, "Died on +.drive_config.drives[0].security_frozen"
    assert result.drive_config.drives[0].connected == False, "Died on +.drive_config.drives[0].connected"
    assert result.drive_config.drives[0].canonical_name == """boot""", "Died on +.drive_config.drives[0].canonical_name"
    assert result.drive_config.drives[0].path == """/boot""", "Died on +.drive_config.drives[0].path"
    assert result.drive_config.drives[0].scsi_state == """Unknown""", "Died on +.drive_config.drives[0].scsi_state"
    assert result.drive_config.drives[0].scsi_compat_id == """boot""", "Died on +.drive_config.drives[0].scsi_compat_id"
    assert result.drive_config.drives[0].name == """boot""", "Died on +.drive_config.drives[0].name"
    assert result.drive_config.drives[0].dev == 0, "Died on +.drive_config.drives[0].dev"
    assert result.drive_config.drives[0].security_at_maximum == False, "Died on +.drive_config.drives[0].security_at_maximum"
    assert result.drive_config.drives[0].path_link == """/boot""", "Died on +.drive_config.drives[0].path_link"
    assert result.drive_config.num_block_actual == 1, "Died on +.drive_config.num_block_actual"
    assert result.drive_config.num_total_actual == 2, "Died on +.drive_config.num_total_actual"
    assert result.drive_config.num_block_expected == 10, "Died on +.drive_config.num_block_expected"

def test_get_feature_status_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetFeatureStatus_v9_0)

    
    feature = "" # feature
    result = ef.get_feature_status()
    assert result.features[0].enabled == True, "Died on +.features[0].enabled"
    assert result.features[0].feature == """Vvols""", "Died on +.features[0].feature"

def test_get_hardware_config_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetHardwareConfig_v9_0)

    
    result = ef.get_hardware_config()
    assert type(result.hardware_config) is dict, "Died on .hardware_config"

def test_get_hardware_info_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetHardwareInfo_v9_0)

    
    result = ef.get_hardware_info()
    assert type(result.hardware_info) is dict, "Died on .hardware_info"

def test_get_hardware_info_v9_1():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetHardwareInfo_v9_1)

    
    result = ef.get_hardware_info()
    assert type(result.hardware_info) is dict, "Died on .hardware_info"

def test_get_hardware_info_v9_2():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetHardwareInfo_v9_2)

    
    result = ef.get_hardware_info()
    assert type(result.hardware_info) is dict, "Died on .hardware_info"

def test_get_hardware_info_v9_3():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetHardwareInfo_v9_3)

    
    result = ef.get_hardware_info()
    assert type(result.hardware_info) is dict, "Died on .hardware_info"

def test_get_ipmi_config_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetIpmiConfig_v9_0)

    
    chassis_type = "" # chassis_type
    force = True # force
    result = ef.get_ipmi_config(force,)
    assert type(result.nodes[3].result) is dict, "Died on .nodes[3].result"
    assert result.nodes[3].node_id == 4, "Died on +.nodes[3].node_id"
    assert type(result.nodes[2].result) is dict, "Died on .nodes[2].result"
    assert result.nodes[2].node_id == 3, "Died on +.nodes[2].node_id"
    assert type(result.nodes[1].result) is dict, "Died on .nodes[1].result"
    assert result.nodes[1].node_id == 2, "Died on +.nodes[1].node_id"
    assert type(result.nodes[0].result) is dict, "Died on .nodes[0].result"
    assert result.nodes[0].node_id == 1, "Died on +.nodes[0].node_id"

def test_get_ipmi_config_v9_1():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetIpmiConfig_v9_1)

    
    chassis_type = "" # chassis_type
    force = True # force
    result = ef.get_ipmi_config(force,)
    assert type(result.nodes[0].result) is dict, "Died on .nodes[0].result"
    assert result.nodes[0].node_id == 1, "Died on +.nodes[0].node_id"

def test_get_ipmi_info_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetIpmiInfo_v9_0)

    
    force = True # force
    result = ef.get_ipmi_info(force,)
    assert type(result.nodes[3].result.ipmi_info.sensors[138]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[138]"
    assert type(result.nodes[3].result.ipmi_info.sensors[137]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[137]"
    assert type(result.nodes[3].result.ipmi_info.sensors[136]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[136]"
    assert type(result.nodes[3].result.ipmi_info.sensors[135]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[135]"
    assert type(result.nodes[3].result.ipmi_info.sensors[134]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[134]"
    assert type(result.nodes[3].result.ipmi_info.sensors[133]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[133]"
    assert type(result.nodes[3].result.ipmi_info.sensors[132]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[132]"
    assert type(result.nodes[3].result.ipmi_info.sensors[131]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[131]"
    assert type(result.nodes[3].result.ipmi_info.sensors[130]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[130]"
    assert type(result.nodes[3].result.ipmi_info.sensors[129]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[129]"
    assert type(result.nodes[3].result.ipmi_info.sensors[128]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[128]"
    assert type(result.nodes[3].result.ipmi_info.sensors[127]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[127]"
    assert type(result.nodes[3].result.ipmi_info.sensors[126]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[126]"
    assert type(result.nodes[3].result.ipmi_info.sensors[125]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[125]"
    assert type(result.nodes[3].result.ipmi_info.sensors[124]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[124]"
    assert type(result.nodes[3].result.ipmi_info.sensors[123]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[123]"
    assert type(result.nodes[3].result.ipmi_info.sensors[122]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[122]"
    assert type(result.nodes[3].result.ipmi_info.sensors[121]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[121]"
    assert type(result.nodes[3].result.ipmi_info.sensors[120]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[120]"
    assert type(result.nodes[3].result.ipmi_info.sensors[119]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[119]"
    assert type(result.nodes[3].result.ipmi_info.sensors[118]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[118]"
    assert type(result.nodes[3].result.ipmi_info.sensors[117]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[117]"
    assert type(result.nodes[3].result.ipmi_info.sensors[116]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[116]"
    assert type(result.nodes[3].result.ipmi_info.sensors[115]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[115]"
    assert type(result.nodes[3].result.ipmi_info.sensors[114]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[114]"
    assert type(result.nodes[3].result.ipmi_info.sensors[113]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[113]"
    assert type(result.nodes[3].result.ipmi_info.sensors[112]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[112]"
    assert type(result.nodes[3].result.ipmi_info.sensors[111]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[111]"
    assert type(result.nodes[3].result.ipmi_info.sensors[110]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[110]"
    assert type(result.nodes[3].result.ipmi_info.sensors[109]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[109]"
    assert type(result.nodes[3].result.ipmi_info.sensors[108]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[108]"
    assert type(result.nodes[3].result.ipmi_info.sensors[107]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[107]"
    assert type(result.nodes[3].result.ipmi_info.sensors[106]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[106]"
    assert type(result.nodes[3].result.ipmi_info.sensors[105]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[105]"
    assert type(result.nodes[3].result.ipmi_info.sensors[104]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[104]"
    assert type(result.nodes[3].result.ipmi_info.sensors[103]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[103]"
    assert type(result.nodes[3].result.ipmi_info.sensors[102]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[102]"
    assert type(result.nodes[3].result.ipmi_info.sensors[101]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[101]"
    assert type(result.nodes[3].result.ipmi_info.sensors[100]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[100]"
    assert type(result.nodes[3].result.ipmi_info.sensors[99]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[99]"
    assert type(result.nodes[3].result.ipmi_info.sensors[98]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[98]"
    assert type(result.nodes[3].result.ipmi_info.sensors[97]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[97]"
    assert type(result.nodes[3].result.ipmi_info.sensors[96]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[96]"
    assert type(result.nodes[3].result.ipmi_info.sensors[95]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[95]"
    assert type(result.nodes[3].result.ipmi_info.sensors[94]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[94]"
    assert type(result.nodes[3].result.ipmi_info.sensors[93]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[93]"
    assert type(result.nodes[3].result.ipmi_info.sensors[92]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[92]"
    assert type(result.nodes[3].result.ipmi_info.sensors[91]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[91]"
    assert type(result.nodes[3].result.ipmi_info.sensors[90]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[90]"
    assert type(result.nodes[3].result.ipmi_info.sensors[89]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[89]"
    assert type(result.nodes[3].result.ipmi_info.sensors[88]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[88]"
    assert type(result.nodes[3].result.ipmi_info.sensors[87]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[87]"
    assert type(result.nodes[3].result.ipmi_info.sensors[86]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[86]"
    assert type(result.nodes[3].result.ipmi_info.sensors[85]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[85]"
    assert type(result.nodes[3].result.ipmi_info.sensors[84]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[84]"
    assert type(result.nodes[3].result.ipmi_info.sensors[83]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[83]"
    assert type(result.nodes[3].result.ipmi_info.sensors[82]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[82]"
    assert type(result.nodes[3].result.ipmi_info.sensors[81]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[81]"
    assert type(result.nodes[3].result.ipmi_info.sensors[80]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[80]"
    assert type(result.nodes[3].result.ipmi_info.sensors[79]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[79]"
    assert type(result.nodes[3].result.ipmi_info.sensors[78]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[78]"
    assert type(result.nodes[3].result.ipmi_info.sensors[77]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[77]"
    assert type(result.nodes[3].result.ipmi_info.sensors[76]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[76]"
    assert type(result.nodes[3].result.ipmi_info.sensors[75]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[75]"
    assert type(result.nodes[3].result.ipmi_info.sensors[74]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[74]"
    assert type(result.nodes[3].result.ipmi_info.sensors[73]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[73]"
    assert type(result.nodes[3].result.ipmi_info.sensors[72]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[72]"
    assert type(result.nodes[3].result.ipmi_info.sensors[71]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[71]"
    assert type(result.nodes[3].result.ipmi_info.sensors[70]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[70]"
    assert type(result.nodes[3].result.ipmi_info.sensors[69]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[69]"
    assert type(result.nodes[3].result.ipmi_info.sensors[68]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[68]"
    assert type(result.nodes[3].result.ipmi_info.sensors[67]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[67]"
    assert type(result.nodes[3].result.ipmi_info.sensors[66]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[66]"
    assert type(result.nodes[3].result.ipmi_info.sensors[65]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[65]"
    assert type(result.nodes[3].result.ipmi_info.sensors[64]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[64]"
    assert type(result.nodes[3].result.ipmi_info.sensors[63]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[63]"
    assert type(result.nodes[3].result.ipmi_info.sensors[62]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[62]"
    assert type(result.nodes[3].result.ipmi_info.sensors[61]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[61]"
    assert type(result.nodes[3].result.ipmi_info.sensors[60]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[60]"
    assert type(result.nodes[3].result.ipmi_info.sensors[59]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[59]"
    assert type(result.nodes[3].result.ipmi_info.sensors[58]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[58]"
    assert type(result.nodes[3].result.ipmi_info.sensors[57]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[57]"
    assert type(result.nodes[3].result.ipmi_info.sensors[56]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[56]"
    assert type(result.nodes[3].result.ipmi_info.sensors[55]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[55]"
    assert type(result.nodes[3].result.ipmi_info.sensors[54]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[54]"
    assert type(result.nodes[3].result.ipmi_info.sensors[53]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[53]"
    assert type(result.nodes[3].result.ipmi_info.sensors[52]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[52]"
    assert type(result.nodes[3].result.ipmi_info.sensors[51]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[51]"
    assert type(result.nodes[3].result.ipmi_info.sensors[50]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[50]"
    assert type(result.nodes[3].result.ipmi_info.sensors[49]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[49]"
    assert type(result.nodes[3].result.ipmi_info.sensors[48]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[48]"
    assert type(result.nodes[3].result.ipmi_info.sensors[47]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[47]"
    assert type(result.nodes[3].result.ipmi_info.sensors[46]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[46]"
    assert type(result.nodes[3].result.ipmi_info.sensors[45]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[45]"
    assert type(result.nodes[3].result.ipmi_info.sensors[44]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[44]"
    assert type(result.nodes[3].result.ipmi_info.sensors[43]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[43]"
    assert type(result.nodes[3].result.ipmi_info.sensors[42]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[42]"
    assert type(result.nodes[3].result.ipmi_info.sensors[41]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[41]"
    assert type(result.nodes[3].result.ipmi_info.sensors[40]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[40]"
    assert type(result.nodes[3].result.ipmi_info.sensors[39]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[39]"
    assert type(result.nodes[3].result.ipmi_info.sensors[38]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[38]"
    assert type(result.nodes[3].result.ipmi_info.sensors[37]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[37]"
    assert type(result.nodes[3].result.ipmi_info.sensors[36]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[36]"
    assert type(result.nodes[3].result.ipmi_info.sensors[35]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[35]"
    assert type(result.nodes[3].result.ipmi_info.sensors[34]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[34]"
    assert type(result.nodes[3].result.ipmi_info.sensors[33]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[33]"
    assert type(result.nodes[3].result.ipmi_info.sensors[32]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[32]"
    assert type(result.nodes[3].result.ipmi_info.sensors[31]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[31]"
    assert type(result.nodes[3].result.ipmi_info.sensors[30]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[30]"
    assert type(result.nodes[3].result.ipmi_info.sensors[29]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[29]"
    assert type(result.nodes[3].result.ipmi_info.sensors[28]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[28]"
    assert type(result.nodes[3].result.ipmi_info.sensors[27]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[27]"
    assert type(result.nodes[3].result.ipmi_info.sensors[26]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[26]"
    assert type(result.nodes[3].result.ipmi_info.sensors[25]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[25]"
    assert type(result.nodes[3].result.ipmi_info.sensors[24]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[24]"
    assert type(result.nodes[3].result.ipmi_info.sensors[23]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[23]"
    assert type(result.nodes[3].result.ipmi_info.sensors[22]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[22]"
    assert type(result.nodes[3].result.ipmi_info.sensors[21]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[21]"
    assert type(result.nodes[3].result.ipmi_info.sensors[20]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[20]"
    assert type(result.nodes[3].result.ipmi_info.sensors[19]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[19]"
    assert type(result.nodes[3].result.ipmi_info.sensors[18]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[18]"
    assert type(result.nodes[3].result.ipmi_info.sensors[17]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[17]"
    assert type(result.nodes[3].result.ipmi_info.sensors[16]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[16]"
    assert type(result.nodes[3].result.ipmi_info.sensors[15]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[15]"
    assert type(result.nodes[3].result.ipmi_info.sensors[14]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[14]"
    assert type(result.nodes[3].result.ipmi_info.sensors[13]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[13]"
    assert type(result.nodes[3].result.ipmi_info.sensors[12]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[12]"
    assert type(result.nodes[3].result.ipmi_info.sensors[11]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[11]"
    assert type(result.nodes[3].result.ipmi_info.sensors[10]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[10]"
    assert type(result.nodes[3].result.ipmi_info.sensors[9]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[9]"
    assert type(result.nodes[3].result.ipmi_info.sensors[8]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[8]"
    assert type(result.nodes[3].result.ipmi_info.sensors[7]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[7]"
    assert type(result.nodes[3].result.ipmi_info.sensors[6]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[6]"
    assert type(result.nodes[3].result.ipmi_info.sensors[5]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[5]"
    assert type(result.nodes[3].result.ipmi_info.sensors[4]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[4]"
    assert type(result.nodes[3].result.ipmi_info.sensors[3]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[3]"
    assert type(result.nodes[3].result.ipmi_info.sensors[2]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[2]"
    assert type(result.nodes[3].result.ipmi_info.sensors[1]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[1]"
    assert type(result.nodes[3].result.ipmi_info.sensors[0]) is dict, "Died on .nodes[3].result.ipmi_info.sensors[0]"
    assert result.nodes[3].node_id == 4, "Died on +.nodes[3].node_id"
    assert type(result.nodes[2].result.ipmi_info.sensors[134]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[134]"
    assert type(result.nodes[2].result.ipmi_info.sensors[133]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[133]"
    assert type(result.nodes[2].result.ipmi_info.sensors[132]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[132]"
    assert type(result.nodes[2].result.ipmi_info.sensors[131]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[131]"
    assert type(result.nodes[2].result.ipmi_info.sensors[130]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[130]"
    assert type(result.nodes[2].result.ipmi_info.sensors[129]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[129]"
    assert type(result.nodes[2].result.ipmi_info.sensors[128]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[128]"
    assert type(result.nodes[2].result.ipmi_info.sensors[127]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[127]"
    assert type(result.nodes[2].result.ipmi_info.sensors[126]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[126]"
    assert type(result.nodes[2].result.ipmi_info.sensors[125]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[125]"
    assert type(result.nodes[2].result.ipmi_info.sensors[124]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[124]"
    assert type(result.nodes[2].result.ipmi_info.sensors[123]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[123]"
    assert type(result.nodes[2].result.ipmi_info.sensors[122]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[122]"
    assert type(result.nodes[2].result.ipmi_info.sensors[121]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[121]"
    assert type(result.nodes[2].result.ipmi_info.sensors[120]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[120]"
    assert type(result.nodes[2].result.ipmi_info.sensors[119]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[119]"
    assert type(result.nodes[2].result.ipmi_info.sensors[118]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[118]"
    assert type(result.nodes[2].result.ipmi_info.sensors[117]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[117]"
    assert type(result.nodes[2].result.ipmi_info.sensors[116]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[116]"
    assert type(result.nodes[2].result.ipmi_info.sensors[115]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[115]"
    assert type(result.nodes[2].result.ipmi_info.sensors[114]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[114]"
    assert type(result.nodes[2].result.ipmi_info.sensors[113]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[113]"
    assert type(result.nodes[2].result.ipmi_info.sensors[112]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[112]"
    assert type(result.nodes[2].result.ipmi_info.sensors[111]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[111]"
    assert type(result.nodes[2].result.ipmi_info.sensors[110]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[110]"
    assert type(result.nodes[2].result.ipmi_info.sensors[109]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[109]"
    assert type(result.nodes[2].result.ipmi_info.sensors[108]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[108]"
    assert type(result.nodes[2].result.ipmi_info.sensors[107]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[107]"
    assert type(result.nodes[2].result.ipmi_info.sensors[106]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[106]"
    assert type(result.nodes[2].result.ipmi_info.sensors[105]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[105]"
    assert type(result.nodes[2].result.ipmi_info.sensors[104]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[104]"
    assert type(result.nodes[2].result.ipmi_info.sensors[103]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[103]"
    assert type(result.nodes[2].result.ipmi_info.sensors[102]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[102]"
    assert type(result.nodes[2].result.ipmi_info.sensors[101]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[101]"
    assert type(result.nodes[2].result.ipmi_info.sensors[100]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[100]"
    assert type(result.nodes[2].result.ipmi_info.sensors[99]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[99]"
    assert type(result.nodes[2].result.ipmi_info.sensors[98]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[98]"
    assert type(result.nodes[2].result.ipmi_info.sensors[97]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[97]"
    assert type(result.nodes[2].result.ipmi_info.sensors[96]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[96]"
    assert type(result.nodes[2].result.ipmi_info.sensors[95]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[95]"
    assert type(result.nodes[2].result.ipmi_info.sensors[94]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[94]"
    assert type(result.nodes[2].result.ipmi_info.sensors[93]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[93]"
    assert type(result.nodes[2].result.ipmi_info.sensors[92]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[92]"
    assert type(result.nodes[2].result.ipmi_info.sensors[91]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[91]"
    assert type(result.nodes[2].result.ipmi_info.sensors[90]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[90]"
    assert type(result.nodes[2].result.ipmi_info.sensors[89]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[89]"
    assert type(result.nodes[2].result.ipmi_info.sensors[88]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[88]"
    assert type(result.nodes[2].result.ipmi_info.sensors[87]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[87]"
    assert type(result.nodes[2].result.ipmi_info.sensors[86]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[86]"
    assert type(result.nodes[2].result.ipmi_info.sensors[85]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[85]"
    assert type(result.nodes[2].result.ipmi_info.sensors[84]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[84]"
    assert type(result.nodes[2].result.ipmi_info.sensors[83]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[83]"
    assert type(result.nodes[2].result.ipmi_info.sensors[82]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[82]"
    assert type(result.nodes[2].result.ipmi_info.sensors[81]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[81]"
    assert type(result.nodes[2].result.ipmi_info.sensors[80]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[80]"
    assert type(result.nodes[2].result.ipmi_info.sensors[79]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[79]"
    assert type(result.nodes[2].result.ipmi_info.sensors[78]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[78]"
    assert type(result.nodes[2].result.ipmi_info.sensors[77]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[77]"
    assert type(result.nodes[2].result.ipmi_info.sensors[76]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[76]"
    assert type(result.nodes[2].result.ipmi_info.sensors[75]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[75]"
    assert type(result.nodes[2].result.ipmi_info.sensors[74]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[74]"
    assert type(result.nodes[2].result.ipmi_info.sensors[73]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[73]"
    assert type(result.nodes[2].result.ipmi_info.sensors[72]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[72]"
    assert type(result.nodes[2].result.ipmi_info.sensors[71]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[71]"
    assert type(result.nodes[2].result.ipmi_info.sensors[70]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[70]"
    assert type(result.nodes[2].result.ipmi_info.sensors[69]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[69]"
    assert type(result.nodes[2].result.ipmi_info.sensors[68]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[68]"
    assert type(result.nodes[2].result.ipmi_info.sensors[67]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[67]"
    assert type(result.nodes[2].result.ipmi_info.sensors[66]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[66]"
    assert type(result.nodes[2].result.ipmi_info.sensors[65]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[65]"
    assert type(result.nodes[2].result.ipmi_info.sensors[64]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[64]"
    assert type(result.nodes[2].result.ipmi_info.sensors[63]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[63]"
    assert type(result.nodes[2].result.ipmi_info.sensors[62]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[62]"
    assert type(result.nodes[2].result.ipmi_info.sensors[61]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[61]"
    assert type(result.nodes[2].result.ipmi_info.sensors[60]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[60]"
    assert type(result.nodes[2].result.ipmi_info.sensors[59]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[59]"
    assert type(result.nodes[2].result.ipmi_info.sensors[58]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[58]"
    assert type(result.nodes[2].result.ipmi_info.sensors[57]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[57]"
    assert type(result.nodes[2].result.ipmi_info.sensors[56]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[56]"
    assert type(result.nodes[2].result.ipmi_info.sensors[55]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[55]"
    assert type(result.nodes[2].result.ipmi_info.sensors[54]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[54]"
    assert type(result.nodes[2].result.ipmi_info.sensors[53]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[53]"
    assert type(result.nodes[2].result.ipmi_info.sensors[52]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[52]"
    assert type(result.nodes[2].result.ipmi_info.sensors[51]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[51]"
    assert type(result.nodes[2].result.ipmi_info.sensors[50]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[50]"
    assert type(result.nodes[2].result.ipmi_info.sensors[49]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[49]"
    assert type(result.nodes[2].result.ipmi_info.sensors[48]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[48]"
    assert type(result.nodes[2].result.ipmi_info.sensors[47]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[47]"
    assert type(result.nodes[2].result.ipmi_info.sensors[46]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[46]"
    assert type(result.nodes[2].result.ipmi_info.sensors[45]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[45]"
    assert type(result.nodes[2].result.ipmi_info.sensors[44]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[44]"
    assert type(result.nodes[2].result.ipmi_info.sensors[43]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[43]"
    assert type(result.nodes[2].result.ipmi_info.sensors[42]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[42]"
    assert type(result.nodes[2].result.ipmi_info.sensors[41]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[41]"
    assert type(result.nodes[2].result.ipmi_info.sensors[40]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[40]"
    assert type(result.nodes[2].result.ipmi_info.sensors[39]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[39]"
    assert type(result.nodes[2].result.ipmi_info.sensors[38]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[38]"
    assert type(result.nodes[2].result.ipmi_info.sensors[37]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[37]"
    assert type(result.nodes[2].result.ipmi_info.sensors[36]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[36]"
    assert type(result.nodes[2].result.ipmi_info.sensors[35]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[35]"
    assert type(result.nodes[2].result.ipmi_info.sensors[34]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[34]"
    assert type(result.nodes[2].result.ipmi_info.sensors[33]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[33]"
    assert type(result.nodes[2].result.ipmi_info.sensors[32]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[32]"
    assert type(result.nodes[2].result.ipmi_info.sensors[31]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[31]"
    assert type(result.nodes[2].result.ipmi_info.sensors[30]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[30]"
    assert type(result.nodes[2].result.ipmi_info.sensors[29]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[29]"
    assert type(result.nodes[2].result.ipmi_info.sensors[28]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[28]"
    assert type(result.nodes[2].result.ipmi_info.sensors[27]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[27]"
    assert type(result.nodes[2].result.ipmi_info.sensors[26]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[26]"
    assert type(result.nodes[2].result.ipmi_info.sensors[25]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[25]"
    assert type(result.nodes[2].result.ipmi_info.sensors[24]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[24]"
    assert type(result.nodes[2].result.ipmi_info.sensors[23]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[23]"
    assert type(result.nodes[2].result.ipmi_info.sensors[22]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[22]"
    assert type(result.nodes[2].result.ipmi_info.sensors[21]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[21]"
    assert type(result.nodes[2].result.ipmi_info.sensors[20]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[20]"
    assert type(result.nodes[2].result.ipmi_info.sensors[19]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[19]"
    assert type(result.nodes[2].result.ipmi_info.sensors[18]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[18]"
    assert type(result.nodes[2].result.ipmi_info.sensors[17]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[17]"
    assert type(result.nodes[2].result.ipmi_info.sensors[16]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[16]"
    assert type(result.nodes[2].result.ipmi_info.sensors[15]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[15]"
    assert type(result.nodes[2].result.ipmi_info.sensors[14]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[14]"
    assert type(result.nodes[2].result.ipmi_info.sensors[13]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[13]"
    assert type(result.nodes[2].result.ipmi_info.sensors[12]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[12]"
    assert type(result.nodes[2].result.ipmi_info.sensors[11]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[11]"
    assert type(result.nodes[2].result.ipmi_info.sensors[10]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[10]"
    assert type(result.nodes[2].result.ipmi_info.sensors[9]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[9]"
    assert type(result.nodes[2].result.ipmi_info.sensors[8]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[8]"
    assert type(result.nodes[2].result.ipmi_info.sensors[7]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[7]"
    assert type(result.nodes[2].result.ipmi_info.sensors[6]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[6]"
    assert type(result.nodes[2].result.ipmi_info.sensors[5]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[5]"
    assert type(result.nodes[2].result.ipmi_info.sensors[4]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[4]"
    assert type(result.nodes[2].result.ipmi_info.sensors[3]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[3]"
    assert type(result.nodes[2].result.ipmi_info.sensors[2]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[2]"
    assert type(result.nodes[2].result.ipmi_info.sensors[1]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[1]"
    assert type(result.nodes[2].result.ipmi_info.sensors[0]) is dict, "Died on .nodes[2].result.ipmi_info.sensors[0]"
    assert result.nodes[2].node_id == 3, "Died on +.nodes[2].node_id"
    assert type(result.nodes[1].result.ipmi_info.sensors[138]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[138]"
    assert type(result.nodes[1].result.ipmi_info.sensors[137]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[137]"
    assert type(result.nodes[1].result.ipmi_info.sensors[136]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[136]"
    assert type(result.nodes[1].result.ipmi_info.sensors[135]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[135]"
    assert type(result.nodes[1].result.ipmi_info.sensors[134]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[134]"
    assert type(result.nodes[1].result.ipmi_info.sensors[133]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[133]"
    assert type(result.nodes[1].result.ipmi_info.sensors[132]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[132]"
    assert type(result.nodes[1].result.ipmi_info.sensors[131]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[131]"
    assert type(result.nodes[1].result.ipmi_info.sensors[130]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[130]"
    assert type(result.nodes[1].result.ipmi_info.sensors[129]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[129]"
    assert type(result.nodes[1].result.ipmi_info.sensors[128]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[128]"
    assert type(result.nodes[1].result.ipmi_info.sensors[127]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[127]"
    assert type(result.nodes[1].result.ipmi_info.sensors[126]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[126]"
    assert type(result.nodes[1].result.ipmi_info.sensors[125]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[125]"
    assert type(result.nodes[1].result.ipmi_info.sensors[124]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[124]"
    assert type(result.nodes[1].result.ipmi_info.sensors[123]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[123]"
    assert type(result.nodes[1].result.ipmi_info.sensors[122]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[122]"
    assert type(result.nodes[1].result.ipmi_info.sensors[121]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[121]"
    assert type(result.nodes[1].result.ipmi_info.sensors[120]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[120]"
    assert type(result.nodes[1].result.ipmi_info.sensors[119]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[119]"
    assert type(result.nodes[1].result.ipmi_info.sensors[118]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[118]"
    assert type(result.nodes[1].result.ipmi_info.sensors[117]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[117]"
    assert type(result.nodes[1].result.ipmi_info.sensors[116]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[116]"
    assert type(result.nodes[1].result.ipmi_info.sensors[115]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[115]"
    assert type(result.nodes[1].result.ipmi_info.sensors[114]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[114]"
    assert type(result.nodes[1].result.ipmi_info.sensors[113]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[113]"
    assert type(result.nodes[1].result.ipmi_info.sensors[112]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[112]"
    assert type(result.nodes[1].result.ipmi_info.sensors[111]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[111]"
    assert type(result.nodes[1].result.ipmi_info.sensors[110]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[110]"
    assert type(result.nodes[1].result.ipmi_info.sensors[109]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[109]"
    assert type(result.nodes[1].result.ipmi_info.sensors[108]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[108]"
    assert type(result.nodes[1].result.ipmi_info.sensors[107]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[107]"
    assert type(result.nodes[1].result.ipmi_info.sensors[106]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[106]"
    assert type(result.nodes[1].result.ipmi_info.sensors[105]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[105]"
    assert type(result.nodes[1].result.ipmi_info.sensors[104]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[104]"
    assert type(result.nodes[1].result.ipmi_info.sensors[103]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[103]"
    assert type(result.nodes[1].result.ipmi_info.sensors[102]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[102]"
    assert type(result.nodes[1].result.ipmi_info.sensors[101]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[101]"
    assert type(result.nodes[1].result.ipmi_info.sensors[100]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[100]"
    assert type(result.nodes[1].result.ipmi_info.sensors[99]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[99]"
    assert type(result.nodes[1].result.ipmi_info.sensors[98]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[98]"
    assert type(result.nodes[1].result.ipmi_info.sensors[97]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[97]"
    assert type(result.nodes[1].result.ipmi_info.sensors[96]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[96]"
    assert type(result.nodes[1].result.ipmi_info.sensors[95]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[95]"
    assert type(result.nodes[1].result.ipmi_info.sensors[94]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[94]"
    assert type(result.nodes[1].result.ipmi_info.sensors[93]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[93]"
    assert type(result.nodes[1].result.ipmi_info.sensors[92]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[92]"
    assert type(result.nodes[1].result.ipmi_info.sensors[91]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[91]"
    assert type(result.nodes[1].result.ipmi_info.sensors[90]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[90]"
    assert type(result.nodes[1].result.ipmi_info.sensors[89]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[89]"
    assert type(result.nodes[1].result.ipmi_info.sensors[88]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[88]"
    assert type(result.nodes[1].result.ipmi_info.sensors[87]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[87]"
    assert type(result.nodes[1].result.ipmi_info.sensors[86]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[86]"
    assert type(result.nodes[1].result.ipmi_info.sensors[85]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[85]"
    assert type(result.nodes[1].result.ipmi_info.sensors[84]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[84]"
    assert type(result.nodes[1].result.ipmi_info.sensors[83]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[83]"
    assert type(result.nodes[1].result.ipmi_info.sensors[82]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[82]"
    assert type(result.nodes[1].result.ipmi_info.sensors[81]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[81]"
    assert type(result.nodes[1].result.ipmi_info.sensors[80]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[80]"
    assert type(result.nodes[1].result.ipmi_info.sensors[79]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[79]"
    assert type(result.nodes[1].result.ipmi_info.sensors[78]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[78]"
    assert type(result.nodes[1].result.ipmi_info.sensors[77]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[77]"
    assert type(result.nodes[1].result.ipmi_info.sensors[76]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[76]"
    assert type(result.nodes[1].result.ipmi_info.sensors[75]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[75]"
    assert type(result.nodes[1].result.ipmi_info.sensors[74]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[74]"
    assert type(result.nodes[1].result.ipmi_info.sensors[73]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[73]"
    assert type(result.nodes[1].result.ipmi_info.sensors[72]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[72]"
    assert type(result.nodes[1].result.ipmi_info.sensors[71]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[71]"
    assert type(result.nodes[1].result.ipmi_info.sensors[70]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[70]"
    assert type(result.nodes[1].result.ipmi_info.sensors[69]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[69]"
    assert type(result.nodes[1].result.ipmi_info.sensors[68]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[68]"
    assert type(result.nodes[1].result.ipmi_info.sensors[67]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[67]"
    assert type(result.nodes[1].result.ipmi_info.sensors[66]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[66]"
    assert type(result.nodes[1].result.ipmi_info.sensors[65]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[65]"
    assert type(result.nodes[1].result.ipmi_info.sensors[64]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[64]"
    assert type(result.nodes[1].result.ipmi_info.sensors[63]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[63]"
    assert type(result.nodes[1].result.ipmi_info.sensors[62]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[62]"
    assert type(result.nodes[1].result.ipmi_info.sensors[61]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[61]"
    assert type(result.nodes[1].result.ipmi_info.sensors[60]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[60]"
    assert type(result.nodes[1].result.ipmi_info.sensors[59]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[59]"
    assert type(result.nodes[1].result.ipmi_info.sensors[58]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[58]"
    assert type(result.nodes[1].result.ipmi_info.sensors[57]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[57]"
    assert type(result.nodes[1].result.ipmi_info.sensors[56]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[56]"
    assert type(result.nodes[1].result.ipmi_info.sensors[55]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[55]"
    assert type(result.nodes[1].result.ipmi_info.sensors[54]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[54]"
    assert type(result.nodes[1].result.ipmi_info.sensors[53]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[53]"
    assert type(result.nodes[1].result.ipmi_info.sensors[52]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[52]"
    assert type(result.nodes[1].result.ipmi_info.sensors[51]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[51]"
    assert type(result.nodes[1].result.ipmi_info.sensors[50]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[50]"
    assert type(result.nodes[1].result.ipmi_info.sensors[49]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[49]"
    assert type(result.nodes[1].result.ipmi_info.sensors[48]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[48]"
    assert type(result.nodes[1].result.ipmi_info.sensors[47]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[47]"
    assert type(result.nodes[1].result.ipmi_info.sensors[46]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[46]"
    assert type(result.nodes[1].result.ipmi_info.sensors[45]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[45]"
    assert type(result.nodes[1].result.ipmi_info.sensors[44]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[44]"
    assert type(result.nodes[1].result.ipmi_info.sensors[43]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[43]"
    assert type(result.nodes[1].result.ipmi_info.sensors[42]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[42]"
    assert type(result.nodes[1].result.ipmi_info.sensors[41]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[41]"
    assert type(result.nodes[1].result.ipmi_info.sensors[40]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[40]"
    assert type(result.nodes[1].result.ipmi_info.sensors[39]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[39]"
    assert type(result.nodes[1].result.ipmi_info.sensors[38]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[38]"
    assert type(result.nodes[1].result.ipmi_info.sensors[37]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[37]"
    assert type(result.nodes[1].result.ipmi_info.sensors[36]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[36]"
    assert type(result.nodes[1].result.ipmi_info.sensors[35]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[35]"
    assert type(result.nodes[1].result.ipmi_info.sensors[34]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[34]"
    assert type(result.nodes[1].result.ipmi_info.sensors[33]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[33]"
    assert type(result.nodes[1].result.ipmi_info.sensors[32]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[32]"
    assert type(result.nodes[1].result.ipmi_info.sensors[31]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[31]"
    assert type(result.nodes[1].result.ipmi_info.sensors[30]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[30]"
    assert type(result.nodes[1].result.ipmi_info.sensors[29]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[29]"
    assert type(result.nodes[1].result.ipmi_info.sensors[28]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[28]"
    assert type(result.nodes[1].result.ipmi_info.sensors[27]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[27]"
    assert type(result.nodes[1].result.ipmi_info.sensors[26]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[26]"
    assert type(result.nodes[1].result.ipmi_info.sensors[25]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[25]"
    assert type(result.nodes[1].result.ipmi_info.sensors[24]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[24]"
    assert type(result.nodes[1].result.ipmi_info.sensors[23]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[23]"
    assert type(result.nodes[1].result.ipmi_info.sensors[22]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[22]"
    assert type(result.nodes[1].result.ipmi_info.sensors[21]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[21]"
    assert type(result.nodes[1].result.ipmi_info.sensors[20]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[20]"
    assert type(result.nodes[1].result.ipmi_info.sensors[19]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[19]"
    assert type(result.nodes[1].result.ipmi_info.sensors[18]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[18]"
    assert type(result.nodes[1].result.ipmi_info.sensors[17]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[17]"
    assert type(result.nodes[1].result.ipmi_info.sensors[16]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[16]"
    assert type(result.nodes[1].result.ipmi_info.sensors[15]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[15]"
    assert type(result.nodes[1].result.ipmi_info.sensors[14]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[14]"
    assert type(result.nodes[1].result.ipmi_info.sensors[13]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[13]"
    assert type(result.nodes[1].result.ipmi_info.sensors[12]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[12]"
    assert type(result.nodes[1].result.ipmi_info.sensors[11]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[11]"
    assert type(result.nodes[1].result.ipmi_info.sensors[10]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[10]"
    assert type(result.nodes[1].result.ipmi_info.sensors[9]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[9]"
    assert type(result.nodes[1].result.ipmi_info.sensors[8]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[8]"
    assert type(result.nodes[1].result.ipmi_info.sensors[7]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[7]"
    assert type(result.nodes[1].result.ipmi_info.sensors[6]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[6]"
    assert type(result.nodes[1].result.ipmi_info.sensors[5]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[5]"
    assert type(result.nodes[1].result.ipmi_info.sensors[4]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[4]"
    assert type(result.nodes[1].result.ipmi_info.sensors[3]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[3]"
    assert type(result.nodes[1].result.ipmi_info.sensors[2]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[2]"
    assert type(result.nodes[1].result.ipmi_info.sensors[1]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[1]"
    assert type(result.nodes[1].result.ipmi_info.sensors[0]) is dict, "Died on .nodes[1].result.ipmi_info.sensors[0]"
    assert result.nodes[1].node_id == 2, "Died on +.nodes[1].node_id"
    assert type(result.nodes[0].result.ipmi_info.sensors[138]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[138]"
    assert type(result.nodes[0].result.ipmi_info.sensors[137]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[137]"
    assert type(result.nodes[0].result.ipmi_info.sensors[136]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[136]"
    assert type(result.nodes[0].result.ipmi_info.sensors[135]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[135]"
    assert type(result.nodes[0].result.ipmi_info.sensors[134]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[134]"
    assert type(result.nodes[0].result.ipmi_info.sensors[133]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[133]"
    assert type(result.nodes[0].result.ipmi_info.sensors[132]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[132]"
    assert type(result.nodes[0].result.ipmi_info.sensors[131]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[131]"
    assert type(result.nodes[0].result.ipmi_info.sensors[130]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[130]"
    assert type(result.nodes[0].result.ipmi_info.sensors[129]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[129]"
    assert type(result.nodes[0].result.ipmi_info.sensors[128]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[128]"
    assert type(result.nodes[0].result.ipmi_info.sensors[127]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[127]"
    assert type(result.nodes[0].result.ipmi_info.sensors[126]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[126]"
    assert type(result.nodes[0].result.ipmi_info.sensors[125]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[125]"
    assert type(result.nodes[0].result.ipmi_info.sensors[124]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[124]"
    assert type(result.nodes[0].result.ipmi_info.sensors[123]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[123]"
    assert type(result.nodes[0].result.ipmi_info.sensors[122]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[122]"
    assert type(result.nodes[0].result.ipmi_info.sensors[121]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[121]"
    assert type(result.nodes[0].result.ipmi_info.sensors[120]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[120]"
    assert type(result.nodes[0].result.ipmi_info.sensors[119]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[119]"
    assert type(result.nodes[0].result.ipmi_info.sensors[118]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[118]"
    assert type(result.nodes[0].result.ipmi_info.sensors[117]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[117]"
    assert type(result.nodes[0].result.ipmi_info.sensors[116]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[116]"
    assert type(result.nodes[0].result.ipmi_info.sensors[115]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[115]"
    assert type(result.nodes[0].result.ipmi_info.sensors[114]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[114]"
    assert type(result.nodes[0].result.ipmi_info.sensors[113]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[113]"
    assert type(result.nodes[0].result.ipmi_info.sensors[112]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[112]"
    assert type(result.nodes[0].result.ipmi_info.sensors[111]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[111]"
    assert type(result.nodes[0].result.ipmi_info.sensors[110]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[110]"
    assert type(result.nodes[0].result.ipmi_info.sensors[109]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[109]"
    assert type(result.nodes[0].result.ipmi_info.sensors[108]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[108]"
    assert type(result.nodes[0].result.ipmi_info.sensors[107]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[107]"
    assert type(result.nodes[0].result.ipmi_info.sensors[106]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[106]"
    assert type(result.nodes[0].result.ipmi_info.sensors[105]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[105]"
    assert type(result.nodes[0].result.ipmi_info.sensors[104]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[104]"
    assert type(result.nodes[0].result.ipmi_info.sensors[103]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[103]"
    assert type(result.nodes[0].result.ipmi_info.sensors[102]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[102]"
    assert type(result.nodes[0].result.ipmi_info.sensors[101]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[101]"
    assert type(result.nodes[0].result.ipmi_info.sensors[100]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[100]"
    assert type(result.nodes[0].result.ipmi_info.sensors[99]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[99]"
    assert type(result.nodes[0].result.ipmi_info.sensors[98]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[98]"
    assert type(result.nodes[0].result.ipmi_info.sensors[97]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[97]"
    assert type(result.nodes[0].result.ipmi_info.sensors[96]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[96]"
    assert type(result.nodes[0].result.ipmi_info.sensors[95]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[95]"
    assert type(result.nodes[0].result.ipmi_info.sensors[94]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[94]"
    assert type(result.nodes[0].result.ipmi_info.sensors[93]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[93]"
    assert type(result.nodes[0].result.ipmi_info.sensors[92]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[92]"
    assert type(result.nodes[0].result.ipmi_info.sensors[91]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[91]"
    assert type(result.nodes[0].result.ipmi_info.sensors[90]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[90]"
    assert type(result.nodes[0].result.ipmi_info.sensors[89]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[89]"
    assert type(result.nodes[0].result.ipmi_info.sensors[88]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[88]"
    assert type(result.nodes[0].result.ipmi_info.sensors[87]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[87]"
    assert type(result.nodes[0].result.ipmi_info.sensors[86]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[86]"
    assert type(result.nodes[0].result.ipmi_info.sensors[85]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[85]"
    assert type(result.nodes[0].result.ipmi_info.sensors[84]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[84]"
    assert type(result.nodes[0].result.ipmi_info.sensors[83]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[83]"
    assert type(result.nodes[0].result.ipmi_info.sensors[82]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[82]"
    assert type(result.nodes[0].result.ipmi_info.sensors[81]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[81]"
    assert type(result.nodes[0].result.ipmi_info.sensors[80]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[80]"
    assert type(result.nodes[0].result.ipmi_info.sensors[79]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[79]"
    assert type(result.nodes[0].result.ipmi_info.sensors[78]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[78]"
    assert type(result.nodes[0].result.ipmi_info.sensors[77]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[77]"
    assert type(result.nodes[0].result.ipmi_info.sensors[76]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[76]"
    assert type(result.nodes[0].result.ipmi_info.sensors[75]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[75]"
    assert type(result.nodes[0].result.ipmi_info.sensors[74]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[74]"
    assert type(result.nodes[0].result.ipmi_info.sensors[73]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[73]"
    assert type(result.nodes[0].result.ipmi_info.sensors[72]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[72]"
    assert type(result.nodes[0].result.ipmi_info.sensors[71]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[71]"
    assert type(result.nodes[0].result.ipmi_info.sensors[70]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[70]"
    assert type(result.nodes[0].result.ipmi_info.sensors[69]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[69]"
    assert type(result.nodes[0].result.ipmi_info.sensors[68]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[68]"
    assert type(result.nodes[0].result.ipmi_info.sensors[67]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[67]"
    assert type(result.nodes[0].result.ipmi_info.sensors[66]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[66]"
    assert type(result.nodes[0].result.ipmi_info.sensors[65]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[65]"
    assert type(result.nodes[0].result.ipmi_info.sensors[64]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[64]"
    assert type(result.nodes[0].result.ipmi_info.sensors[63]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[63]"
    assert type(result.nodes[0].result.ipmi_info.sensors[62]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[62]"
    assert type(result.nodes[0].result.ipmi_info.sensors[61]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[61]"
    assert type(result.nodes[0].result.ipmi_info.sensors[60]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[60]"
    assert type(result.nodes[0].result.ipmi_info.sensors[59]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[59]"
    assert type(result.nodes[0].result.ipmi_info.sensors[58]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[58]"
    assert type(result.nodes[0].result.ipmi_info.sensors[57]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[57]"
    assert type(result.nodes[0].result.ipmi_info.sensors[56]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[56]"
    assert type(result.nodes[0].result.ipmi_info.sensors[55]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[55]"
    assert type(result.nodes[0].result.ipmi_info.sensors[54]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[54]"
    assert type(result.nodes[0].result.ipmi_info.sensors[53]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[53]"
    assert type(result.nodes[0].result.ipmi_info.sensors[52]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[52]"
    assert type(result.nodes[0].result.ipmi_info.sensors[51]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[51]"
    assert type(result.nodes[0].result.ipmi_info.sensors[50]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[50]"
    assert type(result.nodes[0].result.ipmi_info.sensors[49]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[49]"
    assert type(result.nodes[0].result.ipmi_info.sensors[48]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[48]"
    assert type(result.nodes[0].result.ipmi_info.sensors[47]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[47]"
    assert type(result.nodes[0].result.ipmi_info.sensors[46]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[46]"
    assert type(result.nodes[0].result.ipmi_info.sensors[45]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[45]"
    assert type(result.nodes[0].result.ipmi_info.sensors[44]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[44]"
    assert type(result.nodes[0].result.ipmi_info.sensors[43]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[43]"
    assert type(result.nodes[0].result.ipmi_info.sensors[42]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[42]"
    assert type(result.nodes[0].result.ipmi_info.sensors[41]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[41]"
    assert type(result.nodes[0].result.ipmi_info.sensors[40]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[40]"
    assert type(result.nodes[0].result.ipmi_info.sensors[39]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[39]"
    assert type(result.nodes[0].result.ipmi_info.sensors[38]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[38]"
    assert type(result.nodes[0].result.ipmi_info.sensors[37]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[37]"
    assert type(result.nodes[0].result.ipmi_info.sensors[36]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[36]"
    assert type(result.nodes[0].result.ipmi_info.sensors[35]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[35]"
    assert type(result.nodes[0].result.ipmi_info.sensors[34]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[34]"
    assert type(result.nodes[0].result.ipmi_info.sensors[33]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[33]"
    assert type(result.nodes[0].result.ipmi_info.sensors[32]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[32]"
    assert type(result.nodes[0].result.ipmi_info.sensors[31]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[31]"
    assert type(result.nodes[0].result.ipmi_info.sensors[30]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[30]"
    assert type(result.nodes[0].result.ipmi_info.sensors[29]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[29]"
    assert type(result.nodes[0].result.ipmi_info.sensors[28]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[28]"
    assert type(result.nodes[0].result.ipmi_info.sensors[27]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[27]"
    assert type(result.nodes[0].result.ipmi_info.sensors[26]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[26]"
    assert type(result.nodes[0].result.ipmi_info.sensors[25]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[25]"
    assert type(result.nodes[0].result.ipmi_info.sensors[24]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[24]"
    assert type(result.nodes[0].result.ipmi_info.sensors[23]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[23]"
    assert type(result.nodes[0].result.ipmi_info.sensors[22]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[22]"
    assert type(result.nodes[0].result.ipmi_info.sensors[21]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[21]"
    assert type(result.nodes[0].result.ipmi_info.sensors[20]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[20]"
    assert type(result.nodes[0].result.ipmi_info.sensors[19]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[19]"
    assert type(result.nodes[0].result.ipmi_info.sensors[18]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[18]"
    assert type(result.nodes[0].result.ipmi_info.sensors[17]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[17]"
    assert type(result.nodes[0].result.ipmi_info.sensors[16]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[16]"
    assert type(result.nodes[0].result.ipmi_info.sensors[15]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[15]"
    assert type(result.nodes[0].result.ipmi_info.sensors[14]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[14]"
    assert type(result.nodes[0].result.ipmi_info.sensors[13]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[13]"
    assert type(result.nodes[0].result.ipmi_info.sensors[12]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[12]"
    assert type(result.nodes[0].result.ipmi_info.sensors[11]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[11]"
    assert type(result.nodes[0].result.ipmi_info.sensors[10]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[10]"
    assert type(result.nodes[0].result.ipmi_info.sensors[9]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[9]"
    assert type(result.nodes[0].result.ipmi_info.sensors[8]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[8]"
    assert type(result.nodes[0].result.ipmi_info.sensors[7]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[7]"
    assert type(result.nodes[0].result.ipmi_info.sensors[6]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[6]"
    assert type(result.nodes[0].result.ipmi_info.sensors[5]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[5]"
    assert type(result.nodes[0].result.ipmi_info.sensors[4]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[4]"
    assert type(result.nodes[0].result.ipmi_info.sensors[3]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[3]"
    assert type(result.nodes[0].result.ipmi_info.sensors[2]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[2]"
    assert type(result.nodes[0].result.ipmi_info.sensors[1]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[1]"
    assert type(result.nodes[0].result.ipmi_info.sensors[0]) is dict, "Died on .nodes[0].result.ipmi_info.sensors[0]"
    assert result.nodes[0].node_id == 1, "Died on +.nodes[0].node_id"

def test_get_limits_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetLimits_v9_0)

    
    result = ef.get_limits()
    assert result.initiator_count_max == 0, "Died on +.initiator_count_max"
    assert result.iscsi_sessions_from_fibre_channel_nodes_max == 4096, "Died on +.iscsi_sessions_from_fibre_channel_nodes_max"
    assert result.cluster_pairs_count_max == 4, "Died on +.cluster_pairs_count_max"
    assert result.volume_max_iopsmin == 100, "Died on +.volume_max_iopsmin"
    assert result.volume_size_max == 8000000491520, "Died on +.volume_size_max"
    assert result.volume_burst_iopsmax == 100000, "Died on +.volume_burst_iopsmax"
    assert result.volume_access_groups_per_volume_count_max == 4, "Died on +.volume_access_groups_per_volume_count_max"
    assert result.volumes_per_volume_access_group_count_max == 2000, "Died on +.volumes_per_volume_access_group_count_max"
    assert result.initiator_name_length_max == 224, "Died on +.initiator_name_length_max"
    assert result.volume_name_length_min == 1, "Died on +.volume_name_length_min"
    assert result.volume_min_iopsmin == 50, "Died on +.volume_min_iopsmin"
    assert result.snapshots_per_volume_max == 32, "Died on +.snapshots_per_volume_max"
    assert result.clone_jobs_per_volume_max == 2, "Died on +.clone_jobs_per_volume_max"
    assert result.volumes_per_group_snapshot_max == 32, "Died on +.volumes_per_group_snapshot_max"
    assert result.volume_max_iopsmax == 100000, "Died on +.volume_max_iopsmax"
    assert result.volume_access_groups_per_initiator_count_max == 1, "Died on +.volume_access_groups_per_initiator_count_max"
    assert result.bulk_volume_jobs_per_node_max == 8, "Died on +.bulk_volume_jobs_per_node_max"
    assert result.initiators_per_volume_access_group_count_max == 64, "Died on +.initiators_per_volume_access_group_count_max"
    assert result.volume_access_group_name_length_max == 64, "Died on +.volume_access_group_name_length_max"
    assert result.account_name_length_min == 1, "Died on +.account_name_length_min"
    assert result.volume_name_length_max == 64, "Died on +.volume_name_length_max"
    assert result.secret_length_max == 16, "Died on +.secret_length_max"
    assert result.account_count_max == 5000, "Died on +.account_count_max"
    assert result.volume_access_group_count_max == 1000, "Died on +.volume_access_group_count_max"
    assert result.secret_length_min == 12, "Died on +.secret_length_min"
    assert result.volume_access_group_lun_max == 16383, "Died on +.volume_access_group_lun_max"
    assert result.volume_access_group_name_length_min == 1, "Died on +.volume_access_group_name_length_min"
    assert result.bulk_volume_jobs_per_volume_max == 2, "Died on +.bulk_volume_jobs_per_volume_max"
    assert result.snapshot_name_length_max == 64, "Died on +.snapshot_name_length_max"
    assert result.volumes_per_account_count_max == 2000, "Died on +.volumes_per_account_count_max"
    assert result.volume_count_max == 4000, "Died on +.volume_count_max"
    assert result.volume_size_min == 1000000000, "Died on +.volume_size_min"
    assert result.initiator_alias_length_max == 224, "Died on +.initiator_alias_length_max"
    assert result.volume_burst_iopsmin == 100, "Died on +.volume_burst_iopsmin"
    assert result.volume_min_iopsmax == 15000, "Died on +.volume_min_iopsmax"
    assert result.account_name_length_max == 64, "Died on +.account_name_length_max"

def test_get_network_config_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetNetworkConfig_v9_0)

    
    result = ef.get_network_config()
    assert result.network.bond1_g.mac_address == """d4:ae:52:8a:6c:7b""", "Died on +.network.bond1_g.mac_address"
    assert result.network.bond1_g.symmetric_route_rules[3] == """ip route add default via 10.30.95.254""", "Died on +.network.bond1_g.symmetric_route_rules[3]"
    assert result.network.bond1_g.symmetric_route_rules[2] == """ip rule add from 10.30.65.161 table Bond1G""", "Died on +.network.bond1_g.symmetric_route_rules[2]"
    assert result.network.bond1_g.symmetric_route_rules[1] == """ip route add default via 10.30.95.254 dev Bond1G src 10.30.65.161 table Bond1G""", "Died on +.network.bond1_g.symmetric_route_rules[1]"
    assert result.network.bond1_g.symmetric_route_rules[0] == """ip route add 10.30.64.0/19 dev Bond1G src 10.30.65.161 table Bond1G""", "Died on +.network.bond1_g.symmetric_route_rules[0]"
    assert result.network.bond1_g.family == """inet""", "Died on +.network.bond1_g.family"
    assert result.network.bond1_g.virtual_network_tag == """1064""", "Died on +.network.bond1_g.virtual_network_tag"
    assert result.network.bond1_g._default == True, "Died on +.network.bond1_g._default"
    assert result.network.bond1_g.bond_updelay == """200""", "Died on +.network.bond1_g.bond_updelay"
    assert result.network.bond1_g.gateway == """10.30.95.254""", "Died on +.network.bond1_g.gateway"
    assert result.network.bond1_g.physical.mac_address_permanent == """00:00:00:00:00:00""", "Died on +.network.bond1_g.physical.mac_address_permanent"
    assert result.network.bond1_g.physical.mac_address == """d4:ae:52:8a:6c:7b""", "Died on +.network.bond1_g.physical.mac_address"
    assert result.network.bond1_g.physical.up_and_running == True, "Died on +.network.bond1_g.physical.up_and_running"
    assert result.network.bond1_g.physical.network == """10.30.64.0""", "Died on +.network.bond1_g.physical.network"
    assert result.network.bond1_g.physical.mtu == """1500""", "Died on +.network.bond1_g.physical.mtu"
    assert result.network.bond1_g.physical.netmask == """255.255.224.0""", "Died on +.network.bond1_g.physical.netmask"
    assert result.network.bond1_g.physical.address == """10.30.65.161""", "Died on +.network.bond1_g.physical.address"
    assert result.network.bond1_g.network == """10.30.64.0""", "Died on +.network.bond1_g.network"
    assert result.network.bond1_g.bond_miimon == """100""", "Died on +.network.bond1_g.bond_miimon"
    assert result.network.bond1_g.method == """static""", "Died on +.network.bond1_g.method"
    assert result.network.bond1_g.status == """UpAndRunning""", "Died on +.network.bond1_g.status"
    assert result.network.bond1_g.bond_fail_over_mac == """None""", "Died on +.network.bond1_g.bond_fail_over_mac"
    assert result.network.bond1_g.auto == True, "Died on +.network.bond1_g.auto"
    assert result.network.bond1_g.bond_slaves == """eth2 eth3""", "Died on +.network.bond1_g.bond_slaves"
    assert result.network.bond1_g.netmask == """255.255.224.0""", "Died on +.network.bond1_g.netmask"
    assert result.network.bond1_g.bond_mode == """ActivePassive""", "Died on +.network.bond1_g.bond_mode"
    assert result.network.bond1_g.address == """10.30.65.161""", "Died on +.network.bond1_g.address"
    assert result.network.bond1_g.mac_address_permanent == """00:00:00:00:00:00""", "Died on +.network.bond1_g.mac_address_permanent"
    assert result.network.bond1_g.up_and_running == True, "Died on +.network.bond1_g.up_and_running"
    assert result.network.bond1_g.bond_downdelay == """200""", "Died on +.network.bond1_g.bond_downdelay"
    assert result.network.bond1_g.mtu == """1500""", "Died on +.network.bond1_g.mtu"
    assert result.network.bond1_g.bond_primary_reselect == """Failure""", "Died on +.network.bond1_g.bond_primary_reselect"
    assert result.network.lo.mac_address_permanent == """00:00:00:00:00:00""", "Died on +.network.lo.mac_address_permanent"
    assert result.network.lo.mac_address == """00:00:00:00:00:00""", "Died on +.network.lo.mac_address"
    assert result.network.lo.up_and_running == True, "Died on +.network.lo.up_and_running"
    assert result.network.lo.family == """inet""", "Died on +.network.lo.family"
    assert result.network.lo.auto == True, "Died on +.network.lo.auto"
    assert result.network.lo.status == """UpAndRunning""", "Died on +.network.lo.status"
    assert result.network.lo.method == """loopback""", "Died on +.network.lo.method"
    assert result.network.lo.physical.mac_address_permanent == """00:00:00:00:00:00""", "Died on +.network.lo.physical.mac_address_permanent"
    assert result.network.lo.physical.mac_address == """00:00:00:00:00:00""", "Died on +.network.lo.physical.mac_address"
    assert result.network.lo.physical.up_and_running == True, "Died on +.network.lo.physical.up_and_running"
    assert result.network.lo.physical.network == """N/A""", "Died on +.network.lo.physical.network"
    assert result.network.lo.physical.netmask == """N/A""", "Died on +.network.lo.physical.netmask"
    assert result.network.lo.physical.address == """0.0.0.0""", "Died on +.network.lo.physical.address"
    assert result.network.bond10_g.mac_address == """d4:ae:52:8a:6c:77""", "Died on +.network.bond10_g.mac_address"
    assert result.network.bond10_g.symmetric_route_rules[2] == """ip rule add from 192.168.65.161 table Bond10G""", "Died on +.network.bond10_g.symmetric_route_rules[2]"
    assert result.network.bond10_g.symmetric_route_rules[1] == """ip route add default via 192.168.95.254 dev Bond10G src 192.168.65.161 table Bond10G""", "Died on +.network.bond10_g.symmetric_route_rules[1]"
    assert result.network.bond10_g.symmetric_route_rules[0] == """ip route add 192.168.64.0/19 dev Bond10G src 192.168.65.161 table Bond10G""", "Died on +.network.bond10_g.symmetric_route_rules[0]"
    assert result.network.bond10_g.family == """inet""", "Died on +.network.bond10_g.family"
    assert result.network.bond10_g.virtual_network_tag == """2064""", "Died on +.network.bond10_g.virtual_network_tag"
    assert result.network.bond10_g._default == False, "Died on +.network.bond10_g._default"
    assert result.network.bond10_g.bond_updelay == """200""", "Died on +.network.bond10_g.bond_updelay"
    assert result.network.bond10_g.gateway == """192.168.95.254""", "Died on +.network.bond10_g.gateway"
    assert result.network.bond10_g.physical.mac_address_permanent == """00:00:00:00:00:00""", "Died on +.network.bond10_g.physical.mac_address_permanent"
    assert result.network.bond10_g.physical.mac_address == """d4:ae:52:8a:6c:77""", "Died on +.network.bond10_g.physical.mac_address"
    assert result.network.bond10_g.physical.up_and_running == True, "Died on +.network.bond10_g.physical.up_and_running"
    assert result.network.bond10_g.physical.network == """192.168.64.0""", "Died on +.network.bond10_g.physical.network"
    assert result.network.bond10_g.physical.mtu == """9000""", "Died on +.network.bond10_g.physical.mtu"
    assert result.network.bond10_g.physical.netmask == """255.255.224.0""", "Died on +.network.bond10_g.physical.netmask"
    assert result.network.bond10_g.physical.address == """192.168.65.161""", "Died on +.network.bond10_g.physical.address"
    assert result.network.bond10_g.network == """192.168.64.0""", "Died on +.network.bond10_g.network"
    assert result.network.bond10_g.bond_miimon == """100""", "Died on +.network.bond10_g.bond_miimon"
    assert result.network.bond10_g.method == """static""", "Died on +.network.bond10_g.method"
    assert result.network.bond10_g.status == """UpAndRunning""", "Died on +.network.bond10_g.status"
    assert result.network.bond10_g.bond_fail_over_mac == """None""", "Died on +.network.bond10_g.bond_fail_over_mac"
    assert result.network.bond10_g.auto == True, "Died on +.network.bond10_g.auto"
    assert result.network.bond10_g.bond_slaves == """eth0 eth1""", "Died on +.network.bond10_g.bond_slaves"
    assert result.network.bond10_g.netmask == """255.255.224.0""", "Died on +.network.bond10_g.netmask"
    assert result.network.bond10_g.bond_mode == """ActivePassive""", "Died on +.network.bond10_g.bond_mode"
    assert result.network.bond10_g.address == """192.168.65.161""", "Died on +.network.bond10_g.address"
    assert result.network.bond10_g.mac_address_permanent == """00:00:00:00:00:00""", "Died on +.network.bond10_g.mac_address_permanent"
    assert result.network.bond10_g.up_and_running == True, "Died on +.network.bond10_g.up_and_running"
    assert result.network.bond10_g.bond_downdelay == """200""", "Died on +.network.bond10_g.bond_downdelay"
    assert result.network.bond10_g.mtu == """9000""", "Died on +.network.bond10_g.mtu"
    assert result.network.bond10_g.bond_primary_reselect == """Failure""", "Died on +.network.bond10_g.bond_primary_reselect"
    assert result.network.eth3.mac_address_permanent == """d4:ae:52:8a:6c:7d""", "Died on +.network.eth3.mac_address_permanent"
    assert result.network.eth3.mac_address == """d4:ae:52:8a:6c:7b""", "Died on +.network.eth3.mac_address"
    assert result.network.eth3.up_and_running == True, "Died on +.network.eth3.up_and_running"
    assert result.network.eth3.family == """inet""", "Died on +.network.eth3.family"
    assert result.network.eth3.auto == True, "Died on +.network.eth3.auto"
    assert result.network.eth3.bond_master == """Bond1G""", "Died on +.network.eth3.bond_master"
    assert result.network.eth3.status == """UpAndRunning""", "Died on +.network.eth3.status"
    assert result.network.eth3.method == """bond""", "Died on +.network.eth3.method"
    assert result.network.eth3.physical.mac_address_permanent == """d4:ae:52:8a:6c:7d""", "Died on +.network.eth3.physical.mac_address_permanent"
    assert result.network.eth3.physical.mac_address == """d4:ae:52:8a:6c:7b""", "Died on +.network.eth3.physical.mac_address"
    assert result.network.eth3.physical.up_and_running == True, "Died on +.network.eth3.physical.up_and_running"
    assert result.network.eth3.physical.network == """N/A""", "Died on +.network.eth3.physical.network"
    assert result.network.eth3.physical.netmask == """N/A""", "Died on +.network.eth3.physical.netmask"
    assert result.network.eth3.physical.address == """0.0.0.0""", "Died on +.network.eth3.physical.address"
    assert result.network.eth2.mac_address_permanent == """d4:ae:52:8a:6c:7b""", "Died on +.network.eth2.mac_address_permanent"
    assert result.network.eth2.mac_address == """d4:ae:52:8a:6c:7b""", "Died on +.network.eth2.mac_address"
    assert result.network.eth2.up_and_running == True, "Died on +.network.eth2.up_and_running"
    assert result.network.eth2.family == """inet""", "Died on +.network.eth2.family"
    assert result.network.eth2.auto == True, "Died on +.network.eth2.auto"
    assert result.network.eth2.bond_master == """Bond1G""", "Died on +.network.eth2.bond_master"
    assert result.network.eth2.status == """UpAndRunning""", "Died on +.network.eth2.status"
    assert result.network.eth2.method == """bond""", "Died on +.network.eth2.method"
    assert result.network.eth2.physical.mac_address_permanent == """d4:ae:52:8a:6c:7b""", "Died on +.network.eth2.physical.mac_address_permanent"
    assert result.network.eth2.physical.mac_address == """d4:ae:52:8a:6c:7b""", "Died on +.network.eth2.physical.mac_address"
    assert result.network.eth2.physical.up_and_running == True, "Died on +.network.eth2.physical.up_and_running"
    assert result.network.eth2.physical.network == """N/A""", "Died on +.network.eth2.physical.network"
    assert result.network.eth2.physical.netmask == """N/A""", "Died on +.network.eth2.physical.netmask"
    assert result.network.eth2.physical.address == """0.0.0.0""", "Died on +.network.eth2.physical.address"
    assert result.network.eth1.mac_address_permanent == """d4:ae:52:8a:6c:79""", "Died on +.network.eth1.mac_address_permanent"
    assert result.network.eth1.mac_address == """d4:ae:52:8a:6c:77""", "Died on +.network.eth1.mac_address"
    assert result.network.eth1.up_and_running == True, "Died on +.network.eth1.up_and_running"
    assert result.network.eth1.family == """inet""", "Died on +.network.eth1.family"
    assert result.network.eth1.auto == True, "Died on +.network.eth1.auto"
    assert result.network.eth1.bond_master == """Bond10G""", "Died on +.network.eth1.bond_master"
    assert result.network.eth1.status == """UpAndRunning""", "Died on +.network.eth1.status"
    assert result.network.eth1.method == """bond""", "Died on +.network.eth1.method"
    assert result.network.eth1.physical.mac_address_permanent == """d4:ae:52:8a:6c:79""", "Died on +.network.eth1.physical.mac_address_permanent"
    assert result.network.eth1.physical.mac_address == """d4:ae:52:8a:6c:77""", "Died on +.network.eth1.physical.mac_address"
    assert result.network.eth1.physical.up_and_running == True, "Died on +.network.eth1.physical.up_and_running"
    assert result.network.eth1.physical.network == """N/A""", "Died on +.network.eth1.physical.network"
    assert result.network.eth1.physical.netmask == """N/A""", "Died on +.network.eth1.physical.netmask"
    assert result.network.eth1.physical.address == """0.0.0.0""", "Died on +.network.eth1.physical.address"
    assert result.network.eth0.mac_address_permanent == """d4:ae:52:8a:6c:77""", "Died on +.network.eth0.mac_address_permanent"
    assert result.network.eth0.mac_address == """d4:ae:52:8a:6c:77""", "Died on +.network.eth0.mac_address"
    assert result.network.eth0.up_and_running == True, "Died on +.network.eth0.up_and_running"
    assert result.network.eth0.family == """inet""", "Died on +.network.eth0.family"
    assert result.network.eth0.auto == True, "Died on +.network.eth0.auto"
    assert result.network.eth0.bond_master == """Bond10G""", "Died on +.network.eth0.bond_master"
    assert result.network.eth0.status == """UpAndRunning""", "Died on +.network.eth0.status"
    assert result.network.eth0.method == """bond""", "Died on +.network.eth0.method"
    assert result.network.eth0.physical.mac_address_permanent == """d4:ae:52:8a:6c:77""", "Died on +.network.eth0.physical.mac_address_permanent"
    assert result.network.eth0.physical.mac_address == """d4:ae:52:8a:6c:77""", "Died on +.network.eth0.physical.mac_address"
    assert result.network.eth0.physical.up_and_running == True, "Died on +.network.eth0.physical.up_and_running"
    assert result.network.eth0.physical.network == """N/A""", "Died on +.network.eth0.physical.network"
    assert result.network.eth0.physical.netmask == """N/A""", "Died on +.network.eth0.physical.netmask"
    assert result.network.eth0.physical.address == """0.0.0.0""", "Died on +.network.eth0.physical.address"

def test_get_node_hardware_info_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetNodeHardwareInfo_v9_0)

    
    node_id = 42 # node_id
    result = ef.get_node_hardware_info(node_id,)
    assert type(result.node_hardware_info) is dict, "Died on .node_hardware_info"

def test_get_nvram_info_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetNvramInfo_v9_0)

    
    result = ef.get_nvram_info()
    assert type(result.nvram_info) is dict, "Died on .nvram_info"

def test_get_origin_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetOrigin_v9_0)

    
    force = True # force
    result = ef.get_origin(force,)
    assert result.nodes[3].result.origin is None, "Died on .nodes[3].result.origin"
    assert result.nodes[3].node_id == 4, "Died on +.nodes[3].node_id"
    assert result.nodes[2].result.origin.contract_quantity == 0, "Died on +.nodes[2].result.origin.contract_quantity"
    assert result.nodes[2].result.origin.contract_name == """00002265""", "Died on +.nodes[2].result.origin.contract_name"
    assert result.nodes[2].result.origin.integrator == """StackVelocity""", "Died on +.nodes[2].result.origin.integrator"
    assert result.nodes[2].result.origin.contract_type == """Master""", "Died on +.nodes[2].result.origin.contract_type"
    assert result.nodes[2].result.origin.signature.pubkey == """MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxmKgEBzyZv2jFZpucao7HT9lYuR3g/18thP/7arwflrtDauIaPaIbnsuDVWgbPKHsqBkth9XCnDF16yBOFYoJLZ+vW0kNS7Z/CiCiLlmAXIa4voeEqLsQ55IbAhjMXfrGauyUHZYunMBhUG3xDJxdrs4Rgp24VqB/oBxihleyotIX+dLpv7nd7qbVA3juLMAy7cfgxUX7mAEmPAcx3gNiNw7SBBZaeFVrNSiXv3+Zrw5wLkLH1QDWwuBRK+3yGTkzVwD5QgLw0qkRMkFobBhk96Z7CQbf4B/8zi3bhvowoyaK+4Cv/jmEjs2TS0QFW0PQHKIjyC3ckkcLaZZ2DQcLQIDAQAB""", "Died on +.nodes[2].result.origin.signature.pubkey"
    assert result.nodes[2].result.origin.signature.version == 1, "Died on +.nodes[2].result.origin.signature.version"
    assert result.nodes[2].result.origin.signature.data == """eiPNNA3TpfgO0bl+SnhjaO1ZEKJUPZJDG1PFZrbOmUu5JXfQ012Aq0RzhMSKIb8MVTgesZ/+urfzuVD9Zf1JKwnfv7h3UZLMzE7eC6rJnLNi+AgHEYvqBLLKMJ39HNj+xEOogpQmBIn5jKv7U05pk4tsQwbxv4HtoQNMEl+PdQuVdDGLD9ipU3jgAw5sHFFZ+hLq8Uk3fzUiiR7LcW2b9aAw4KEQdSj/OhCNB4/7IcKOq8YBpP3ONWb+N6jrqSfMtnD4sa7vzSX7vI0z++zBeUd6E0hJz7atonS6oAqtyT4F48giO6hBSfkqt0KLvvC1Mcgh0LQrQG+XZnQ5KWBIuQ==""", "Died on +.nodes[2].result.origin.signature.data"
    assert result.nodes[2].result.origin.location == """Memphis, Tennessee""", "Died on +.nodes[2].result.origin.location"
    assert result.nodes[2].result.origin.contract_date == """10/1/2015""", "Died on +.nodes[2].result.origin.contract_date"
    assert result.nodes[2].result.origin.organization == """none""", "Died on +.nodes[2].result.origin.organization"
    assert result.nodes[2].result.origin.type == """appliance""", "Died on +.nodes[2].result.origin.type"
    assert result.nodes[2].node_id == 3, "Died on +.nodes[2].node_id"
    assert result.nodes[1].result.origin.contract_quantity == 0, "Died on +.nodes[1].result.origin.contract_quantity"
    assert result.nodes[1].result.origin.contract_name == """00002265""", "Died on +.nodes[1].result.origin.contract_name"
    assert result.nodes[1].result.origin.integrator == """StackVelocity""", "Died on +.nodes[1].result.origin.integrator"
    assert result.nodes[1].result.origin.contract_type == """Master""", "Died on +.nodes[1].result.origin.contract_type"
    assert result.nodes[1].result.origin.signature.pubkey == """MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxmKgEBzyZv2jFZpucao7HT9lYuR3g/18thP/7arwflrtDauIaPaIbnsuDVWgbPKHsqBkth9XCnDF16yBOFYoJLZ+vW0kNS7Z/CiCiLlmAXIa4voeEqLsQ55IbAhjMXfrGauyUHZYunMBhUG3xDJxdrs4Rgp24VqB/oBxihleyotIX+dLpv7nd7qbVA3juLMAy7cfgxUX7mAEmPAcx3gNiNw7SBBZaeFVrNSiXv3+Zrw5wLkLH1QDWwuBRK+3yGTkzVwD5QgLw0qkRMkFobBhk96Z7CQbf4B/8zi3bhvowoyaK+4Cv/jmEjs2TS0QFW0PQHKIjyC3ckkcLaZZ2DQcLQIDAQAB""", "Died on +.nodes[1].result.origin.signature.pubkey"
    assert result.nodes[1].result.origin.signature.version == 1, "Died on +.nodes[1].result.origin.signature.version"
    assert result.nodes[1].result.origin.signature.data == """eiPNNA3TpfgO0bl+SnhjaO1ZEKJUPZJDG1PFZrbOmUu5JXfQ012Aq0RzhMSKIb8MVTgesZ/+urfzuVD9Zf1JKwnfv7h3UZLMzE7eC6rJnLNi+AgHEYvqBLLKMJ39HNj+xEOogpQmBIn5jKv7U05pk4tsQwbxv4HtoQNMEl+PdQuVdDGLD9ipU3jgAw5sHFFZ+hLq8Uk3fzUiiR7LcW2b9aAw4KEQdSj/OhCNB4/7IcKOq8YBpP3ONWb+N6jrqSfMtnD4sa7vzSX7vI0z++zBeUd6E0hJz7atonS6oAqtyT4F48giO6hBSfkqt0KLvvC1Mcgh0LQrQG+XZnQ5KWBIuQ==""", "Died on +.nodes[1].result.origin.signature.data"
    assert result.nodes[1].result.origin.location == """Memphis, Tennessee""", "Died on +.nodes[1].result.origin.location"
    assert result.nodes[1].result.origin.contract_date == """10/1/2015""", "Died on +.nodes[1].result.origin.contract_date"
    assert result.nodes[1].result.origin.organization == """none""", "Died on +.nodes[1].result.origin.organization"
    assert result.nodes[1].result.origin.type == """appliance""", "Died on +.nodes[1].result.origin.type"
    assert result.nodes[1].node_id == 2, "Died on +.nodes[1].node_id"
    assert result.nodes[0].result.origin.contract_quantity == 0, "Died on +.nodes[0].result.origin.contract_quantity"
    assert result.nodes[0].result.origin.contract_name == """00002265""", "Died on +.nodes[0].result.origin.contract_name"
    assert result.nodes[0].result.origin.integrator == """StackVelocity""", "Died on +.nodes[0].result.origin.integrator"
    assert result.nodes[0].result.origin.contract_type == """Master""", "Died on +.nodes[0].result.origin.contract_type"
    assert result.nodes[0].result.origin.signature.pubkey == """MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxmKgEBzyZv2jFZpucao7HT9lYuR3g/18thP/7arwflrtDauIaPaIbnsuDVWgbPKHsqBkth9XCnDF16yBOFYoJLZ+vW0kNS7Z/CiCiLlmAXIa4voeEqLsQ55IbAhjMXfrGauyUHZYunMBhUG3xDJxdrs4Rgp24VqB/oBxihleyotIX+dLpv7nd7qbVA3juLMAy7cfgxUX7mAEmPAcx3gNiNw7SBBZaeFVrNSiXv3+Zrw5wLkLH1QDWwuBRK+3yGTkzVwD5QgLw0qkRMkFobBhk96Z7CQbf4B/8zi3bhvowoyaK+4Cv/jmEjs2TS0QFW0PQHKIjyC3ckkcLaZZ2DQcLQIDAQAB""", "Died on +.nodes[0].result.origin.signature.pubkey"
    assert result.nodes[0].result.origin.signature.version == 1, "Died on +.nodes[0].result.origin.signature.version"
    assert result.nodes[0].result.origin.signature.data == """eiPNNA3TpfgO0bl+SnhjaO1ZEKJUPZJDG1PFZrbOmUu5JXfQ012Aq0RzhMSKIb8MVTgesZ/+urfzuVD9Zf1JKwnfv7h3UZLMzE7eC6rJnLNi+AgHEYvqBLLKMJ39HNj+xEOogpQmBIn5jKv7U05pk4tsQwbxv4HtoQNMEl+PdQuVdDGLD9ipU3jgAw5sHFFZ+hLq8Uk3fzUiiR7LcW2b9aAw4KEQdSj/OhCNB4/7IcKOq8YBpP3ONWb+N6jrqSfMtnD4sa7vzSX7vI0z++zBeUd6E0hJz7atonS6oAqtyT4F48giO6hBSfkqt0KLvvC1Mcgh0LQrQG+XZnQ5KWBIuQ==""", "Died on +.nodes[0].result.origin.signature.data"
    assert result.nodes[0].result.origin.location == """Memphis, Tennessee""", "Died on +.nodes[0].result.origin.location"
    assert result.nodes[0].result.origin.contract_date == """10/1/2015""", "Died on +.nodes[0].result.origin.contract_date"
    assert result.nodes[0].result.origin.organization == """none""", "Died on +.nodes[0].result.origin.organization"
    assert result.nodes[0].result.origin.type == """appliance""", "Died on +.nodes[0].result.origin.type"
    assert result.nodes[0].node_id == 1, "Died on +.nodes[0].node_id"

def test_get_storage_container_efficiency_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetStorageContainerEfficiency_v9_0)

    
    storage_container_id = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # storage_container_id
    result = ef.get_storage_container_efficiency(storage_container_id,)
    assert result.timestamp == """2016-10-14T22:41:24Z""", "Died on +.timestamp"
    assert result.thin_provisioning == 1, "Died on +.thin_provisioning"
    assert result.compression == 1, "Died on +.compression"
    assert result.deduplication == 1, "Died on +.deduplication"

def test_get_virtual_volume_count_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetVirtualVolumeCount_v9_0)

    
    result = ef.get_virtual_volume_count()
    assert result.count == 0, "Died on +.count"

def test_get_volume_count_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_GetVolumeCount_v9_0)

    
    result = ef.get_volume_count()
    assert result.count == 736, "Died on +.count"

def test_list_all_nodes_v8_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListAllNodes_v8_0)

    
    result = ef.list_all_nodes()
    assert result.nodes[0].sip == """10.117.62.22""", "Died on +.nodes[0].sip"
    assert result.nodes[0].name == """node4""", "Died on +.nodes[0].name"
    assert result.nodes[0].platform_info.node_type == """SF3010""", "Died on +.nodes[0].platform_info.node_type"
    assert result.nodes[0].platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.nodes[0].platform_info.cpu_model"
    assert result.nodes[0].platform_info.node_memory_gb == 72, "Died on +.nodes[0].platform_info.node_memory_gb"
    assert result.nodes[0].platform_info.chassis_type == """R620""", "Died on +.nodes[0].platform_info.chassis_type"
    assert result.nodes[0].cip == """10.117.62.22""", "Died on +.nodes[0].cip"
    assert result.nodes[0].sipi == """Bond10G""", "Died on +.nodes[0].sipi"
    assert result.nodes[0].node_id == 1, "Died on +.nodes[0].node_id"
    assert result.nodes[0].software_version == """8.7.0.15""", "Died on +.nodes[0].software_version"
    assert result.nodes[0].mip == """10.117.60.22""", "Died on +.nodes[0].mip"
    assert result.nodes[0].associated_master_service_id == 1, "Died on +.nodes[0].associated_master_service_id"
    assert result.nodes[0].mipi == """Bond1G""", "Died on +.nodes[0].mipi"
    assert result.nodes[0].fibre_channel_target_port_group is None, "Died on .nodes[0].fibre_channel_target_port_group"
    assert type(result.nodes[0].attributes) is dict, "Died on .nodes[0].attributes"
    assert result.nodes[0].associated_fservice_id == 0, "Died on +.nodes[0].associated_fservice_id"
    assert result.nodes[0].virtual_networks[0].virtual_network_id == 16, "Died on +.nodes[0].virtual_networks[0].virtual_network_id"
    assert result.nodes[0].virtual_networks[0].address == """10.117.41.130""", "Died on +.nodes[0].virtual_networks[0].address"
    assert result.nodes[0].cipi == """Bond10G""", "Died on +.nodes[0].cipi"
    assert result.nodes[0].uuid == UUID("4C4C4544-0032-3810-8036-B3C04F585631"), "Died on .nodes[0].uuid"

def test_list_async_results_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListAsyncResults_v9_0)

    
    async_result_types = "" # async_result_types
    result = ef.list_async_results()
    assert result.async_handles[0].async_result_id == 1, "Died on +.async_handles[0].async_result_id"
    assert result.async_handles[0].success == True, "Died on +.async_handles[0].success"
    assert result.async_handles[0].completed == True, "Died on +.async_handles[0].completed"
    assert result.async_handles[0].last_update_time == """2016-10-27T16:09:49Z""", "Died on +.async_handles[0].last_update_time"
    assert result.async_handles[0].result_type == """DriveAdd""", "Died on +.async_handles[0].result_type"
    assert type(result.async_handles[0].data) is dict, "Died on .async_handles[0].data"
    assert result.async_handles[0].create_time == """2016-10-27T16:09:29Z""", "Died on +.async_handles[0].create_time"

def test_list_drive_stats_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListDriveStats_v9_0)

    
    drives = 42 # drives
    result = ef.list_drive_stats()
    assert result.drive_stats[0].reserve_capacity_percent == 100, "Died on +.drive_stats[0].reserve_capacity_percent"
    assert result.drive_stats[0].total_capacity == 300069052416, "Died on +.drive_stats[0].total_capacity"
    assert result.drive_stats[0].write_bytes == 2462169894, "Died on +.drive_stats[0].write_bytes"
    assert result.drive_stats[0].power_on_hours == 17736, "Died on +.drive_stats[0].power_on_hours"
    assert result.drive_stats[0].failed_die_count == 0, "Died on +.drive_stats[0].failed_die_count"
    assert result.drive_stats[0].lifetime_read_bytes == 30171004403712, "Died on +.drive_stats[0].lifetime_read_bytes"
    assert result.drive_stats[0].drive_id == 22, "Died on +.drive_stats[0].drive_id"
    assert result.drive_stats[0].timestamp == """2016-03-01T00:19:24.782735Z""", "Died on +.drive_stats[0].timestamp"
    assert result.drive_stats[0].read_ops == 3624, "Died on +.drive_stats[0].read_ops"
    assert result.drive_stats[0].lifetime_write_bytes == 103464755527680, "Died on +.drive_stats[0].lifetime_write_bytes"
    assert result.drive_stats[0].used_memory == 879165440, "Died on +.drive_stats[0].used_memory"
    assert result.drive_stats[0].read_bytes == 14656542, "Died on +.drive_stats[0].read_bytes"
    assert result.drive_stats[0].life_remaining_percent == 84, "Died on +.drive_stats[0].life_remaining_percent"
    assert result.drive_stats[0].reallocated_sectors == 0, "Died on +.drive_stats[0].reallocated_sectors"
    assert result.drive_stats[0].write_ops == 608802, "Died on +.drive_stats[0].write_ops"
    assert result.drive_stats[0].used_capacity == 1783735635, "Died on +.drive_stats[0].used_capacity"
    assert type(result.errors[0]) is dict, "Died on .errors[0]"

def test_list_fibre_channel_sessions_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListFibreChannelSessions_v9_0)

    
    result = ef.list_fibre_channel_sessions()
    assert result.sessions[1].target_wwpn == """5f:47:ac:c0:00:00:00:11""", "Died on +.sessions[1].target_wwpn"
    assert result.sessions[1].service_id == 22, "Died on +.sessions[1].service_id"
    assert result.sessions[1].volume_access_group_id == 7, "Died on +.sessions[1].volume_access_group_id"
    assert result.sessions[1].initiator_wwpn == """21:00:00:0e:1e:14:af:40""", "Died on +.sessions[1].initiator_wwpn"
    assert result.sessions[1].node_id == 1, "Died on +.sessions[1].node_id"
    assert result.sessions[0].target_wwpn == """5f:47:ac:c0:00:00:00:10""", "Died on +.sessions[0].target_wwpn"
    assert result.sessions[0].service_id == 21, "Died on +.sessions[0].service_id"
    assert result.sessions[0].volume_access_group_id == 7, "Died on +.sessions[0].volume_access_group_id"
    assert result.sessions[0].initiator_wwpn == """21:00:00:0e:1e:14:af:40""", "Died on +.sessions[0].initiator_wwpn"
    assert result.sessions[0].node_id == 5, "Died on +.sessions[0].node_id"

def test_list_iscsisessions_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListISCSISessions_v9_0)

    
    result = ef.list_iscsisessions()
    assert result.sessions[1].initiator.initiator_id == 2, "Died on +.sessions[1].initiator.initiator_id"
    assert result.sessions[1].initiator.initiator_name == """iqn.2010-01.net.solidfire.eng:zdc-3""", "Died on +.sessions[1].initiator.initiator_name"
    assert result.sessions[1].initiator.volume_access_groups[0] == 1, "Died on +.sessions[1].initiator.volume_access_groups[0]"
    assert type(result.sessions[1].initiator.attributes) is dict, "Died on .sessions[1].initiator.attributes"
    assert result.sessions[1].initiator_port_name == """iqn.2010-01.net.solidfire.eng:zdc-3,i,0x23d080000""", "Died on +.sessions[1].initiator_port_name"
    assert result.sessions[1].initiator_ip == """10.30.76.3:33995""", "Died on +.sessions[1].initiator_ip"
    assert result.sessions[1].volume_instance == 139922531221504, "Died on +.sessions[1].volume_instance"
    assert result.sessions[1].initiator_session_id == 9613869056, "Died on +.sessions[1].initiator_session_id"
    assert result.sessions[1].service_id == 4, "Died on +.sessions[1].service_id"
    assert result.sessions[1].node_id == 1, "Died on +.sessions[1].node_id"
    assert result.sessions[1].account_name == """myaccount""", "Died on +.sessions[1].account_name"
    assert result.sessions[1].drive_id == 1, "Died on +.sessions[1].drive_id"
    assert result.sessions[1].session_id == 17179882018, "Died on +.sessions[1].session_id"
    assert result.sessions[1].initiator_name == """iqn.2010-01.net.solidfire.eng:zdc-3""", "Died on +.sessions[1].initiator_name"
    assert result.sessions[1].target_port_name == """iqn.2010-01.com.solidfire:dvmj.trruw982e4vr2cgf.9,t,0x1""", "Died on +.sessions[1].target_port_name"
    assert result.sessions[1].target_ip == """10.30.65.134:3260""", "Died on +.sessions[1].target_ip"
    assert result.sessions[1].virtual_network_id == 0, "Died on +.sessions[1].virtual_network_id"
    assert result.sessions[1].target_name == """iqn.2010-01.com.solidfire:dvmj.trruw982e4vr2cgf.9""", "Died on +.sessions[1].target_name"
    assert result.sessions[1].create_time == """2016-08-12T16:40:04.827831Z""", "Died on +.sessions[1].create_time"
    assert result.sessions[1].volume_id == 9, "Died on +.sessions[1].volume_id"
    assert result.sessions[1].account_id == 1, "Died on +.sessions[1].account_id"
    assert result.sessions[0].initiator.initiator_id == 2, "Died on +.sessions[0].initiator.initiator_id"
    assert result.sessions[0].initiator.initiator_name == """iqn.2010-01.net.solidfire.eng:zdc-3""", "Died on +.sessions[0].initiator.initiator_name"
    assert result.sessions[0].initiator.volume_access_groups[0] == 1, "Died on +.sessions[0].initiator.volume_access_groups[0]"
    assert type(result.sessions[0].initiator.attributes) is dict, "Died on .sessions[0].initiator.attributes"
    assert result.sessions[0].initiator_port_name == """iqn.2010-01.net.solidfire.eng:zdc-3,i,0x23d070000""", "Died on +.sessions[0].initiator_port_name"
    assert result.sessions[0].initiator_ip == """10.30.76.3:33994""", "Died on +.sessions[0].initiator_ip"
    assert result.sessions[0].volume_instance == 139922648856576, "Died on +.sessions[0].volume_instance"
    assert result.sessions[0].initiator_session_id == 9613803520, "Died on +.sessions[0].initiator_session_id"
    assert result.sessions[0].service_id == 4, "Died on +.sessions[0].service_id"
    assert result.sessions[0].node_id == 1, "Died on +.sessions[0].node_id"
    assert result.sessions[0].account_name == """myaccount""", "Died on +.sessions[0].account_name"
    assert result.sessions[0].drive_id == 1, "Died on +.sessions[0].drive_id"
    assert result.sessions[0].session_id == 17179882017, "Died on +.sessions[0].session_id"
    assert result.sessions[0].initiator_name == """iqn.2010-01.net.solidfire.eng:zdc-3""", "Died on +.sessions[0].initiator_name"
    assert result.sessions[0].target_port_name == """iqn.2010-01.com.solidfire:dvmj.aawuanfmxukfnffl.3,t,0x1""", "Died on +.sessions[0].target_port_name"
    assert result.sessions[0].target_ip == """10.30.65.134:3260""", "Died on +.sessions[0].target_ip"
    assert result.sessions[0].virtual_network_id == 0, "Died on +.sessions[0].virtual_network_id"
    assert result.sessions[0].target_name == """iqn.2010-01.com.solidfire:dvmj.aawuanfmxukfnffl.3""", "Died on +.sessions[0].target_name"
    assert result.sessions[0].create_time == """2016-08-12T16:40:04.827786Z""", "Died on +.sessions[0].create_time"
    assert result.sessions[0].volume_id == 3, "Died on +.sessions[0].volume_id"
    assert result.sessions[0].account_id == 1, "Died on +.sessions[0].account_id"

def test_list_pending_active_nodes_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListPendingActiveNodes_v9_0)

    
    result = ef.list_pending_active_nodes()
    assert result.pending_active_nodes[0].active_node_key == """5rPHP3lTAO""", "Died on +.pending_active_nodes[0].active_node_key"
    assert result.pending_active_nodes[0].sip == """10.10.5.106""", "Died on +.pending_active_nodes[0].sip"
    assert result.pending_active_nodes[0].software_version == """9.0.0.1077""", "Died on +.pending_active_nodes[0].software_version"
    assert result.pending_active_nodes[0].cip == """10.10.5.106""", "Died on +.pending_active_nodes[0].cip"
    assert result.pending_active_nodes[0].async_handle == 2, "Died on +.pending_active_nodes[0].async_handle"
    assert result.pending_active_nodes[0].platform_info.node_type == """SF3010""", "Died on +.pending_active_nodes[0].platform_info.node_type"
    assert result.pending_active_nodes[0].platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.pending_active_nodes[0].platform_info.cpu_model"
    assert result.pending_active_nodes[0].platform_info.node_memory_gb == 72, "Died on +.pending_active_nodes[0].platform_info.node_memory_gb"
    assert result.pending_active_nodes[0].platform_info.chassis_type == """R620""", "Died on +.pending_active_nodes[0].platform_info.chassis_type"
    assert result.pending_active_nodes[0].mip == """192.168.133.106""", "Died on +.pending_active_nodes[0].mip"
    assert result.pending_active_nodes[0].assigned_node_id == 5, "Died on +.pending_active_nodes[0].assigned_node_id"
    assert result.pending_active_nodes[0].pending_node_id == 1, "Died on +.pending_active_nodes[0].pending_node_id"

def test_list_protocol_endpoints_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListProtocolEndpoints_v9_0)

    
    protocol_endpoint_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # protocol_endpoint_ids
    result = ef.list_protocol_endpoints()
    assert result.protocol_endpoints[3].primary_provider_id == 3, "Died on +.protocol_endpoints[3].primary_provider_id"
    assert result.protocol_endpoints[3].protocol_endpoint_state == """Active""", "Died on +.protocol_endpoints[3].protocol_endpoint_state"
    assert result.protocol_endpoints[3].provider_type == """Primary""", "Died on +.protocol_endpoints[3].provider_type"
    assert result.protocol_endpoints[3].protocol_endpoint_id == UUID("f3e7911d-0e86-4776-97db-7468c272213f"), "Died on .protocol_endpoints[3].protocol_endpoint_id"
    assert result.protocol_endpoints[3].secondary_provider_id == 4, "Died on +.protocol_endpoints[3].secondary_provider_id"
    assert result.protocol_endpoints[3].scsi_naadevice_id == """6f47acc2000000036970687200000000""", "Died on +.protocol_endpoints[3].scsi_naadevice_id"
    assert result.protocol_endpoints[2].primary_provider_id == 4, "Died on +.protocol_endpoints[2].primary_provider_id"
    assert result.protocol_endpoints[2].protocol_endpoint_state == """Active""", "Died on +.protocol_endpoints[2].protocol_endpoint_state"
    assert result.protocol_endpoints[2].provider_type == """Primary""", "Died on +.protocol_endpoints[2].provider_type"
    assert result.protocol_endpoints[2].protocol_endpoint_id == UUID("c6458dfe-9803-4350-bb4e-68a3feb7e830"), "Died on .protocol_endpoints[2].protocol_endpoint_id"
    assert result.protocol_endpoints[2].secondary_provider_id == 1, "Died on +.protocol_endpoints[2].secondary_provider_id"
    assert result.protocol_endpoints[2].scsi_naadevice_id == """6f47acc2000000046970687200000000""", "Died on +.protocol_endpoints[2].scsi_naadevice_id"
    assert result.protocol_endpoints[1].primary_provider_id == 2, "Died on +.protocol_endpoints[1].primary_provider_id"
    assert result.protocol_endpoints[1].protocol_endpoint_state == """Active""", "Died on +.protocol_endpoints[1].protocol_endpoint_state"
    assert result.protocol_endpoints[1].provider_type == """Primary""", "Died on +.protocol_endpoints[1].provider_type"
    assert result.protocol_endpoints[1].protocol_endpoint_id == UUID("1f16ed86-3f31-4c76-b004-a1251187700b"), "Died on .protocol_endpoints[1].protocol_endpoint_id"
    assert result.protocol_endpoints[1].secondary_provider_id == 3, "Died on +.protocol_endpoints[1].secondary_provider_id"
    assert result.protocol_endpoints[1].scsi_naadevice_id == """6f47acc2000000026970687200000000""", "Died on +.protocol_endpoints[1].scsi_naadevice_id"
    assert result.protocol_endpoints[0].primary_provider_id == 1, "Died on +.protocol_endpoints[0].primary_provider_id"
    assert result.protocol_endpoints[0].protocol_endpoint_state == """Active""", "Died on +.protocol_endpoints[0].protocol_endpoint_state"
    assert result.protocol_endpoints[0].provider_type == """Primary""", "Died on +.protocol_endpoints[0].provider_type"
    assert result.protocol_endpoints[0].protocol_endpoint_id == UUID("1387e257-d2e3-4446-be6d-39db71583e7b"), "Died on .protocol_endpoints[0].protocol_endpoint_id"
    assert result.protocol_endpoints[0].secondary_provider_id == 2, "Died on +.protocol_endpoints[0].secondary_provider_id"
    assert result.protocol_endpoints[0].scsi_naadevice_id == """6f47acc2000000016970687200000000""", "Died on +.protocol_endpoints[0].scsi_naadevice_id"

def test_list_services_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListServices_v9_0)

    
    result = ef.list_services()
    assert result.services[33].node.sip == """10.117.62.25""", "Died on +.services[33].node.sip"
    assert result.services[33].node.name == """SF-F2A3""", "Died on +.services[33].node.name"
    assert result.services[33].node.platform_info.node_type == """SF3010""", "Died on +.services[33].node.platform_info.node_type"
    assert result.services[33].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[33].node.platform_info.cpu_model"
    assert result.services[33].node.platform_info.node_memory_gb == 72, "Died on +.services[33].node.platform_info.node_memory_gb"
    assert result.services[33].node.platform_info.chassis_type == """R620""", "Died on +.services[33].node.platform_info.chassis_type"
    assert result.services[33].node.cip == """10.117.62.25""", "Died on +.services[33].node.cip"
    assert result.services[33].node.sipi == """Bond10G""", "Died on +.services[33].node.sipi"
    assert result.services[33].node.node_id == 3, "Died on +.services[33].node.node_id"
    assert result.services[33].node.software_version == """9.0.0.1554""", "Died on +.services[33].node.software_version"
    assert result.services[33].node.mip == """10.117.60.25""", "Died on +.services[33].node.mip"
    assert result.services[33].node.associated_master_service_id == 4, "Died on +.services[33].node.associated_master_service_id"
    assert result.services[33].node.mipi == """Bond1G""", "Died on +.services[33].node.mipi"
    assert result.services[33].node.fibre_channel_target_port_group is None, "Died on .services[33].node.fibre_channel_target_port_group"
    assert type(result.services[33].node.attributes) is dict, "Died on .services[33].node.attributes"
    assert result.services[33].node.associated_fservice_id == 0, "Died on +.services[33].node.associated_fservice_id"
    assert result.services[33].node.cipi == """Bond10G""", "Died on +.services[33].node.cipi"
    assert result.services[33].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[33].node.uuid"
    assert result.services[33].drive.slot == 3, "Died on +.services[33].drive.slot"
    assert result.services[33].drive.capacity == 300069052416, "Died on +.services[33].drive.capacity"
    assert result.services[33].drive.node_id == 3, "Died on +.services[33].drive.node_id"
    assert result.services[33].drive.drive_id == 16, "Died on +.services[33].drive.drive_id"
    assert result.services[33].drive.customer_slice_file_capacity == 0, "Died on +.services[33].drive.customer_slice_file_capacity"
    assert result.services[33].drive.assigned_service == 21, "Died on +.services[33].drive.assigned_service"
    assert result.services[33].drive.drive_type == """block""", "Died on +.services[33].drive.drive_type"
    assert type(result.services[33].drive.attributes) is dict, "Died on .services[33].drive.attributes"
    assert result.services[33].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL311604K4300PGN""", "Died on +.services[33].drive.serial"
    assert result.services[33].drive.reserved_slice_file_capacity == 0, "Died on +.services[33].drive.reserved_slice_file_capacity"
    assert result.services[33].drive.drive_status == """assigned""", "Died on +.services[33].drive.drive_status"
    assert result.services[33].service.status == """healthy""", "Died on +.services[33].service.status"
    assert result.services[33].service.associated_bv == 0, "Died on +.services[33].service.associated_bv"
    assert result.services[33].service.associated_ts == 0, "Died on +.services[33].service.associated_ts"
    assert result.services[33].service.associated_vs == 0, "Died on +.services[33].service.associated_vs"
    assert result.services[33].service.ipc_port == 4008, "Died on +.services[33].service.ipc_port"
    assert result.services[33].service.service_type == """block""", "Died on +.services[33].service.service_type"
    assert result.services[33].service.node_id == 3, "Died on +.services[33].service.node_id"
    assert result.services[33].service.drive_id == 16, "Died on +.services[33].service.drive_id"
    assert result.services[33].service.service_id == 21, "Died on +.services[33].service.service_id"
    assert result.services[33].service.iscsi_port == 0, "Died on +.services[33].service.iscsi_port"
    assert result.services[33].service.drive_ids[0] == 16, "Died on +.services[33].service.drive_ids[0]"
    assert result.services[33].service.first_time_startup == False, "Died on +.services[33].service.first_time_startup"
    assert result.services[33].service.started_drive_ids[0] == 16, "Died on +.services[33].service.started_drive_ids[0]"
    assert result.services[33].drives[0].slot == 3, "Died on +.services[33].drives[0].slot"
    assert result.services[33].drives[0].capacity == 300069052416, "Died on +.services[33].drives[0].capacity"
    assert result.services[33].drives[0].node_id == 3, "Died on +.services[33].drives[0].node_id"
    assert result.services[33].drives[0].drive_id == 16, "Died on +.services[33].drives[0].drive_id"
    assert result.services[33].drives[0].customer_slice_file_capacity == 0, "Died on +.services[33].drives[0].customer_slice_file_capacity"
    assert result.services[33].drives[0].assigned_service == 21, "Died on +.services[33].drives[0].assigned_service"
    assert result.services[33].drives[0].drive_type == """Block""", "Died on +.services[33].drives[0].drive_type"
    assert type(result.services[33].drives[0].attributes) is dict, "Died on .services[33].drives[0].attributes"
    assert result.services[33].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL311604K4300PGN""", "Died on +.services[33].drives[0].serial"
    assert result.services[33].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[33].drives[0].reserved_slice_file_capacity"
    assert result.services[33].drives[0].drive_status == """assigned""", "Died on +.services[33].drives[0].drive_status"
    assert result.services[32].node.sip == """10.117.62.26""", "Died on +.services[32].node.sip"
    assert result.services[32].node.name == """SF-1713""", "Died on +.services[32].node.name"
    assert result.services[32].node.platform_info.node_type == """SF3010""", "Died on +.services[32].node.platform_info.node_type"
    assert result.services[32].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[32].node.platform_info.cpu_model"
    assert result.services[32].node.platform_info.node_memory_gb == 72, "Died on +.services[32].node.platform_info.node_memory_gb"
    assert result.services[32].node.platform_info.chassis_type == """R620""", "Died on +.services[32].node.platform_info.chassis_type"
    assert result.services[32].node.cip == """10.117.62.26""", "Died on +.services[32].node.cip"
    assert result.services[32].node.sipi == """Bond10G""", "Died on +.services[32].node.sipi"
    assert result.services[32].node.node_id == 4, "Died on +.services[32].node.node_id"
    assert result.services[32].node.software_version == """9.0.0.1554""", "Died on +.services[32].node.software_version"
    assert result.services[32].node.mip == """10.117.60.26""", "Died on +.services[32].node.mip"
    assert result.services[32].node.associated_master_service_id == 3, "Died on +.services[32].node.associated_master_service_id"
    assert result.services[32].node.mipi == """Bond1G""", "Died on +.services[32].node.mipi"
    assert result.services[32].node.fibre_channel_target_port_group is None, "Died on .services[32].node.fibre_channel_target_port_group"
    assert type(result.services[32].node.attributes) is dict, "Died on .services[32].node.attributes"
    assert result.services[32].node.associated_fservice_id == 0, "Died on +.services[32].node.associated_fservice_id"
    assert result.services[32].node.cipi == """Bond10G""", "Died on +.services[32].node.cipi"
    assert result.services[32].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[32].node.uuid"
    assert result.services[32].drive.slot == 2, "Died on +.services[32].drive.slot"
    assert result.services[32].drive.capacity == 300069052416, "Died on +.services[32].drive.capacity"
    assert result.services[32].drive.node_id == 4, "Died on +.services[32].drive.node_id"
    assert result.services[32].drive.drive_id == 4, "Died on +.services[32].drive.drive_id"
    assert result.services[32].drive.customer_slice_file_capacity == 0, "Died on +.services[32].drive.customer_slice_file_capacity"
    assert result.services[32].drive.assigned_service == 20, "Died on +.services[32].drive.assigned_service"
    assert result.services[32].drive.drive_type == """block""", "Died on +.services[32].drive.drive_type"
    assert type(result.services[32].drive.attributes) is dict, "Died on .services[32].drive.attributes"
    assert result.services[32].drive.serial == """scsi-SATA_INTEL_SSDSA2BW3CVPR120504U8300EGN""", "Died on +.services[32].drive.serial"
    assert result.services[32].drive.reserved_slice_file_capacity == 0, "Died on +.services[32].drive.reserved_slice_file_capacity"
    assert result.services[32].drive.drive_status == """assigned""", "Died on +.services[32].drive.drive_status"
    assert result.services[32].service.status == """healthy""", "Died on +.services[32].service.status"
    assert result.services[32].service.associated_bv == 0, "Died on +.services[32].service.associated_bv"
    assert result.services[32].service.associated_ts == 0, "Died on +.services[32].service.associated_ts"
    assert result.services[32].service.associated_vs == 0, "Died on +.services[32].service.associated_vs"
    assert result.services[32].service.ipc_port == 4007, "Died on +.services[32].service.ipc_port"
    assert result.services[32].service.service_type == """block""", "Died on +.services[32].service.service_type"
    assert result.services[32].service.node_id == 4, "Died on +.services[32].service.node_id"
    assert result.services[32].service.drive_id == 4, "Died on +.services[32].service.drive_id"
    assert result.services[32].service.service_id == 20, "Died on +.services[32].service.service_id"
    assert result.services[32].service.iscsi_port == 0, "Died on +.services[32].service.iscsi_port"
    assert result.services[32].service.drive_ids[0] == 4, "Died on +.services[32].service.drive_ids[0]"
    assert result.services[32].service.first_time_startup == False, "Died on +.services[32].service.first_time_startup"
    assert result.services[32].service.started_drive_ids[0] == 4, "Died on +.services[32].service.started_drive_ids[0]"
    assert result.services[32].drives[0].slot == 2, "Died on +.services[32].drives[0].slot"
    assert result.services[32].drives[0].capacity == 300069052416, "Died on +.services[32].drives[0].capacity"
    assert result.services[32].drives[0].node_id == 4, "Died on +.services[32].drives[0].node_id"
    assert result.services[32].drives[0].drive_id == 4, "Died on +.services[32].drives[0].drive_id"
    assert result.services[32].drives[0].customer_slice_file_capacity == 0, "Died on +.services[32].drives[0].customer_slice_file_capacity"
    assert result.services[32].drives[0].assigned_service == 20, "Died on +.services[32].drives[0].assigned_service"
    assert result.services[32].drives[0].drive_type == """Block""", "Died on +.services[32].drives[0].drive_type"
    assert type(result.services[32].drives[0].attributes) is dict, "Died on .services[32].drives[0].attributes"
    assert result.services[32].drives[0].serial == """scsi-SATA_INTEL_SSDSA2BW3CVPR120504U8300EGN""", "Died on +.services[32].drives[0].serial"
    assert result.services[32].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[32].drives[0].reserved_slice_file_capacity"
    assert result.services[32].drives[0].drive_status == """assigned""", "Died on +.services[32].drives[0].drive_status"
    assert result.services[31].node.sip == """10.117.62.26""", "Died on +.services[31].node.sip"
    assert result.services[31].node.name == """SF-1713""", "Died on +.services[31].node.name"
    assert result.services[31].node.platform_info.node_type == """SF3010""", "Died on +.services[31].node.platform_info.node_type"
    assert result.services[31].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[31].node.platform_info.cpu_model"
    assert result.services[31].node.platform_info.node_memory_gb == 72, "Died on +.services[31].node.platform_info.node_memory_gb"
    assert result.services[31].node.platform_info.chassis_type == """R620""", "Died on +.services[31].node.platform_info.chassis_type"
    assert result.services[31].node.cip == """10.117.62.26""", "Died on +.services[31].node.cip"
    assert result.services[31].node.sipi == """Bond10G""", "Died on +.services[31].node.sipi"
    assert result.services[31].node.node_id == 4, "Died on +.services[31].node.node_id"
    assert result.services[31].node.software_version == """9.0.0.1554""", "Died on +.services[31].node.software_version"
    assert result.services[31].node.mip == """10.117.60.26""", "Died on +.services[31].node.mip"
    assert result.services[31].node.associated_master_service_id == 3, "Died on +.services[31].node.associated_master_service_id"
    assert result.services[31].node.mipi == """Bond1G""", "Died on +.services[31].node.mipi"
    assert result.services[31].node.fibre_channel_target_port_group is None, "Died on .services[31].node.fibre_channel_target_port_group"
    assert type(result.services[31].node.attributes) is dict, "Died on .services[31].node.attributes"
    assert result.services[31].node.associated_fservice_id == 0, "Died on +.services[31].node.associated_fservice_id"
    assert result.services[31].node.cipi == """Bond10G""", "Died on +.services[31].node.cipi"
    assert result.services[31].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[31].node.uuid"
    assert result.services[31].service.status == """healthy""", "Died on +.services[31].service.status"
    assert result.services[31].service.associated_bv == 0, "Died on +.services[31].service.associated_bv"
    assert result.services[31].service.associated_ts == 0, "Died on +.services[31].service.associated_ts"
    assert result.services[31].service.associated_vs == 0, "Died on +.services[31].service.associated_vs"
    assert result.services[31].service.ipc_port == 4004, "Died on +.services[31].service.ipc_port"
    assert result.services[31].service.service_type == """transport""", "Died on +.services[31].service.service_type"
    assert result.services[31].service.node_id == 4, "Died on +.services[31].service.node_id"
    assert result.services[31].service.drive_id == 0, "Died on +.services[31].service.drive_id"
    assert result.services[31].service.service_id == 9, "Died on +.services[31].service.service_id"
    assert result.services[31].service.iscsi_port == 3260, "Died on +.services[31].service.iscsi_port"
    assert result.services[31].service.first_time_startup == True, "Died on +.services[31].service.first_time_startup"
    assert result.services[30].node.sip == """10.117.62.26""", "Died on +.services[30].node.sip"
    assert result.services[30].node.name == """SF-1713""", "Died on +.services[30].node.name"
    assert result.services[30].node.platform_info.node_type == """SF3010""", "Died on +.services[30].node.platform_info.node_type"
    assert result.services[30].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[30].node.platform_info.cpu_model"
    assert result.services[30].node.platform_info.node_memory_gb == 72, "Died on +.services[30].node.platform_info.node_memory_gb"
    assert result.services[30].node.platform_info.chassis_type == """R620""", "Died on +.services[30].node.platform_info.chassis_type"
    assert result.services[30].node.cip == """10.117.62.26""", "Died on +.services[30].node.cip"
    assert result.services[30].node.sipi == """Bond10G""", "Died on +.services[30].node.sipi"
    assert result.services[30].node.node_id == 4, "Died on +.services[30].node.node_id"
    assert result.services[30].node.software_version == """9.0.0.1554""", "Died on +.services[30].node.software_version"
    assert result.services[30].node.mip == """10.117.60.26""", "Died on +.services[30].node.mip"
    assert result.services[30].node.associated_master_service_id == 3, "Died on +.services[30].node.associated_master_service_id"
    assert result.services[30].node.mipi == """Bond1G""", "Died on +.services[30].node.mipi"
    assert result.services[30].node.fibre_channel_target_port_group is None, "Died on .services[30].node.fibre_channel_target_port_group"
    assert type(result.services[30].node.attributes) is dict, "Died on .services[30].node.attributes"
    assert result.services[30].node.associated_fservice_id == 0, "Died on +.services[30].node.associated_fservice_id"
    assert result.services[30].node.cipi == """Bond10G""", "Died on +.services[30].node.cipi"
    assert result.services[30].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[30].node.uuid"
    assert result.services[30].service.status == """healthy""", "Died on +.services[30].service.status"
    assert result.services[30].service.associated_bv == 0, "Died on +.services[30].service.associated_bv"
    assert result.services[30].service.associated_ts == 0, "Died on +.services[30].service.associated_ts"
    assert result.services[30].service.associated_vs == 0, "Died on +.services[30].service.associated_vs"
    assert result.services[30].service.ipc_port == 4003, "Died on +.services[30].service.ipc_port"
    assert result.services[30].service.service_type == """volume""", "Died on +.services[30].service.service_type"
    assert result.services[30].service.node_id == 4, "Died on +.services[30].service.node_id"
    assert result.services[30].service.drive_id == 0, "Died on +.services[30].service.drive_id"
    assert result.services[30].service.service_id == 8, "Died on +.services[30].service.service_id"
    assert result.services[30].service.iscsi_port == 0, "Died on +.services[30].service.iscsi_port"
    assert result.services[30].service.first_time_startup == True, "Died on +.services[30].service.first_time_startup"
    assert result.services[29].node.sip == """10.117.62.26""", "Died on +.services[29].node.sip"
    assert result.services[29].node.name == """SF-1713""", "Died on +.services[29].node.name"
    assert result.services[29].node.platform_info.node_type == """SF3010""", "Died on +.services[29].node.platform_info.node_type"
    assert result.services[29].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[29].node.platform_info.cpu_model"
    assert result.services[29].node.platform_info.node_memory_gb == 72, "Died on +.services[29].node.platform_info.node_memory_gb"
    assert result.services[29].node.platform_info.chassis_type == """R620""", "Died on +.services[29].node.platform_info.chassis_type"
    assert result.services[29].node.cip == """10.117.62.26""", "Died on +.services[29].node.cip"
    assert result.services[29].node.sipi == """Bond10G""", "Died on +.services[29].node.sipi"
    assert result.services[29].node.node_id == 4, "Died on +.services[29].node.node_id"
    assert result.services[29].node.software_version == """9.0.0.1554""", "Died on +.services[29].node.software_version"
    assert result.services[29].node.mip == """10.117.60.26""", "Died on +.services[29].node.mip"
    assert result.services[29].node.associated_master_service_id == 3, "Died on +.services[29].node.associated_master_service_id"
    assert result.services[29].node.mipi == """Bond1G""", "Died on +.services[29].node.mipi"
    assert result.services[29].node.fibre_channel_target_port_group is None, "Died on .services[29].node.fibre_channel_target_port_group"
    assert type(result.services[29].node.attributes) is dict, "Died on .services[29].node.attributes"
    assert result.services[29].node.associated_fservice_id == 0, "Died on +.services[29].node.associated_fservice_id"
    assert result.services[29].node.cipi == """Bond10G""", "Died on +.services[29].node.cipi"
    assert result.services[29].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[29].node.uuid"
    assert result.services[29].service.status == """healthy""", "Died on +.services[29].service.status"
    assert result.services[29].service.associated_bv == 0, "Died on +.services[29].service.associated_bv"
    assert result.services[29].service.associated_ts == 0, "Died on +.services[29].service.associated_ts"
    assert result.services[29].service.associated_vs == 0, "Died on +.services[29].service.associated_vs"
    assert result.services[29].service.ipc_port == 4001, "Died on +.services[29].service.ipc_port"
    assert result.services[29].service.service_type == """bulkvolume""", "Died on +.services[29].service.service_type"
    assert result.services[29].service.node_id == 4, "Died on +.services[29].service.node_id"
    assert result.services[29].service.drive_id == 0, "Died on +.services[29].service.drive_id"
    assert result.services[29].service.service_id == 7, "Died on +.services[29].service.service_id"
    assert result.services[29].service.iscsi_port == 0, "Died on +.services[29].service.iscsi_port"
    assert result.services[29].service.first_time_startup == True, "Died on +.services[29].service.first_time_startup"
    assert result.services[28].node.sip == """10.117.62.24""", "Died on +.services[28].node.sip"
    assert result.services[28].node.name == """SF-918D""", "Died on +.services[28].node.name"
    assert result.services[28].node.platform_info.node_type == """FC0025""", "Died on +.services[28].node.platform_info.node_type"
    assert result.services[28].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[28].node.platform_info.cpu_model"
    assert result.services[28].node.platform_info.node_memory_gb == 32, "Died on +.services[28].node.platform_info.node_memory_gb"
    assert result.services[28].node.platform_info.chassis_type == """R620""", "Died on +.services[28].node.platform_info.chassis_type"
    assert result.services[28].node.cip == """10.117.62.24""", "Died on +.services[28].node.cip"
    assert result.services[28].node.sipi == """Bond10G""", "Died on +.services[28].node.sipi"
    assert result.services[28].node.node_id == 2, "Died on +.services[28].node.node_id"
    assert result.services[28].node.software_version == """9.0.0.1554""", "Died on +.services[28].node.software_version"
    assert result.services[28].node.mip == """10.117.60.24""", "Died on +.services[28].node.mip"
    assert result.services[28].node.associated_master_service_id == 5, "Died on +.services[28].node.associated_master_service_id"
    assert result.services[28].node.mipi == """Bond1G""", "Died on +.services[28].node.mipi"
    assert result.services[28].node.fibre_channel_target_port_group == 1, "Died on +.services[28].node.fibre_channel_target_port_group"
    assert type(result.services[28].node.attributes) is dict, "Died on .services[28].node.attributes"
    assert result.services[28].node.associated_fservice_id == 6, "Died on +.services[28].node.associated_fservice_id"
    assert result.services[28].node.cipi == """Bond10G""", "Died on +.services[28].node.cipi"
    assert result.services[28].node.uuid == UUID("4C4C4544-0034-5910-8033-B1C04F503232"), "Died on .services[28].node.uuid"
    assert result.services[28].service.status == """healthy""", "Died on +.services[28].service.status"
    assert result.services[28].service.associated_bv == 0, "Died on +.services[28].service.associated_bv"
    assert result.services[28].service.associated_ts == 0, "Died on +.services[28].service.associated_ts"
    assert result.services[28].service.associated_vs == 0, "Died on +.services[28].service.associated_vs"
    assert result.services[28].service.ipc_port == 4001, "Died on +.services[28].service.ipc_port"
    assert result.services[28].service.service_type == """fibre""", "Died on +.services[28].service.service_type"
    assert result.services[28].service.node_id == 2, "Died on +.services[28].service.node_id"
    assert result.services[28].service.drive_id == 0, "Died on +.services[28].service.drive_id"
    assert result.services[28].service.service_id == 6, "Died on +.services[28].service.service_id"
    assert result.services[28].service.iscsi_port == 0, "Died on +.services[28].service.iscsi_port"
    assert result.services[28].service.first_time_startup == True, "Died on +.services[28].service.first_time_startup"
    assert result.services[27].node.sip == """10.117.62.24""", "Died on +.services[27].node.sip"
    assert result.services[27].node.name == """SF-918D""", "Died on +.services[27].node.name"
    assert result.services[27].node.platform_info.node_type == """FC0025""", "Died on +.services[27].node.platform_info.node_type"
    assert result.services[27].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[27].node.platform_info.cpu_model"
    assert result.services[27].node.platform_info.node_memory_gb == 32, "Died on +.services[27].node.platform_info.node_memory_gb"
    assert result.services[27].node.platform_info.chassis_type == """R620""", "Died on +.services[27].node.platform_info.chassis_type"
    assert result.services[27].node.cip == """10.117.62.24""", "Died on +.services[27].node.cip"
    assert result.services[27].node.sipi == """Bond10G""", "Died on +.services[27].node.sipi"
    assert result.services[27].node.node_id == 2, "Died on +.services[27].node.node_id"
    assert result.services[27].node.software_version == """9.0.0.1554""", "Died on +.services[27].node.software_version"
    assert result.services[27].node.mip == """10.117.60.24""", "Died on +.services[27].node.mip"
    assert result.services[27].node.associated_master_service_id == 5, "Died on +.services[27].node.associated_master_service_id"
    assert result.services[27].node.mipi == """Bond1G""", "Died on +.services[27].node.mipi"
    assert result.services[27].node.fibre_channel_target_port_group == 1, "Died on +.services[27].node.fibre_channel_target_port_group"
    assert type(result.services[27].node.attributes) is dict, "Died on .services[27].node.attributes"
    assert result.services[27].node.associated_fservice_id == 6, "Died on +.services[27].node.associated_fservice_id"
    assert result.services[27].node.cipi == """Bond10G""", "Died on +.services[27].node.cipi"
    assert result.services[27].node.uuid == UUID("4C4C4544-0034-5910-8033-B1C04F503232"), "Died on .services[27].node.uuid"
    assert result.services[27].service.status == """healthy""", "Died on +.services[27].service.status"
    assert result.services[27].service.associated_bv == 0, "Died on +.services[27].service.associated_bv"
    assert result.services[27].service.associated_ts == 0, "Died on +.services[27].service.associated_ts"
    assert result.services[27].service.associated_vs == 8000, "Died on +.services[27].service.associated_vs"
    assert result.services[27].service.ipc_port == 4000, "Died on +.services[27].service.ipc_port"
    assert result.services[27].service.service_type == """master""", "Died on +.services[27].service.service_type"
    assert result.services[27].service.node_id == 2, "Died on +.services[27].service.node_id"
    assert result.services[27].service.drive_id == 0, "Died on +.services[27].service.drive_id"
    assert result.services[27].service.service_id == 5, "Died on +.services[27].service.service_id"
    assert result.services[27].service.iscsi_port == 0, "Died on +.services[27].service.iscsi_port"
    assert result.services[27].service.first_time_startup == True, "Died on +.services[27].service.first_time_startup"
    assert result.services[26].node.sip == """10.117.62.25""", "Died on +.services[26].node.sip"
    assert result.services[26].node.name == """SF-F2A3""", "Died on +.services[26].node.name"
    assert result.services[26].node.platform_info.node_type == """SF3010""", "Died on +.services[26].node.platform_info.node_type"
    assert result.services[26].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[26].node.platform_info.cpu_model"
    assert result.services[26].node.platform_info.node_memory_gb == 72, "Died on +.services[26].node.platform_info.node_memory_gb"
    assert result.services[26].node.platform_info.chassis_type == """R620""", "Died on +.services[26].node.platform_info.chassis_type"
    assert result.services[26].node.cip == """10.117.62.25""", "Died on +.services[26].node.cip"
    assert result.services[26].node.sipi == """Bond10G""", "Died on +.services[26].node.sipi"
    assert result.services[26].node.node_id == 3, "Died on +.services[26].node.node_id"
    assert result.services[26].node.software_version == """9.0.0.1554""", "Died on +.services[26].node.software_version"
    assert result.services[26].node.mip == """10.117.60.25""", "Died on +.services[26].node.mip"
    assert result.services[26].node.associated_master_service_id == 4, "Died on +.services[26].node.associated_master_service_id"
    assert result.services[26].node.mipi == """Bond1G""", "Died on +.services[26].node.mipi"
    assert result.services[26].node.fibre_channel_target_port_group is None, "Died on .services[26].node.fibre_channel_target_port_group"
    assert type(result.services[26].node.attributes) is dict, "Died on .services[26].node.attributes"
    assert result.services[26].node.associated_fservice_id == 0, "Died on +.services[26].node.associated_fservice_id"
    assert result.services[26].node.cipi == """Bond10G""", "Died on +.services[26].node.cipi"
    assert result.services[26].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[26].node.uuid"
    assert result.services[26].service.status == """healthy""", "Died on +.services[26].service.status"
    assert result.services[26].service.associated_bv == 0, "Died on +.services[26].service.associated_bv"
    assert result.services[26].service.associated_ts == 0, "Died on +.services[26].service.associated_ts"
    assert result.services[26].service.associated_vs == 8000, "Died on +.services[26].service.associated_vs"
    assert result.services[26].service.ipc_port == 4000, "Died on +.services[26].service.ipc_port"
    assert result.services[26].service.service_type == """master""", "Died on +.services[26].service.service_type"
    assert result.services[26].service.node_id == 3, "Died on +.services[26].service.node_id"
    assert result.services[26].service.drive_id == 0, "Died on +.services[26].service.drive_id"
    assert result.services[26].service.service_id == 4, "Died on +.services[26].service.service_id"
    assert result.services[26].service.iscsi_port == 0, "Died on +.services[26].service.iscsi_port"
    assert result.services[26].service.first_time_startup == True, "Died on +.services[26].service.first_time_startup"
    assert result.services[25].node.sip == """10.117.62.26""", "Died on +.services[25].node.sip"
    assert result.services[25].node.name == """SF-1713""", "Died on +.services[25].node.name"
    assert result.services[25].node.platform_info.node_type == """SF3010""", "Died on +.services[25].node.platform_info.node_type"
    assert result.services[25].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[25].node.platform_info.cpu_model"
    assert result.services[25].node.platform_info.node_memory_gb == 72, "Died on +.services[25].node.platform_info.node_memory_gb"
    assert result.services[25].node.platform_info.chassis_type == """R620""", "Died on +.services[25].node.platform_info.chassis_type"
    assert result.services[25].node.cip == """10.117.62.26""", "Died on +.services[25].node.cip"
    assert result.services[25].node.sipi == """Bond10G""", "Died on +.services[25].node.sipi"
    assert result.services[25].node.node_id == 4, "Died on +.services[25].node.node_id"
    assert result.services[25].node.software_version == """9.0.0.1554""", "Died on +.services[25].node.software_version"
    assert result.services[25].node.mip == """10.117.60.26""", "Died on +.services[25].node.mip"
    assert result.services[25].node.associated_master_service_id == 3, "Died on +.services[25].node.associated_master_service_id"
    assert result.services[25].node.mipi == """Bond1G""", "Died on +.services[25].node.mipi"
    assert result.services[25].node.fibre_channel_target_port_group is None, "Died on .services[25].node.fibre_channel_target_port_group"
    assert type(result.services[25].node.attributes) is dict, "Died on .services[25].node.attributes"
    assert result.services[25].node.associated_fservice_id == 0, "Died on +.services[25].node.associated_fservice_id"
    assert result.services[25].node.cipi == """Bond10G""", "Died on +.services[25].node.cipi"
    assert result.services[25].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[25].node.uuid"
    assert result.services[25].service.status == """healthy""", "Died on +.services[25].service.status"
    assert result.services[25].service.associated_bv == 0, "Died on +.services[25].service.associated_bv"
    assert result.services[25].service.associated_ts == 0, "Died on +.services[25].service.associated_ts"
    assert result.services[25].service.associated_vs == 8000, "Died on +.services[25].service.associated_vs"
    assert result.services[25].service.ipc_port == 4000, "Died on +.services[25].service.ipc_port"
    assert result.services[25].service.service_type == """master""", "Died on +.services[25].service.service_type"
    assert result.services[25].service.node_id == 4, "Died on +.services[25].service.node_id"
    assert result.services[25].service.drive_id == 0, "Died on +.services[25].service.drive_id"
    assert result.services[25].service.service_id == 3, "Died on +.services[25].service.service_id"
    assert result.services[25].service.iscsi_port == 0, "Died on +.services[25].service.iscsi_port"
    assert result.services[25].service.first_time_startup == True, "Died on +.services[25].service.first_time_startup"
    assert result.services[24].node.sip == """10.117.62.23""", "Died on +.services[24].node.sip"
    assert result.services[24].node.name == """SF-5391""", "Died on +.services[24].node.name"
    assert result.services[24].node.platform_info.node_type == """FC0025""", "Died on +.services[24].node.platform_info.node_type"
    assert result.services[24].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[24].node.platform_info.cpu_model"
    assert result.services[24].node.platform_info.node_memory_gb == 32, "Died on +.services[24].node.platform_info.node_memory_gb"
    assert result.services[24].node.platform_info.chassis_type == """R620""", "Died on +.services[24].node.platform_info.chassis_type"
    assert result.services[24].node.cip == """10.117.62.23""", "Died on +.services[24].node.cip"
    assert result.services[24].node.sipi == """Bond10G""", "Died on +.services[24].node.sipi"
    assert result.services[24].node.node_id == 1, "Died on +.services[24].node.node_id"
    assert result.services[24].node.software_version == """9.0.0.1554""", "Died on +.services[24].node.software_version"
    assert result.services[24].node.mip == """10.117.60.23""", "Died on +.services[24].node.mip"
    assert result.services[24].node.associated_master_service_id == 1, "Died on +.services[24].node.associated_master_service_id"
    assert result.services[24].node.mipi == """Bond1G""", "Died on +.services[24].node.mipi"
    assert result.services[24].node.fibre_channel_target_port_group == 0, "Died on +.services[24].node.fibre_channel_target_port_group"
    assert type(result.services[24].node.attributes) is dict, "Died on .services[24].node.attributes"
    assert result.services[24].node.associated_fservice_id == 2, "Died on +.services[24].node.associated_fservice_id"
    assert result.services[24].node.cipi == """Bond10G""", "Died on +.services[24].node.cipi"
    assert result.services[24].node.uuid == UUID("4C4C4544-0032-4B10-8038-C2C04F513232"), "Died on .services[24].node.uuid"
    assert result.services[24].service.status == """healthy""", "Died on +.services[24].service.status"
    assert result.services[24].service.associated_bv == 0, "Died on +.services[24].service.associated_bv"
    assert result.services[24].service.associated_ts == 0, "Died on +.services[24].service.associated_ts"
    assert result.services[24].service.associated_vs == 0, "Died on +.services[24].service.associated_vs"
    assert result.services[24].service.ipc_port == 4001, "Died on +.services[24].service.ipc_port"
    assert result.services[24].service.service_type == """fibre""", "Died on +.services[24].service.service_type"
    assert result.services[24].service.node_id == 1, "Died on +.services[24].service.node_id"
    assert result.services[24].service.drive_id == 0, "Died on +.services[24].service.drive_id"
    assert result.services[24].service.service_id == 2, "Died on +.services[24].service.service_id"
    assert result.services[24].service.iscsi_port == 0, "Died on +.services[24].service.iscsi_port"
    assert result.services[24].service.first_time_startup == True, "Died on +.services[24].service.first_time_startup"
    assert result.services[23].node.sip == """10.117.62.23""", "Died on +.services[23].node.sip"
    assert result.services[23].node.name == """SF-5391""", "Died on +.services[23].node.name"
    assert result.services[23].node.platform_info.node_type == """FC0025""", "Died on +.services[23].node.platform_info.node_type"
    assert result.services[23].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[23].node.platform_info.cpu_model"
    assert result.services[23].node.platform_info.node_memory_gb == 32, "Died on +.services[23].node.platform_info.node_memory_gb"
    assert result.services[23].node.platform_info.chassis_type == """R620""", "Died on +.services[23].node.platform_info.chassis_type"
    assert result.services[23].node.cip == """10.117.62.23""", "Died on +.services[23].node.cip"
    assert result.services[23].node.sipi == """Bond10G""", "Died on +.services[23].node.sipi"
    assert result.services[23].node.node_id == 1, "Died on +.services[23].node.node_id"
    assert result.services[23].node.software_version == """9.0.0.1554""", "Died on +.services[23].node.software_version"
    assert result.services[23].node.mip == """10.117.60.23""", "Died on +.services[23].node.mip"
    assert result.services[23].node.associated_master_service_id == 1, "Died on +.services[23].node.associated_master_service_id"
    assert result.services[23].node.mipi == """Bond1G""", "Died on +.services[23].node.mipi"
    assert result.services[23].node.fibre_channel_target_port_group == 0, "Died on +.services[23].node.fibre_channel_target_port_group"
    assert type(result.services[23].node.attributes) is dict, "Died on .services[23].node.attributes"
    assert result.services[23].node.associated_fservice_id == 2, "Died on +.services[23].node.associated_fservice_id"
    assert result.services[23].node.cipi == """Bond10G""", "Died on +.services[23].node.cipi"
    assert result.services[23].node.uuid == UUID("4C4C4544-0032-4B10-8038-C2C04F513232"), "Died on .services[23].node.uuid"
    assert result.services[23].service.status == """healthy""", "Died on +.services[23].service.status"
    assert result.services[23].service.associated_bv == 0, "Died on +.services[23].service.associated_bv"
    assert result.services[23].service.associated_ts == 0, "Died on +.services[23].service.associated_ts"
    assert result.services[23].service.associated_vs == 8000, "Died on +.services[23].service.associated_vs"
    assert result.services[23].service.ipc_port == 4000, "Died on +.services[23].service.ipc_port"
    assert result.services[23].service.service_type == """master""", "Died on +.services[23].service.service_type"
    assert result.services[23].service.node_id == 1, "Died on +.services[23].service.node_id"
    assert result.services[23].service.drive_id == 0, "Died on +.services[23].service.drive_id"
    assert result.services[23].service.service_id == 1, "Died on +.services[23].service.service_id"
    assert result.services[23].service.iscsi_port == 0, "Died on +.services[23].service.iscsi_port"
    assert result.services[23].service.first_time_startup == True, "Died on +.services[23].service.first_time_startup"
    assert result.services[22].node.sip == """10.117.62.25""", "Died on +.services[22].node.sip"
    assert result.services[22].node.name == """SF-F2A3""", "Died on +.services[22].node.name"
    assert result.services[22].node.platform_info.node_type == """SF3010""", "Died on +.services[22].node.platform_info.node_type"
    assert result.services[22].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[22].node.platform_info.cpu_model"
    assert result.services[22].node.platform_info.node_memory_gb == 72, "Died on +.services[22].node.platform_info.node_memory_gb"
    assert result.services[22].node.platform_info.chassis_type == """R620""", "Died on +.services[22].node.platform_info.chassis_type"
    assert result.services[22].node.cip == """10.117.62.25""", "Died on +.services[22].node.cip"
    assert result.services[22].node.sipi == """Bond10G""", "Died on +.services[22].node.sipi"
    assert result.services[22].node.node_id == 3, "Died on +.services[22].node.node_id"
    assert result.services[22].node.software_version == """9.0.0.1554""", "Died on +.services[22].node.software_version"
    assert result.services[22].node.mip == """10.117.60.25""", "Died on +.services[22].node.mip"
    assert result.services[22].node.associated_master_service_id == 4, "Died on +.services[22].node.associated_master_service_id"
    assert result.services[22].node.mipi == """Bond1G""", "Died on +.services[22].node.mipi"
    assert result.services[22].node.fibre_channel_target_port_group is None, "Died on .services[22].node.fibre_channel_target_port_group"
    assert type(result.services[22].node.attributes) is dict, "Died on .services[22].node.attributes"
    assert result.services[22].node.associated_fservice_id == 0, "Died on +.services[22].node.associated_fservice_id"
    assert result.services[22].node.cipi == """Bond10G""", "Died on +.services[22].node.cipi"
    assert result.services[22].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[22].node.uuid"
    assert result.services[22].drive.slot == 2, "Died on +.services[22].drive.slot"
    assert result.services[22].drive.capacity == 300069052416, "Died on +.services[22].drive.capacity"
    assert result.services[22].drive.node_id == 3, "Died on +.services[22].drive.node_id"
    assert result.services[22].drive.drive_id == 15, "Died on +.services[22].drive.drive_id"
    assert result.services[22].drive.customer_slice_file_capacity == 0, "Died on +.services[22].drive.customer_slice_file_capacity"
    assert result.services[22].drive.assigned_service == 19, "Died on +.services[22].drive.assigned_service"
    assert result.services[22].drive.drive_type == """block""", "Died on +.services[22].drive.drive_type"
    assert type(result.services[22].drive.attributes) is dict, "Died on .services[22].drive.attributes"
    assert result.services[22].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL3113015C300PGN""", "Died on +.services[22].drive.serial"
    assert result.services[22].drive.reserved_slice_file_capacity == 0, "Died on +.services[22].drive.reserved_slice_file_capacity"
    assert result.services[22].drive.drive_status == """assigned""", "Died on +.services[22].drive.drive_status"
    assert result.services[22].service.status == """healthy""", "Died on +.services[22].service.status"
    assert result.services[22].service.associated_bv == 0, "Died on +.services[22].service.associated_bv"
    assert result.services[22].service.associated_ts == 0, "Died on +.services[22].service.associated_ts"
    assert result.services[22].service.associated_vs == 0, "Died on +.services[22].service.associated_vs"
    assert result.services[22].service.ipc_port == 4007, "Died on +.services[22].service.ipc_port"
    assert result.services[22].service.service_type == """block""", "Died on +.services[22].service.service_type"
    assert result.services[22].service.node_id == 3, "Died on +.services[22].service.node_id"
    assert result.services[22].service.drive_id == 15, "Died on +.services[22].service.drive_id"
    assert result.services[22].service.service_id == 19, "Died on +.services[22].service.service_id"
    assert result.services[22].service.iscsi_port == 0, "Died on +.services[22].service.iscsi_port"
    assert result.services[22].service.drive_ids[0] == 15, "Died on +.services[22].service.drive_ids[0]"
    assert result.services[22].service.first_time_startup == False, "Died on +.services[22].service.first_time_startup"
    assert result.services[22].service.started_drive_ids[0] == 15, "Died on +.services[22].service.started_drive_ids[0]"
    assert result.services[22].drives[0].slot == 2, "Died on +.services[22].drives[0].slot"
    assert result.services[22].drives[0].capacity == 300069052416, "Died on +.services[22].drives[0].capacity"
    assert result.services[22].drives[0].node_id == 3, "Died on +.services[22].drives[0].node_id"
    assert result.services[22].drives[0].drive_id == 15, "Died on +.services[22].drives[0].drive_id"
    assert result.services[22].drives[0].customer_slice_file_capacity == 0, "Died on +.services[22].drives[0].customer_slice_file_capacity"
    assert result.services[22].drives[0].assigned_service == 19, "Died on +.services[22].drives[0].assigned_service"
    assert result.services[22].drives[0].drive_type == """Block""", "Died on +.services[22].drives[0].drive_type"
    assert type(result.services[22].drives[0].attributes) is dict, "Died on .services[22].drives[0].attributes"
    assert result.services[22].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL3113015C300PGN""", "Died on +.services[22].drives[0].serial"
    assert result.services[22].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[22].drives[0].reserved_slice_file_capacity"
    assert result.services[22].drives[0].drive_status == """assigned""", "Died on +.services[22].drives[0].drive_status"
    assert result.services[21].node.sip == """10.117.62.26""", "Died on +.services[21].node.sip"
    assert result.services[21].node.name == """SF-1713""", "Died on +.services[21].node.name"
    assert result.services[21].node.platform_info.node_type == """SF3010""", "Died on +.services[21].node.platform_info.node_type"
    assert result.services[21].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[21].node.platform_info.cpu_model"
    assert result.services[21].node.platform_info.node_memory_gb == 72, "Died on +.services[21].node.platform_info.node_memory_gb"
    assert result.services[21].node.platform_info.chassis_type == """R620""", "Died on +.services[21].node.platform_info.chassis_type"
    assert result.services[21].node.cip == """10.117.62.26""", "Died on +.services[21].node.cip"
    assert result.services[21].node.sipi == """Bond10G""", "Died on +.services[21].node.sipi"
    assert result.services[21].node.node_id == 4, "Died on +.services[21].node.node_id"
    assert result.services[21].node.software_version == """9.0.0.1554""", "Died on +.services[21].node.software_version"
    assert result.services[21].node.mip == """10.117.60.26""", "Died on +.services[21].node.mip"
    assert result.services[21].node.associated_master_service_id == 3, "Died on +.services[21].node.associated_master_service_id"
    assert result.services[21].node.mipi == """Bond1G""", "Died on +.services[21].node.mipi"
    assert result.services[21].node.fibre_channel_target_port_group is None, "Died on .services[21].node.fibre_channel_target_port_group"
    assert type(result.services[21].node.attributes) is dict, "Died on .services[21].node.attributes"
    assert result.services[21].node.associated_fservice_id == 0, "Died on +.services[21].node.associated_fservice_id"
    assert result.services[21].node.cipi == """Bond10G""", "Died on +.services[21].node.cipi"
    assert result.services[21].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[21].node.uuid"
    assert result.services[21].drive.slot == 1, "Died on +.services[21].drive.slot"
    assert result.services[21].drive.capacity == 300069052416, "Died on +.services[21].drive.capacity"
    assert result.services[21].drive.node_id == 4, "Died on +.services[21].drive.node_id"
    assert result.services[21].drive.drive_id == 3, "Died on +.services[21].drive.drive_id"
    assert result.services[21].drive.customer_slice_file_capacity == 0, "Died on +.services[21].drive.customer_slice_file_capacity"
    assert result.services[21].drive.assigned_service == 18, "Died on +.services[21].drive.assigned_service"
    assert result.services[21].drive.drive_type == """block""", "Died on +.services[21].drive.drive_type"
    assert type(result.services[21].drive.attributes) is dict, "Died on .services[21].drive.attributes"
    assert result.services[21].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR1214010M300EGN""", "Died on +.services[21].drive.serial"
    assert result.services[21].drive.reserved_slice_file_capacity == 0, "Died on +.services[21].drive.reserved_slice_file_capacity"
    assert result.services[21].drive.drive_status == """assigned""", "Died on +.services[21].drive.drive_status"
    assert result.services[21].service.status == """healthy""", "Died on +.services[21].service.status"
    assert result.services[21].service.associated_bv == 0, "Died on +.services[21].service.associated_bv"
    assert result.services[21].service.associated_ts == 0, "Died on +.services[21].service.associated_ts"
    assert result.services[21].service.associated_vs == 0, "Died on +.services[21].service.associated_vs"
    assert result.services[21].service.ipc_port == 4006, "Died on +.services[21].service.ipc_port"
    assert result.services[21].service.service_type == """block""", "Died on +.services[21].service.service_type"
    assert result.services[21].service.node_id == 4, "Died on +.services[21].service.node_id"
    assert result.services[21].service.drive_id == 3, "Died on +.services[21].service.drive_id"
    assert result.services[21].service.service_id == 18, "Died on +.services[21].service.service_id"
    assert result.services[21].service.iscsi_port == 0, "Died on +.services[21].service.iscsi_port"
    assert result.services[21].service.drive_ids[0] == 3, "Died on +.services[21].service.drive_ids[0]"
    assert result.services[21].service.first_time_startup == False, "Died on +.services[21].service.first_time_startup"
    assert result.services[21].service.started_drive_ids[0] == 3, "Died on +.services[21].service.started_drive_ids[0]"
    assert result.services[21].drives[0].slot == 1, "Died on +.services[21].drives[0].slot"
    assert result.services[21].drives[0].capacity == 300069052416, "Died on +.services[21].drives[0].capacity"
    assert result.services[21].drives[0].node_id == 4, "Died on +.services[21].drives[0].node_id"
    assert result.services[21].drives[0].drive_id == 3, "Died on +.services[21].drives[0].drive_id"
    assert result.services[21].drives[0].customer_slice_file_capacity == 0, "Died on +.services[21].drives[0].customer_slice_file_capacity"
    assert result.services[21].drives[0].assigned_service == 18, "Died on +.services[21].drives[0].assigned_service"
    assert result.services[21].drives[0].drive_type == """Block""", "Died on +.services[21].drives[0].drive_type"
    assert type(result.services[21].drives[0].attributes) is dict, "Died on .services[21].drives[0].attributes"
    assert result.services[21].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR1214010M300EGN""", "Died on +.services[21].drives[0].serial"
    assert result.services[21].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[21].drives[0].reserved_slice_file_capacity"
    assert result.services[21].drives[0].drive_status == """assigned""", "Died on +.services[21].drives[0].drive_status"
    assert result.services[20].node.sip == """10.117.62.25""", "Died on +.services[20].node.sip"
    assert result.services[20].node.name == """SF-F2A3""", "Died on +.services[20].node.name"
    assert result.services[20].node.platform_info.node_type == """SF3010""", "Died on +.services[20].node.platform_info.node_type"
    assert result.services[20].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[20].node.platform_info.cpu_model"
    assert result.services[20].node.platform_info.node_memory_gb == 72, "Died on +.services[20].node.platform_info.node_memory_gb"
    assert result.services[20].node.platform_info.chassis_type == """R620""", "Died on +.services[20].node.platform_info.chassis_type"
    assert result.services[20].node.cip == """10.117.62.25""", "Died on +.services[20].node.cip"
    assert result.services[20].node.sipi == """Bond10G""", "Died on +.services[20].node.sipi"
    assert result.services[20].node.node_id == 3, "Died on +.services[20].node.node_id"
    assert result.services[20].node.software_version == """9.0.0.1554""", "Died on +.services[20].node.software_version"
    assert result.services[20].node.mip == """10.117.60.25""", "Died on +.services[20].node.mip"
    assert result.services[20].node.associated_master_service_id == 4, "Died on +.services[20].node.associated_master_service_id"
    assert result.services[20].node.mipi == """Bond1G""", "Died on +.services[20].node.mipi"
    assert result.services[20].node.fibre_channel_target_port_group is None, "Died on .services[20].node.fibre_channel_target_port_group"
    assert type(result.services[20].node.attributes) is dict, "Died on .services[20].node.attributes"
    assert result.services[20].node.associated_fservice_id == 0, "Died on +.services[20].node.associated_fservice_id"
    assert result.services[20].node.cipi == """Bond10G""", "Died on +.services[20].node.cipi"
    assert result.services[20].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[20].node.uuid"
    assert result.services[20].drive.slot == 1, "Died on +.services[20].drive.slot"
    assert result.services[20].drive.capacity == 300069052416, "Died on +.services[20].drive.capacity"
    assert result.services[20].drive.node_id == 3, "Died on +.services[20].drive.node_id"
    assert result.services[20].drive.drive_id == 14, "Died on +.services[20].drive.drive_id"
    assert result.services[20].drive.customer_slice_file_capacity == 0, "Died on +.services[20].drive.customer_slice_file_capacity"
    assert result.services[20].drive.assigned_service == 17, "Died on +.services[20].drive.assigned_service"
    assert result.services[20].drive.drive_type == """block""", "Died on +.services[20].drive.drive_type"
    assert type(result.services[20].drive.attributes) is dict, "Died on .services[20].drive.attributes"
    assert result.services[20].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL311301EL300PGN""", "Died on +.services[20].drive.serial"
    assert result.services[20].drive.reserved_slice_file_capacity == 0, "Died on +.services[20].drive.reserved_slice_file_capacity"
    assert result.services[20].drive.drive_status == """assigned""", "Died on +.services[20].drive.drive_status"
    assert result.services[20].service.status == """healthy""", "Died on +.services[20].service.status"
    assert result.services[20].service.associated_bv == 0, "Died on +.services[20].service.associated_bv"
    assert result.services[20].service.associated_ts == 0, "Died on +.services[20].service.associated_ts"
    assert result.services[20].service.associated_vs == 0, "Died on +.services[20].service.associated_vs"
    assert result.services[20].service.ipc_port == 4006, "Died on +.services[20].service.ipc_port"
    assert result.services[20].service.service_type == """block""", "Died on +.services[20].service.service_type"
    assert result.services[20].service.node_id == 3, "Died on +.services[20].service.node_id"
    assert result.services[20].service.drive_id == 14, "Died on +.services[20].service.drive_id"
    assert result.services[20].service.service_id == 17, "Died on +.services[20].service.service_id"
    assert result.services[20].service.iscsi_port == 0, "Died on +.services[20].service.iscsi_port"
    assert result.services[20].service.drive_ids[0] == 14, "Died on +.services[20].service.drive_ids[0]"
    assert result.services[20].service.first_time_startup == False, "Died on +.services[20].service.first_time_startup"
    assert result.services[20].service.started_drive_ids[0] == 14, "Died on +.services[20].service.started_drive_ids[0]"
    assert result.services[20].drives[0].slot == 1, "Died on +.services[20].drives[0].slot"
    assert result.services[20].drives[0].capacity == 300069052416, "Died on +.services[20].drives[0].capacity"
    assert result.services[20].drives[0].node_id == 3, "Died on +.services[20].drives[0].node_id"
    assert result.services[20].drives[0].drive_id == 14, "Died on +.services[20].drives[0].drive_id"
    assert result.services[20].drives[0].customer_slice_file_capacity == 0, "Died on +.services[20].drives[0].customer_slice_file_capacity"
    assert result.services[20].drives[0].assigned_service == 17, "Died on +.services[20].drives[0].assigned_service"
    assert result.services[20].drives[0].drive_type == """Block""", "Died on +.services[20].drives[0].drive_type"
    assert type(result.services[20].drives[0].attributes) is dict, "Died on .services[20].drives[0].attributes"
    assert result.services[20].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL311301EL300PGN""", "Died on +.services[20].drives[0].serial"
    assert result.services[20].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[20].drives[0].reserved_slice_file_capacity"
    assert result.services[20].drives[0].drive_status == """assigned""", "Died on +.services[20].drives[0].drive_status"
    assert result.services[19].node.sip == """10.117.62.25""", "Died on +.services[19].node.sip"
    assert result.services[19].node.name == """SF-F2A3""", "Died on +.services[19].node.name"
    assert result.services[19].node.platform_info.node_type == """SF3010""", "Died on +.services[19].node.platform_info.node_type"
    assert result.services[19].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[19].node.platform_info.cpu_model"
    assert result.services[19].node.platform_info.node_memory_gb == 72, "Died on +.services[19].node.platform_info.node_memory_gb"
    assert result.services[19].node.platform_info.chassis_type == """R620""", "Died on +.services[19].node.platform_info.chassis_type"
    assert result.services[19].node.cip == """10.117.62.25""", "Died on +.services[19].node.cip"
    assert result.services[19].node.sipi == """Bond10G""", "Died on +.services[19].node.sipi"
    assert result.services[19].node.node_id == 3, "Died on +.services[19].node.node_id"
    assert result.services[19].node.software_version == """9.0.0.1554""", "Died on +.services[19].node.software_version"
    assert result.services[19].node.mip == """10.117.60.25""", "Died on +.services[19].node.mip"
    assert result.services[19].node.associated_master_service_id == 4, "Died on +.services[19].node.associated_master_service_id"
    assert result.services[19].node.mipi == """Bond1G""", "Died on +.services[19].node.mipi"
    assert result.services[19].node.fibre_channel_target_port_group is None, "Died on .services[19].node.fibre_channel_target_port_group"
    assert type(result.services[19].node.attributes) is dict, "Died on .services[19].node.attributes"
    assert result.services[19].node.associated_fservice_id == 0, "Died on +.services[19].node.associated_fservice_id"
    assert result.services[19].node.cipi == """Bond10G""", "Died on +.services[19].node.cipi"
    assert result.services[19].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[19].node.uuid"
    assert result.services[19].drive.slot == 0, "Died on +.services[19].drive.slot"
    assert result.services[19].drive.capacity == 300069052416, "Died on +.services[19].drive.capacity"
    assert result.services[19].drive.node_id == 3, "Died on +.services[19].drive.node_id"
    assert result.services[19].drive.drive_id == 13, "Died on +.services[19].drive.drive_id"
    assert result.services[19].drive.customer_slice_file_capacity == 0, "Died on +.services[19].drive.customer_slice_file_capacity"
    assert result.services[19].drive.assigned_service == 16, "Died on +.services[19].drive.assigned_service"
    assert result.services[19].drive.drive_type == """block""", "Died on +.services[19].drive.drive_type"
    assert type(result.services[19].drive.attributes) is dict, "Died on .services[19].drive.attributes"
    assert result.services[19].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR1214002J300EGN""", "Died on +.services[19].drive.serial"
    assert result.services[19].drive.reserved_slice_file_capacity == 0, "Died on +.services[19].drive.reserved_slice_file_capacity"
    assert result.services[19].drive.drive_status == """assigned""", "Died on +.services[19].drive.drive_status"
    assert result.services[19].service.status == """healthy""", "Died on +.services[19].service.status"
    assert result.services[19].service.associated_bv == 0, "Died on +.services[19].service.associated_bv"
    assert result.services[19].service.associated_ts == 0, "Died on +.services[19].service.associated_ts"
    assert result.services[19].service.associated_vs == 0, "Died on +.services[19].service.associated_vs"
    assert result.services[19].service.ipc_port == 4005, "Died on +.services[19].service.ipc_port"
    assert result.services[19].service.service_type == """block""", "Died on +.services[19].service.service_type"
    assert result.services[19].service.node_id == 3, "Died on +.services[19].service.node_id"
    assert result.services[19].service.drive_id == 13, "Died on +.services[19].service.drive_id"
    assert result.services[19].service.service_id == 16, "Died on +.services[19].service.service_id"
    assert result.services[19].service.iscsi_port == 0, "Died on +.services[19].service.iscsi_port"
    assert result.services[19].service.drive_ids[0] == 13, "Died on +.services[19].service.drive_ids[0]"
    assert result.services[19].service.first_time_startup == False, "Died on +.services[19].service.first_time_startup"
    assert result.services[19].service.started_drive_ids[0] == 13, "Died on +.services[19].service.started_drive_ids[0]"
    assert result.services[19].drives[0].slot == 0, "Died on +.services[19].drives[0].slot"
    assert result.services[19].drives[0].capacity == 300069052416, "Died on +.services[19].drives[0].capacity"
    assert result.services[19].drives[0].node_id == 3, "Died on +.services[19].drives[0].node_id"
    assert result.services[19].drives[0].drive_id == 13, "Died on +.services[19].drives[0].drive_id"
    assert result.services[19].drives[0].customer_slice_file_capacity == 0, "Died on +.services[19].drives[0].customer_slice_file_capacity"
    assert result.services[19].drives[0].assigned_service == 16, "Died on +.services[19].drives[0].assigned_service"
    assert result.services[19].drives[0].drive_type == """Block""", "Died on +.services[19].drives[0].drive_type"
    assert type(result.services[19].drives[0].attributes) is dict, "Died on .services[19].drives[0].attributes"
    assert result.services[19].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR1214002J300EGN""", "Died on +.services[19].drives[0].serial"
    assert result.services[19].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[19].drives[0].reserved_slice_file_capacity"
    assert result.services[19].drives[0].drive_status == """assigned""", "Died on +.services[19].drives[0].drive_status"
    assert result.services[18].node.sip == """10.117.62.26""", "Died on +.services[18].node.sip"
    assert result.services[18].node.name == """SF-1713""", "Died on +.services[18].node.name"
    assert result.services[18].node.platform_info.node_type == """SF3010""", "Died on +.services[18].node.platform_info.node_type"
    assert result.services[18].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[18].node.platform_info.cpu_model"
    assert result.services[18].node.platform_info.node_memory_gb == 72, "Died on +.services[18].node.platform_info.node_memory_gb"
    assert result.services[18].node.platform_info.chassis_type == """R620""", "Died on +.services[18].node.platform_info.chassis_type"
    assert result.services[18].node.cip == """10.117.62.26""", "Died on +.services[18].node.cip"
    assert result.services[18].node.sipi == """Bond10G""", "Died on +.services[18].node.sipi"
    assert result.services[18].node.node_id == 4, "Died on +.services[18].node.node_id"
    assert result.services[18].node.software_version == """9.0.0.1554""", "Died on +.services[18].node.software_version"
    assert result.services[18].node.mip == """10.117.60.26""", "Died on +.services[18].node.mip"
    assert result.services[18].node.associated_master_service_id == 3, "Died on +.services[18].node.associated_master_service_id"
    assert result.services[18].node.mipi == """Bond1G""", "Died on +.services[18].node.mipi"
    assert result.services[18].node.fibre_channel_target_port_group is None, "Died on .services[18].node.fibre_channel_target_port_group"
    assert type(result.services[18].node.attributes) is dict, "Died on .services[18].node.attributes"
    assert result.services[18].node.associated_fservice_id == 0, "Died on +.services[18].node.associated_fservice_id"
    assert result.services[18].node.cipi == """Bond10G""", "Died on +.services[18].node.cipi"
    assert result.services[18].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[18].node.uuid"
    assert result.services[18].drive.slot == 0, "Died on +.services[18].drive.slot"
    assert result.services[18].drive.capacity == 300069052416, "Died on +.services[18].drive.capacity"
    assert result.services[18].drive.node_id == 4, "Died on +.services[18].drive.node_id"
    assert result.services[18].drive.drive_id == 2, "Died on +.services[18].drive.drive_id"
    assert result.services[18].drive.customer_slice_file_capacity == 0, "Died on +.services[18].drive.customer_slice_file_capacity"
    assert result.services[18].drive.assigned_service == 15, "Died on +.services[18].drive.assigned_service"
    assert result.services[18].drive.drive_type == """block""", "Died on +.services[18].drive.drive_type"
    assert type(result.services[18].drive.attributes) is dict, "Died on .services[18].drive.attributes"
    assert result.services[18].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR121400NA300EGN""", "Died on +.services[18].drive.serial"
    assert result.services[18].drive.reserved_slice_file_capacity == 0, "Died on +.services[18].drive.reserved_slice_file_capacity"
    assert result.services[18].drive.drive_status == """assigned""", "Died on +.services[18].drive.drive_status"
    assert result.services[18].service.status == """healthy""", "Died on +.services[18].service.status"
    assert result.services[18].service.associated_bv == 0, "Died on +.services[18].service.associated_bv"
    assert result.services[18].service.associated_ts == 0, "Died on +.services[18].service.associated_ts"
    assert result.services[18].service.associated_vs == 0, "Died on +.services[18].service.associated_vs"
    assert result.services[18].service.ipc_port == 4005, "Died on +.services[18].service.ipc_port"
    assert result.services[18].service.service_type == """block""", "Died on +.services[18].service.service_type"
    assert result.services[18].service.node_id == 4, "Died on +.services[18].service.node_id"
    assert result.services[18].service.drive_id == 2, "Died on +.services[18].service.drive_id"
    assert result.services[18].service.service_id == 15, "Died on +.services[18].service.service_id"
    assert result.services[18].service.iscsi_port == 0, "Died on +.services[18].service.iscsi_port"
    assert result.services[18].service.drive_ids[0] == 2, "Died on +.services[18].service.drive_ids[0]"
    assert result.services[18].service.first_time_startup == False, "Died on +.services[18].service.first_time_startup"
    assert result.services[18].service.started_drive_ids[0] == 2, "Died on +.services[18].service.started_drive_ids[0]"
    assert result.services[18].drives[0].slot == 0, "Died on +.services[18].drives[0].slot"
    assert result.services[18].drives[0].capacity == 300069052416, "Died on +.services[18].drives[0].capacity"
    assert result.services[18].drives[0].node_id == 4, "Died on +.services[18].drives[0].node_id"
    assert result.services[18].drives[0].drive_id == 2, "Died on +.services[18].drives[0].drive_id"
    assert result.services[18].drives[0].customer_slice_file_capacity == 0, "Died on +.services[18].drives[0].customer_slice_file_capacity"
    assert result.services[18].drives[0].assigned_service == 15, "Died on +.services[18].drives[0].assigned_service"
    assert result.services[18].drives[0].drive_type == """Block""", "Died on +.services[18].drives[0].drive_type"
    assert type(result.services[18].drives[0].attributes) is dict, "Died on .services[18].drives[0].attributes"
    assert result.services[18].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR121400NA300EGN""", "Died on +.services[18].drives[0].serial"
    assert result.services[18].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[18].drives[0].reserved_slice_file_capacity"
    assert result.services[18].drives[0].drive_status == """assigned""", "Died on +.services[18].drives[0].drive_status"
    assert result.services[17].node.sip == """10.117.62.25""", "Died on +.services[17].node.sip"
    assert result.services[17].node.name == """SF-F2A3""", "Died on +.services[17].node.name"
    assert result.services[17].node.platform_info.node_type == """SF3010""", "Died on +.services[17].node.platform_info.node_type"
    assert result.services[17].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[17].node.platform_info.cpu_model"
    assert result.services[17].node.platform_info.node_memory_gb == 72, "Died on +.services[17].node.platform_info.node_memory_gb"
    assert result.services[17].node.platform_info.chassis_type == """R620""", "Died on +.services[17].node.platform_info.chassis_type"
    assert result.services[17].node.cip == """10.117.62.25""", "Died on +.services[17].node.cip"
    assert result.services[17].node.sipi == """Bond10G""", "Died on +.services[17].node.sipi"
    assert result.services[17].node.node_id == 3, "Died on +.services[17].node.node_id"
    assert result.services[17].node.software_version == """9.0.0.1554""", "Died on +.services[17].node.software_version"
    assert result.services[17].node.mip == """10.117.60.25""", "Died on +.services[17].node.mip"
    assert result.services[17].node.associated_master_service_id == 4, "Died on +.services[17].node.associated_master_service_id"
    assert result.services[17].node.mipi == """Bond1G""", "Died on +.services[17].node.mipi"
    assert result.services[17].node.fibre_channel_target_port_group is None, "Died on .services[17].node.fibre_channel_target_port_group"
    assert type(result.services[17].node.attributes) is dict, "Died on .services[17].node.attributes"
    assert result.services[17].node.associated_fservice_id == 0, "Died on +.services[17].node.associated_fservice_id"
    assert result.services[17].node.cipi == """Bond10G""", "Died on +.services[17].node.cipi"
    assert result.services[17].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[17].node.uuid"
    assert result.services[17].drive.slot == -1, "Died on +.services[17].drive.slot"
    assert result.services[17].drive.capacity == 299988156416, "Died on +.services[17].drive.capacity"
    assert result.services[17].drive.node_id == 3, "Died on +.services[17].drive.node_id"
    assert result.services[17].drive.drive_id == 12, "Died on +.services[17].drive.drive_id"
    assert result.services[17].drive.customer_slice_file_capacity == 134994670387, "Died on +.services[17].drive.customer_slice_file_capacity"
    assert result.services[17].drive.assigned_service == 14, "Died on +.services[17].drive.assigned_service"
    assert result.services[17].drive.drive_type == """volume""", "Died on +.services[17].drive.drive_type"
    assert type(result.services[17].drive.attributes) is dict, "Died on .services[17].drive.attributes"
    assert result.services[17].drive.serial == """scsi-SATA_VRFSD3400GNCVMT205121578-part4""", "Died on +.services[17].drive.serial"
    assert result.services[17].drive.reserved_slice_file_capacity == 67497335193, "Died on +.services[17].drive.reserved_slice_file_capacity"
    assert result.services[17].drive.drive_status == """assigned""", "Died on +.services[17].drive.drive_status"
    assert result.services[17].service.status == """healthy""", "Died on +.services[17].service.status"
    assert result.services[17].service.associated_bv == 11, "Died on +.services[17].service.associated_bv"
    assert result.services[17].service.associated_ts == 13, "Died on +.services[17].service.associated_ts"
    assert result.services[17].service.associated_vs == 12, "Died on +.services[17].service.associated_vs"
    assert result.services[17].service.ipc_port == 4002, "Died on +.services[17].service.ipc_port"
    assert result.services[17].service.service_type == """slice""", "Died on +.services[17].service.service_type"
    assert result.services[17].service.node_id == 3, "Died on +.services[17].service.node_id"
    assert result.services[17].service.drive_id == 12, "Died on +.services[17].service.drive_id"
    assert result.services[17].service.service_id == 14, "Died on +.services[17].service.service_id"
    assert result.services[17].service.iscsi_port == 0, "Died on +.services[17].service.iscsi_port"
    assert result.services[17].service.drive_ids[0] == 12, "Died on +.services[17].service.drive_ids[0]"
    assert result.services[17].service.first_time_startup == False, "Died on +.services[17].service.first_time_startup"
    assert result.services[17].service.started_drive_ids[0] == 12, "Died on +.services[17].service.started_drive_ids[0]"
    assert result.services[17].drives[0].slot == -1, "Died on +.services[17].drives[0].slot"
    assert result.services[17].drives[0].capacity == 299988156416, "Died on +.services[17].drives[0].capacity"
    assert result.services[17].drives[0].node_id == 3, "Died on +.services[17].drives[0].node_id"
    assert result.services[17].drives[0].drive_id == 12, "Died on +.services[17].drives[0].drive_id"
    assert result.services[17].drives[0].customer_slice_file_capacity == 134994670387, "Died on +.services[17].drives[0].customer_slice_file_capacity"
    assert result.services[17].drives[0].assigned_service == 14, "Died on +.services[17].drives[0].assigned_service"
    assert result.services[17].drives[0].drive_type == """Slice""", "Died on +.services[17].drives[0].drive_type"
    assert type(result.services[17].drives[0].attributes) is dict, "Died on .services[17].drives[0].attributes"
    assert result.services[17].drives[0].serial == """scsi-SATA_VRFSD3400GNCVMT205121578-part4""", "Died on +.services[17].drives[0].serial"
    assert result.services[17].drives[0].reserved_slice_file_capacity == 67497335193, "Died on +.services[17].drives[0].reserved_slice_file_capacity"
    assert result.services[17].drives[0].drive_status == """assigned""", "Died on +.services[17].drives[0].drive_status"
    assert result.services[16].node.sip == """10.117.62.25""", "Died on +.services[16].node.sip"
    assert result.services[16].node.name == """SF-F2A3""", "Died on +.services[16].node.name"
    assert result.services[16].node.platform_info.node_type == """SF3010""", "Died on +.services[16].node.platform_info.node_type"
    assert result.services[16].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[16].node.platform_info.cpu_model"
    assert result.services[16].node.platform_info.node_memory_gb == 72, "Died on +.services[16].node.platform_info.node_memory_gb"
    assert result.services[16].node.platform_info.chassis_type == """R620""", "Died on +.services[16].node.platform_info.chassis_type"
    assert result.services[16].node.cip == """10.117.62.25""", "Died on +.services[16].node.cip"
    assert result.services[16].node.sipi == """Bond10G""", "Died on +.services[16].node.sipi"
    assert result.services[16].node.node_id == 3, "Died on +.services[16].node.node_id"
    assert result.services[16].node.software_version == """9.0.0.1554""", "Died on +.services[16].node.software_version"
    assert result.services[16].node.mip == """10.117.60.25""", "Died on +.services[16].node.mip"
    assert result.services[16].node.associated_master_service_id == 4, "Died on +.services[16].node.associated_master_service_id"
    assert result.services[16].node.mipi == """Bond1G""", "Died on +.services[16].node.mipi"
    assert result.services[16].node.fibre_channel_target_port_group is None, "Died on .services[16].node.fibre_channel_target_port_group"
    assert type(result.services[16].node.attributes) is dict, "Died on .services[16].node.attributes"
    assert result.services[16].node.associated_fservice_id == 0, "Died on +.services[16].node.associated_fservice_id"
    assert result.services[16].node.cipi == """Bond10G""", "Died on +.services[16].node.cipi"
    assert result.services[16].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[16].node.uuid"
    assert result.services[16].service.status == """healthy""", "Died on +.services[16].service.status"
    assert result.services[16].service.associated_bv == 0, "Died on +.services[16].service.associated_bv"
    assert result.services[16].service.associated_ts == 0, "Died on +.services[16].service.associated_ts"
    assert result.services[16].service.associated_vs == 0, "Died on +.services[16].service.associated_vs"
    assert result.services[16].service.ipc_port == 4004, "Died on +.services[16].service.ipc_port"
    assert result.services[16].service.service_type == """transport""", "Died on +.services[16].service.service_type"
    assert result.services[16].service.node_id == 3, "Died on +.services[16].service.node_id"
    assert result.services[16].service.drive_id == 0, "Died on +.services[16].service.drive_id"
    assert result.services[16].service.service_id == 13, "Died on +.services[16].service.service_id"
    assert result.services[16].service.iscsi_port == 3260, "Died on +.services[16].service.iscsi_port"
    assert result.services[16].service.first_time_startup == True, "Died on +.services[16].service.first_time_startup"
    assert result.services[15].node.sip == """10.117.62.25""", "Died on +.services[15].node.sip"
    assert result.services[15].node.name == """SF-F2A3""", "Died on +.services[15].node.name"
    assert result.services[15].node.platform_info.node_type == """SF3010""", "Died on +.services[15].node.platform_info.node_type"
    assert result.services[15].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[15].node.platform_info.cpu_model"
    assert result.services[15].node.platform_info.node_memory_gb == 72, "Died on +.services[15].node.platform_info.node_memory_gb"
    assert result.services[15].node.platform_info.chassis_type == """R620""", "Died on +.services[15].node.platform_info.chassis_type"
    assert result.services[15].node.cip == """10.117.62.25""", "Died on +.services[15].node.cip"
    assert result.services[15].node.sipi == """Bond10G""", "Died on +.services[15].node.sipi"
    assert result.services[15].node.node_id == 3, "Died on +.services[15].node.node_id"
    assert result.services[15].node.software_version == """9.0.0.1554""", "Died on +.services[15].node.software_version"
    assert result.services[15].node.mip == """10.117.60.25""", "Died on +.services[15].node.mip"
    assert result.services[15].node.associated_master_service_id == 4, "Died on +.services[15].node.associated_master_service_id"
    assert result.services[15].node.mipi == """Bond1G""", "Died on +.services[15].node.mipi"
    assert result.services[15].node.fibre_channel_target_port_group is None, "Died on .services[15].node.fibre_channel_target_port_group"
    assert type(result.services[15].node.attributes) is dict, "Died on .services[15].node.attributes"
    assert result.services[15].node.associated_fservice_id == 0, "Died on +.services[15].node.associated_fservice_id"
    assert result.services[15].node.cipi == """Bond10G""", "Died on +.services[15].node.cipi"
    assert result.services[15].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[15].node.uuid"
    assert result.services[15].drive.slot == 9, "Died on +.services[15].drive.slot"
    assert result.services[15].drive.capacity == 300069052416, "Died on +.services[15].drive.capacity"
    assert result.services[15].drive.node_id == 3, "Died on +.services[15].drive.node_id"
    assert result.services[15].drive.drive_id == 22, "Died on +.services[15].drive.drive_id"
    assert result.services[15].drive.customer_slice_file_capacity == 0, "Died on +.services[15].drive.customer_slice_file_capacity"
    assert result.services[15].drive.assigned_service == 34, "Died on +.services[15].drive.assigned_service"
    assert result.services[15].drive.drive_type == """block""", "Died on +.services[15].drive.drive_type"
    assert type(result.services[15].drive.attributes) is dict, "Died on .services[15].drive.attributes"
    assert result.services[15].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL3071045B300PGN""", "Died on +.services[15].drive.serial"
    assert result.services[15].drive.reserved_slice_file_capacity == 0, "Died on +.services[15].drive.reserved_slice_file_capacity"
    assert result.services[15].drive.drive_status == """assigned""", "Died on +.services[15].drive.drive_status"
    assert result.services[15].service.status == """healthy""", "Died on +.services[15].service.status"
    assert result.services[15].service.associated_bv == 0, "Died on +.services[15].service.associated_bv"
    assert result.services[15].service.associated_ts == 0, "Died on +.services[15].service.associated_ts"
    assert result.services[15].service.associated_vs == 0, "Died on +.services[15].service.associated_vs"
    assert result.services[15].service.ipc_port == 4014, "Died on +.services[15].service.ipc_port"
    assert result.services[15].service.service_type == """block""", "Died on +.services[15].service.service_type"
    assert result.services[15].service.node_id == 3, "Died on +.services[15].service.node_id"
    assert result.services[15].service.drive_id == 22, "Died on +.services[15].service.drive_id"
    assert result.services[15].service.service_id == 34, "Died on +.services[15].service.service_id"
    assert result.services[15].service.iscsi_port == 0, "Died on +.services[15].service.iscsi_port"
    assert result.services[15].service.drive_ids[0] == 22, "Died on +.services[15].service.drive_ids[0]"
    assert result.services[15].service.first_time_startup == False, "Died on +.services[15].service.first_time_startup"
    assert result.services[15].service.started_drive_ids[0] == 22, "Died on +.services[15].service.started_drive_ids[0]"
    assert result.services[15].drives[0].slot == 9, "Died on +.services[15].drives[0].slot"
    assert result.services[15].drives[0].capacity == 300069052416, "Died on +.services[15].drives[0].capacity"
    assert result.services[15].drives[0].node_id == 3, "Died on +.services[15].drives[0].node_id"
    assert result.services[15].drives[0].drive_id == 22, "Died on +.services[15].drives[0].drive_id"
    assert result.services[15].drives[0].customer_slice_file_capacity == 0, "Died on +.services[15].drives[0].customer_slice_file_capacity"
    assert result.services[15].drives[0].assigned_service == 34, "Died on +.services[15].drives[0].assigned_service"
    assert result.services[15].drives[0].drive_type == """Block""", "Died on +.services[15].drives[0].drive_type"
    assert type(result.services[15].drives[0].attributes) is dict, "Died on .services[15].drives[0].attributes"
    assert result.services[15].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL3071045B300PGN""", "Died on +.services[15].drives[0].serial"
    assert result.services[15].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[15].drives[0].reserved_slice_file_capacity"
    assert result.services[15].drives[0].drive_status == """assigned""", "Died on +.services[15].drives[0].drive_status"
    assert result.services[14].node.sip == """10.117.62.25""", "Died on +.services[14].node.sip"
    assert result.services[14].node.name == """SF-F2A3""", "Died on +.services[14].node.name"
    assert result.services[14].node.platform_info.node_type == """SF3010""", "Died on +.services[14].node.platform_info.node_type"
    assert result.services[14].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[14].node.platform_info.cpu_model"
    assert result.services[14].node.platform_info.node_memory_gb == 72, "Died on +.services[14].node.platform_info.node_memory_gb"
    assert result.services[14].node.platform_info.chassis_type == """R620""", "Died on +.services[14].node.platform_info.chassis_type"
    assert result.services[14].node.cip == """10.117.62.25""", "Died on +.services[14].node.cip"
    assert result.services[14].node.sipi == """Bond10G""", "Died on +.services[14].node.sipi"
    assert result.services[14].node.node_id == 3, "Died on +.services[14].node.node_id"
    assert result.services[14].node.software_version == """9.0.0.1554""", "Died on +.services[14].node.software_version"
    assert result.services[14].node.mip == """10.117.60.25""", "Died on +.services[14].node.mip"
    assert result.services[14].node.associated_master_service_id == 4, "Died on +.services[14].node.associated_master_service_id"
    assert result.services[14].node.mipi == """Bond1G""", "Died on +.services[14].node.mipi"
    assert result.services[14].node.fibre_channel_target_port_group is None, "Died on .services[14].node.fibre_channel_target_port_group"
    assert type(result.services[14].node.attributes) is dict, "Died on .services[14].node.attributes"
    assert result.services[14].node.associated_fservice_id == 0, "Died on +.services[14].node.associated_fservice_id"
    assert result.services[14].node.cipi == """Bond10G""", "Died on +.services[14].node.cipi"
    assert result.services[14].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[14].node.uuid"
    assert result.services[14].service.status == """healthy""", "Died on +.services[14].service.status"
    assert result.services[14].service.associated_bv == 0, "Died on +.services[14].service.associated_bv"
    assert result.services[14].service.associated_ts == 0, "Died on +.services[14].service.associated_ts"
    assert result.services[14].service.associated_vs == 0, "Died on +.services[14].service.associated_vs"
    assert result.services[14].service.ipc_port == 4003, "Died on +.services[14].service.ipc_port"
    assert result.services[14].service.service_type == """volume""", "Died on +.services[14].service.service_type"
    assert result.services[14].service.node_id == 3, "Died on +.services[14].service.node_id"
    assert result.services[14].service.drive_id == 0, "Died on +.services[14].service.drive_id"
    assert result.services[14].service.service_id == 12, "Died on +.services[14].service.service_id"
    assert result.services[14].service.iscsi_port == 0, "Died on +.services[14].service.iscsi_port"
    assert result.services[14].service.first_time_startup == True, "Died on +.services[14].service.first_time_startup"
    assert result.services[13].node.sip == """10.117.62.26""", "Died on +.services[13].node.sip"
    assert result.services[13].node.name == """SF-1713""", "Died on +.services[13].node.name"
    assert result.services[13].node.platform_info.node_type == """SF3010""", "Died on +.services[13].node.platform_info.node_type"
    assert result.services[13].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[13].node.platform_info.cpu_model"
    assert result.services[13].node.platform_info.node_memory_gb == 72, "Died on +.services[13].node.platform_info.node_memory_gb"
    assert result.services[13].node.platform_info.chassis_type == """R620""", "Died on +.services[13].node.platform_info.chassis_type"
    assert result.services[13].node.cip == """10.117.62.26""", "Died on +.services[13].node.cip"
    assert result.services[13].node.sipi == """Bond10G""", "Died on +.services[13].node.sipi"
    assert result.services[13].node.node_id == 4, "Died on +.services[13].node.node_id"
    assert result.services[13].node.software_version == """9.0.0.1554""", "Died on +.services[13].node.software_version"
    assert result.services[13].node.mip == """10.117.60.26""", "Died on +.services[13].node.mip"
    assert result.services[13].node.associated_master_service_id == 3, "Died on +.services[13].node.associated_master_service_id"
    assert result.services[13].node.mipi == """Bond1G""", "Died on +.services[13].node.mipi"
    assert result.services[13].node.fibre_channel_target_port_group is None, "Died on .services[13].node.fibre_channel_target_port_group"
    assert type(result.services[13].node.attributes) is dict, "Died on .services[13].node.attributes"
    assert result.services[13].node.associated_fservice_id == 0, "Died on +.services[13].node.associated_fservice_id"
    assert result.services[13].node.cipi == """Bond10G""", "Died on +.services[13].node.cipi"
    assert result.services[13].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[13].node.uuid"
    assert result.services[13].drive.slot == 9, "Died on +.services[13].drive.slot"
    assert result.services[13].drive.capacity == 300069052416, "Died on +.services[13].drive.capacity"
    assert result.services[13].drive.node_id == 4, "Died on +.services[13].drive.node_id"
    assert result.services[13].drive.drive_id == 11, "Died on +.services[13].drive.drive_id"
    assert result.services[13].drive.customer_slice_file_capacity == 0, "Died on +.services[13].drive.customer_slice_file_capacity"
    assert result.services[13].drive.assigned_service == 33, "Died on +.services[13].drive.assigned_service"
    assert result.services[13].drive.drive_type == """block""", "Died on +.services[13].drive.drive_type"
    assert type(result.services[13].drive.attributes) is dict, "Died on .services[13].drive.attributes"
    assert result.services[13].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227500TS300EGN""", "Died on +.services[13].drive.serial"
    assert result.services[13].drive.reserved_slice_file_capacity == 0, "Died on +.services[13].drive.reserved_slice_file_capacity"
    assert result.services[13].drive.drive_status == """assigned""", "Died on +.services[13].drive.drive_status"
    assert result.services[13].service.status == """healthy""", "Died on +.services[13].service.status"
    assert result.services[13].service.associated_bv == 0, "Died on +.services[13].service.associated_bv"
    assert result.services[13].service.associated_ts == 0, "Died on +.services[13].service.associated_ts"
    assert result.services[13].service.associated_vs == 0, "Died on +.services[13].service.associated_vs"
    assert result.services[13].service.ipc_port == 4014, "Died on +.services[13].service.ipc_port"
    assert result.services[13].service.service_type == """block""", "Died on +.services[13].service.service_type"
    assert result.services[13].service.node_id == 4, "Died on +.services[13].service.node_id"
    assert result.services[13].service.drive_id == 11, "Died on +.services[13].service.drive_id"
    assert result.services[13].service.service_id == 33, "Died on +.services[13].service.service_id"
    assert result.services[13].service.iscsi_port == 0, "Died on +.services[13].service.iscsi_port"
    assert result.services[13].service.drive_ids[0] == 11, "Died on +.services[13].service.drive_ids[0]"
    assert result.services[13].service.first_time_startup == False, "Died on +.services[13].service.first_time_startup"
    assert result.services[13].service.started_drive_ids[0] == 11, "Died on +.services[13].service.started_drive_ids[0]"
    assert result.services[13].drives[0].slot == 9, "Died on +.services[13].drives[0].slot"
    assert result.services[13].drives[0].capacity == 300069052416, "Died on +.services[13].drives[0].capacity"
    assert result.services[13].drives[0].node_id == 4, "Died on +.services[13].drives[0].node_id"
    assert result.services[13].drives[0].drive_id == 11, "Died on +.services[13].drives[0].drive_id"
    assert result.services[13].drives[0].customer_slice_file_capacity == 0, "Died on +.services[13].drives[0].customer_slice_file_capacity"
    assert result.services[13].drives[0].assigned_service == 33, "Died on +.services[13].drives[0].assigned_service"
    assert result.services[13].drives[0].drive_type == """Block""", "Died on +.services[13].drives[0].drive_type"
    assert type(result.services[13].drives[0].attributes) is dict, "Died on .services[13].drives[0].attributes"
    assert result.services[13].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227500TS300EGN""", "Died on +.services[13].drives[0].serial"
    assert result.services[13].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[13].drives[0].reserved_slice_file_capacity"
    assert result.services[13].drives[0].drive_status == """assigned""", "Died on +.services[13].drives[0].drive_status"
    assert result.services[12].node.sip == """10.117.62.25""", "Died on +.services[12].node.sip"
    assert result.services[12].node.name == """SF-F2A3""", "Died on +.services[12].node.name"
    assert result.services[12].node.platform_info.node_type == """SF3010""", "Died on +.services[12].node.platform_info.node_type"
    assert result.services[12].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[12].node.platform_info.cpu_model"
    assert result.services[12].node.platform_info.node_memory_gb == 72, "Died on +.services[12].node.platform_info.node_memory_gb"
    assert result.services[12].node.platform_info.chassis_type == """R620""", "Died on +.services[12].node.platform_info.chassis_type"
    assert result.services[12].node.cip == """10.117.62.25""", "Died on +.services[12].node.cip"
    assert result.services[12].node.sipi == """Bond10G""", "Died on +.services[12].node.sipi"
    assert result.services[12].node.node_id == 3, "Died on +.services[12].node.node_id"
    assert result.services[12].node.software_version == """9.0.0.1554""", "Died on +.services[12].node.software_version"
    assert result.services[12].node.mip == """10.117.60.25""", "Died on +.services[12].node.mip"
    assert result.services[12].node.associated_master_service_id == 4, "Died on +.services[12].node.associated_master_service_id"
    assert result.services[12].node.mipi == """Bond1G""", "Died on +.services[12].node.mipi"
    assert result.services[12].node.fibre_channel_target_port_group is None, "Died on .services[12].node.fibre_channel_target_port_group"
    assert type(result.services[12].node.attributes) is dict, "Died on .services[12].node.attributes"
    assert result.services[12].node.associated_fservice_id == 0, "Died on +.services[12].node.associated_fservice_id"
    assert result.services[12].node.cipi == """Bond10G""", "Died on +.services[12].node.cipi"
    assert result.services[12].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[12].node.uuid"
    assert result.services[12].service.status == """healthy""", "Died on +.services[12].service.status"
    assert result.services[12].service.associated_bv == 0, "Died on +.services[12].service.associated_bv"
    assert result.services[12].service.associated_ts == 0, "Died on +.services[12].service.associated_ts"
    assert result.services[12].service.associated_vs == 0, "Died on +.services[12].service.associated_vs"
    assert result.services[12].service.ipc_port == 4001, "Died on +.services[12].service.ipc_port"
    assert result.services[12].service.service_type == """bulkvolume""", "Died on +.services[12].service.service_type"
    assert result.services[12].service.node_id == 3, "Died on +.services[12].service.node_id"
    assert result.services[12].service.drive_id == 0, "Died on +.services[12].service.drive_id"
    assert result.services[12].service.service_id == 11, "Died on +.services[12].service.service_id"
    assert result.services[12].service.iscsi_port == 0, "Died on +.services[12].service.iscsi_port"
    assert result.services[12].service.first_time_startup == True, "Died on +.services[12].service.first_time_startup"
    assert result.services[11].node.sip == """10.117.62.25""", "Died on +.services[11].node.sip"
    assert result.services[11].node.name == """SF-F2A3""", "Died on +.services[11].node.name"
    assert result.services[11].node.platform_info.node_type == """SF3010""", "Died on +.services[11].node.platform_info.node_type"
    assert result.services[11].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[11].node.platform_info.cpu_model"
    assert result.services[11].node.platform_info.node_memory_gb == 72, "Died on +.services[11].node.platform_info.node_memory_gb"
    assert result.services[11].node.platform_info.chassis_type == """R620""", "Died on +.services[11].node.platform_info.chassis_type"
    assert result.services[11].node.cip == """10.117.62.25""", "Died on +.services[11].node.cip"
    assert result.services[11].node.sipi == """Bond10G""", "Died on +.services[11].node.sipi"
    assert result.services[11].node.node_id == 3, "Died on +.services[11].node.node_id"
    assert result.services[11].node.software_version == """9.0.0.1554""", "Died on +.services[11].node.software_version"
    assert result.services[11].node.mip == """10.117.60.25""", "Died on +.services[11].node.mip"
    assert result.services[11].node.associated_master_service_id == 4, "Died on +.services[11].node.associated_master_service_id"
    assert result.services[11].node.mipi == """Bond1G""", "Died on +.services[11].node.mipi"
    assert result.services[11].node.fibre_channel_target_port_group is None, "Died on .services[11].node.fibre_channel_target_port_group"
    assert type(result.services[11].node.attributes) is dict, "Died on .services[11].node.attributes"
    assert result.services[11].node.associated_fservice_id == 0, "Died on +.services[11].node.associated_fservice_id"
    assert result.services[11].node.cipi == """Bond10G""", "Died on +.services[11].node.cipi"
    assert result.services[11].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[11].node.uuid"
    assert result.services[11].drive.slot == 8, "Died on +.services[11].drive.slot"
    assert result.services[11].drive.capacity == 300069052416, "Died on +.services[11].drive.capacity"
    assert result.services[11].drive.node_id == 3, "Died on +.services[11].drive.node_id"
    assert result.services[11].drive.drive_id == 21, "Died on +.services[11].drive.drive_id"
    assert result.services[11].drive.customer_slice_file_capacity == 0, "Died on +.services[11].drive.customer_slice_file_capacity"
    assert result.services[11].drive.assigned_service == 32, "Died on +.services[11].drive.assigned_service"
    assert result.services[11].drive.drive_type == """block""", "Died on +.services[11].drive.drive_type"
    assert type(result.services[11].drive.attributes) is dict, "Died on .services[11].drive.attributes"
    assert result.services[11].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL3072006A300PGN""", "Died on +.services[11].drive.serial"
    assert result.services[11].drive.reserved_slice_file_capacity == 0, "Died on +.services[11].drive.reserved_slice_file_capacity"
    assert result.services[11].drive.drive_status == """assigned""", "Died on +.services[11].drive.drive_status"
    assert result.services[11].service.status == """healthy""", "Died on +.services[11].service.status"
    assert result.services[11].service.associated_bv == 0, "Died on +.services[11].service.associated_bv"
    assert result.services[11].service.associated_ts == 0, "Died on +.services[11].service.associated_ts"
    assert result.services[11].service.associated_vs == 0, "Died on +.services[11].service.associated_vs"
    assert result.services[11].service.ipc_port == 4013, "Died on +.services[11].service.ipc_port"
    assert result.services[11].service.service_type == """block""", "Died on +.services[11].service.service_type"
    assert result.services[11].service.node_id == 3, "Died on +.services[11].service.node_id"
    assert result.services[11].service.drive_id == 21, "Died on +.services[11].service.drive_id"
    assert result.services[11].service.service_id == 32, "Died on +.services[11].service.service_id"
    assert result.services[11].service.iscsi_port == 0, "Died on +.services[11].service.iscsi_port"
    assert result.services[11].service.drive_ids[0] == 21, "Died on +.services[11].service.drive_ids[0]"
    assert result.services[11].service.first_time_startup == False, "Died on +.services[11].service.first_time_startup"
    assert result.services[11].service.started_drive_ids[0] == 21, "Died on +.services[11].service.started_drive_ids[0]"
    assert result.services[11].drives[0].slot == 8, "Died on +.services[11].drives[0].slot"
    assert result.services[11].drives[0].capacity == 300069052416, "Died on +.services[11].drives[0].capacity"
    assert result.services[11].drives[0].node_id == 3, "Died on +.services[11].drives[0].node_id"
    assert result.services[11].drives[0].drive_id == 21, "Died on +.services[11].drives[0].drive_id"
    assert result.services[11].drives[0].customer_slice_file_capacity == 0, "Died on +.services[11].drives[0].customer_slice_file_capacity"
    assert result.services[11].drives[0].assigned_service == 32, "Died on +.services[11].drives[0].assigned_service"
    assert result.services[11].drives[0].drive_type == """Block""", "Died on +.services[11].drives[0].drive_type"
    assert type(result.services[11].drives[0].attributes) is dict, "Died on .services[11].drives[0].attributes"
    assert result.services[11].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL3072006A300PGN""", "Died on +.services[11].drives[0].serial"
    assert result.services[11].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[11].drives[0].reserved_slice_file_capacity"
    assert result.services[11].drives[0].drive_status == """assigned""", "Died on +.services[11].drives[0].drive_status"
    assert result.services[10].node.sip == """10.117.62.26""", "Died on +.services[10].node.sip"
    assert result.services[10].node.name == """SF-1713""", "Died on +.services[10].node.name"
    assert result.services[10].node.platform_info.node_type == """SF3010""", "Died on +.services[10].node.platform_info.node_type"
    assert result.services[10].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[10].node.platform_info.cpu_model"
    assert result.services[10].node.platform_info.node_memory_gb == 72, "Died on +.services[10].node.platform_info.node_memory_gb"
    assert result.services[10].node.platform_info.chassis_type == """R620""", "Died on +.services[10].node.platform_info.chassis_type"
    assert result.services[10].node.cip == """10.117.62.26""", "Died on +.services[10].node.cip"
    assert result.services[10].node.sipi == """Bond10G""", "Died on +.services[10].node.sipi"
    assert result.services[10].node.node_id == 4, "Died on +.services[10].node.node_id"
    assert result.services[10].node.software_version == """9.0.0.1554""", "Died on +.services[10].node.software_version"
    assert result.services[10].node.mip == """10.117.60.26""", "Died on +.services[10].node.mip"
    assert result.services[10].node.associated_master_service_id == 3, "Died on +.services[10].node.associated_master_service_id"
    assert result.services[10].node.mipi == """Bond1G""", "Died on +.services[10].node.mipi"
    assert result.services[10].node.fibre_channel_target_port_group is None, "Died on .services[10].node.fibre_channel_target_port_group"
    assert type(result.services[10].node.attributes) is dict, "Died on .services[10].node.attributes"
    assert result.services[10].node.associated_fservice_id == 0, "Died on +.services[10].node.associated_fservice_id"
    assert result.services[10].node.cipi == """Bond10G""", "Died on +.services[10].node.cipi"
    assert result.services[10].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[10].node.uuid"
    assert result.services[10].drive.slot == -1, "Died on +.services[10].drive.slot"
    assert result.services[10].drive.capacity == 299988156416, "Died on +.services[10].drive.capacity"
    assert result.services[10].drive.node_id == 4, "Died on +.services[10].drive.node_id"
    assert result.services[10].drive.drive_id == 1, "Died on +.services[10].drive.drive_id"
    assert result.services[10].drive.customer_slice_file_capacity == 134994670387, "Died on +.services[10].drive.customer_slice_file_capacity"
    assert result.services[10].drive.assigned_service == 10, "Died on +.services[10].drive.assigned_service"
    assert result.services[10].drive.drive_type == """volume""", "Died on +.services[10].drive.drive_type"
    assert type(result.services[10].drive.attributes) is dict, "Died on .services[10].drive.attributes"
    assert result.services[10].drive.serial == """scsi-SATA_VRFSD3400GNCVMT205121574-part4""", "Died on +.services[10].drive.serial"
    assert result.services[10].drive.reserved_slice_file_capacity == 67497335193, "Died on +.services[10].drive.reserved_slice_file_capacity"
    assert result.services[10].drive.drive_status == """assigned""", "Died on +.services[10].drive.drive_status"
    assert result.services[10].service.status == """healthy""", "Died on +.services[10].service.status"
    assert result.services[10].service.associated_bv == 7, "Died on +.services[10].service.associated_bv"
    assert result.services[10].service.associated_ts == 9, "Died on +.services[10].service.associated_ts"
    assert result.services[10].service.associated_vs == 8, "Died on +.services[10].service.associated_vs"
    assert result.services[10].service.ipc_port == 4002, "Died on +.services[10].service.ipc_port"
    assert result.services[10].service.service_type == """slice""", "Died on +.services[10].service.service_type"
    assert result.services[10].service.node_id == 4, "Died on +.services[10].service.node_id"
    assert result.services[10].service.drive_id == 1, "Died on +.services[10].service.drive_id"
    assert result.services[10].service.service_id == 10, "Died on +.services[10].service.service_id"
    assert result.services[10].service.iscsi_port == 0, "Died on +.services[10].service.iscsi_port"
    assert result.services[10].service.drive_ids[0] == 1, "Died on +.services[10].service.drive_ids[0]"
    assert result.services[10].service.first_time_startup == False, "Died on +.services[10].service.first_time_startup"
    assert result.services[10].service.started_drive_ids[0] == 1, "Died on +.services[10].service.started_drive_ids[0]"
    assert result.services[10].drives[0].slot == -1, "Died on +.services[10].drives[0].slot"
    assert result.services[10].drives[0].capacity == 299988156416, "Died on +.services[10].drives[0].capacity"
    assert result.services[10].drives[0].node_id == 4, "Died on +.services[10].drives[0].node_id"
    assert result.services[10].drives[0].drive_id == 1, "Died on +.services[10].drives[0].drive_id"
    assert result.services[10].drives[0].customer_slice_file_capacity == 134994670387, "Died on +.services[10].drives[0].customer_slice_file_capacity"
    assert result.services[10].drives[0].assigned_service == 10, "Died on +.services[10].drives[0].assigned_service"
    assert result.services[10].drives[0].drive_type == """Slice""", "Died on +.services[10].drives[0].drive_type"
    assert type(result.services[10].drives[0].attributes) is dict, "Died on .services[10].drives[0].attributes"
    assert result.services[10].drives[0].serial == """scsi-SATA_VRFSD3400GNCVMT205121574-part4""", "Died on +.services[10].drives[0].serial"
    assert result.services[10].drives[0].reserved_slice_file_capacity == 67497335193, "Died on +.services[10].drives[0].reserved_slice_file_capacity"
    assert result.services[10].drives[0].drive_status == """assigned""", "Died on +.services[10].drives[0].drive_status"
    assert result.services[9].node.sip == """10.117.62.26""", "Died on +.services[9].node.sip"
    assert result.services[9].node.name == """SF-1713""", "Died on +.services[9].node.name"
    assert result.services[9].node.platform_info.node_type == """SF3010""", "Died on +.services[9].node.platform_info.node_type"
    assert result.services[9].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[9].node.platform_info.cpu_model"
    assert result.services[9].node.platform_info.node_memory_gb == 72, "Died on +.services[9].node.platform_info.node_memory_gb"
    assert result.services[9].node.platform_info.chassis_type == """R620""", "Died on +.services[9].node.platform_info.chassis_type"
    assert result.services[9].node.cip == """10.117.62.26""", "Died on +.services[9].node.cip"
    assert result.services[9].node.sipi == """Bond10G""", "Died on +.services[9].node.sipi"
    assert result.services[9].node.node_id == 4, "Died on +.services[9].node.node_id"
    assert result.services[9].node.software_version == """9.0.0.1554""", "Died on +.services[9].node.software_version"
    assert result.services[9].node.mip == """10.117.60.26""", "Died on +.services[9].node.mip"
    assert result.services[9].node.associated_master_service_id == 3, "Died on +.services[9].node.associated_master_service_id"
    assert result.services[9].node.mipi == """Bond1G""", "Died on +.services[9].node.mipi"
    assert result.services[9].node.fibre_channel_target_port_group is None, "Died on .services[9].node.fibre_channel_target_port_group"
    assert type(result.services[9].node.attributes) is dict, "Died on .services[9].node.attributes"
    assert result.services[9].node.associated_fservice_id == 0, "Died on +.services[9].node.associated_fservice_id"
    assert result.services[9].node.cipi == """Bond10G""", "Died on +.services[9].node.cipi"
    assert result.services[9].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[9].node.uuid"
    assert result.services[9].drive.slot == 8, "Died on +.services[9].drive.slot"
    assert result.services[9].drive.capacity == 300069052416, "Died on +.services[9].drive.capacity"
    assert result.services[9].drive.node_id == 4, "Died on +.services[9].drive.node_id"
    assert result.services[9].drive.drive_id == 10, "Died on +.services[9].drive.drive_id"
    assert result.services[9].drive.customer_slice_file_capacity == 0, "Died on +.services[9].drive.customer_slice_file_capacity"
    assert result.services[9].drive.assigned_service == 31, "Died on +.services[9].drive.assigned_service"
    assert result.services[9].drive.drive_type == """block""", "Died on +.services[9].drive.drive_type"
    assert type(result.services[9].drive.attributes) is dict, "Died on .services[9].drive.attributes"
    assert result.services[9].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR2275018Z300EGN""", "Died on +.services[9].drive.serial"
    assert result.services[9].drive.reserved_slice_file_capacity == 0, "Died on +.services[9].drive.reserved_slice_file_capacity"
    assert result.services[9].drive.drive_status == """assigned""", "Died on +.services[9].drive.drive_status"
    assert result.services[9].service.status == """healthy""", "Died on +.services[9].service.status"
    assert result.services[9].service.associated_bv == 0, "Died on +.services[9].service.associated_bv"
    assert result.services[9].service.associated_ts == 0, "Died on +.services[9].service.associated_ts"
    assert result.services[9].service.associated_vs == 0, "Died on +.services[9].service.associated_vs"
    assert result.services[9].service.ipc_port == 4013, "Died on +.services[9].service.ipc_port"
    assert result.services[9].service.service_type == """block""", "Died on +.services[9].service.service_type"
    assert result.services[9].service.node_id == 4, "Died on +.services[9].service.node_id"
    assert result.services[9].service.drive_id == 10, "Died on +.services[9].service.drive_id"
    assert result.services[9].service.service_id == 31, "Died on +.services[9].service.service_id"
    assert result.services[9].service.iscsi_port == 0, "Died on +.services[9].service.iscsi_port"
    assert result.services[9].service.drive_ids[0] == 10, "Died on +.services[9].service.drive_ids[0]"
    assert result.services[9].service.first_time_startup == False, "Died on +.services[9].service.first_time_startup"
    assert result.services[9].service.started_drive_ids[0] == 10, "Died on +.services[9].service.started_drive_ids[0]"
    assert result.services[9].drives[0].slot == 8, "Died on +.services[9].drives[0].slot"
    assert result.services[9].drives[0].capacity == 300069052416, "Died on +.services[9].drives[0].capacity"
    assert result.services[9].drives[0].node_id == 4, "Died on +.services[9].drives[0].node_id"
    assert result.services[9].drives[0].drive_id == 10, "Died on +.services[9].drives[0].drive_id"
    assert result.services[9].drives[0].customer_slice_file_capacity == 0, "Died on +.services[9].drives[0].customer_slice_file_capacity"
    assert result.services[9].drives[0].assigned_service == 31, "Died on +.services[9].drives[0].assigned_service"
    assert result.services[9].drives[0].drive_type == """Block""", "Died on +.services[9].drives[0].drive_type"
    assert type(result.services[9].drives[0].attributes) is dict, "Died on .services[9].drives[0].attributes"
    assert result.services[9].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR2275018Z300EGN""", "Died on +.services[9].drives[0].serial"
    assert result.services[9].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[9].drives[0].reserved_slice_file_capacity"
    assert result.services[9].drives[0].drive_status == """assigned""", "Died on +.services[9].drives[0].drive_status"
    assert result.services[8].node.sip == """10.117.62.26""", "Died on +.services[8].node.sip"
    assert result.services[8].node.name == """SF-1713""", "Died on +.services[8].node.name"
    assert result.services[8].node.platform_info.node_type == """SF3010""", "Died on +.services[8].node.platform_info.node_type"
    assert result.services[8].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[8].node.platform_info.cpu_model"
    assert result.services[8].node.platform_info.node_memory_gb == 72, "Died on +.services[8].node.platform_info.node_memory_gb"
    assert result.services[8].node.platform_info.chassis_type == """R620""", "Died on +.services[8].node.platform_info.chassis_type"
    assert result.services[8].node.cip == """10.117.62.26""", "Died on +.services[8].node.cip"
    assert result.services[8].node.sipi == """Bond10G""", "Died on +.services[8].node.sipi"
    assert result.services[8].node.node_id == 4, "Died on +.services[8].node.node_id"
    assert result.services[8].node.software_version == """9.0.0.1554""", "Died on +.services[8].node.software_version"
    assert result.services[8].node.mip == """10.117.60.26""", "Died on +.services[8].node.mip"
    assert result.services[8].node.associated_master_service_id == 3, "Died on +.services[8].node.associated_master_service_id"
    assert result.services[8].node.mipi == """Bond1G""", "Died on +.services[8].node.mipi"
    assert result.services[8].node.fibre_channel_target_port_group is None, "Died on .services[8].node.fibre_channel_target_port_group"
    assert type(result.services[8].node.attributes) is dict, "Died on .services[8].node.attributes"
    assert result.services[8].node.associated_fservice_id == 0, "Died on +.services[8].node.associated_fservice_id"
    assert result.services[8].node.cipi == """Bond10G""", "Died on +.services[8].node.cipi"
    assert result.services[8].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[8].node.uuid"
    assert result.services[8].drive.slot == 7, "Died on +.services[8].drive.slot"
    assert result.services[8].drive.capacity == 300069052416, "Died on +.services[8].drive.capacity"
    assert result.services[8].drive.node_id == 4, "Died on +.services[8].drive.node_id"
    assert result.services[8].drive.drive_id == 9, "Died on +.services[8].drive.drive_id"
    assert result.services[8].drive.customer_slice_file_capacity == 0, "Died on +.services[8].drive.customer_slice_file_capacity"
    assert result.services[8].drive.assigned_service == 30, "Died on +.services[8].drive.assigned_service"
    assert result.services[8].drive.drive_type == """block""", "Died on +.services[8].drive.drive_type"
    assert type(result.services[8].drive.attributes) is dict, "Died on .services[8].drive.attributes"
    assert result.services[8].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227400QG300EGN""", "Died on +.services[8].drive.serial"
    assert result.services[8].drive.reserved_slice_file_capacity == 0, "Died on +.services[8].drive.reserved_slice_file_capacity"
    assert result.services[8].drive.drive_status == """assigned""", "Died on +.services[8].drive.drive_status"
    assert result.services[8].service.status == """healthy""", "Died on +.services[8].service.status"
    assert result.services[8].service.associated_bv == 0, "Died on +.services[8].service.associated_bv"
    assert result.services[8].service.associated_ts == 0, "Died on +.services[8].service.associated_ts"
    assert result.services[8].service.associated_vs == 0, "Died on +.services[8].service.associated_vs"
    assert result.services[8].service.ipc_port == 4012, "Died on +.services[8].service.ipc_port"
    assert result.services[8].service.service_type == """block""", "Died on +.services[8].service.service_type"
    assert result.services[8].service.node_id == 4, "Died on +.services[8].service.node_id"
    assert result.services[8].service.drive_id == 9, "Died on +.services[8].service.drive_id"
    assert result.services[8].service.service_id == 30, "Died on +.services[8].service.service_id"
    assert result.services[8].service.iscsi_port == 0, "Died on +.services[8].service.iscsi_port"
    assert result.services[8].service.drive_ids[0] == 9, "Died on +.services[8].service.drive_ids[0]"
    assert result.services[8].service.first_time_startup == False, "Died on +.services[8].service.first_time_startup"
    assert result.services[8].service.started_drive_ids[0] == 9, "Died on +.services[8].service.started_drive_ids[0]"
    assert result.services[8].drives[0].slot == 7, "Died on +.services[8].drives[0].slot"
    assert result.services[8].drives[0].capacity == 300069052416, "Died on +.services[8].drives[0].capacity"
    assert result.services[8].drives[0].node_id == 4, "Died on +.services[8].drives[0].node_id"
    assert result.services[8].drives[0].drive_id == 9, "Died on +.services[8].drives[0].drive_id"
    assert result.services[8].drives[0].customer_slice_file_capacity == 0, "Died on +.services[8].drives[0].customer_slice_file_capacity"
    assert result.services[8].drives[0].assigned_service == 30, "Died on +.services[8].drives[0].assigned_service"
    assert result.services[8].drives[0].drive_type == """Block""", "Died on +.services[8].drives[0].drive_type"
    assert type(result.services[8].drives[0].attributes) is dict, "Died on .services[8].drives[0].attributes"
    assert result.services[8].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227400QG300EGN""", "Died on +.services[8].drives[0].serial"
    assert result.services[8].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[8].drives[0].reserved_slice_file_capacity"
    assert result.services[8].drives[0].drive_status == """assigned""", "Died on +.services[8].drives[0].drive_status"
    assert result.services[7].node.sip == """10.117.62.25""", "Died on +.services[7].node.sip"
    assert result.services[7].node.name == """SF-F2A3""", "Died on +.services[7].node.name"
    assert result.services[7].node.platform_info.node_type == """SF3010""", "Died on +.services[7].node.platform_info.node_type"
    assert result.services[7].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[7].node.platform_info.cpu_model"
    assert result.services[7].node.platform_info.node_memory_gb == 72, "Died on +.services[7].node.platform_info.node_memory_gb"
    assert result.services[7].node.platform_info.chassis_type == """R620""", "Died on +.services[7].node.platform_info.chassis_type"
    assert result.services[7].node.cip == """10.117.62.25""", "Died on +.services[7].node.cip"
    assert result.services[7].node.sipi == """Bond10G""", "Died on +.services[7].node.sipi"
    assert result.services[7].node.node_id == 3, "Died on +.services[7].node.node_id"
    assert result.services[7].node.software_version == """9.0.0.1554""", "Died on +.services[7].node.software_version"
    assert result.services[7].node.mip == """10.117.60.25""", "Died on +.services[7].node.mip"
    assert result.services[7].node.associated_master_service_id == 4, "Died on +.services[7].node.associated_master_service_id"
    assert result.services[7].node.mipi == """Bond1G""", "Died on +.services[7].node.mipi"
    assert result.services[7].node.fibre_channel_target_port_group is None, "Died on .services[7].node.fibre_channel_target_port_group"
    assert type(result.services[7].node.attributes) is dict, "Died on .services[7].node.attributes"
    assert result.services[7].node.associated_fservice_id == 0, "Died on +.services[7].node.associated_fservice_id"
    assert result.services[7].node.cipi == """Bond10G""", "Died on +.services[7].node.cipi"
    assert result.services[7].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[7].node.uuid"
    assert result.services[7].drive.slot == 7, "Died on +.services[7].drive.slot"
    assert result.services[7].drive.capacity == 300069052416, "Died on +.services[7].drive.capacity"
    assert result.services[7].drive.node_id == 3, "Died on +.services[7].drive.node_id"
    assert result.services[7].drive.drive_id == 20, "Died on +.services[7].drive.drive_id"
    assert result.services[7].drive.customer_slice_file_capacity == 0, "Died on +.services[7].drive.customer_slice_file_capacity"
    assert result.services[7].drive.assigned_service == 29, "Died on +.services[7].drive.assigned_service"
    assert result.services[7].drive.drive_type == """block""", "Died on +.services[7].drive.drive_type"
    assert type(result.services[7].drive.attributes) is dict, "Died on .services[7].drive.attributes"
    assert result.services[7].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL305101U0300JGN""", "Died on +.services[7].drive.serial"
    assert result.services[7].drive.reserved_slice_file_capacity == 0, "Died on +.services[7].drive.reserved_slice_file_capacity"
    assert result.services[7].drive.drive_status == """assigned""", "Died on +.services[7].drive.drive_status"
    assert result.services[7].service.status == """healthy""", "Died on +.services[7].service.status"
    assert result.services[7].service.associated_bv == 0, "Died on +.services[7].service.associated_bv"
    assert result.services[7].service.associated_ts == 0, "Died on +.services[7].service.associated_ts"
    assert result.services[7].service.associated_vs == 0, "Died on +.services[7].service.associated_vs"
    assert result.services[7].service.ipc_port == 4012, "Died on +.services[7].service.ipc_port"
    assert result.services[7].service.service_type == """block""", "Died on +.services[7].service.service_type"
    assert result.services[7].service.node_id == 3, "Died on +.services[7].service.node_id"
    assert result.services[7].service.drive_id == 20, "Died on +.services[7].service.drive_id"
    assert result.services[7].service.service_id == 29, "Died on +.services[7].service.service_id"
    assert result.services[7].service.iscsi_port == 0, "Died on +.services[7].service.iscsi_port"
    assert result.services[7].service.drive_ids[0] == 20, "Died on +.services[7].service.drive_ids[0]"
    assert result.services[7].service.first_time_startup == False, "Died on +.services[7].service.first_time_startup"
    assert result.services[7].service.started_drive_ids[0] == 20, "Died on +.services[7].service.started_drive_ids[0]"
    assert result.services[7].drives[0].slot == 7, "Died on +.services[7].drives[0].slot"
    assert result.services[7].drives[0].capacity == 300069052416, "Died on +.services[7].drives[0].capacity"
    assert result.services[7].drives[0].node_id == 3, "Died on +.services[7].drives[0].node_id"
    assert result.services[7].drives[0].drive_id == 20, "Died on +.services[7].drives[0].drive_id"
    assert result.services[7].drives[0].customer_slice_file_capacity == 0, "Died on +.services[7].drives[0].customer_slice_file_capacity"
    assert result.services[7].drives[0].assigned_service == 29, "Died on +.services[7].drives[0].assigned_service"
    assert result.services[7].drives[0].drive_type == """Block""", "Died on +.services[7].drives[0].drive_type"
    assert type(result.services[7].drives[0].attributes) is dict, "Died on .services[7].drives[0].attributes"
    assert result.services[7].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL305101U0300JGN""", "Died on +.services[7].drives[0].serial"
    assert result.services[7].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[7].drives[0].reserved_slice_file_capacity"
    assert result.services[7].drives[0].drive_status == """assigned""", "Died on +.services[7].drives[0].drive_status"
    assert result.services[6].node.sip == """10.117.62.26""", "Died on +.services[6].node.sip"
    assert result.services[6].node.name == """SF-1713""", "Died on +.services[6].node.name"
    assert result.services[6].node.platform_info.node_type == """SF3010""", "Died on +.services[6].node.platform_info.node_type"
    assert result.services[6].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[6].node.platform_info.cpu_model"
    assert result.services[6].node.platform_info.node_memory_gb == 72, "Died on +.services[6].node.platform_info.node_memory_gb"
    assert result.services[6].node.platform_info.chassis_type == """R620""", "Died on +.services[6].node.platform_info.chassis_type"
    assert result.services[6].node.cip == """10.117.62.26""", "Died on +.services[6].node.cip"
    assert result.services[6].node.sipi == """Bond10G""", "Died on +.services[6].node.sipi"
    assert result.services[6].node.node_id == 4, "Died on +.services[6].node.node_id"
    assert result.services[6].node.software_version == """9.0.0.1554""", "Died on +.services[6].node.software_version"
    assert result.services[6].node.mip == """10.117.60.26""", "Died on +.services[6].node.mip"
    assert result.services[6].node.associated_master_service_id == 3, "Died on +.services[6].node.associated_master_service_id"
    assert result.services[6].node.mipi == """Bond1G""", "Died on +.services[6].node.mipi"
    assert result.services[6].node.fibre_channel_target_port_group is None, "Died on .services[6].node.fibre_channel_target_port_group"
    assert type(result.services[6].node.attributes) is dict, "Died on .services[6].node.attributes"
    assert result.services[6].node.associated_fservice_id == 0, "Died on +.services[6].node.associated_fservice_id"
    assert result.services[6].node.cipi == """Bond10G""", "Died on +.services[6].node.cipi"
    assert result.services[6].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[6].node.uuid"
    assert result.services[6].drive.slot == 6, "Died on +.services[6].drive.slot"
    assert result.services[6].drive.capacity == 300069052416, "Died on +.services[6].drive.capacity"
    assert result.services[6].drive.node_id == 4, "Died on +.services[6].drive.node_id"
    assert result.services[6].drive.drive_id == 8, "Died on +.services[6].drive.drive_id"
    assert result.services[6].drive.customer_slice_file_capacity == 0, "Died on +.services[6].drive.customer_slice_file_capacity"
    assert result.services[6].drive.assigned_service == 28, "Died on +.services[6].drive.assigned_service"
    assert result.services[6].drive.drive_type == """block""", "Died on +.services[6].drive.drive_type"
    assert type(result.services[6].drive.attributes) is dict, "Died on .services[6].drive.attributes"
    assert result.services[6].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227401S0300EGN""", "Died on +.services[6].drive.serial"
    assert result.services[6].drive.reserved_slice_file_capacity == 0, "Died on +.services[6].drive.reserved_slice_file_capacity"
    assert result.services[6].drive.drive_status == """assigned""", "Died on +.services[6].drive.drive_status"
    assert result.services[6].service.status == """healthy""", "Died on +.services[6].service.status"
    assert result.services[6].service.associated_bv == 0, "Died on +.services[6].service.associated_bv"
    assert result.services[6].service.associated_ts == 0, "Died on +.services[6].service.associated_ts"
    assert result.services[6].service.associated_vs == 0, "Died on +.services[6].service.associated_vs"
    assert result.services[6].service.ipc_port == 4011, "Died on +.services[6].service.ipc_port"
    assert result.services[6].service.service_type == """block""", "Died on +.services[6].service.service_type"
    assert result.services[6].service.node_id == 4, "Died on +.services[6].service.node_id"
    assert result.services[6].service.drive_id == 8, "Died on +.services[6].service.drive_id"
    assert result.services[6].service.service_id == 28, "Died on +.services[6].service.service_id"
    assert result.services[6].service.iscsi_port == 0, "Died on +.services[6].service.iscsi_port"
    assert result.services[6].service.drive_ids[0] == 8, "Died on +.services[6].service.drive_ids[0]"
    assert result.services[6].service.first_time_startup == False, "Died on +.services[6].service.first_time_startup"
    assert result.services[6].service.started_drive_ids[0] == 8, "Died on +.services[6].service.started_drive_ids[0]"
    assert result.services[6].drives[0].slot == 6, "Died on +.services[6].drives[0].slot"
    assert result.services[6].drives[0].capacity == 300069052416, "Died on +.services[6].drives[0].capacity"
    assert result.services[6].drives[0].node_id == 4, "Died on +.services[6].drives[0].node_id"
    assert result.services[6].drives[0].drive_id == 8, "Died on +.services[6].drives[0].drive_id"
    assert result.services[6].drives[0].customer_slice_file_capacity == 0, "Died on +.services[6].drives[0].customer_slice_file_capacity"
    assert result.services[6].drives[0].assigned_service == 28, "Died on +.services[6].drives[0].assigned_service"
    assert result.services[6].drives[0].drive_type == """Block""", "Died on +.services[6].drives[0].drive_type"
    assert type(result.services[6].drives[0].attributes) is dict, "Died on .services[6].drives[0].attributes"
    assert result.services[6].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227401S0300EGN""", "Died on +.services[6].drives[0].serial"
    assert result.services[6].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[6].drives[0].reserved_slice_file_capacity"
    assert result.services[6].drives[0].drive_status == """assigned""", "Died on +.services[6].drives[0].drive_status"
    assert result.services[5].node.sip == """10.117.62.25""", "Died on +.services[5].node.sip"
    assert result.services[5].node.name == """SF-F2A3""", "Died on +.services[5].node.name"
    assert result.services[5].node.platform_info.node_type == """SF3010""", "Died on +.services[5].node.platform_info.node_type"
    assert result.services[5].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[5].node.platform_info.cpu_model"
    assert result.services[5].node.platform_info.node_memory_gb == 72, "Died on +.services[5].node.platform_info.node_memory_gb"
    assert result.services[5].node.platform_info.chassis_type == """R620""", "Died on +.services[5].node.platform_info.chassis_type"
    assert result.services[5].node.cip == """10.117.62.25""", "Died on +.services[5].node.cip"
    assert result.services[5].node.sipi == """Bond10G""", "Died on +.services[5].node.sipi"
    assert result.services[5].node.node_id == 3, "Died on +.services[5].node.node_id"
    assert result.services[5].node.software_version == """9.0.0.1554""", "Died on +.services[5].node.software_version"
    assert result.services[5].node.mip == """10.117.60.25""", "Died on +.services[5].node.mip"
    assert result.services[5].node.associated_master_service_id == 4, "Died on +.services[5].node.associated_master_service_id"
    assert result.services[5].node.mipi == """Bond1G""", "Died on +.services[5].node.mipi"
    assert result.services[5].node.fibre_channel_target_port_group is None, "Died on .services[5].node.fibre_channel_target_port_group"
    assert type(result.services[5].node.attributes) is dict, "Died on .services[5].node.attributes"
    assert result.services[5].node.associated_fservice_id == 0, "Died on +.services[5].node.associated_fservice_id"
    assert result.services[5].node.cipi == """Bond10G""", "Died on +.services[5].node.cipi"
    assert result.services[5].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[5].node.uuid"
    assert result.services[5].drive.slot == 6, "Died on +.services[5].drive.slot"
    assert result.services[5].drive.capacity == 300069052416, "Died on +.services[5].drive.capacity"
    assert result.services[5].drive.node_id == 3, "Died on +.services[5].drive.node_id"
    assert result.services[5].drive.drive_id == 19, "Died on +.services[5].drive.drive_id"
    assert result.services[5].drive.customer_slice_file_capacity == 0, "Died on +.services[5].drive.customer_slice_file_capacity"
    assert result.services[5].drive.assigned_service == 27, "Died on +.services[5].drive.assigned_service"
    assert result.services[5].drive.drive_type == """block""", "Died on +.services[5].drive.drive_type"
    assert type(result.services[5].drive.attributes) is dict, "Died on .services[5].drive.attributes"
    assert result.services[5].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL307103KD300PGN""", "Died on +.services[5].drive.serial"
    assert result.services[5].drive.reserved_slice_file_capacity == 0, "Died on +.services[5].drive.reserved_slice_file_capacity"
    assert result.services[5].drive.drive_status == """assigned""", "Died on +.services[5].drive.drive_status"
    assert result.services[5].service.status == """healthy""", "Died on +.services[5].service.status"
    assert result.services[5].service.associated_bv == 0, "Died on +.services[5].service.associated_bv"
    assert result.services[5].service.associated_ts == 0, "Died on +.services[5].service.associated_ts"
    assert result.services[5].service.associated_vs == 0, "Died on +.services[5].service.associated_vs"
    assert result.services[5].service.ipc_port == 4011, "Died on +.services[5].service.ipc_port"
    assert result.services[5].service.service_type == """block""", "Died on +.services[5].service.service_type"
    assert result.services[5].service.node_id == 3, "Died on +.services[5].service.node_id"
    assert result.services[5].service.drive_id == 19, "Died on +.services[5].service.drive_id"
    assert result.services[5].service.service_id == 27, "Died on +.services[5].service.service_id"
    assert result.services[5].service.iscsi_port == 0, "Died on +.services[5].service.iscsi_port"
    assert result.services[5].service.drive_ids[0] == 19, "Died on +.services[5].service.drive_ids[0]"
    assert result.services[5].service.first_time_startup == False, "Died on +.services[5].service.first_time_startup"
    assert result.services[5].service.started_drive_ids[0] == 19, "Died on +.services[5].service.started_drive_ids[0]"
    assert result.services[5].drives[0].slot == 6, "Died on +.services[5].drives[0].slot"
    assert result.services[5].drives[0].capacity == 300069052416, "Died on +.services[5].drives[0].capacity"
    assert result.services[5].drives[0].node_id == 3, "Died on +.services[5].drives[0].node_id"
    assert result.services[5].drives[0].drive_id == 19, "Died on +.services[5].drives[0].drive_id"
    assert result.services[5].drives[0].customer_slice_file_capacity == 0, "Died on +.services[5].drives[0].customer_slice_file_capacity"
    assert result.services[5].drives[0].assigned_service == 27, "Died on +.services[5].drives[0].assigned_service"
    assert result.services[5].drives[0].drive_type == """Block""", "Died on +.services[5].drives[0].drive_type"
    assert type(result.services[5].drives[0].attributes) is dict, "Died on .services[5].drives[0].attributes"
    assert result.services[5].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL307103KD300PGN""", "Died on +.services[5].drives[0].serial"
    assert result.services[5].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[5].drives[0].reserved_slice_file_capacity"
    assert result.services[5].drives[0].drive_status == """assigned""", "Died on +.services[5].drives[0].drive_status"
    assert result.services[4].node.sip == """10.117.62.26""", "Died on +.services[4].node.sip"
    assert result.services[4].node.name == """SF-1713""", "Died on +.services[4].node.name"
    assert result.services[4].node.platform_info.node_type == """SF3010""", "Died on +.services[4].node.platform_info.node_type"
    assert result.services[4].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[4].node.platform_info.cpu_model"
    assert result.services[4].node.platform_info.node_memory_gb == 72, "Died on +.services[4].node.platform_info.node_memory_gb"
    assert result.services[4].node.platform_info.chassis_type == """R620""", "Died on +.services[4].node.platform_info.chassis_type"
    assert result.services[4].node.cip == """10.117.62.26""", "Died on +.services[4].node.cip"
    assert result.services[4].node.sipi == """Bond10G""", "Died on +.services[4].node.sipi"
    assert result.services[4].node.node_id == 4, "Died on +.services[4].node.node_id"
    assert result.services[4].node.software_version == """9.0.0.1554""", "Died on +.services[4].node.software_version"
    assert result.services[4].node.mip == """10.117.60.26""", "Died on +.services[4].node.mip"
    assert result.services[4].node.associated_master_service_id == 3, "Died on +.services[4].node.associated_master_service_id"
    assert result.services[4].node.mipi == """Bond1G""", "Died on +.services[4].node.mipi"
    assert result.services[4].node.fibre_channel_target_port_group is None, "Died on .services[4].node.fibre_channel_target_port_group"
    assert type(result.services[4].node.attributes) is dict, "Died on .services[4].node.attributes"
    assert result.services[4].node.associated_fservice_id == 0, "Died on +.services[4].node.associated_fservice_id"
    assert result.services[4].node.cipi == """Bond10G""", "Died on +.services[4].node.cipi"
    assert result.services[4].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[4].node.uuid"
    assert result.services[4].drive.slot == 5, "Died on +.services[4].drive.slot"
    assert result.services[4].drive.capacity == 300069052416, "Died on +.services[4].drive.capacity"
    assert result.services[4].drive.node_id == 4, "Died on +.services[4].drive.node_id"
    assert result.services[4].drive.drive_id == 7, "Died on +.services[4].drive.drive_id"
    assert result.services[4].drive.customer_slice_file_capacity == 0, "Died on +.services[4].drive.customer_slice_file_capacity"
    assert result.services[4].drive.assigned_service == 26, "Died on +.services[4].drive.assigned_service"
    assert result.services[4].drive.drive_type == """block""", "Died on +.services[4].drive.drive_type"
    assert type(result.services[4].drive.attributes) is dict, "Died on .services[4].drive.attributes"
    assert result.services[4].drive.serial == """scsi-SATA_INTEL_SSDSA2BW3CVPR120504CK300EGN""", "Died on +.services[4].drive.serial"
    assert result.services[4].drive.reserved_slice_file_capacity == 0, "Died on +.services[4].drive.reserved_slice_file_capacity"
    assert result.services[4].drive.drive_status == """assigned""", "Died on +.services[4].drive.drive_status"
    assert result.services[4].service.status == """healthy""", "Died on +.services[4].service.status"
    assert result.services[4].service.associated_bv == 0, "Died on +.services[4].service.associated_bv"
    assert result.services[4].service.associated_ts == 0, "Died on +.services[4].service.associated_ts"
    assert result.services[4].service.associated_vs == 0, "Died on +.services[4].service.associated_vs"
    assert result.services[4].service.ipc_port == 4010, "Died on +.services[4].service.ipc_port"
    assert result.services[4].service.service_type == """block""", "Died on +.services[4].service.service_type"
    assert result.services[4].service.node_id == 4, "Died on +.services[4].service.node_id"
    assert result.services[4].service.drive_id == 7, "Died on +.services[4].service.drive_id"
    assert result.services[4].service.service_id == 26, "Died on +.services[4].service.service_id"
    assert result.services[4].service.iscsi_port == 0, "Died on +.services[4].service.iscsi_port"
    assert result.services[4].service.drive_ids[0] == 7, "Died on +.services[4].service.drive_ids[0]"
    assert result.services[4].service.first_time_startup == False, "Died on +.services[4].service.first_time_startup"
    assert result.services[4].service.started_drive_ids[0] == 7, "Died on +.services[4].service.started_drive_ids[0]"
    assert result.services[4].drives[0].slot == 5, "Died on +.services[4].drives[0].slot"
    assert result.services[4].drives[0].capacity == 300069052416, "Died on +.services[4].drives[0].capacity"
    assert result.services[4].drives[0].node_id == 4, "Died on +.services[4].drives[0].node_id"
    assert result.services[4].drives[0].drive_id == 7, "Died on +.services[4].drives[0].drive_id"
    assert result.services[4].drives[0].customer_slice_file_capacity == 0, "Died on +.services[4].drives[0].customer_slice_file_capacity"
    assert result.services[4].drives[0].assigned_service == 26, "Died on +.services[4].drives[0].assigned_service"
    assert result.services[4].drives[0].drive_type == """Block""", "Died on +.services[4].drives[0].drive_type"
    assert type(result.services[4].drives[0].attributes) is dict, "Died on .services[4].drives[0].attributes"
    assert result.services[4].drives[0].serial == """scsi-SATA_INTEL_SSDSA2BW3CVPR120504CK300EGN""", "Died on +.services[4].drives[0].serial"
    assert result.services[4].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[4].drives[0].reserved_slice_file_capacity"
    assert result.services[4].drives[0].drive_status == """assigned""", "Died on +.services[4].drives[0].drive_status"
    assert result.services[3].node.sip == """10.117.62.25""", "Died on +.services[3].node.sip"
    assert result.services[3].node.name == """SF-F2A3""", "Died on +.services[3].node.name"
    assert result.services[3].node.platform_info.node_type == """SF3010""", "Died on +.services[3].node.platform_info.node_type"
    assert result.services[3].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[3].node.platform_info.cpu_model"
    assert result.services[3].node.platform_info.node_memory_gb == 72, "Died on +.services[3].node.platform_info.node_memory_gb"
    assert result.services[3].node.platform_info.chassis_type == """R620""", "Died on +.services[3].node.platform_info.chassis_type"
    assert result.services[3].node.cip == """10.117.62.25""", "Died on +.services[3].node.cip"
    assert result.services[3].node.sipi == """Bond10G""", "Died on +.services[3].node.sipi"
    assert result.services[3].node.node_id == 3, "Died on +.services[3].node.node_id"
    assert result.services[3].node.software_version == """9.0.0.1554""", "Died on +.services[3].node.software_version"
    assert result.services[3].node.mip == """10.117.60.25""", "Died on +.services[3].node.mip"
    assert result.services[3].node.associated_master_service_id == 4, "Died on +.services[3].node.associated_master_service_id"
    assert result.services[3].node.mipi == """Bond1G""", "Died on +.services[3].node.mipi"
    assert result.services[3].node.fibre_channel_target_port_group is None, "Died on .services[3].node.fibre_channel_target_port_group"
    assert type(result.services[3].node.attributes) is dict, "Died on .services[3].node.attributes"
    assert result.services[3].node.associated_fservice_id == 0, "Died on +.services[3].node.associated_fservice_id"
    assert result.services[3].node.cipi == """Bond10G""", "Died on +.services[3].node.cipi"
    assert result.services[3].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[3].node.uuid"
    assert result.services[3].drive.slot == 5, "Died on +.services[3].drive.slot"
    assert result.services[3].drive.capacity == 300069052416, "Died on +.services[3].drive.capacity"
    assert result.services[3].drive.node_id == 3, "Died on +.services[3].drive.node_id"
    assert result.services[3].drive.drive_id == 18, "Died on +.services[3].drive.drive_id"
    assert result.services[3].drive.customer_slice_file_capacity == 0, "Died on +.services[3].drive.customer_slice_file_capacity"
    assert result.services[3].drive.assigned_service == 25, "Died on +.services[3].drive.assigned_service"
    assert result.services[3].drive.drive_type == """block""", "Died on +.services[3].drive.drive_type"
    assert type(result.services[3].drive.attributes) is dict, "Died on .services[3].drive.attributes"
    assert result.services[3].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL31130138300PGN""", "Died on +.services[3].drive.serial"
    assert result.services[3].drive.reserved_slice_file_capacity == 0, "Died on +.services[3].drive.reserved_slice_file_capacity"
    assert result.services[3].drive.drive_status == """assigned""", "Died on +.services[3].drive.drive_status"
    assert result.services[3].service.status == """healthy""", "Died on +.services[3].service.status"
    assert result.services[3].service.associated_bv == 0, "Died on +.services[3].service.associated_bv"
    assert result.services[3].service.associated_ts == 0, "Died on +.services[3].service.associated_ts"
    assert result.services[3].service.associated_vs == 0, "Died on +.services[3].service.associated_vs"
    assert result.services[3].service.ipc_port == 4010, "Died on +.services[3].service.ipc_port"
    assert result.services[3].service.service_type == """block""", "Died on +.services[3].service.service_type"
    assert result.services[3].service.node_id == 3, "Died on +.services[3].service.node_id"
    assert result.services[3].service.drive_id == 18, "Died on +.services[3].service.drive_id"
    assert result.services[3].service.service_id == 25, "Died on +.services[3].service.service_id"
    assert result.services[3].service.iscsi_port == 0, "Died on +.services[3].service.iscsi_port"
    assert result.services[3].service.drive_ids[0] == 18, "Died on +.services[3].service.drive_ids[0]"
    assert result.services[3].service.first_time_startup == False, "Died on +.services[3].service.first_time_startup"
    assert result.services[3].service.started_drive_ids[0] == 18, "Died on +.services[3].service.started_drive_ids[0]"
    assert result.services[3].drives[0].slot == 5, "Died on +.services[3].drives[0].slot"
    assert result.services[3].drives[0].capacity == 300069052416, "Died on +.services[3].drives[0].capacity"
    assert result.services[3].drives[0].node_id == 3, "Died on +.services[3].drives[0].node_id"
    assert result.services[3].drives[0].drive_id == 18, "Died on +.services[3].drives[0].drive_id"
    assert result.services[3].drives[0].customer_slice_file_capacity == 0, "Died on +.services[3].drives[0].customer_slice_file_capacity"
    assert result.services[3].drives[0].assigned_service == 25, "Died on +.services[3].drives[0].assigned_service"
    assert result.services[3].drives[0].drive_type == """Block""", "Died on +.services[3].drives[0].drive_type"
    assert type(result.services[3].drives[0].attributes) is dict, "Died on .services[3].drives[0].attributes"
    assert result.services[3].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL31130138300PGN""", "Died on +.services[3].drives[0].serial"
    assert result.services[3].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[3].drives[0].reserved_slice_file_capacity"
    assert result.services[3].drives[0].drive_status == """assigned""", "Died on +.services[3].drives[0].drive_status"
    assert result.services[2].node.sip == """10.117.62.26""", "Died on +.services[2].node.sip"
    assert result.services[2].node.name == """SF-1713""", "Died on +.services[2].node.name"
    assert result.services[2].node.platform_info.node_type == """SF3010""", "Died on +.services[2].node.platform_info.node_type"
    assert result.services[2].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[2].node.platform_info.cpu_model"
    assert result.services[2].node.platform_info.node_memory_gb == 72, "Died on +.services[2].node.platform_info.node_memory_gb"
    assert result.services[2].node.platform_info.chassis_type == """R620""", "Died on +.services[2].node.platform_info.chassis_type"
    assert result.services[2].node.cip == """10.117.62.26""", "Died on +.services[2].node.cip"
    assert result.services[2].node.sipi == """Bond10G""", "Died on +.services[2].node.sipi"
    assert result.services[2].node.node_id == 4, "Died on +.services[2].node.node_id"
    assert result.services[2].node.software_version == """9.0.0.1554""", "Died on +.services[2].node.software_version"
    assert result.services[2].node.mip == """10.117.60.26""", "Died on +.services[2].node.mip"
    assert result.services[2].node.associated_master_service_id == 3, "Died on +.services[2].node.associated_master_service_id"
    assert result.services[2].node.mipi == """Bond1G""", "Died on +.services[2].node.mipi"
    assert result.services[2].node.fibre_channel_target_port_group is None, "Died on .services[2].node.fibre_channel_target_port_group"
    assert type(result.services[2].node.attributes) is dict, "Died on .services[2].node.attributes"
    assert result.services[2].node.associated_fservice_id == 0, "Died on +.services[2].node.associated_fservice_id"
    assert result.services[2].node.cipi == """Bond10G""", "Died on +.services[2].node.cipi"
    assert result.services[2].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[2].node.uuid"
    assert result.services[2].drive.slot == 4, "Died on +.services[2].drive.slot"
    assert result.services[2].drive.capacity == 300069052416, "Died on +.services[2].drive.capacity"
    assert result.services[2].drive.node_id == 4, "Died on +.services[2].drive.node_id"
    assert result.services[2].drive.drive_id == 6, "Died on +.services[2].drive.drive_id"
    assert result.services[2].drive.customer_slice_file_capacity == 0, "Died on +.services[2].drive.customer_slice_file_capacity"
    assert result.services[2].drive.assigned_service == 24, "Died on +.services[2].drive.assigned_service"
    assert result.services[2].drive.drive_type == """block""", "Died on +.services[2].drive.drive_type"
    assert type(result.services[2].drive.attributes) is dict, "Died on .services[2].drive.attributes"
    assert result.services[2].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227401VN300EGN""", "Died on +.services[2].drive.serial"
    assert result.services[2].drive.reserved_slice_file_capacity == 0, "Died on +.services[2].drive.reserved_slice_file_capacity"
    assert result.services[2].drive.drive_status == """assigned""", "Died on +.services[2].drive.drive_status"
    assert result.services[2].service.status == """healthy""", "Died on +.services[2].service.status"
    assert result.services[2].service.associated_bv == 0, "Died on +.services[2].service.associated_bv"
    assert result.services[2].service.associated_ts == 0, "Died on +.services[2].service.associated_ts"
    assert result.services[2].service.associated_vs == 0, "Died on +.services[2].service.associated_vs"
    assert result.services[2].service.ipc_port == 4009, "Died on +.services[2].service.ipc_port"
    assert result.services[2].service.service_type == """block""", "Died on +.services[2].service.service_type"
    assert result.services[2].service.node_id == 4, "Died on +.services[2].service.node_id"
    assert result.services[2].service.drive_id == 6, "Died on +.services[2].service.drive_id"
    assert result.services[2].service.service_id == 24, "Died on +.services[2].service.service_id"
    assert result.services[2].service.iscsi_port == 0, "Died on +.services[2].service.iscsi_port"
    assert result.services[2].service.drive_ids[0] == 6, "Died on +.services[2].service.drive_ids[0]"
    assert result.services[2].service.first_time_startup == False, "Died on +.services[2].service.first_time_startup"
    assert result.services[2].service.started_drive_ids[0] == 6, "Died on +.services[2].service.started_drive_ids[0]"
    assert result.services[2].drives[0].slot == 4, "Died on +.services[2].drives[0].slot"
    assert result.services[2].drives[0].capacity == 300069052416, "Died on +.services[2].drives[0].capacity"
    assert result.services[2].drives[0].node_id == 4, "Died on +.services[2].drives[0].node_id"
    assert result.services[2].drives[0].drive_id == 6, "Died on +.services[2].drives[0].drive_id"
    assert result.services[2].drives[0].customer_slice_file_capacity == 0, "Died on +.services[2].drives[0].customer_slice_file_capacity"
    assert result.services[2].drives[0].assigned_service == 24, "Died on +.services[2].drives[0].assigned_service"
    assert result.services[2].drives[0].drive_type == """Block""", "Died on +.services[2].drives[0].drive_type"
    assert type(result.services[2].drives[0].attributes) is dict, "Died on .services[2].drives[0].attributes"
    assert result.services[2].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3BTPR227401VN300EGN""", "Died on +.services[2].drives[0].serial"
    assert result.services[2].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[2].drives[0].reserved_slice_file_capacity"
    assert result.services[2].drives[0].drive_status == """assigned""", "Died on +.services[2].drives[0].drive_status"
    assert result.services[1].node.sip == """10.117.62.25""", "Died on +.services[1].node.sip"
    assert result.services[1].node.name == """SF-F2A3""", "Died on +.services[1].node.name"
    assert result.services[1].node.platform_info.node_type == """SF3010""", "Died on +.services[1].node.platform_info.node_type"
    assert result.services[1].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[1].node.platform_info.cpu_model"
    assert result.services[1].node.platform_info.node_memory_gb == 72, "Died on +.services[1].node.platform_info.node_memory_gb"
    assert result.services[1].node.platform_info.chassis_type == """R620""", "Died on +.services[1].node.platform_info.chassis_type"
    assert result.services[1].node.cip == """10.117.62.25""", "Died on +.services[1].node.cip"
    assert result.services[1].node.sipi == """Bond10G""", "Died on +.services[1].node.sipi"
    assert result.services[1].node.node_id == 3, "Died on +.services[1].node.node_id"
    assert result.services[1].node.software_version == """9.0.0.1554""", "Died on +.services[1].node.software_version"
    assert result.services[1].node.mip == """10.117.60.25""", "Died on +.services[1].node.mip"
    assert result.services[1].node.associated_master_service_id == 4, "Died on +.services[1].node.associated_master_service_id"
    assert result.services[1].node.mipi == """Bond1G""", "Died on +.services[1].node.mipi"
    assert result.services[1].node.fibre_channel_target_port_group is None, "Died on .services[1].node.fibre_channel_target_port_group"
    assert type(result.services[1].node.attributes) is dict, "Died on .services[1].node.attributes"
    assert result.services[1].node.associated_fservice_id == 0, "Died on +.services[1].node.associated_fservice_id"
    assert result.services[1].node.cipi == """Bond10G""", "Died on +.services[1].node.cipi"
    assert result.services[1].node.uuid == UUID("4C4C4544-0053-3310-8053-B6C04F435831"), "Died on .services[1].node.uuid"
    assert result.services[1].drive.slot == 4, "Died on +.services[1].drive.slot"
    assert result.services[1].drive.capacity == 300069052416, "Died on +.services[1].drive.capacity"
    assert result.services[1].drive.node_id == 3, "Died on +.services[1].drive.node_id"
    assert result.services[1].drive.drive_id == 17, "Died on +.services[1].drive.drive_id"
    assert result.services[1].drive.customer_slice_file_capacity == 0, "Died on +.services[1].drive.customer_slice_file_capacity"
    assert result.services[1].drive.assigned_service == 23, "Died on +.services[1].drive.assigned_service"
    assert result.services[1].drive.drive_type == """block""", "Died on +.services[1].drive.drive_type"
    assert type(result.services[1].drive.attributes) is dict, "Died on .services[1].drive.attributes"
    assert result.services[1].drive.serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL311300X7300PGN""", "Died on +.services[1].drive.serial"
    assert result.services[1].drive.reserved_slice_file_capacity == 0, "Died on +.services[1].drive.reserved_slice_file_capacity"
    assert result.services[1].drive.drive_status == """assigned""", "Died on +.services[1].drive.drive_status"
    assert result.services[1].service.status == """healthy""", "Died on +.services[1].service.status"
    assert result.services[1].service.associated_bv == 0, "Died on +.services[1].service.associated_bv"
    assert result.services[1].service.associated_ts == 0, "Died on +.services[1].service.associated_ts"
    assert result.services[1].service.associated_vs == 0, "Died on +.services[1].service.associated_vs"
    assert result.services[1].service.ipc_port == 4009, "Died on +.services[1].service.ipc_port"
    assert result.services[1].service.service_type == """block""", "Died on +.services[1].service.service_type"
    assert result.services[1].service.node_id == 3, "Died on +.services[1].service.node_id"
    assert result.services[1].service.drive_id == 17, "Died on +.services[1].service.drive_id"
    assert result.services[1].service.service_id == 23, "Died on +.services[1].service.service_id"
    assert result.services[1].service.iscsi_port == 0, "Died on +.services[1].service.iscsi_port"
    assert result.services[1].service.drive_ids[0] == 17, "Died on +.services[1].service.drive_ids[0]"
    assert result.services[1].service.first_time_startup == False, "Died on +.services[1].service.first_time_startup"
    assert result.services[1].service.started_drive_ids[0] == 17, "Died on +.services[1].service.started_drive_ids[0]"
    assert result.services[1].drives[0].slot == 4, "Died on +.services[1].drives[0].slot"
    assert result.services[1].drives[0].capacity == 300069052416, "Died on +.services[1].drives[0].capacity"
    assert result.services[1].drives[0].node_id == 3, "Died on +.services[1].drives[0].node_id"
    assert result.services[1].drives[0].drive_id == 17, "Died on +.services[1].drives[0].drive_id"
    assert result.services[1].drives[0].customer_slice_file_capacity == 0, "Died on +.services[1].drives[0].customer_slice_file_capacity"
    assert result.services[1].drives[0].assigned_service == 23, "Died on +.services[1].drives[0].assigned_service"
    assert result.services[1].drives[0].drive_type == """Block""", "Died on +.services[1].drives[0].drive_type"
    assert type(result.services[1].drives[0].attributes) is dict, "Died on .services[1].drives[0].attributes"
    assert result.services[1].drives[0].serial == """scsi-SATA_INTEL_SSDSC2BB3BTWL311300X7300PGN""", "Died on +.services[1].drives[0].serial"
    assert result.services[1].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[1].drives[0].reserved_slice_file_capacity"
    assert result.services[1].drives[0].drive_status == """assigned""", "Died on +.services[1].drives[0].drive_status"
    assert result.services[0].node.sip == """10.117.62.26""", "Died on +.services[0].node.sip"
    assert result.services[0].node.name == """SF-1713""", "Died on +.services[0].node.name"
    assert result.services[0].node.platform_info.node_type == """SF3010""", "Died on +.services[0].node.platform_info.node_type"
    assert result.services[0].node.platform_info.cpu_model == """Intel(R) Xeon(R) CPU E5-2640 0 @ 2.50GHz""", "Died on +.services[0].node.platform_info.cpu_model"
    assert result.services[0].node.platform_info.node_memory_gb == 72, "Died on +.services[0].node.platform_info.node_memory_gb"
    assert result.services[0].node.platform_info.chassis_type == """R620""", "Died on +.services[0].node.platform_info.chassis_type"
    assert result.services[0].node.cip == """10.117.62.26""", "Died on +.services[0].node.cip"
    assert result.services[0].node.sipi == """Bond10G""", "Died on +.services[0].node.sipi"
    assert result.services[0].node.node_id == 4, "Died on +.services[0].node.node_id"
    assert result.services[0].node.software_version == """9.0.0.1554""", "Died on +.services[0].node.software_version"
    assert result.services[0].node.mip == """10.117.60.26""", "Died on +.services[0].node.mip"
    assert result.services[0].node.associated_master_service_id == 3, "Died on +.services[0].node.associated_master_service_id"
    assert result.services[0].node.mipi == """Bond1G""", "Died on +.services[0].node.mipi"
    assert result.services[0].node.fibre_channel_target_port_group is None, "Died on .services[0].node.fibre_channel_target_port_group"
    assert type(result.services[0].node.attributes) is dict, "Died on .services[0].node.attributes"
    assert result.services[0].node.associated_fservice_id == 0, "Died on +.services[0].node.associated_fservice_id"
    assert result.services[0].node.cipi == """Bond10G""", "Died on +.services[0].node.cipi"
    assert result.services[0].node.uuid == UUID("4C4C4544-0053-3210-8054-B6C04F435831"), "Died on .services[0].node.uuid"
    assert result.services[0].drive.slot == 3, "Died on +.services[0].drive.slot"
    assert result.services[0].drive.capacity == 300069052416, "Died on +.services[0].drive.capacity"
    assert result.services[0].drive.node_id == 4, "Died on +.services[0].drive.node_id"
    assert result.services[0].drive.drive_id == 5, "Died on +.services[0].drive.drive_id"
    assert result.services[0].drive.customer_slice_file_capacity == 0, "Died on +.services[0].drive.customer_slice_file_capacity"
    assert result.services[0].drive.assigned_service == 22, "Died on +.services[0].drive.assigned_service"
    assert result.services[0].drive.drive_type == """block""", "Died on +.services[0].drive.drive_type"
    assert type(result.services[0].drive.attributes) is dict, "Died on .services[0].drive.attributes"
    assert result.services[0].drive.serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR132402D3300EGN""", "Died on +.services[0].drive.serial"
    assert result.services[0].drive.reserved_slice_file_capacity == 0, "Died on +.services[0].drive.reserved_slice_file_capacity"
    assert result.services[0].drive.drive_status == """assigned""", "Died on +.services[0].drive.drive_status"
    assert result.services[0].service.status == """healthy""", "Died on +.services[0].service.status"
    assert result.services[0].service.associated_bv == 0, "Died on +.services[0].service.associated_bv"
    assert result.services[0].service.associated_ts == 0, "Died on +.services[0].service.associated_ts"
    assert result.services[0].service.associated_vs == 0, "Died on +.services[0].service.associated_vs"
    assert result.services[0].service.ipc_port == 4008, "Died on +.services[0].service.ipc_port"
    assert result.services[0].service.service_type == """block""", "Died on +.services[0].service.service_type"
    assert result.services[0].service.node_id == 4, "Died on +.services[0].service.node_id"
    assert result.services[0].service.drive_id == 5, "Died on +.services[0].service.drive_id"
    assert result.services[0].service.service_id == 22, "Died on +.services[0].service.service_id"
    assert result.services[0].service.iscsi_port == 0, "Died on +.services[0].service.iscsi_port"
    assert result.services[0].service.drive_ids[0] == 5, "Died on +.services[0].service.drive_ids[0]"
    assert result.services[0].service.first_time_startup == False, "Died on +.services[0].service.first_time_startup"
    assert result.services[0].service.started_drive_ids[0] == 5, "Died on +.services[0].service.started_drive_ids[0]"
    assert result.services[0].drives[0].slot == 3, "Died on +.services[0].drives[0].slot"
    assert result.services[0].drives[0].capacity == 300069052416, "Died on +.services[0].drives[0].capacity"
    assert result.services[0].drives[0].node_id == 4, "Died on +.services[0].drives[0].node_id"
    assert result.services[0].drives[0].drive_id == 5, "Died on +.services[0].drives[0].drive_id"
    assert result.services[0].drives[0].customer_slice_file_capacity == 0, "Died on +.services[0].drives[0].customer_slice_file_capacity"
    assert result.services[0].drives[0].assigned_service == 22, "Died on +.services[0].drives[0].assigned_service"
    assert result.services[0].drives[0].drive_type == """Block""", "Died on +.services[0].drives[0].drive_type"
    assert type(result.services[0].drives[0].attributes) is dict, "Died on .services[0].drives[0].attributes"
    assert result.services[0].drives[0].serial == """scsi-SATA_INTEL_SSDSA2CW3CVPR132402D3300EGN""", "Died on +.services[0].drives[0].serial"
    assert result.services[0].drives[0].reserved_slice_file_capacity == 0, "Died on +.services[0].drives[0].reserved_slice_file_capacity"
    assert result.services[0].drives[0].drive_status == """assigned""", "Died on +.services[0].drives[0].drive_status"

def test_list_snapshots_v8_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListSnapshots_v8_0)

    
    volume_id = 42 # volume_id
    result = ef.list_snapshots()
    assert result.snapshots[0].status == """done""", "Died on +.snapshots[0].status"
    assert result.snapshots[0].name == """haxepyBR2J5nx4-Rv-Q8Xe704OWucxrNMHmBKalCRrlzbjGu7Fri-F6A1om9l1qU""", "Died on +.snapshots[0].name"
    assert result.snapshots[0].snapshot_uuid == UUID("c78bf699-3b5d-4ba2-9558-72ded9a71257"), "Died on .snapshots[0].snapshot_uuid"
    assert result.snapshots[0].total_size == 1000341504, "Died on +.snapshots[0].total_size"
    assert result.snapshots[0].checksum == """0x0""", "Died on +.snapshots[0].checksum"
    assert result.snapshots[0].expiration_reason == """None""", "Died on +.snapshots[0].expiration_reason"
    assert result.snapshots[0].enable_remote_replication == False, "Died on +.snapshots[0].enable_remote_replication"
    assert result.snapshots[0].volume_id == 6452, "Died on +.snapshots[0].volume_id"
    assert result.snapshots[0].group_id == 0, "Died on +.snapshots[0].group_id"
    assert result.snapshots[0].group_snapshot_uuid == UUID("00000000-0000-0000-0000-000000000000"), "Died on .snapshots[0].group_snapshot_uuid"
    assert result.snapshots[0].snapshot_id == 8136, "Died on +.snapshots[0].snapshot_id"
    assert type(result.snapshots[0].attributes) is dict, "Died on .snapshots[0].attributes"
    assert result.snapshots[0].expiration_time == """2017-01-13T16:07:36Z""", "Died on +.snapshots[0].expiration_time"
    assert result.snapshots[0].create_time == """2017-01-13T16:06:36Z""", "Died on +.snapshots[0].create_time"
    assert result.snapshots[0].virtual_volume_id is None, "Died on .snapshots[0].virtual_volume_id"

def test_list_snapshots_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListSnapshots_v9_0)

    
    volume_id = 42 # volume_id
    result = ef.list_snapshots()
    assert result.snapshots[0].status == """done""", "Died on +.snapshots[0].status"
    assert result.snapshots[0].name == """2016-12-06T22:49:03Z""", "Died on +.snapshots[0].name"
    assert result.snapshots[0].total_size == 20000538624, "Died on +.snapshots[0].total_size"
    assert result.snapshots[0].snapshot_uuid == UUID("db5633bc-d1e8-4674-b598-d58a3f265167"), "Died on .snapshots[0].snapshot_uuid"
    assert result.snapshots[0].remote_statuses[0].volume_pair_uuid == UUID("cb44f772-bb26-40f8-ab3b-8577282eb785"), "Died on .snapshots[0].remote_statuses[0].volume_pair_uuid"
    assert result.snapshots[0].remote_statuses[0].remote_status == """Syncing""", "Died on +.snapshots[0].remote_statuses[0].remote_status"
    assert result.snapshots[0].expiration_reason == """None""", "Died on +.snapshots[0].expiration_reason"
    assert result.snapshots[0].enable_remote_replication == True, "Died on +.snapshots[0].enable_remote_replication"
    assert result.snapshots[0].volume_id == 4, "Died on +.snapshots[0].volume_id"
    assert result.snapshots[0].group_id == 0, "Died on +.snapshots[0].group_id"
    assert result.snapshots[0].group_snapshot_uuid == UUID("00000000-0000-0000-0000-000000000000"), "Died on .snapshots[0].group_snapshot_uuid"
    assert result.snapshots[0].snapshot_id == 2235, "Died on +.snapshots[0].snapshot_id"
    assert type(result.snapshots[0].attributes) is dict, "Died on .snapshots[0].attributes"
    assert result.snapshots[0].expiration_time == """2016-12-07T22:49:03Z""", "Died on +.snapshots[0].expiration_time"
    assert result.snapshots[0].checksum == """0xc683fe2c00e085c3""", "Died on +.snapshots[0].checksum"
    assert result.snapshots[0].create_time == """2016-12-06T22:49:03Z""", "Died on +.snapshots[0].create_time"
    assert result.snapshots[0].virtual_volume_id is None, "Died on .snapshots[0].virtual_volume_id"

def test_list_virtual_volume_bindings_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVirtualVolumeBindings_v9_0)

    
    virtual_volume_binding_ids = 42 # virtual_volume_binding_ids
    result = ef.list_virtual_volume_bindings()
    assert result.bindings[0].virtual_volume_host_id == UUID("564de1a4-9a99-da0f-8b7c-3a41dfd64bf1"), "Died on .bindings[0].virtual_volume_host_id"
    assert result.bindings[0].protocol_endpoint_id == UUID("5dd53da0-b9b7-43f9-9b7e-b41c2558e92b"), "Died on .bindings[0].protocol_endpoint_id"
    assert result.bindings[0].virtual_volume_binding_id == 177, "Died on +.bindings[0].virtual_volume_binding_id"
    assert result.bindings[0].virtual_volume_secondary_id == """0xe200000000a6""", "Died on +.bindings[0].virtual_volume_secondary_id"
    assert result.bindings[0].protocol_endpoint_in_band_id == """naa.6f47acc2000000016a67746700000000""", "Died on +.bindings[0].protocol_endpoint_in_band_id"
    assert result.bindings[0].protocol_endpoint_type == """SCSI""", "Died on +.bindings[0].protocol_endpoint_type"
    assert result.bindings[0].virtual_volume_id == UUID("269d3378-1ca6-4175-a18f-6d4839e5c746"), "Died on .bindings[0].virtual_volume_id"

def test_list_virtual_volume_hosts_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVirtualVolumeHosts_v9_0)

    
    virtual_volume_host_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # virtual_volume_host_ids
    result = ef.list_virtual_volume_hosts()
    assert result.hosts[0].visible_protocol_endpoint_ids[0] == UUID("5dd53da0-b9b7-43f9-9b7e-b41c2558e92b"), "Died on .hosts[0].visible_protocol_endpoint_ids[0]"
    assert result.hosts[0].virtual_volume_host_id == UUID("564de1a4-9a99-da0f-8b7c-3a41dfd64bf1"), "Died on .hosts[0].virtual_volume_host_id"
    assert result.hosts[0].initiator_names[1] == """iqn.1998-01.com.vmware:zdc-dhcp-0-c-29-d6-4b-f1-5bcf9254""", "Died on +.hosts[0].initiator_names[1]"
    assert result.hosts[0].initiator_names[0] == """iqn.1998-01.com.vmware:zdc-dhcp-0-c-29-d6-4b-f1-1a0cd614""", "Died on +.hosts[0].initiator_names[0]"
    assert result.hosts[0].cluster_id == UUID("5ebdb4ad-9617-4647-adfd-c1013578483b"), "Died on .hosts[0].cluster_id"
    assert result.hosts[0].host_address == """172.30.89.117""", "Died on +.hosts[0].host_address"

def test_list_virtual_volumes_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVirtualVolumes_v9_0)

    
    details = True # details
    limit = 42 # limit
    recursive = True # recursive
    start_virtual_volume_id = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # start_virtual_volume_id
    virtual_volume_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # virtual_volume_ids
    result = ef.list_virtual_volumes()
    assert result.virtual_volumes[0].status == """done""", "Died on +.virtual_volumes[0].status"
    assert result.virtual_volumes[0].snapshot_info is None, "Died on .virtual_volumes[0].snapshot_info"
    assert result.virtual_volumes[0].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[0].parent_virtual_volume_id"
    assert result.virtual_volumes[0].volume_info is None, "Died on .virtual_volumes[0].volume_info"
    assert result.virtual_volumes[0].storage_container.status == """active""", "Died on +.virtual_volumes[0].storage_container.status"
    assert result.virtual_volumes[0].storage_container.storage_container_id == UUID("abaab415-bedc-44cd-98b8-f37495884db0"), "Died on .virtual_volumes[0].storage_container.storage_container_id"
    assert result.virtual_volumes[0].storage_container.name == """test""", "Died on +.virtual_volumes[0].storage_container.name"
    assert result.virtual_volumes[0].storage_container.initiator_secret == """B5)D1y10K)8IDN58""", "Died on +.virtual_volumes[0].storage_container.initiator_secret"
    assert result.virtual_volumes[0].storage_container.target_secret == """qgae@{o{~82U)U^""", "Died on +.virtual_volumes[0].storage_container.target_secret"
    assert result.virtual_volumes[0].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[0].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[0].storage_container.account_id == 1, "Died on +.virtual_volumes[0].storage_container.account_id"
    assert result.virtual_volumes[0].volume_id == 166, "Died on +.virtual_volumes[0].volume_id"
    assert result.virtual_volumes[0].virtual_volume_type == """config""", "Died on +.virtual_volumes[0].virtual_volume_type"
    assert result.virtual_volumes[0].snapshot_id == 0, "Died on +.virtual_volumes[0].snapshot_id"
    assert result.virtual_volumes[0].bindings[0] == 177, "Died on +.virtual_volumes[0].bindings[0]"
    assert type(result.virtual_volumes[0].metadata) is dict, "Died on .virtual_volumes[0].metadata"
    assert result.virtual_volumes[0].virtual_volume_id == UUID("269d3378-1ca6-4175-a18f-6d4839e5c746"), "Died on .virtual_volumes[0].virtual_volume_id"
    assert result.next_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .next_virtual_volume_id"

def test_list_virtual_volumes_v9_1():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVirtualVolumes_v9_1)

    
    details = True # details
    limit = 42 # limit
    recursive = True # recursive
    start_virtual_volume_id = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # start_virtual_volume_id
    virtual_volume_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # virtual_volume_ids
    result = ef.list_virtual_volumes()
    assert result.virtual_volumes[9].status == """done""", "Died on +.virtual_volumes[9].status"
    assert result.virtual_volumes[9].snapshot_info is None, "Died on .virtual_volumes[9].snapshot_info"
    assert result.virtual_volumes[9].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[9].parent_virtual_volume_id"
    assert result.virtual_volumes[9].volume_info is None, "Died on .virtual_volumes[9].volume_info"
    assert result.virtual_volumes[9].storage_container.status == """active""", "Died on +.virtual_volumes[9].storage_container.status"
    assert result.virtual_volumes[9].storage_container.storage_container_id == UUID("f8ee427e-f858-420d-bd38-762ad1cb6cc3"), "Died on .virtual_volumes[9].storage_container.storage_container_id"
    assert result.virtual_volumes[9].storage_container.name == """akcluster1""", "Died on +.virtual_volumes[9].storage_container.name"
    assert result.virtual_volumes[9].storage_container.initiator_secret == """0&%Q2f$61(3#1TX%""", "Died on +.virtual_volumes[9].storage_container.initiator_secret"
    assert result.virtual_volumes[9].storage_container.target_secret == """[]6~98n1ltWn<cl%""", "Died on +.virtual_volumes[9].storage_container.target_secret"
    assert result.virtual_volumes[9].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[9].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[9].storage_container.account_id == 2, "Died on +.virtual_volumes[9].storage_container.account_id"
    assert result.virtual_volumes[9].volume_id == 5, "Died on +.virtual_volumes[9].volume_id"
    assert result.virtual_volumes[9].virtual_volume_type == """data""", "Died on +.virtual_volumes[9].virtual_volume_type"
    assert result.virtual_volumes[9].snapshot_id == 0, "Died on +.virtual_volumes[9].snapshot_id"
    assert type(result.virtual_volumes[9].metadata) is dict, "Died on .virtual_volumes[9].metadata"
    assert result.virtual_volumes[9].virtual_volume_id == UUID("c983e671-23dd-45a1-9b7e-9b4f94c13534"), "Died on .virtual_volumes[9].virtual_volume_id"
    assert result.virtual_volumes[8].status == """done""", "Died on +.virtual_volumes[8].status"
    assert result.virtual_volumes[8].snapshot_info is None, "Died on .virtual_volumes[8].snapshot_info"
    assert result.virtual_volumes[8].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[8].parent_virtual_volume_id"
    assert result.virtual_volumes[8].volume_info is None, "Died on .virtual_volumes[8].volume_info"
    assert result.virtual_volumes[8].storage_container.status == """active""", "Died on +.virtual_volumes[8].storage_container.status"
    assert result.virtual_volumes[8].storage_container.storage_container_id == UUID("f8ee427e-f858-420d-bd38-762ad1cb6cc3"), "Died on .virtual_volumes[8].storage_container.storage_container_id"
    assert result.virtual_volumes[8].storage_container.name == """akcluster1""", "Died on +.virtual_volumes[8].storage_container.name"
    assert result.virtual_volumes[8].storage_container.initiator_secret == """0&%Q2f$61(3#1TX%""", "Died on +.virtual_volumes[8].storage_container.initiator_secret"
    assert result.virtual_volumes[8].storage_container.target_secret == """[]6~98n1ltWn<cl%""", "Died on +.virtual_volumes[8].storage_container.target_secret"
    assert result.virtual_volumes[8].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[8].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[8].storage_container.account_id == 2, "Died on +.virtual_volumes[8].storage_container.account_id"
    assert result.virtual_volumes[8].volume_id == 9, "Died on +.virtual_volumes[8].volume_id"
    assert result.virtual_volumes[8].virtual_volume_type == """data""", "Died on +.virtual_volumes[8].virtual_volume_type"
    assert result.virtual_volumes[8].snapshot_id == 0, "Died on +.virtual_volumes[8].snapshot_id"
    assert type(result.virtual_volumes[8].metadata) is dict, "Died on .virtual_volumes[8].metadata"
    assert result.virtual_volumes[8].virtual_volume_id == UUID("83345d1c-70ab-4d99-8177-d96f67570594"), "Died on .virtual_volumes[8].virtual_volume_id"
    assert result.virtual_volumes[7].status == """done""", "Died on +.virtual_volumes[7].status"
    assert result.virtual_volumes[7].snapshot_info is None, "Died on .virtual_volumes[7].snapshot_info"
    assert result.virtual_volumes[7].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[7].parent_virtual_volume_id"
    assert result.virtual_volumes[7].volume_info is None, "Died on .virtual_volumes[7].volume_info"
    assert result.virtual_volumes[7].storage_container.status == """active""", "Died on +.virtual_volumes[7].storage_container.status"
    assert result.virtual_volumes[7].storage_container.storage_container_id == UUID("76bbb2b4-8936-4c98-814d-d16f9249c156"), "Died on .virtual_volumes[7].storage_container.storage_container_id"
    assert result.virtual_volumes[7].storage_container.name == """ErikSC""", "Died on +.virtual_volumes[7].storage_container.name"
    assert result.virtual_volumes[7].storage_container.initiator_secret == """n]shaq.ju!z>5{0X""", "Died on +.virtual_volumes[7].storage_container.initiator_secret"
    assert result.virtual_volumes[7].storage_container.target_secret == """037<BCYs^|iB%y,b""", "Died on +.virtual_volumes[7].storage_container.target_secret"
    assert result.virtual_volumes[7].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[7].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[7].storage_container.account_id == 4, "Died on +.virtual_volumes[7].storage_container.account_id"
    assert result.virtual_volumes[7].volume_id == 14, "Died on +.virtual_volumes[7].volume_id"
    assert result.virtual_volumes[7].virtual_volume_type == """swap""", "Died on +.virtual_volumes[7].virtual_volume_type"
    assert result.virtual_volumes[7].snapshot_id == 0, "Died on +.virtual_volumes[7].snapshot_id"
    assert result.virtual_volumes[7].bindings[0] == 37, "Died on +.virtual_volumes[7].bindings[0]"
    assert type(result.virtual_volumes[7].metadata) is dict, "Died on .virtual_volumes[7].metadata"
    assert result.virtual_volumes[7].virtual_volume_id == UUID("8182ae66-7cdb-4df4-be00-e1b93a5b8364"), "Died on .virtual_volumes[7].virtual_volume_id"
    assert result.virtual_volumes[6].status == """done""", "Died on +.virtual_volumes[6].status"
    assert result.virtual_volumes[6].snapshot_info is None, "Died on .virtual_volumes[6].snapshot_info"
    assert result.virtual_volumes[6].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[6].parent_virtual_volume_id"
    assert result.virtual_volumes[6].volume_info is None, "Died on .virtual_volumes[6].volume_info"
    assert result.virtual_volumes[6].storage_container.status == """active""", "Died on +.virtual_volumes[6].storage_container.status"
    assert result.virtual_volumes[6].storage_container.storage_container_id == UUID("f8ee427e-f858-420d-bd38-762ad1cb6cc3"), "Died on .virtual_volumes[6].storage_container.storage_container_id"
    assert result.virtual_volumes[6].storage_container.name == """akcluster1""", "Died on +.virtual_volumes[6].storage_container.name"
    assert result.virtual_volumes[6].storage_container.initiator_secret == """0&%Q2f$61(3#1TX%""", "Died on +.virtual_volumes[6].storage_container.initiator_secret"
    assert result.virtual_volumes[6].storage_container.target_secret == """[]6~98n1ltWn<cl%""", "Died on +.virtual_volumes[6].storage_container.target_secret"
    assert result.virtual_volumes[6].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[6].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[6].storage_container.account_id == 2, "Died on +.virtual_volumes[6].storage_container.account_id"
    assert result.virtual_volumes[6].volume_id == 8, "Died on +.virtual_volumes[6].volume_id"
    assert result.virtual_volumes[6].virtual_volume_type == """config""", "Died on +.virtual_volumes[6].virtual_volume_type"
    assert result.virtual_volumes[6].snapshot_id == 0, "Died on +.virtual_volumes[6].snapshot_id"
    assert type(result.virtual_volumes[6].metadata) is dict, "Died on .virtual_volumes[6].metadata"
    assert result.virtual_volumes[6].virtual_volume_id == UUID("6664a13e-a525-47a2-a58b-47231a5ecfea"), "Died on .virtual_volumes[6].virtual_volume_id"
    assert result.virtual_volumes[5].status == """done""", "Died on +.virtual_volumes[5].status"
    assert result.virtual_volumes[5].snapshot_info is None, "Died on .virtual_volumes[5].snapshot_info"
    assert result.virtual_volumes[5].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[5].parent_virtual_volume_id"
    assert result.virtual_volumes[5].volume_info is None, "Died on .virtual_volumes[5].volume_info"
    assert result.virtual_volumes[5].storage_container.status == """active""", "Died on +.virtual_volumes[5].storage_container.status"
    assert result.virtual_volumes[5].storage_container.storage_container_id == UUID("f8ee427e-f858-420d-bd38-762ad1cb6cc3"), "Died on .virtual_volumes[5].storage_container.storage_container_id"
    assert result.virtual_volumes[5].storage_container.name == """akcluster1""", "Died on +.virtual_volumes[5].storage_container.name"
    assert result.virtual_volumes[5].storage_container.initiator_secret == """0&%Q2f$61(3#1TX%""", "Died on +.virtual_volumes[5].storage_container.initiator_secret"
    assert result.virtual_volumes[5].storage_container.target_secret == """[]6~98n1ltWn<cl%""", "Died on +.virtual_volumes[5].storage_container.target_secret"
    assert result.virtual_volumes[5].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[5].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[5].storage_container.account_id == 2, "Died on +.virtual_volumes[5].storage_container.account_id"
    assert result.virtual_volumes[5].volume_id == 2, "Died on +.virtual_volumes[5].volume_id"
    assert result.virtual_volumes[5].virtual_volume_type == """config""", "Died on +.virtual_volumes[5].virtual_volume_type"
    assert result.virtual_volumes[5].snapshot_id == 0, "Died on +.virtual_volumes[5].snapshot_id"
    assert type(result.virtual_volumes[5].metadata) is dict, "Died on .virtual_volumes[5].metadata"
    assert result.virtual_volumes[5].virtual_volume_id == UUID("5630cccd-0bc5-4fcd-a4d7-6f5d66da295a"), "Died on .virtual_volumes[5].virtual_volume_id"
    assert result.virtual_volumes[4].status == """done""", "Died on +.virtual_volumes[4].status"
    assert result.virtual_volumes[4].snapshot_info is None, "Died on .virtual_volumes[4].snapshot_info"
    assert result.virtual_volumes[4].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[4].parent_virtual_volume_id"
    assert result.virtual_volumes[4].volume_info is None, "Died on .virtual_volumes[4].volume_info"
    assert result.virtual_volumes[4].storage_container.status == """active""", "Died on +.virtual_volumes[4].storage_container.status"
    assert result.virtual_volumes[4].storage_container.storage_container_id == UUID("f8ee427e-f858-420d-bd38-762ad1cb6cc3"), "Died on .virtual_volumes[4].storage_container.storage_container_id"
    assert result.virtual_volumes[4].storage_container.name == """akcluster1""", "Died on +.virtual_volumes[4].storage_container.name"
    assert result.virtual_volumes[4].storage_container.initiator_secret == """0&%Q2f$61(3#1TX%""", "Died on +.virtual_volumes[4].storage_container.initiator_secret"
    assert result.virtual_volumes[4].storage_container.target_secret == """[]6~98n1ltWn<cl%""", "Died on +.virtual_volumes[4].storage_container.target_secret"
    assert result.virtual_volumes[4].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[4].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[4].storage_container.account_id == 2, "Died on +.virtual_volumes[4].storage_container.account_id"
    assert result.virtual_volumes[4].volume_id == 3, "Died on +.virtual_volumes[4].volume_id"
    assert result.virtual_volumes[4].virtual_volume_type == """data""", "Died on +.virtual_volumes[4].virtual_volume_type"
    assert result.virtual_volumes[4].snapshot_id == 0, "Died on +.virtual_volumes[4].snapshot_id"
    assert type(result.virtual_volumes[4].metadata) is dict, "Died on .virtual_volumes[4].metadata"
    assert result.virtual_volumes[4].virtual_volume_id == UUID("4a2fa09f-8eb7-4151-be39-27bae2f8100f"), "Died on .virtual_volumes[4].virtual_volume_id"
    assert result.virtual_volumes[3].status == """done""", "Died on +.virtual_volumes[3].status"
    assert result.virtual_volumes[3].snapshot_info is None, "Died on .virtual_volumes[3].snapshot_info"
    assert result.virtual_volumes[3].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[3].parent_virtual_volume_id"
    assert result.virtual_volumes[3].volume_info is None, "Died on .virtual_volumes[3].volume_info"
    assert result.virtual_volumes[3].storage_container.status == """active""", "Died on +.virtual_volumes[3].storage_container.status"
    assert result.virtual_volumes[3].storage_container.storage_container_id == UUID("f8ee427e-f858-420d-bd38-762ad1cb6cc3"), "Died on .virtual_volumes[3].storage_container.storage_container_id"
    assert result.virtual_volumes[3].storage_container.name == """akcluster1""", "Died on +.virtual_volumes[3].storage_container.name"
    assert result.virtual_volumes[3].storage_container.initiator_secret == """0&%Q2f$61(3#1TX%""", "Died on +.virtual_volumes[3].storage_container.initiator_secret"
    assert result.virtual_volumes[3].storage_container.target_secret == """[]6~98n1ltWn<cl%""", "Died on +.virtual_volumes[3].storage_container.target_secret"
    assert result.virtual_volumes[3].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[3].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[3].storage_container.account_id == 2, "Died on +.virtual_volumes[3].storage_container.account_id"
    assert result.virtual_volumes[3].volume_id == 4, "Died on +.virtual_volumes[3].volume_id"
    assert result.virtual_volumes[3].virtual_volume_type == """data""", "Died on +.virtual_volumes[3].virtual_volume_type"
    assert result.virtual_volumes[3].snapshot_id == 0, "Died on +.virtual_volumes[3].snapshot_id"
    assert type(result.virtual_volumes[3].metadata) is dict, "Died on .virtual_volumes[3].metadata"
    assert result.virtual_volumes[3].virtual_volume_id == UUID("25081b2e-0656-428d-b4a3-6dddb0255d51"), "Died on .virtual_volumes[3].virtual_volume_id"
    assert result.virtual_volumes[2].status == """done""", "Died on +.virtual_volumes[2].status"
    assert result.virtual_volumes[2].snapshot_info is None, "Died on .virtual_volumes[2].snapshot_info"
    assert result.virtual_volumes[2].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[2].parent_virtual_volume_id"
    assert result.virtual_volumes[2].volume_info is None, "Died on .virtual_volumes[2].volume_info"
    assert result.virtual_volumes[2].storage_container.status == """active""", "Died on +.virtual_volumes[2].storage_container.status"
    assert result.virtual_volumes[2].storage_container.storage_container_id == UUID("76bbb2b4-8936-4c98-814d-d16f9249c156"), "Died on .virtual_volumes[2].storage_container.storage_container_id"
    assert result.virtual_volumes[2].storage_container.name == """ErikSC""", "Died on +.virtual_volumes[2].storage_container.name"
    assert result.virtual_volumes[2].storage_container.initiator_secret == """n]shaq.ju!z>5{0X""", "Died on +.virtual_volumes[2].storage_container.initiator_secret"
    assert result.virtual_volumes[2].storage_container.target_secret == """037<BCYs^|iB%y,b""", "Died on +.virtual_volumes[2].storage_container.target_secret"
    assert result.virtual_volumes[2].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[2].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[2].storage_container.account_id == 4, "Died on +.virtual_volumes[2].storage_container.account_id"
    assert result.virtual_volumes[2].volume_id == 12, "Died on +.virtual_volumes[2].volume_id"
    assert result.virtual_volumes[2].virtual_volume_type == """config""", "Died on +.virtual_volumes[2].virtual_volume_type"
    assert result.virtual_volumes[2].snapshot_id == 0, "Died on +.virtual_volumes[2].snapshot_id"
    assert result.virtual_volumes[2].bindings[0] == 36, "Died on +.virtual_volumes[2].bindings[0]"
    assert type(result.virtual_volumes[2].metadata) is dict, "Died on .virtual_volumes[2].metadata"
    assert result.virtual_volumes[2].virtual_volume_id == UUID("1e09b208-80ee-43fa-8dad-6ffc2a013072"), "Died on .virtual_volumes[2].virtual_volume_id"
    assert result.virtual_volumes[1].status == """done""", "Died on +.virtual_volumes[1].status"
    assert result.virtual_volumes[1].snapshot_info is None, "Died on .virtual_volumes[1].snapshot_info"
    assert result.virtual_volumes[1].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[1].parent_virtual_volume_id"
    assert result.virtual_volumes[1].volume_info is None, "Died on .virtual_volumes[1].volume_info"
    assert result.virtual_volumes[1].storage_container.status == """active""", "Died on +.virtual_volumes[1].storage_container.status"
    assert result.virtual_volumes[1].storage_container.storage_container_id == UUID("76bbb2b4-8936-4c98-814d-d16f9249c156"), "Died on .virtual_volumes[1].storage_container.storage_container_id"
    assert result.virtual_volumes[1].storage_container.name == """ErikSC""", "Died on +.virtual_volumes[1].storage_container.name"
    assert result.virtual_volumes[1].storage_container.initiator_secret == """n]shaq.ju!z>5{0X""", "Died on +.virtual_volumes[1].storage_container.initiator_secret"
    assert result.virtual_volumes[1].storage_container.target_secret == """037<BCYs^|iB%y,b""", "Died on +.virtual_volumes[1].storage_container.target_secret"
    assert result.virtual_volumes[1].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[1].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[1].storage_container.account_id == 4, "Died on +.virtual_volumes[1].storage_container.account_id"
    assert result.virtual_volumes[1].volume_id == 13, "Died on +.virtual_volumes[1].volume_id"
    assert result.virtual_volumes[1].virtual_volume_type == """data""", "Died on +.virtual_volumes[1].virtual_volume_type"
    assert result.virtual_volumes[1].snapshot_id == 0, "Died on +.virtual_volumes[1].snapshot_id"
    assert result.virtual_volumes[1].bindings[0] == 38, "Died on +.virtual_volumes[1].bindings[0]"
    assert type(result.virtual_volumes[1].metadata) is dict, "Died on .virtual_volumes[1].metadata"
    assert result.virtual_volumes[1].virtual_volume_id == UUID("1dfe1cb3-bdd6-4051-a92c-43a0184d483d"), "Died on .virtual_volumes[1].virtual_volume_id"
    assert result.virtual_volumes[0].status == """done""", "Died on +.virtual_volumes[0].status"
    assert result.virtual_volumes[0].snapshot_info is None, "Died on .virtual_volumes[0].snapshot_info"
    assert result.virtual_volumes[0].parent_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .virtual_volumes[0].parent_virtual_volume_id"
    assert result.virtual_volumes[0].volume_info is None, "Died on .virtual_volumes[0].volume_info"
    assert result.virtual_volumes[0].storage_container.status == """active""", "Died on +.virtual_volumes[0].storage_container.status"
    assert result.virtual_volumes[0].storage_container.storage_container_id == UUID("f8ee427e-f858-420d-bd38-762ad1cb6cc3"), "Died on .virtual_volumes[0].storage_container.storage_container_id"
    assert result.virtual_volumes[0].storage_container.name == """akcluster1""", "Died on +.virtual_volumes[0].storage_container.name"
    assert result.virtual_volumes[0].storage_container.initiator_secret == """0&%Q2f$61(3#1TX%""", "Died on +.virtual_volumes[0].storage_container.initiator_secret"
    assert result.virtual_volumes[0].storage_container.target_secret == """[]6~98n1ltWn<cl%""", "Died on +.virtual_volumes[0].storage_container.target_secret"
    assert result.virtual_volumes[0].storage_container.protocol_endpoint_type == """SCSI""", "Died on +.virtual_volumes[0].storage_container.protocol_endpoint_type"
    assert result.virtual_volumes[0].storage_container.account_id == 2, "Died on +.virtual_volumes[0].storage_container.account_id"
    assert result.virtual_volumes[0].volume_id == 6, "Died on +.virtual_volumes[0].volume_id"
    assert result.virtual_volumes[0].virtual_volume_type == """data""", "Died on +.virtual_volumes[0].virtual_volume_type"
    assert result.virtual_volumes[0].snapshot_id == 0, "Died on +.virtual_volumes[0].snapshot_id"
    assert type(result.virtual_volumes[0].metadata) is dict, "Died on .virtual_volumes[0].metadata"
    assert result.virtual_volumes[0].virtual_volume_id == UUID("10c24f95-336d-4173-a19f-93ffbd852585"), "Died on .virtual_volumes[0].virtual_volume_id"
    assert result.next_virtual_volume_id == UUID("00000000-0000-0000-0000-000000000000"), "Died on .next_virtual_volume_id"

def test_list_virtual_volume_tasks_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVirtualVolumeTasks_v9_0)

    
    virtual_volume_task_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # virtual_volume_task_ids
    result = ef.list_virtual_volume_tasks()
    assert result.tasks[0].status == """success""", "Died on +.tasks[0].status"
    assert result.tasks[0].virtual_volume_host_id == UUID("564de1a4-9a99-da0f-8b7c-3a41dfd64bf1"), "Died on .tasks[0].virtual_volume_host_id"
    assert result.tasks[0].virtual_volume_task_id == UUID("a1b72df7-66a6-489a-86e4-538d0dbe05bf"), "Died on .tasks[0].virtual_volume_task_id"
    assert result.tasks[0].parent_used_size == 0, "Died on +.tasks[0].parent_used_size"
    assert result.tasks[0].clone_virtual_volume_id == UUID("fafeb3a0-7dd9-4c9f-8a07-80e0bbf6f4d0"), "Died on .tasks[0].clone_virtual_volume_id"
    assert result.tasks[0].parent_total_size == 42949672960, "Died on +.tasks[0].parent_total_size"
    assert result.tasks[0].cancelled == False, "Died on +.tasks[0].cancelled"
    assert type(result.tasks[0].parent_metadata) is dict, "Died on .tasks[0].parent_metadata"
    assert result.tasks[0].operation == """clone""", "Died on +.tasks[0].operation"
    assert result.tasks[0].virtualvolume_id == UUID("fafeb3a0-7dd9-4c9f-8a07-80e0bbf6f4d0"), "Died on .tasks[0].virtualvolume_id"

def test_list_volume_access_groups_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVolumeAccessGroups_v9_0)

    
    start_volume_access_group_id = 42 # start_volume_access_group_id
    limit = 42 # limit
    result = ef.list_volume_access_groups()
    assert result.volume_access_groups[1].name == """loyds""", "Died on +.volume_access_groups[1].name"
    assert result.volume_access_groups[1].initiator_ids[1] == 5, "Died on +.volume_access_groups[1].initiator_ids[1]"
    assert result.volume_access_groups[1].initiator_ids[0] == 4, "Died on +.volume_access_groups[1].initiator_ids[0]"
    assert result.volume_access_groups[1].volumes[0] == 5, "Died on +.volume_access_groups[1].volumes[0]"
    assert result.volume_access_groups[1].initiators[1] == """21:00:00:0e:1e:1b:2a:41""", "Died on +.volume_access_groups[1].initiators[1]"
    assert result.volume_access_groups[1].initiators[0] == """21:00:00:0e:1e:1b:2a:40""", "Died on +.volume_access_groups[1].initiators[0]"
    assert type(result.volume_access_groups[1].attributes) is dict, "Died on .volume_access_groups[1].attributes"
    assert result.volume_access_groups[1].volume_access_group_id == 2, "Died on +.volume_access_groups[1].volume_access_group_id"
    assert result.volume_access_groups[0].name == """sra-site1-esxi""", "Died on +.volume_access_groups[0].name"
    assert result.volume_access_groups[0].initiator_ids[0] == 1, "Died on +.volume_access_groups[0].initiator_ids[0]"
    assert result.volume_access_groups[0].volumes[1] == 4, "Died on +.volume_access_groups[0].volumes[1]"
    assert result.volume_access_groups[0].volumes[0] == 2, "Died on +.volume_access_groups[0].volumes[0]"
    assert result.volume_access_groups[0].initiators[0] == """iqn.1998-01.com.vmware:sra-site1-esxi""", "Died on +.volume_access_groups[0].initiators[0]"
    assert type(result.volume_access_groups[0].attributes) is dict, "Died on .volume_access_groups[0].attributes"
    assert result.volume_access_groups[0].volume_access_group_id == 1, "Died on +.volume_access_groups[0].volume_access_group_id"

def test_list_volume_stats_by_virtual_volume_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVolumeStatsByVirtualVolume_v9_0)

    
    virtual_volume_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # virtual_volume_ids
    result = ef.list_volume_stats_by_virtual_volume()

def test_list_volume_stats_by_virtual_volume_v9_1():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ListVolumeStatsByVirtualVolume_v9_1)

    
    virtual_volume_ids = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # virtual_volume_ids
    result = ef.list_volume_stats_by_virtual_volume()
    assert result.volume_stats[9].metadata_hosts.primary == 5, "Died on +.volume_stats[9].metadata_hosts.primary"
    assert result.volume_stats[9].write_latency_usec == 0, "Died on +.volume_stats[9].write_latency_usec"
    assert result.volume_stats[9].write_bytes_last_sample == 0, "Died on +.volume_stats[9].write_bytes_last_sample"
    assert result.volume_stats[9].burst_iopscredit == 0, "Died on +.volume_stats[9].burst_iopscredit"
    assert result.volume_stats[9].sample_period_msec == 0, "Died on +.volume_stats[9].sample_period_msec"
    assert result.volume_stats[9].async_delay is None, "Died on .volume_stats[9].async_delay"
    assert result.volume_stats[9].zero_blocks == 1048576, "Died on +.volume_stats[9].zero_blocks"
    assert result.volume_stats[9].actual_iops == 0, "Died on +.volume_stats[9].actual_iops"
    assert result.volume_stats[9].write_bytes == 0, "Died on +.volume_stats[9].write_bytes"
    assert result.volume_stats[9].read_ops == 0, "Died on +.volume_stats[9].read_ops"
    assert result.volume_stats[9].unaligned_writes == 0, "Died on +.volume_stats[9].unaligned_writes"
    assert result.volume_stats[9].latency_usec == 0, "Died on +.volume_stats[9].latency_usec"
    assert result.volume_stats[9].volume_size == 4294967296, "Died on +.volume_stats[9].volume_size"
    assert result.volume_stats[9].read_bytes == 0, "Died on +.volume_stats[9].read_bytes"
    assert result.volume_stats[9].write_ops == 0, "Died on +.volume_stats[9].write_ops"
    assert result.volume_stats[9].client_queue_depth == 0, "Died on +.volume_stats[9].client_queue_depth"
    assert result.volume_stats[9].read_bytes_last_sample == 0, "Died on +.volume_stats[9].read_bytes_last_sample"
    assert result.volume_stats[9].read_ops_last_sample == 0, "Died on +.volume_stats[9].read_ops_last_sample"
    assert result.volume_stats[9].timestamp == """2016-11-22T18:06:08.946487Z""", "Died on +.volume_stats[9].timestamp"
    assert result.volume_stats[9].average_iopsize == 0, "Died on +.volume_stats[9].average_iopsize"
    assert result.volume_stats[9].desired_metadata_hosts is None, "Died on .volume_stats[9].desired_metadata_hosts"
    assert result.volume_stats[9].write_ops_last_sample == 0, "Died on +.volume_stats[9].write_ops_last_sample"
    assert result.volume_stats[9].non_zero_blocks == 0, "Died on +.volume_stats[9].non_zero_blocks"
    assert result.volume_stats[9].virtual_volume_id == UUID("c983e671-23dd-45a1-9b7e-9b4f94c13534"), "Died on .volume_stats[9].virtual_volume_id"
    assert result.volume_stats[9].throttle == 0, "Died on +.volume_stats[9].throttle"
    assert result.volume_stats[9].volume_id == 5, "Died on +.volume_stats[9].volume_id"
    assert result.volume_stats[9].unaligned_reads == 0, "Died on +.volume_stats[9].unaligned_reads"
    assert result.volume_stats[9].read_latency_usec == 0, "Died on +.volume_stats[9].read_latency_usec"
    assert result.volume_stats[9].volume_utilization == 0, "Died on +.volume_stats[9].volume_utilization"
    assert result.volume_stats[9].account_id == 2, "Died on +.volume_stats[9].account_id"
    assert result.volume_stats[8].metadata_hosts.primary == 5, "Died on +.volume_stats[8].metadata_hosts.primary"
    assert result.volume_stats[8].write_latency_usec == 0, "Died on +.volume_stats[8].write_latency_usec"
    assert result.volume_stats[8].write_bytes_last_sample == 0, "Died on +.volume_stats[8].write_bytes_last_sample"
    assert result.volume_stats[8].burst_iopscredit == 0, "Died on +.volume_stats[8].burst_iopscredit"
    assert result.volume_stats[8].sample_period_msec == 0, "Died on +.volume_stats[8].sample_period_msec"
    assert result.volume_stats[8].async_delay is None, "Died on .volume_stats[8].async_delay"
    assert result.volume_stats[8].zero_blocks == 2621440, "Died on +.volume_stats[8].zero_blocks"
    assert result.volume_stats[8].actual_iops == 0, "Died on +.volume_stats[8].actual_iops"
    assert result.volume_stats[8].write_bytes == 0, "Died on +.volume_stats[8].write_bytes"
    assert result.volume_stats[8].read_ops == 0, "Died on +.volume_stats[8].read_ops"
    assert result.volume_stats[8].unaligned_writes == 0, "Died on +.volume_stats[8].unaligned_writes"
    assert result.volume_stats[8].latency_usec == 0, "Died on +.volume_stats[8].latency_usec"
    assert result.volume_stats[8].volume_size == 10737418240, "Died on +.volume_stats[8].volume_size"
    assert result.volume_stats[8].read_bytes == 0, "Died on +.volume_stats[8].read_bytes"
    assert result.volume_stats[8].write_ops == 0, "Died on +.volume_stats[8].write_ops"
    assert result.volume_stats[8].client_queue_depth == 0, "Died on +.volume_stats[8].client_queue_depth"
    assert result.volume_stats[8].read_bytes_last_sample == 0, "Died on +.volume_stats[8].read_bytes_last_sample"
    assert result.volume_stats[8].read_ops_last_sample == 0, "Died on +.volume_stats[8].read_ops_last_sample"
    assert result.volume_stats[8].timestamp == """2016-11-22T18:06:08.935746Z""", "Died on +.volume_stats[8].timestamp"
    assert result.volume_stats[8].average_iopsize == 0, "Died on +.volume_stats[8].average_iopsize"
    assert result.volume_stats[8].desired_metadata_hosts is None, "Died on .volume_stats[8].desired_metadata_hosts"
    assert result.volume_stats[8].write_ops_last_sample == 0, "Died on +.volume_stats[8].write_ops_last_sample"
    assert result.volume_stats[8].non_zero_blocks == 0, "Died on +.volume_stats[8].non_zero_blocks"
    assert result.volume_stats[8].virtual_volume_id == UUID("83345d1c-70ab-4d99-8177-d96f67570594"), "Died on .volume_stats[8].virtual_volume_id"
    assert result.volume_stats[8].throttle == 0, "Died on +.volume_stats[8].throttle"
    assert result.volume_stats[8].volume_id == 9, "Died on +.volume_stats[8].volume_id"
    assert result.volume_stats[8].unaligned_reads == 0, "Died on +.volume_stats[8].unaligned_reads"
    assert result.volume_stats[8].read_latency_usec == 0, "Died on +.volume_stats[8].read_latency_usec"
    assert result.volume_stats[8].volume_utilization == 0, "Died on +.volume_stats[8].volume_utilization"
    assert result.volume_stats[8].account_id == 2, "Died on +.volume_stats[8].account_id"
    assert result.volume_stats[7].metadata_hosts.primary == 5, "Died on +.volume_stats[7].metadata_hosts.primary"
    assert result.volume_stats[7].write_latency_usec == 0, "Died on +.volume_stats[7].write_latency_usec"
    assert result.volume_stats[7].write_bytes_last_sample == 0, "Died on +.volume_stats[7].write_bytes_last_sample"
    assert result.volume_stats[7].burst_iopscredit == 0, "Died on +.volume_stats[7].burst_iopscredit"
    assert result.volume_stats[7].sample_period_msec == 0, "Died on +.volume_stats[7].sample_period_msec"
    assert result.volume_stats[7].async_delay is None, "Died on .volume_stats[7].async_delay"
    assert result.volume_stats[7].zero_blocks == 524288, "Died on +.volume_stats[7].zero_blocks"
    assert result.volume_stats[7].actual_iops == 0, "Died on +.volume_stats[7].actual_iops"
    assert result.volume_stats[7].write_bytes == 0, "Died on +.volume_stats[7].write_bytes"
    assert result.volume_stats[7].read_ops == 0, "Died on +.volume_stats[7].read_ops"
    assert result.volume_stats[7].unaligned_writes == 0, "Died on +.volume_stats[7].unaligned_writes"
    assert result.volume_stats[7].latency_usec == 0, "Died on +.volume_stats[7].latency_usec"
    assert result.volume_stats[7].volume_size == 2147483648, "Died on +.volume_stats[7].volume_size"
    assert result.volume_stats[7].read_bytes == 0, "Died on +.volume_stats[7].read_bytes"
    assert result.volume_stats[7].write_ops == 0, "Died on +.volume_stats[7].write_ops"
    assert result.volume_stats[7].client_queue_depth == 0, "Died on +.volume_stats[7].client_queue_depth"
    assert result.volume_stats[7].read_bytes_last_sample == 0, "Died on +.volume_stats[7].read_bytes_last_sample"
    assert result.volume_stats[7].read_ops_last_sample == 0, "Died on +.volume_stats[7].read_ops_last_sample"
    assert result.volume_stats[7].timestamp == """2016-11-22T18:06:08.925641Z""", "Died on +.volume_stats[7].timestamp"
    assert result.volume_stats[7].average_iopsize == 0, "Died on +.volume_stats[7].average_iopsize"
    assert result.volume_stats[7].desired_metadata_hosts is None, "Died on .volume_stats[7].desired_metadata_hosts"
    assert result.volume_stats[7].write_ops_last_sample == 0, "Died on +.volume_stats[7].write_ops_last_sample"
    assert result.volume_stats[7].non_zero_blocks == 0, "Died on +.volume_stats[7].non_zero_blocks"
    assert result.volume_stats[7].virtual_volume_id == UUID("8182ae66-7cdb-4df4-be00-e1b93a5b8364"), "Died on .volume_stats[7].virtual_volume_id"
    assert result.volume_stats[7].throttle == 0, "Died on +.volume_stats[7].throttle"
    assert result.volume_stats[7].volume_id == 14, "Died on +.volume_stats[7].volume_id"
    assert result.volume_stats[7].unaligned_reads == 0, "Died on +.volume_stats[7].unaligned_reads"
    assert result.volume_stats[7].read_latency_usec == 0, "Died on +.volume_stats[7].read_latency_usec"
    assert result.volume_stats[7].volume_utilization == 0, "Died on +.volume_stats[7].volume_utilization"
    assert result.volume_stats[7].account_id == 4, "Died on +.volume_stats[7].account_id"
    assert result.volume_stats[6].metadata_hosts.primary == 5, "Died on +.volume_stats[6].metadata_hosts.primary"
    assert result.volume_stats[6].write_latency_usec == 0, "Died on +.volume_stats[6].write_latency_usec"
    assert result.volume_stats[6].write_bytes_last_sample == 0, "Died on +.volume_stats[6].write_bytes_last_sample"
    assert result.volume_stats[6].burst_iopscredit == 0, "Died on +.volume_stats[6].burst_iopscredit"
    assert result.volume_stats[6].sample_period_msec == 0, "Died on +.volume_stats[6].sample_period_msec"
    assert result.volume_stats[6].async_delay is None, "Died on .volume_stats[6].async_delay"
    assert result.volume_stats[6].zero_blocks == 1047169, "Died on +.volume_stats[6].zero_blocks"
    assert result.volume_stats[6].actual_iops == 0, "Died on +.volume_stats[6].actual_iops"
    assert result.volume_stats[6].write_bytes == 10829824, "Died on +.volume_stats[6].write_bytes"
    assert result.volume_stats[6].read_ops == 462, "Died on +.volume_stats[6].read_ops"
    assert result.volume_stats[6].unaligned_writes == 1200, "Died on +.volume_stats[6].unaligned_writes"
    assert result.volume_stats[6].latency_usec == 0, "Died on +.volume_stats[6].latency_usec"
    assert result.volume_stats[6].volume_size == 4294967296, "Died on +.volume_stats[6].volume_size"
    assert result.volume_stats[6].read_bytes == 1610752, "Died on +.volume_stats[6].read_bytes"
    assert result.volume_stats[6].write_ops == 1351, "Died on +.volume_stats[6].write_ops"
    assert result.volume_stats[6].client_queue_depth == 0, "Died on +.volume_stats[6].client_queue_depth"
    assert result.volume_stats[6].read_bytes_last_sample == 0, "Died on +.volume_stats[6].read_bytes_last_sample"
    assert result.volume_stats[6].read_ops_last_sample == 0, "Died on +.volume_stats[6].read_ops_last_sample"
    assert result.volume_stats[6].timestamp == """2016-11-22T18:06:08.915110Z""", "Died on +.volume_stats[6].timestamp"
    assert result.volume_stats[6].average_iopsize == 0, "Died on +.volume_stats[6].average_iopsize"
    assert result.volume_stats[6].desired_metadata_hosts is None, "Died on .volume_stats[6].desired_metadata_hosts"
    assert result.volume_stats[6].write_ops_last_sample == 0, "Died on +.volume_stats[6].write_ops_last_sample"
    assert result.volume_stats[6].non_zero_blocks == 1407, "Died on +.volume_stats[6].non_zero_blocks"
    assert result.volume_stats[6].virtual_volume_id == UUID("6664a13e-a525-47a2-a58b-47231a5ecfea"), "Died on .volume_stats[6].virtual_volume_id"
    assert result.volume_stats[6].throttle == 0, "Died on +.volume_stats[6].throttle"
    assert result.volume_stats[6].volume_id == 8, "Died on +.volume_stats[6].volume_id"
    assert result.volume_stats[6].unaligned_reads == 438, "Died on +.volume_stats[6].unaligned_reads"
    assert result.volume_stats[6].read_latency_usec == 0, "Died on +.volume_stats[6].read_latency_usec"
    assert result.volume_stats[6].volume_utilization == 0, "Died on +.volume_stats[6].volume_utilization"
    assert result.volume_stats[6].account_id == 2, "Died on +.volume_stats[6].account_id"
    assert result.volume_stats[5].metadata_hosts.primary == 5, "Died on +.volume_stats[5].metadata_hosts.primary"
    assert result.volume_stats[5].write_latency_usec == 0, "Died on +.volume_stats[5].write_latency_usec"
    assert result.volume_stats[5].write_bytes_last_sample == 0, "Died on +.volume_stats[5].write_bytes_last_sample"
    assert result.volume_stats[5].burst_iopscredit == 0, "Died on +.volume_stats[5].burst_iopscredit"
    assert result.volume_stats[5].sample_period_msec == 0, "Died on +.volume_stats[5].sample_period_msec"
    assert result.volume_stats[5].async_delay is None, "Died on .volume_stats[5].async_delay"
    assert result.volume_stats[5].zero_blocks == 1047162, "Died on +.volume_stats[5].zero_blocks"
    assert result.volume_stats[5].actual_iops == 0, "Died on +.volume_stats[5].actual_iops"
    assert result.volume_stats[5].write_bytes == 12729344, "Died on +.volume_stats[5].write_bytes"
    assert result.volume_stats[5].read_ops == 3667, "Died on +.volume_stats[5].read_ops"
    assert result.volume_stats[5].unaligned_writes == 4210, "Died on +.volume_stats[5].unaligned_writes"
    assert result.volume_stats[5].latency_usec == 0, "Died on +.volume_stats[5].latency_usec"
    assert result.volume_stats[5].volume_size == 4294967296, "Died on +.volume_stats[5].volume_size"
    assert result.volume_stats[5].read_bytes == 9278464, "Died on +.volume_stats[5].read_bytes"
    assert result.volume_stats[5].write_ops == 4373, "Died on +.volume_stats[5].write_ops"
    assert result.volume_stats[5].client_queue_depth == 0, "Died on +.volume_stats[5].client_queue_depth"
    assert result.volume_stats[5].read_bytes_last_sample == 0, "Died on +.volume_stats[5].read_bytes_last_sample"
    assert result.volume_stats[5].read_ops_last_sample == 0, "Died on +.volume_stats[5].read_ops_last_sample"
    assert result.volume_stats[5].timestamp == """2016-11-22T18:06:08.904266Z""", "Died on +.volume_stats[5].timestamp"
    assert result.volume_stats[5].average_iopsize == 0, "Died on +.volume_stats[5].average_iopsize"
    assert result.volume_stats[5].desired_metadata_hosts is None, "Died on .volume_stats[5].desired_metadata_hosts"
    assert result.volume_stats[5].write_ops_last_sample == 0, "Died on +.volume_stats[5].write_ops_last_sample"
    assert result.volume_stats[5].non_zero_blocks == 1414, "Died on +.volume_stats[5].non_zero_blocks"
    assert result.volume_stats[5].virtual_volume_id == UUID("5630cccd-0bc5-4fcd-a4d7-6f5d66da295a"), "Died on .volume_stats[5].virtual_volume_id"
    assert result.volume_stats[5].throttle == 0, "Died on +.volume_stats[5].throttle"
    assert result.volume_stats[5].volume_id == 2, "Died on +.volume_stats[5].volume_id"
    assert result.volume_stats[5].unaligned_reads == 3541, "Died on +.volume_stats[5].unaligned_reads"
    assert result.volume_stats[5].read_latency_usec == 0, "Died on +.volume_stats[5].read_latency_usec"
    assert result.volume_stats[5].volume_utilization == 0, "Died on +.volume_stats[5].volume_utilization"
    assert result.volume_stats[5].account_id == 2, "Died on +.volume_stats[5].account_id"
    assert result.volume_stats[4].metadata_hosts.primary == 5, "Died on +.volume_stats[4].metadata_hosts.primary"
    assert result.volume_stats[4].write_latency_usec == 0, "Died on +.volume_stats[4].write_latency_usec"
    assert result.volume_stats[4].write_bytes_last_sample == 0, "Died on +.volume_stats[4].write_bytes_last_sample"
    assert result.volume_stats[4].burst_iopscredit == 0, "Died on +.volume_stats[4].burst_iopscredit"
    assert result.volume_stats[4].sample_period_msec == 0, "Died on +.volume_stats[4].sample_period_msec"
    assert result.volume_stats[4].async_delay is None, "Died on .volume_stats[4].async_delay"
    assert result.volume_stats[4].zero_blocks == 1310720, "Died on +.volume_stats[4].zero_blocks"
    assert result.volume_stats[4].actual_iops == 0, "Died on +.volume_stats[4].actual_iops"
    assert result.volume_stats[4].write_bytes == 0, "Died on +.volume_stats[4].write_bytes"
    assert result.volume_stats[4].read_ops == 0, "Died on +.volume_stats[4].read_ops"
    assert result.volume_stats[4].unaligned_writes == 0, "Died on +.volume_stats[4].unaligned_writes"
    assert result.volume_stats[4].latency_usec == 0, "Died on +.volume_stats[4].latency_usec"
    assert result.volume_stats[4].volume_size == 5368709120, "Died on +.volume_stats[4].volume_size"
    assert result.volume_stats[4].read_bytes == 0, "Died on +.volume_stats[4].read_bytes"
    assert result.volume_stats[4].write_ops == 0, "Died on +.volume_stats[4].write_ops"
    assert result.volume_stats[4].client_queue_depth == 0, "Died on +.volume_stats[4].client_queue_depth"
    assert result.volume_stats[4].read_bytes_last_sample == 0, "Died on +.volume_stats[4].read_bytes_last_sample"
    assert result.volume_stats[4].read_ops_last_sample == 0, "Died on +.volume_stats[4].read_ops_last_sample"
    assert result.volume_stats[4].timestamp == """2016-11-22T18:06:08.893663Z""", "Died on +.volume_stats[4].timestamp"
    assert result.volume_stats[4].average_iopsize == 0, "Died on +.volume_stats[4].average_iopsize"
    assert result.volume_stats[4].desired_metadata_hosts is None, "Died on .volume_stats[4].desired_metadata_hosts"
    assert result.volume_stats[4].write_ops_last_sample == 0, "Died on +.volume_stats[4].write_ops_last_sample"
    assert result.volume_stats[4].non_zero_blocks == 0, "Died on +.volume_stats[4].non_zero_blocks"
    assert result.volume_stats[4].virtual_volume_id == UUID("4a2fa09f-8eb7-4151-be39-27bae2f8100f"), "Died on .volume_stats[4].virtual_volume_id"
    assert result.volume_stats[4].throttle == 0, "Died on +.volume_stats[4].throttle"
    assert result.volume_stats[4].volume_id == 3, "Died on +.volume_stats[4].volume_id"
    assert result.volume_stats[4].unaligned_reads == 0, "Died on +.volume_stats[4].unaligned_reads"
    assert result.volume_stats[4].read_latency_usec == 0, "Died on +.volume_stats[4].read_latency_usec"
    assert result.volume_stats[4].volume_utilization == 0, "Died on +.volume_stats[4].volume_utilization"
    assert result.volume_stats[4].account_id == 2, "Died on +.volume_stats[4].account_id"
    assert result.volume_stats[3].metadata_hosts.primary == 5, "Died on +.volume_stats[3].metadata_hosts.primary"
    assert result.volume_stats[3].write_latency_usec == 0, "Died on +.volume_stats[3].write_latency_usec"
    assert result.volume_stats[3].write_bytes_last_sample == 0, "Died on +.volume_stats[3].write_bytes_last_sample"
    assert result.volume_stats[3].burst_iopscredit == 0, "Died on +.volume_stats[3].burst_iopscredit"
    assert result.volume_stats[3].sample_period_msec == 0, "Died on +.volume_stats[3].sample_period_msec"
    assert result.volume_stats[3].async_delay is None, "Died on .volume_stats[3].async_delay"
    assert result.volume_stats[3].zero_blocks == 1048576, "Died on +.volume_stats[3].zero_blocks"
    assert result.volume_stats[3].actual_iops == 0, "Died on +.volume_stats[3].actual_iops"
    assert result.volume_stats[3].write_bytes == 0, "Died on +.volume_stats[3].write_bytes"
    assert result.volume_stats[3].read_ops == 0, "Died on +.volume_stats[3].read_ops"
    assert result.volume_stats[3].unaligned_writes == 0, "Died on +.volume_stats[3].unaligned_writes"
    assert result.volume_stats[3].latency_usec == 0, "Died on +.volume_stats[3].latency_usec"
    assert result.volume_stats[3].volume_size == 4294967296, "Died on +.volume_stats[3].volume_size"
    assert result.volume_stats[3].read_bytes == 0, "Died on +.volume_stats[3].read_bytes"
    assert result.volume_stats[3].write_ops == 0, "Died on +.volume_stats[3].write_ops"
    assert result.volume_stats[3].client_queue_depth == 0, "Died on +.volume_stats[3].client_queue_depth"
    assert result.volume_stats[3].read_bytes_last_sample == 0, "Died on +.volume_stats[3].read_bytes_last_sample"
    assert result.volume_stats[3].read_ops_last_sample == 0, "Died on +.volume_stats[3].read_ops_last_sample"
    assert result.volume_stats[3].timestamp == """2016-11-22T18:06:08.882931Z""", "Died on +.volume_stats[3].timestamp"
    assert result.volume_stats[3].average_iopsize == 0, "Died on +.volume_stats[3].average_iopsize"
    assert result.volume_stats[3].desired_metadata_hosts is None, "Died on .volume_stats[3].desired_metadata_hosts"
    assert result.volume_stats[3].write_ops_last_sample == 0, "Died on +.volume_stats[3].write_ops_last_sample"
    assert result.volume_stats[3].non_zero_blocks == 0, "Died on +.volume_stats[3].non_zero_blocks"
    assert result.volume_stats[3].virtual_volume_id == UUID("25081b2e-0656-428d-b4a3-6dddb0255d51"), "Died on .volume_stats[3].virtual_volume_id"
    assert result.volume_stats[3].throttle == 0, "Died on +.volume_stats[3].throttle"
    assert result.volume_stats[3].volume_id == 4, "Died on +.volume_stats[3].volume_id"
    assert result.volume_stats[3].unaligned_reads == 0, "Died on +.volume_stats[3].unaligned_reads"
    assert result.volume_stats[3].read_latency_usec == 0, "Died on +.volume_stats[3].read_latency_usec"
    assert result.volume_stats[3].volume_utilization == 0, "Died on +.volume_stats[3].volume_utilization"
    assert result.volume_stats[3].account_id == 2, "Died on +.volume_stats[3].account_id"
    assert result.volume_stats[2].metadata_hosts.primary == 5, "Died on +.volume_stats[2].metadata_hosts.primary"
    assert result.volume_stats[2].write_latency_usec == 0, "Died on +.volume_stats[2].write_latency_usec"
    assert result.volume_stats[2].write_bytes_last_sample == 0, "Died on +.volume_stats[2].write_bytes_last_sample"
    assert result.volume_stats[2].burst_iopscredit == 0, "Died on +.volume_stats[2].burst_iopscredit"
    assert result.volume_stats[2].sample_period_msec == 500, "Died on +.volume_stats[2].sample_period_msec"
    assert result.volume_stats[2].async_delay is None, "Died on .volume_stats[2].async_delay"
    assert result.volume_stats[2].zero_blocks == 1047129, "Died on +.volume_stats[2].zero_blocks"
    assert result.volume_stats[2].actual_iops == 0, "Died on +.volume_stats[2].actual_iops"
    assert result.volume_stats[2].write_bytes == 15736832, "Died on +.volume_stats[2].write_bytes"
    assert result.volume_stats[2].read_ops == 587, "Died on +.volume_stats[2].read_ops"
    assert result.volume_stats[2].unaligned_writes == 5879, "Died on +.volume_stats[2].unaligned_writes"
    assert result.volume_stats[2].latency_usec == 0, "Died on +.volume_stats[2].latency_usec"
    assert result.volume_stats[2].volume_size == 4294967296, "Died on +.volume_stats[2].volume_size"
    assert result.volume_stats[2].read_bytes == 2517504, "Died on +.volume_stats[2].read_bytes"
    assert result.volume_stats[2].write_ops == 6046, "Died on +.volume_stats[2].write_ops"
    assert result.volume_stats[2].client_queue_depth == 0, "Died on +.volume_stats[2].client_queue_depth"
    assert result.volume_stats[2].read_bytes_last_sample == 0, "Died on +.volume_stats[2].read_bytes_last_sample"
    assert result.volume_stats[2].read_ops_last_sample == 0, "Died on +.volume_stats[2].read_ops_last_sample"
    assert result.volume_stats[2].timestamp == """2016-11-22T18:06:08.872020Z""", "Died on +.volume_stats[2].timestamp"
    assert result.volume_stats[2].average_iopsize == 512, "Died on +.volume_stats[2].average_iopsize"
    assert result.volume_stats[2].desired_metadata_hosts is None, "Died on .volume_stats[2].desired_metadata_hosts"
    assert result.volume_stats[2].write_ops_last_sample == 0, "Died on +.volume_stats[2].write_ops_last_sample"
    assert result.volume_stats[2].non_zero_blocks == 1447, "Died on +.volume_stats[2].non_zero_blocks"
    assert result.volume_stats[2].virtual_volume_id == UUID("1e09b208-80ee-43fa-8dad-6ffc2a013072"), "Died on .volume_stats[2].virtual_volume_id"
    assert result.volume_stats[2].throttle == 0, "Died on +.volume_stats[2].throttle"
    assert result.volume_stats[2].volume_id == 12, "Died on +.volume_stats[2].volume_id"
    assert result.volume_stats[2].unaligned_reads == 557, "Died on +.volume_stats[2].unaligned_reads"
    assert result.volume_stats[2].read_latency_usec == 0, "Died on +.volume_stats[2].read_latency_usec"
    assert result.volume_stats[2].volume_utilization == 0, "Died on +.volume_stats[2].volume_utilization"
    assert result.volume_stats[2].account_id == 4, "Died on +.volume_stats[2].account_id"
    assert result.volume_stats[1].metadata_hosts.primary == 5, "Died on +.volume_stats[1].metadata_hosts.primary"
    assert result.volume_stats[1].write_latency_usec == 0, "Died on +.volume_stats[1].write_latency_usec"
    assert result.volume_stats[1].write_bytes_last_sample == 0, "Died on +.volume_stats[1].write_bytes_last_sample"
    assert result.volume_stats[1].burst_iopscredit == 0, "Died on +.volume_stats[1].burst_iopscredit"
    assert result.volume_stats[1].sample_period_msec == 0, "Died on +.volume_stats[1].sample_period_msec"
    assert result.volume_stats[1].async_delay is None, "Died on .volume_stats[1].async_delay"
    assert result.volume_stats[1].zero_blocks == 2097152, "Died on +.volume_stats[1].zero_blocks"
    assert result.volume_stats[1].actual_iops == 0, "Died on +.volume_stats[1].actual_iops"
    assert result.volume_stats[1].write_bytes == 0, "Died on +.volume_stats[1].write_bytes"
    assert result.volume_stats[1].read_ops == 1, "Died on +.volume_stats[1].read_ops"
    assert result.volume_stats[1].unaligned_writes == 0, "Died on +.volume_stats[1].unaligned_writes"
    assert result.volume_stats[1].latency_usec == 0, "Died on +.volume_stats[1].latency_usec"
    assert result.volume_stats[1].volume_size == 8589934592, "Died on +.volume_stats[1].volume_size"
    assert result.volume_stats[1].read_bytes == 512, "Died on +.volume_stats[1].read_bytes"
    assert result.volume_stats[1].write_ops == 0, "Died on +.volume_stats[1].write_ops"
    assert result.volume_stats[1].client_queue_depth == 0, "Died on +.volume_stats[1].client_queue_depth"
    assert result.volume_stats[1].read_bytes_last_sample == 0, "Died on +.volume_stats[1].read_bytes_last_sample"
    assert result.volume_stats[1].read_ops_last_sample == 0, "Died on +.volume_stats[1].read_ops_last_sample"
    assert result.volume_stats[1].timestamp == """2016-11-22T18:06:08.862264Z""", "Died on +.volume_stats[1].timestamp"
    assert result.volume_stats[1].average_iopsize == 0, "Died on +.volume_stats[1].average_iopsize"
    assert result.volume_stats[1].desired_metadata_hosts is None, "Died on .volume_stats[1].desired_metadata_hosts"
    assert result.volume_stats[1].write_ops_last_sample == 0, "Died on +.volume_stats[1].write_ops_last_sample"
    assert result.volume_stats[1].non_zero_blocks == 0, "Died on +.volume_stats[1].non_zero_blocks"
    assert result.volume_stats[1].virtual_volume_id == UUID("1dfe1cb3-bdd6-4051-a92c-43a0184d483d"), "Died on .volume_stats[1].virtual_volume_id"
    assert result.volume_stats[1].throttle == 0, "Died on +.volume_stats[1].throttle"
    assert result.volume_stats[1].volume_id == 13, "Died on +.volume_stats[1].volume_id"
    assert result.volume_stats[1].unaligned_reads == 1, "Died on +.volume_stats[1].unaligned_reads"
    assert result.volume_stats[1].read_latency_usec == 0, "Died on +.volume_stats[1].read_latency_usec"
    assert result.volume_stats[1].volume_utilization == 0, "Died on +.volume_stats[1].volume_utilization"
    assert result.volume_stats[1].account_id == 4, "Died on +.volume_stats[1].account_id"
    assert result.volume_stats[0].metadata_hosts.primary == 5, "Died on +.volume_stats[0].metadata_hosts.primary"
    assert result.volume_stats[0].write_latency_usec == 0, "Died on +.volume_stats[0].write_latency_usec"
    assert result.volume_stats[0].write_bytes_last_sample == 0, "Died on +.volume_stats[0].write_bytes_last_sample"
    assert result.volume_stats[0].burst_iopscredit == 0, "Died on +.volume_stats[0].burst_iopscredit"
    assert result.volume_stats[0].sample_period_msec == 0, "Died on +.volume_stats[0].sample_period_msec"
    assert result.volume_stats[0].async_delay is None, "Died on .volume_stats[0].async_delay"
    assert result.volume_stats[0].zero_blocks == 1048576, "Died on +.volume_stats[0].zero_blocks"
    assert result.volume_stats[0].actual_iops == 0, "Died on +.volume_stats[0].actual_iops"
    assert result.volume_stats[0].write_bytes == 0, "Died on +.volume_stats[0].write_bytes"
    assert result.volume_stats[0].read_ops == 0, "Died on +.volume_stats[0].read_ops"
    assert result.volume_stats[0].unaligned_writes == 0, "Died on +.volume_stats[0].unaligned_writes"
    assert result.volume_stats[0].latency_usec == 0, "Died on +.volume_stats[0].latency_usec"
    assert result.volume_stats[0].volume_size == 4294967296, "Died on +.volume_stats[0].volume_size"
    assert result.volume_stats[0].read_bytes == 0, "Died on +.volume_stats[0].read_bytes"
    assert result.volume_stats[0].write_ops == 0, "Died on +.volume_stats[0].write_ops"
    assert result.volume_stats[0].client_queue_depth == 0, "Died on +.volume_stats[0].client_queue_depth"
    assert result.volume_stats[0].read_bytes_last_sample == 0, "Died on +.volume_stats[0].read_bytes_last_sample"
    assert result.volume_stats[0].read_ops_last_sample == 0, "Died on +.volume_stats[0].read_ops_last_sample"
    assert result.volume_stats[0].timestamp == """2016-11-22T18:06:08.851768Z""", "Died on +.volume_stats[0].timestamp"
    assert result.volume_stats[0].average_iopsize == 0, "Died on +.volume_stats[0].average_iopsize"
    assert result.volume_stats[0].desired_metadata_hosts is None, "Died on .volume_stats[0].desired_metadata_hosts"
    assert result.volume_stats[0].write_ops_last_sample == 0, "Died on +.volume_stats[0].write_ops_last_sample"
    assert result.volume_stats[0].non_zero_blocks == 0, "Died on +.volume_stats[0].non_zero_blocks"
    assert result.volume_stats[0].virtual_volume_id == UUID("10c24f95-336d-4173-a19f-93ffbd852585"), "Died on .volume_stats[0].virtual_volume_id"
    assert result.volume_stats[0].throttle == 0, "Died on +.volume_stats[0].throttle"
    assert result.volume_stats[0].volume_id == 6, "Died on +.volume_stats[0].volume_id"
    assert result.volume_stats[0].unaligned_reads == 0, "Died on +.volume_stats[0].unaligned_reads"
    assert result.volume_stats[0].read_latency_usec == 0, "Died on +.volume_stats[0].read_latency_usec"
    assert result.volume_stats[0].volume_utilization == 0, "Died on +.volume_stats[0].volume_utilization"
    assert result.volume_stats[0].account_id == 2, "Died on +.volume_stats[0].account_id"

def test_modify_storage_container_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ModifyStorageContainer_v9_0)

    
    storage_container_id = UUID("2b0653fb-3d64-4ae0-9ef8-356e685b0b2e") # storage_container_id
    initiator_secret = "" # initiator_secret
    target_secret = "" # target_secret
    result = ef.modify_storage_container(storage_container_id,)
    assert result.storage_container.status == """active""", "Died on +.storage_container.status"
    assert result.storage_container.storage_container_id == UUID("b4528ea8-2930-41a0-8b8e-6361e1f0a71f"), "Died on .storage_container.storage_container_id"
    assert result.storage_container.name == """ExampleName""", "Died on +.storage_container.name"
    assert result.storage_container.initiator_secret == """e;~t5f4T~r8CQK9""", "Died on +.storage_container.initiator_secret"
    assert result.storage_container.target_secret == """LIU4?KW8mOlMZO^6""", "Died on +.storage_container.target_secret"
    assert result.storage_container.protocol_endpoint_type == """SCSI""", "Died on +.storage_container.protocol_endpoint_type"
    assert result.storage_container.account_id == 114, "Died on +.storage_container.account_id"

def test_modify_volume_access_group_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ModifyVolumeAccessGroup_v9_0)

    
    volume_access_group_id = 42 # volume_access_group_id
    virtual_network_id = 42 # virtual_network_id
    virtual_network_tags = 42 # virtual_network_tags
    name = "" # name
    initiators = "" # initiators
    volumes = 42 # volumes
    attributes = dict() # attributes
    result = ef.modify_volume_access_group(volume_access_group_id,)
    assert result.volume_access_group.name == """northbanktest""", "Died on +.volume_access_group.name"
    assert result.volume_access_group.deleted_volumes[0] == 327, "Died on +.volume_access_group.deleted_volumes[0]"
    assert result.volume_access_group.initiator_ids[1] == 115, "Died on +.volume_access_group.initiator_ids[1]"
    assert result.volume_access_group.initiator_ids[0] == 114, "Died on +.volume_access_group.initiator_ids[0]"
    assert result.volume_access_group.volumes[0] == 346, "Died on +.volume_access_group.volumes[0]"
    assert result.volume_access_group.initiators[1] == """iqn.1998-01.com.vmware:donesq-esx1-421b281b""", "Died on +.volume_access_group.initiators[1]"
    assert result.volume_access_group.initiators[0] == """iqn.1998-01.com.vmware:desk1-esx1-577b283a""", "Died on +.volume_access_group.initiators[0]"
    assert type(result.volume_access_group.attributes) is dict, "Died on .volume_access_group.attributes"
    assert result.volume_access_group.volume_access_group_id == 96, "Died on +.volume_access_group.volume_access_group_id"

def test_modify_volumes_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ModifyVolumes_v9_0)

    
    volume_ids = 42 # volume_ids
    account_id = 42 # account_id
    access = "" # access
    qos = dict() # qos
    total_size = 42 # total_size
    attributes = dict() # attributes
    result = ef.modify_volumes(volume_ids,)
    assert result.volumes[1].status == """active""", "Died on +.volumes[1].status"
    assert result.volumes[1].enable512e == False, "Died on +.volumes[1].enable512e"
    assert result.volumes[1].scsi_naadevice_id == """6f47acc1000000006a6f373300000003""", "Died on +.volumes[1].scsi_naadevice_id"
    assert result.volumes[1].name == """doctest2""", "Died on +.volumes[1].name"
    assert result.volumes[1].total_size == 1000341504, "Died on +.volumes[1].total_size"
    assert result.volumes[1].block_size == 4096, "Died on +.volumes[1].block_size"
    assert result.volumes[1].scsi_euidevice_id == """6a6f373300000003f47acc0100000000""", "Died on +.volumes[1].scsi_euidevice_id"
    assert result.volumes[1].iqn == """iqn.2010-01.com.solidfire:jo73.3""", "Died on +.volumes[1].iqn"
    assert result.volumes[1].volume_id == 3, "Died on +.volumes[1].volume_id"
    assert result.volumes[1].access == """replicationTarget""", "Died on +.volumes[1].access"
    assert result.volumes[1].slice_count == 1, "Died on +.volumes[1].slice_count"
    assert type(result.volumes[1].attributes) is dict, "Died on .volumes[1].attributes"
    assert result.volumes[1].virtual_volume_id is None, "Died on .volumes[1].virtual_volume_id"
    assert result.volumes[1].create_time == """2016-04-06T17:26:31Z""", "Died on +.volumes[1].create_time"
    assert result.volumes[1].qos.burst_iops == 150, "Died on +.volumes[1].qos.burst_iops"
    assert result.volumes[1].qos.min_iops == 50, "Died on +.volumes[1].qos.min_iops"
    assert result.volumes[1].qos.burst_time == 60, "Died on +.volumes[1].qos.burst_time"
    assert result.volumes[1].qos.max_iops == 100, "Died on +.volumes[1].qos.max_iops"
    assert result.volumes[1].account_id == 1, "Died on +.volumes[1].account_id"
    assert result.volumes[0].status == """active""", "Died on +.volumes[0].status"
    assert result.volumes[0].enable512e == False, "Died on +.volumes[0].enable512e"
    assert result.volumes[0].scsi_naadevice_id == """6f47acc1000000006a6f373300000002""", "Died on +.volumes[0].scsi_naadevice_id"
    assert result.volumes[0].name == """doctest1""", "Died on +.volumes[0].name"
    assert result.volumes[0].total_size == 1000341504, "Died on +.volumes[0].total_size"
    assert result.volumes[0].block_size == 4096, "Died on +.volumes[0].block_size"
    assert result.volumes[0].scsi_euidevice_id == """6a6f373300000002f47acc0100000000""", "Died on +.volumes[0].scsi_euidevice_id"
    assert result.volumes[0].iqn == """iqn.2010-01.com.solidfire:jo73.2""", "Died on +.volumes[0].iqn"
    assert result.volumes[0].volume_id == 2, "Died on +.volumes[0].volume_id"
    assert result.volumes[0].access == """replicationTarget""", "Died on +.volumes[0].access"
    assert result.volumes[0].slice_count == 1, "Died on +.volumes[0].slice_count"
    assert type(result.volumes[0].attributes) is dict, "Died on .volumes[0].attributes"
    assert result.volumes[0].virtual_volume_id is None, "Died on .volumes[0].virtual_volume_id"
    assert result.volumes[0].create_time == """2016-04-06T17:25:13Z""", "Died on +.volumes[0].create_time"
    assert result.volumes[0].qos.burst_iops == 150, "Died on +.volumes[0].qos.burst_iops"
    assert result.volumes[0].qos.min_iops == 50, "Died on +.volumes[0].qos.min_iops"
    assert result.volumes[0].qos.burst_time == 60, "Died on +.volumes[0].qos.burst_time"
    assert result.volumes[0].qos.max_iops == 100, "Died on +.volumes[0].qos.max_iops"
    assert result.volumes[0].account_id == 1, "Died on +.volumes[0].account_id"

def test_modify_volumes_v9_1():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ModifyVolumes_v9_1)

    
    volume_ids = 42 # volume_ids
    account_id = 42 # account_id
    access = "" # access
    qos = dict() # qos
    total_size = 42 # total_size
    attributes = dict() # attributes
    result = ef.modify_volumes(volume_ids,)
    assert result.volumes[9].status == """active""", "Died on +.volumes[9].status"
    assert result.volumes[9].enable512e == False, "Died on +.volumes[9].enable512e"
    assert result.volumes[9].scsi_naadevice_id == """6f47acc1000000006978766c00002705""", "Died on +.volumes[9].scsi_naadevice_id"
    assert result.volumes[9].name == """haxecsTMk7ArAT6lwxPlMxAJypTmUuQwYZzm7LOKOg44wiHgez3uihp7Z-YPer21""", "Died on +.volumes[9].name"
    assert result.volumes[9].total_size == 1000341504, "Died on +.volumes[9].total_size"
    assert result.volumes[9].block_size == 4096, "Died on +.volumes[9].block_size"
    assert result.volumes[9].scsi_euidevice_id == """6978766c00002705f47acc0100000000""", "Died on +.volumes[9].scsi_euidevice_id"
    assert result.volumes[9].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecstmk7arat6lwxplmxajyptmuuqwyzzm7lokog44wihgez3uihp7z-yper21.9989""", "Died on +.volumes[9].iqn"
    assert result.volumes[9].volume_id == 9989, "Died on +.volumes[9].volume_id"
    assert result.volumes[9].access == """readWrite""", "Died on +.volumes[9].access"
    assert result.volumes[9].slice_count == 1, "Died on +.volumes[9].slice_count"
    assert type(result.volumes[9].attributes) is dict, "Died on .volumes[9].attributes"
    assert result.volumes[9].virtual_volume_id is None, "Died on .volumes[9].virtual_volume_id"
    assert result.volumes[9].create_time == """2016-11-22T15:40:20Z""", "Died on +.volumes[9].create_time"
    assert result.volumes[9].qos.burst_iops == 15000, "Died on +.volumes[9].qos.burst_iops"
    assert result.volumes[9].qos.min_iops == 50, "Died on +.volumes[9].qos.min_iops"
    assert result.volumes[9].qos.burst_time == 60, "Died on +.volumes[9].qos.burst_time"
    assert result.volumes[9].qos.max_iops == 15000, "Died on +.volumes[9].qos.max_iops"
    assert result.volumes[9].account_id == 8731, "Died on +.volumes[9].account_id"
    assert result.volumes[8].status == """active""", "Died on +.volumes[8].status"
    assert result.volumes[8].enable512e == False, "Died on +.volumes[8].enable512e"
    assert result.volumes[8].scsi_naadevice_id == """6f47acc1000000006978766c00002704""", "Died on +.volumes[8].scsi_naadevice_id"
    assert result.volumes[8].name == """haxecsqrXv1xuyJ6J9SXQ1wrH-jsaSgK0Z1LMkvBgSKmx52pcjWdYrYGxaAPv9QE""", "Died on +.volumes[8].name"
    assert result.volumes[8].total_size == 1000341504, "Died on +.volumes[8].total_size"
    assert result.volumes[8].block_size == 4096, "Died on +.volumes[8].block_size"
    assert result.volumes[8].scsi_euidevice_id == """6978766c00002704f47acc0100000000""", "Died on +.volumes[8].scsi_euidevice_id"
    assert result.volumes[8].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecsqrxv1xuyj6j9sxq1wrh-jsasgk0z1lmkvbgskmx52pcjwdyrygxaapv9qe.9988""", "Died on +.volumes[8].iqn"
    assert result.volumes[8].volume_id == 9988, "Died on +.volumes[8].volume_id"
    assert result.volumes[8].access == """readWrite""", "Died on +.volumes[8].access"
    assert result.volumes[8].slice_count == 1, "Died on +.volumes[8].slice_count"
    assert type(result.volumes[8].attributes) is dict, "Died on .volumes[8].attributes"
    assert result.volumes[8].virtual_volume_id is None, "Died on .volumes[8].virtual_volume_id"
    assert result.volumes[8].create_time == """2016-11-22T15:40:19Z""", "Died on +.volumes[8].create_time"
    assert result.volumes[8].qos.burst_iops == 15000, "Died on +.volumes[8].qos.burst_iops"
    assert result.volumes[8].qos.min_iops == 50, "Died on +.volumes[8].qos.min_iops"
    assert result.volumes[8].qos.burst_time == 60, "Died on +.volumes[8].qos.burst_time"
    assert result.volumes[8].qos.max_iops == 15000, "Died on +.volumes[8].qos.max_iops"
    assert result.volumes[8].account_id == 8731, "Died on +.volumes[8].account_id"
    assert result.volumes[7].status == """active""", "Died on +.volumes[7].status"
    assert result.volumes[7].enable512e == False, "Died on +.volumes[7].enable512e"
    assert result.volumes[7].scsi_naadevice_id == """6f47acc1000000006978766c00002703""", "Died on +.volumes[7].scsi_naadevice_id"
    assert result.volumes[7].name == """haxecsd2GJ0atOYD2MuwRAhxUtzHLpMAEvoMWKg7KZwpzrKktDUXZDduYZTn4Wqc""", "Died on +.volumes[7].name"
    assert result.volumes[7].total_size == 1000341504, "Died on +.volumes[7].total_size"
    assert result.volumes[7].block_size == 4096, "Died on +.volumes[7].block_size"
    assert result.volumes[7].scsi_euidevice_id == """6978766c00002703f47acc0100000000""", "Died on +.volumes[7].scsi_euidevice_id"
    assert result.volumes[7].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecsd2gj0atoyd2muwrahxutzhlpmaevomwkg7kzwpzrkktduxzdduyztn4wqc.9987""", "Died on +.volumes[7].iqn"
    assert result.volumes[7].volume_id == 9987, "Died on +.volumes[7].volume_id"
    assert result.volumes[7].access == """readWrite""", "Died on +.volumes[7].access"
    assert result.volumes[7].slice_count == 1, "Died on +.volumes[7].slice_count"
    assert type(result.volumes[7].attributes) is dict, "Died on .volumes[7].attributes"
    assert result.volumes[7].virtual_volume_id is None, "Died on .volumes[7].virtual_volume_id"
    assert result.volumes[7].create_time == """2016-11-22T15:40:19Z""", "Died on +.volumes[7].create_time"
    assert result.volumes[7].qos.burst_iops == 15000, "Died on +.volumes[7].qos.burst_iops"
    assert result.volumes[7].qos.min_iops == 50, "Died on +.volumes[7].qos.min_iops"
    assert result.volumes[7].qos.burst_time == 60, "Died on +.volumes[7].qos.burst_time"
    assert result.volumes[7].qos.max_iops == 15000, "Died on +.volumes[7].qos.max_iops"
    assert result.volumes[7].account_id == 8731, "Died on +.volumes[7].account_id"
    assert result.volumes[6].status == """active""", "Died on +.volumes[6].status"
    assert result.volumes[6].enable512e == False, "Died on +.volumes[6].enable512e"
    assert result.volumes[6].scsi_naadevice_id == """6f47acc1000000006978766c00002702""", "Died on +.volumes[6].scsi_naadevice_id"
    assert result.volumes[6].name == """haxecsWVs6tXeLqUrcAl1xh4Zr9tFE2uCzBtZsHx-WL20ASb1unbHZlt2njNSnQn""", "Died on +.volumes[6].name"
    assert result.volumes[6].total_size == 1000341504, "Died on +.volumes[6].total_size"
    assert result.volumes[6].block_size == 4096, "Died on +.volumes[6].block_size"
    assert result.volumes[6].scsi_euidevice_id == """6978766c00002702f47acc0100000000""", "Died on +.volumes[6].scsi_euidevice_id"
    assert result.volumes[6].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecswvs6txelqurcal1xh4zr9tfe2uczbtzshx-wl20asb1unbhzlt2njnsnqn.9986""", "Died on +.volumes[6].iqn"
    assert result.volumes[6].volume_id == 9986, "Died on +.volumes[6].volume_id"
    assert result.volumes[6].access == """readWrite""", "Died on +.volumes[6].access"
    assert result.volumes[6].slice_count == 1, "Died on +.volumes[6].slice_count"
    assert type(result.volumes[6].attributes) is dict, "Died on .volumes[6].attributes"
    assert result.volumes[6].virtual_volume_id is None, "Died on .volumes[6].virtual_volume_id"
    assert result.volumes[6].create_time == """2016-11-22T15:40:18Z""", "Died on +.volumes[6].create_time"
    assert result.volumes[6].qos.burst_iops == 15000, "Died on +.volumes[6].qos.burst_iops"
    assert result.volumes[6].qos.min_iops == 50, "Died on +.volumes[6].qos.min_iops"
    assert result.volumes[6].qos.burst_time == 60, "Died on +.volumes[6].qos.burst_time"
    assert result.volumes[6].qos.max_iops == 15000, "Died on +.volumes[6].qos.max_iops"
    assert result.volumes[6].account_id == 8731, "Died on +.volumes[6].account_id"
    assert result.volumes[5].status == """active""", "Died on +.volumes[5].status"
    assert result.volumes[5].enable512e == False, "Died on +.volumes[5].enable512e"
    assert result.volumes[5].scsi_naadevice_id == """6f47acc1000000006978766c00002701""", "Died on +.volumes[5].scsi_naadevice_id"
    assert result.volumes[5].name == """haxecs0gjUYyK7LxpbAZnIw4-4upyllA6jcFGDAQr03aa67L-dJyhUTTrWL8ALt8""", "Died on +.volumes[5].name"
    assert result.volumes[5].total_size == 1000341504, "Died on +.volumes[5].total_size"
    assert result.volumes[5].block_size == 4096, "Died on +.volumes[5].block_size"
    assert result.volumes[5].scsi_euidevice_id == """6978766c00002701f47acc0100000000""", "Died on +.volumes[5].scsi_euidevice_id"
    assert result.volumes[5].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecs0gjuyyk7lxpbazniw4-4upylla6jcfgdaqr03aa67l-djyhuttrwl8alt8.9985""", "Died on +.volumes[5].iqn"
    assert result.volumes[5].volume_id == 9985, "Died on +.volumes[5].volume_id"
    assert result.volumes[5].access == """readWrite""", "Died on +.volumes[5].access"
    assert result.volumes[5].slice_count == 1, "Died on +.volumes[5].slice_count"
    assert type(result.volumes[5].attributes) is dict, "Died on .volumes[5].attributes"
    assert result.volumes[5].virtual_volume_id is None, "Died on .volumes[5].virtual_volume_id"
    assert result.volumes[5].create_time == """2016-11-22T15:40:18Z""", "Died on +.volumes[5].create_time"
    assert result.volumes[5].qos.burst_iops == 15000, "Died on +.volumes[5].qos.burst_iops"
    assert result.volumes[5].qos.min_iops == 50, "Died on +.volumes[5].qos.min_iops"
    assert result.volumes[5].qos.burst_time == 60, "Died on +.volumes[5].qos.burst_time"
    assert result.volumes[5].qos.max_iops == 15000, "Died on +.volumes[5].qos.max_iops"
    assert result.volumes[5].account_id == 8731, "Died on +.volumes[5].account_id"
    assert result.volumes[4].status == """active""", "Died on +.volumes[4].status"
    assert result.volumes[4].enable512e == False, "Died on +.volumes[4].enable512e"
    assert result.volumes[4].scsi_naadevice_id == """6f47acc1000000006978766c00002700""", "Died on +.volumes[4].scsi_naadevice_id"
    assert result.volumes[4].name == """haxecs-aYusaaABjCuGxReAFnJ49bb2zzvcEZGSa6iUHwmN5Y5uJy85Zrjjp5B-8""", "Died on +.volumes[4].name"
    assert result.volumes[4].total_size == 1000341504, "Died on +.volumes[4].total_size"
    assert result.volumes[4].block_size == 4096, "Died on +.volumes[4].block_size"
    assert result.volumes[4].scsi_euidevice_id == """6978766c00002700f47acc0100000000""", "Died on +.volumes[4].scsi_euidevice_id"
    assert result.volumes[4].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecs-ayusaaabjcugxreafnj49bb2zzvcezgsa6iuhwmn5y5ujy85zrjjp5b-8.9984""", "Died on +.volumes[4].iqn"
    assert result.volumes[4].volume_id == 9984, "Died on +.volumes[4].volume_id"
    assert result.volumes[4].access == """readWrite""", "Died on +.volumes[4].access"
    assert result.volumes[4].slice_count == 1, "Died on +.volumes[4].slice_count"
    assert type(result.volumes[4].attributes) is dict, "Died on .volumes[4].attributes"
    assert result.volumes[4].virtual_volume_id is None, "Died on .volumes[4].virtual_volume_id"
    assert result.volumes[4].create_time == """2016-11-22T15:40:18Z""", "Died on +.volumes[4].create_time"
    assert result.volumes[4].qos.burst_iops == 15000, "Died on +.volumes[4].qos.burst_iops"
    assert result.volumes[4].qos.min_iops == 50, "Died on +.volumes[4].qos.min_iops"
    assert result.volumes[4].qos.burst_time == 60, "Died on +.volumes[4].qos.burst_time"
    assert result.volumes[4].qos.max_iops == 15000, "Died on +.volumes[4].qos.max_iops"
    assert result.volumes[4].account_id == 8731, "Died on +.volumes[4].account_id"
    assert result.volumes[3].status == """active""", "Died on +.volumes[3].status"
    assert result.volumes[3].enable512e == False, "Died on +.volumes[3].enable512e"
    assert result.volumes[3].scsi_naadevice_id == """6f47acc1000000006978766c000026ff""", "Died on +.volumes[3].scsi_naadevice_id"
    assert result.volumes[3].name == """haxecsmsseXt8U48VAvvF4cgLBhgLepyFk-Te6BYaSRHq2TSUU5AAQMFGtNcbFhO""", "Died on +.volumes[3].name"
    assert result.volumes[3].total_size == 1000341504, "Died on +.volumes[3].total_size"
    assert result.volumes[3].block_size == 4096, "Died on +.volumes[3].block_size"
    assert result.volumes[3].scsi_euidevice_id == """6978766c000026fff47acc0100000000""", "Died on +.volumes[3].scsi_euidevice_id"
    assert result.volumes[3].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecsmssext8u48vavvf4cglbhglepyfk-te6byasrhq2tsuu5aaqmfgtncbfho.9983""", "Died on +.volumes[3].iqn"
    assert result.volumes[3].volume_id == 9983, "Died on +.volumes[3].volume_id"
    assert result.volumes[3].access == """readWrite""", "Died on +.volumes[3].access"
    assert result.volumes[3].slice_count == 1, "Died on +.volumes[3].slice_count"
    assert type(result.volumes[3].attributes) is dict, "Died on .volumes[3].attributes"
    assert result.volumes[3].virtual_volume_id is None, "Died on .volumes[3].virtual_volume_id"
    assert result.volumes[3].create_time == """2016-11-22T15:40:17Z""", "Died on +.volumes[3].create_time"
    assert result.volumes[3].qos.burst_iops == 15000, "Died on +.volumes[3].qos.burst_iops"
    assert result.volumes[3].qos.min_iops == 50, "Died on +.volumes[3].qos.min_iops"
    assert result.volumes[3].qos.burst_time == 60, "Died on +.volumes[3].qos.burst_time"
    assert result.volumes[3].qos.max_iops == 15000, "Died on +.volumes[3].qos.max_iops"
    assert result.volumes[3].account_id == 8731, "Died on +.volumes[3].account_id"
    assert result.volumes[2].status == """active""", "Died on +.volumes[2].status"
    assert result.volumes[2].enable512e == False, "Died on +.volumes[2].enable512e"
    assert result.volumes[2].scsi_naadevice_id == """6f47acc1000000006978766c000026fe""", "Died on +.volumes[2].scsi_naadevice_id"
    assert result.volumes[2].name == """haxecsMcXWLMFmGVYwBJQMKylKQU0jLZEubpLb6N1egfSeXLbw-aF5-86g3yW2ny""", "Died on +.volumes[2].name"
    assert result.volumes[2].total_size == 1000341504, "Died on +.volumes[2].total_size"
    assert result.volumes[2].block_size == 4096, "Died on +.volumes[2].block_size"
    assert result.volumes[2].scsi_euidevice_id == """6978766c000026fef47acc0100000000""", "Died on +.volumes[2].scsi_euidevice_id"
    assert result.volumes[2].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecsmcxwlmfmgvywbjqmkylkqu0jlzeubplb6n1egfsexlbw-af5-86g3yw2ny.9982""", "Died on +.volumes[2].iqn"
    assert result.volumes[2].volume_id == 9982, "Died on +.volumes[2].volume_id"
    assert result.volumes[2].access == """readWrite""", "Died on +.volumes[2].access"
    assert result.volumes[2].slice_count == 1, "Died on +.volumes[2].slice_count"
    assert type(result.volumes[2].attributes) is dict, "Died on .volumes[2].attributes"
    assert result.volumes[2].virtual_volume_id is None, "Died on .volumes[2].virtual_volume_id"
    assert result.volumes[2].create_time == """2016-11-22T15:40:17Z""", "Died on +.volumes[2].create_time"
    assert result.volumes[2].qos.burst_iops == 15000, "Died on +.volumes[2].qos.burst_iops"
    assert result.volumes[2].qos.min_iops == 50, "Died on +.volumes[2].qos.min_iops"
    assert result.volumes[2].qos.burst_time == 60, "Died on +.volumes[2].qos.burst_time"
    assert result.volumes[2].qos.max_iops == 15000, "Died on +.volumes[2].qos.max_iops"
    assert result.volumes[2].account_id == 8731, "Died on +.volumes[2].account_id"
    assert result.volumes[1].status == """active""", "Died on +.volumes[1].status"
    assert result.volumes[1].enable512e == False, "Died on +.volumes[1].enable512e"
    assert result.volumes[1].scsi_naadevice_id == """6f47acc1000000006978766c000026fd""", "Died on +.volumes[1].scsi_naadevice_id"
    assert result.volumes[1].name == """haxecsksGCuvTR98NqeDr-AJYSgUleRJEP4oNfWa11IrehGUOkM-hAY8r1-PbQGm""", "Died on +.volumes[1].name"
    assert result.volumes[1].total_size == 1000341504, "Died on +.volumes[1].total_size"
    assert result.volumes[1].block_size == 4096, "Died on +.volumes[1].block_size"
    assert result.volumes[1].scsi_euidevice_id == """6978766c000026fdf47acc0100000000""", "Died on +.volumes[1].scsi_euidevice_id"
    assert result.volumes[1].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecsksgcuvtr98nqedr-ajysgulerjep4onfwa11irehguokm-hay8r1-pbqgm.9981""", "Died on +.volumes[1].iqn"
    assert result.volumes[1].volume_id == 9981, "Died on +.volumes[1].volume_id"
    assert result.volumes[1].access == """readWrite""", "Died on +.volumes[1].access"
    assert result.volumes[1].slice_count == 1, "Died on +.volumes[1].slice_count"
    assert type(result.volumes[1].attributes) is dict, "Died on .volumes[1].attributes"
    assert result.volumes[1].virtual_volume_id is None, "Died on .volumes[1].virtual_volume_id"
    assert result.volumes[1].create_time == """2016-11-22T15:40:16Z""", "Died on +.volumes[1].create_time"
    assert result.volumes[1].qos.burst_iops == 15000, "Died on +.volumes[1].qos.burst_iops"
    assert result.volumes[1].qos.min_iops == 50, "Died on +.volumes[1].qos.min_iops"
    assert result.volumes[1].qos.burst_time == 60, "Died on +.volumes[1].qos.burst_time"
    assert result.volumes[1].qos.max_iops == 15000, "Died on +.volumes[1].qos.max_iops"
    assert result.volumes[1].account_id == 8731, "Died on +.volumes[1].account_id"
    assert result.volumes[0].status == """active""", "Died on +.volumes[0].status"
    assert result.volumes[0].enable512e == False, "Died on +.volumes[0].enable512e"
    assert result.volumes[0].scsi_naadevice_id == """6f47acc1000000006978766c000026fc""", "Died on +.volumes[0].scsi_naadevice_id"
    assert result.volumes[0].name == """haxecsl537C7LrXL7lRHGvDuUCobdg2w2E1YLCsoAxk8KdiZNtILDuhsfP3jUKbX""", "Died on +.volumes[0].name"
    assert result.volumes[0].total_size == 1000341504, "Died on +.volumes[0].total_size"
    assert result.volumes[0].block_size == 4096, "Died on +.volumes[0].block_size"
    assert result.volumes[0].scsi_euidevice_id == """6978766c000026fcf47acc0100000000""", "Died on +.volumes[0].scsi_euidevice_id"
    assert result.volumes[0].iqn == """iqn.2010-01.com.solidfire:ixvl.haxecsl537c7lrxl7lrhgvduucobdg2w2e1ylcsoaxk8kdizntilduhsfp3jukbx.9980""", "Died on +.volumes[0].iqn"
    assert result.volumes[0].volume_id == 9980, "Died on +.volumes[0].volume_id"
    assert result.volumes[0].access == """readWrite""", "Died on +.volumes[0].access"
    assert result.volumes[0].slice_count == 1, "Died on +.volumes[0].slice_count"
    assert type(result.volumes[0].attributes) is dict, "Died on .volumes[0].attributes"
    assert result.volumes[0].virtual_volume_id is None, "Died on .volumes[0].virtual_volume_id"
    assert result.volumes[0].create_time == """2016-11-22T15:40:16Z""", "Died on +.volumes[0].create_time"
    assert result.volumes[0].qos.burst_iops == 15000, "Died on +.volumes[0].qos.burst_iops"
    assert result.volumes[0].qos.min_iops == 50, "Died on +.volumes[0].qos.min_iops"
    assert result.volumes[0].qos.burst_time == 60, "Died on +.volumes[0].qos.burst_time"
    assert result.volumes[0].qos.max_iops == 15000, "Died on +.volumes[0].qos.max_iops"
    assert result.volumes[0].account_id == 8731, "Died on +.volumes[0].account_id"

def test_purge_deleted_volumes_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_PurgeDeletedVolumes_v9_0)

    
    volume_ids = 42 # volume_ids
    account_ids = 42 # account_ids
    volume_access_group_ids = 42 # volume_access_group_ids
    result = ef.purge_deleted_volumes()

def test_reset_node_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_ResetNode_v9_0)

    
    build = "" # build
    force = True # force
    option = "" # option
    result = ef.reset_node(build,force,option,)
    assert type(result.rtfi_info) is dict, "Died on .rtfi_info"

def test_restart_networking_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_RestartNetworking_v9_0)

    
    force = True # force
    result = ef.restart_networking(force,)

def test_restart_services_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_RestartServices_v9_0)

    
    force = True # force
    service = "" # service
    action = "" # action
    result = ef.restart_services(force,)

def test_restart_services_v9_1():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_RestartServices_v9_1)

    
    force = True # force
    service = "" # service
    action = "" # action
    result = ef.restart_services(force,)

def test_set_default_qos_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_SetDefaultQoS_v9_0)

    
    min_iops = 42 # min_iops
    max_iops = 42 # max_iops
    burst_iops = 42 # burst_iops
    result = ef.set_default_qos()
    assert result.burst_iops == 8000, "Died on +.burst_iops"
    assert result.min_iops == 200, "Died on +.min_iops"
    assert result.max_iops == 1000, "Died on +.max_iops"

def test_shutdown_v9_0():
    ef = Element("10.117.60.15:444", "admin", "admin", 9.0)
    ef._dispatcher.post = MagicMock(return_value = Resources.RESP_Shutdown_v9_0)

    
    nodes = 42 # nodes
    option = "" # option
    result = ef.shutdown(nodes,)
    assert result.successful[0] == 1, "Died on +.successful[0]"


if __name__ == "__main__":
    test_cancel_clone_v9_0()
    test_cancel_group_clone_v9_0()
    test_copy_volume_v9_0()
    test_create_storage_container_v9_0()
    test_create_volume_access_group_v9_0()
    test_delete_storage_containers_v9_0()
    test_delete_volumes_v9_0()
    test_enable_feature_v9_0()
    test_get_account_efficiency_v9_0()
    test_get_cluster_hardware_info_v9_0()
    test_get_drive_config_v9_0()
    test_get_drive_config_v9_1()
    test_get_drive_config_v9_2()
    test_get_feature_status_v9_0()
    test_get_hardware_config_v9_0()
    test_get_hardware_info_v9_0()
    test_get_hardware_info_v9_1()
    test_get_hardware_info_v9_2()
    test_get_hardware_info_v9_3()
    test_get_ipmi_config_v9_0()
    test_get_ipmi_config_v9_1()
    test_get_ipmi_info_v9_0()
    test_get_limits_v9_0()
    test_get_network_config_v9_0()
    test_get_node_hardware_info_v9_0()
    test_get_nvram_info_v9_0()
    test_get_origin_v9_0()
    test_get_storage_container_efficiency_v9_0()
    test_get_virtual_volume_count_v9_0()
    test_get_volume_count_v9_0()
    test_list_all_nodes_v8_0()
    test_list_async_results_v9_0()
    test_list_drive_stats_v9_0()
    test_list_fibre_channel_sessions_v9_0()
    test_list_iscsisessions_v9_0()
    test_list_pending_active_nodes_v9_0()
    test_list_protocol_endpoints_v9_0()
    test_list_services_v9_0()
    test_list_snapshots_v8_0()
    test_list_snapshots_v9_0()
    test_list_virtual_volume_bindings_v9_0()
    test_list_virtual_volume_hosts_v9_0()
    test_list_virtual_volumes_v9_0()
    test_list_virtual_volumes_v9_1()
    test_list_virtual_volume_tasks_v9_0()
    test_list_volume_access_groups_v9_0()
    test_list_volume_stats_by_virtual_volume_v9_0()
    test_list_volume_stats_by_virtual_volume_v9_1()
    test_modify_storage_container_v9_0()
    test_modify_volume_access_group_v9_0()
    test_modify_volumes_v9_0()
    test_modify_volumes_v9_1()
    test_purge_deleted_volumes_v9_0()
    test_reset_node_v9_0()
    test_restart_networking_v9_0()
    test_restart_services_v9_0()
    test_restart_services_v9_1()
    test_set_default_qos_v9_0()
    test_shutdown_v9_0()